---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab CI build token'
---

## Description

The response body contains content that matches the pattern of a GitLab CI build (job) token was identified. Job tokens are used to execute functionality in the context of a pipeline job. In most cases job tokens have limited privileges and can only be used to read from the repository where the pipeline executes from. External projects can grant access to job tokens from other projects. A malicious actor has a limited time frame to use this token to attempt to access the repository.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). Because job tokens are short lived, there is no revocation process, it is no longer available after the job that created it completes.
For more details on exactly what a job token is allowed to access, please see [GitLabs documentation on job tokens](../../../../../ci/jobs/ci_job_token.md).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.152 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
