# frozen_string_literal: true

class SwitchMigrateEvidencesForVulnerabilityFindingsToSecDatabase2 < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  milestone '18.3'

  def up
    execute <<~SQL
      UPDATE batched_background_migrations
      SET gitlab_schema = 'gitlab_sec'
      WHERE job_class_name = 'MigrateEvidencesForVulnerabilityFindings'
      AND table_name = 'vulnerability_occurrences';
    SQL
  end

  def down
    execute <<~SQL
      UPDATE batched_background_migrations
      SET gitlab_schema = 'gitlab_main'
      WHERE job_class_name = 'MigrateEvidencesForVulnerabilityFindings'
      AND table_name = 'vulnerability_occurrences';
    SQL
  end
end
