# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=too-many-lines
# pylint: disable=unused-argument

from knack.util import CLIError
from azure.cli.core.util import sdk_no_wait


def synapse_kusto_operation_list(client):
    return client.list()


def synapse_kusto_pool_list_sku(client):
    return client.list_skus()


def synapse_kusto_pool_list(client,
                            resource_group_name,
                            workspace_name):
    return client.list_by_workspace(resource_group_name=resource_group_name,
                                    workspace_name=workspace_name)


def synapse_kusto_pool_show(client,
                            workspace_name,
                            kusto_pool_name,
                            resource_group_name):
    return client.get(workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      resource_group_name=resource_group_name)


def synapse_kusto_pool_delete(client,
                              workspace_name,
                              resource_group_name,
                              kusto_pool_name,
                              no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       workspace_name=workspace_name,
                       resource_group_name=resource_group_name,
                       kusto_pool_name=kusto_pool_name)


def synapse_kusto_pool_list_follower_database(client,
                                              workspace_name,
                                              kusto_pool_name,
                                              resource_group_name):
    return client.list_follower_databases(workspace_name=workspace_name,
                                          kusto_pool_name=kusto_pool_name,
                                          resource_group_name=resource_group_name)


def synapse_kusto_pool_list_language_extension(client,
                                               workspace_name,
                                               kusto_pool_name,
                                               resource_group_name):
    return client.list_language_extensions(workspace_name=workspace_name,
                                           kusto_pool_name=kusto_pool_name,
                                           resource_group_name=resource_group_name)


def synapse_kusto_pool_list_sku(client,
                                workspace_name,
                                kusto_pool_name,
                                resource_group_name):
    return client.list_skus_by_resource(workspace_name=workspace_name,
                                        kusto_pool_name=kusto_pool_name,
                                        resource_group_name=resource_group_name)


def synapse_kusto_pool_start(client,
                             workspace_name,
                             kusto_pool_name,
                             resource_group_name,
                             no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_start,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_pool_stop(client,
                            workspace_name,
                            kusto_pool_name,
                            resource_group_name,
                            no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_stop,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_attached_database_configuration_list(client,
                                                       workspace_name,
                                                       kusto_pool_name,
                                                       resource_group_name):
    return client.list_by_kusto_pool(workspace_name=workspace_name,
                                     kusto_pool_name=kusto_pool_name,
                                     resource_group_name=resource_group_name)


def synapse_kusto_attached_database_configuration_show(client,
                                                       workspace_name,
                                                       kusto_pool_name,
                                                       attached_database_configuration_name,
                                                       resource_group_name):
    return client.get(workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      attached_database_configuration_name=attached_database_configuration_name,
                      resource_group_name=resource_group_name)


def synapse_kusto_attached_database_configuration_create(client,
                                                         workspace_name,
                                                         kusto_pool_name,
                                                         attached_database_configuration_name,
                                                         resource_group_name,
                                                         location=None,
                                                         database_name=None,
                                                         kusto_pool_resource_id=None,
                                                         default_principals_modification_kind=None,
                                                         table_level_sharing_properties=None,
                                                         no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    if database_name is not None:
        parameters['database_name'] = database_name
    if kusto_pool_resource_id is not None:
        parameters['kusto_pool_resource_id'] = kusto_pool_resource_id
    if default_principals_modification_kind is not None:
        parameters['default_principals_modification_kind'] = default_principals_modification_kind
    if table_level_sharing_properties is not None:
        parameters['table_level_sharing_properties'] = table_level_sharing_properties
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       attached_database_configuration_name=attached_database_configuration_name,
                       resource_group_name=resource_group_name,
                       parameters=parameters)


def synapse_kusto_attached_database_configuration_update(instance,
                                                         workspace_name,
                                                         kusto_pool_name,
                                                         attached_database_configuration_name,
                                                         resource_group_name,
                                                         location=None,
                                                         database_name=None,
                                                         kusto_pool_resource_id=None,
                                                         default_principals_modification_kind=None,
                                                         table_level_sharing_properties=None,
                                                         no_wait=False):
    if location is not None:
        instance.location = location
    if database_name is not None:
        instance.database_name = database_name
    if kusto_pool_resource_id is not None:
        instance.kusto_pool_resource_id = kusto_pool_resource_id
    if default_principals_modification_kind is not None:
        instance.default_principals_modification_kind = default_principals_modification_kind
    if table_level_sharing_properties is not None:
        instance.table_level_sharing_properties = table_level_sharing_properties
    return instance


def synapse_kusto_attached_database_configuration_delete(client,
                                                         workspace_name,
                                                         kusto_pool_name,
                                                         attached_database_configuration_name,
                                                         resource_group_name,
                                                         no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       attached_database_configuration_name=attached_database_configuration_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_database_list(client,
                                resource_group_name,
                                workspace_name,
                                kusto_pool_name):
    return client.list_by_kusto_pool(resource_group_name=resource_group_name,
                                     workspace_name=workspace_name,
                                     kusto_pool_name=kusto_pool_name)


def synapse_kusto_database_show(client,
                                resource_group_name,
                                workspace_name,
                                kusto_pool_name,
                                database_name):
    return client.get(resource_group_name=resource_group_name,
                      workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      database_name=database_name)


def synapse_kusto_database_create(client,
                                  resource_group_name,
                                  workspace_name,
                                  kusto_pool_name,
                                  database_name,
                                  read_write_database=None,
                                  no_wait=False):
    all_parameters = []
    if read_write_database is not None:
        all_parameters.append(read_write_database)
    if len(all_parameters) > 1:
        raise CLIError('at most one of  read_write_database is needed for parameters!')
    if len(all_parameters) != 1:
        raise CLIError('parameters is required. but none of read_write_database is provided!')
    parameters = all_parameters[0] if len(all_parameters) == 1 else None
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       parameters=parameters)


def synapse_kusto_database_update(client,
                                  resource_group_name,
                                  workspace_name,
                                  kusto_pool_name,
                                  database_name,
                                  read_write_database=None,
                                  no_wait=False):
    all_parameters = []
    if read_write_database is not None:
        all_parameters.append(read_write_database)
    if len(all_parameters) > 1:
        raise CLIError('at most one of  read_write_database is needed for parameters!')
    if len(all_parameters) != 1:
        raise CLIError('parameters is required. but none of read_write_database is provided!')
    parameters = all_parameters[0] if len(all_parameters) == 1 else None
    return sdk_no_wait(no_wait,
                       client.begin_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       parameters=parameters)


def synapse_kusto_database_delete(client,
                                  resource_group_name,
                                  workspace_name,
                                  kusto_pool_name,
                                  database_name,
                                  no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name)


def synapse_kusto_data_connection_list(client,
                                       resource_group_name,
                                       workspace_name,
                                       kusto_pool_name,
                                       database_name):
    return client.list_by_database(resource_group_name=resource_group_name,
                                   workspace_name=workspace_name,
                                   kusto_pool_name=kusto_pool_name,
                                   database_name=database_name)


def synapse_kusto_data_connection_show(client,
                                       resource_group_name,
                                       workspace_name,
                                       kusto_pool_name,
                                       database_name,
                                       data_connection_name):
    return client.get(resource_group_name=resource_group_name,
                      workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      database_name=database_name,
                      data_connection_name=data_connection_name)


def synapse_kusto_data_connection_event_grid_create(client,
                                                    resource_group_name,
                                                    workspace_name,
                                                    kusto_pool_name,
                                                    database_name,
                                                    data_connection_name,
                                                    location=None,
                                                    storage_account_resource_id=None,
                                                    event_hub_resource_id=None,
                                                    consumer_group=None,
                                                    table_name=None,
                                                    mapping_rule_name=None,
                                                    data_format=None,
                                                    ignore_first_record=None,
                                                    blob_storage_event_type=None,
                                                    no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'EventGrid'
    if storage_account_resource_id is not None:
        parameters['storage_account_resource_id'] = storage_account_resource_id
    if event_hub_resource_id is not None:
        parameters['event_hub_resource_id'] = event_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if ignore_first_record is not None:
        parameters['ignore_first_record'] = ignore_first_record
    if blob_storage_event_type is not None:
        parameters['blob_storage_event_type'] = blob_storage_event_type
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_event_hub_create(client,
                                                   resource_group_name,
                                                   workspace_name,
                                                   kusto_pool_name,
                                                   database_name,
                                                   data_connection_name,
                                                   location=None,
                                                   event_hub_resource_id=None,
                                                   consumer_group=None,
                                                   table_name=None,
                                                   mapping_rule_name=None,
                                                   data_format=None,
                                                   event_system_properties=None,
                                                   compression=None,
                                                   managed_identity_resource_id=None,
                                                   no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'EventHub'
    if event_hub_resource_id is not None:
        parameters['event_hub_resource_id'] = event_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if event_system_properties is not None:
        parameters['event_system_properties'] = event_system_properties
    if compression is not None:
        parameters['compression'] = compression
    if managed_identity_resource_id is not None:
        parameters['managed_identity_resource_id'] = managed_identity_resource_id
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_iot_hub_create(client,
                                                 resource_group_name,
                                                 workspace_name,
                                                 kusto_pool_name,
                                                 database_name,
                                                 data_connection_name,
                                                 location=None,
                                                 iot_hub_resource_id=None,
                                                 consumer_group=None,
                                                 table_name=None,
                                                 mapping_rule_name=None,
                                                 data_format=None,
                                                 event_system_properties=None,
                                                 shared_access_policy_name=None,
                                                 no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'IotHub'
    if iot_hub_resource_id is not None:
        parameters['iot_hub_resource_id'] = iot_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if event_system_properties is not None:
        parameters['event_system_properties'] = event_system_properties
    if shared_access_policy_name is not None:
        parameters['shared_access_policy_name'] = shared_access_policy_name
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_event_grid_update(client,
                                                    resource_group_name,
                                                    workspace_name,
                                                    kusto_pool_name,
                                                    database_name,
                                                    data_connection_name,
                                                    location=None,
                                                    storage_account_resource_id=None,
                                                    event_hub_resource_id=None,
                                                    consumer_group=None,
                                                    table_name=None,
                                                    mapping_rule_name=None,
                                                    data_format=None,
                                                    ignore_first_record=None,
                                                    blob_storage_event_type=None,
                                                    no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'EventGrid'
    if storage_account_resource_id is not None:
        parameters['storage_account_resource_id'] = storage_account_resource_id
    if event_hub_resource_id is not None:
        parameters['event_hub_resource_id'] = event_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if ignore_first_record is not None:
        parameters['ignore_first_record'] = ignore_first_record
    if blob_storage_event_type is not None:
        parameters['blob_storage_event_type'] = blob_storage_event_type
    return sdk_no_wait(no_wait,
                       client.begin_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_event_hub_update(client,
                                                   resource_group_name,
                                                   workspace_name,
                                                   kusto_pool_name,
                                                   database_name,
                                                   data_connection_name,
                                                   location=None,
                                                   event_hub_resource_id=None,
                                                   consumer_group=None,
                                                   table_name=None,
                                                   mapping_rule_name=None,
                                                   data_format=None,
                                                   event_system_properties=None,
                                                   compression=None,
                                                   managed_identity_resource_id=None,
                                                   no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'EventHub'
    if event_hub_resource_id is not None:
        parameters['event_hub_resource_id'] = event_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if event_system_properties is not None:
        parameters['event_system_properties'] = event_system_properties
    if compression is not None:
        parameters['compression'] = compression
    if managed_identity_resource_id is not None:
        parameters['managed_identity_resource_id'] = managed_identity_resource_id
    return sdk_no_wait(no_wait,
                       client.begin_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_iot_hub_update(client,
                                                 resource_group_name,
                                                 workspace_name,
                                                 kusto_pool_name,
                                                 database_name,
                                                 data_connection_name,
                                                 location=None,
                                                 iot_hub_resource_id=None,
                                                 consumer_group=None,
                                                 table_name=None,
                                                 mapping_rule_name=None,
                                                 data_format=None,
                                                 event_system_properties=None,
                                                 shared_access_policy_name=None,
                                                 no_wait=False):
    parameters = {}
    if location is not None:
        parameters['location'] = location
    parameters['kind'] = 'IotHub'
    if iot_hub_resource_id is not None:
        parameters['iot_hub_resource_id'] = iot_hub_resource_id
    if consumer_group is not None:
        parameters['consumer_group'] = consumer_group
    if table_name is not None:
        parameters['table_name'] = table_name
    if mapping_rule_name is not None:
        parameters['mapping_rule_name'] = mapping_rule_name
    if data_format is not None:
        parameters['data_format'] = data_format
    if event_system_properties is not None:
        parameters['event_system_properties'] = event_system_properties
    if shared_access_policy_name is not None:
        parameters['shared_access_policy_name'] = shared_access_policy_name
    return sdk_no_wait(no_wait,
                       client.begin_update,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name,
                       parameters=parameters)


def synapse_kusto_data_connection_delete(client,
                                         resource_group_name,
                                         workspace_name,
                                         kusto_pool_name,
                                         database_name,
                                         data_connection_name,
                                         no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       resource_group_name=resource_group_name,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       data_connection_name=data_connection_name)


def synapse_kusto_pool_principal_assignment_list(client,
                                                 workspace_name,
                                                 kusto_pool_name,
                                                 resource_group_name):
    return client.list(workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_pool_principal_assignment_show(client,
                                                 workspace_name,
                                                 kusto_pool_name,
                                                 principal_assignment_name,
                                                 resource_group_name):
    return client.get(workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      principal_assignment_name=principal_assignment_name,
                      resource_group_name=resource_group_name)


def synapse_kusto_pool_principal_assignment_create(client,
                                                   workspace_name,
                                                   kusto_pool_name,
                                                   principal_assignment_name,
                                                   resource_group_name,
                                                   principal_id=None,
                                                   role=None,
                                                   tenant_id=None,
                                                   principal_type=None,
                                                   no_wait=False):
    parameters = {}
    if principal_id is not None:
        parameters['principal_id'] = principal_id
    if role is not None:
        parameters['role'] = role
    if tenant_id is not None:
        parameters['tenant_id'] = tenant_id
    if principal_type is not None:
        parameters['principal_type'] = principal_type
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       principal_assignment_name=principal_assignment_name,
                       resource_group_name=resource_group_name,
                       parameters=parameters)


def synapse_kusto_pool_principal_assignment_update(instance,
                                                   workspace_name,
                                                   kusto_pool_name,
                                                   principal_assignment_name,
                                                   resource_group_name,
                                                   principal_id=None,
                                                   role=None,
                                                   tenant_id=None,
                                                   principal_type=None,
                                                   no_wait=False):
    if principal_id is not None:
        instance.principal_id = principal_id
    if role is not None:
        instance.role = role
    if tenant_id is not None:
        instance.tenant_id = tenant_id
    if principal_type is not None:
        instance.principal_type = principal_type
    return instance


def synapse_kusto_pool_principal_assignment_delete(client,
                                                   workspace_name,
                                                   kusto_pool_name,
                                                   principal_assignment_name,
                                                   resource_group_name,
                                                   no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       principal_assignment_name=principal_assignment_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_database_principal_assignment_list(client,
                                                     workspace_name,
                                                     kusto_pool_name,
                                                     database_name,
                                                     resource_group_name):
    return client.list(workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       resource_group_name=resource_group_name)


def synapse_kusto_database_principal_assignment_show(client,
                                                     workspace_name,
                                                     kusto_pool_name,
                                                     database_name,
                                                     principal_assignment_name,
                                                     resource_group_name):
    return client.get(workspace_name=workspace_name,
                      kusto_pool_name=kusto_pool_name,
                      database_name=database_name,
                      principal_assignment_name=principal_assignment_name,
                      resource_group_name=resource_group_name)


def synapse_kusto_database_principal_assignment_create(client,
                                                       workspace_name,
                                                       kusto_pool_name,
                                                       database_name,
                                                       principal_assignment_name,
                                                       resource_group_name,
                                                       principal_id=None,
                                                       role=None,
                                                       tenant_id=None,
                                                       principal_type=None,
                                                       no_wait=False):
    parameters = {}
    if principal_id is not None:
        parameters['principal_id'] = principal_id
    if role is not None:
        parameters['role'] = role
    if tenant_id is not None:
        parameters['tenant_id'] = tenant_id
    if principal_type is not None:
        parameters['principal_type'] = principal_type
    return sdk_no_wait(no_wait,
                       client.begin_create_or_update,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       principal_assignment_name=principal_assignment_name,
                       resource_group_name=resource_group_name,
                       parameters=parameters)


def synapse_kusto_database_principal_assignment_update(instance,
                                                       workspace_name,
                                                       kusto_pool_name,
                                                       database_name,
                                                       principal_assignment_name,
                                                       resource_group_name,
                                                       principal_id=None,
                                                       role=None,
                                                       tenant_id=None,
                                                       principal_type=None,
                                                       no_wait=False):
    if principal_id is not None:
        instance.principal_id = principal_id
    if role is not None:
        instance.role = role
    if tenant_id is not None:
        instance.tenant_id = tenant_id
    if principal_type is not None:
        instance.principal_type = principal_type
    return instance


def synapse_kusto_database_principal_assignment_delete(client,
                                                       workspace_name,
                                                       kusto_pool_name,
                                                       database_name,
                                                       principal_assignment_name,
                                                       resource_group_name,
                                                       no_wait=False):
    return sdk_no_wait(no_wait,
                       client.begin_delete,
                       workspace_name=workspace_name,
                       kusto_pool_name=kusto_pool_name,
                       database_name=database_name,
                       principal_assignment_name=principal_assignment_name,
                       resource_group_name=resource_group_name)
