/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarBrowser;
import edu.umass.cs.benchlab.har.HarCreator;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarEntries;
import edu.umass.cs.benchlab.har.HarPages;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarLog {
    public static String TABLE_NAME = "log";
    private String version = "1.2";
    private HarCreator creator;
    private HarBrowser browser;
    private HarPages pages;
    private HarEntries entries;
    private HarCustomFields customFields = new HarCustomFields();
    private String comment;
    private HarDatabaseConfig harDbConfig;
    private long dbLogId;

    public HarLog(String version, HarCreator creator, HarBrowser browser, String comment) {
        this.version = version;
        this.creator = creator;
        this.browser = browser;
        this.comment = comment;
    }

    public HarLog(HarCreator creator) {
        this.creator = creator;
    }

    public HarLog(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() == JsonToken.END_OBJECT) {
            throw new JsonParseException("Empty file", jp.getCurrentLocation());
        }
        if (!"log".equals(jp.getCurrentName())) {
            throw new JsonParseException("First element must be \"log\"", jp.getCurrentLocation());
        }
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"log\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("version".equals(name)) {
                this.setVersion(jp.getText());
                continue;
            }
            if ("creator".equals(name)) {
                this.setCreator(new HarCreator(jp, warnings));
                continue;
            }
            if ("browser".equals(name)) {
                this.setBrowser(new HarBrowser(jp, warnings));
                continue;
            }
            if ("pages".equals(name)) {
                this.setPages(new HarPages(jp, warnings));
                continue;
            }
            if ("entries".equals(name)) {
                this.setEntries(new HarEntries(jp, warnings));
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in log element", jp.getCurrentLocation());
        }
        if (this.version == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing version field in log element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing version field in log element", jp.getCurrentLocation());
            }
        }
        if (this.creator == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing create field in log element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing create field in log element", jp.getCurrentLocation());
            }
        }
        if (this.entries == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing entries field in log element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing entries field in log element", jp.getCurrentLocation());
            }
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("log");
        g.writeStringField("version", this.version);
        this.creator.writeHar(g);
        if (this.browser != null) {
            this.browser.writeHar(g);
        }
        if (this.pages != null) {
            this.pages.writeHar(g);
        }
        this.entries.writeHar(g);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    public HarLog(HarDatabaseConfig config) throws SQLException {
        this.readJDBC(config, 1L);
    }

    public HarLog(HarDatabaseConfig config, long logId) throws SQLException {
        this.readJDBC(config, logId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC() throws SQLException {
        if (this.harDbConfig == null) {
            throw new SQLException("This object was not retrieved from the database");
        }
        Connection c = null;
        Statement ps = null;
        String tableName = this.harDbConfig.getTablePrefix() + TABLE_NAME;
        try {
            c = this.harDbConfig.getConnection();
            ps = c.prepareStatement("DELETE FROM " + tableName + " WHERE id=?");
            ps.setLong(1, this.dbLogId);
            if (ps.executeUpdate() != 1) {
                throw new SQLException("No HarLog with id " + this.dbLogId + " found in database");
            }
            this.creator.deleteFromJDBC(this.harDbConfig, this.dbLogId);
            if (this.browser != null) {
                this.browser.deleteFromJDBC(this.harDbConfig, this.dbLogId);
            }
            if (this.pages != null) {
                this.pages.deleteFromJDBC(this.harDbConfig, this.dbLogId);
            }
            this.entries.deleteFromJDBC(this.harDbConfig, this.dbLogId);
            this.customFields.deleteFromJDBC(this.harDbConfig, this.dbLogId);
            this.harDbConfig.dropTableIfEmpty(c, tableName, this.harDbConfig);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            this.harDbConfig.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        this.harDbConfig = config;
        this.dbLogId = logId;
        String tableName = config.getTablePrefix() + "log";
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            c = config.getConnection();
            ps = c.prepareStatement("SELECT version,comment FROM " + tableName + " WHERE id=?");
            ps.setLong(1, logId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarLog with id " + logId + " found in database");
            }
            this.setVersion(rs.getString(1));
            this.setComment(rs.getString(2));
            this.creator = new HarCreator(config, logId);
            try {
                this.browser = new HarBrowser(config, logId);
            }
            catch (SQLException ignore) {
                this.browser = null;
            }
            try {
                this.pages = new HarPages(config, logId);
            }
            catch (SQLException ignore) {
                this.pages = null;
            }
            this.entries = new HarEntries(config, logId);
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARLOG, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public long writeJDBC(HarDatabaseConfig config) throws SQLException {
        long logId;
        Connection c = config.getConnection();
        c.setAutoCommit(false);
        c.setSavepoint();
        c.setTransactionIsolation(2);
        String tableName = config.getTablePrefix() + "log";
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ", version " + config.getStringDbType() + ",comment " + config.getStringDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (version,comment) VALUES (?,?)", 1);
            ps.setString(1, this.version);
            if (this.comment == null) {
                ps.setNull(2, -1);
            } else {
                ps.setString(2, this.comment);
            }
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarLog entry");
            }
            logId = rs.getLong(1);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.creator.writeJDBC(logId, config);
            if (this.browser != null) {
                this.browser.writeJDBC(logId, config);
            }
            if (this.pages != null) {
                this.pages.writeJDBC(logId, config);
            }
            this.entries.writeJDBC(logId, config);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARLOG, logId, logId);
            c.commit();
            c.setAutoCommit(true);
            CallableStatement cs = c.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            cs.execute();
            cs.close();
        }
        catch (SQLException e) {
            c.rollback();
            throw e;
        }
        finally {
            config.closeConnection(c);
        }
        return logId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HarCreator getCreator() {
        return this.creator;
    }

    public void setCreator(HarCreator creator) {
        this.creator = creator;
    }

    public HarBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(HarBrowser browser) {
        this.browser = browser;
    }

    public HarPages getPages() {
        return this.pages;
    }

    public void setPages(HarPages pages) {
        this.pages = pages;
    }

    public HarEntries getEntries() {
        return this.entries;
    }

    public void setEntries(HarEntries entries) {
        this.entries = entries;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ \"log\": { \"version\": \"" + this.version + "\", " + this.creator + "," + this.browser + ", " + this.pages + ", " + this.entries + ", " + " \"comment\": " + "\"" + this.comment + "\" }, " + this.customFields + " }\n");
        return sb.toString();
    }
}

