// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from MKW41Z4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,mkw41z4

// MKW41Z4 NXP Microcontroller
//
//     Redistribution and use in source and binary forms, with or without modification,\nare permitted provided that the following conditions are met:
//     o Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//     o Redistributions in binary form must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation and/or
//     other materials provided with the distribution.
//     o Neither the name of the copyright holder nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
//     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
//     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "MKW41Z4"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Enhanced direct memory access controller
	IRQ_DMA0 = 0

	// Enhanced direct memory access controller
	IRQ_DMA1 = 1

	// Enhanced direct memory access controller
	IRQ_DMA2 = 2

	// Enhanced direct memory access controller
	IRQ_DMA3 = 3

	// Flash Memory Interface
	IRQ_FTFA = 5

	// DC to DC Converter // Power Management Controller
	IRQ_LVD_LVW_DCDC = 6

	// Low leakage wakeup unit
	IRQ_LLWU = 7

	// Inter-Integrated Circuit
	IRQ_I2C0 = 8

	// Inter-Integrated Circuit
	IRQ_I2C1 = 9

	// Serial Peripheral Interface
	IRQ_SPI0 = 10

	// Touch sense input
	IRQ_TSI0 = 11

	// Universal Asynchronous Receiver/Transmitter
	IRQ_LPUART0 = 12

	// TRNG0
	IRQ_TRNG0 = 13

	// Carrier Modulator Transmitter
	IRQ_CMT = 14

	// Analog-to-Digital Converter
	IRQ_ADC0 = 15

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP0 = 16

	// Timer/PWM Module
	IRQ_TPM0 = 17

	// Timer/PWM Module
	IRQ_TPM1 = 18

	// Timer/PWM Module
	IRQ_TPM2 = 19

	// Secure Real Time Clock
	IRQ_RTC = 20

	// Secure Real Time Clock
	IRQ_RTC_Seconds = 21

	// Periodic Interrupt Timer
	IRQ_PIT = 22

	// LTC
	IRQ_LTC0 = 23

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC0 = 25

	// Multipurpose Clock Generator module
	IRQ_MCG = 27

	// Low Power Timer
	IRQ_LPTMR0 = 28

	// Serial Peripheral Interface
	IRQ_SPI1 = 29

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTA = 30

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTB_PORTC = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export DMA0_IRQHandler
func interruptDMA0() {
	callHandlers(IRQ_DMA0)
}

//export DMA1_IRQHandler
func interruptDMA1() {
	callHandlers(IRQ_DMA1)
}

//export DMA2_IRQHandler
func interruptDMA2() {
	callHandlers(IRQ_DMA2)
}

//export DMA3_IRQHandler
func interruptDMA3() {
	callHandlers(IRQ_DMA3)
}

//export FTFA_IRQHandler
func interruptFTFA() {
	callHandlers(IRQ_FTFA)
}

//export LVD_LVW_DCDC_IRQHandler
func interruptLVD_LVW_DCDC() {
	callHandlers(IRQ_LVD_LVW_DCDC)
}

//export LLWU_IRQHandler
func interruptLLWU() {
	callHandlers(IRQ_LLWU)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export TSI0_IRQHandler
func interruptTSI0() {
	callHandlers(IRQ_TSI0)
}

//export LPUART0_IRQHandler
func interruptLPUART0() {
	callHandlers(IRQ_LPUART0)
}

//export TRNG0_IRQHandler
func interruptTRNG0() {
	callHandlers(IRQ_TRNG0)
}

//export CMT_IRQHandler
func interruptCMT() {
	callHandlers(IRQ_CMT)
}

//export ADC0_IRQHandler
func interruptADC0() {
	callHandlers(IRQ_ADC0)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export TPM0_IRQHandler
func interruptTPM0() {
	callHandlers(IRQ_TPM0)
}

//export TPM1_IRQHandler
func interruptTPM1() {
	callHandlers(IRQ_TPM1)
}

//export TPM2_IRQHandler
func interruptTPM2() {
	callHandlers(IRQ_TPM2)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTC_Seconds_IRQHandler
func interruptRTC_Seconds() {
	callHandlers(IRQ_RTC_Seconds)
}

//export PIT_IRQHandler
func interruptPIT() {
	callHandlers(IRQ_PIT)
}

//export LTC0_IRQHandler
func interruptLTC0() {
	callHandlers(IRQ_LTC0)
}

//export DAC0_IRQHandler
func interruptDAC0() {
	callHandlers(IRQ_DAC0)
}

//export MCG_IRQHandler
func interruptMCG() {
	callHandlers(IRQ_MCG)
}

//export LPTMR0_IRQHandler
func interruptLPTMR0() {
	callHandlers(IRQ_LPTMR0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export PORTA_IRQHandler
func interruptPORTA() {
	callHandlers(IRQ_PORTA)
}

//export PORTB_PORTC_IRQHandler
func interruptPORTB_PORTC() {
	callHandlers(IRQ_PORTB_PORTC)
}

// Peripherals.
var (
	// Flash configuration field
	FTFA_FlashConfig = (*FTFA_FlashConfig_Type)(unsafe.Pointer(uintptr(0x400)))

	// Enhanced direct memory access controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Flash Memory Interface
	FTFA = (*FTFA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA channel multiplexor
	DMAMUX0 = (*DMAMUX0_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// TRNG0
	TRNG0 = (*TRNG0_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Periodic Interrupt Timer
	PIT = (*PIT_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// Timer/PWM Module
	TPM0 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Timer/PWM Module
	TPM1 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Timer/PWM Module
	TPM2 = (*TPM_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// Analog-to-Digital Converter
	ADC0 = (*ADC0_Type)(unsafe.Pointer(uintptr(0x4003b000)))

	// Secure Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003d000)))

	// 12-Bit Digital-to-Analog Converter
	DAC0 = (*DAC0_Type)(unsafe.Pointer(uintptr(0x4003f000)))

	// Low Power Timer
	LPTMR0 = (*LPTMR0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// System register file
	RFSYS = (*RFSYS_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Touch sense input
	TSI0 = (*TSI0_Type)(unsafe.Pointer(uintptr(0x40045000)))

	// System Integration Module
	SIM = (*SIM_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Pin Control and Interrupts
	PORTA = (*PORT_Type)(unsafe.Pointer(uintptr(0x40049000)))

	// Pin Control and Interrupts
	PORTB = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004a000)))

	// Pin Control and Interrupts
	PORTC = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004b000)))

	// Universal Asynchronous Receiver/Transmitter
	LPUART0 = (*LPUART0_Type)(unsafe.Pointer(uintptr(0x40054000)))

	// LTC
	LTC0 = (*LTC0_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// RSIM
	RSIM = (*RSIM_Type)(unsafe.Pointer(uintptr(0x40059000)))

	// DC to DC Converter
	DCDC = (*DCDC_Type)(unsafe.Pointer(uintptr(0x4005a000)))

	// BLE_RF
	BTLE_RF = (*BTLE_RF_Type)(unsafe.Pointer(uintptr(0x4005b000)))

	// XCVR_RX_DIG
	XCVR_RX_DIG = (*XCVR_RX_DIG_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// XCVR_TX_DIG
	XCVR_TX_DIG = (*XCVR_TX_DIG_Type)(unsafe.Pointer(uintptr(0x4005c200)))

	// XCVR_PLL_DIG
	XCVR_PLL_DIG = (*XCVR_PLL_DIG_Type)(unsafe.Pointer(uintptr(0x4005c224)))

	// XCVR_MISC
	XCVR_MISC = (*XCVR_MISC_Type)(unsafe.Pointer(uintptr(0x4005c280)))

	// XCVR_TSM
	XCVR_TSM = (*XCVR_TSM_Type)(unsafe.Pointer(uintptr(0x4005c2c0)))

	// XCVR_PHY
	XCVR_PHY = (*XCVR_PHY_Type)(unsafe.Pointer(uintptr(0x4005c400)))

	// XCVR_ZBDEMOD
	XCVR_ZBDEM = (*XCVR_ZBDEM_Type)(unsafe.Pointer(uintptr(0x4005c480)))

	// XCVR_ANALOG
	XCVR_ANA = (*XCVR_ANA_Type)(unsafe.Pointer(uintptr(0x4005c500)))

	// XCVR_PKT_RAM
	XCVR_PKT_RAM = (*XCVR_PKT_RAM_Type)(unsafe.Pointer(uintptr(0x4005c700)))

	// ZLL
	ZLL = (*ZLL_Type)(unsafe.Pointer(uintptr(0x4005d000)))

	// ANT
	ANT = (*ANT_Type)(unsafe.Pointer(uintptr(0x4005e000)))

	// GENERIC_FSK
	GENFSK = (*GENFSK_Type)(unsafe.Pointer(uintptr(0x4005f000)))

	// Carrier Modulator Transmitter
	CMT = (*CMT_Type)(unsafe.Pointer(uintptr(0x40062000)))

	// Multipurpose Clock Generator module
	MCG = (*MCG_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Inter-Integrated Circuit
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40066000)))

	// Inter-Integrated Circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40067000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP0 = (*CMP0_Type)(unsafe.Pointer(uintptr(0x40073000)))

	// Voltage Reference
	VREF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Low leakage wakeup unit
	LLWU = (*LLWU_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x4007d000)))

	// System Mode Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x4007e000)))

	// Reset Control Module
	RCM = (*RCM_Type)(unsafe.Pointer(uintptr(0x4007f000)))

	// General Purpose Input/Output
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff000)))

	// General Purpose Input/Output
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff040)))

	// General Purpose Input/Output
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff080)))

	// System Control Block
	SystemControl = (*SystemControl_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Micro Trace Buffer
	MTB = (*MTB_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// MTB data watchpoint and trace
	MTBDWT = (*MTBDWT_Type)(unsafe.Pointer(uintptr(0xf0001000)))

	// System ROM
	ROM = (*ROM_Type)(unsafe.Pointer(uintptr(0xf0002000)))

	// Core Platform Miscellaneous Control Module
	MCM = (*MCM_Type)(unsafe.Pointer(uintptr(0xf0003000)))

	// General Purpose Input/Output
	FGPIOA = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000000)))

	// General Purpose Input/Output
	FGPIOB = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000040)))

	// General Purpose Input/Output
	FGPIOC = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000080)))
)

// Flash configuration field
type FTFA_FlashConfig_Type struct {
	BACKKEY3 volatile.Register8 // 0x0
	BACKKEY2 volatile.Register8 // 0x1
	BACKKEY1 volatile.Register8 // 0x2
	BACKKEY0 volatile.Register8 // 0x3
	BACKKEY7 volatile.Register8 // 0x4
	BACKKEY6 volatile.Register8 // 0x5
	BACKKEY5 volatile.Register8 // 0x6
	BACKKEY4 volatile.Register8 // 0x7
	FPROT3   volatile.Register8 // 0x8
	FPROT2   volatile.Register8 // 0x9
	FPROT1   volatile.Register8 // 0xA
	FPROT0   volatile.Register8 // 0xB
	FSEC     volatile.Register8 // 0xC
	FOPT     volatile.Register8 // 0xD
}

// FTFA_FlashConfig.BACKKEY3: Backdoor Comparison Key 3.
func (o *FTFA_FlashConfig_Type) SetBACKKEY3(value uint8) {
	volatile.StoreUint8(&o.BACKKEY3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY3() uint8 {
	return volatile.LoadUint8(&o.BACKKEY3.Reg)
}

// FTFA_FlashConfig.BACKKEY2: Backdoor Comparison Key 2.
func (o *FTFA_FlashConfig_Type) SetBACKKEY2(value uint8) {
	volatile.StoreUint8(&o.BACKKEY2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY2() uint8 {
	return volatile.LoadUint8(&o.BACKKEY2.Reg)
}

// FTFA_FlashConfig.BACKKEY1: Backdoor Comparison Key 1.
func (o *FTFA_FlashConfig_Type) SetBACKKEY1(value uint8) {
	volatile.StoreUint8(&o.BACKKEY1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY1() uint8 {
	return volatile.LoadUint8(&o.BACKKEY1.Reg)
}

// FTFA_FlashConfig.BACKKEY0: Backdoor Comparison Key 0.
func (o *FTFA_FlashConfig_Type) SetBACKKEY0(value uint8) {
	volatile.StoreUint8(&o.BACKKEY0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY0() uint8 {
	return volatile.LoadUint8(&o.BACKKEY0.Reg)
}

// FTFA_FlashConfig.BACKKEY7: Backdoor Comparison Key 7.
func (o *FTFA_FlashConfig_Type) SetBACKKEY7(value uint8) {
	volatile.StoreUint8(&o.BACKKEY7.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY7() uint8 {
	return volatile.LoadUint8(&o.BACKKEY7.Reg)
}

// FTFA_FlashConfig.BACKKEY6: Backdoor Comparison Key 6.
func (o *FTFA_FlashConfig_Type) SetBACKKEY6(value uint8) {
	volatile.StoreUint8(&o.BACKKEY6.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY6() uint8 {
	return volatile.LoadUint8(&o.BACKKEY6.Reg)
}

// FTFA_FlashConfig.BACKKEY5: Backdoor Comparison Key 5.
func (o *FTFA_FlashConfig_Type) SetBACKKEY5(value uint8) {
	volatile.StoreUint8(&o.BACKKEY5.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY5() uint8 {
	return volatile.LoadUint8(&o.BACKKEY5.Reg)
}

// FTFA_FlashConfig.BACKKEY4: Backdoor Comparison Key 4.
func (o *FTFA_FlashConfig_Type) SetBACKKEY4(value uint8) {
	volatile.StoreUint8(&o.BACKKEY4.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY4() uint8 {
	return volatile.LoadUint8(&o.BACKKEY4.Reg)
}

// FTFA_FlashConfig.FPROT3: Non-volatile P-Flash Protection 1 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA_FlashConfig.FPROT2: Non-volatile P-Flash Protection 1 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA_FlashConfig.FPROT1: Non-volatile P-Flash Protection 0 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA_FlashConfig.FPROT0: Non-volatile P-Flash Protection 0 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFA_FlashConfig.FSEC: Non-volatile Flash Security Register
func (o *FTFA_FlashConfig_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_FlashConfig_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_FlashConfig_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA_FlashConfig.FOPT: Non-volatile Flash Option Register
func (o *FTFA_FlashConfig_Type) SetFOPT_LPBOOT0(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x1)|value)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_LPBOOT0() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg) & 0x1
}
func (o *FTFA_FlashConfig_Type) SetFOPT_NMI_DIS(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x4)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_NMI_DIS() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x4) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFOPT_RESET_PIN_CFG(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x8)|value<<3)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_RESET_PIN_CFG() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x8) >> 3
}
func (o *FTFA_FlashConfig_Type) SetFOPT_LPBOOT1(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_LPBOOT1() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x10) >> 4
}
func (o *FTFA_FlashConfig_Type) SetFOPT_FAST_INIT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_FAST_INIT() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x20) >> 5
}

// Enhanced direct memory access controller
type DMA_Type struct {
	CR                 volatile.Register32 // 0x0
	ES                 volatile.Register32 // 0x4
	_                  [4]byte
	ERQ                volatile.Register32 // 0xC
	_                  [4]byte
	EEI                volatile.Register32 // 0x14
	CEEI               volatile.Register8  // 0x18
	SEEI               volatile.Register8  // 0x19
	CERQ               volatile.Register8  // 0x1A
	SERQ               volatile.Register8  // 0x1B
	CDNE               volatile.Register8  // 0x1C
	SSRT               volatile.Register8  // 0x1D
	CERR               volatile.Register8  // 0x1E
	CINT               volatile.Register8  // 0x1F
	_                  [4]byte
	INT                volatile.Register32 // 0x24
	_                  [4]byte
	ERR                volatile.Register32 // 0x2C
	_                  [4]byte
	HRS                volatile.Register32 // 0x34
	_                  [12]byte
	EARS               volatile.Register32 // 0x44
	_                  [184]byte
	DCHPRI3            volatile.Register8 // 0x100
	DCHPRI2            volatile.Register8 // 0x101
	DCHPRI1            volatile.Register8 // 0x102
	DCHPRI0            volatile.Register8 // 0x103
	_                  [3836]byte
	TCD0_SADDR         volatile.Register32 // 0x1000
	TCD0_SOFF          volatile.Register16 // 0x1004
	TCD0_ATTR          volatile.Register16 // 0x1006
	TCD0_NBYTES_MLNO   volatile.Register32 // 0x1008
	TCD0_SLAST         volatile.Register32 // 0x100C
	TCD0_DADDR         volatile.Register32 // 0x1010
	TCD0_DOFF          volatile.Register16 // 0x1014
	TCD0_CITER_ELINKNO volatile.Register16 // 0x1016
	TCD0_DLASTSGA      volatile.Register32 // 0x1018
	TCD0_CSR           volatile.Register16 // 0x101C
	TCD0_BITER_ELINKNO volatile.Register16 // 0x101E
	TCD1_SADDR         volatile.Register32 // 0x1020
	TCD1_SOFF          volatile.Register16 // 0x1024
	TCD1_ATTR          volatile.Register16 // 0x1026
	TCD1_NBYTES_MLNO   volatile.Register32 // 0x1028
	TCD1_SLAST         volatile.Register32 // 0x102C
	TCD1_DADDR         volatile.Register32 // 0x1030
	TCD1_DOFF          volatile.Register16 // 0x1034
	TCD1_CITER_ELINKNO volatile.Register16 // 0x1036
	TCD1_DLASTSGA      volatile.Register32 // 0x1038
	TCD1_CSR           volatile.Register16 // 0x103C
	TCD1_BITER_ELINKNO volatile.Register16 // 0x103E
	TCD2_SADDR         volatile.Register32 // 0x1040
	TCD2_SOFF          volatile.Register16 // 0x1044
	TCD2_ATTR          volatile.Register16 // 0x1046
	TCD2_NBYTES_MLNO   volatile.Register32 // 0x1048
	TCD2_SLAST         volatile.Register32 // 0x104C
	TCD2_DADDR         volatile.Register32 // 0x1050
	TCD2_DOFF          volatile.Register16 // 0x1054
	TCD2_CITER_ELINKNO volatile.Register16 // 0x1056
	TCD2_DLASTSGA      volatile.Register32 // 0x1058
	TCD2_CSR           volatile.Register16 // 0x105C
	TCD2_BITER_ELINKNO volatile.Register16 // 0x105E
	TCD3_SADDR         volatile.Register32 // 0x1060
	TCD3_SOFF          volatile.Register16 // 0x1064
	TCD3_ATTR          volatile.Register16 // 0x1066
	TCD3_NBYTES_MLNO   volatile.Register32 // 0x1068
	TCD3_SLAST         volatile.Register32 // 0x106C
	TCD3_DADDR         volatile.Register32 // 0x1070
	TCD3_DOFF          volatile.Register16 // 0x1074
	TCD3_CITER_ELINKNO volatile.Register16 // 0x1076
	TCD3_DLASTSGA      volatile.Register32 // 0x1078
	TCD3_CSR           volatile.Register16 // 0x107C
	TCD3_BITER_ELINKNO volatile.Register16 // 0x107E
}

// DMA.CR: Control Register
func (o *DMA_Type) SetCR_EDBG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCR_EDBG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCR_ERCA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCR_ERCA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCR_HOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCR_HOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCR_HALT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCR_HALT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCR_CLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCR_CLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCR_EMLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCR_EMLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCR_ECX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetCR_ECX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetCR_CX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCR_CX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetCR_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetCR_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// DMA.ES: Error Status Register
func (o *DMA_Type) SetES_DBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetES_DBE() uint32 {
	return volatile.LoadUint32(&o.ES.Reg) & 0x1
}
func (o *DMA_Type) SetES_SBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetES_SBE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetES_SGE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetES_SGE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetES_NCE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetES_NCE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetES_DOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetES_DOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetES_DAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetES_DAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetES_SOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetES_SOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetES_SAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetES_SAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetES_ERRCHN(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetES_ERRCHN() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetES_CPE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetES_CPE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetES_ECX(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetES_ECX() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetES_VLD(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetES_VLD() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80000000) >> 31
}

// DMA.ERQ: Enable Request Register
func (o *DMA_Type) SetERQ_ERQ0(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERQ_ERQ0() uint32 {
	return volatile.LoadUint32(&o.ERQ.Reg) & 0x1
}
func (o *DMA_Type) SetERQ_ERQ1(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERQ_ERQ1() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERQ_ERQ2(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERQ_ERQ2() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERQ_ERQ3(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERQ_ERQ3() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x8) >> 3
}

// DMA.EEI: Enable Error Interrupt Register
func (o *DMA_Type) SetEEI_EEI0(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEEI_EEI0() uint32 {
	return volatile.LoadUint32(&o.EEI.Reg) & 0x1
}
func (o *DMA_Type) SetEEI_EEI1(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetEEI_EEI1() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetEEI_EEI2(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetEEI_EEI2() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetEEI_EEI3(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetEEI_EEI3() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x8) >> 3
}

// DMA.CEEI: Clear Enable Error Interrupt Register
func (o *DMA_Type) SetCEEI(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetCEEI() uint8 {
	return volatile.LoadUint8(&o.CEEI.Reg) & 0x3
}
func (o *DMA_Type) SetCEEI_CAEE(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCEEI_CAEE() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x80) >> 7
}

// DMA.SEEI: Set Enable Error Interrupt Register
func (o *DMA_Type) SetSEEI(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetSEEI() uint8 {
	return volatile.LoadUint8(&o.SEEI.Reg) & 0x3
}
func (o *DMA_Type) SetSEEI_SAEE(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSEEI_SAEE() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x80) >> 7
}

// DMA.CERQ: Clear Enable Request Register
func (o *DMA_Type) SetCERQ(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetCERQ() uint8 {
	return volatile.LoadUint8(&o.CERQ.Reg) & 0x3
}
func (o *DMA_Type) SetCERQ_CAER(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERQ_CAER() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x80) >> 7
}

// DMA.SERQ: Set Enable Request Register
func (o *DMA_Type) SetSERQ(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetSERQ() uint8 {
	return volatile.LoadUint8(&o.SERQ.Reg) & 0x3
}
func (o *DMA_Type) SetSERQ_SAER(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSERQ_SAER() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x80) >> 7
}

// DMA.CDNE: Clear DONE Status Bit Register
func (o *DMA_Type) SetCDNE(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetCDNE() uint8 {
	return volatile.LoadUint8(&o.CDNE.Reg) & 0x3
}
func (o *DMA_Type) SetCDNE_CADN(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCDNE_CADN() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCDNE_NOP(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCDNE_NOP() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x80) >> 7
}

// DMA.SSRT: Set START Bit Register
func (o *DMA_Type) SetSSRT(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetSSRT() uint8 {
	return volatile.LoadUint8(&o.SSRT.Reg) & 0x3
}
func (o *DMA_Type) SetSSRT_SAST(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSSRT_SAST() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSSRT_NOP(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSSRT_NOP() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x80) >> 7
}

// DMA.CERR: Clear Error Register
func (o *DMA_Type) SetCERR(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetCERR() uint8 {
	return volatile.LoadUint8(&o.CERR.Reg) & 0x3
}
func (o *DMA_Type) SetCERR_CAEI(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERR_CAEI() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERR_NOP(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERR_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x80) >> 7
}

// DMA.CINT: Clear Interrupt Request Register
func (o *DMA_Type) SetCINT(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetCINT() uint8 {
	return volatile.LoadUint8(&o.CINT.Reg) & 0x3
}
func (o *DMA_Type) SetCINT_CAIR(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCINT_CAIR() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCINT_NOP(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCINT_NOP() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x80) >> 7
}

// DMA.INT: Interrupt Request Register
func (o *DMA_Type) SetINT_INT0(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_INT0() uint32 {
	return volatile.LoadUint32(&o.INT.Reg) & 0x1
}
func (o *DMA_Type) SetINT_INT1(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_INT1() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_INT2(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_INT2() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_INT3(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_INT3() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x8) >> 3
}

// DMA.ERR: Error Register
func (o *DMA_Type) SetERR_ERR0(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERR_ERR0() uint32 {
	return volatile.LoadUint32(&o.ERR.Reg) & 0x1
}
func (o *DMA_Type) SetERR_ERR1(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERR_ERR2(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERR_ERR3(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x8) >> 3
}

// DMA.HRS: Hardware Request Status Register
func (o *DMA_Type) SetHRS_HRS0(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHRS_HRS0() uint32 {
	return volatile.LoadUint32(&o.HRS.Reg) & 0x1
}
func (o *DMA_Type) SetHRS_HRS1(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetHRS_HRS1() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetHRS_HRS2(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHRS_HRS2() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHRS_HRS3(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHRS_HRS3() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x8) >> 3
}

// DMA.EARS: Enable Asynchronous Request in Stop Register
func (o *DMA_Type) SetEARS_EDREQ_0(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEARS_EDREQ_0() uint32 {
	return volatile.LoadUint32(&o.EARS.Reg) & 0x1
}
func (o *DMA_Type) SetEARS_EDREQ_1(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetEARS_EDREQ_1() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetEARS_EDREQ_2(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetEARS_EDREQ_2() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetEARS_EDREQ_3(value uint32) {
	volatile.StoreUint32(&o.EARS.Reg, volatile.LoadUint32(&o.EARS.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetEARS_EDREQ_3() uint32 {
	return (volatile.LoadUint32(&o.EARS.Reg) & 0x8) >> 3
}

// DMA.DCHPRI3: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI3_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCHPRI3_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x3
}
func (o *DMA_Type) SetDCHPRI3_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI3_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI3_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI3_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x80) >> 7
}

// DMA.DCHPRI2: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI2_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCHPRI2_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x3
}
func (o *DMA_Type) SetDCHPRI2_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI2_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI2_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI2_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x80) >> 7
}

// DMA.DCHPRI1: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI1_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCHPRI1_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x3
}
func (o *DMA_Type) SetDCHPRI1_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI1_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI1_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI1_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x80) >> 7
}

// DMA.DCHPRI0: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI0_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCHPRI0_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x3
}
func (o *DMA_Type) SetDCHPRI0_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI0_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI0_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI0_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x80) >> 7
}

// DMA.TCD0_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD0_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_SADDR.Reg)
}

// DMA.TCD0_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD0_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_SOFF.Reg)
}

// DMA.TCD0_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD0_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD0_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD0_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD0_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD0_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD0_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD0_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD0_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD0_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Mapping Disabled)
func (o *DMA_Type) SetTCD0_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD0_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD0_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD0_NBYTES_MLNO.Reg)
}

// DMA.TCD0_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD0_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD0_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD0_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD0_SLAST.Reg)
}

// DMA.TCD0_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD0_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_DADDR.Reg)
}

// DMA.TCD0_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD0_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_DOFF.Reg)
}

// DMA.TCD0_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD0_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD0_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD0_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD0_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD0_DLASTSGA.Reg)
}

// DMA.TCD0_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD0_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD0_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD0_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD0_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD0_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD0_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD0_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD0_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD0_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD0_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD0_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD0_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD0_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD0_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD0_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD0_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetTCD0_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD0_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD0_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD1_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_SADDR.Reg)
}

// DMA.TCD1_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD1_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_SOFF.Reg)
}

// DMA.TCD1_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD1_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD1_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD1_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD1_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD1_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD1_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD1_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD1_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD1_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Mapping Disabled)
func (o *DMA_Type) SetTCD1_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD1_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD1_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD1_NBYTES_MLNO.Reg)
}

// DMA.TCD1_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD1_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD1_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD1_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD1_SLAST.Reg)
}

// DMA.TCD1_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD1_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_DADDR.Reg)
}

// DMA.TCD1_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD1_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_DOFF.Reg)
}

// DMA.TCD1_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD1_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD1_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD1_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD1_DLASTSGA.Reg)
}

// DMA.TCD1_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD1_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD1_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD1_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD1_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD1_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD1_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD1_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD1_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD1_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD1_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD1_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD1_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD1_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD1_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD1_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD1_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetTCD1_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD1_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD1_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD2_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_SADDR.Reg)
}

// DMA.TCD2_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD2_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_SOFF.Reg)
}

// DMA.TCD2_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD2_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD2_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD2_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD2_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD2_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD2_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD2_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD2_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD2_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Mapping Disabled)
func (o *DMA_Type) SetTCD2_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD2_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD2_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD2_NBYTES_MLNO.Reg)
}

// DMA.TCD2_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD2_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD2_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD2_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD2_SLAST.Reg)
}

// DMA.TCD2_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD2_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_DADDR.Reg)
}

// DMA.TCD2_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD2_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_DOFF.Reg)
}

// DMA.TCD2_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD2_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD2_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD2_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD2_DLASTSGA.Reg)
}

// DMA.TCD2_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD2_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD2_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD2_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD2_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD2_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD2_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD2_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD2_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD2_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD2_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD2_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD2_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD2_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD2_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD2_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD2_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetTCD2_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD2_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD2_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD3_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_SADDR.Reg)
}

// DMA.TCD3_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD3_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_SOFF.Reg)
}

// DMA.TCD3_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD3_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD3_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD3_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD3_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD3_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD3_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD3_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD3_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD3_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Mapping Disabled)
func (o *DMA_Type) SetTCD3_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD3_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD3_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD3_NBYTES_MLNO.Reg)
}

// DMA.TCD3_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD3_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD3_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD3_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD3_SLAST.Reg)
}

// DMA.TCD3_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD3_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_DADDR.Reg)
}

// DMA.TCD3_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD3_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_DOFF.Reg)
}

// DMA.TCD3_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD3_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD3_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD3_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD3_DLASTSGA.Reg)
}

// DMA.TCD3_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD3_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD3_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD3_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD3_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD3_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD3_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD3_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD3_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD3_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD3_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD3_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD3_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD3_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD3_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD3_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD3_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetTCD3_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD3_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD3_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// Flash Memory Interface
type FTFA_Type struct {
	FSTAT  volatile.Register8 // 0x0
	FCNFG  volatile.Register8 // 0x1
	FSEC   volatile.Register8 // 0x2
	FOPT   volatile.Register8 // 0x3
	FCCOB3 volatile.Register8 // 0x4
	FCCOB2 volatile.Register8 // 0x5
	FCCOB1 volatile.Register8 // 0x6
	FCCOB0 volatile.Register8 // 0x7
	FCCOB7 volatile.Register8 // 0x8
	FCCOB6 volatile.Register8 // 0x9
	FCCOB5 volatile.Register8 // 0xA
	FCCOB4 volatile.Register8 // 0xB
	FCCOBB volatile.Register8 // 0xC
	FCCOBA volatile.Register8 // 0xD
	FCCOB9 volatile.Register8 // 0xE
	FCCOB8 volatile.Register8 // 0xF
	FPROT3 volatile.Register8 // 0x10
	FPROT2 volatile.Register8 // 0x11
	FPROT1 volatile.Register8 // 0x12
	FPROT0 volatile.Register8 // 0x13
	_      [4]byte
	XACCH3 volatile.Register8 // 0x18
	XACCH2 volatile.Register8 // 0x19
	XACCH1 volatile.Register8 // 0x1A
	XACCH0 volatile.Register8 // 0x1B
	XACCL3 volatile.Register8 // 0x1C
	XACCL2 volatile.Register8 // 0x1D
	XACCL1 volatile.Register8 // 0x1E
	XACCL0 volatile.Register8 // 0x1F
	SACCH3 volatile.Register8 // 0x20
	SACCH2 volatile.Register8 // 0x21
	SACCH1 volatile.Register8 // 0x22
	SACCH0 volatile.Register8 // 0x23
	SACCL3 volatile.Register8 // 0x24
	SACCL2 volatile.Register8 // 0x25
	SACCL1 volatile.Register8 // 0x26
	SACCL0 volatile.Register8 // 0x27
	FACSS  volatile.Register8 // 0x28
	_      [2]byte
	FACSN  volatile.Register8 // 0x2B
}

// FTFA.FSTAT: Flash Status Register
func (o *FTFA_Type) SetFSTAT_MGSTAT0(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x1)|value)
}
func (o *FTFA_Type) GetFSTAT_MGSTAT0() uint8 {
	return volatile.LoadUint8(&o.FSTAT.Reg) & 0x1
}
func (o *FTFA_Type) SetFSTAT_FPVIOL(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFSTAT_FPVIOL() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFSTAT_ACCERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFSTAT_ACCERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFSTAT_RDCOLERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFSTAT_RDCOLERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFSTAT_CCIF(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFSTAT_CCIF() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x80) >> 7
}

// FTFA.FCNFG: Flash Configuration Register
func (o *FTFA_Type) SetFCNFG_ERSSUSP(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFCNFG_ERSSUSP() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFCNFG_ERSAREQ(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFCNFG_ERSAREQ() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFCNFG_RDCOLLIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFCNFG_RDCOLLIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFCNFG_CCIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFCNFG_CCIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x80) >> 7
}

// FTFA.FSEC: Flash Security Register
func (o *FTFA_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA.FOPT: Flash Option Register
func (o *FTFA_Type) SetFOPT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, value)
}
func (o *FTFA_Type) GetFOPT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg)
}

// FTFA.FCCOB3: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB3(value uint8) {
	volatile.StoreUint8(&o.FCCOB3.Reg, value)
}
func (o *FTFA_Type) GetFCCOB3() uint8 {
	return volatile.LoadUint8(&o.FCCOB3.Reg)
}

// FTFA.FCCOB2: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB2(value uint8) {
	volatile.StoreUint8(&o.FCCOB2.Reg, value)
}
func (o *FTFA_Type) GetFCCOB2() uint8 {
	return volatile.LoadUint8(&o.FCCOB2.Reg)
}

// FTFA.FCCOB1: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB1(value uint8) {
	volatile.StoreUint8(&o.FCCOB1.Reg, value)
}
func (o *FTFA_Type) GetFCCOB1() uint8 {
	return volatile.LoadUint8(&o.FCCOB1.Reg)
}

// FTFA.FCCOB0: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB0(value uint8) {
	volatile.StoreUint8(&o.FCCOB0.Reg, value)
}
func (o *FTFA_Type) GetFCCOB0() uint8 {
	return volatile.LoadUint8(&o.FCCOB0.Reg)
}

// FTFA.FCCOB7: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB7(value uint8) {
	volatile.StoreUint8(&o.FCCOB7.Reg, value)
}
func (o *FTFA_Type) GetFCCOB7() uint8 {
	return volatile.LoadUint8(&o.FCCOB7.Reg)
}

// FTFA.FCCOB6: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB6(value uint8) {
	volatile.StoreUint8(&o.FCCOB6.Reg, value)
}
func (o *FTFA_Type) GetFCCOB6() uint8 {
	return volatile.LoadUint8(&o.FCCOB6.Reg)
}

// FTFA.FCCOB5: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB5(value uint8) {
	volatile.StoreUint8(&o.FCCOB5.Reg, value)
}
func (o *FTFA_Type) GetFCCOB5() uint8 {
	return volatile.LoadUint8(&o.FCCOB5.Reg)
}

// FTFA.FCCOB4: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB4(value uint8) {
	volatile.StoreUint8(&o.FCCOB4.Reg, value)
}
func (o *FTFA_Type) GetFCCOB4() uint8 {
	return volatile.LoadUint8(&o.FCCOB4.Reg)
}

// FTFA.FCCOBB: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBB(value uint8) {
	volatile.StoreUint8(&o.FCCOBB.Reg, value)
}
func (o *FTFA_Type) GetFCCOBB() uint8 {
	return volatile.LoadUint8(&o.FCCOBB.Reg)
}

// FTFA.FCCOBA: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBA(value uint8) {
	volatile.StoreUint8(&o.FCCOBA.Reg, value)
}
func (o *FTFA_Type) GetFCCOBA() uint8 {
	return volatile.LoadUint8(&o.FCCOBA.Reg)
}

// FTFA.FCCOB9: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB9(value uint8) {
	volatile.StoreUint8(&o.FCCOB9.Reg, value)
}
func (o *FTFA_Type) GetFCCOB9() uint8 {
	return volatile.LoadUint8(&o.FCCOB9.Reg)
}

// FTFA.FCCOB8: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB8(value uint8) {
	volatile.StoreUint8(&o.FCCOB8.Reg, value)
}
func (o *FTFA_Type) GetFCCOB8() uint8 {
	return volatile.LoadUint8(&o.FCCOB8.Reg)
}

// FTFA.FPROT3: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA.FPROT2: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA.FPROT1: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA.FPROT0: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFA.XACCH3: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH3(value uint8) {
	volatile.StoreUint8(&o.XACCH3.Reg, value)
}
func (o *FTFA_Type) GetXACCH3() uint8 {
	return volatile.LoadUint8(&o.XACCH3.Reg)
}

// FTFA.XACCH2: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH2(value uint8) {
	volatile.StoreUint8(&o.XACCH2.Reg, value)
}
func (o *FTFA_Type) GetXACCH2() uint8 {
	return volatile.LoadUint8(&o.XACCH2.Reg)
}

// FTFA.XACCH1: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH1(value uint8) {
	volatile.StoreUint8(&o.XACCH1.Reg, value)
}
func (o *FTFA_Type) GetXACCH1() uint8 {
	return volatile.LoadUint8(&o.XACCH1.Reg)
}

// FTFA.XACCH0: Execute-only Access Registers
func (o *FTFA_Type) SetXACCH0(value uint8) {
	volatile.StoreUint8(&o.XACCH0.Reg, value)
}
func (o *FTFA_Type) GetXACCH0() uint8 {
	return volatile.LoadUint8(&o.XACCH0.Reg)
}

// FTFA.XACCL3: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL3(value uint8) {
	volatile.StoreUint8(&o.XACCL3.Reg, value)
}
func (o *FTFA_Type) GetXACCL3() uint8 {
	return volatile.LoadUint8(&o.XACCL3.Reg)
}

// FTFA.XACCL2: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL2(value uint8) {
	volatile.StoreUint8(&o.XACCL2.Reg, value)
}
func (o *FTFA_Type) GetXACCL2() uint8 {
	return volatile.LoadUint8(&o.XACCL2.Reg)
}

// FTFA.XACCL1: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL1(value uint8) {
	volatile.StoreUint8(&o.XACCL1.Reg, value)
}
func (o *FTFA_Type) GetXACCL1() uint8 {
	return volatile.LoadUint8(&o.XACCL1.Reg)
}

// FTFA.XACCL0: Execute-only Access Registers
func (o *FTFA_Type) SetXACCL0(value uint8) {
	volatile.StoreUint8(&o.XACCL0.Reg, value)
}
func (o *FTFA_Type) GetXACCL0() uint8 {
	return volatile.LoadUint8(&o.XACCL0.Reg)
}

// FTFA.SACCH3: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH3(value uint8) {
	volatile.StoreUint8(&o.SACCH3.Reg, value)
}
func (o *FTFA_Type) GetSACCH3() uint8 {
	return volatile.LoadUint8(&o.SACCH3.Reg)
}

// FTFA.SACCH2: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH2(value uint8) {
	volatile.StoreUint8(&o.SACCH2.Reg, value)
}
func (o *FTFA_Type) GetSACCH2() uint8 {
	return volatile.LoadUint8(&o.SACCH2.Reg)
}

// FTFA.SACCH1: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH1(value uint8) {
	volatile.StoreUint8(&o.SACCH1.Reg, value)
}
func (o *FTFA_Type) GetSACCH1() uint8 {
	return volatile.LoadUint8(&o.SACCH1.Reg)
}

// FTFA.SACCH0: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCH0(value uint8) {
	volatile.StoreUint8(&o.SACCH0.Reg, value)
}
func (o *FTFA_Type) GetSACCH0() uint8 {
	return volatile.LoadUint8(&o.SACCH0.Reg)
}

// FTFA.SACCL3: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL3(value uint8) {
	volatile.StoreUint8(&o.SACCL3.Reg, value)
}
func (o *FTFA_Type) GetSACCL3() uint8 {
	return volatile.LoadUint8(&o.SACCL3.Reg)
}

// FTFA.SACCL2: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL2(value uint8) {
	volatile.StoreUint8(&o.SACCL2.Reg, value)
}
func (o *FTFA_Type) GetSACCL2() uint8 {
	return volatile.LoadUint8(&o.SACCL2.Reg)
}

// FTFA.SACCL1: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL1(value uint8) {
	volatile.StoreUint8(&o.SACCL1.Reg, value)
}
func (o *FTFA_Type) GetSACCL1() uint8 {
	return volatile.LoadUint8(&o.SACCL1.Reg)
}

// FTFA.SACCL0: Supervisor-only Access Registers
func (o *FTFA_Type) SetSACCL0(value uint8) {
	volatile.StoreUint8(&o.SACCL0.Reg, value)
}
func (o *FTFA_Type) GetSACCL0() uint8 {
	return volatile.LoadUint8(&o.SACCL0.Reg)
}

// FTFA.FACSS: Flash Access Segment Size Register
func (o *FTFA_Type) SetFACSS(value uint8) {
	volatile.StoreUint8(&o.FACSS.Reg, value)
}
func (o *FTFA_Type) GetFACSS() uint8 {
	return volatile.LoadUint8(&o.FACSS.Reg)
}

// FTFA.FACSN: Flash Access Segment Number Register
func (o *FTFA_Type) SetFACSN(value uint8) {
	volatile.StoreUint8(&o.FACSN.Reg, value)
}
func (o *FTFA_Type) GetFACSN() uint8 {
	return volatile.LoadUint8(&o.FACSN.Reg)
}

// DMA channel multiplexor
type DMAMUX0_Type struct {
	CHCFG0 volatile.Register8 // 0x0
	CHCFG1 volatile.Register8 // 0x1
	CHCFG2 volatile.Register8 // 0x2
	CHCFG3 volatile.Register8 // 0x3
}

// DMAMUX0.CHCFG0: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG0_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG0_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG0.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG0_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG0_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG0_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG0_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG1: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG1_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG1_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG1.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG1_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG1_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG1_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG1_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG2: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG2_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG2_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG2.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG2_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG2_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG2_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG2_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG3: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG3_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG3_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG3.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG3_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG3_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG3_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG3_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x80) >> 7
}

// TRNG0
type TRNG0_Type struct {
	MCTL       volatile.Register32 // 0x0
	SCMISC     volatile.Register32 // 0x4
	PKRRNG     volatile.Register32 // 0x8
	PKRMAX     volatile.Register32 // 0xC
	SDCTL      volatile.Register32 // 0x10
	SBLIM      volatile.Register32 // 0x14
	FRQMIN     volatile.Register32 // 0x18
	FRQCNT     volatile.Register32 // 0x1C
	SCMC       volatile.Register32 // 0x20
	SCR1C      volatile.Register32 // 0x24
	SCR2C      volatile.Register32 // 0x28
	SCR3C      volatile.Register32 // 0x2C
	SCR4C      volatile.Register32 // 0x30
	SCR5C      volatile.Register32 // 0x34
	SCR6PC     volatile.Register32 // 0x38
	STATUS     volatile.Register32 // 0x3C
	ENT0       volatile.Register32 // 0x40
	ENT1       volatile.Register32 // 0x44
	ENT2       volatile.Register32 // 0x48
	ENT3       volatile.Register32 // 0x4C
	ENT4       volatile.Register32 // 0x50
	ENT5       volatile.Register32 // 0x54
	ENT6       volatile.Register32 // 0x58
	ENT7       volatile.Register32 // 0x5C
	ENT8       volatile.Register32 // 0x60
	ENT9       volatile.Register32 // 0x64
	ENT10      volatile.Register32 // 0x68
	ENT11      volatile.Register32 // 0x6C
	ENT12      volatile.Register32 // 0x70
	ENT13      volatile.Register32 // 0x74
	ENT14      volatile.Register32 // 0x78
	ENT15      volatile.Register32 // 0x7C
	PKRCNT10   volatile.Register32 // 0x80
	PKRCNT32   volatile.Register32 // 0x84
	PKRCNT54   volatile.Register32 // 0x88
	PKRCNT76   volatile.Register32 // 0x8C
	PKRCNT98   volatile.Register32 // 0x90
	PKRCNTBA   volatile.Register32 // 0x94
	PKRCNTDC   volatile.Register32 // 0x98
	PKRCNTFE   volatile.Register32 // 0x9C
	_          [16]byte
	SEC_CFG    volatile.Register32 // 0xB0
	INT_CTRL   volatile.Register32 // 0xB4
	INT_MASK   volatile.Register32 // 0xB8
	INT_STATUS volatile.Register32 // 0xBC
	_          [48]byte
	VID1       volatile.Register32 // 0xF0
	VID2       volatile.Register32 // 0xF4
}

// TRNG0.MCTL: Miscellaneous Control Register
func (o *TRNG0_Type) SetMCTL_SAMP_MODE(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x3)|value)
}
func (o *TRNG0_Type) GetMCTL_SAMP_MODE() uint32 {
	return volatile.LoadUint32(&o.MCTL.Reg) & 0x3
}
func (o *TRNG0_Type) SetMCTL_OSC_DIV(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0xc)|value<<2)
}
func (o *TRNG0_Type) GetMCTL_OSC_DIV() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0xc) >> 2
}
func (o *TRNG0_Type) SetMCTL_UNUSED(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x10)|value<<4)
}
func (o *TRNG0_Type) GetMCTL_UNUSED() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x10) >> 4
}
func (o *TRNG0_Type) SetMCTL_TRNG_ACC(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x20)|value<<5)
}
func (o *TRNG0_Type) GetMCTL_TRNG_ACC() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x20) >> 5
}
func (o *TRNG0_Type) SetMCTL_RST_DEF(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x40)|value<<6)
}
func (o *TRNG0_Type) GetMCTL_RST_DEF() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x40) >> 6
}
func (o *TRNG0_Type) SetMCTL_FOR_SCLK(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x80)|value<<7)
}
func (o *TRNG0_Type) GetMCTL_FOR_SCLK() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x80) >> 7
}
func (o *TRNG0_Type) SetMCTL_FCT_FAIL(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x100)|value<<8)
}
func (o *TRNG0_Type) GetMCTL_FCT_FAIL() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x100) >> 8
}
func (o *TRNG0_Type) SetMCTL_FCT_VAL(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x200)|value<<9)
}
func (o *TRNG0_Type) GetMCTL_FCT_VAL() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x200) >> 9
}
func (o *TRNG0_Type) SetMCTL_ENT_VAL(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x400)|value<<10)
}
func (o *TRNG0_Type) GetMCTL_ENT_VAL() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x400) >> 10
}
func (o *TRNG0_Type) SetMCTL_TST_OUT(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x800)|value<<11)
}
func (o *TRNG0_Type) GetMCTL_TST_OUT() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x800) >> 11
}
func (o *TRNG0_Type) SetMCTL_ERR(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x1000)|value<<12)
}
func (o *TRNG0_Type) GetMCTL_ERR() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x1000) >> 12
}
func (o *TRNG0_Type) SetMCTL_TSTOP_OK(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x2000)|value<<13)
}
func (o *TRNG0_Type) GetMCTL_TSTOP_OK() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x2000) >> 13
}
func (o *TRNG0_Type) SetMCTL_PRGM(value uint32) {
	volatile.StoreUint32(&o.MCTL.Reg, volatile.LoadUint32(&o.MCTL.Reg)&^(0x10000)|value<<16)
}
func (o *TRNG0_Type) GetMCTL_PRGM() uint32 {
	return (volatile.LoadUint32(&o.MCTL.Reg) & 0x10000) >> 16
}

// TRNG0.SCMISC: Statistical Check Miscellaneous Register
func (o *TRNG0_Type) SetSCMISC_LRUN_MAX(value uint32) {
	volatile.StoreUint32(&o.SCMISC.Reg, volatile.LoadUint32(&o.SCMISC.Reg)&^(0xff)|value)
}
func (o *TRNG0_Type) GetSCMISC_LRUN_MAX() uint32 {
	return volatile.LoadUint32(&o.SCMISC.Reg) & 0xff
}
func (o *TRNG0_Type) SetSCMISC_RTY_CT(value uint32) {
	volatile.StoreUint32(&o.SCMISC.Reg, volatile.LoadUint32(&o.SCMISC.Reg)&^(0xf0000)|value<<16)
}
func (o *TRNG0_Type) GetSCMISC_RTY_CT() uint32 {
	return (volatile.LoadUint32(&o.SCMISC.Reg) & 0xf0000) >> 16
}

// TRNG0.PKRRNG: Poker Range Register
func (o *TRNG0_Type) SetPKRRNG_PKR_RNG(value uint32) {
	volatile.StoreUint32(&o.PKRRNG.Reg, volatile.LoadUint32(&o.PKRRNG.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRRNG_PKR_RNG() uint32 {
	return volatile.LoadUint32(&o.PKRRNG.Reg) & 0xffff
}

// TRNG0.PKRMAX: Poker Maximum Limit Register
func (o *TRNG0_Type) SetPKRMAX_PKR_MAX(value uint32) {
	volatile.StoreUint32(&o.PKRMAX.Reg, volatile.LoadUint32(&o.PKRMAX.Reg)&^(0xffffff)|value)
}
func (o *TRNG0_Type) GetPKRMAX_PKR_MAX() uint32 {
	return volatile.LoadUint32(&o.PKRMAX.Reg) & 0xffffff
}

// TRNG0.SDCTL: Seed Control Register
func (o *TRNG0_Type) SetSDCTL_SAMP_SIZE(value uint32) {
	volatile.StoreUint32(&o.SDCTL.Reg, volatile.LoadUint32(&o.SDCTL.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetSDCTL_SAMP_SIZE() uint32 {
	return volatile.LoadUint32(&o.SDCTL.Reg) & 0xffff
}
func (o *TRNG0_Type) SetSDCTL_ENT_DLY(value uint32) {
	volatile.StoreUint32(&o.SDCTL.Reg, volatile.LoadUint32(&o.SDCTL.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetSDCTL_ENT_DLY() uint32 {
	return (volatile.LoadUint32(&o.SDCTL.Reg) & 0xffff0000) >> 16
}

// TRNG0.SBLIM: Sparse Bit Limit Register
func (o *TRNG0_Type) SetSBLIM_SB_LIM(value uint32) {
	volatile.StoreUint32(&o.SBLIM.Reg, volatile.LoadUint32(&o.SBLIM.Reg)&^(0x3ff)|value)
}
func (o *TRNG0_Type) GetSBLIM_SB_LIM() uint32 {
	return volatile.LoadUint32(&o.SBLIM.Reg) & 0x3ff
}

// TRNG0.FRQMIN: Frequency Count Minimum Limit Register
func (o *TRNG0_Type) SetFRQMIN_FRQ_MIN(value uint32) {
	volatile.StoreUint32(&o.FRQMIN.Reg, volatile.LoadUint32(&o.FRQMIN.Reg)&^(0x3fffff)|value)
}
func (o *TRNG0_Type) GetFRQMIN_FRQ_MIN() uint32 {
	return volatile.LoadUint32(&o.FRQMIN.Reg) & 0x3fffff
}

// TRNG0.FRQCNT: Frequency Count Register
func (o *TRNG0_Type) SetFRQCNT_FRQ_CT(value uint32) {
	volatile.StoreUint32(&o.FRQCNT.Reg, volatile.LoadUint32(&o.FRQCNT.Reg)&^(0x3fffff)|value)
}
func (o *TRNG0_Type) GetFRQCNT_FRQ_CT() uint32 {
	return volatile.LoadUint32(&o.FRQCNT.Reg) & 0x3fffff
}

// TRNG0.SCMC: Statistical Check Monobit Count Register
func (o *TRNG0_Type) SetSCMC_MONO_CT(value uint32) {
	volatile.StoreUint32(&o.SCMC.Reg, volatile.LoadUint32(&o.SCMC.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetSCMC_MONO_CT() uint32 {
	return volatile.LoadUint32(&o.SCMC.Reg) & 0xffff
}

// TRNG0.SCR1C: Statistical Check Run Length 1 Count Register
func (o *TRNG0_Type) SetSCR1C_R1_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR1C.Reg, volatile.LoadUint32(&o.SCR1C.Reg)&^(0x7fff)|value)
}
func (o *TRNG0_Type) GetSCR1C_R1_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR1C.Reg) & 0x7fff
}
func (o *TRNG0_Type) SetSCR1C_R1_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR1C.Reg, volatile.LoadUint32(&o.SCR1C.Reg)&^(0x7fff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR1C_R1_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR1C.Reg) & 0x7fff0000) >> 16
}

// TRNG0.SCR2C: Statistical Check Run Length 2 Count Register
func (o *TRNG0_Type) SetSCR2C_R2_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR2C.Reg, volatile.LoadUint32(&o.SCR2C.Reg)&^(0x3fff)|value)
}
func (o *TRNG0_Type) GetSCR2C_R2_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR2C.Reg) & 0x3fff
}
func (o *TRNG0_Type) SetSCR2C_R2_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR2C.Reg, volatile.LoadUint32(&o.SCR2C.Reg)&^(0x3fff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR2C_R2_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR2C.Reg) & 0x3fff0000) >> 16
}

// TRNG0.SCR3C: Statistical Check Run Length 3 Count Register
func (o *TRNG0_Type) SetSCR3C_R3_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR3C.Reg, volatile.LoadUint32(&o.SCR3C.Reg)&^(0x1fff)|value)
}
func (o *TRNG0_Type) GetSCR3C_R3_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR3C.Reg) & 0x1fff
}
func (o *TRNG0_Type) SetSCR3C_R3_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR3C.Reg, volatile.LoadUint32(&o.SCR3C.Reg)&^(0x1fff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR3C_R3_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR3C.Reg) & 0x1fff0000) >> 16
}

// TRNG0.SCR4C: Statistical Check Run Length 4 Count Register
func (o *TRNG0_Type) SetSCR4C_R4_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR4C.Reg, volatile.LoadUint32(&o.SCR4C.Reg)&^(0xfff)|value)
}
func (o *TRNG0_Type) GetSCR4C_R4_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR4C.Reg) & 0xfff
}
func (o *TRNG0_Type) SetSCR4C_R4_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR4C.Reg, volatile.LoadUint32(&o.SCR4C.Reg)&^(0xfff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR4C_R4_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR4C.Reg) & 0xfff0000) >> 16
}

// TRNG0.SCR5C: Statistical Check Run Length 5 Count Register
func (o *TRNG0_Type) SetSCR5C_R5_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR5C.Reg, volatile.LoadUint32(&o.SCR5C.Reg)&^(0x7ff)|value)
}
func (o *TRNG0_Type) GetSCR5C_R5_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR5C.Reg) & 0x7ff
}
func (o *TRNG0_Type) SetSCR5C_R5_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR5C.Reg, volatile.LoadUint32(&o.SCR5C.Reg)&^(0x7ff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR5C_R5_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR5C.Reg) & 0x7ff0000) >> 16
}

// TRNG0.SCR6PC: Statistical Check Run Length 6+ Count Register
func (o *TRNG0_Type) SetSCR6PC_R6P_0_CT(value uint32) {
	volatile.StoreUint32(&o.SCR6PC.Reg, volatile.LoadUint32(&o.SCR6PC.Reg)&^(0x7ff)|value)
}
func (o *TRNG0_Type) GetSCR6PC_R6P_0_CT() uint32 {
	return volatile.LoadUint32(&o.SCR6PC.Reg) & 0x7ff
}
func (o *TRNG0_Type) SetSCR6PC_R6P_1_CT(value uint32) {
	volatile.StoreUint32(&o.SCR6PC.Reg, volatile.LoadUint32(&o.SCR6PC.Reg)&^(0x7ff0000)|value<<16)
}
func (o *TRNG0_Type) GetSCR6PC_R6P_1_CT() uint32 {
	return (volatile.LoadUint32(&o.SCR6PC.Reg) & 0x7ff0000) >> 16
}

// TRNG0.STATUS: Status Register
func (o *TRNG0_Type) SetSTATUS_TF1BR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TRNG0_Type) GetSTATUS_TF1BR0() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *TRNG0_Type) SetSTATUS_TF1BR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TRNG0_Type) GetSTATUS_TF1BR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TRNG0_Type) SetSTATUS_TF2BR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *TRNG0_Type) GetSTATUS_TF2BR0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *TRNG0_Type) SetSTATUS_TF2BR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TRNG0_Type) GetSTATUS_TF2BR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TRNG0_Type) SetSTATUS_TF3BR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TRNG0_Type) GetSTATUS_TF3BR0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TRNG0_Type) SetSTATUS_TF3BR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TRNG0_Type) GetSTATUS_TF3BR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *TRNG0_Type) SetSTATUS_TF4BR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *TRNG0_Type) GetSTATUS_TF4BR0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *TRNG0_Type) SetSTATUS_TF4BR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TRNG0_Type) GetSTATUS_TF4BR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *TRNG0_Type) SetSTATUS_TF5BR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *TRNG0_Type) GetSTATUS_TF5BR0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *TRNG0_Type) SetSTATUS_TF5BR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *TRNG0_Type) GetSTATUS_TF5BR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *TRNG0_Type) SetSTATUS_TF6PBR0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *TRNG0_Type) GetSTATUS_TF6PBR0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *TRNG0_Type) SetSTATUS_TF6PBR1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *TRNG0_Type) GetSTATUS_TF6PBR1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}
func (o *TRNG0_Type) SetSTATUS_TFSB(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *TRNG0_Type) GetSTATUS_TFSB() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *TRNG0_Type) SetSTATUS_TFLR(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *TRNG0_Type) GetSTATUS_TFLR() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *TRNG0_Type) SetSTATUS_TFP(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *TRNG0_Type) GetSTATUS_TFP() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *TRNG0_Type) SetSTATUS_TFMB(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *TRNG0_Type) GetSTATUS_TFMB() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *TRNG0_Type) SetSTATUS_RETRY_CT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf0000)|value<<16)
}
func (o *TRNG0_Type) GetSTATUS_RETRY_CT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf0000) >> 16
}

// TRNG0.ENT0: Entropy Read Register
func (o *TRNG0_Type) SetENT0(value uint32) {
	volatile.StoreUint32(&o.ENT0.Reg, value)
}
func (o *TRNG0_Type) GetENT0() uint32 {
	return volatile.LoadUint32(&o.ENT0.Reg)
}

// TRNG0.ENT1: Entropy Read Register
func (o *TRNG0_Type) SetENT1(value uint32) {
	volatile.StoreUint32(&o.ENT1.Reg, value)
}
func (o *TRNG0_Type) GetENT1() uint32 {
	return volatile.LoadUint32(&o.ENT1.Reg)
}

// TRNG0.ENT2: Entropy Read Register
func (o *TRNG0_Type) SetENT2(value uint32) {
	volatile.StoreUint32(&o.ENT2.Reg, value)
}
func (o *TRNG0_Type) GetENT2() uint32 {
	return volatile.LoadUint32(&o.ENT2.Reg)
}

// TRNG0.ENT3: Entropy Read Register
func (o *TRNG0_Type) SetENT3(value uint32) {
	volatile.StoreUint32(&o.ENT3.Reg, value)
}
func (o *TRNG0_Type) GetENT3() uint32 {
	return volatile.LoadUint32(&o.ENT3.Reg)
}

// TRNG0.ENT4: Entropy Read Register
func (o *TRNG0_Type) SetENT4(value uint32) {
	volatile.StoreUint32(&o.ENT4.Reg, value)
}
func (o *TRNG0_Type) GetENT4() uint32 {
	return volatile.LoadUint32(&o.ENT4.Reg)
}

// TRNG0.ENT5: Entropy Read Register
func (o *TRNG0_Type) SetENT5(value uint32) {
	volatile.StoreUint32(&o.ENT5.Reg, value)
}
func (o *TRNG0_Type) GetENT5() uint32 {
	return volatile.LoadUint32(&o.ENT5.Reg)
}

// TRNG0.ENT6: Entropy Read Register
func (o *TRNG0_Type) SetENT6(value uint32) {
	volatile.StoreUint32(&o.ENT6.Reg, value)
}
func (o *TRNG0_Type) GetENT6() uint32 {
	return volatile.LoadUint32(&o.ENT6.Reg)
}

// TRNG0.ENT7: Entropy Read Register
func (o *TRNG0_Type) SetENT7(value uint32) {
	volatile.StoreUint32(&o.ENT7.Reg, value)
}
func (o *TRNG0_Type) GetENT7() uint32 {
	return volatile.LoadUint32(&o.ENT7.Reg)
}

// TRNG0.ENT8: Entropy Read Register
func (o *TRNG0_Type) SetENT8(value uint32) {
	volatile.StoreUint32(&o.ENT8.Reg, value)
}
func (o *TRNG0_Type) GetENT8() uint32 {
	return volatile.LoadUint32(&o.ENT8.Reg)
}

// TRNG0.ENT9: Entropy Read Register
func (o *TRNG0_Type) SetENT9(value uint32) {
	volatile.StoreUint32(&o.ENT9.Reg, value)
}
func (o *TRNG0_Type) GetENT9() uint32 {
	return volatile.LoadUint32(&o.ENT9.Reg)
}

// TRNG0.ENT10: Entropy Read Register
func (o *TRNG0_Type) SetENT10(value uint32) {
	volatile.StoreUint32(&o.ENT10.Reg, value)
}
func (o *TRNG0_Type) GetENT10() uint32 {
	return volatile.LoadUint32(&o.ENT10.Reg)
}

// TRNG0.ENT11: Entropy Read Register
func (o *TRNG0_Type) SetENT11(value uint32) {
	volatile.StoreUint32(&o.ENT11.Reg, value)
}
func (o *TRNG0_Type) GetENT11() uint32 {
	return volatile.LoadUint32(&o.ENT11.Reg)
}

// TRNG0.ENT12: Entropy Read Register
func (o *TRNG0_Type) SetENT12(value uint32) {
	volatile.StoreUint32(&o.ENT12.Reg, value)
}
func (o *TRNG0_Type) GetENT12() uint32 {
	return volatile.LoadUint32(&o.ENT12.Reg)
}

// TRNG0.ENT13: Entropy Read Register
func (o *TRNG0_Type) SetENT13(value uint32) {
	volatile.StoreUint32(&o.ENT13.Reg, value)
}
func (o *TRNG0_Type) GetENT13() uint32 {
	return volatile.LoadUint32(&o.ENT13.Reg)
}

// TRNG0.ENT14: Entropy Read Register
func (o *TRNG0_Type) SetENT14(value uint32) {
	volatile.StoreUint32(&o.ENT14.Reg, value)
}
func (o *TRNG0_Type) GetENT14() uint32 {
	return volatile.LoadUint32(&o.ENT14.Reg)
}

// TRNG0.ENT15: Entropy Read Register
func (o *TRNG0_Type) SetENT15(value uint32) {
	volatile.StoreUint32(&o.ENT15.Reg, value)
}
func (o *TRNG0_Type) GetENT15() uint32 {
	return volatile.LoadUint32(&o.ENT15.Reg)
}

// TRNG0.PKRCNT10: Statistical Check Poker Count 1 and 0 Register
func (o *TRNG0_Type) SetPKRCNT10_PKR_0_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT10.Reg, volatile.LoadUint32(&o.PKRCNT10.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNT10_PKR_0_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNT10.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNT10_PKR_1_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT10.Reg, volatile.LoadUint32(&o.PKRCNT10.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNT10_PKR_1_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNT10.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNT32: Statistical Check Poker Count 3 and 2 Register
func (o *TRNG0_Type) SetPKRCNT32_PKR_2_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT32.Reg, volatile.LoadUint32(&o.PKRCNT32.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNT32_PKR_2_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNT32.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNT32_PKR_3_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT32.Reg, volatile.LoadUint32(&o.PKRCNT32.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNT32_PKR_3_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNT32.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNT54: Statistical Check Poker Count 5 and 4 Register
func (o *TRNG0_Type) SetPKRCNT54_PKR_4_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT54.Reg, volatile.LoadUint32(&o.PKRCNT54.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNT54_PKR_4_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNT54.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNT54_PKR_5_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT54.Reg, volatile.LoadUint32(&o.PKRCNT54.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNT54_PKR_5_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNT54.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNT76: Statistical Check Poker Count 7 and 6 Register
func (o *TRNG0_Type) SetPKRCNT76_PKR_6_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT76.Reg, volatile.LoadUint32(&o.PKRCNT76.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNT76_PKR_6_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNT76.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNT76_PKR_7_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT76.Reg, volatile.LoadUint32(&o.PKRCNT76.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNT76_PKR_7_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNT76.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNT98: Statistical Check Poker Count 9 and 8 Register
func (o *TRNG0_Type) SetPKRCNT98_PKR_8_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT98.Reg, volatile.LoadUint32(&o.PKRCNT98.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNT98_PKR_8_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNT98.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNT98_PKR_9_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNT98.Reg, volatile.LoadUint32(&o.PKRCNT98.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNT98_PKR_9_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNT98.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNTBA: Statistical Check Poker Count B and A Register
func (o *TRNG0_Type) SetPKRCNTBA_PKR_A_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTBA.Reg, volatile.LoadUint32(&o.PKRCNTBA.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNTBA_PKR_A_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNTBA.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNTBA_PKR_B_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTBA.Reg, volatile.LoadUint32(&o.PKRCNTBA.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNTBA_PKR_B_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNTBA.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNTDC: Statistical Check Poker Count D and C Register
func (o *TRNG0_Type) SetPKRCNTDC_PKR_C_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTDC.Reg, volatile.LoadUint32(&o.PKRCNTDC.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNTDC_PKR_C_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNTDC.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNTDC_PKR_D_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTDC.Reg, volatile.LoadUint32(&o.PKRCNTDC.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNTDC_PKR_D_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNTDC.Reg) & 0xffff0000) >> 16
}

// TRNG0.PKRCNTFE: Statistical Check Poker Count F and E Register
func (o *TRNG0_Type) SetPKRCNTFE_PKR_E_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTFE.Reg, volatile.LoadUint32(&o.PKRCNTFE.Reg)&^(0xffff)|value)
}
func (o *TRNG0_Type) GetPKRCNTFE_PKR_E_CT() uint32 {
	return volatile.LoadUint32(&o.PKRCNTFE.Reg) & 0xffff
}
func (o *TRNG0_Type) SetPKRCNTFE_PKR_F_CT(value uint32) {
	volatile.StoreUint32(&o.PKRCNTFE.Reg, volatile.LoadUint32(&o.PKRCNTFE.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetPKRCNTFE_PKR_F_CT() uint32 {
	return (volatile.LoadUint32(&o.PKRCNTFE.Reg) & 0xffff0000) >> 16
}

// TRNG0.SEC_CFG: Security Configuration Register
func (o *TRNG0_Type) SetSEC_CFG_SH0(value uint32) {
	volatile.StoreUint32(&o.SEC_CFG.Reg, volatile.LoadUint32(&o.SEC_CFG.Reg)&^(0x1)|value)
}
func (o *TRNG0_Type) GetSEC_CFG_SH0() uint32 {
	return volatile.LoadUint32(&o.SEC_CFG.Reg) & 0x1
}
func (o *TRNG0_Type) SetSEC_CFG_NO_PRGM(value uint32) {
	volatile.StoreUint32(&o.SEC_CFG.Reg, volatile.LoadUint32(&o.SEC_CFG.Reg)&^(0x2)|value<<1)
}
func (o *TRNG0_Type) GetSEC_CFG_NO_PRGM() uint32 {
	return (volatile.LoadUint32(&o.SEC_CFG.Reg) & 0x2) >> 1
}
func (o *TRNG0_Type) SetSEC_CFG_SK_VAL(value uint32) {
	volatile.StoreUint32(&o.SEC_CFG.Reg, volatile.LoadUint32(&o.SEC_CFG.Reg)&^(0x4)|value<<2)
}
func (o *TRNG0_Type) GetSEC_CFG_SK_VAL() uint32 {
	return (volatile.LoadUint32(&o.SEC_CFG.Reg) & 0x4) >> 2
}

// TRNG0.INT_CTRL: Interrupt Control Register
func (o *TRNG0_Type) SetINT_CTRL_HW_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_CTRL.Reg, volatile.LoadUint32(&o.INT_CTRL.Reg)&^(0x1)|value)
}
func (o *TRNG0_Type) GetINT_CTRL_HW_ERR() uint32 {
	return volatile.LoadUint32(&o.INT_CTRL.Reg) & 0x1
}
func (o *TRNG0_Type) SetINT_CTRL_ENT_VAL(value uint32) {
	volatile.StoreUint32(&o.INT_CTRL.Reg, volatile.LoadUint32(&o.INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TRNG0_Type) GetINT_CTRL_ENT_VAL() uint32 {
	return (volatile.LoadUint32(&o.INT_CTRL.Reg) & 0x2) >> 1
}
func (o *TRNG0_Type) SetINT_CTRL_FRQ_CT_FAIL(value uint32) {
	volatile.StoreUint32(&o.INT_CTRL.Reg, volatile.LoadUint32(&o.INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *TRNG0_Type) GetINT_CTRL_FRQ_CT_FAIL() uint32 {
	return (volatile.LoadUint32(&o.INT_CTRL.Reg) & 0x4) >> 2
}
func (o *TRNG0_Type) SetINT_CTRL_UNUSED(value uint32) {
	volatile.StoreUint32(&o.INT_CTRL.Reg, volatile.LoadUint32(&o.INT_CTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *TRNG0_Type) GetINT_CTRL_UNUSED() uint32 {
	return (volatile.LoadUint32(&o.INT_CTRL.Reg) & 0xfffffff8) >> 3
}

// TRNG0.INT_MASK: Mask Register
func (o *TRNG0_Type) SetINT_MASK_HW_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_MASK.Reg, volatile.LoadUint32(&o.INT_MASK.Reg)&^(0x1)|value)
}
func (o *TRNG0_Type) GetINT_MASK_HW_ERR() uint32 {
	return volatile.LoadUint32(&o.INT_MASK.Reg) & 0x1
}
func (o *TRNG0_Type) SetINT_MASK_ENT_VAL(value uint32) {
	volatile.StoreUint32(&o.INT_MASK.Reg, volatile.LoadUint32(&o.INT_MASK.Reg)&^(0x2)|value<<1)
}
func (o *TRNG0_Type) GetINT_MASK_ENT_VAL() uint32 {
	return (volatile.LoadUint32(&o.INT_MASK.Reg) & 0x2) >> 1
}
func (o *TRNG0_Type) SetINT_MASK_FRQ_CT_FAIL(value uint32) {
	volatile.StoreUint32(&o.INT_MASK.Reg, volatile.LoadUint32(&o.INT_MASK.Reg)&^(0x4)|value<<2)
}
func (o *TRNG0_Type) GetINT_MASK_FRQ_CT_FAIL() uint32 {
	return (volatile.LoadUint32(&o.INT_MASK.Reg) & 0x4) >> 2
}

// TRNG0.INT_STATUS: Interrupt Status Register
func (o *TRNG0_Type) SetINT_STATUS_HW_ERR(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *TRNG0_Type) GetINT_STATUS_HW_ERR() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *TRNG0_Type) SetINT_STATUS_ENT_VAL(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TRNG0_Type) GetINT_STATUS_ENT_VAL() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *TRNG0_Type) SetINT_STATUS_FRQ_CT_FAIL(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *TRNG0_Type) GetINT_STATUS_FRQ_CT_FAIL() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}

// TRNG0.VID1: Version ID Register (MS)
func (o *TRNG0_Type) SetVID1_MIN_REV(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xff)|value)
}
func (o *TRNG0_Type) GetVID1_MIN_REV() uint32 {
	return volatile.LoadUint32(&o.VID1.Reg) & 0xff
}
func (o *TRNG0_Type) SetVID1_MAJ_REV(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xff00)|value<<8)
}
func (o *TRNG0_Type) GetVID1_MAJ_REV() uint32 {
	return (volatile.LoadUint32(&o.VID1.Reg) & 0xff00) >> 8
}
func (o *TRNG0_Type) SetVID1_IP_ID(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xffff0000)|value<<16)
}
func (o *TRNG0_Type) GetVID1_IP_ID() uint32 {
	return (volatile.LoadUint32(&o.VID1.Reg) & 0xffff0000) >> 16
}

// TRNG0.VID2: Version ID Register (LS)
func (o *TRNG0_Type) SetVID2_CONFIG_OPT(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff)|value)
}
func (o *TRNG0_Type) GetVID2_CONFIG_OPT() uint32 {
	return volatile.LoadUint32(&o.VID2.Reg) & 0xff
}
func (o *TRNG0_Type) SetVID2_ECO_REV(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff00)|value<<8)
}
func (o *TRNG0_Type) GetVID2_ECO_REV() uint32 {
	return (volatile.LoadUint32(&o.VID2.Reg) & 0xff00) >> 8
}
func (o *TRNG0_Type) SetVID2_INTG_OPT(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff0000)|value<<16)
}
func (o *TRNG0_Type) GetVID2_INTG_OPT() uint32 {
	return (volatile.LoadUint32(&o.VID2.Reg) & 0xff0000) >> 16
}
func (o *TRNG0_Type) SetVID2_ERA(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff000000)|value<<24)
}
func (o *TRNG0_Type) GetVID2_ERA() uint32 {
	return (volatile.LoadUint32(&o.VID2.Reg) & 0xff000000) >> 24
}

// Serial Peripheral Interface
type SPI_Type struct {
	MCR   volatile.Register32 // 0x0
	_     [4]byte
	TCR   volatile.Register32 // 0x8
	CTAR0 volatile.Register32 // 0xC
	CTAR1 volatile.Register32 // 0x10
	_     [24]byte
	SR    volatile.Register32 // 0x2C
	RSER  volatile.Register32 // 0x30
	PUSHR volatile.Register32 // 0x34
	POPR  volatile.Register32 // 0x38
	TXFR0 volatile.Register32 // 0x3C
	TXFR1 volatile.Register32 // 0x40
	TXFR2 volatile.Register32 // 0x44
	TXFR3 volatile.Register32 // 0x48
	_     [48]byte
	RXFR0 volatile.Register32 // 0x7C
	RXFR1 volatile.Register32 // 0x80
	RXFR2 volatile.Register32 // 0x84
	RXFR3 volatile.Register32 // 0x88
}

// SPI.MCR: Module Configuration Register
func (o *SPI_Type) SetMCR_HALT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMCR_HALT() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *SPI_Type) SetMCR_SMPL_PT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetMCR_SMPL_PT() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetMCR_CLR_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetMCR_CLR_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetMCR_CLR_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetMCR_CLR_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetMCR_DIS_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetMCR_DIS_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetMCR_DIS_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetMCR_DIS_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetMCR_DOZE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetMCR_DOZE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetMCR_PCSIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMCR_PCSIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMCR_ROOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetMCR_ROOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetMCR_MTFE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetMCR_MTFE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetMCR_FRZ() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetMCR_DCONF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x30000000)|value<<28)
}
func (o *SPI_Type) GetMCR_DCONF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x30000000) >> 28
}
func (o *SPI_Type) SetMCR_CONT_SCKE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetMCR_CONT_SCKE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetMCR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetMCR_MSTR() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// SPI.TCR: Transfer Count Register
func (o *SPI_Type) SetTCR_SPI_TCNT(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTCR_SPI_TCNT() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xffff0000) >> 16
}

// SPI.CTAR0: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR0_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR0_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR0.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR0_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR0_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR0_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR0_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR0_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR0_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR0_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR0_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR0_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR0_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR0_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR0_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR0_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR0_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR0_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR0_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR0_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR0_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR0_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR0_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x80000000) >> 31
}

// SPI.CTAR1: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR1_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR1_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR1.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR1_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR1_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR1_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR1_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR1_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR1_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR1_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR1_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR1_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR1_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR1_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR1_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR1_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR1_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR1_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR1_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR1_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR1_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR1_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR1_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR1_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x80000000) >> 31
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_POPNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetSR_POPNXTPTR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0xf
}
func (o *SPI_Type) SetSR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetSR_RXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetSR_TXNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetSR_TXNXTPTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetSR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetSR_TXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetSR_RFDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetSR_RFDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetSR_RFOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetSR_RFOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetSR_TFFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetSR_TFFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetSR_TFUF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetSR_TFUF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetSR_EOQF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetSR_EOQF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetSR_TXRXS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetSR_TXRXS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// SPI.RSER: DMA/Interrupt Request Select and Enable Register
func (o *SPI_Type) SetRSER_RFDF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetRSER_RFDF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetRSER_RFDF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetRSER_RFDF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetRSER_RFOF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetRSER_RFOF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetRSER_TFFF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetRSER_TFFF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetRSER_TFFF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetRSER_TFFF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetRSER_TFUF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetRSER_TFUF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetRSER_EOQF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetRSER_EOQF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetRSER_TCF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetRSER_TCF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000000) >> 31
}

// SPI.PUSHR: PUSH TX FIFO Register In Master Mode
func (o *SPI_Type) SetPUSHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetPUSHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.PUSHR.Reg) & 0xffff
}
func (o *SPI_Type) SetPUSHR_PCS(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetPUSHR_PCS() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetPUSHR_CTCNT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetPUSHR_CTCNT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetPUSHR_EOQ(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetPUSHR_EOQ() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetPUSHR_CTAS(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x70000000)|value<<28)
}
func (o *SPI_Type) GetPUSHR_CTAS() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x70000000) >> 28
}
func (o *SPI_Type) SetPUSHR_CONT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetPUSHR_CONT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x80000000) >> 31
}

// SPI.POPR: POP RX FIFO Register
func (o *SPI_Type) SetPOPR(value uint32) {
	volatile.StoreUint32(&o.POPR.Reg, value)
}
func (o *SPI_Type) GetPOPR() uint32 {
	return volatile.LoadUint32(&o.POPR.Reg)
}

// SPI.TXFR0: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR0_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR0_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR0_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR0_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR1: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR1_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR1_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR1_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR1_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR2: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR2_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR2_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR2_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR2_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR3: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR3_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR3_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR3_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR3_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff0000) >> 16
}

// SPI.RXFR0: Receive FIFO Registers
func (o *SPI_Type) SetRXFR0(value uint32) {
	volatile.StoreUint32(&o.RXFR0.Reg, value)
}
func (o *SPI_Type) GetRXFR0() uint32 {
	return volatile.LoadUint32(&o.RXFR0.Reg)
}

// SPI.RXFR1: Receive FIFO Registers
func (o *SPI_Type) SetRXFR1(value uint32) {
	volatile.StoreUint32(&o.RXFR1.Reg, value)
}
func (o *SPI_Type) GetRXFR1() uint32 {
	return volatile.LoadUint32(&o.RXFR1.Reg)
}

// SPI.RXFR2: Receive FIFO Registers
func (o *SPI_Type) SetRXFR2(value uint32) {
	volatile.StoreUint32(&o.RXFR2.Reg, value)
}
func (o *SPI_Type) GetRXFR2() uint32 {
	return volatile.LoadUint32(&o.RXFR2.Reg)
}

// SPI.RXFR3: Receive FIFO Registers
func (o *SPI_Type) SetRXFR3(value uint32) {
	volatile.StoreUint32(&o.RXFR3.Reg, value)
}
func (o *SPI_Type) GetRXFR3() uint32 {
	return volatile.LoadUint32(&o.RXFR3.Reg)
}

// Periodic Interrupt Timer
type PIT_Type struct {
	MCR     volatile.Register32 // 0x0
	_       [220]byte
	LTMR64H volatile.Register32 // 0xE0
	LTMR64L volatile.Register32 // 0xE4
	_       [24]byte
	LDVAL0  volatile.Register32 // 0x100
	CVAL0   volatile.Register32 // 0x104
	TCTRL0  volatile.Register32 // 0x108
	TFLG0   volatile.Register32 // 0x10C
	LDVAL1  volatile.Register32 // 0x110
	CVAL1   volatile.Register32 // 0x114
	TCTRL1  volatile.Register32 // 0x118
	TFLG1   volatile.Register32 // 0x11C
}

// PIT.MCR: PIT Module Control Register
func (o *PIT_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetMCR_FRZ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PIT_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}

// PIT.LTMR64H: PIT Upper Lifetime Timer Register
func (o *PIT_Type) SetLTMR64H(value uint32) {
	volatile.StoreUint32(&o.LTMR64H.Reg, value)
}
func (o *PIT_Type) GetLTMR64H() uint32 {
	return volatile.LoadUint32(&o.LTMR64H.Reg)
}

// PIT.LTMR64L: PIT Lower Lifetime Timer Register
func (o *PIT_Type) SetLTMR64L(value uint32) {
	volatile.StoreUint32(&o.LTMR64L.Reg, value)
}
func (o *PIT_Type) GetLTMR64L() uint32 {
	return volatile.LoadUint32(&o.LTMR64L.Reg)
}

// PIT.LDVAL0: Timer Load Value Register
func (o *PIT_Type) SetLDVAL0(value uint32) {
	volatile.StoreUint32(&o.LDVAL0.Reg, value)
}
func (o *PIT_Type) GetLDVAL0() uint32 {
	return volatile.LoadUint32(&o.LDVAL0.Reg)
}

// PIT.CVAL0: Current Timer Value Register
func (o *PIT_Type) SetCVAL0(value uint32) {
	volatile.StoreUint32(&o.CVAL0.Reg, value)
}
func (o *PIT_Type) GetCVAL0() uint32 {
	return volatile.LoadUint32(&o.CVAL0.Reg)
}

// PIT.TCTRL0: Timer Control Register
func (o *PIT_Type) SetTCTRL0_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL0_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL0.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL0_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL0_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL0_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL0_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x4) >> 2
}

// PIT.TFLG0: Timer Flag Register
func (o *PIT_Type) SetTFLG0_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG0.Reg, volatile.LoadUint32(&o.TFLG0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG0_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG0.Reg) & 0x1
}

// PIT.LDVAL1: Timer Load Value Register
func (o *PIT_Type) SetLDVAL1(value uint32) {
	volatile.StoreUint32(&o.LDVAL1.Reg, value)
}
func (o *PIT_Type) GetLDVAL1() uint32 {
	return volatile.LoadUint32(&o.LDVAL1.Reg)
}

// PIT.CVAL1: Current Timer Value Register
func (o *PIT_Type) SetCVAL1(value uint32) {
	volatile.StoreUint32(&o.CVAL1.Reg, value)
}
func (o *PIT_Type) GetCVAL1() uint32 {
	return volatile.LoadUint32(&o.CVAL1.Reg)
}

// PIT.TCTRL1: Timer Control Register
func (o *PIT_Type) SetTCTRL1_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL1_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL1.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL1_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL1_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL1_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL1_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x4) >> 2
}

// PIT.TFLG1: Timer Flag Register
func (o *PIT_Type) SetTFLG1_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG1.Reg, volatile.LoadUint32(&o.TFLG1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG1_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG1.Reg) & 0x1
}

// Timer/PWM Module
type TPM_Type struct {
	SC      volatile.Register32 // 0x0
	CNT     volatile.Register32 // 0x4
	MOD     volatile.Register32 // 0x8
	C0SC    volatile.Register32 // 0xC
	C0V     volatile.Register32 // 0x10
	C1SC    volatile.Register32 // 0x14
	C1V     volatile.Register32 // 0x18
	C2SC    volatile.Register32 // 0x1C
	C2V     volatile.Register32 // 0x20
	C3SC    volatile.Register32 // 0x24
	C3V     volatile.Register32 // 0x28
	_       [36]byte
	STATUS  volatile.Register32 // 0x50
	_       [16]byte
	COMBINE volatile.Register32 // 0x64
	_       [8]byte
	POL     volatile.Register32 // 0x70
	_       [4]byte
	FILTER  volatile.Register32 // 0x78
	_       [4]byte
	QDCTRL  volatile.Register32 // 0x80
	CONF    volatile.Register32 // 0x84
}

// TPM.SC: Status and Control
func (o *TPM_Type) SetSC_PS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7)|value)
}
func (o *TPM_Type) GetSC_PS() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x7
}
func (o *TPM_Type) SetSC_CMOD(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x18)|value<<3)
}
func (o *TPM_Type) GetSC_CMOD() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x18) >> 3
}
func (o *TPM_Type) SetSC_CPWMS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetSC_CPWMS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetSC_TOIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetSC_TOIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetSC_TOF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetSC_TOF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}
func (o *TPM_Type) SetSC_DMA(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetSC_DMA() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x100) >> 8
}

// TPM.CNT: Counter
func (o *TPM_Type) SetCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TPM.MOD: Modulo
func (o *TPM_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// TPM.C0SC: Channel (n) Status and Control
func (o *TPM_Type) SetC0SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC0SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C0SC.Reg) & 0x1
}
func (o *TPM_Type) SetC0SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC0SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC0SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC0SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC0SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC0SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC0SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC0SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC0SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC0SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC0SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC0SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x80) >> 7
}

// TPM.C0V: Channel (n) Value
func (o *TPM_Type) SetC0V_VAL(value uint32) {
	volatile.StoreUint32(&o.C0V.Reg, volatile.LoadUint32(&o.C0V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC0V_VAL() uint32 {
	return volatile.LoadUint32(&o.C0V.Reg) & 0xffff
}

// TPM.C1SC: Channel (n) Status and Control
func (o *TPM_Type) SetC1SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC1SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C1SC.Reg) & 0x1
}
func (o *TPM_Type) SetC1SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC1SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC1SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC1SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC1SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC1SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC1SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC1SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC1SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC1SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC1SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC1SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x80) >> 7
}

// TPM.C1V: Channel (n) Value
func (o *TPM_Type) SetC1V_VAL(value uint32) {
	volatile.StoreUint32(&o.C1V.Reg, volatile.LoadUint32(&o.C1V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC1V_VAL() uint32 {
	return volatile.LoadUint32(&o.C1V.Reg) & 0xffff
}

// TPM.C2SC: Channel (n) Status and Control
func (o *TPM_Type) SetC2SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC2SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C2SC.Reg) & 0x1
}
func (o *TPM_Type) SetC2SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC2SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC2SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC2SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC2SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC2SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC2SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC2SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC2SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC2SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC2SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC2SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x80) >> 7
}

// TPM.C2V: Channel (n) Value
func (o *TPM_Type) SetC2V_VAL(value uint32) {
	volatile.StoreUint32(&o.C2V.Reg, volatile.LoadUint32(&o.C2V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC2V_VAL() uint32 {
	return volatile.LoadUint32(&o.C2V.Reg) & 0xffff
}

// TPM.C3SC: Channel (n) Status and Control
func (o *TPM_Type) SetC3SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC3SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C3SC.Reg) & 0x1
}
func (o *TPM_Type) SetC3SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC3SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC3SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC3SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC3SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC3SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC3SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC3SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC3SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC3SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC3SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC3SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x80) >> 7
}

// TPM.C3V: Channel (n) Value
func (o *TPM_Type) SetC3V_VAL(value uint32) {
	volatile.StoreUint32(&o.C3V.Reg, volatile.LoadUint32(&o.C3V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC3V_VAL() uint32 {
	return volatile.LoadUint32(&o.C3V.Reg) & 0xffff
}

// TPM.STATUS: Capture and Compare Status
func (o *TPM_Type) SetSTATUS_CH0F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetSTATUS_CH0F() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *TPM_Type) SetSTATUS_CH1F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TPM_Type) GetSTATUS_CH1F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TPM_Type) SetSTATUS_CH2F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetSTATUS_CH2F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetSTATUS_CH3F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetSTATUS_CH3F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetSTATUS_TOF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetSTATUS_TOF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}

// TPM.COMBINE: Combine Channel Register
func (o *TPM_Type) SetCOMBINE_COMBINE0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetCOMBINE_COMBINE0() uint32 {
	return volatile.LoadUint32(&o.COMBINE.Reg) & 0x1
}
func (o *TPM_Type) SetCOMBINE_COMSWAP0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2)|value<<1)
}
func (o *TPM_Type) GetCOMBINE_COMSWAP0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2) >> 1
}
func (o *TPM_Type) SetCOMBINE_COMBINE1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetCOMBINE_COMBINE1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x100) >> 8
}
func (o *TPM_Type) SetCOMBINE_COMSWAP1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x200)|value<<9)
}
func (o *TPM_Type) GetCOMBINE_COMSWAP1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x200) >> 9
}

// TPM.POL: Channel Polarity
func (o *TPM_Type) SetPOL_POL0(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetPOL_POL0() uint32 {
	return volatile.LoadUint32(&o.POL.Reg) & 0x1
}
func (o *TPM_Type) SetPOL_POL1(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x2)|value<<1)
}
func (o *TPM_Type) GetPOL_POL1() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x2) >> 1
}
func (o *TPM_Type) SetPOL_POL2(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetPOL_POL2() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetPOL_POL3(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetPOL_POL3() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x8) >> 3
}

// TPM.FILTER: Filter Control
func (o *TPM_Type) SetFILTER_CH0FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf)|value)
}
func (o *TPM_Type) GetFILTER_CH0FVAL() uint32 {
	return volatile.LoadUint32(&o.FILTER.Reg) & 0xf
}
func (o *TPM_Type) SetFILTER_CH1FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf0)|value<<4)
}
func (o *TPM_Type) GetFILTER_CH1FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf0) >> 4
}
func (o *TPM_Type) SetFILTER_CH2FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf00)|value<<8)
}
func (o *TPM_Type) GetFILTER_CH2FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf00) >> 8
}
func (o *TPM_Type) SetFILTER_CH3FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf000)|value<<12)
}
func (o *TPM_Type) GetFILTER_CH3FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf000) >> 12
}

// TPM.QDCTRL: Quadrature Decoder Control and Status
func (o *TPM_Type) SetQDCTRL_QUADEN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetQDCTRL_QUADEN() uint32 {
	return volatile.LoadUint32(&o.QDCTRL.Reg) & 0x1
}
func (o *TPM_Type) SetQDCTRL_TOFDIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TPM_Type) GetQDCTRL_TOFDIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x2) >> 1
}
func (o *TPM_Type) SetQDCTRL_QUADIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetQDCTRL_QUADIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetQDCTRL_QUADMODE(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetQDCTRL_QUADMODE() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x8) >> 3
}

// TPM.CONF: Configuration
func (o *TPM_Type) SetCONF_DOZEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetCONF_DOZEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetCONF_DBGMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xc0)|value<<6)
}
func (o *TPM_Type) GetCONF_DBGMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xc0) >> 6
}
func (o *TPM_Type) SetCONF_GTBSYNC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetCONF_GTBSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x100) >> 8
}
func (o *TPM_Type) SetCONF_GTBEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *TPM_Type) GetCONF_GTBEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *TPM_Type) SetCONF_CSOT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000)|value<<16)
}
func (o *TPM_Type) GetCONF_CSOT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000) >> 16
}
func (o *TPM_Type) SetCONF_CSOO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000)|value<<17)
}
func (o *TPM_Type) GetCONF_CSOO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000) >> 17
}
func (o *TPM_Type) SetCONF_CROT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40000)|value<<18)
}
func (o *TPM_Type) GetCONF_CROT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40000) >> 18
}
func (o *TPM_Type) SetCONF_CPOT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80000)|value<<19)
}
func (o *TPM_Type) GetCONF_CPOT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80000) >> 19
}
func (o *TPM_Type) SetCONF_TRGPOL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400000)|value<<22)
}
func (o *TPM_Type) GetCONF_TRGPOL() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400000) >> 22
}
func (o *TPM_Type) SetCONF_TRGSRC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x800000)|value<<23)
}
func (o *TPM_Type) GetCONF_TRGSRC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x800000) >> 23
}
func (o *TPM_Type) SetCONF_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xf000000)|value<<24)
}
func (o *TPM_Type) GetCONF_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xf000000) >> 24
}

// Analog-to-Digital Converter
type ADC0_Type struct {
	SC1A volatile.Register32 // 0x0
	SC1B volatile.Register32 // 0x4
	CFG1 volatile.Register32 // 0x8
	CFG2 volatile.Register32 // 0xC
	RA   volatile.Register32 // 0x10
	RB   volatile.Register32 // 0x14
	CV1  volatile.Register32 // 0x18
	CV2  volatile.Register32 // 0x1C
	SC2  volatile.Register32 // 0x20
	SC3  volatile.Register32 // 0x24
	OFS  volatile.Register32 // 0x28
	PG   volatile.Register32 // 0x2C
	MG   volatile.Register32 // 0x30
	CLPD volatile.Register32 // 0x34
	CLPS volatile.Register32 // 0x38
	CLP4 volatile.Register32 // 0x3C
	CLP3 volatile.Register32 // 0x40
	CLP2 volatile.Register32 // 0x44
	CLP1 volatile.Register32 // 0x48
	CLP0 volatile.Register32 // 0x4C
	_    [4]byte
	CLMD volatile.Register32 // 0x54
	CLMS volatile.Register32 // 0x58
	CLM4 volatile.Register32 // 0x5C
	CLM3 volatile.Register32 // 0x60
	CLM2 volatile.Register32 // 0x64
	CLM1 volatile.Register32 // 0x68
	CLM0 volatile.Register32 // 0x6C
}

// ADC0.SC1A: ADC Status and Control Registers 1
func (o *ADC0_Type) SetSC1A_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x1f)|value)
}
func (o *ADC0_Type) GetSC1A_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1A.Reg) & 0x1f
}
func (o *ADC0_Type) SetSC1A_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC1A_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC1A_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC1A_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC1A_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC1A_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x80) >> 7
}

// ADC0.SC1B: ADC Status and Control Registers 1
func (o *ADC0_Type) SetSC1B_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x1f)|value)
}
func (o *ADC0_Type) GetSC1B_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1B.Reg) & 0x1f
}
func (o *ADC0_Type) SetSC1B_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC1B_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC1B_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC1B_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC1B_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC1B_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x80) >> 7
}

// ADC0.CFG1: ADC Configuration Register 1
func (o *ADC0_Type) SetCFG1_ADICLK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetCFG1_ADICLK() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x3
}
func (o *ADC0_Type) SetCFG1_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *ADC0_Type) GetCFG1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *ADC0_Type) SetCFG1_ADLSMP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetCFG1_ADLSMP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ADC0_Type) SetCFG1_ADIV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x60)|value<<5)
}
func (o *ADC0_Type) GetCFG1_ADIV() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x60) >> 5
}
func (o *ADC0_Type) SetCFG1_ADLPC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetCFG1_ADLPC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}

// ADC0.CFG2: ADC Configuration Register 2
func (o *ADC0_Type) SetCFG2_ADLSTS(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetCFG2_ADLSTS() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x3
}
func (o *ADC0_Type) SetCFG2_ADHSC(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetCFG2_ADHSC() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetCFG2_ADACKEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetCFG2_ADACKEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetCFG2_MUXSEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetCFG2_MUXSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}

// ADC0.RA: ADC Data Result Register
func (o *ADC0_Type) SetRA_D(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetRA_D() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0xffff
}

// ADC0.RB: ADC Data Result Register
func (o *ADC0_Type) SetRB_D(value uint32) {
	volatile.StoreUint32(&o.RB.Reg, volatile.LoadUint32(&o.RB.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetRB_D() uint32 {
	return volatile.LoadUint32(&o.RB.Reg) & 0xffff
}

// ADC0.CV1: Compare Value Registers
func (o *ADC0_Type) SetCV1_CV(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, volatile.LoadUint32(&o.CV1.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetCV1_CV() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg) & 0xffff
}

// ADC0.CV2: Compare Value Registers
func (o *ADC0_Type) SetCV2_CV(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, volatile.LoadUint32(&o.CV2.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetCV2_CV() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg) & 0xffff
}

// ADC0.SC2: Status and Control Register 2
func (o *ADC0_Type) SetSC2_REFSEL(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetSC2_REFSEL() uint32 {
	return volatile.LoadUint32(&o.SC2.Reg) & 0x3
}
func (o *ADC0_Type) SetSC2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetSC2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetSC2_ACREN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetSC2_ACREN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetSC2_ACFGT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetSC2_ACFGT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x10) >> 4
}
func (o *ADC0_Type) SetSC2_ACFE(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC2_ACFE() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC2_ADTRG(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC2_ADTRG() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC2_ADACT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC2_ADACT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x80) >> 7
}

// ADC0.SC3: Status and Control Register 3
func (o *ADC0_Type) SetSC3_AVGS(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetSC3_AVGS() uint32 {
	return volatile.LoadUint32(&o.SC3.Reg) & 0x3
}
func (o *ADC0_Type) SetSC3_AVGE(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetSC3_AVGE() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetSC3_ADCO(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetSC3_ADCO() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetSC3_CALF(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC3_CALF() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC3_CAL(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC3_CAL() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x80) >> 7
}

// ADC0.OFS: ADC Offset Correction Register
func (o *ADC0_Type) SetOFS(value uint32) {
	volatile.StoreUint32(&o.OFS.Reg, volatile.LoadUint32(&o.OFS.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetOFS() uint32 {
	return volatile.LoadUint32(&o.OFS.Reg) & 0xffff
}

// ADC0.PG: ADC Plus-Side Gain Register
func (o *ADC0_Type) SetPG(value uint32) {
	volatile.StoreUint32(&o.PG.Reg, volatile.LoadUint32(&o.PG.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetPG() uint32 {
	return volatile.LoadUint32(&o.PG.Reg) & 0xffff
}

// ADC0.MG: ADC Minus-Side Gain Register
func (o *ADC0_Type) SetMG(value uint32) {
	volatile.StoreUint32(&o.MG.Reg, volatile.LoadUint32(&o.MG.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetMG() uint32 {
	return volatile.LoadUint32(&o.MG.Reg) & 0xffff
}

// ADC0.CLPD: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLPD(value uint32) {
	volatile.StoreUint32(&o.CLPD.Reg, volatile.LoadUint32(&o.CLPD.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLPD() uint32 {
	return volatile.LoadUint32(&o.CLPD.Reg) & 0x3f
}

// ADC0.CLPS: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLPS(value uint32) {
	volatile.StoreUint32(&o.CLPS.Reg, volatile.LoadUint32(&o.CLPS.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLPS() uint32 {
	return volatile.LoadUint32(&o.CLPS.Reg) & 0x3f
}

// ADC0.CLP4: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP4(value uint32) {
	volatile.StoreUint32(&o.CLP4.Reg, volatile.LoadUint32(&o.CLP4.Reg)&^(0x3ff)|value)
}
func (o *ADC0_Type) GetCLP4() uint32 {
	return volatile.LoadUint32(&o.CLP4.Reg) & 0x3ff
}

// ADC0.CLP3: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP3(value uint32) {
	volatile.StoreUint32(&o.CLP3.Reg, volatile.LoadUint32(&o.CLP3.Reg)&^(0x1ff)|value)
}
func (o *ADC0_Type) GetCLP3() uint32 {
	return volatile.LoadUint32(&o.CLP3.Reg) & 0x1ff
}

// ADC0.CLP2: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP2(value uint32) {
	volatile.StoreUint32(&o.CLP2.Reg, volatile.LoadUint32(&o.CLP2.Reg)&^(0xff)|value)
}
func (o *ADC0_Type) GetCLP2() uint32 {
	return volatile.LoadUint32(&o.CLP2.Reg) & 0xff
}

// ADC0.CLP1: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP1(value uint32) {
	volatile.StoreUint32(&o.CLP1.Reg, volatile.LoadUint32(&o.CLP1.Reg)&^(0x7f)|value)
}
func (o *ADC0_Type) GetCLP1() uint32 {
	return volatile.LoadUint32(&o.CLP1.Reg) & 0x7f
}

// ADC0.CLP0: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP0(value uint32) {
	volatile.StoreUint32(&o.CLP0.Reg, volatile.LoadUint32(&o.CLP0.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLP0() uint32 {
	return volatile.LoadUint32(&o.CLP0.Reg) & 0x3f
}

// ADC0.CLMD: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLMD(value uint32) {
	volatile.StoreUint32(&o.CLMD.Reg, volatile.LoadUint32(&o.CLMD.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLMD() uint32 {
	return volatile.LoadUint32(&o.CLMD.Reg) & 0x3f
}

// ADC0.CLMS: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLMS(value uint32) {
	volatile.StoreUint32(&o.CLMS.Reg, volatile.LoadUint32(&o.CLMS.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLMS() uint32 {
	return volatile.LoadUint32(&o.CLMS.Reg) & 0x3f
}

// ADC0.CLM4: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM4(value uint32) {
	volatile.StoreUint32(&o.CLM4.Reg, volatile.LoadUint32(&o.CLM4.Reg)&^(0x3ff)|value)
}
func (o *ADC0_Type) GetCLM4() uint32 {
	return volatile.LoadUint32(&o.CLM4.Reg) & 0x3ff
}

// ADC0.CLM3: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM3(value uint32) {
	volatile.StoreUint32(&o.CLM3.Reg, volatile.LoadUint32(&o.CLM3.Reg)&^(0x1ff)|value)
}
func (o *ADC0_Type) GetCLM3() uint32 {
	return volatile.LoadUint32(&o.CLM3.Reg) & 0x1ff
}

// ADC0.CLM2: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM2(value uint32) {
	volatile.StoreUint32(&o.CLM2.Reg, volatile.LoadUint32(&o.CLM2.Reg)&^(0xff)|value)
}
func (o *ADC0_Type) GetCLM2() uint32 {
	return volatile.LoadUint32(&o.CLM2.Reg) & 0xff
}

// ADC0.CLM1: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM1(value uint32) {
	volatile.StoreUint32(&o.CLM1.Reg, volatile.LoadUint32(&o.CLM1.Reg)&^(0x7f)|value)
}
func (o *ADC0_Type) GetCLM1() uint32 {
	return volatile.LoadUint32(&o.CLM1.Reg) & 0x7f
}

// ADC0.CLM0: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM0(value uint32) {
	volatile.StoreUint32(&o.CLM0.Reg, volatile.LoadUint32(&o.CLM0.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLM0() uint32 {
	return volatile.LoadUint32(&o.CLM0.Reg) & 0x3f
}

// Secure Real Time Clock
type RTC_Type struct {
	TSR volatile.Register32 // 0x0
	TPR volatile.Register32 // 0x4
	TAR volatile.Register32 // 0x8
	TCR volatile.Register32 // 0xC
	CR  volatile.Register32 // 0x10
	SR  volatile.Register32 // 0x14
	LR  volatile.Register32 // 0x18
	IER volatile.Register32 // 0x1C
}

// RTC.TSR: RTC Time Seconds Register
func (o *RTC_Type) SetTSR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, value)
}
func (o *RTC_Type) GetTSR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg)
}

// RTC.TPR: RTC Time Prescaler Register
func (o *RTC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, volatile.LoadUint32(&o.TPR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg) & 0xffff
}

// RTC.TAR: RTC Time Alarm Register
func (o *RTC_Type) SetTAR(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, value)
}
func (o *RTC_Type) GetTAR() uint32 {
	return volatile.LoadUint32(&o.TAR.Reg)
}

// RTC.TCR: RTC Time Compensation Register
func (o *RTC_Type) SetTCR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetTCR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xff
}
func (o *RTC_Type) SetTCR_CIR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_Type) GetTCR_CIR() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff00) >> 8
}
func (o *RTC_Type) SetTCR_TCV(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RTC_Type) GetTCR_TCV() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff0000) >> 16
}
func (o *RTC_Type) SetTCR_CIC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_Type) GetTCR_CIC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff000000) >> 24
}

// RTC.CR: RTC Control Register
func (o *RTC_Type) SetCR_SWR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCR_SWR() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RTC_Type) SetCR_WPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCR_WPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCR_SUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCR_SUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCR_UM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_UM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WPS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_WPS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_OSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_OSCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_CLKO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_SC16P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_SC16P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_SC8P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_SC8P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_SC4P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_SC4P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_SC2P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_SC2P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}

// RTC.SR: RTC Status Register
func (o *RTC_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_TIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_TAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_TAF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// RTC.LR: RTC Lock Register
func (o *RTC_Type) SetLR_TCL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetLR_TCL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetLR_CRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetLR_CRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetLR_SRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetLR_SRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetLR_LRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetLR_LRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x40) >> 6
}

// RTC.IER: RTC Interrupt Enable Register
func (o *RTC_Type) SetIER_TIIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIER_TIIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *RTC_Type) SetIER_TOIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIER_TOIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIER_TAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIER_TAIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIER_TSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIER_TSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIER_WPON(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetIER_WPON() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}

// 12-Bit Digital-to-Analog Converter
type DAC0_Type struct {
	DAT0L volatile.Register8 // 0x0
	DAT0H volatile.Register8 // 0x1
	DAT1L volatile.Register8 // 0x2
	DAT1H volatile.Register8 // 0x3
	_     [28]byte
	SR    volatile.Register8 // 0x20
	C0    volatile.Register8 // 0x21
	C1    volatile.Register8 // 0x22
	C2    volatile.Register8 // 0x23
}

// DAC0.DAT0L: DAC Data Low Register
func (o *DAC0_Type) SetDAT0L(value uint8) {
	volatile.StoreUint8(&o.DAT0L.Reg, value)
}
func (o *DAC0_Type) GetDAT0L() uint8 {
	return volatile.LoadUint8(&o.DAT0L.Reg)
}

// DAC0.DAT0H: DAC Data High Register
func (o *DAC0_Type) SetDAT0H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT0H.Reg, volatile.LoadUint8(&o.DAT0H.Reg)&^(0xf)|value)
}
func (o *DAC0_Type) GetDAT0H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT0H.Reg) & 0xf
}

// DAC0.DAT1L: DAC Data Low Register
func (o *DAC0_Type) SetDAT1L(value uint8) {
	volatile.StoreUint8(&o.DAT1L.Reg, value)
}
func (o *DAC0_Type) GetDAT1L() uint8 {
	return volatile.LoadUint8(&o.DAT1L.Reg)
}

// DAC0.DAT1H: DAC Data High Register
func (o *DAC0_Type) SetDAT1H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT1H.Reg, volatile.LoadUint8(&o.DAT1H.Reg)&^(0xf)|value)
}
func (o *DAC0_Type) GetDAT1H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT1H.Reg) & 0xf
}

// DAC0.SR: DAC Status Register
func (o *DAC0_Type) SetSR_DACBFRPBF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetSR_DACBFRPBF() uint8 {
	return volatile.LoadUint8(&o.SR.Reg) & 0x1
}
func (o *DAC0_Type) SetSR_DACBFRPTF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DAC0_Type) GetSR_DACBFRPTF() uint8 {
	return (volatile.LoadUint8(&o.SR.Reg) & 0x2) >> 1
}
func (o *DAC0_Type) SetSR_DACBFWMF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DAC0_Type) GetSR_DACBFWMF() uint8 {
	return (volatile.LoadUint8(&o.SR.Reg) & 0x4) >> 2
}

// DAC0.C0: DAC Control Register
func (o *DAC0_Type) SetC0_DACBBIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC0_DACBBIEN() uint8 {
	return volatile.LoadUint8(&o.C0.Reg) & 0x1
}
func (o *DAC0_Type) SetC0_DACBTIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x2)|value<<1)
}
func (o *DAC0_Type) GetC0_DACBTIEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x2) >> 1
}
func (o *DAC0_Type) SetC0_DACBWIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x4)|value<<2)
}
func (o *DAC0_Type) GetC0_DACBWIEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x4) >> 2
}
func (o *DAC0_Type) SetC0_LPEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x8)|value<<3)
}
func (o *DAC0_Type) GetC0_LPEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x8) >> 3
}
func (o *DAC0_Type) SetC0_DACSWTRG(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x10)|value<<4)
}
func (o *DAC0_Type) GetC0_DACSWTRG() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x10) >> 4
}
func (o *DAC0_Type) SetC0_DACTRGSEL(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x20)|value<<5)
}
func (o *DAC0_Type) GetC0_DACTRGSEL() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x20) >> 5
}
func (o *DAC0_Type) SetC0_DACRFS(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x40)|value<<6)
}
func (o *DAC0_Type) GetC0_DACRFS() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x40) >> 6
}
func (o *DAC0_Type) SetC0_DACEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x80)|value<<7)
}
func (o *DAC0_Type) GetC0_DACEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x80) >> 7
}

// DAC0.C1: DAC Control Register 1
func (o *DAC0_Type) SetC1_DACBFEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC1_DACBFEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *DAC0_Type) SetC1_DACBFMD(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *DAC0_Type) GetC1_DACBFMD() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *DAC0_Type) SetC1_DACBFWM(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x18)|value<<3)
}
func (o *DAC0_Type) GetC1_DACBFWM() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x18) >> 3
}
func (o *DAC0_Type) SetC1_DMAEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *DAC0_Type) GetC1_DMAEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// DAC0.C2: DAC Control Register 2
func (o *DAC0_Type) SetC2_DACBFUP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC2_DACBFUP() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *DAC0_Type) SetC2_DACBFRP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *DAC0_Type) GetC2_DACBFRP() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}

// Low Power Timer
type LPTMR0_Type struct {
	CSR volatile.Register32 // 0x0
	PSR volatile.Register32 // 0x4
	CMR volatile.Register32 // 0x8
	CNR volatile.Register32 // 0xC
}

// LPTMR0.CSR: Low Power Timer Control Status Register
func (o *LPTMR0_Type) SetCSR_TEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *LPTMR0_Type) GetCSR_TEN() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *LPTMR0_Type) SetCSR_TMS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *LPTMR0_Type) GetCSR_TMS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *LPTMR0_Type) SetCSR_TFC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetCSR_TFC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetCSR_TPP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *LPTMR0_Type) GetCSR_TPP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *LPTMR0_Type) SetCSR_TPS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x30)|value<<4)
}
func (o *LPTMR0_Type) GetCSR_TPS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x30) >> 4
}
func (o *LPTMR0_Type) SetCSR_TIE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *LPTMR0_Type) GetCSR_TIE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *LPTMR0_Type) SetCSR_TCF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *LPTMR0_Type) GetCSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}

// LPTMR0.PSR: Low Power Timer Prescale Register
func (o *LPTMR0_Type) SetPSR_PCS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x3)|value)
}
func (o *LPTMR0_Type) GetPSR_PCS() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x3
}
func (o *LPTMR0_Type) SetPSR_PBYP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetPSR_PBYP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetPSR_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x78)|value<<3)
}
func (o *LPTMR0_Type) GetPSR_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x78) >> 3
}

// LPTMR0.CMR: Low Power Timer Compare Register
func (o *LPTMR0_Type) SetCMR_COMPARE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCMR_COMPARE() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xffff
}

// LPTMR0.CNR: Low Power Timer Counter Register
func (o *LPTMR0_Type) SetCNR_COUNTER(value uint32) {
	volatile.StoreUint32(&o.CNR.Reg, volatile.LoadUint32(&o.CNR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCNR_COUNTER() uint32 {
	return volatile.LoadUint32(&o.CNR.Reg) & 0xffff
}

// System register file
type RFSYS_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	REG5 volatile.Register32 // 0x14
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// RFSYS.REG0: Register file register
func (o *RFSYS_Type) SetREG0_LL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG0_LL() uint32 {
	return volatile.LoadUint32(&o.REG0.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG0_LH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG0_LH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG0_HL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG0_HL() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG0_HH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG0_HH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xff000000) >> 24
}

// RFSYS.REG1: Register file register
func (o *RFSYS_Type) SetREG1_LL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG1_LL() uint32 {
	return volatile.LoadUint32(&o.REG1.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG1_LH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG1_LH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG1_HL(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG1_HL() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG1_HH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG1_HH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0xff000000) >> 24
}

// RFSYS.REG2: Register file register
func (o *RFSYS_Type) SetREG2_LL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG2_LL() uint32 {
	return volatile.LoadUint32(&o.REG2.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG2_LH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG2_LH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG2_HL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG2_HL() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG2_HH(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG2_HH() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0xff000000) >> 24
}

// RFSYS.REG3: Register file register
func (o *RFSYS_Type) SetREG3_LL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG3_LL() uint32 {
	return volatile.LoadUint32(&o.REG3.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG3_LH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG3_LH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG3_HL(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG3_HL() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG3_HH(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG3_HH() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xff000000) >> 24
}

// RFSYS.REG4: Register file register
func (o *RFSYS_Type) SetREG4_LL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG4_LL() uint32 {
	return volatile.LoadUint32(&o.REG4.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG4_LH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG4_LH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG4_HL(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG4_HL() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG4_HH(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG4_HH() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xff000000) >> 24
}

// RFSYS.REG5: Register file register
func (o *RFSYS_Type) SetREG5_LL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG5_LL() uint32 {
	return volatile.LoadUint32(&o.REG5.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG5_LH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG5_LH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG5_HL(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG5_HL() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG5_HH(value uint32) {
	volatile.StoreUint32(&o.REG5.Reg, volatile.LoadUint32(&o.REG5.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG5_HH() uint32 {
	return (volatile.LoadUint32(&o.REG5.Reg) & 0xff000000) >> 24
}

// RFSYS.REG6: Register file register
func (o *RFSYS_Type) SetREG6_LL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG6_LL() uint32 {
	return volatile.LoadUint32(&o.REG6.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG6_LH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG6_LH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG6_HL(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG6_HL() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG6_HH(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG6_HH() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0xff000000) >> 24
}

// RFSYS.REG7: Register file register
func (o *RFSYS_Type) SetREG7_LL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff)|value)
}
func (o *RFSYS_Type) GetREG7_LL() uint32 {
	return volatile.LoadUint32(&o.REG7.Reg) & 0xff
}
func (o *RFSYS_Type) SetREG7_LH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff00)|value<<8)
}
func (o *RFSYS_Type) GetREG7_LH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff00) >> 8
}
func (o *RFSYS_Type) SetREG7_HL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff0000)|value<<16)
}
func (o *RFSYS_Type) GetREG7_HL() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff0000) >> 16
}
func (o *RFSYS_Type) SetREG7_HH(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0xff000000)|value<<24)
}
func (o *RFSYS_Type) GetREG7_HH() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0xff000000) >> 24
}

// Touch sense input
type TSI0_Type struct {
	GENCS volatile.Register32 // 0x0
	DATA  volatile.Register32 // 0x4
	TSHD  volatile.Register32 // 0x8
}

// TSI0.GENCS: TSI General Control and Status Register
func (o *TSI0_Type) SetGENCS_CURSW(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x2)|value<<1)
}
func (o *TSI0_Type) GetGENCS_CURSW() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x2) >> 1
}
func (o *TSI0_Type) SetGENCS_EOSF(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x4)|value<<2)
}
func (o *TSI0_Type) GetGENCS_EOSF() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x4) >> 2
}
func (o *TSI0_Type) SetGENCS_SCNIP(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x8)|value<<3)
}
func (o *TSI0_Type) GetGENCS_SCNIP() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x8) >> 3
}
func (o *TSI0_Type) SetGENCS_STM(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x10)|value<<4)
}
func (o *TSI0_Type) GetGENCS_STM() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x10) >> 4
}
func (o *TSI0_Type) SetGENCS_STPE(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x20)|value<<5)
}
func (o *TSI0_Type) GetGENCS_STPE() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x20) >> 5
}
func (o *TSI0_Type) SetGENCS_TSIIEN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x40)|value<<6)
}
func (o *TSI0_Type) GetGENCS_TSIIEN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x40) >> 6
}
func (o *TSI0_Type) SetGENCS_TSIEN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x80)|value<<7)
}
func (o *TSI0_Type) GetGENCS_TSIEN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x80) >> 7
}
func (o *TSI0_Type) SetGENCS_NSCN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x1f00)|value<<8)
}
func (o *TSI0_Type) GetGENCS_NSCN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x1f00) >> 8
}
func (o *TSI0_Type) SetGENCS_PS(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xe000)|value<<13)
}
func (o *TSI0_Type) GetGENCS_PS() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xe000) >> 13
}
func (o *TSI0_Type) SetGENCS_EXTCHRG(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x70000)|value<<16)
}
func (o *TSI0_Type) GetGENCS_EXTCHRG() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x70000) >> 16
}
func (o *TSI0_Type) SetGENCS_DVOLT(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x180000)|value<<19)
}
func (o *TSI0_Type) GetGENCS_DVOLT() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x180000) >> 19
}
func (o *TSI0_Type) SetGENCS_REFCHRG(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xe00000)|value<<21)
}
func (o *TSI0_Type) GetGENCS_REFCHRG() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xe00000) >> 21
}
func (o *TSI0_Type) SetGENCS_MODE(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xf000000)|value<<24)
}
func (o *TSI0_Type) GetGENCS_MODE() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xf000000) >> 24
}
func (o *TSI0_Type) SetGENCS_ESOR(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x10000000)|value<<28)
}
func (o *TSI0_Type) GetGENCS_ESOR() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x10000000) >> 28
}
func (o *TSI0_Type) SetGENCS_OUTRGF(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x80000000)|value<<31)
}
func (o *TSI0_Type) GetGENCS_OUTRGF() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x80000000) >> 31
}

// TSI0.DATA: TSI DATA Register
func (o *TSI0_Type) SetDATA_TSICNT(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xffff)|value)
}
func (o *TSI0_Type) GetDATA_TSICNT() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xffff
}
func (o *TSI0_Type) SetDATA_SWTS(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x400000)|value<<22)
}
func (o *TSI0_Type) GetDATA_SWTS() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x400000) >> 22
}
func (o *TSI0_Type) SetDATA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x800000)|value<<23)
}
func (o *TSI0_Type) GetDATA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x800000) >> 23
}
func (o *TSI0_Type) SetDATA_TSICH(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSI0_Type) GetDATA_TSICH() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xf0000000) >> 28
}

// TSI0.TSHD: TSI Threshold Register
func (o *TSI0_Type) SetTSHD_THRESL(value uint32) {
	volatile.StoreUint32(&o.TSHD.Reg, volatile.LoadUint32(&o.TSHD.Reg)&^(0xffff)|value)
}
func (o *TSI0_Type) GetTSHD_THRESL() uint32 {
	return volatile.LoadUint32(&o.TSHD.Reg) & 0xffff
}
func (o *TSI0_Type) SetTSHD_THRESH(value uint32) {
	volatile.StoreUint32(&o.TSHD.Reg, volatile.LoadUint32(&o.TSHD.Reg)&^(0xffff0000)|value<<16)
}
func (o *TSI0_Type) GetTSHD_THRESH() uint32 {
	return (volatile.LoadUint32(&o.TSHD.Reg) & 0xffff0000) >> 16
}

// System Integration Module
type SIM_Type struct {
	SOPT1   volatile.Register32 // 0x0
	_       [4096]byte
	SOPT2   volatile.Register32 // 0x1004
	_       [4]byte
	SOPT4   volatile.Register32 // 0x100C
	SOPT5   volatile.Register32 // 0x1010
	_       [4]byte
	SOPT7   volatile.Register32 // 0x1018
	_       [8]byte
	SDID    volatile.Register32 // 0x1024
	_       [12]byte
	SCGC4   volatile.Register32 // 0x1034
	SCGC5   volatile.Register32 // 0x1038
	SCGC6   volatile.Register32 // 0x103C
	SCGC7   volatile.Register32 // 0x1040
	CLKDIV1 volatile.Register32 // 0x1044
	_       [4]byte
	FCFG1   volatile.Register32 // 0x104C
	FCFG2   volatile.Register32 // 0x1050
	_       [4]byte
	UIDMH   volatile.Register32 // 0x1058
	UIDML   volatile.Register32 // 0x105C
	UIDL    volatile.Register32 // 0x1060
	_       [156]byte
	COPC    volatile.Register32 // 0x1100
	SRVCOP  volatile.Register32 // 0x1104
}

// SIM.SOPT1: System Options Register 1
func (o *SIM_Type) SetSOPT1_OSC32KOUT(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x30000)|value<<16)
}
func (o *SIM_Type) GetSOPT1_OSC32KOUT() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x30000) >> 16
}
func (o *SIM_Type) SetSOPT1_OSC32KSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT1_OSC32KSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0xc0000) >> 18
}

// SIM.SOPT2: System Options Register 2
func (o *SIM_Type) SetSOPT2_CLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xe0)|value<<5)
}
func (o *SIM_Type) GetSOPT2_CLKOUTSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xe0) >> 5
}
func (o *SIM_Type) SetSOPT2_TPMSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x3000000)|value<<24)
}
func (o *SIM_Type) GetSOPT2_TPMSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x3000000) >> 24
}
func (o *SIM_Type) SetSOPT2_LPUART0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xc000000)|value<<26)
}
func (o *SIM_Type) GetSOPT2_LPUART0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xc000000) >> 26
}

// SIM.SOPT4: System Options Register 4
func (o *SIM_Type) SetSOPT4_TPM1CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSOPT4_TPM1CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSOPT4_TPM2CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSOPT4_TPM2CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x100000) >> 20
}
func (o *SIM_Type) SetSOPT4_TPM0CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT4_TPM0CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT4_TPM1CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT4_TPM1CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT4_TPM2CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT4_TPM2CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x4000000) >> 26
}

// SIM.SOPT5: System Options Register 5
func (o *SIM_Type) SetSOPT5_LPUART0TXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x3)|value)
}
func (o *SIM_Type) GetSOPT5_LPUART0TXSRC() uint32 {
	return volatile.LoadUint32(&o.SOPT5.Reg) & 0x3
}
func (o *SIM_Type) SetSOPT5_LPUART0RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x4)|value<<2)
}
func (o *SIM_Type) GetSOPT5_LPUART0RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x4) >> 2
}
func (o *SIM_Type) SetSOPT5_LPUART0ODE(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x10000)|value<<16)
}
func (o *SIM_Type) GetSOPT5_LPUART0ODE() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x10000) >> 16
}

// SIM.SOPT7: System Options Register 7
func (o *SIM_Type) SetSOPT7_ADC0TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSOPT7_ADC0TRGSEL() uint32 {
	return volatile.LoadUint32(&o.SOPT7.Reg) & 0xf
}
func (o *SIM_Type) SetSOPT7_ADC0PRETRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT7_ADC0PRETRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT7_ADC0ALTTRGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSOPT7_ADC0ALTTRGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x80) >> 7
}

// SIM.SDID: System Device Identification Register
func (o *SIM_Type) SetSDID_PINID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSDID_PINID() uint32 {
	return volatile.LoadUint32(&o.SDID.Reg) & 0xf
}
func (o *SIM_Type) SetSDID_DIEID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf80)|value<<7)
}
func (o *SIM_Type) GetSDID_DIEID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf80) >> 7
}
func (o *SIM_Type) SetSDID_REVID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf000)|value<<12)
}
func (o *SIM_Type) GetSDID_REVID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf000) >> 12
}
func (o *SIM_Type) SetSDID_SRAMSIZE(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf0000)|value<<16)
}
func (o *SIM_Type) GetSDID_SRAMSIZE() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf0000) >> 16
}
func (o *SIM_Type) SetSDID_SERIESID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf00000)|value<<20)
}
func (o *SIM_Type) GetSDID_SERIESID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf00000) >> 20
}
func (o *SIM_Type) SetSDID_SUBFAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0x3000000)|value<<24)
}
func (o *SIM_Type) GetSDID_SUBFAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0x3000000) >> 24
}
func (o *SIM_Type) SetSDID_FAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetSDID_FAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf0000000) >> 28
}

// SIM.SCGC4: System Clock Gating Control Register 4
func (o *SIM_Type) SetSCGC4_CMT(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x4)|value<<2)
}
func (o *SIM_Type) GetSCGC4_CMT() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x4) >> 2
}
func (o *SIM_Type) SetSCGC4_I2C0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x40)|value<<6)
}
func (o *SIM_Type) GetSCGC4_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x40) >> 6
}
func (o *SIM_Type) SetSCGC4_I2C1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSCGC4_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80) >> 7
}
func (o *SIM_Type) SetSCGC4_CMP(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80000)|value<<19)
}
func (o *SIM_Type) GetSCGC4_CMP() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80000) >> 19
}
func (o *SIM_Type) SetSCGC4_VREF(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSCGC4_VREF() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x100000) >> 20
}

// SIM.SCGC5: System Clock Gating Control Register 5
func (o *SIM_Type) SetSCGC5_LPTMR(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC5_LPTMR() uint32 {
	return volatile.LoadUint32(&o.SCGC5.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC5_TSI(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x20)|value<<5)
}
func (o *SIM_Type) GetSCGC5_TSI() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x20) >> 5
}
func (o *SIM_Type) SetSCGC5_PORTA(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x200)|value<<9)
}
func (o *SIM_Type) GetSCGC5_PORTA() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x200) >> 9
}
func (o *SIM_Type) SetSCGC5_PORTB(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC5_PORTB() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC5_PORTC(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x800)|value<<11)
}
func (o *SIM_Type) GetSCGC5_PORTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x800) >> 11
}
func (o *SIM_Type) SetSCGC5_LPUART0(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSCGC5_LPUART0() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x100000) >> 20
}
func (o *SIM_Type) SetSCGC5_LTC(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSCGC5_LTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSCGC5_RSIM(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSCGC5_RSIM() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSCGC5_DCDC(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSCGC5_DCDC() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSCGC5_BTLL(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSCGC5_BTLL() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSCGC5_PHYDIG(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x10000000)|value<<28)
}
func (o *SIM_Type) GetSCGC5_PHYDIG() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x10000000) >> 28
}
func (o *SIM_Type) SetSCGC5_ZigBee(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSCGC5_ZigBee() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSCGC5_ANT(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x40000000)|value<<30)
}
func (o *SIM_Type) GetSCGC5_ANT() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x40000000) >> 30
}
func (o *SIM_Type) SetSCGC5_GEN_FSK(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSCGC5_GEN_FSK() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x80000000) >> 31
}

// SIM.SCGC6: System Clock Gating Control Register 6
func (o *SIM_Type) SetSCGC6_FTF(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC6_FTF() uint32 {
	return volatile.LoadUint32(&o.SCGC6.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC6_DMAMUX(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSCGC6_DMAMUX() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSCGC6_TRNG(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x200)|value<<9)
}
func (o *SIM_Type) GetSCGC6_TRNG() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x200) >> 9
}
func (o *SIM_Type) SetSCGC6_SPI0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC6_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC6_SPI1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2000)|value<<13)
}
func (o *SIM_Type) GetSCGC6_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2000) >> 13
}
func (o *SIM_Type) SetSCGC6_PIT(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x800000)|value<<23)
}
func (o *SIM_Type) GetSCGC6_PIT() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x800000) >> 23
}
func (o *SIM_Type) SetSCGC6_TPM0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSCGC6_TPM0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSCGC6_TPM1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSCGC6_TPM1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSCGC6_TPM2(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSCGC6_TPM2() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSCGC6_ADC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSCGC6_ADC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSCGC6_RTC(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSCGC6_RTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSCGC6_DAC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSCGC6_DAC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x80000000) >> 31
}

// SIM.SCGC7: System Clock Gating Control Register 7
func (o *SIM_Type) SetSCGC7_DMA(value uint32) {
	volatile.StoreUint32(&o.SCGC7.Reg, volatile.LoadUint32(&o.SCGC7.Reg)&^(0x100)|value<<8)
}
func (o *SIM_Type) GetSCGC7_DMA() uint32 {
	return (volatile.LoadUint32(&o.SCGC7.Reg) & 0x100) >> 8
}

// SIM.CLKDIV1: System Clock Divider Register 1
func (o *SIM_Type) SetCLKDIV1_OUTDIV4(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0x70000)|value<<16)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV4() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0x70000) >> 16
}
func (o *SIM_Type) SetCLKDIV1_OUTDIV1(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV1() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf0000000) >> 28
}

// SIM.FCFG1: Flash Configuration Register 1
func (o *SIM_Type) SetFCFG1_FLASHDIS(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetFCFG1_FLASHDIS() uint32 {
	return volatile.LoadUint32(&o.FCFG1.Reg) & 0x1
}
func (o *SIM_Type) SetFCFG1_FLASHDOZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetFCFG1_FLASHDOZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetFCFG1_PFSIZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetFCFG1_PFSIZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0xf000000) >> 24
}

// SIM.FCFG2: Flash Configuration Register 2
func (o *SIM_Type) SetFCFG2_MAXADDR1(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f0000)|value<<16)
}
func (o *SIM_Type) GetFCFG2_MAXADDR1() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f0000) >> 16
}
func (o *SIM_Type) SetFCFG2_MAXADDR0(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f000000)|value<<24)
}
func (o *SIM_Type) GetFCFG2_MAXADDR0() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f000000) >> 24
}

// SIM.UIDMH: Unique Identification Register Mid-High
func (o *SIM_Type) SetUIDMH_UID(value uint32) {
	volatile.StoreUint32(&o.UIDMH.Reg, volatile.LoadUint32(&o.UIDMH.Reg)&^(0xffff)|value)
}
func (o *SIM_Type) GetUIDMH_UID() uint32 {
	return volatile.LoadUint32(&o.UIDMH.Reg) & 0xffff
}

// SIM.UIDML: Unique Identification Register Mid Low
func (o *SIM_Type) SetUIDML(value uint32) {
	volatile.StoreUint32(&o.UIDML.Reg, value)
}
func (o *SIM_Type) GetUIDML() uint32 {
	return volatile.LoadUint32(&o.UIDML.Reg)
}

// SIM.UIDL: Unique Identification Register Low
func (o *SIM_Type) SetUIDL(value uint32) {
	volatile.StoreUint32(&o.UIDL.Reg, value)
}
func (o *SIM_Type) GetUIDL() uint32 {
	return volatile.LoadUint32(&o.UIDL.Reg)
}

// SIM.COPC: COP Control Register
func (o *SIM_Type) SetCOPC_COPW(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetCOPC_COPW() uint32 {
	return volatile.LoadUint32(&o.COPC.Reg) & 0x1
}
func (o *SIM_Type) SetCOPC_COPCLKS(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetCOPC_COPCLKS() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetCOPC_COPT(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0xc)|value<<2)
}
func (o *SIM_Type) GetCOPC_COPT() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0xc) >> 2
}
func (o *SIM_Type) SetCOPC_COPSTPEN(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetCOPC_COPSTPEN() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetCOPC_COPDBGEN(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x20)|value<<5)
}
func (o *SIM_Type) GetCOPC_COPDBGEN() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0x20) >> 5
}
func (o *SIM_Type) SetCOPC_COPCLKSEL(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0xc0)|value<<6)
}
func (o *SIM_Type) GetCOPC_COPCLKSEL() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0xc0) >> 6
}

// SIM.SRVCOP: Service COP
func (o *SIM_Type) SetSRVCOP(value uint32) {
	volatile.StoreUint32(&o.SRVCOP.Reg, volatile.LoadUint32(&o.SRVCOP.Reg)&^(0xff)|value)
}
func (o *SIM_Type) GetSRVCOP() uint32 {
	return volatile.LoadUint32(&o.SRVCOP.Reg) & 0xff
}

// Pin Control and Interrupts
type PORT_Type struct {
	PCR0  volatile.Register32 // 0x0
	PCR1  volatile.Register32 // 0x4
	PCR2  volatile.Register32 // 0x8
	PCR3  volatile.Register32 // 0xC
	PCR4  volatile.Register32 // 0x10
	PCR5  volatile.Register32 // 0x14
	PCR6  volatile.Register32 // 0x18
	PCR7  volatile.Register32 // 0x1C
	PCR8  volatile.Register32 // 0x20
	PCR9  volatile.Register32 // 0x24
	PCR10 volatile.Register32 // 0x28
	PCR11 volatile.Register32 // 0x2C
	PCR12 volatile.Register32 // 0x30
	PCR13 volatile.Register32 // 0x34
	PCR14 volatile.Register32 // 0x38
	PCR15 volatile.Register32 // 0x3C
	PCR16 volatile.Register32 // 0x40
	PCR17 volatile.Register32 // 0x44
	PCR18 volatile.Register32 // 0x48
	PCR19 volatile.Register32 // 0x4C
	PCR20 volatile.Register32 // 0x50
	PCR21 volatile.Register32 // 0x54
	PCR22 volatile.Register32 // 0x58
	PCR23 volatile.Register32 // 0x5C
	PCR24 volatile.Register32 // 0x60
	PCR25 volatile.Register32 // 0x64
	PCR26 volatile.Register32 // 0x68
	PCR27 volatile.Register32 // 0x6C
	PCR28 volatile.Register32 // 0x70
	PCR29 volatile.Register32 // 0x74
	PCR30 volatile.Register32 // 0x78
	PCR31 volatile.Register32 // 0x7C
	GPCLR volatile.Register32 // 0x80
	GPCHR volatile.Register32 // 0x84
	_     [24]byte
	ISFR  volatile.Register32 // 0xA0
}

// PORT.PCR0: Pin Control Register n
func (o *PORT_Type) SetPCR0_PS(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR0_PS() uint32 {
	return volatile.LoadUint32(&o.PCR0.Reg) & 0x1
}
func (o *PORT_Type) SetPCR0_PE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR0_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR0_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR0_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR0_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR0_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR0_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR0_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR0_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR0_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR0_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR0_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR0_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR0_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x1000000) >> 24
}

// PORT.PCR1: Pin Control Register n
func (o *PORT_Type) SetPCR1_PS(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR1_PS() uint32 {
	return volatile.LoadUint32(&o.PCR1.Reg) & 0x1
}
func (o *PORT_Type) SetPCR1_PE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR1_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR1_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR1_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR1_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR1_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR1_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR1_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR1_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR1_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR1_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR1_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR1_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR1_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x1000000) >> 24
}

// PORT.PCR2: Pin Control Register n
func (o *PORT_Type) SetPCR2_PS(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR2_PS() uint32 {
	return volatile.LoadUint32(&o.PCR2.Reg) & 0x1
}
func (o *PORT_Type) SetPCR2_PE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR2_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR2_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR2_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR2_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR2_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR2_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR2_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR2_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR2_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR2_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR2_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR2_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR2_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x1000000) >> 24
}

// PORT.PCR3: Pin Control Register n
func (o *PORT_Type) SetPCR3_PS(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR3_PS() uint32 {
	return volatile.LoadUint32(&o.PCR3.Reg) & 0x1
}
func (o *PORT_Type) SetPCR3_PE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR3_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR3_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR3_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR3_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR3_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR3_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR3_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR3_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR3_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR3_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR3_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR3_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR3_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x1000000) >> 24
}

// PORT.PCR4: Pin Control Register n
func (o *PORT_Type) SetPCR4_PS(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR4_PS() uint32 {
	return volatile.LoadUint32(&o.PCR4.Reg) & 0x1
}
func (o *PORT_Type) SetPCR4_PE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR4_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR4_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR4_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR4_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR4_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR4_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR4_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR4_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR4_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR4_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR4_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR4_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR4_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x1000000) >> 24
}

// PORT.PCR5: Pin Control Register n
func (o *PORT_Type) SetPCR5_PS(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR5_PS() uint32 {
	return volatile.LoadUint32(&o.PCR5.Reg) & 0x1
}
func (o *PORT_Type) SetPCR5_PE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR5_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR5_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR5_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR5_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR5_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR5_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR5_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR5_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR5_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR5_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR5_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR5_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR5_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x1000000) >> 24
}

// PORT.PCR6: Pin Control Register n
func (o *PORT_Type) SetPCR6_PS(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR6_PS() uint32 {
	return volatile.LoadUint32(&o.PCR6.Reg) & 0x1
}
func (o *PORT_Type) SetPCR6_PE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR6_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR6_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR6_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR6_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR6_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR6_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR6_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR6_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR6_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR6_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR6_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR6_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR6_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x1000000) >> 24
}

// PORT.PCR7: Pin Control Register n
func (o *PORT_Type) SetPCR7_PS(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR7_PS() uint32 {
	return volatile.LoadUint32(&o.PCR7.Reg) & 0x1
}
func (o *PORT_Type) SetPCR7_PE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR7_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR7_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR7_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR7_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR7_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR7_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR7_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR7_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR7_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR7_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR7_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR7_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR7_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x1000000) >> 24
}

// PORT.PCR8: Pin Control Register n
func (o *PORT_Type) SetPCR8_PS(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR8_PS() uint32 {
	return volatile.LoadUint32(&o.PCR8.Reg) & 0x1
}
func (o *PORT_Type) SetPCR8_PE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR8_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR8_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR8_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR8_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR8_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR8_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR8_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR8_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR8_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR8_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR8_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR8_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR8_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x1000000) >> 24
}

// PORT.PCR9: Pin Control Register n
func (o *PORT_Type) SetPCR9_PS(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR9_PS() uint32 {
	return volatile.LoadUint32(&o.PCR9.Reg) & 0x1
}
func (o *PORT_Type) SetPCR9_PE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR9_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR9_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR9_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR9_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR9_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR9_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR9_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR9_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR9_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR9_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR9_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR9_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR9_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x1000000) >> 24
}

// PORT.PCR10: Pin Control Register n
func (o *PORT_Type) SetPCR10_PS(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR10_PS() uint32 {
	return volatile.LoadUint32(&o.PCR10.Reg) & 0x1
}
func (o *PORT_Type) SetPCR10_PE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR10_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR10_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR10_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR10_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR10_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR10_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR10_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR10_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR10_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR10_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR10_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR10_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR10_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x1000000) >> 24
}

// PORT.PCR11: Pin Control Register n
func (o *PORT_Type) SetPCR11_PS(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR11_PS() uint32 {
	return volatile.LoadUint32(&o.PCR11.Reg) & 0x1
}
func (o *PORT_Type) SetPCR11_PE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR11_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR11_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR11_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR11_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR11_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR11_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR11_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR11_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR11_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR11_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR11_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR11_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR11_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x1000000) >> 24
}

// PORT.PCR12: Pin Control Register n
func (o *PORT_Type) SetPCR12_PS(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR12_PS() uint32 {
	return volatile.LoadUint32(&o.PCR12.Reg) & 0x1
}
func (o *PORT_Type) SetPCR12_PE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR12_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR12_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR12_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR12_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR12_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR12_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR12_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR12_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR12_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR12_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR12_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR12_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR12_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x1000000) >> 24
}

// PORT.PCR13: Pin Control Register n
func (o *PORT_Type) SetPCR13_PS(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR13_PS() uint32 {
	return volatile.LoadUint32(&o.PCR13.Reg) & 0x1
}
func (o *PORT_Type) SetPCR13_PE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR13_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR13_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR13_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR13_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR13_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR13_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR13_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR13_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR13_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR13_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR13_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR13_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR13_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x1000000) >> 24
}

// PORT.PCR14: Pin Control Register n
func (o *PORT_Type) SetPCR14_PS(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR14_PS() uint32 {
	return volatile.LoadUint32(&o.PCR14.Reg) & 0x1
}
func (o *PORT_Type) SetPCR14_PE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR14_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR14_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR14_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR14_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR14_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR14_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR14_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR14_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR14_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR14_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR14_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR14_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR14_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x1000000) >> 24
}

// PORT.PCR15: Pin Control Register n
func (o *PORT_Type) SetPCR15_PS(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR15_PS() uint32 {
	return volatile.LoadUint32(&o.PCR15.Reg) & 0x1
}
func (o *PORT_Type) SetPCR15_PE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR15_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR15_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR15_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR15_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR15_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR15_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR15_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR15_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR15_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR15_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR15_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR15_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR15_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x1000000) >> 24
}

// PORT.PCR16: Pin Control Register n
func (o *PORT_Type) SetPCR16_PS(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR16_PS() uint32 {
	return volatile.LoadUint32(&o.PCR16.Reg) & 0x1
}
func (o *PORT_Type) SetPCR16_PE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR16_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR16_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR16_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR16_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR16_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR16_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR16_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR16_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR16_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR16_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR16_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR16_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR16_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x1000000) >> 24
}

// PORT.PCR17: Pin Control Register n
func (o *PORT_Type) SetPCR17_PS(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR17_PS() uint32 {
	return volatile.LoadUint32(&o.PCR17.Reg) & 0x1
}
func (o *PORT_Type) SetPCR17_PE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR17_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR17_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR17_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR17_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR17_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR17_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR17_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR17_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR17_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR17_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR17_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR17_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR17_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x1000000) >> 24
}

// PORT.PCR18: Pin Control Register n
func (o *PORT_Type) SetPCR18_PS(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR18_PS() uint32 {
	return volatile.LoadUint32(&o.PCR18.Reg) & 0x1
}
func (o *PORT_Type) SetPCR18_PE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR18_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR18_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR18_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR18_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR18_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR18_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR18_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR18_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR18_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR18_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR18_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR18_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR18_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x1000000) >> 24
}

// PORT.PCR19: Pin Control Register n
func (o *PORT_Type) SetPCR19_PS(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR19_PS() uint32 {
	return volatile.LoadUint32(&o.PCR19.Reg) & 0x1
}
func (o *PORT_Type) SetPCR19_PE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR19_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR19_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR19_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR19_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR19_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR19_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR19_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR19_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR19_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR19_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR19_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR19_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR19_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x1000000) >> 24
}

// PORT.PCR20: Pin Control Register n
func (o *PORT_Type) SetPCR20_PS(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR20_PS() uint32 {
	return volatile.LoadUint32(&o.PCR20.Reg) & 0x1
}
func (o *PORT_Type) SetPCR20_PE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR20_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR20_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR20_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR20_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR20_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR20_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR20_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR20_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR20_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR20_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR20_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR20_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR20_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x1000000) >> 24
}

// PORT.PCR21: Pin Control Register n
func (o *PORT_Type) SetPCR21_PS(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR21_PS() uint32 {
	return volatile.LoadUint32(&o.PCR21.Reg) & 0x1
}
func (o *PORT_Type) SetPCR21_PE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR21_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR21_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR21_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR21_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR21_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR21_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR21_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR21_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR21_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR21_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR21_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR21_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR21_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x1000000) >> 24
}

// PORT.PCR22: Pin Control Register n
func (o *PORT_Type) SetPCR22_PS(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR22_PS() uint32 {
	return volatile.LoadUint32(&o.PCR22.Reg) & 0x1
}
func (o *PORT_Type) SetPCR22_PE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR22_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR22_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR22_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR22_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR22_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR22_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR22_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR22_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR22_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR22_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR22_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR22_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR22_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x1000000) >> 24
}

// PORT.PCR23: Pin Control Register n
func (o *PORT_Type) SetPCR23_PS(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR23_PS() uint32 {
	return volatile.LoadUint32(&o.PCR23.Reg) & 0x1
}
func (o *PORT_Type) SetPCR23_PE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR23_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR23_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR23_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR23_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR23_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR23_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR23_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR23_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR23_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR23_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR23_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR23_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR23_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x1000000) >> 24
}

// PORT.PCR24: Pin Control Register n
func (o *PORT_Type) SetPCR24_PS(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR24_PS() uint32 {
	return volatile.LoadUint32(&o.PCR24.Reg) & 0x1
}
func (o *PORT_Type) SetPCR24_PE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR24_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR24_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR24_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR24_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR24_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR24_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR24_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR24_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR24_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR24_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR24_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR24_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR24_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x1000000) >> 24
}

// PORT.PCR25: Pin Control Register n
func (o *PORT_Type) SetPCR25_PS(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR25_PS() uint32 {
	return volatile.LoadUint32(&o.PCR25.Reg) & 0x1
}
func (o *PORT_Type) SetPCR25_PE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR25_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR25_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR25_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR25_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR25_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR25_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR25_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR25_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR25_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR25_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR25_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR25_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR25_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x1000000) >> 24
}

// PORT.PCR26: Pin Control Register n
func (o *PORT_Type) SetPCR26_PS(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR26_PS() uint32 {
	return volatile.LoadUint32(&o.PCR26.Reg) & 0x1
}
func (o *PORT_Type) SetPCR26_PE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR26_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR26_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR26_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR26_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR26_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR26_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR26_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR26_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR26_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR26_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR26_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR26_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR26_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x1000000) >> 24
}

// PORT.PCR27: Pin Control Register n
func (o *PORT_Type) SetPCR27_PS(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR27_PS() uint32 {
	return volatile.LoadUint32(&o.PCR27.Reg) & 0x1
}
func (o *PORT_Type) SetPCR27_PE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR27_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR27_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR27_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR27_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR27_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR27_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR27_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR27_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR27_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR27_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR27_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR27_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR27_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x1000000) >> 24
}

// PORT.PCR28: Pin Control Register n
func (o *PORT_Type) SetPCR28_PS(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR28_PS() uint32 {
	return volatile.LoadUint32(&o.PCR28.Reg) & 0x1
}
func (o *PORT_Type) SetPCR28_PE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR28_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR28_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR28_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR28_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR28_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR28_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR28_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR28_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR28_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR28_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR28_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR28_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR28_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x1000000) >> 24
}

// PORT.PCR29: Pin Control Register n
func (o *PORT_Type) SetPCR29_PS(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR29_PS() uint32 {
	return volatile.LoadUint32(&o.PCR29.Reg) & 0x1
}
func (o *PORT_Type) SetPCR29_PE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR29_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR29_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR29_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR29_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR29_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR29_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR29_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR29_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR29_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR29_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR29_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR29_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR29_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x1000000) >> 24
}

// PORT.PCR30: Pin Control Register n
func (o *PORT_Type) SetPCR30_PS(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR30_PS() uint32 {
	return volatile.LoadUint32(&o.PCR30.Reg) & 0x1
}
func (o *PORT_Type) SetPCR30_PE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR30_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR30_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR30_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR30_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR30_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR30_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR30_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR30_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR30_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR30_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR30_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR30_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR30_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x1000000) >> 24
}

// PORT.PCR31: Pin Control Register n
func (o *PORT_Type) SetPCR31_PS(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR31_PS() uint32 {
	return volatile.LoadUint32(&o.PCR31.Reg) & 0x1
}
func (o *PORT_Type) SetPCR31_PE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR31_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR31_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR31_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR31_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR31_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR31_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR31_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR31_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR31_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR31_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR31_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR31_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR31_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x1000000) >> 24
}

// PORT.GPCLR: Global Pin Control Low Register
func (o *PORT_Type) SetGPCLR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCLR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCLR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCLR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff0000) >> 16
}

// PORT.GPCHR: Global Pin Control High Register
func (o *PORT_Type) SetGPCHR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCHR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCHR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCHR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff0000) >> 16
}

// PORT.ISFR: Interrupt Status Flag Register
func (o *PORT_Type) SetISFR(value uint32) {
	volatile.StoreUint32(&o.ISFR.Reg, value)
}
func (o *PORT_Type) GetISFR() uint32 {
	return volatile.LoadUint32(&o.ISFR.Reg)
}

// Universal Asynchronous Receiver/Transmitter
type LPUART0_Type struct {
	BAUD  volatile.Register32 // 0x0
	STAT  volatile.Register32 // 0x4
	CTRL  volatile.Register32 // 0x8
	DATA  volatile.Register32 // 0xC
	MATCH volatile.Register32 // 0x10
	MODIR volatile.Register32 // 0x14
}

// LPUART0.BAUD: LPUART Baud Rate Register
func (o *LPUART0_Type) SetBAUD_SBR(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x1fff)|value)
}
func (o *LPUART0_Type) GetBAUD_SBR() uint32 {
	return volatile.LoadUint32(&o.BAUD.Reg) & 0x1fff
}
func (o *LPUART0_Type) SetBAUD_SBNS(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART0_Type) GetBAUD_SBNS() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x2000) >> 13
}
func (o *LPUART0_Type) SetBAUD_RXEDGIE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetBAUD_RXEDGIE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetBAUD_LBKDIE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetBAUD_LBKDIE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetBAUD_RESYNCDIS(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetBAUD_RESYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetBAUD_BOTHEDGE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetBAUD_BOTHEDGE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetBAUD_MATCFG(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xc0000)|value<<18)
}
func (o *LPUART0_Type) GetBAUD_MATCFG() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xc0000) >> 18
}
func (o *LPUART0_Type) SetBAUD_RDMAE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetBAUD_RDMAE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetBAUD_TDMAE(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetBAUD_TDMAE() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetBAUD_OSR(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x1f000000)|value<<24)
}
func (o *LPUART0_Type) GetBAUD_OSR() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x1f000000) >> 24
}
func (o *LPUART0_Type) SetBAUD_M10(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetBAUD_M10() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetBAUD_MAEN2(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetBAUD_MAEN2() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetBAUD_MAEN1(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetBAUD_MAEN1() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0x80000000) >> 31
}

// LPUART0.STAT: LPUART Status Register
func (o *LPUART0_Type) SetSTAT_MA2F(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetSTAT_MA2F() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetSTAT_MA1F(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetSTAT_MA1F() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetSTAT_PF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetSTAT_PF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetSTAT_FE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetSTAT_FE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetSTAT_NF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetSTAT_NF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000) >> 18
}
func (o *LPUART0_Type) SetSTAT_OR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART0_Type) GetSTAT_OR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000) >> 19
}
func (o *LPUART0_Type) SetSTAT_IDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART0_Type) GetSTAT_IDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100000) >> 20
}
func (o *LPUART0_Type) SetSTAT_RDRF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetSTAT_RDRF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetSTAT_TC(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART0_Type) GetSTAT_TC() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400000) >> 22
}
func (o *LPUART0_Type) SetSTAT_TDRE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetSTAT_TDRE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetSTAT_RAF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART0_Type) GetSTAT_RAF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000000) >> 24
}
func (o *LPUART0_Type) SetSTAT_LBKDE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *LPUART0_Type) GetSTAT_LBKDE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000000) >> 25
}
func (o *LPUART0_Type) SetSTAT_BRK13(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART0_Type) GetSTAT_BRK13() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000000) >> 26
}
func (o *LPUART0_Type) SetSTAT_RWUID(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART0_Type) GetSTAT_RWUID() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000000) >> 27
}
func (o *LPUART0_Type) SetSTAT_RXINV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART0_Type) GetSTAT_RXINV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000000) >> 28
}
func (o *LPUART0_Type) SetSTAT_MSBF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetSTAT_MSBF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetSTAT_RXEDGIF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetSTAT_RXEDGIF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetSTAT_LBKDIF(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetSTAT_LBKDIF() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000000) >> 31
}

// LPUART0.CTRL: LPUART Control Register
func (o *LPUART0_Type) SetCTRL_PT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetCTRL_PT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *LPUART0_Type) SetCTRL_PE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetCTRL_PE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetCTRL_ILT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetCTRL_ILT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetCTRL_WAKE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetCTRL_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetCTRL_M(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetCTRL_M() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetCTRL_RSRC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetCTRL_RSRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetCTRL_DOZEEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *LPUART0_Type) GetCTRL_DOZEEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *LPUART0_Type) SetCTRL_LOOPS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *LPUART0_Type) GetCTRL_LOOPS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *LPUART0_Type) SetCTRL_IDLECFG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x700)|value<<8)
}
func (o *LPUART0_Type) GetCTRL_IDLECFG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x700) >> 8
}
func (o *LPUART0_Type) SetCTRL_MA2IE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetCTRL_MA2IE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetCTRL_MA1IE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetCTRL_MA1IE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *LPUART0_Type) SetCTRL_SBK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART0_Type) GetCTRL_SBK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *LPUART0_Type) SetCTRL_RWU(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART0_Type) GetCTRL_RWU() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *LPUART0_Type) SetCTRL_RE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetCTRL_RE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *LPUART0_Type) SetCTRL_TE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART0_Type) GetCTRL_TE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *LPUART0_Type) SetCTRL_ILIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART0_Type) GetCTRL_ILIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *LPUART0_Type) SetCTRL_RIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART0_Type) GetCTRL_RIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *LPUART0_Type) SetCTRL_TCIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART0_Type) GetCTRL_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *LPUART0_Type) SetCTRL_TIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART0_Type) GetCTRL_TIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *LPUART0_Type) SetCTRL_PEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART0_Type) GetCTRL_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *LPUART0_Type) SetCTRL_FEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *LPUART0_Type) GetCTRL_FEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *LPUART0_Type) SetCTRL_NEIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART0_Type) GetCTRL_NEIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *LPUART0_Type) SetCTRL_ORIE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART0_Type) GetCTRL_ORIE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000000) >> 27
}
func (o *LPUART0_Type) SetCTRL_TXINV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART0_Type) GetCTRL_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000000) >> 28
}
func (o *LPUART0_Type) SetCTRL_TXDIR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART0_Type) GetCTRL_TXDIR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000000) >> 29
}
func (o *LPUART0_Type) SetCTRL_R9T8(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART0_Type) GetCTRL_R9T8() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *LPUART0_Type) SetCTRL_R8T9(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART0_Type) GetCTRL_R8T9() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// LPUART0.DATA: LPUART Data Register
func (o *LPUART0_Type) SetDATA_R0T0(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetDATA_R0T0() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0x1
}
func (o *LPUART0_Type) SetDATA_R1T1(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetDATA_R1T1() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetDATA_R2T2(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetDATA_R2T2() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetDATA_R3T3(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetDATA_R3T3() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetDATA_R4T4(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetDATA_R4T4() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetDATA_R5T5(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetDATA_R5T5() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetDATA_R6T6(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x40)|value<<6)
}
func (o *LPUART0_Type) GetDATA_R6T6() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x40) >> 6
}
func (o *LPUART0_Type) SetDATA_R7T7(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x80)|value<<7)
}
func (o *LPUART0_Type) GetDATA_R7T7() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x80) >> 7
}
func (o *LPUART0_Type) SetDATA_R8T8(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x100)|value<<8)
}
func (o *LPUART0_Type) GetDATA_R8T8() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x100) >> 8
}
func (o *LPUART0_Type) SetDATA_R9T9(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x200)|value<<9)
}
func (o *LPUART0_Type) GetDATA_R9T9() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x200) >> 9
}
func (o *LPUART0_Type) SetDATA_IDLINE(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x800)|value<<11)
}
func (o *LPUART0_Type) GetDATA_IDLINE() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x800) >> 11
}
func (o *LPUART0_Type) SetDATA_RXEMPT(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART0_Type) GetDATA_RXEMPT() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x1000) >> 12
}
func (o *LPUART0_Type) SetDATA_FRETSC(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART0_Type) GetDATA_FRETSC() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x2000) >> 13
}
func (o *LPUART0_Type) SetDATA_PARITYE(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART0_Type) GetDATA_PARITYE() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x4000) >> 14
}
func (o *LPUART0_Type) SetDATA_NOISY(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART0_Type) GetDATA_NOISY() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x8000) >> 15
}

// LPUART0.MATCH: LPUART Match Address Register
func (o *LPUART0_Type) SetMATCH_MA1(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x3ff)|value)
}
func (o *LPUART0_Type) GetMATCH_MA1() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x3ff
}
func (o *LPUART0_Type) SetMATCH_MA2(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LPUART0_Type) GetMATCH_MA2() uint32 {
	return (volatile.LoadUint32(&o.MATCH.Reg) & 0x3ff0000) >> 16
}

// LPUART0.MODIR: LPUART Modem IrDA Register
func (o *LPUART0_Type) SetMODIR_TXCTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x1)|value)
}
func (o *LPUART0_Type) GetMODIR_TXCTSE() uint32 {
	return volatile.LoadUint32(&o.MODIR.Reg) & 0x1
}
func (o *LPUART0_Type) SetMODIR_TXRTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART0_Type) GetMODIR_TXRTSE() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x2) >> 1
}
func (o *LPUART0_Type) SetMODIR_TXRTSPOL(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART0_Type) GetMODIR_TXRTSPOL() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x4) >> 2
}
func (o *LPUART0_Type) SetMODIR_RXRTSE(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART0_Type) GetMODIR_RXRTSE() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x8) >> 3
}
func (o *LPUART0_Type) SetMODIR_TXCTSC(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART0_Type) GetMODIR_TXCTSC() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x10) >> 4
}
func (o *LPUART0_Type) SetMODIR_TXCTSSRC(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x20)|value<<5)
}
func (o *LPUART0_Type) GetMODIR_TXCTSSRC() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x20) >> 5
}
func (o *LPUART0_Type) SetMODIR_TNP(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x30000)|value<<16)
}
func (o *LPUART0_Type) GetMODIR_TNP() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x30000) >> 16
}
func (o *LPUART0_Type) SetMODIR_IREN(value uint32) {
	volatile.StoreUint32(&o.MODIR.Reg, volatile.LoadUint32(&o.MODIR.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART0_Type) GetMODIR_IREN() uint32 {
	return (volatile.LoadUint32(&o.MODIR.Reg) & 0x40000) >> 18
}

// LTC
type LTC0_Type struct {
	MD      volatile.Register32 // 0x0
	_       [4]byte
	KS      volatile.Register32 // 0x8
	_       [4]byte
	DS      volatile.Register32 // 0x10
	_       [4]byte
	ICVS    volatile.Register32 // 0x18
	_       [20]byte
	COM     volatile.Register32 // 0x30
	CTL     volatile.Register32 // 0x34
	_       [8]byte
	CW      volatile.Register32 // 0x40
	_       [4]byte
	STA     volatile.Register32 // 0x48
	ESTA    volatile.Register32 // 0x4C
	_       [8]byte
	AADSZ   volatile.Register32 // 0x58
	_       [164]byte
	CTX_0   volatile.Register32 // 0x100
	CTX_1   volatile.Register32 // 0x104
	CTX_2   volatile.Register32 // 0x108
	CTX_3   volatile.Register32 // 0x10C
	CTX_4   volatile.Register32 // 0x110
	CTX_5   volatile.Register32 // 0x114
	CTX_6   volatile.Register32 // 0x118
	CTX_7   volatile.Register32 // 0x11C
	CTX_8   volatile.Register32 // 0x120
	CTX_9   volatile.Register32 // 0x124
	CTX_10  volatile.Register32 // 0x128
	CTX_11  volatile.Register32 // 0x12C
	CTX_12  volatile.Register32 // 0x130
	CTX_13  volatile.Register32 // 0x134
	_       [200]byte
	KEY_0   volatile.Register32 // 0x200
	KEY_1   volatile.Register32 // 0x204
	KEY_2   volatile.Register32 // 0x208
	KEY_3   volatile.Register32 // 0x20C
	_       [736]byte
	VID1    volatile.Register32 // 0x4F0
	VID2    volatile.Register32 // 0x4F4
	CHAVID  volatile.Register32 // 0x4F8
	_       [708]byte
	FIFOSTA volatile.Register32 // 0x7C0
	_       [28]byte
	IFIFO   volatile.Register32 // 0x7E0
	_       [12]byte
	OFIFO   volatile.Register32 // 0x7F0
}

// LTC0.MD: Mode Register
func (o *LTC0_Type) SetMD_ENC(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x1)|value)
}
func (o *LTC0_Type) GetMD_ENC() uint32 {
	return volatile.LoadUint32(&o.MD.Reg) & 0x1
}
func (o *LTC0_Type) SetMD_ICV_TEST(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x2)|value<<1)
}
func (o *LTC0_Type) GetMD_ICV_TEST() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0x2) >> 1
}
func (o *LTC0_Type) SetMD_AS(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0xc)|value<<2)
}
func (o *LTC0_Type) GetMD_AS() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0xc) >> 2
}
func (o *LTC0_Type) SetMD_AAI(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x1ff0)|value<<4)
}
func (o *LTC0_Type) GetMD_AAI() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0x1ff0) >> 4
}
func (o *LTC0_Type) SetMD_ALG(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0xff0000)|value<<16)
}
func (o *LTC0_Type) GetMD_ALG() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0xff0000) >> 16
}

// LTC0.KS: Key Size Register
func (o *LTC0_Type) SetKS(value uint32) {
	volatile.StoreUint32(&o.KS.Reg, volatile.LoadUint32(&o.KS.Reg)&^(0x1f)|value)
}
func (o *LTC0_Type) GetKS() uint32 {
	return volatile.LoadUint32(&o.KS.Reg) & 0x1f
}

// LTC0.DS: Data Size Register
func (o *LTC0_Type) SetDS(value uint32) {
	volatile.StoreUint32(&o.DS.Reg, volatile.LoadUint32(&o.DS.Reg)&^(0xfff)|value)
}
func (o *LTC0_Type) GetDS() uint32 {
	return volatile.LoadUint32(&o.DS.Reg) & 0xfff
}

// LTC0.ICVS: ICV Size Register
func (o *LTC0_Type) SetICVS(value uint32) {
	volatile.StoreUint32(&o.ICVS.Reg, volatile.LoadUint32(&o.ICVS.Reg)&^(0x1f)|value)
}
func (o *LTC0_Type) GetICVS() uint32 {
	return volatile.LoadUint32(&o.ICVS.Reg) & 0x1f
}

// LTC0.COM: Command Register
func (o *LTC0_Type) SetCOM_ALL(value uint32) {
	volatile.StoreUint32(&o.COM.Reg, volatile.LoadUint32(&o.COM.Reg)&^(0x1)|value)
}
func (o *LTC0_Type) GetCOM_ALL() uint32 {
	return volatile.LoadUint32(&o.COM.Reg) & 0x1
}
func (o *LTC0_Type) SetCOM_AES(value uint32) {
	volatile.StoreUint32(&o.COM.Reg, volatile.LoadUint32(&o.COM.Reg)&^(0x2)|value<<1)
}
func (o *LTC0_Type) GetCOM_AES() uint32 {
	return (volatile.LoadUint32(&o.COM.Reg) & 0x2) >> 1
}

// LTC0.CTL: Control Register
func (o *LTC0_Type) SetCTL_IM(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1)|value)
}
func (o *LTC0_Type) GetCTL_IM() uint32 {
	return volatile.LoadUint32(&o.CTL.Reg) & 0x1
}
func (o *LTC0_Type) SetCTL_IFE(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100)|value<<8)
}
func (o *LTC0_Type) GetCTL_IFE() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100) >> 8
}
func (o *LTC0_Type) SetCTL_IFR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200)|value<<9)
}
func (o *LTC0_Type) GetCTL_IFR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200) >> 9
}
func (o *LTC0_Type) SetCTL_OFE(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x1000)|value<<12)
}
func (o *LTC0_Type) GetCTL_OFE() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x1000) >> 12
}
func (o *LTC0_Type) SetCTL_OFR(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x2000)|value<<13)
}
func (o *LTC0_Type) GetCTL_OFR() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x2000) >> 13
}
func (o *LTC0_Type) SetCTL_IFS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x10000)|value<<16)
}
func (o *LTC0_Type) GetCTL_IFS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x10000) >> 16
}
func (o *LTC0_Type) SetCTL_OFS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x20000)|value<<17)
}
func (o *LTC0_Type) GetCTL_OFS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x20000) >> 17
}
func (o *LTC0_Type) SetCTL_KIS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x100000)|value<<20)
}
func (o *LTC0_Type) GetCTL_KIS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x100000) >> 20
}
func (o *LTC0_Type) SetCTL_KOS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x200000)|value<<21)
}
func (o *LTC0_Type) GetCTL_KOS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x200000) >> 21
}
func (o *LTC0_Type) SetCTL_CIS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x400000)|value<<22)
}
func (o *LTC0_Type) GetCTL_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x400000) >> 22
}
func (o *LTC0_Type) SetCTL_COS(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x800000)|value<<23)
}
func (o *LTC0_Type) GetCTL_COS() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x800000) >> 23
}
func (o *LTC0_Type) SetCTL_KAL(value uint32) {
	volatile.StoreUint32(&o.CTL.Reg, volatile.LoadUint32(&o.CTL.Reg)&^(0x80000000)|value<<31)
}
func (o *LTC0_Type) GetCTL_KAL() uint32 {
	return (volatile.LoadUint32(&o.CTL.Reg) & 0x80000000) >> 31
}

// LTC0.CW: Clear Written Register
func (o *LTC0_Type) SetCW_CM(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x1)|value)
}
func (o *LTC0_Type) GetCW_CM() uint32 {
	return volatile.LoadUint32(&o.CW.Reg) & 0x1
}
func (o *LTC0_Type) SetCW_CDS(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x4)|value<<2)
}
func (o *LTC0_Type) GetCW_CDS() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x4) >> 2
}
func (o *LTC0_Type) SetCW_CICV(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x8)|value<<3)
}
func (o *LTC0_Type) GetCW_CICV() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x8) >> 3
}
func (o *LTC0_Type) SetCW_CCR(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x20)|value<<5)
}
func (o *LTC0_Type) GetCW_CCR() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x20) >> 5
}
func (o *LTC0_Type) SetCW_CKR(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x40)|value<<6)
}
func (o *LTC0_Type) GetCW_CKR() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x40) >> 6
}
func (o *LTC0_Type) SetCW_COF(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x40000000)|value<<30)
}
func (o *LTC0_Type) GetCW_COF() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x40000000) >> 30
}
func (o *LTC0_Type) SetCW_CIF(value uint32) {
	volatile.StoreUint32(&o.CW.Reg, volatile.LoadUint32(&o.CW.Reg)&^(0x80000000)|value<<31)
}
func (o *LTC0_Type) GetCW_CIF() uint32 {
	return (volatile.LoadUint32(&o.CW.Reg) & 0x80000000) >> 31
}

// LTC0.STA: Status Register
func (o *LTC0_Type) SetSTA_AB(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *LTC0_Type) GetSTA_AB() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *LTC0_Type) SetSTA_DI(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *LTC0_Type) GetSTA_DI() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *LTC0_Type) SetSTA_EI(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *LTC0_Type) GetSTA_EI() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}

// LTC0.ESTA: Error Status Register
func (o *LTC0_Type) SetESTA_ERRID1(value uint32) {
	volatile.StoreUint32(&o.ESTA.Reg, volatile.LoadUint32(&o.ESTA.Reg)&^(0xf)|value)
}
func (o *LTC0_Type) GetESTA_ERRID1() uint32 {
	return volatile.LoadUint32(&o.ESTA.Reg) & 0xf
}
func (o *LTC0_Type) SetESTA_CL1(value uint32) {
	volatile.StoreUint32(&o.ESTA.Reg, volatile.LoadUint32(&o.ESTA.Reg)&^(0xf00)|value<<8)
}
func (o *LTC0_Type) GetESTA_CL1() uint32 {
	return (volatile.LoadUint32(&o.ESTA.Reg) & 0xf00) >> 8
}

// LTC0.AADSZ: AAD Size Register
func (o *LTC0_Type) SetAADSZ(value uint32) {
	volatile.StoreUint32(&o.AADSZ.Reg, volatile.LoadUint32(&o.AADSZ.Reg)&^(0xf)|value)
}
func (o *LTC0_Type) GetAADSZ() uint32 {
	return volatile.LoadUint32(&o.AADSZ.Reg) & 0xf
}
func (o *LTC0_Type) SetAADSZ_AL(value uint32) {
	volatile.StoreUint32(&o.AADSZ.Reg, volatile.LoadUint32(&o.AADSZ.Reg)&^(0x80000000)|value<<31)
}
func (o *LTC0_Type) GetAADSZ_AL() uint32 {
	return (volatile.LoadUint32(&o.AADSZ.Reg) & 0x80000000) >> 31
}

// LTC0.CTX_0: Context Register
func (o *LTC0_Type) SetCTX_0(value uint32) {
	volatile.StoreUint32(&o.CTX_0.Reg, value)
}
func (o *LTC0_Type) GetCTX_0() uint32 {
	return volatile.LoadUint32(&o.CTX_0.Reg)
}

// LTC0.CTX_1: Context Register
func (o *LTC0_Type) SetCTX_1(value uint32) {
	volatile.StoreUint32(&o.CTX_1.Reg, value)
}
func (o *LTC0_Type) GetCTX_1() uint32 {
	return volatile.LoadUint32(&o.CTX_1.Reg)
}

// LTC0.CTX_2: Context Register
func (o *LTC0_Type) SetCTX_2(value uint32) {
	volatile.StoreUint32(&o.CTX_2.Reg, value)
}
func (o *LTC0_Type) GetCTX_2() uint32 {
	return volatile.LoadUint32(&o.CTX_2.Reg)
}

// LTC0.CTX_3: Context Register
func (o *LTC0_Type) SetCTX_3(value uint32) {
	volatile.StoreUint32(&o.CTX_3.Reg, value)
}
func (o *LTC0_Type) GetCTX_3() uint32 {
	return volatile.LoadUint32(&o.CTX_3.Reg)
}

// LTC0.CTX_4: Context Register
func (o *LTC0_Type) SetCTX_4(value uint32) {
	volatile.StoreUint32(&o.CTX_4.Reg, value)
}
func (o *LTC0_Type) GetCTX_4() uint32 {
	return volatile.LoadUint32(&o.CTX_4.Reg)
}

// LTC0.CTX_5: Context Register
func (o *LTC0_Type) SetCTX_5(value uint32) {
	volatile.StoreUint32(&o.CTX_5.Reg, value)
}
func (o *LTC0_Type) GetCTX_5() uint32 {
	return volatile.LoadUint32(&o.CTX_5.Reg)
}

// LTC0.CTX_6: Context Register
func (o *LTC0_Type) SetCTX_6(value uint32) {
	volatile.StoreUint32(&o.CTX_6.Reg, value)
}
func (o *LTC0_Type) GetCTX_6() uint32 {
	return volatile.LoadUint32(&o.CTX_6.Reg)
}

// LTC0.CTX_7: Context Register
func (o *LTC0_Type) SetCTX_7(value uint32) {
	volatile.StoreUint32(&o.CTX_7.Reg, value)
}
func (o *LTC0_Type) GetCTX_7() uint32 {
	return volatile.LoadUint32(&o.CTX_7.Reg)
}

// LTC0.CTX_8: Context Register
func (o *LTC0_Type) SetCTX_8(value uint32) {
	volatile.StoreUint32(&o.CTX_8.Reg, value)
}
func (o *LTC0_Type) GetCTX_8() uint32 {
	return volatile.LoadUint32(&o.CTX_8.Reg)
}

// LTC0.CTX_9: Context Register
func (o *LTC0_Type) SetCTX_9(value uint32) {
	volatile.StoreUint32(&o.CTX_9.Reg, value)
}
func (o *LTC0_Type) GetCTX_9() uint32 {
	return volatile.LoadUint32(&o.CTX_9.Reg)
}

// LTC0.CTX_10: Context Register
func (o *LTC0_Type) SetCTX_10(value uint32) {
	volatile.StoreUint32(&o.CTX_10.Reg, value)
}
func (o *LTC0_Type) GetCTX_10() uint32 {
	return volatile.LoadUint32(&o.CTX_10.Reg)
}

// LTC0.CTX_11: Context Register
func (o *LTC0_Type) SetCTX_11(value uint32) {
	volatile.StoreUint32(&o.CTX_11.Reg, value)
}
func (o *LTC0_Type) GetCTX_11() uint32 {
	return volatile.LoadUint32(&o.CTX_11.Reg)
}

// LTC0.CTX_12: Context Register
func (o *LTC0_Type) SetCTX_12(value uint32) {
	volatile.StoreUint32(&o.CTX_12.Reg, value)
}
func (o *LTC0_Type) GetCTX_12() uint32 {
	return volatile.LoadUint32(&o.CTX_12.Reg)
}

// LTC0.CTX_13: Context Register
func (o *LTC0_Type) SetCTX_13(value uint32) {
	volatile.StoreUint32(&o.CTX_13.Reg, value)
}
func (o *LTC0_Type) GetCTX_13() uint32 {
	return volatile.LoadUint32(&o.CTX_13.Reg)
}

// LTC0.KEY_0: Key Registers
func (o *LTC0_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *LTC0_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// LTC0.KEY_1: Key Registers
func (o *LTC0_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *LTC0_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// LTC0.KEY_2: Key Registers
func (o *LTC0_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *LTC0_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// LTC0.KEY_3: Key Registers
func (o *LTC0_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *LTC0_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// LTC0.VID1: Version ID Register
func (o *LTC0_Type) SetVID1_MIN_REV(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xff)|value)
}
func (o *LTC0_Type) GetVID1_MIN_REV() uint32 {
	return volatile.LoadUint32(&o.VID1.Reg) & 0xff
}
func (o *LTC0_Type) SetVID1_MAJ_REV(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xff00)|value<<8)
}
func (o *LTC0_Type) GetVID1_MAJ_REV() uint32 {
	return (volatile.LoadUint32(&o.VID1.Reg) & 0xff00) >> 8
}
func (o *LTC0_Type) SetVID1_IP_ID(value uint32) {
	volatile.StoreUint32(&o.VID1.Reg, volatile.LoadUint32(&o.VID1.Reg)&^(0xffff0000)|value<<16)
}
func (o *LTC0_Type) GetVID1_IP_ID() uint32 {
	return (volatile.LoadUint32(&o.VID1.Reg) & 0xffff0000) >> 16
}

// LTC0.VID2: Version ID 2 Register
func (o *LTC0_Type) SetVID2_ECO_REV(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff)|value)
}
func (o *LTC0_Type) GetVID2_ECO_REV() uint32 {
	return volatile.LoadUint32(&o.VID2.Reg) & 0xff
}
func (o *LTC0_Type) SetVID2_ARCH_ERA(value uint32) {
	volatile.StoreUint32(&o.VID2.Reg, volatile.LoadUint32(&o.VID2.Reg)&^(0xff00)|value<<8)
}
func (o *LTC0_Type) GetVID2_ARCH_ERA() uint32 {
	return (volatile.LoadUint32(&o.VID2.Reg) & 0xff00) >> 8
}

// LTC0.CHAVID: CHA Version ID Register
func (o *LTC0_Type) SetCHAVID_AESREV(value uint32) {
	volatile.StoreUint32(&o.CHAVID.Reg, volatile.LoadUint32(&o.CHAVID.Reg)&^(0xf)|value)
}
func (o *LTC0_Type) GetCHAVID_AESREV() uint32 {
	return volatile.LoadUint32(&o.CHAVID.Reg) & 0xf
}
func (o *LTC0_Type) SetCHAVID_AESVID(value uint32) {
	volatile.StoreUint32(&o.CHAVID.Reg, volatile.LoadUint32(&o.CHAVID.Reg)&^(0xf0)|value<<4)
}
func (o *LTC0_Type) GetCHAVID_AESVID() uint32 {
	return (volatile.LoadUint32(&o.CHAVID.Reg) & 0xf0) >> 4
}

// LTC0.FIFOSTA: FIFO Status Register
func (o *LTC0_Type) SetFIFOSTA_IFL(value uint32) {
	volatile.StoreUint32(&o.FIFOSTA.Reg, volatile.LoadUint32(&o.FIFOSTA.Reg)&^(0x7f)|value)
}
func (o *LTC0_Type) GetFIFOSTA_IFL() uint32 {
	return volatile.LoadUint32(&o.FIFOSTA.Reg) & 0x7f
}
func (o *LTC0_Type) SetFIFOSTA_IFF(value uint32) {
	volatile.StoreUint32(&o.FIFOSTA.Reg, volatile.LoadUint32(&o.FIFOSTA.Reg)&^(0x8000)|value<<15)
}
func (o *LTC0_Type) GetFIFOSTA_IFF() uint32 {
	return (volatile.LoadUint32(&o.FIFOSTA.Reg) & 0x8000) >> 15
}
func (o *LTC0_Type) SetFIFOSTA_OFL(value uint32) {
	volatile.StoreUint32(&o.FIFOSTA.Reg, volatile.LoadUint32(&o.FIFOSTA.Reg)&^(0x7f0000)|value<<16)
}
func (o *LTC0_Type) GetFIFOSTA_OFL() uint32 {
	return (volatile.LoadUint32(&o.FIFOSTA.Reg) & 0x7f0000) >> 16
}
func (o *LTC0_Type) SetFIFOSTA_OFF(value uint32) {
	volatile.StoreUint32(&o.FIFOSTA.Reg, volatile.LoadUint32(&o.FIFOSTA.Reg)&^(0x80000000)|value<<31)
}
func (o *LTC0_Type) GetFIFOSTA_OFF() uint32 {
	return (volatile.LoadUint32(&o.FIFOSTA.Reg) & 0x80000000) >> 31
}

// LTC0.IFIFO: Input Data FIFO
func (o *LTC0_Type) SetIFIFO(value uint32) {
	volatile.StoreUint32(&o.IFIFO.Reg, value)
}
func (o *LTC0_Type) GetIFIFO() uint32 {
	return volatile.LoadUint32(&o.IFIFO.Reg)
}

// LTC0.OFIFO: Output Data FIFO
func (o *LTC0_Type) SetOFIFO(value uint32) {
	volatile.StoreUint32(&o.OFIFO.Reg, value)
}
func (o *LTC0_Type) GetOFIFO() uint32 {
	return volatile.LoadUint32(&o.OFIFO.Reg)
}

// RSIM
type RSIM_Type struct {
	CONTROL        volatile.Register32 // 0x0
	ACTIVE_DELAY   volatile.Register32 // 0x4
	MAC_MSB        volatile.Register32 // 0x8
	MAC_LSB        volatile.Register32 // 0xC
	MISC           volatile.Register32 // 0x10
	_              [236]byte
	DSM_TIMER      volatile.Register32 // 0x100
	DSM_CONTROL    volatile.Register32 // 0x104
	DSM_OSC_OFFSET volatile.Register32 // 0x108
	ANT_SLEEP      volatile.Register32 // 0x10C
	ANT_WAKE       volatile.Register32 // 0x110
	ZIG_SLEEP      volatile.Register32 // 0x114
	ZIG_WAKE       volatile.Register32 // 0x118
	GEN_SLEEP      volatile.Register32 // 0x11C
	GEN_WAKE       volatile.Register32 // 0x120
	RF_OSC_CTRL    volatile.Register32 // 0x124
	ANA_TEST       volatile.Register32 // 0x128
	ANA_TRIM       volatile.Register32 // 0x12C
}

// RSIM.CONTROL: Radio System Control
func (o *RSIM_Type) SetCONTROL_BLE_RF_OSC_REQ_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1)|value)
}
func (o *RSIM_Type) GetCONTROL_BLE_RF_OSC_REQ_EN() uint32 {
	return volatile.LoadUint32(&o.CONTROL.Reg) & 0x1
}
func (o *RSIM_Type) SetCONTROL_BLE_RF_OSC_REQ_STAT(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *RSIM_Type) GetCONTROL_BLE_RF_OSC_REQ_STAT() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2) >> 1
}
func (o *RSIM_Type) SetCONTROL_BLE_RF_OSC_REQ_INT_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x10)|value<<4)
}
func (o *RSIM_Type) GetCONTROL_BLE_RF_OSC_REQ_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x10) >> 4
}
func (o *RSIM_Type) SetCONTROL_BLE_RF_OSC_REQ_INT(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x20)|value<<5)
}
func (o *RSIM_Type) GetCONTROL_BLE_RF_OSC_REQ_INT() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x20) >> 5
}
func (o *RSIM_Type) SetCONTROL_RF_OSC_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0xf00)|value<<8)
}
func (o *RSIM_Type) GetCONTROL_RF_OSC_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0xf00) >> 8
}
func (o *RSIM_Type) SetCONTROL_RADIO_GASKET_BYPASS_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1000)|value<<12)
}
func (o *RSIM_Type) GetCONTROL_RADIO_GASKET_BYPASS_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x1000) >> 12
}
func (o *RSIM_Type) SetCONTROL_RADIO_GASKET_BYPASS_OVRD(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2000)|value<<13)
}
func (o *RSIM_Type) GetCONTROL_RADIO_GASKET_BYPASS_OVRD() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2000) >> 13
}
func (o *RSIM_Type) SetCONTROL_IPP_OBE_3V_BLE_ACTIVE_1(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x10000)|value<<16)
}
func (o *RSIM_Type) GetCONTROL_IPP_OBE_3V_BLE_ACTIVE_1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x10000) >> 16
}
func (o *RSIM_Type) SetCONTROL_IPP_OBE_3V_BLE_ACTIVE_2(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x20000)|value<<17)
}
func (o *RSIM_Type) GetCONTROL_IPP_OBE_3V_BLE_ACTIVE_2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x20000) >> 17
}
func (o *RSIM_Type) SetCONTROL_RADIO_RAM_ACCESS_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x40000)|value<<18)
}
func (o *RSIM_Type) GetCONTROL_RADIO_RAM_ACCESS_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x40000) >> 18
}
func (o *RSIM_Type) SetCONTROL_RADIO_RAM_ACCESS_OVRD(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x80000)|value<<19)
}
func (o *RSIM_Type) GetCONTROL_RADIO_RAM_ACCESS_OVRD() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x80000) >> 19
}
func (o *RSIM_Type) SetCONTROL_RSIM_DSM_EXIT(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x100000)|value<<20)
}
func (o *RSIM_Type) GetCONTROL_RSIM_DSM_EXIT() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x100000) >> 20
}
func (o *RSIM_Type) SetCONTROL_RSIM_STOP_ACK_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x400000)|value<<22)
}
func (o *RSIM_Type) GetCONTROL_RSIM_STOP_ACK_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x400000) >> 22
}
func (o *RSIM_Type) SetCONTROL_RSIM_STOP_ACK_OVRD(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x800000)|value<<23)
}
func (o *RSIM_Type) GetCONTROL_RSIM_STOP_ACK_OVRD() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x800000) >> 23
}
func (o *RSIM_Type) SetCONTROL_RF_OSC_READY(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *RSIM_Type) GetCONTROL_RF_OSC_READY() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x1000000) >> 24
}
func (o *RSIM_Type) SetCONTROL_RF_OSC_READY_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *RSIM_Type) GetCONTROL_RF_OSC_READY_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2000000) >> 25
}
func (o *RSIM_Type) SetCONTROL_RF_OSC_READY_OVRD(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x4000000)|value<<26)
}
func (o *RSIM_Type) GetCONTROL_RF_OSC_READY_OVRD() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x4000000) >> 26
}
func (o *RSIM_Type) SetCONTROL_BLOCK_SOC_RESETS(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x10000000)|value<<28)
}
func (o *RSIM_Type) GetCONTROL_BLOCK_SOC_RESETS() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x10000000) >> 28
}
func (o *RSIM_Type) SetCONTROL_BLOCK_RADIO_OUTPUTS(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x20000000)|value<<29)
}
func (o *RSIM_Type) GetCONTROL_BLOCK_RADIO_OUTPUTS() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x20000000) >> 29
}
func (o *RSIM_Type) SetCONTROL_ALLOW_DFT_RESETS(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x40000000)|value<<30)
}
func (o *RSIM_Type) GetCONTROL_ALLOW_DFT_RESETS() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x40000000) >> 30
}
func (o *RSIM_Type) SetCONTROL_RADIO_RESET_BIT(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *RSIM_Type) GetCONTROL_RADIO_RESET_BIT() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x80000000) >> 31
}

// RSIM.ACTIVE_DELAY: Radio Active Early Warning
func (o *RSIM_Type) SetACTIVE_DELAY_BLE_FINE_DELAY(value uint32) {
	volatile.StoreUint32(&o.ACTIVE_DELAY.Reg, volatile.LoadUint32(&o.ACTIVE_DELAY.Reg)&^(0x3f)|value)
}
func (o *RSIM_Type) GetACTIVE_DELAY_BLE_FINE_DELAY() uint32 {
	return volatile.LoadUint32(&o.ACTIVE_DELAY.Reg) & 0x3f
}
func (o *RSIM_Type) SetACTIVE_DELAY_BLE_COARSE_DELAY(value uint32) {
	volatile.StoreUint32(&o.ACTIVE_DELAY.Reg, volatile.LoadUint32(&o.ACTIVE_DELAY.Reg)&^(0xf0000)|value<<16)
}
func (o *RSIM_Type) GetACTIVE_DELAY_BLE_COARSE_DELAY() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE_DELAY.Reg) & 0xf0000) >> 16
}

// RSIM.MAC_MSB: Radio MAC Address
func (o *RSIM_Type) SetMAC_MSB_MAC_ADDR_MSB(value uint32) {
	volatile.StoreUint32(&o.MAC_MSB.Reg, volatile.LoadUint32(&o.MAC_MSB.Reg)&^(0xff)|value)
}
func (o *RSIM_Type) GetMAC_MSB_MAC_ADDR_MSB() uint32 {
	return volatile.LoadUint32(&o.MAC_MSB.Reg) & 0xff
}

// RSIM.MAC_LSB: Radio MAC Address
func (o *RSIM_Type) SetMAC_LSB(value uint32) {
	volatile.StoreUint32(&o.MAC_LSB.Reg, value)
}
func (o *RSIM_Type) GetMAC_LSB() uint32 {
	return volatile.LoadUint32(&o.MAC_LSB.Reg)
}

// RSIM.MISC: Radio Miscellaneous
func (o *RSIM_Type) SetMISC_ANALOG_TEST_EN(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0x1f)|value)
}
func (o *RSIM_Type) GetMISC_ANALOG_TEST_EN() uint32 {
	return volatile.LoadUint32(&o.MISC.Reg) & 0x1f
}
func (o *RSIM_Type) SetMISC_RADIO_VERSION(value uint32) {
	volatile.StoreUint32(&o.MISC.Reg, volatile.LoadUint32(&o.MISC.Reg)&^(0xff000000)|value<<24)
}
func (o *RSIM_Type) GetMISC_RADIO_VERSION() uint32 {
	return (volatile.LoadUint32(&o.MISC.Reg) & 0xff000000) >> 24
}

// RSIM.DSM_TIMER: Deep Sleep Timer
func (o *RSIM_Type) SetDSM_TIMER(value uint32) {
	volatile.StoreUint32(&o.DSM_TIMER.Reg, volatile.LoadUint32(&o.DSM_TIMER.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetDSM_TIMER() uint32 {
	return volatile.LoadUint32(&o.DSM_TIMER.Reg) & 0xffffff
}

// RSIM.DSM_CONTROL: Deep Sleep Timer Control
func (o *RSIM_Type) SetDSM_CONTROL_DSM_ANT_READY(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x1)|value)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_ANT_READY() uint32 {
	return volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x1
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_DEEP_SLEEP_STATUS(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_DEEP_SLEEP_STATUS() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x2) >> 1
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_ANT_FINISHED(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_ANT_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x4) >> 2
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_SYSCLK_REQUEST_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_SYSCLK_REQUEST_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x8) >> 3
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_SLEEP_REQUEST(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x10)|value<<4)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_SLEEP_REQUEST() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x10) >> 4
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_SYSCLK_REQ(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x20)|value<<5)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_SYSCLK_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x20) >> 5
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x40)|value<<6)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x40) >> 6
}
func (o *RSIM_Type) SetDSM_CONTROL_ANT_SYSCLK_REQ_INT(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x80)|value<<7)
}
func (o *RSIM_Type) GetDSM_CONTROL_ANT_SYSCLK_REQ_INT() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x80) >> 7
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_GEN_READY(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x100)|value<<8)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_GEN_READY() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x100) >> 8
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_DEEP_SLEEP_STATUS(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x200)|value<<9)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_DEEP_SLEEP_STATUS() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x200) >> 9
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_GEN_FINISHED(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x400)|value<<10)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_GEN_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x400) >> 10
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_SYSCLK_REQUEST_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x800)|value<<11)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_SYSCLK_REQUEST_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x800) >> 11
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_SLEEP_REQUEST(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x1000)|value<<12)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_SLEEP_REQUEST() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x1000) >> 12
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_SYSCLK_REQ(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x2000)|value<<13)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_SYSCLK_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x2000) >> 13
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x4000)|value<<14)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x4000) >> 14
}
func (o *RSIM_Type) SetDSM_CONTROL_GEN_SYSCLK_REQ_INT(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x8000)|value<<15)
}
func (o *RSIM_Type) GetDSM_CONTROL_GEN_SYSCLK_REQ_INT() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x8000) >> 15
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_ZIG_READY(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x10000)|value<<16)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_ZIG_READY() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x10000) >> 16
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_DEEP_SLEEP_STATUS(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x20000)|value<<17)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_DEEP_SLEEP_STATUS() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x20000) >> 17
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_ZIG_FINISHED(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x40000)|value<<18)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_ZIG_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x40000) >> 18
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_SYSCLK_REQUEST_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x80000)|value<<19)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_SYSCLK_REQUEST_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x80000) >> 19
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_SLEEP_REQUEST(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x100000)|value<<20)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_SLEEP_REQUEST() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x100000) >> 20
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_SYSCLK_REQ(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x200000)|value<<21)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_SYSCLK_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x200000) >> 21
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x400000)|value<<22)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x400000) >> 22
}
func (o *RSIM_Type) SetDSM_CONTROL_ZIG_SYSCLK_REQ_INT(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x800000)|value<<23)
}
func (o *RSIM_Type) GetDSM_CONTROL_ZIG_SYSCLK_REQ_INT() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x800000) >> 23
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_TIMER_CLR(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x8000000)|value<<27)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_TIMER_CLR() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x8000000) >> 27
}
func (o *RSIM_Type) SetDSM_CONTROL_DSM_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.DSM_CONTROL.Reg, volatile.LoadUint32(&o.DSM_CONTROL.Reg)&^(0x80000000)|value<<31)
}
func (o *RSIM_Type) GetDSM_CONTROL_DSM_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.DSM_CONTROL.Reg) & 0x80000000) >> 31
}

// RSIM.DSM_OSC_OFFSET: Deep Sleep Wakeup Time Offset
func (o *RSIM_Type) SetDSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME(value uint32) {
	volatile.StoreUint32(&o.DSM_OSC_OFFSET.Reg, volatile.LoadUint32(&o.DSM_OSC_OFFSET.Reg)&^(0x3ff)|value)
}
func (o *RSIM_Type) GetDSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME() uint32 {
	return volatile.LoadUint32(&o.DSM_OSC_OFFSET.Reg) & 0x3ff
}

// RSIM.ANT_SLEEP: ANT Link Layer Sleep Time
func (o *RSIM_Type) SetANT_SLEEP_ANT_SLEEP_TIME(value uint32) {
	volatile.StoreUint32(&o.ANT_SLEEP.Reg, volatile.LoadUint32(&o.ANT_SLEEP.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetANT_SLEEP_ANT_SLEEP_TIME() uint32 {
	return volatile.LoadUint32(&o.ANT_SLEEP.Reg) & 0xffffff
}

// RSIM.ANT_WAKE: ANT Link Layer Wake Time
func (o *RSIM_Type) SetANT_WAKE_ANT_WAKE_TIME(value uint32) {
	volatile.StoreUint32(&o.ANT_WAKE.Reg, volatile.LoadUint32(&o.ANT_WAKE.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetANT_WAKE_ANT_WAKE_TIME() uint32 {
	return volatile.LoadUint32(&o.ANT_WAKE.Reg) & 0xffffff
}

// RSIM.ZIG_SLEEP: 802.15.4 Link Layer Sleep Time
func (o *RSIM_Type) SetZIG_SLEEP_ZIG_SLEEP_TIME(value uint32) {
	volatile.StoreUint32(&o.ZIG_SLEEP.Reg, volatile.LoadUint32(&o.ZIG_SLEEP.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetZIG_SLEEP_ZIG_SLEEP_TIME() uint32 {
	return volatile.LoadUint32(&o.ZIG_SLEEP.Reg) & 0xffffff
}

// RSIM.ZIG_WAKE: 802.15.4 Link Layer Wake Time
func (o *RSIM_Type) SetZIG_WAKE_ZIG_WAKE_TIME(value uint32) {
	volatile.StoreUint32(&o.ZIG_WAKE.Reg, volatile.LoadUint32(&o.ZIG_WAKE.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetZIG_WAKE_ZIG_WAKE_TIME() uint32 {
	return volatile.LoadUint32(&o.ZIG_WAKE.Reg) & 0xffffff
}

// RSIM.GEN_SLEEP: Generic FSK Link Layer Sleep Time
func (o *RSIM_Type) SetGEN_SLEEP_GEN_SLEEP_TIME(value uint32) {
	volatile.StoreUint32(&o.GEN_SLEEP.Reg, volatile.LoadUint32(&o.GEN_SLEEP.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetGEN_SLEEP_GEN_SLEEP_TIME() uint32 {
	return volatile.LoadUint32(&o.GEN_SLEEP.Reg) & 0xffffff
}

// RSIM.GEN_WAKE: Generic FSK Link Layer Wake Time
func (o *RSIM_Type) SetGEN_WAKE_GEN_WAKE_TIME(value uint32) {
	volatile.StoreUint32(&o.GEN_WAKE.Reg, volatile.LoadUint32(&o.GEN_WAKE.Reg)&^(0xffffff)|value)
}
func (o *RSIM_Type) GetGEN_WAKE_GEN_WAKE_TIME() uint32 {
	return volatile.LoadUint32(&o.GEN_WAKE.Reg) & 0xffffff
}

// RSIM.RF_OSC_CTRL: Radio Oscillator Control
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x3)|value)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL() uint32 {
	return volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x3
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_ALC_ON(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_ALC_ON() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x4) >> 2
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RF_OSC_BYPASS_EN(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RF_OSC_BYPASS_EN() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x8) >> 3
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_COMP_BIAS(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x1f0)|value<<4)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_COMP_BIAS() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x1f0) >> 4
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x200) >> 9
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x400) >> 10
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_DIG_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_DIG_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x800) >> 11
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_GM(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x1f000)|value<<12)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_GM() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x1f000) >> 12
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_ON_OVRD(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_ON_OVRD() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x20000) >> 17
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_ON_OVRD_ON(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_ON_OVRD_ON() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x40000) >> 18
}
func (o *RSIM_Type) SetRF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x300000)|value<<20)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x300000) >> 20
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x8000000) >> 27
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RADIO_EXT_OSC_OVRD(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RADIO_EXT_OSC_OVRD() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x10000000) >> 28
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x20000000) >> 29
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RADIO_RF_ABORT_OVRD(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RADIO_RF_ABORT_OVRD() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x40000000) >> 30
}
func (o *RSIM_Type) SetRF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.RF_OSC_CTRL.Reg, volatile.LoadUint32(&o.RF_OSC_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *RSIM_Type) GetRF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.RF_OSC_CTRL.Reg) & 0x80000000) >> 31
}

// RSIM.ANA_TEST: Radio Analog Test Registers
func (o *RSIM_Type) SetANA_TEST_BB_LDO_LS_BYP(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x1)|value)
}
func (o *RSIM_Type) GetANA_TEST_BB_LDO_LS_BYP() uint32 {
	return volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x1
}
func (o *RSIM_Type) SetANA_TEST_BB_LDO_LS_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x2)|value<<1)
}
func (o *RSIM_Type) GetANA_TEST_BB_LDO_LS_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x2) >> 1
}
func (o *RSIM_Type) SetANA_TEST_BB_LDO_XO_BYP_ON(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x4)|value<<2)
}
func (o *RSIM_Type) GetANA_TEST_BB_LDO_XO_BYP_ON() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x4) >> 2
}
func (o *RSIM_Type) SetANA_TEST_BB_LDO_XO_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x8)|value<<3)
}
func (o *RSIM_Type) GetANA_TEST_BB_LDO_XO_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x8) >> 3
}
func (o *RSIM_Type) SetANA_TEST_BB_XTAL_TEST(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x10)|value<<4)
}
func (o *RSIM_Type) GetANA_TEST_BB_XTAL_TEST() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x10) >> 4
}
func (o *RSIM_Type) SetANA_TEST_BG_DIAGBUF(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x20)|value<<5)
}
func (o *RSIM_Type) GetANA_TEST_BG_DIAGBUF() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x20) >> 5
}
func (o *RSIM_Type) SetANA_TEST_BG_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x40)|value<<6)
}
func (o *RSIM_Type) GetANA_TEST_BG_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x40) >> 6
}
func (o *RSIM_Type) SetANA_TEST_BG_STARTUPFORCE(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x80)|value<<7)
}
func (o *RSIM_Type) GetANA_TEST_BG_STARTUPFORCE() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x80) >> 7
}
func (o *RSIM_Type) SetANA_TEST_DIAG_1234_ON(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x100)|value<<8)
}
func (o *RSIM_Type) GetANA_TEST_DIAG_1234_ON() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x100) >> 8
}
func (o *RSIM_Type) SetANA_TEST_DIAG2SOCADC_DEC(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x600)|value<<9)
}
func (o *RSIM_Type) GetANA_TEST_DIAG2SOCADC_DEC() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x600) >> 9
}
func (o *RSIM_Type) SetANA_TEST_DIAG2SOCADC_DEC_ON(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x800)|value<<11)
}
func (o *RSIM_Type) GetANA_TEST_DIAG2SOCADC_DEC_ON() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x800) >> 11
}
func (o *RSIM_Type) SetANA_TEST_DIAGCODE(value uint32) {
	volatile.StoreUint32(&o.ANA_TEST.Reg, volatile.LoadUint32(&o.ANA_TEST.Reg)&^(0x7000)|value<<12)
}
func (o *RSIM_Type) GetANA_TEST_DIAGCODE() uint32 {
	return (volatile.LoadUint32(&o.ANA_TEST.Reg) & 0x7000) >> 12
}

// RSIM.ANA_TRIM: Radio Analog Trim Registers
func (o *RSIM_Type) SetANA_TRIM_BB_LDO_LS_SPARE(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0x3)|value)
}
func (o *RSIM_Type) GetANA_TRIM_BB_LDO_LS_SPARE() uint32 {
	return volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0x3
}
func (o *RSIM_Type) SetANA_TRIM_BB_LDO_LS_TRIM(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0x38)|value<<3)
}
func (o *RSIM_Type) GetANA_TRIM_BB_LDO_LS_TRIM() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0x38) >> 3
}
func (o *RSIM_Type) SetANA_TRIM_BB_LDO_XO_SPARE(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0xc0)|value<<6)
}
func (o *RSIM_Type) GetANA_TRIM_BB_LDO_XO_SPARE() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0xc0) >> 6
}
func (o *RSIM_Type) SetANA_TRIM_BB_LDO_XO_TRIM(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0x700)|value<<8)
}
func (o *RSIM_Type) GetANA_TRIM_BB_LDO_XO_TRIM() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0x700) >> 8
}
func (o *RSIM_Type) SetANA_TRIM_BB_XTAL_SPARE(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0xf800)|value<<11)
}
func (o *RSIM_Type) GetANA_TRIM_BB_XTAL_SPARE() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0xf800) >> 11
}
func (o *RSIM_Type) SetANA_TRIM_BB_XTAL_TRIM(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0xff0000)|value<<16)
}
func (o *RSIM_Type) GetANA_TRIM_BB_XTAL_TRIM() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0xff0000) >> 16
}
func (o *RSIM_Type) SetANA_TRIM_BG_1V_TRIM(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0xf000000)|value<<24)
}
func (o *RSIM_Type) GetANA_TRIM_BG_1V_TRIM() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0xf000000) >> 24
}
func (o *RSIM_Type) SetANA_TRIM_BG_IBIAS_5U_TRIM(value uint32) {
	volatile.StoreUint32(&o.ANA_TRIM.Reg, volatile.LoadUint32(&o.ANA_TRIM.Reg)&^(0xf0000000)|value<<28)
}
func (o *RSIM_Type) GetANA_TRIM_BG_IBIAS_5U_TRIM() uint32 {
	return (volatile.LoadUint32(&o.ANA_TRIM.Reg) & 0xf0000000) >> 28
}

// DC to DC Converter
type DCDC_Type struct {
	REG0 volatile.Register32 // 0x0
	REG1 volatile.Register32 // 0x4
	REG2 volatile.Register32 // 0x8
	REG3 volatile.Register32 // 0xC
	REG4 volatile.Register32 // 0x10
	_    [4]byte
	REG6 volatile.Register32 // 0x18
	REG7 volatile.Register32 // 0x1C
}

// DCDC.REG0: DCDC REGISTER 0
func (o *DCDC_Type) SetREG0_DCDC_DISABLE_AUTO_CLK_SWITCH(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x2)|value<<1)
}
func (o *DCDC_Type) GetREG0_DCDC_DISABLE_AUTO_CLK_SWITCH() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x2) >> 1
}
func (o *DCDC_Type) SetREG0_DCDC_SEL_CLK(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x4)|value<<2)
}
func (o *DCDC_Type) GetREG0_DCDC_SEL_CLK() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x4) >> 2
}
func (o *DCDC_Type) SetREG0_DCDC_PWD_OSC_INT(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x8)|value<<3)
}
func (o *DCDC_Type) GetREG0_DCDC_PWD_OSC_INT() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x8) >> 3
}
func (o *DCDC_Type) SetREG0_DCDC_LP_DF_CMP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x200)|value<<9)
}
func (o *DCDC_Type) GetREG0_DCDC_LP_DF_CMP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x200) >> 9
}
func (o *DCDC_Type) SetREG0_DCDC_VBAT_DIV_CTRL(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0xc00)|value<<10)
}
func (o *DCDC_Type) GetREG0_DCDC_VBAT_DIV_CTRL() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0xc00) >> 10
}
func (o *DCDC_Type) SetREG0_DCDC_LP_STATE_HYS_L(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x60000)|value<<17)
}
func (o *DCDC_Type) GetREG0_DCDC_LP_STATE_HYS_L() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x60000) >> 17
}
func (o *DCDC_Type) SetREG0_DCDC_LP_STATE_HYS_H(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x180000)|value<<19)
}
func (o *DCDC_Type) GetREG0_DCDC_LP_STATE_HYS_H() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x180000) >> 19
}
func (o *DCDC_Type) SetREG0_HYST_LP_COMP_ADJ(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x200000)|value<<21)
}
func (o *DCDC_Type) GetREG0_HYST_LP_COMP_ADJ() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x200000) >> 21
}
func (o *DCDC_Type) SetREG0_HYST_LP_CMP_DISABLE(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x400000)|value<<22)
}
func (o *DCDC_Type) GetREG0_HYST_LP_CMP_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x400000) >> 22
}
func (o *DCDC_Type) SetREG0_OFFSET_RSNS_LP_ADJ(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x800000)|value<<23)
}
func (o *DCDC_Type) GetREG0_OFFSET_RSNS_LP_ADJ() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x800000) >> 23
}
func (o *DCDC_Type) SetREG0_OFFSET_RSNS_LP_DISABLE(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x1000000)|value<<24)
}
func (o *DCDC_Type) GetREG0_OFFSET_RSNS_LP_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x1000000) >> 24
}
func (o *DCDC_Type) SetREG0_DCDC_LESS_I(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x2000000)|value<<25)
}
func (o *DCDC_Type) GetREG0_DCDC_LESS_I() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x2000000) >> 25
}
func (o *DCDC_Type) SetREG0_PWD_CMP_OFFSET(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x4000000)|value<<26)
}
func (o *DCDC_Type) GetREG0_PWD_CMP_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x4000000) >> 26
}
func (o *DCDC_Type) SetREG0_DCDC_XTALOK_DISABLE(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x8000000)|value<<27)
}
func (o *DCDC_Type) GetREG0_DCDC_XTALOK_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x8000000) >> 27
}
func (o *DCDC_Type) SetREG0_PSWITCH_STATUS(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x10000000)|value<<28)
}
func (o *DCDC_Type) GetREG0_PSWITCH_STATUS() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x10000000) >> 28
}
func (o *DCDC_Type) SetREG0_VLPS_CONFIG_DCDC_HP(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x20000000)|value<<29)
}
func (o *DCDC_Type) GetREG0_VLPS_CONFIG_DCDC_HP() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x20000000) >> 29
}
func (o *DCDC_Type) SetREG0_VLPR_VLPW_CONFIG_DCDC_HP(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x40000000)|value<<30)
}
func (o *DCDC_Type) GetREG0_VLPR_VLPW_CONFIG_DCDC_HP() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x40000000) >> 30
}
func (o *DCDC_Type) SetREG0_DCDC_STS_DC_OK(value uint32) {
	volatile.StoreUint32(&o.REG0.Reg, volatile.LoadUint32(&o.REG0.Reg)&^(0x80000000)|value<<31)
}
func (o *DCDC_Type) GetREG0_DCDC_STS_DC_OK() uint32 {
	return (volatile.LoadUint32(&o.REG0.Reg) & 0x80000000) >> 31
}

// DCDC.REG1: DCDC REGISTER 1
func (o *DCDC_Type) SetREG1_POSLIMIT_BUCK_IN(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x7f)|value)
}
func (o *DCDC_Type) GetREG1_POSLIMIT_BUCK_IN() uint32 {
	return volatile.LoadUint32(&o.REG1.Reg) & 0x7f
}
func (o *DCDC_Type) SetREG1_POSLIMIT_BOOST_IN(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x3f80)|value<<7)
}
func (o *DCDC_Type) GetREG1_POSLIMIT_BOOST_IN() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0x3f80) >> 7
}
func (o *DCDC_Type) SetREG1_DCDC_LOOPCTRL_CM_HST_THRESH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x200000)|value<<21)
}
func (o *DCDC_Type) GetREG1_DCDC_LOOPCTRL_CM_HST_THRESH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0x200000) >> 21
}
func (o *DCDC_Type) SetREG1_DCDC_LOOPCTRL_DF_HST_THRESH(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x400000)|value<<22)
}
func (o *DCDC_Type) GetREG1_DCDC_LOOPCTRL_DF_HST_THRESH() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0x400000) >> 22
}
func (o *DCDC_Type) SetREG1_DCDC_LOOPCTRL_EN_CM_HYST(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x800000)|value<<23)
}
func (o *DCDC_Type) GetREG1_DCDC_LOOPCTRL_EN_CM_HYST() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0x800000) >> 23
}
func (o *DCDC_Type) SetREG1_DCDC_LOOPCTRL_EN_DF_HYST(value uint32) {
	volatile.StoreUint32(&o.REG1.Reg, volatile.LoadUint32(&o.REG1.Reg)&^(0x1000000)|value<<24)
}
func (o *DCDC_Type) GetREG1_DCDC_LOOPCTRL_EN_DF_HYST() uint32 {
	return (volatile.LoadUint32(&o.REG1.Reg) & 0x1000000) >> 24
}

// DCDC.REG2: DCDC REGISTER 2
func (o *DCDC_Type) SetREG2_DCDC_LOOPCTRL_HYST_SIGN(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0x2000)|value<<13)
}
func (o *DCDC_Type) GetREG2_DCDC_LOOPCTRL_HYST_SIGN() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0x2000) >> 13
}
func (o *DCDC_Type) SetREG2_DCDC_BATTMONITOR_EN_BATADJ(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0x8000)|value<<15)
}
func (o *DCDC_Type) GetREG2_DCDC_BATTMONITOR_EN_BATADJ() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0x8000) >> 15
}
func (o *DCDC_Type) SetREG2_DCDC_BATTMONITOR_BATT_VAL(value uint32) {
	volatile.StoreUint32(&o.REG2.Reg, volatile.LoadUint32(&o.REG2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DCDC_Type) GetREG2_DCDC_BATTMONITOR_BATT_VAL() uint32 {
	return (volatile.LoadUint32(&o.REG2.Reg) & 0x3ff0000) >> 16
}

// DCDC.REG3: DCDC REGISTER 3
func (o *DCDC_Type) SetREG3_DCDC_VDD1P8CTRL_TRG(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x3f)|value)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P8CTRL_TRG() uint32 {
	return volatile.LoadUint32(&o.REG3.Reg) & 0x3f
}
func (o *DCDC_Type) SetREG3_DCDC_VDD1P5CTRL_TRG_BUCK(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x7c0)|value<<6)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P5CTRL_TRG_BUCK() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x7c0) >> 6
}
func (o *DCDC_Type) SetREG3_DCDC_VDD1P5CTRL_TRG_BOOST(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0xf800)|value<<11)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P5CTRL_TRG_BOOST() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0xf800) >> 11
}
func (o *DCDC_Type) SetREG3_DCDC_VDD1P5CTRL_ADJTN(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x1e0000)|value<<17)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P5CTRL_ADJTN() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x1e0000) >> 17
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_DC_HALFCLK_PULSED(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x200000)|value<<21)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_DC_HALFCLK_PULSED() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x200000) >> 21
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_DOUBLE_FETS_PULSED(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x400000)|value<<22)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_DOUBLE_FETS_PULSED() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x400000) >> 22
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_HALF_FETS_PULSED(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x800000)|value<<23)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_HALF_FETS_PULSED() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x800000) >> 23
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_DC_HALFCLK(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x1000000)|value<<24)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_DC_HALFCLK() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x1000000) >> 24
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_DOUBLE_FETS(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x2000000)|value<<25)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_DOUBLE_FETS() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x2000000) >> 25
}
func (o *DCDC_Type) SetREG3_DCDC_MINPWR_HALF_FETS(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x4000000)|value<<26)
}
func (o *DCDC_Type) GetREG3_DCDC_MINPWR_HALF_FETS() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x4000000) >> 26
}
func (o *DCDC_Type) SetREG3_DCDC_VDD1P5CTRL_DISABLE_STEP(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x20000000)|value<<29)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P5CTRL_DISABLE_STEP() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x20000000) >> 29
}
func (o *DCDC_Type) SetREG3_DCDC_VDD1P8CTRL_DISABLE_STEP(value uint32) {
	volatile.StoreUint32(&o.REG3.Reg, volatile.LoadUint32(&o.REG3.Reg)&^(0x40000000)|value<<30)
}
func (o *DCDC_Type) GetREG3_DCDC_VDD1P8CTRL_DISABLE_STEP() uint32 {
	return (volatile.LoadUint32(&o.REG3.Reg) & 0x40000000) >> 30
}

// DCDC.REG4: DCDC REGISTER 4
func (o *DCDC_Type) SetREG4_DCDC_SW_SHUTDOWN(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0x1)|value)
}
func (o *DCDC_Type) GetREG4_DCDC_SW_SHUTDOWN() uint32 {
	return volatile.LoadUint32(&o.REG4.Reg) & 0x1
}
func (o *DCDC_Type) SetREG4_UNLOCK(value uint32) {
	volatile.StoreUint32(&o.REG4.Reg, volatile.LoadUint32(&o.REG4.Reg)&^(0xffff0000)|value<<16)
}
func (o *DCDC_Type) GetREG4_UNLOCK() uint32 {
	return (volatile.LoadUint32(&o.REG4.Reg) & 0xffff0000) >> 16
}

// DCDC.REG6: DCDC REGISTER 6
func (o *DCDC_Type) SetREG6_PSWITCH_INT_RISE_EN(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0x1)|value)
}
func (o *DCDC_Type) GetREG6_PSWITCH_INT_RISE_EN() uint32 {
	return volatile.LoadUint32(&o.REG6.Reg) & 0x1
}
func (o *DCDC_Type) SetREG6_PSWITCH_INT_FALL_EN(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0x2)|value<<1)
}
func (o *DCDC_Type) GetREG6_PSWITCH_INT_FALL_EN() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0x2) >> 1
}
func (o *DCDC_Type) SetREG6_PSWITCH_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0x4)|value<<2)
}
func (o *DCDC_Type) GetREG6_PSWITCH_INT_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0x4) >> 2
}
func (o *DCDC_Type) SetREG6_PSWITCH_INT_MUTE(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0x8)|value<<3)
}
func (o *DCDC_Type) GetREG6_PSWITCH_INT_MUTE() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0x8) >> 3
}
func (o *DCDC_Type) SetREG6_PSWITCH_INT_STS(value uint32) {
	volatile.StoreUint32(&o.REG6.Reg, volatile.LoadUint32(&o.REG6.Reg)&^(0x80000000)|value<<31)
}
func (o *DCDC_Type) GetREG6_PSWITCH_INT_STS() uint32 {
	return (volatile.LoadUint32(&o.REG6.Reg) & 0x80000000) >> 31
}

// DCDC.REG7: DCDC REGISTER 7
func (o *DCDC_Type) SetREG7_INTEGRATOR_VALUE(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0x7ffff)|value)
}
func (o *DCDC_Type) GetREG7_INTEGRATOR_VALUE() uint32 {
	return volatile.LoadUint32(&o.REG7.Reg) & 0x7ffff
}
func (o *DCDC_Type) SetREG7_INTEGRATOR_VALUE_SEL(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0x80000)|value<<19)
}
func (o *DCDC_Type) GetREG7_INTEGRATOR_VALUE_SEL() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0x80000) >> 19
}
func (o *DCDC_Type) SetREG7_PULSE_RUN_SPEEDUP(value uint32) {
	volatile.StoreUint32(&o.REG7.Reg, volatile.LoadUint32(&o.REG7.Reg)&^(0x100000)|value<<20)
}
func (o *DCDC_Type) GetREG7_PULSE_RUN_SPEEDUP() uint32 {
	return (volatile.LoadUint32(&o.REG7.Reg) & 0x100000) >> 20
}

// BLE_RF
type BTLE_RF_Type struct {
	_           [1536]byte
	BLE_PART_ID volatile.Register16 // 0x600
	_           [2]byte
	DSM_STATUS  volatile.Register16 // 0x604
	_           [2]byte
	MISC_CTRL   volatile.Register16 // 0x608
}

// BTLE_RF.BLE_PART_ID: BLUETOOTH LOW ENERGY PART ID
func (o *BTLE_RF_Type) SetBLE_PART_ID(value uint16) {
	volatile.StoreUint16(&o.BLE_PART_ID.Reg, value)
}
func (o *BTLE_RF_Type) GetBLE_PART_ID() uint16 {
	return volatile.LoadUint16(&o.BLE_PART_ID.Reg)
}

// BTLE_RF.DSM_STATUS: BLE DSM STATUS
func (o *BTLE_RF_Type) SetDSM_STATUS_ORF_SYSCLK_REQ(value uint16) {
	volatile.StoreUint16(&o.DSM_STATUS.Reg, volatile.LoadUint16(&o.DSM_STATUS.Reg)&^(0x1)|value)
}
func (o *BTLE_RF_Type) GetDSM_STATUS_ORF_SYSCLK_REQ() uint16 {
	return volatile.LoadUint16(&o.DSM_STATUS.Reg) & 0x1
}
func (o *BTLE_RF_Type) SetDSM_STATUS_RIF_LL_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.DSM_STATUS.Reg, volatile.LoadUint16(&o.DSM_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *BTLE_RF_Type) GetDSM_STATUS_RIF_LL_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.DSM_STATUS.Reg) & 0x2) >> 1
}
func (o *BTLE_RF_Type) SetDSM_STATUS_XCVR_BUSY(value uint16) {
	volatile.StoreUint16(&o.DSM_STATUS.Reg, volatile.LoadUint16(&o.DSM_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *BTLE_RF_Type) GetDSM_STATUS_XCVR_BUSY() uint16 {
	return (volatile.LoadUint16(&o.DSM_STATUS.Reg) & 0x4) >> 2
}

// BTLE_RF.MISC_CTRL: BLUETOOTH LOW ENERGY MISCELLANEOUS CONTROL
func (o *BTLE_RF_Type) SetMISC_CTRL_TSM_INTR_EN(value uint16) {
	volatile.StoreUint16(&o.MISC_CTRL.Reg, volatile.LoadUint16(&o.MISC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BTLE_RF_Type) GetMISC_CTRL_TSM_INTR_EN() uint16 {
	return (volatile.LoadUint16(&o.MISC_CTRL.Reg) & 0x2) >> 1
}

// XCVR_RX_DIG
type XCVR_RX_DIG_Type struct {
	RX_DIG_CTRL               volatile.Register32 // 0x0
	AGC_CTRL_0                volatile.Register32 // 0x4
	AGC_CTRL_1                volatile.Register32 // 0x8
	AGC_CTRL_2                volatile.Register32 // 0xC
	AGC_CTRL_3                volatile.Register32 // 0x10
	AGC_STAT                  volatile.Register32 // 0x14
	RSSI_CTRL_0               volatile.Register32 // 0x18
	RSSI_CTRL_1               volatile.Register32 // 0x1C
	RSSI_DFT                  volatile.Register32 // 0x20
	DCOC_CTRL_0               volatile.Register32 // 0x24
	DCOC_CTRL_1               volatile.Register32 // 0x28
	DCOC_DAC_INIT             volatile.Register32 // 0x2C
	DCOC_DIG_MAN              volatile.Register32 // 0x30
	DCOC_CAL_GAIN             volatile.Register32 // 0x34
	DCOC_STAT                 volatile.Register32 // 0x38
	DCOC_DC_EST               volatile.Register32 // 0x3C
	DCOC_CAL_RCP              volatile.Register32 // 0x40
	_                         [4]byte
	IQMC_CTRL                 volatile.Register32 // 0x48
	IQMC_CAL                  volatile.Register32 // 0x4C
	LNA_GAIN_VAL_3_0          volatile.Register32 // 0x50
	LNA_GAIN_VAL_7_4          volatile.Register32 // 0x54
	LNA_GAIN_VAL_8            volatile.Register32 // 0x58
	BBA_RES_TUNE_VAL_7_0      volatile.Register32 // 0x5C
	BBA_RES_TUNE_VAL_10_8     volatile.Register32 // 0x60
	LNA_GAIN_LIN_VAL_2_0      volatile.Register32 // 0x64
	LNA_GAIN_LIN_VAL_5_3      volatile.Register32 // 0x68
	LNA_GAIN_LIN_VAL_8_6      volatile.Register32 // 0x6C
	LNA_GAIN_LIN_VAL_9        volatile.Register32 // 0x70
	BBA_RES_TUNE_LIN_VAL_3_0  volatile.Register32 // 0x74
	BBA_RES_TUNE_LIN_VAL_7_4  volatile.Register32 // 0x78
	BBA_RES_TUNE_LIN_VAL_10_8 volatile.Register32 // 0x7C
	AGC_GAIN_TBL_03_00        volatile.Register32 // 0x80
	AGC_GAIN_TBL_07_04        volatile.Register32 // 0x84
	AGC_GAIN_TBL_11_08        volatile.Register32 // 0x88
	AGC_GAIN_TBL_15_12        volatile.Register32 // 0x8C
	AGC_GAIN_TBL_19_16        volatile.Register32 // 0x90
	AGC_GAIN_TBL_23_20        volatile.Register32 // 0x94
	AGC_GAIN_TBL_26_24        volatile.Register32 // 0x98
	_                         [4]byte
	DCOC_OFFSET_0             volatile.Register32 // 0xA0
	DCOC_OFFSET_1             volatile.Register32 // 0xA4
	DCOC_OFFSET_2             volatile.Register32 // 0xA8
	DCOC_OFFSET_3             volatile.Register32 // 0xAC
	DCOC_OFFSET_4             volatile.Register32 // 0xB0
	DCOC_OFFSET_5             volatile.Register32 // 0xB4
	DCOC_OFFSET_6             volatile.Register32 // 0xB8
	DCOC_OFFSET_7             volatile.Register32 // 0xBC
	DCOC_OFFSET_8             volatile.Register32 // 0xC0
	DCOC_OFFSET_9             volatile.Register32 // 0xC4
	DCOC_OFFSET_10            volatile.Register32 // 0xC8
	DCOC_OFFSET_11            volatile.Register32 // 0xCC
	DCOC_OFFSET_12            volatile.Register32 // 0xD0
	DCOC_OFFSET_13            volatile.Register32 // 0xD4
	DCOC_OFFSET_14            volatile.Register32 // 0xD8
	DCOC_OFFSET_15            volatile.Register32 // 0xDC
	DCOC_OFFSET_16            volatile.Register32 // 0xE0
	DCOC_OFFSET_17            volatile.Register32 // 0xE4
	DCOC_OFFSET_18            volatile.Register32 // 0xE8
	DCOC_OFFSET_19            volatile.Register32 // 0xEC
	DCOC_OFFSET_20            volatile.Register32 // 0xF0
	DCOC_OFFSET_21            volatile.Register32 // 0xF4
	DCOC_OFFSET_22            volatile.Register32 // 0xF8
	DCOC_OFFSET_23            volatile.Register32 // 0xFC
	DCOC_OFFSET_24            volatile.Register32 // 0x100
	DCOC_OFFSET_25            volatile.Register32 // 0x104
	DCOC_OFFSET_26            volatile.Register32 // 0x108
	DCOC_BBA_STEP             volatile.Register32 // 0x10C
	DCOC_TZA_STEP_0           volatile.Register32 // 0x110
	DCOC_TZA_STEP_1           volatile.Register32 // 0x114
	DCOC_TZA_STEP_2           volatile.Register32 // 0x118
	DCOC_TZA_STEP_3           volatile.Register32 // 0x11C
	DCOC_TZA_STEP_4           volatile.Register32 // 0x120
	DCOC_TZA_STEP_5           volatile.Register32 // 0x124
	DCOC_TZA_STEP_6           volatile.Register32 // 0x128
	DCOC_TZA_STEP_7           volatile.Register32 // 0x12C
	DCOC_TZA_STEP_8           volatile.Register32 // 0x130
	DCOC_TZA_STEP_9           volatile.Register32 // 0x134
	DCOC_TZA_STEP_10          volatile.Register32 // 0x138
	_                         [44]byte
	DCOC_CAL_ALPHA            volatile.Register32 // 0x168
	DCOC_CAL_BETA_Q           volatile.Register32 // 0x16C
	DCOC_CAL_BETA_I           volatile.Register32 // 0x170
	DCOC_CAL_GAMMA            volatile.Register32 // 0x174
	DCOC_CAL_IIR              volatile.Register32 // 0x178
	_                         [4]byte
	DCOC_CAL1                 volatile.Register32 // 0x180
	DCOC_CAL2                 volatile.Register32 // 0x184
	DCOC_CAL3                 volatile.Register32 // 0x188
	_                         [4]byte
	CCA_ED_LQI_CTRL_0         volatile.Register32 // 0x190
	CCA_ED_LQI_CTRL_1         volatile.Register32 // 0x194
	CCA_ED_LQI_STAT_0         volatile.Register32 // 0x198
	_                         [4]byte
	RX_CHF_COEF_0             volatile.Register32 // 0x1A0
	RX_CHF_COEF_1             volatile.Register32 // 0x1A4
	RX_CHF_COEF_2             volatile.Register32 // 0x1A8
	RX_CHF_COEF_3             volatile.Register32 // 0x1AC
	RX_CHF_COEF_4             volatile.Register32 // 0x1B0
	RX_CHF_COEF_5             volatile.Register32 // 0x1B4
	RX_CHF_COEF_6             volatile.Register32 // 0x1B8
	RX_CHF_COEF_7             volatile.Register32 // 0x1BC
	RX_CHF_COEF_8             volatile.Register32 // 0x1C0
	RX_CHF_COEF_9             volatile.Register32 // 0x1C4
	RX_CHF_COEF_10            volatile.Register32 // 0x1C8
	RX_CHF_COEF_11            volatile.Register32 // 0x1CC
	AGC_MAN_AGC_IDX           volatile.Register32 // 0x1D0
	DC_RESID_CTRL             volatile.Register32 // 0x1D4
	DC_RESID_EST              volatile.Register32 // 0x1D8
	RX_RCCAL_CTRL0            volatile.Register32 // 0x1DC
	RX_RCCAL_CTRL1            volatile.Register32 // 0x1E0
	RX_RCCAL_STAT             volatile.Register32 // 0x1E4
	AUXPLL_FCAL_CTRL          volatile.Register32 // 0x1E8
	AUXPLL_FCAL_CNT6          volatile.Register32 // 0x1EC
	AUXPLL_FCAL_CNT5_4        volatile.Register32 // 0x1F0
	AUXPLL_FCAL_CNT3_2        volatile.Register32 // 0x1F4
	AUXPLL_FCAL_CNT1_0        volatile.Register32 // 0x1F8
	RXDIG_DFT                 volatile.Register32 // 0x1FC
}

// XCVR_RX_DIG.RX_DIG_CTRL: RX Digital Control
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_ADC_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_ADC_NEGEDGE() uint32 {
	return volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_CH_FILT_BYPASS(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_CH_FILT_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x2) >> 1
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_ADC_RAW_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_ADC_RAW_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x4) >> 2
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_ADC_POL(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_ADC_POL() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_OSR(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_OSR() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x70) >> 4
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_FSK_ZB_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_FSK_ZB_SEL() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x100) >> 8
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_NORM_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_NORM_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x200) >> 9
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_RSSI_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_RSSI_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x400) >> 10
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_AGC_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_AGC_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DCOC_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DCOC_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x1000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DCOC_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DCOC_CAL_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x2000) >> 13
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_IQ_SWAP(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_IQ_SWAP() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x4000) >> 14
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DC_RESID_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DC_RESID_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_SRC_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_SRC_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x10000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_SRC_RATE(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_SRC_RATE() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x20000) >> 17
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DMA_DTEST_EN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DMA_DTEST_EN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x40000) >> 18
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_GAIN(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x1f00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_GAIN() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x1f00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x2000000) >> 25
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_HAZARD(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_HAZARD() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x10000000) >> 28
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_RSSI_FILT_HAZARD(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_RSSI_FILT_HAZARD() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x20000000) >> 29
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_SAT_I(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_SAT_I() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x40000000) >> 30
}
func (o *XCVR_RX_DIG_Type) SetRX_DIG_CTRL_RX_DEC_FILT_SAT_Q(value uint32) {
	volatile.StoreUint32(&o.RX_DIG_CTRL.Reg, volatile.LoadUint32(&o.RX_DIG_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_RX_DIG_Type) GetRX_DIG_CTRL_RX_DEC_FILT_SAT_Q() uint32 {
	return (volatile.LoadUint32(&o.RX_DIG_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_RX_DIG.AGC_CTRL_0: AGC Control 0
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_SLOW_AGC_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_SLOW_AGC_EN() uint32 {
	return volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_SLOW_AGC_SRC(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x6)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_SLOW_AGC_SRC() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x6) >> 1
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_FREEZE_PRE_OR_AA(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_FREEZE_PRE_OR_AA() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x10) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_UP_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_UP_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x40) >> 6
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_UP_SRC(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_UP_SRC() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0x80) >> 7
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_UP_RSSI_THRESH(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_UP_RSSI_THRESH() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_0_AGC_DOWN_RSSI_THRESH(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_0.Reg, volatile.LoadUint32(&o.AGC_CTRL_0.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_0_AGC_DOWN_RSSI_THRESH() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_0.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.AGC_CTRL_1: AGC Control 1
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_BBA_ALT_CODE(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_BBA_ALT_CODE() uint32 {
	return volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_LNA_ALT_CODE(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0xff0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_LNA_ALT_CODE() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0xff0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_LNA_USER_GAIN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_LNA_USER_GAIN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_BBA_USER_GAIN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_BBA_USER_GAIN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_USER_LNA_GAIN_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_USER_LNA_GAIN_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0x100000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_USER_BBA_GAIN_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_USER_BBA_GAIN_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0x200000) >> 21
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_PRESLOW_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_PRESLOW_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0x400000) >> 22
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_1_LNA_GAIN_SETTLE_TIME(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_1.Reg, volatile.LoadUint32(&o.AGC_CTRL_1.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_1_LNA_GAIN_SETTLE_TIME() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_1.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.AGC_CTRL_2: AGC Control 2
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_BBA_PDET_RST(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_BBA_PDET_RST() uint32 {
	return volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_TZA_PDET_RST(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_TZA_PDET_RST() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x2) >> 1
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_MAN_PDET_RST(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_MAN_PDET_RST() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x4) >> 2
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_BBA_GAIN_SETTLE_TIME(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0xff0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_BBA_GAIN_SETTLE_TIME() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0xff0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_BBA_PDET_SEL_LO(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_BBA_PDET_SEL_LO() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x7000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_BBA_PDET_SEL_HI(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x38000)|value<<15)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_BBA_PDET_SEL_HI() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x38000) >> 15
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_TZA_PDET_SEL_LO(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x1c0000)|value<<18)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_TZA_PDET_SEL_LO() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x1c0000) >> 18
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_TZA_PDET_SEL_HI(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0xe00000)|value<<21)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_TZA_PDET_SEL_HI() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0xe00000) >> 21
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_AGC_FAST_EXPIRE(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x3f000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_AGC_FAST_EXPIRE() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x3f000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_LNA_LG_ON_OVR(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_LNA_LG_ON_OVR() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x40000000) >> 30
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_2_LNA_HG_ON_OVR(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_2.Reg, volatile.LoadUint32(&o.AGC_CTRL_2.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_2_LNA_HG_ON_OVR() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_2.Reg) & 0x80000000) >> 31
}

// XCVR_RX_DIG.AGC_CTRL_3: AGC Control 3
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_3_AGC_UNFREEZE_TIME(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_3.Reg, volatile.LoadUint32(&o.AGC_CTRL_3.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_3_AGC_UNFREEZE_TIME() uint32 {
	return volatile.LoadUint32(&o.AGC_CTRL_3.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_3_AGC_PDET_LO_DLY(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_3.Reg, volatile.LoadUint32(&o.AGC_CTRL_3.Reg)&^(0xe000)|value<<13)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_3_AGC_PDET_LO_DLY() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_3.Reg) & 0xe000) >> 13
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_3_AGC_RSSI_DELT_H2S(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_3.Reg, volatile.LoadUint32(&o.AGC_CTRL_3.Reg)&^(0x7f0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_3_AGC_RSSI_DELT_H2S() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_3.Reg) & 0x7f0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_3_AGC_H2S_STEP_SZ(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_3.Reg, volatile.LoadUint32(&o.AGC_CTRL_3.Reg)&^(0xf800000)|value<<23)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_3_AGC_H2S_STEP_SZ() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_3.Reg) & 0xf800000) >> 23
}
func (o *XCVR_RX_DIG_Type) SetAGC_CTRL_3_AGC_UP_STEP_SZ(value uint32) {
	volatile.StoreUint32(&o.AGC_CTRL_3.Reg, volatile.LoadUint32(&o.AGC_CTRL_3.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_CTRL_3_AGC_UP_STEP_SZ() uint32 {
	return (volatile.LoadUint32(&o.AGC_CTRL_3.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_STAT: AGC Status
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_BBA_PDET_LO_STAT(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_BBA_PDET_LO_STAT() uint32 {
	return volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_BBA_PDET_HI_STAT(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_BBA_PDET_HI_STAT() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x2) >> 1
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_TZA_PDET_LO_STAT(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_TZA_PDET_LO_STAT() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x4) >> 2
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_TZA_PDET_HI_STAT(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_TZA_PDET_HI_STAT() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_CURR_AGC_IDX(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x1f0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_CURR_AGC_IDX() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x1f0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_AGC_FROZEN(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_AGC_FROZEN() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0x200) >> 9
}
func (o *XCVR_RX_DIG_Type) SetAGC_STAT_RSSI_ADC_RAW(value uint32) {
	volatile.StoreUint32(&o.AGC_STAT.Reg, volatile.LoadUint32(&o.AGC_STAT.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_STAT_RSSI_ADC_RAW() uint32 {
	return (volatile.LoadUint32(&o.AGC_STAT.Reg) & 0xff0000) >> 16
}

// XCVR_RX_DIG.RSSI_CTRL_0: RSSI Control 0
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_USE_VALS(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_USE_VALS() uint32 {
	return volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_HOLD_SRC(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x6)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_HOLD_SRC() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x6) >> 1
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_HOLD_EN(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_HOLD_EN() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_IIR_CW_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x60)|value<<5)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_IIR_CW_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x60) >> 5
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_N_WINDOW_AVG(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_N_WINDOW_AVG() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x300) >> 8
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_HOLD_DELAY(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0xfc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_HOLD_DELAY() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0xfc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_IIR_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_IIR_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_VLD_SETTLE(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0x700000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_VLD_SETTLE() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0x700000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_0_RSSI_ADJ(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_0.Reg, volatile.LoadUint32(&o.RSSI_CTRL_0.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_0_RSSI_ADJ() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_0.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.RSSI_CTRL_1: RSSI Control 1
func (o *XCVR_RX_DIG_Type) SetRSSI_CTRL_1_RSSI_OUT(value uint32) {
	volatile.StoreUint32(&o.RSSI_CTRL_1.Reg, volatile.LoadUint32(&o.RSSI_CTRL_1.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_CTRL_1_RSSI_OUT() uint32 {
	return (volatile.LoadUint32(&o.RSSI_CTRL_1.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.RSSI_DFT: RSSI DFT
func (o *XCVR_RX_DIG_Type) SetRSSI_DFT_DFT_MAG(value uint32) {
	volatile.StoreUint32(&o.RSSI_DFT.Reg, volatile.LoadUint32(&o.RSSI_DFT.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_DFT_DFT_MAG() uint32 {
	return volatile.LoadUint32(&o.RSSI_DFT.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetRSSI_DFT_DFT_NOISE(value uint32) {
	volatile.StoreUint32(&o.RSSI_DFT.Reg, volatile.LoadUint32(&o.RSSI_DFT.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRSSI_DFT_DFT_NOISE() uint32 {
	return (volatile.LoadUint32(&o.RSSI_DFT.Reg) & 0x1fff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CTRL_0: DCOC Control 0
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS() uint32 {
	return volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_MAN(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_MAN() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x2) >> 1
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_TRK_EST_OVR(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_TRK_EST_OVR() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x4) >> 2
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_CORRECT_SRC(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_CORRECT_SRC() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_CORRECT_EN(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_CORRECT_EN() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x10) >> 4
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_TRACK_FROM_ZERO(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_TRACK_FROM_ZERO() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x20) >> 5
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_BBA_CORR_POL(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_BBA_CORR_POL() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x40) >> 6
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_TZA_CORR_POL(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_TZA_CORR_POL() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x80) >> 7
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_CAL_DURATION(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x1f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_CAL_DURATION() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x1f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_CORR_DLY(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x1f0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_CORR_DLY() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x1f0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_0_DCOC_CORR_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_0.Reg, volatile.LoadUint32(&o.DCOC_CTRL_0.Reg)&^(0x7f000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_0_DCOC_CORR_HOLD_TIME() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_0.Reg) & 0x7f000000) >> 24
}

// XCVR_RX_DIG.DCOC_CTRL_1: DCOC Control 1
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_SIGN_SCALE_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x3)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_SIGN_SCALE_IDX() uint32 {
	return volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x3
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x1c)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x1c) >> 2
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0xe0)|value<<5)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0xe0) >> 5
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_TRK_EST_GS_CNT(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_TRK_EST_GS_CNT() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x7000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x30000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x30000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x1c0000)|value<<18)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x1c0000) >> 18
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0xe00000)|value<<21)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0xe00000) >> 21
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CTRL_1.Reg, volatile.LoadUint32(&o.DCOC_CTRL_1.Reg)&^(0x1f000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CTRL_1.Reg) & 0x1f000000) >> 24
}

// XCVR_RX_DIG.DCOC_DAC_INIT: DCOC DAC Initialization
func (o *XCVR_RX_DIG_Type) SetDCOC_DAC_INIT_BBA_DCOC_INIT_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_DAC_INIT.Reg, volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DAC_INIT_BBA_DCOC_INIT_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_DAC_INIT_BBA_DCOC_INIT_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_DAC_INIT.Reg, volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DAC_INIT_BBA_DCOC_INIT_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_DAC_INIT_TZA_DCOC_INIT_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_DAC_INIT.Reg, volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DAC_INIT_TZA_DCOC_INIT_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_DAC_INIT_TZA_DCOC_INIT_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_DAC_INIT.Reg, volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DAC_INIT_TZA_DCOC_INIT_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_DAC_INIT.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_DIG_MAN: DCOC Digital Correction Manual Override
func (o *XCVR_RX_DIG_Type) SetDCOC_DIG_MAN_DIG_DCOC_INIT_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_DIG_MAN.Reg, volatile.LoadUint32(&o.DCOC_DIG_MAN.Reg)&^(0xfff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DIG_MAN_DIG_DCOC_INIT_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_DIG_MAN.Reg) & 0xfff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_DIG_MAN_DIG_DCOC_INIT_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_DIG_MAN.Reg, volatile.LoadUint32(&o.DCOC_DIG_MAN.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DIG_MAN_DIG_DCOC_INIT_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_DIG_MAN.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL_GAIN: DCOC Calibration Gain
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAIN.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAIN.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.DCOC_STAT: DCOC Status
func (o *XCVR_RX_DIG_Type) SetDCOC_STAT_BBA_DCOC_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_STAT.Reg, volatile.LoadUint32(&o.DCOC_STAT.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_STAT_BBA_DCOC_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_STAT.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_STAT_BBA_DCOC_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_STAT.Reg, volatile.LoadUint32(&o.DCOC_STAT.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_STAT_BBA_DCOC_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_STAT.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_STAT_TZA_DCOC_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_STAT.Reg, volatile.LoadUint32(&o.DCOC_STAT.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_STAT_TZA_DCOC_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_STAT.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_STAT_TZA_DCOC_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_STAT.Reg, volatile.LoadUint32(&o.DCOC_STAT.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_STAT_TZA_DCOC_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_STAT.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_DC_EST: DCOC DC Estimate
func (o *XCVR_RX_DIG_Type) SetDCOC_DC_EST_DC_EST_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_DC_EST.Reg, volatile.LoadUint32(&o.DCOC_DC_EST.Reg)&^(0xfff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DC_EST_DC_EST_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_DC_EST.Reg) & 0xfff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_DC_EST_DC_EST_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_DC_EST.Reg, volatile.LoadUint32(&o.DCOC_DC_EST.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_DC_EST_DC_EST_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_DC_EST.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL_RCP: DCOC Calibration Reciprocals
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_RCP_DCOC_TMP_CALC_RECIP(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_RCP.Reg, volatile.LoadUint32(&o.DCOC_CAL_RCP.Reg)&^(0x7ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_RCP_DCOC_TMP_CALC_RECIP() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_RCP.Reg) & 0x7ff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_RCP_ALPHA_CALC_RECIP(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_RCP.Reg, volatile.LoadUint32(&o.DCOC_CAL_RCP.Reg)&^(0x7ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_RCP_ALPHA_CALC_RECIP() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_RCP.Reg) & 0x7ff0000) >> 16
}

// XCVR_RX_DIG.IQMC_CTRL: IQMC Control
func (o *XCVR_RX_DIG_Type) SetIQMC_CTRL_IQMC_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.IQMC_CTRL.Reg, volatile.LoadUint32(&o.IQMC_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_RX_DIG_Type) GetIQMC_CTRL_IQMC_CAL_EN() uint32 {
	return volatile.LoadUint32(&o.IQMC_CTRL.Reg) & 0x1
}
func (o *XCVR_RX_DIG_Type) SetIQMC_CTRL_IQMC_NUM_ITER(value uint32) {
	volatile.StoreUint32(&o.IQMC_CTRL.Reg, volatile.LoadUint32(&o.IQMC_CTRL.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetIQMC_CTRL_IQMC_NUM_ITER() uint32 {
	return (volatile.LoadUint32(&o.IQMC_CTRL.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetIQMC_CTRL_IQMC_DC_GAIN_ADJ(value uint32) {
	volatile.StoreUint32(&o.IQMC_CTRL.Reg, volatile.LoadUint32(&o.IQMC_CTRL.Reg)&^(0x7ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetIQMC_CTRL_IQMC_DC_GAIN_ADJ() uint32 {
	return (volatile.LoadUint32(&o.IQMC_CTRL.Reg) & 0x7ff0000) >> 16
}

// XCVR_RX_DIG.IQMC_CAL: IQMC Calibration
func (o *XCVR_RX_DIG_Type) SetIQMC_CAL_IQMC_GAIN_ADJ(value uint32) {
	volatile.StoreUint32(&o.IQMC_CAL.Reg, volatile.LoadUint32(&o.IQMC_CAL.Reg)&^(0x7ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetIQMC_CAL_IQMC_GAIN_ADJ() uint32 {
	return volatile.LoadUint32(&o.IQMC_CAL.Reg) & 0x7ff
}
func (o *XCVR_RX_DIG_Type) SetIQMC_CAL_IQMC_PHASE_ADJ(value uint32) {
	volatile.StoreUint32(&o.IQMC_CAL.Reg, volatile.LoadUint32(&o.IQMC_CAL.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetIQMC_CAL_IQMC_PHASE_ADJ() uint32 {
	return (volatile.LoadUint32(&o.IQMC_CAL.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.LNA_GAIN_VAL_3_0: LNA_GAIN Step Values 3..0
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_3_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_3_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_3_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_3_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_3_0.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.LNA_GAIN_VAL_7_4: LNA_GAIN Step Values 7..4
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_7_4.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_7_4.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_7_4.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_7_4.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_7_4.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.LNA_GAIN_VAL_8: LNA_GAIN Step Values 8
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_8(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_8.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_8.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_8() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_VAL_8.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_VAL_8_LNA_GAIN_VAL_9(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_VAL_8.Reg, volatile.LoadUint32(&o.LNA_GAIN_VAL_8.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_VAL_8_LNA_GAIN_VAL_9() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_VAL_8.Reg) & 0xff00) >> 8
}

// XCVR_RX_DIG.BBA_RES_TUNE_VAL_7_0: BBA Resistor Tune Values 7..0
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0() uint32 {
	return volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_7_0.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.BBA_RES_TUNE_VAL_10_8: BBA Resistor Tune Values 10..8
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8() uint32 {
	return volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_VAL_10_8.Reg) & 0xf00) >> 8
}

// XCVR_RX_DIG.LNA_GAIN_LIN_VAL_2_0: LNA Linear Gain Values 2..0
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg)&^(0xffc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg) & 0xffc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg)&^(0x3ff00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_2_0.Reg) & 0x3ff00000) >> 20
}

// XCVR_RX_DIG.LNA_GAIN_LIN_VAL_5_3: LNA Linear Gain Values 5..3
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg)&^(0xffc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg) & 0xffc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg)&^(0x3ff00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_5_3.Reg) & 0x3ff00000) >> 20
}

// XCVR_RX_DIG.LNA_GAIN_LIN_VAL_8_6: LNA Linear Gain Values 8..6
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg)&^(0xffc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg) & 0xffc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg)&^(0x3ff00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8() uint32 {
	return (volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_8_6.Reg) & 0x3ff00000) >> 20
}

// XCVR_RX_DIG.LNA_GAIN_LIN_VAL_9: LNA Linear Gain Values 9
func (o *XCVR_RX_DIG_Type) SetLNA_GAIN_LIN_VAL_9(value uint32) {
	volatile.StoreUint32(&o.LNA_GAIN_LIN_VAL_9.Reg, volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_9.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetLNA_GAIN_LIN_VAL_9() uint32 {
	return volatile.LoadUint32(&o.LNA_GAIN_LIN_VAL_9.Reg) & 0x3ff
}

// XCVR_RX_DIG.BBA_RES_TUNE_LIN_VAL_3_0: BBA Resistor Tune Values 3..0
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0() uint32 {
	return volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_3_0.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.BBA_RES_TUNE_LIN_VAL_7_4: BBA Resistor Tune Values 7..4
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4() uint32 {
	return volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_7_4.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.BBA_RES_TUNE_LIN_VAL_10_8: BBA Resistor Tune Values 10..8
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8() uint32 {
	return volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg)&^(0xffc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg) & 0xffc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10(value uint32) {
	volatile.StoreUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg, volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg)&^(0x3ff00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetBBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10() uint32 {
	return (volatile.LoadUint32(&o.BBA_RES_TUNE_LIN_VAL_10_8.Reg) & 0x3ff00000) >> 20
}

// XCVR_RX_DIG.AGC_GAIN_TBL_03_00: AGC Gain Tables Step 03..00
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_BBA_GAIN_00(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_BBA_GAIN_00() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_LNA_GAIN_00(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_LNA_GAIN_00() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_BBA_GAIN_01(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_BBA_GAIN_01() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_LNA_GAIN_01(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_LNA_GAIN_01() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_BBA_GAIN_02(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_BBA_GAIN_02() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_LNA_GAIN_02(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_LNA_GAIN_02() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_BBA_GAIN_03(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_BBA_GAIN_03() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_03_00_LNA_GAIN_03(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_03_00.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_03_00_LNA_GAIN_03() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_03_00.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_07_04: AGC Gain Tables Step 07..04
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_BBA_GAIN_04(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_BBA_GAIN_04() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_LNA_GAIN_04(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_LNA_GAIN_04() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_BBA_GAIN_05(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_BBA_GAIN_05() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_LNA_GAIN_05(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_LNA_GAIN_05() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_BBA_GAIN_06(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_BBA_GAIN_06() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_LNA_GAIN_06(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_LNA_GAIN_06() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_BBA_GAIN_07(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_BBA_GAIN_07() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_07_04_LNA_GAIN_07(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_07_04.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_07_04_LNA_GAIN_07() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_07_04.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_11_08: AGC Gain Tables Step 11..08
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_BBA_GAIN_08(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_BBA_GAIN_08() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_LNA_GAIN_08(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_LNA_GAIN_08() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_BBA_GAIN_09(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_BBA_GAIN_09() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_LNA_GAIN_09(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_LNA_GAIN_09() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_BBA_GAIN_10(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_BBA_GAIN_10() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_LNA_GAIN_10(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_LNA_GAIN_10() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_BBA_GAIN_11(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_BBA_GAIN_11() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_11_08_LNA_GAIN_11(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_11_08.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_11_08_LNA_GAIN_11() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_11_08.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_15_12: AGC Gain Tables Step 15..12
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_BBA_GAIN_12(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_BBA_GAIN_12() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_LNA_GAIN_12(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_LNA_GAIN_12() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_BBA_GAIN_13(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_BBA_GAIN_13() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_LNA_GAIN_13(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_LNA_GAIN_13() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_BBA_GAIN_14(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_BBA_GAIN_14() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_LNA_GAIN_14(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_LNA_GAIN_14() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_BBA_GAIN_15(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_BBA_GAIN_15() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_15_12_LNA_GAIN_15(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_15_12.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_15_12_LNA_GAIN_15() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_15_12.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_19_16: AGC Gain Tables Step 19..16
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_BBA_GAIN_16(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_BBA_GAIN_16() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_LNA_GAIN_16(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_LNA_GAIN_16() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_BBA_GAIN_17(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_BBA_GAIN_17() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_LNA_GAIN_17(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_LNA_GAIN_17() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_BBA_GAIN_18(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_BBA_GAIN_18() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_LNA_GAIN_18(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_LNA_GAIN_18() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_BBA_GAIN_19(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_BBA_GAIN_19() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_19_16_LNA_GAIN_19(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_19_16.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_19_16_LNA_GAIN_19() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_19_16.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_23_20: AGC Gain Tables Step 23..20
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_BBA_GAIN_20(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_BBA_GAIN_20() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_LNA_GAIN_20(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_LNA_GAIN_20() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_BBA_GAIN_21(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_BBA_GAIN_21() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_LNA_GAIN_21(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_LNA_GAIN_21() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_BBA_GAIN_22(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_BBA_GAIN_22() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_LNA_GAIN_22(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_LNA_GAIN_22() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_BBA_GAIN_23(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_BBA_GAIN_23() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_23_20_LNA_GAIN_23(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_23_20.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_23_20_LNA_GAIN_23() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_23_20.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.AGC_GAIN_TBL_26_24: AGC Gain Tables Step 26..24
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_BBA_GAIN_24(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_BBA_GAIN_24() uint32 {
	return volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_LNA_GAIN_24(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_LNA_GAIN_24() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_BBA_GAIN_25(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_BBA_GAIN_25() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_LNA_GAIN_25(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_LNA_GAIN_25() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_BBA_GAIN_26(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_BBA_GAIN_26() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_GAIN_TBL_26_24_LNA_GAIN_26(value uint32) {
	volatile.StoreUint32(&o.AGC_GAIN_TBL_26_24.Reg, volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg)&^(0xf00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetAGC_GAIN_TBL_26_24_LNA_GAIN_26() uint32 {
	return (volatile.LoadUint32(&o.AGC_GAIN_TBL_26_24.Reg) & 0xf00000) >> 20
}

// XCVR_RX_DIG.DCOC_OFFSET_0: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_0_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_0.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_0_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_0_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_0.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_0_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_0_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_0.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_0_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_0_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_0.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_0_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_0.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_1: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_1_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_1.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_1_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_1_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_1.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_1_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_1_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_1.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_1_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_1_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_1.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_1_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_1.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_2: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_2_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_2.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_2_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_2_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_2.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_2_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_2_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_2.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_2_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_2_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_2.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_2_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_2.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_3: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_3_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_3.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_3_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_3_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_3.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_3_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_3_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_3.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_3_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_3_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_3.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_3_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_3.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_4: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_4_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_4.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_4_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_4_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_4.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_4_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_4_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_4.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_4_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_4_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_4.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_4_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_4.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_5: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_5_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_5.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_5_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_5_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_5.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_5_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_5_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_5.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_5_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_5_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_5.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_5_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_5.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_6: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_6_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_6.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_6_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_6_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_6.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_6_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_6_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_6.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_6_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_6_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_6.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_6_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_6.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_7: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_7_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_7.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_7_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_7_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_7.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_7_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_7_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_7.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_7_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_7_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_7.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_7_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_7.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_8: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_8_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_8.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_8_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_8_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_8.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_8_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_8_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_8.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_8_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_8_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_8.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_8_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_8.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_9: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_9_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_9.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_9_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_9_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_9.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_9_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_9_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_9.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_9_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_9_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_9.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_9_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_9.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_10: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_10_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_10.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_10_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_10_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_10.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_10_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_10_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_10.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_10_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_10_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_10.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_10_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_10.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_11: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_11_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_11.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_11_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_11_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_11.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_11_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_11_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_11.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_11_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_11_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_11.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_11_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_11.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_12: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_12_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_12.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_12_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_12_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_12.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_12_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_12_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_12.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_12_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_12_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_12.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_12_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_12.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_13: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_13_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_13.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_13_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_13_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_13.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_13_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_13_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_13.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_13_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_13_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_13.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_13_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_13.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_14: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_14_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_14.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_14_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_14_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_14.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_14_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_14_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_14.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_14_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_14_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_14.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_14_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_14.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_15: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_15_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_15.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_15_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_15_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_15.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_15_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_15_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_15.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_15_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_15_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_15.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_15_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_15.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_16: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_16_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_16.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_16_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_16_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_16.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_16_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_16_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_16.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_16_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_16_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_16.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_16_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_16.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_17: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_17_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_17.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_17_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_17_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_17.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_17_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_17_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_17.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_17_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_17_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_17.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_17_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_17.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_18: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_18_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_18.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_18_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_18_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_18.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_18_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_18_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_18.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_18_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_18_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_18.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_18_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_18.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_19: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_19_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_19.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_19_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_19_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_19.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_19_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_19_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_19.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_19_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_19_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_19.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_19_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_19.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_20: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_20_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_20.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_20_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_20_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_20.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_20_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_20_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_20.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_20_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_20_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_20.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_20_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_20.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_21: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_21_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_21.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_21_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_21_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_21.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_21_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_21_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_21.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_21_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_21_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_21.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_21_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_21.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_22: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_22_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_22.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_22_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_22_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_22.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_22_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_22_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_22.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_22_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_22_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_22.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_22_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_22.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_23: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_23_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_23.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_23_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_23_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_23.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_23_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_23_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_23.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_23_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_23_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_23.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_23_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_23.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_24: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_24_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_24.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_24_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_24_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_24.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_24_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_24_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_24.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_24_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_24_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_24.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_24_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_24.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_25: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_25_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_25.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_25_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_25_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_25.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_25_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_25_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_25.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_25_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_25_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_25.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_25_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_25.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_OFFSET_26: DCOC Offset
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_26_DCOC_BBA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_26.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_26_DCOC_BBA_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_26_DCOC_BBA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_26.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_26_DCOC_BBA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg) & 0x3f00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_26_DCOC_TZA_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_26.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_26_DCOC_TZA_OFFSET_I() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDCOC_OFFSET_26_DCOC_TZA_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_OFFSET_26.Reg, volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_OFFSET_26_DCOC_TZA_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_OFFSET_26.Reg) & 0xff000000) >> 24
}

// XCVR_RX_DIG.DCOC_BBA_STEP: DCOC BBA DAC Step
func (o *XCVR_RX_DIG_Type) SetDCOC_BBA_STEP_BBA_DCOC_STEP_RECIP(value uint32) {
	volatile.StoreUint32(&o.DCOC_BBA_STEP.Reg, volatile.LoadUint32(&o.DCOC_BBA_STEP.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_BBA_STEP_BBA_DCOC_STEP_RECIP() uint32 {
	return volatile.LoadUint32(&o.DCOC_BBA_STEP.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_BBA_STEP_BBA_DCOC_STEP(value uint32) {
	volatile.StoreUint32(&o.DCOC_BBA_STEP.Reg, volatile.LoadUint32(&o.DCOC_BBA_STEP.Reg)&^(0x1ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_BBA_STEP_BBA_DCOC_STEP() uint32 {
	return (volatile.LoadUint32(&o.DCOC_BBA_STEP.Reg) & 0x1ff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_0: DCOC TZA DAC Step 0
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_0.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_0.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_0.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_0.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_0.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_0.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_1: DCOC TZA DAC Step 1
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_1.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_1.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_1.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_1.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_1.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_1.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_2: DCOC TZA DAC Step 2
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_2.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_2.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_2.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_2.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_2.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_2.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_3: DCOC TZA DAC Step 3
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_3.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_3.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_3.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_3.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_3.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_3.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_4: DCOC TZA DAC Step 4
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_4.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_4.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_4.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_4.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_4.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_4.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_5: DCOC TZA DAC Step 5
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_5.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_5.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_5.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_5.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_5.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_5.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_6: DCOC TZA DAC Step 6
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_6.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_6.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_6.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_6.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_6.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_6.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_7: DCOC TZA DAC Step 7
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_7.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_7.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_7.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_7.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_7.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_7.Reg) & 0x1fff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_8: DCOC TZA DAC Step 5
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_8.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_8.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_8.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_8.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_8.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_8.Reg) & 0x1fff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_9: DCOC TZA DAC Step 9
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_9.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_9.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_9.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_9.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_9.Reg)&^(0x3fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_9.Reg) & 0x3fff0000) >> 16
}

// XCVR_RX_DIG.DCOC_TZA_STEP_10: DCOC TZA DAC Step 10
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_10.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_10.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10() uint32 {
	return volatile.LoadUint32(&o.DCOC_TZA_STEP_10.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10(value uint32) {
	volatile.StoreUint32(&o.DCOC_TZA_STEP_10.Reg, volatile.LoadUint32(&o.DCOC_TZA_STEP_10.Reg)&^(0x3fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10() uint32 {
	return (volatile.LoadUint32(&o.DCOC_TZA_STEP_10.Reg) & 0x3fff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL_ALPHA: DCOC Calibration Alpha
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_ALPHA.Reg, volatile.LoadUint32(&o.DCOC_CAL_ALPHA.Reg)&^(0x7ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_ALPHA.Reg) & 0x7ff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_ALPHA.Reg, volatile.LoadUint32(&o.DCOC_CAL_ALPHA.Reg)&^(0x7ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_ALPHA.Reg) & 0x7ff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL_BETA_Q: DCOC Calibration Beta Q
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_BETA_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_BETA_Q.Reg, volatile.LoadUint32(&o.DCOC_CAL_BETA_Q.Reg)&^(0x1ffff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_BETA_Q() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_BETA_Q.Reg) & 0x1ffff
}

// XCVR_RX_DIG.DCOC_CAL_BETA_I: DCOC Calibration Beta I
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_BETA_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_BETA_I.Reg, volatile.LoadUint32(&o.DCOC_CAL_BETA_I.Reg)&^(0x1ffff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_BETA_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_BETA_I.Reg) & 0x1ffff
}

// XCVR_RX_DIG.DCOC_CAL_GAMMA: DCOC Calibration Gamma
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAMMA.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAMMA.Reg)&^(0xffff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_GAMMA.Reg) & 0xffff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_GAMMA.Reg, volatile.LoadUint32(&o.DCOC_CAL_GAMMA.Reg)&^(0xffff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_GAMMA.Reg) & 0xffff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL_IIR: DCOC Calibration IIR
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_IIR.Reg, volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg)&^(0x3)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg) & 0x3
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_IIR.Reg, volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg)&^(0xc)|value<<2)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg) & 0xc) >> 2
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL_IIR.Reg, volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg)&^(0x30)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL_IIR.Reg) & 0x30) >> 4
}

// XCVR_RX_DIG.DCOC_CAL1: DCOC Calibration Result
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL1_DCOC_CAL_RES_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL1.Reg, volatile.LoadUint32(&o.DCOC_CAL1.Reg)&^(0xfff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL1_DCOC_CAL_RES_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL1.Reg) & 0xfff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL1_DCOC_CAL_RES_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL1.Reg, volatile.LoadUint32(&o.DCOC_CAL1.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL1_DCOC_CAL_RES_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL1.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL2: DCOC Calibration Result
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL2_DCOC_CAL_RES_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL2.Reg, volatile.LoadUint32(&o.DCOC_CAL2.Reg)&^(0xfff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL2_DCOC_CAL_RES_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL2.Reg) & 0xfff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL2_DCOC_CAL_RES_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL2.Reg, volatile.LoadUint32(&o.DCOC_CAL2.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL2_DCOC_CAL_RES_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL2.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.DCOC_CAL3: DCOC Calibration Result
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL3_DCOC_CAL_RES_I(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL3.Reg, volatile.LoadUint32(&o.DCOC_CAL3.Reg)&^(0xfff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL3_DCOC_CAL_RES_I() uint32 {
	return volatile.LoadUint32(&o.DCOC_CAL3.Reg) & 0xfff
}
func (o *XCVR_RX_DIG_Type) SetDCOC_CAL3_DCOC_CAL_RES_Q(value uint32) {
	volatile.StoreUint32(&o.DCOC_CAL3.Reg, volatile.LoadUint32(&o.DCOC_CAL3.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDCOC_CAL3_DCOC_CAL_RES_Q() uint32 {
	return (volatile.LoadUint32(&o.DCOC_CAL3.Reg) & 0xfff0000) >> 16
}

// XCVR_RX_DIG.CCA_ED_LQI_CTRL_0: RX_DIG CCA ED LQI Control Register 0
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_0_LQI_CORR_THRESH(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_0_LQI_CORR_THRESH() uint32 {
	return volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_0_LQI_CNTR(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_0_LQI_CNTR() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_0_SNR_ADJ(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg)&^(0x3f000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_0_SNR_ADJ() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_0.Reg) & 0x3f000000) >> 24
}

// XCVR_RX_DIG.CCA_ED_LQI_CTRL_1: RX_DIG CCA ED LQI Control Register 1
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY() uint32 {
	return volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x3f
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x1c0)|value<<6)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x1c0) >> 6
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0xe00)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0xe00) >> 9
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_LQI_RSSI_SENS(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_LQI_RSSI_SENS() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0xf000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_SNR_LQI_DIS(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_SNR_LQI_DIS() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x10000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_SEL_SNR_MODE(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_SEL_SNR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x20000) >> 17
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x40000) >> 18
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x80000) >> 19
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x100000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_MAN_AA_MATCH(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_MAN_AA_MATCH() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0x200000) >> 21
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0xf000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_CTRL_1_LQI_BIAS(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_CTRL_1.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_CTRL_1_LQI_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_CTRL_1.Reg) & 0xf0000000) >> 28
}

// XCVR_RX_DIG.CCA_ED_LQI_STAT_0: RX_DIG CCA ED LQI Status Register 0
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_STAT_0_LQI_OUT(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_STAT_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_STAT_0_LQI_OUT() uint32 {
	return volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg) & 0xff
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_STAT_0_ED_OUT(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_STAT_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_STAT_0_ED_OUT() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg) & 0xff00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_STAT_0_SNR_OUT(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_STAT_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_STAT_0_SNR_OUT() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg) & 0xff0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_STAT_0_CCA1_STATE(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_STAT_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_STAT_0_CCA1_STATE() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg) & 0x1000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetCCA_ED_LQI_STAT_0_MEAS_COMPLETE(value uint32) {
	volatile.StoreUint32(&o.CCA_ED_LQI_STAT_0.Reg, volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_RX_DIG_Type) GetCCA_ED_LQI_STAT_0_MEAS_COMPLETE() uint32 {
	return (volatile.LoadUint32(&o.CCA_ED_LQI_STAT_0.Reg) & 0x2000000) >> 25
}

// XCVR_RX_DIG.RX_CHF_COEF_0: Receive Channel Filter Coefficient 0
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_0_RX_CH_FILT_H0(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_0.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_0.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_0_RX_CH_FILT_H0() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_0.Reg) & 0x3f
}

// XCVR_RX_DIG.RX_CHF_COEF_1: Receive Channel Filter Coefficient 1
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_1_RX_CH_FILT_H1(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_1.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_1.Reg)&^(0x3f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_1_RX_CH_FILT_H1() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_1.Reg) & 0x3f
}

// XCVR_RX_DIG.RX_CHF_COEF_2: Receive Channel Filter Coefficient 2
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_2_RX_CH_FILT_H2(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_2.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_2.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_2_RX_CH_FILT_H2() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_2.Reg) & 0x7f
}

// XCVR_RX_DIG.RX_CHF_COEF_3: Receive Channel Filter Coefficient 3
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_3_RX_CH_FILT_H3(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_3.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_3.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_3_RX_CH_FILT_H3() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_3.Reg) & 0x7f
}

// XCVR_RX_DIG.RX_CHF_COEF_4: Receive Channel Filter Coefficient 4
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_4_RX_CH_FILT_H4(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_4.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_4.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_4_RX_CH_FILT_H4() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_4.Reg) & 0x7f
}

// XCVR_RX_DIG.RX_CHF_COEF_5: Receive Channel Filter Coefficient 5
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_5_RX_CH_FILT_H5(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_5.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_5.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_5_RX_CH_FILT_H5() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_5.Reg) & 0x7f
}

// XCVR_RX_DIG.RX_CHF_COEF_6: Receive Channel Filter Coefficient 6
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_6_RX_CH_FILT_H6(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_6.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_6.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_6_RX_CH_FILT_H6() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_6.Reg) & 0xff
}

// XCVR_RX_DIG.RX_CHF_COEF_7: Receive Channel Filter Coefficient 7
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_7_RX_CH_FILT_H7(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_7.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_7.Reg)&^(0xff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_7_RX_CH_FILT_H7() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_7.Reg) & 0xff
}

// XCVR_RX_DIG.RX_CHF_COEF_8: Receive Channel Filter Coefficient 8
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_8_RX_CH_FILT_H8(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_8.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_8.Reg)&^(0x1ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_8_RX_CH_FILT_H8() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_8.Reg) & 0x1ff
}

// XCVR_RX_DIG.RX_CHF_COEF_9: Receive Channel Filter Coefficient 9
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_9_RX_CH_FILT_H9(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_9.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_9.Reg)&^(0x1ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_9_RX_CH_FILT_H9() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_9.Reg) & 0x1ff
}

// XCVR_RX_DIG.RX_CHF_COEF_10: Receive Channel Filter Coefficient 10
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_10_RX_CH_FILT_H10(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_10.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_10.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_10_RX_CH_FILT_H10() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_10.Reg) & 0x3ff
}

// XCVR_RX_DIG.RX_CHF_COEF_11: Receive Channel Filter Coefficient 11
func (o *XCVR_RX_DIG_Type) SetRX_CHF_COEF_11_RX_CH_FILT_H11(value uint32) {
	volatile.StoreUint32(&o.RX_CHF_COEF_11.Reg, volatile.LoadUint32(&o.RX_CHF_COEF_11.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_CHF_COEF_11_RX_CH_FILT_H11() uint32 {
	return volatile.LoadUint32(&o.RX_CHF_COEF_11.Reg) & 0x3ff
}

// XCVR_RX_DIG.AGC_MAN_AGC_IDX: AGC Manual AGC Index
func (o *XCVR_RX_DIG_Type) SetAGC_MAN_AGC_IDX_AGC_MAN_IDX(value uint32) {
	volatile.StoreUint32(&o.AGC_MAN_AGC_IDX.Reg, volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg)&^(0x1f0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAGC_MAN_AGC_IDX_AGC_MAN_IDX() uint32 {
	return (volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg) & 0x1f0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetAGC_MAN_AGC_IDX_AGC_MAN_IDX_EN(value uint32) {
	volatile.StoreUint32(&o.AGC_MAN_AGC_IDX.Reg, volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetAGC_MAN_AGC_IDX_AGC_MAN_IDX_EN() uint32 {
	return (volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg) & 0x1000000) >> 24
}
func (o *XCVR_RX_DIG_Type) SetAGC_MAN_AGC_IDX_AGC_DCOC_START_PT(value uint32) {
	volatile.StoreUint32(&o.AGC_MAN_AGC_IDX.Reg, volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_RX_DIG_Type) GetAGC_MAN_AGC_IDX_AGC_DCOC_START_PT() uint32 {
	return (volatile.LoadUint32(&o.AGC_MAN_AGC_IDX.Reg) & 0x2000000) >> 25
}

// XCVR_RX_DIG.DC_RESID_CTRL: DC Residual Control
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_NWIN(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_NWIN() uint32 {
	return volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0x7f
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_ITER_FREEZE(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_ITER_FREEZE() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0xf00) >> 8
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_ALPHA(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0x7000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_DLY(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0x70000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_DLY() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0x70000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_EXT_DC_EN(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_EXT_DC_EN() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0x100000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_CTRL_DC_RESID_MIN_AGC_IDX(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_CTRL.Reg, volatile.LoadUint32(&o.DC_RESID_CTRL.Reg)&^(0x1f000000)|value<<24)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_CTRL_DC_RESID_MIN_AGC_IDX() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_CTRL.Reg) & 0x1f000000) >> 24
}

// XCVR_RX_DIG.DC_RESID_EST: DC Residual Estimate
func (o *XCVR_RX_DIG_Type) SetDC_RESID_EST_DC_RESID_OFFSET_I(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_EST.Reg, volatile.LoadUint32(&o.DC_RESID_EST.Reg)&^(0x1fff)|value)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_EST_DC_RESID_OFFSET_I() uint32 {
	return volatile.LoadUint32(&o.DC_RESID_EST.Reg) & 0x1fff
}
func (o *XCVR_RX_DIG_Type) SetDC_RESID_EST_DC_RESID_OFFSET_Q(value uint32) {
	volatile.StoreUint32(&o.DC_RESID_EST.Reg, volatile.LoadUint32(&o.DC_RESID_EST.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetDC_RESID_EST_DC_RESID_OFFSET_Q() uint32 {
	return (volatile.LoadUint32(&o.DC_RESID_EST.Reg) & 0x1fff0000) >> 16
}

// XCVR_RX_DIG.RX_RCCAL_CTRL0: RX RC Calibration Control0
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_BBA_RCCAL_OFFSET(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_BBA_RCCAL_OFFSET() uint32 {
	return volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_BBA_RCCAL_MANUAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x1f0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_BBA_RCCAL_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x1f0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_BBA_RCCAL_DIS(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_BBA_RCCAL_DIS() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x200) >> 9
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_RCCAL_SMP_DLY(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x3000)|value<<12)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_RCCAL_SMP_DLY() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x3000) >> 12
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_RCCAL_COMP_INV(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_RCCAL_COMP_INV() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x8000) >> 15
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_TZA_RCCAL_OFFSET(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_TZA_RCCAL_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_TZA_RCCAL_MANUAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x1f00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_TZA_RCCAL_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x1f00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL0_TZA_RCCAL_DIS(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL0.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL0_TZA_RCCAL_DIS() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL0.Reg) & 0x2000000) >> 25
}

// XCVR_RX_DIG.RX_RCCAL_CTRL1: RX RC Calibration Control1
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_ADC_RCCAL_OFFSET(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0xf)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_ADC_RCCAL_OFFSET() uint32 {
	return volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0xf
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_ADC_RCCAL_MANUAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0x1f0)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_ADC_RCCAL_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0x1f0) >> 4
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_ADC_RCCAL_DIS(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_ADC_RCCAL_DIS() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0x200) >> 9
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0xf0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0x1f00000)|value<<20)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0x1f00000) >> 20
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_CTRL1_BBA2_RCCAL_DIS(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_CTRL1.Reg, volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_CTRL1_BBA2_RCCAL_DIS() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_CTRL1.Reg) & 0x2000000) >> 25
}

// XCVR_RX_DIG.RX_RCCAL_STAT: RX RC Calibration Status
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_STAT_RCCAL_CODE(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_STAT.Reg, volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg)&^(0x1f)|value)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_STAT_RCCAL_CODE() uint32 {
	return volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg) & 0x1f
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_STAT_ADC_RCCAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_STAT.Reg, volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg)&^(0x3e0)|value<<5)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_STAT_ADC_RCCAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg) & 0x3e0) >> 5
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_STAT_BBA2_RCCAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_STAT.Reg, volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg)&^(0x7c00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_STAT_BBA2_RCCAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg) & 0x7c00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_STAT_BBA_RCCAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_STAT.Reg, volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg)&^(0x1f0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_STAT_BBA_RCCAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg) & 0x1f0000) >> 16
}
func (o *XCVR_RX_DIG_Type) SetRX_RCCAL_STAT_TZA_RCCAL(value uint32) {
	volatile.StoreUint32(&o.RX_RCCAL_STAT.Reg, volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg)&^(0x3e00000)|value<<21)
}
func (o *XCVR_RX_DIG_Type) GetRX_RCCAL_STAT_TZA_RCCAL() uint32 {
	return (volatile.LoadUint32(&o.RX_RCCAL_STAT.Reg) & 0x3e00000) >> 21
}

// XCVR_RX_DIG.AUXPLL_FCAL_CTRL: Aux PLL Frequency Calibration Control
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0x7f)|value)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL() uint32 {
	return volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0x7f
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_FCAL_RUN_CNT(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_FCAL_RUN_CNT() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0x100) >> 8
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_FCAL_COMP_INV(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_FCAL_COMP_INV() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0x200) >> 9
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_FCAL_SMP_DLY(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_FCAL_SMP_DLY() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0xc00) >> 10
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CTRL_DAC_CAL_ADJUST(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CTRL.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg)&^(0x7f0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CTRL_DAC_CAL_ADJUST() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CTRL.Reg) & 0x7f0000) >> 16
}

// XCVR_RX_DIG.AUXPLL_FCAL_CNT6: Aux PLL Frequency Calibration Count 6
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT6_FCAL_COUNT_6(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT6.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT6.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT6_FCAL_COUNT_6() uint32 {
	return volatile.LoadUint32(&o.AUXPLL_FCAL_CNT6.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT6_FCAL_BESTDIFF(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT6.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT6_FCAL_BESTDIFF() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CNT6.Reg) & 0x3ff0000) >> 16
}

// XCVR_RX_DIG.AUXPLL_FCAL_CNT5_4: Aux PLL Frequency Calibration Count 5 and 4
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT5_4_FCAL_COUNT_4(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT5_4.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT5_4.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT5_4_FCAL_COUNT_4() uint32 {
	return volatile.LoadUint32(&o.AUXPLL_FCAL_CNT5_4.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT5_4_FCAL_COUNT_5(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT5_4.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT5_4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT5_4_FCAL_COUNT_5() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CNT5_4.Reg) & 0x3ff0000) >> 16
}

// XCVR_RX_DIG.AUXPLL_FCAL_CNT3_2: Aux PLL Frequency Calibration Count 3 and 2
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT3_2_FCAL_COUNT_2(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT3_2.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT3_2.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT3_2_FCAL_COUNT_2() uint32 {
	return volatile.LoadUint32(&o.AUXPLL_FCAL_CNT3_2.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT3_2_FCAL_COUNT_3(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT3_2.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT3_2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT3_2_FCAL_COUNT_3() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CNT3_2.Reg) & 0x3ff0000) >> 16
}

// XCVR_RX_DIG.AUXPLL_FCAL_CNT1_0: Aux PLL Frequency Calibration Count 1 and 0
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT1_0_FCAL_COUNT_0(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT1_0.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT1_0.Reg)&^(0x3ff)|value)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT1_0_FCAL_COUNT_0() uint32 {
	return volatile.LoadUint32(&o.AUXPLL_FCAL_CNT1_0.Reg) & 0x3ff
}
func (o *XCVR_RX_DIG_Type) SetAUXPLL_FCAL_CNT1_0_FCAL_COUNT_1(value uint32) {
	volatile.StoreUint32(&o.AUXPLL_FCAL_CNT1_0.Reg, volatile.LoadUint32(&o.AUXPLL_FCAL_CNT1_0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *XCVR_RX_DIG_Type) GetAUXPLL_FCAL_CNT1_0_FCAL_COUNT_1() uint32 {
	return (volatile.LoadUint32(&o.AUXPLL_FCAL_CNT1_0.Reg) & 0x3ff0000) >> 16
}

// XCVR_RX_DIG.RXDIG_DFT: RXDIG DFT
func (o *XCVR_RX_DIG_Type) SetRXDIG_DFT_DFT_TONE_FREQ(value uint32) {
	volatile.StoreUint32(&o.RXDIG_DFT.Reg, volatile.LoadUint32(&o.RXDIG_DFT.Reg)&^(0x7)|value)
}
func (o *XCVR_RX_DIG_Type) GetRXDIG_DFT_DFT_TONE_FREQ() uint32 {
	return volatile.LoadUint32(&o.RXDIG_DFT.Reg) & 0x7
}
func (o *XCVR_RX_DIG_Type) SetRXDIG_DFT_DFT_TONE_SCALE(value uint32) {
	volatile.StoreUint32(&o.RXDIG_DFT.Reg, volatile.LoadUint32(&o.RXDIG_DFT.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_RX_DIG_Type) GetRXDIG_DFT_DFT_TONE_SCALE() uint32 {
	return (volatile.LoadUint32(&o.RXDIG_DFT.Reg) & 0x8) >> 3
}
func (o *XCVR_RX_DIG_Type) SetRXDIG_DFT_DFT_TONE_TZA_EN(value uint32) {
	volatile.StoreUint32(&o.RXDIG_DFT.Reg, volatile.LoadUint32(&o.RXDIG_DFT.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_RX_DIG_Type) GetRXDIG_DFT_DFT_TONE_TZA_EN() uint32 {
	return (volatile.LoadUint32(&o.RXDIG_DFT.Reg) & 0x10) >> 4
}
func (o *XCVR_RX_DIG_Type) SetRXDIG_DFT_DFT_TONE_BBA_EN(value uint32) {
	volatile.StoreUint32(&o.RXDIG_DFT.Reg, volatile.LoadUint32(&o.RXDIG_DFT.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_RX_DIG_Type) GetRXDIG_DFT_DFT_TONE_BBA_EN() uint32 {
	return (volatile.LoadUint32(&o.RXDIG_DFT.Reg) & 0x20) >> 5
}

// XCVR_TX_DIG
type XCVR_TX_DIG_Type struct {
	CTRL          volatile.Register32 // 0x0
	DATA_PADDING  volatile.Register32 // 0x4
	GFSK_CTRL     volatile.Register32 // 0x8
	GFSK_COEFF2   volatile.Register32 // 0xC
	GFSK_COEFF1   volatile.Register32 // 0x10
	FSK_SCALE     volatile.Register32 // 0x14
	DFT_PATTERN   volatile.Register32 // 0x18
	RF_DFT_BIST_1 volatile.Register32 // 0x1C
	RF_DFT_BIST_2 volatile.Register32 // 0x20
}

// XCVR_TX_DIG.CTRL: TX Digital Control
func (o *XCVR_TX_DIG_Type) SetCTRL_RADIO_DFT_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf)|value)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_RADIO_DFT_MODE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xf
}
func (o *XCVR_TX_DIG_Type) SetCTRL_LFSR_LENGTH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_LFSR_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x70) >> 4
}
func (o *XCVR_TX_DIG_Type) SetCTRL_LFSR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_LFSR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_TX_DIG_Type) SetCTRL_DFT_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x700)|value<<8)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_DFT_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x700) >> 8
}
func (o *XCVR_TX_DIG_Type) SetCTRL_TX_DFT_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_TX_DFT_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_TX_DIG_Type) SetCTRL_SOC_TEST_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_SOC_TEST_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3000) >> 12
}
func (o *XCVR_TX_DIG_Type) SetCTRL_TX_CAPTURE_POL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_TX_CAPTURE_POL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *XCVR_TX_DIG_Type) SetCTRL_FREQ_WORD_ADJ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffc00000)|value<<22)
}
func (o *XCVR_TX_DIG_Type) GetCTRL_FREQ_WORD_ADJ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffc00000) >> 22
}

// XCVR_TX_DIG.DATA_PADDING: TX Data Padding
func (o *XCVR_TX_DIG_Type) SetDATA_PADDING_DATA_PADDING_PAT_0(value uint32) {
	volatile.StoreUint32(&o.DATA_PADDING.Reg, volatile.LoadUint32(&o.DATA_PADDING.Reg)&^(0xff)|value)
}
func (o *XCVR_TX_DIG_Type) GetDATA_PADDING_DATA_PADDING_PAT_0() uint32 {
	return volatile.LoadUint32(&o.DATA_PADDING.Reg) & 0xff
}
func (o *XCVR_TX_DIG_Type) SetDATA_PADDING_DATA_PADDING_PAT_1(value uint32) {
	volatile.StoreUint32(&o.DATA_PADDING.Reg, volatile.LoadUint32(&o.DATA_PADDING.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TX_DIG_Type) GetDATA_PADDING_DATA_PADDING_PAT_1() uint32 {
	return (volatile.LoadUint32(&o.DATA_PADDING.Reg) & 0xff00) >> 8
}
func (o *XCVR_TX_DIG_Type) SetDATA_PADDING_DFT_LFSR_OUT(value uint32) {
	volatile.StoreUint32(&o.DATA_PADDING.Reg, volatile.LoadUint32(&o.DATA_PADDING.Reg)&^(0x7fff0000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetDATA_PADDING_DFT_LFSR_OUT() uint32 {
	return (volatile.LoadUint32(&o.DATA_PADDING.Reg) & 0x7fff0000) >> 16
}
func (o *XCVR_TX_DIG_Type) SetDATA_PADDING_LRM(value uint32) {
	volatile.StoreUint32(&o.DATA_PADDING.Reg, volatile.LoadUint32(&o.DATA_PADDING.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TX_DIG_Type) GetDATA_PADDING_LRM() uint32 {
	return (volatile.LoadUint32(&o.DATA_PADDING.Reg) & 0x80000000) >> 31
}

// XCVR_TX_DIG.GFSK_CTRL: TX GFSK Modulator Control
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0xffff)|value)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL() uint32 {
	return volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0xffff
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_GFSK_MI(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_GFSK_MI() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x30000) >> 16
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_GFSK_MLD(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_GFSK_MLD() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x100000) >> 20
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_GFSK_FLD(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_GFSK_FLD() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x200000) >> 21
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_GFSK_MOD_INDEX_SCALING(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_GFSK_MOD_INDEX_SCALING() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x7000000) >> 24
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x10000000) >> 28
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_TX_IMAGE_FILTER_0_OVRD(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_TX_IMAGE_FILTER_0_OVRD() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x20000000) >> 29
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_TX_IMAGE_FILTER_1_OVRD(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_TX_IMAGE_FILTER_1_OVRD() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x40000000) >> 30
}
func (o *XCVR_TX_DIG_Type) SetGFSK_CTRL_TX_IMAGE_FILTER_2_OVRD(value uint32) {
	volatile.StoreUint32(&o.GFSK_CTRL.Reg, volatile.LoadUint32(&o.GFSK_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_CTRL_TX_IMAGE_FILTER_2_OVRD() uint32 {
	return (volatile.LoadUint32(&o.GFSK_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_TX_DIG.GFSK_COEFF2: TX GFSK Filter Coefficients 2
func (o *XCVR_TX_DIG_Type) SetGFSK_COEFF2(value uint32) {
	volatile.StoreUint32(&o.GFSK_COEFF2.Reg, value)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_COEFF2() uint32 {
	return volatile.LoadUint32(&o.GFSK_COEFF2.Reg)
}

// XCVR_TX_DIG.GFSK_COEFF1: TX GFSK Filter Coefficients 1
func (o *XCVR_TX_DIG_Type) SetGFSK_COEFF1(value uint32) {
	volatile.StoreUint32(&o.GFSK_COEFF1.Reg, value)
}
func (o *XCVR_TX_DIG_Type) GetGFSK_COEFF1() uint32 {
	return volatile.LoadUint32(&o.GFSK_COEFF1.Reg)
}

// XCVR_TX_DIG.FSK_SCALE: TX FSK Modulation Levels
func (o *XCVR_TX_DIG_Type) SetFSK_SCALE_FSK_MODULATION_SCALE_0(value uint32) {
	volatile.StoreUint32(&o.FSK_SCALE.Reg, volatile.LoadUint32(&o.FSK_SCALE.Reg)&^(0x1fff)|value)
}
func (o *XCVR_TX_DIG_Type) GetFSK_SCALE_FSK_MODULATION_SCALE_0() uint32 {
	return volatile.LoadUint32(&o.FSK_SCALE.Reg) & 0x1fff
}
func (o *XCVR_TX_DIG_Type) SetFSK_SCALE_FSK_MODULATION_SCALE_1(value uint32) {
	volatile.StoreUint32(&o.FSK_SCALE.Reg, volatile.LoadUint32(&o.FSK_SCALE.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetFSK_SCALE_FSK_MODULATION_SCALE_1() uint32 {
	return (volatile.LoadUint32(&o.FSK_SCALE.Reg) & 0x1fff0000) >> 16
}

// XCVR_TX_DIG.DFT_PATTERN: TX DFT Modulation Pattern
func (o *XCVR_TX_DIG_Type) SetDFT_PATTERN(value uint32) {
	volatile.StoreUint32(&o.DFT_PATTERN.Reg, value)
}
func (o *XCVR_TX_DIG_Type) GetDFT_PATTERN() uint32 {
	return volatile.LoadUint32(&o.DFT_PATTERN.Reg)
}

// XCVR_TX_DIG.RF_DFT_BIST_1: TX DFT Control 1
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_BIST_GO(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x1)|value)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_BIST_GO() uint32 {
	return volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x1
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_BIST_FINISHED(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_BIST_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x2) >> 1
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_BIST_RESULT(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_BIST_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x4) >> 2
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_BIST_THRSHLD(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_BIST_THRSHLD() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0xf0) >> 4
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_MAX_DIFF(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_MAX_DIFF() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0xff00) >> 8
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_CTUNE_MAX_DIFF_CH(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x7f0000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_CTUNE_MAX_DIFF_CH() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x7f0000) >> 16
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_PA_AM_MOD_FREQ(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_PA_AM_MOD_FREQ() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x7000000) >> 24
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_PA_AM_MOD_ENTRIES(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x70000000)|value<<28)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_PA_AM_MOD_ENTRIES() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x70000000) >> 28
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_1_PA_AM_MOD_EN(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_1.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_1_PA_AM_MOD_EN() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_1.Reg) & 0x80000000) >> 31
}

// XCVR_TX_DIG.RF_DFT_BIST_2: TX DFT Control 2
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_SYN_BIST_GO(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x1)|value)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_SYN_BIST_GO() uint32 {
	return volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x1
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_SYN_BIST_FINISHED(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_SYN_BIST_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x2) >> 1
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_SYN_BIST_RESULT(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_SYN_BIST_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x4) >> 2
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x8) >> 3
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_FREQ_COUNT_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0xff0)|value<<4)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_FREQ_COUNT_THRESHOLD() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0xff0) >> 4
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_INL_BIST_GO(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_INL_BIST_GO() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x1000) >> 12
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_INL_BIST_FINISHED(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_INL_BIST_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x2000) >> 13
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_INL_BIST_RESULT(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_INL_BIST_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x4000) >> 14
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_DNL_BIST_GO(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_DNL_BIST_GO() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x10000) >> 16
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_DNL_BIST_FINISHED(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_DNL_BIST_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x20000) >> 17
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_HPM_DNL_BIST_RESULT(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_HPM_DNL_BIST_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x40000) >> 18
}
func (o *XCVR_TX_DIG_Type) SetRF_DFT_BIST_2_DFT_MAX_RAM_SIZE(value uint32) {
	volatile.StoreUint32(&o.RF_DFT_BIST_2.Reg, volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg)&^(0x1ff00000)|value<<20)
}
func (o *XCVR_TX_DIG_Type) GetRF_DFT_BIST_2_DFT_MAX_RAM_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RF_DFT_BIST_2.Reg) & 0x1ff00000) >> 20
}

// XCVR_PLL_DIG
type XCVR_PLL_DIG_Type struct {
	HPM_BUMP      volatile.Register32 // 0x0
	MOD_CTRL      volatile.Register32 // 0x4
	CHAN_MAP      volatile.Register32 // 0x8
	LOCK_DETECT   volatile.Register32 // 0xC
	HPM_CTRL      volatile.Register32 // 0x10
	HPMCAL_CTRL   volatile.Register32 // 0x14
	HPM_CAL1      volatile.Register32 // 0x18
	HPM_CAL2      volatile.Register32 // 0x1C
	HPM_SDM_RES   volatile.Register32 // 0x20
	LPM_CTRL      volatile.Register32 // 0x24
	LPM_SDM_CTRL1 volatile.Register32 // 0x28
	LPM_SDM_CTRL2 volatile.Register32 // 0x2C
	LPM_SDM_CTRL3 volatile.Register32 // 0x30
	LPM_SDM_RES1  volatile.Register32 // 0x34
	LPM_SDM_RES2  volatile.Register32 // 0x38
	DELAY_MATCH   volatile.Register32 // 0x3C
	CTUNE_CTRL    volatile.Register32 // 0x40
	CTUNE_CNT6    volatile.Register32 // 0x44
	CTUNE_CNT5_4  volatile.Register32 // 0x48
	CTUNE_CNT3_2  volatile.Register32 // 0x4C
	CTUNE_CNT1_0  volatile.Register32 // 0x50
	CTUNE_RES     volatile.Register32 // 0x54
}

// XCVR_PLL_DIG.HPM_BUMP: PLL HPM Analog Bump Control
func (o *XCVR_PLL_DIG_Type) SetHPM_BUMP_HPM_VCM_TX(value uint32) {
	volatile.StoreUint32(&o.HPM_BUMP.Reg, volatile.LoadUint32(&o.HPM_BUMP.Reg)&^(0x7)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_BUMP_HPM_VCM_TX() uint32 {
	return volatile.LoadUint32(&o.HPM_BUMP.Reg) & 0x7
}
func (o *XCVR_PLL_DIG_Type) SetHPM_BUMP_HPM_VCM_CAL(value uint32) {
	volatile.StoreUint32(&o.HPM_BUMP.Reg, volatile.LoadUint32(&o.HPM_BUMP.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_BUMP_HPM_VCM_CAL() uint32 {
	return (volatile.LoadUint32(&o.HPM_BUMP.Reg) & 0x70) >> 4
}
func (o *XCVR_PLL_DIG_Type) SetHPM_BUMP_HPM_FDB_RES_TX(value uint32) {
	volatile.StoreUint32(&o.HPM_BUMP.Reg, volatile.LoadUint32(&o.HPM_BUMP.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_BUMP_HPM_FDB_RES_TX() uint32 {
	return (volatile.LoadUint32(&o.HPM_BUMP.Reg) & 0x300) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetHPM_BUMP_HPM_FDB_RES_CAL(value uint32) {
	volatile.StoreUint32(&o.HPM_BUMP.Reg, volatile.LoadUint32(&o.HPM_BUMP.Reg)&^(0x3000)|value<<12)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_BUMP_HPM_FDB_RES_CAL() uint32 {
	return (volatile.LoadUint32(&o.HPM_BUMP.Reg) & 0x3000) >> 12
}

// XCVR_PLL_DIG.MOD_CTRL: PLL Modulation Control
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_MODULATION_WORD_MANUAL(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_MODULATION_WORD_MANUAL() uint32 {
	return volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0x1fff
}
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_MOD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_MOD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_HPM_MOD_MANUAL(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_HPM_MOD_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0xff0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_HPM_MOD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_HPM_MOD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0x8000000) >> 27
}
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_HPM_SDM_OUT_MANUAL(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_HPM_SDM_OUT_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0x30000000) >> 28
}
func (o *XCVR_PLL_DIG_Type) SetMOD_CTRL_HPM_SDM_OUT_DISABLE(value uint32) {
	volatile.StoreUint32(&o.MOD_CTRL.Reg, volatile.LoadUint32(&o.MOD_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetMOD_CTRL_HPM_SDM_OUT_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.MOD_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.CHAN_MAP: PLL Channel Mapping
func (o *XCVR_PLL_DIG_Type) SetCHAN_MAP_CHANNEL_NUM(value uint32) {
	volatile.StoreUint32(&o.CHAN_MAP.Reg, volatile.LoadUint32(&o.CHAN_MAP.Reg)&^(0x7f)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCHAN_MAP_CHANNEL_NUM() uint32 {
	return volatile.LoadUint32(&o.CHAN_MAP.Reg) & 0x7f
}
func (o *XCVR_PLL_DIG_Type) SetCHAN_MAP_BOC(value uint32) {
	volatile.StoreUint32(&o.CHAN_MAP.Reg, volatile.LoadUint32(&o.CHAN_MAP.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetCHAN_MAP_BOC() uint32 {
	return (volatile.LoadUint32(&o.CHAN_MAP.Reg) & 0x100) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetCHAN_MAP_BMR(value uint32) {
	volatile.StoreUint32(&o.CHAN_MAP.Reg, volatile.LoadUint32(&o.CHAN_MAP.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_PLL_DIG_Type) GetCHAN_MAP_BMR() uint32 {
	return (volatile.LoadUint32(&o.CHAN_MAP.Reg) & 0x200) >> 9
}
func (o *XCVR_PLL_DIG_Type) SetCHAN_MAP_ZOC(value uint32) {
	volatile.StoreUint32(&o.CHAN_MAP.Reg, volatile.LoadUint32(&o.CHAN_MAP.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_PLL_DIG_Type) GetCHAN_MAP_ZOC() uint32 {
	return (volatile.LoadUint32(&o.CHAN_MAP.Reg) & 0x400) >> 10
}

// XCVR_PLL_DIG.LOCK_DETECT: PLL Lock Detect Control
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_CT_FAIL(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x1)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_CT_FAIL() uint32 {
	return volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x1
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_CTFF(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_CTFF() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x2) >> 1
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_CS_FAIL(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_CS_FAIL() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x4) >> 2
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_CSFF(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_CSFF() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x8) >> 3
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FT_FAIL(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FT_FAIL() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x10) >> 4
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FTFF(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FTFF() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x20) >> 5
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_TAFF(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_TAFF() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x80) >> 7
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_CTUNE_LDF_LEV(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_CTUNE_LDF_LEV() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0xf00) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FTF_RX_THRSH(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x3f000)|value<<12)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FTF_RX_THRSH() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x3f000) >> 12
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FTW_RX(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FTW_RX() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x80000) >> 19
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FTF_TX_THRSH(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x3f00000)|value<<20)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FTF_TX_THRSH() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x3f00000) >> 20
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FTW_TX(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FTW_TX() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x8000000) >> 27
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FREQ_COUNT_GO(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FREQ_COUNT_GO() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x10000000) >> 28
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FREQ_COUNT_FINISHED(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FREQ_COUNT_FINISHED() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0x20000000) >> 29
}
func (o *XCVR_PLL_DIG_Type) SetLOCK_DETECT_FREQ_COUNT_TIME(value uint32) {
	volatile.StoreUint32(&o.LOCK_DETECT.Reg, volatile.LoadUint32(&o.LOCK_DETECT.Reg)&^(0xc0000000)|value<<30)
}
func (o *XCVR_PLL_DIG_Type) GetLOCK_DETECT_FREQ_COUNT_TIME() uint32 {
	return (volatile.LoadUint32(&o.LOCK_DETECT.Reg) & 0xc0000000) >> 30
}

// XCVR_PLL_DIG.HPM_CTRL: PLL High Port Modulator Control
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_SDM_IN_MANUAL(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x3ff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_SDM_IN_MANUAL() uint32 {
	return volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x3ff
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPFF(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPFF() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x2000) >> 13
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_SDM_OUT_INVERT(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_SDM_OUT_INVERT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x4000) >> 14
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_SDM_IN_DISABLE(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_SDM_IN_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_LFSR_SIZE(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x70000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_LFSR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x70000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_DTH_SCL(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_DTH_SCL() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x100000) >> 20
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_DTH_EN(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_DTH_EN() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x800000) >> 23
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_INTEGER_SCALE(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x3000000)|value<<24)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_INTEGER_SCALE() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x3000000) >> 24
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_INTEGER_INVERT(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_INTEGER_INVERT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x8000000) >> 27
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_CAL_INVERT(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_CAL_INVERT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x10000000) >> 28
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CTRL_HPM_MOD_IN_INVERT(value uint32) {
	volatile.StoreUint32(&o.HPM_CTRL.Reg, volatile.LoadUint32(&o.HPM_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CTRL_HPM_MOD_IN_INVERT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.HPMCAL_CTRL: PLL High Port Calibration Control
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_FACTOR(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_FACTOR() uint32 {
	return volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x1fff
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_NOT_BUMPED(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_NOT_BUMPED() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x2000) >> 13
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_COUNT_SCALE(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_COUNT_SCALE() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x4000) >> 14
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HP_CAL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HP_CAL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x1fff0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_ARRAY_SIZE(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_ARRAY_SIZE() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x40000000) >> 30
}
func (o *XCVR_PLL_DIG_Type) SetHPMCAL_CTRL_HPM_CAL_TIME(value uint32) {
	volatile.StoreUint32(&o.HPMCAL_CTRL.Reg, volatile.LoadUint32(&o.HPMCAL_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetHPMCAL_CTRL_HPM_CAL_TIME() uint32 {
	return (volatile.LoadUint32(&o.HPMCAL_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.HPM_CAL1: PLL High Port Calibration Result 1
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL1_HPM_COUNT_1(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL1.Reg, volatile.LoadUint32(&o.HPM_CAL1.Reg)&^(0x7ffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL1_HPM_COUNT_1() uint32 {
	return volatile.LoadUint32(&o.HPM_CAL1.Reg) & 0x7ffff
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL1_CS_WT(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL1.Reg, volatile.LoadUint32(&o.HPM_CAL1.Reg)&^(0x700000)|value<<20)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL1_CS_WT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CAL1.Reg) & 0x700000) >> 20
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL1_CS_FW(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL1.Reg, volatile.LoadUint32(&o.HPM_CAL1.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL1_CS_FW() uint32 {
	return (volatile.LoadUint32(&o.HPM_CAL1.Reg) & 0x7000000) >> 24
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL1_CS_FCNT(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL1.Reg, volatile.LoadUint32(&o.HPM_CAL1.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL1_CS_FCNT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CAL1.Reg) & 0xf0000000) >> 28
}

// XCVR_PLL_DIG.HPM_CAL2: PLL High Port Calibration Result 2
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL2_HPM_COUNT_2(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL2.Reg, volatile.LoadUint32(&o.HPM_CAL2.Reg)&^(0x7ffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL2_HPM_COUNT_2() uint32 {
	return volatile.LoadUint32(&o.HPM_CAL2.Reg) & 0x7ffff
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL2_CS_RC(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL2.Reg, volatile.LoadUint32(&o.HPM_CAL2.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL2_CS_RC() uint32 {
	return (volatile.LoadUint32(&o.HPM_CAL2.Reg) & 0x100000) >> 20
}
func (o *XCVR_PLL_DIG_Type) SetHPM_CAL2_CS_FT(value uint32) {
	volatile.StoreUint32(&o.HPM_CAL2.Reg, volatile.LoadUint32(&o.HPM_CAL2.Reg)&^(0x1f000000)|value<<24)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_CAL2_CS_FT() uint32 {
	return (volatile.LoadUint32(&o.HPM_CAL2.Reg) & 0x1f000000) >> 24
}

// XCVR_PLL_DIG.HPM_SDM_RES: PLL High Port Sigma Delta Results
func (o *XCVR_PLL_DIG_Type) SetHPM_SDM_RES_HPM_NUM_SELECTED(value uint32) {
	volatile.StoreUint32(&o.HPM_SDM_RES.Reg, volatile.LoadUint32(&o.HPM_SDM_RES.Reg)&^(0x3ff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_SDM_RES_HPM_NUM_SELECTED() uint32 {
	return volatile.LoadUint32(&o.HPM_SDM_RES.Reg) & 0x3ff
}
func (o *XCVR_PLL_DIG_Type) SetHPM_SDM_RES_HPM_DENOM(value uint32) {
	volatile.StoreUint32(&o.HPM_SDM_RES.Reg, volatile.LoadUint32(&o.HPM_SDM_RES.Reg)&^(0x3ff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_SDM_RES_HPM_DENOM() uint32 {
	return (volatile.LoadUint32(&o.HPM_SDM_RES.Reg) & 0x3ff0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetHPM_SDM_RES_HPM_COUNT_ADJUST(value uint32) {
	volatile.StoreUint32(&o.HPM_SDM_RES.Reg, volatile.LoadUint32(&o.HPM_SDM_RES.Reg)&^(0xf0000000)|value<<28)
}
func (o *XCVR_PLL_DIG_Type) GetHPM_SDM_RES_HPM_COUNT_ADJUST() uint32 {
	return (volatile.LoadUint32(&o.HPM_SDM_RES.Reg) & 0xf0000000) >> 28
}

// XCVR_PLL_DIG.LPM_CTRL: PLL Low Port Modulator Control
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_PLL_LD_MANUAL(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x3f)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_PLL_LD_MANUAL() uint32 {
	return volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x3f
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_PLL_LD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_PLL_LD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPFF(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPFF() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x2000) >> 13
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_SDM_INV(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_SDM_INV() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x4000) >> 14
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_DISABLE(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_DTH_SCL(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_DTH_SCL() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0xf0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_D_CTRL(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_D_CTRL() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x400000) >> 22
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_D_OVRD(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_D_OVRD() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x800000) >> 23
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_SCALE(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0xf000000)|value<<24)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_SCALE() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0xf000000) >> 24
}
func (o *XCVR_PLL_DIG_Type) SetLPM_CTRL_LPM_SDM_USE_NEG(value uint32) {
	volatile.StoreUint32(&o.LPM_CTRL.Reg, volatile.LoadUint32(&o.LPM_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_CTRL_LPM_SDM_USE_NEG() uint32 {
	return (volatile.LoadUint32(&o.LPM_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.LPM_SDM_CTRL1: PLL Low Port Sigma Delta Control 1
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL1_LPM_INTG_SELECTED(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL1.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg)&^(0x7f)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL1_LPM_INTG_SELECTED() uint32 {
	return volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg) & 0x7f
}
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL1_HPM_ARRAY_BIAS(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL1.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg)&^(0x7f00)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL1_HPM_ARRAY_BIAS() uint32 {
	return (volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg) & 0x7f00) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL1_LPM_INTG(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL1.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg)&^(0x7f0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL1_LPM_INTG() uint32 {
	return (volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg) & 0x7f0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL1_SDM_MAP_DISABLE(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL1.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL1_SDM_MAP_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.LPM_SDM_CTRL1.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.LPM_SDM_CTRL2: PLL Low Port Sigma Delta Control 2
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL2_LPM_NUM(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL2.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL2.Reg)&^(0xfffffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL2_LPM_NUM() uint32 {
	return volatile.LoadUint32(&o.LPM_SDM_CTRL2.Reg) & 0xfffffff
}

// XCVR_PLL_DIG.LPM_SDM_CTRL3: PLL Low Port Sigma Delta Control 3
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_CTRL3_LPM_DENOM(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_CTRL3.Reg, volatile.LoadUint32(&o.LPM_SDM_CTRL3.Reg)&^(0xfffffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_CTRL3_LPM_DENOM() uint32 {
	return volatile.LoadUint32(&o.LPM_SDM_CTRL3.Reg) & 0xfffffff
}

// XCVR_PLL_DIG.LPM_SDM_RES1: PLL Low Port Sigma Delta Result 1
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_RES1_LPM_NUM_SELECTED(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_RES1.Reg, volatile.LoadUint32(&o.LPM_SDM_RES1.Reg)&^(0xfffffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_RES1_LPM_NUM_SELECTED() uint32 {
	return volatile.LoadUint32(&o.LPM_SDM_RES1.Reg) & 0xfffffff
}

// XCVR_PLL_DIG.LPM_SDM_RES2: PLL Low Port Sigma Delta Result 2
func (o *XCVR_PLL_DIG_Type) SetLPM_SDM_RES2_LPM_DENOM_SELECTED(value uint32) {
	volatile.StoreUint32(&o.LPM_SDM_RES2.Reg, volatile.LoadUint32(&o.LPM_SDM_RES2.Reg)&^(0xfffffff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetLPM_SDM_RES2_LPM_DENOM_SELECTED() uint32 {
	return volatile.LoadUint32(&o.LPM_SDM_RES2.Reg) & 0xfffffff
}

// XCVR_PLL_DIG.DELAY_MATCH: PLL Delay Matching
func (o *XCVR_PLL_DIG_Type) SetDELAY_MATCH_LPM_SDM_DELAY(value uint32) {
	volatile.StoreUint32(&o.DELAY_MATCH.Reg, volatile.LoadUint32(&o.DELAY_MATCH.Reg)&^(0xf)|value)
}
func (o *XCVR_PLL_DIG_Type) GetDELAY_MATCH_LPM_SDM_DELAY() uint32 {
	return volatile.LoadUint32(&o.DELAY_MATCH.Reg) & 0xf
}
func (o *XCVR_PLL_DIG_Type) SetDELAY_MATCH_HPM_SDM_DELAY(value uint32) {
	volatile.StoreUint32(&o.DELAY_MATCH.Reg, volatile.LoadUint32(&o.DELAY_MATCH.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetDELAY_MATCH_HPM_SDM_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DELAY_MATCH.Reg) & 0xf00) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetDELAY_MATCH_HPM_INTEGER_DELAY(value uint32) {
	volatile.StoreUint32(&o.DELAY_MATCH.Reg, volatile.LoadUint32(&o.DELAY_MATCH.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetDELAY_MATCH_HPM_INTEGER_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DELAY_MATCH.Reg) & 0xf0000) >> 16
}

// XCVR_PLL_DIG.CTUNE_CTRL: PLL Coarse Tune Control
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CTRL_CTUNE_TARGET_MANUAL(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CTRL.Reg, volatile.LoadUint32(&o.CTUNE_CTRL.Reg)&^(0xfff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CTRL_CTUNE_TARGET_MANUAL() uint32 {
	return volatile.LoadUint32(&o.CTUNE_CTRL.Reg) & 0xfff
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CTRL_CTUNE_TARGET_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CTRL.Reg, volatile.LoadUint32(&o.CTUNE_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CTRL_CTUNE_TARGET_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CTRL_CTUNE_ADJUST(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CTRL.Reg, volatile.LoadUint32(&o.CTUNE_CTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CTRL_CTUNE_ADJUST() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CTRL.Reg) & 0xf0000) >> 16
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CTRL_CTUNE_MANUAL(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CTRL.Reg, volatile.LoadUint32(&o.CTUNE_CTRL.Reg)&^(0x7f000000)|value<<24)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CTRL_CTUNE_MANUAL() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CTRL.Reg) & 0x7f000000) >> 24
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CTRL_CTUNE_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CTRL.Reg, volatile.LoadUint32(&o.CTUNE_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CTRL_CTUNE_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CTRL.Reg) & 0x80000000) >> 31
}

// XCVR_PLL_DIG.CTUNE_CNT6: PLL Coarse Tune Count 6
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT6_CTUNE_COUNT_6(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT6.Reg, volatile.LoadUint32(&o.CTUNE_CNT6.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT6_CTUNE_COUNT_6() uint32 {
	return volatile.LoadUint32(&o.CTUNE_CNT6.Reg) & 0x1fff
}

// XCVR_PLL_DIG.CTUNE_CNT5_4: PLL Coarse Tune Counts 5 and 4
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT5_4_CTUNE_COUNT_4(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT5_4.Reg, volatile.LoadUint32(&o.CTUNE_CNT5_4.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT5_4_CTUNE_COUNT_4() uint32 {
	return volatile.LoadUint32(&o.CTUNE_CNT5_4.Reg) & 0x1fff
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT5_4_CTUNE_COUNT_5(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT5_4.Reg, volatile.LoadUint32(&o.CTUNE_CNT5_4.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT5_4_CTUNE_COUNT_5() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CNT5_4.Reg) & 0x1fff0000) >> 16
}

// XCVR_PLL_DIG.CTUNE_CNT3_2: PLL Coarse Tune Counts 3 and 2
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT3_2_CTUNE_COUNT_2(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT3_2.Reg, volatile.LoadUint32(&o.CTUNE_CNT3_2.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT3_2_CTUNE_COUNT_2() uint32 {
	return volatile.LoadUint32(&o.CTUNE_CNT3_2.Reg) & 0x1fff
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT3_2_CTUNE_COUNT_3(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT3_2.Reg, volatile.LoadUint32(&o.CTUNE_CNT3_2.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT3_2_CTUNE_COUNT_3() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CNT3_2.Reg) & 0x1fff0000) >> 16
}

// XCVR_PLL_DIG.CTUNE_CNT1_0: PLL Coarse Tune Counts 1 and 0
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT1_0_CTUNE_COUNT_0(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT1_0.Reg, volatile.LoadUint32(&o.CTUNE_CNT1_0.Reg)&^(0x1fff)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT1_0_CTUNE_COUNT_0() uint32 {
	return volatile.LoadUint32(&o.CTUNE_CNT1_0.Reg) & 0x1fff
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_CNT1_0_CTUNE_COUNT_1(value uint32) {
	volatile.StoreUint32(&o.CTUNE_CNT1_0.Reg, volatile.LoadUint32(&o.CTUNE_CNT1_0.Reg)&^(0x1fff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_CNT1_0_CTUNE_COUNT_1() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_CNT1_0.Reg) & 0x1fff0000) >> 16
}

// XCVR_PLL_DIG.CTUNE_RES: PLL Coarse Tune Results
func (o *XCVR_PLL_DIG_Type) SetCTUNE_RES_CTUNE_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CTUNE_RES.Reg, volatile.LoadUint32(&o.CTUNE_RES.Reg)&^(0x7f)|value)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_RES_CTUNE_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CTUNE_RES.Reg) & 0x7f
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_RES_CTUNE_BEST_DIFF(value uint32) {
	volatile.StoreUint32(&o.CTUNE_RES.Reg, volatile.LoadUint32(&o.CTUNE_RES.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_RES_CTUNE_BEST_DIFF() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_RES.Reg) & 0xff00) >> 8
}
func (o *XCVR_PLL_DIG_Type) SetCTUNE_RES_CTUNE_FREQ_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CTUNE_RES.Reg, volatile.LoadUint32(&o.CTUNE_RES.Reg)&^(0xfff0000)|value<<16)
}
func (o *XCVR_PLL_DIG_Type) GetCTUNE_RES_CTUNE_FREQ_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.CTUNE_RES.Reg) & 0xfff0000) >> 16
}

// XCVR_MISC
type XCVR_MISC_Type struct {
	XCVR_CTRL           volatile.Register32 // 0x0
	XCVR_STATUS         volatile.Register32 // 0x4
	BLE_ARB_CTRL        volatile.Register32 // 0x8
	_                   [4]byte
	OVERWRITE_VER       volatile.Register32 // 0x10
	DMA_CTRL            volatile.Register32 // 0x14
	DMA_DATA            volatile.Register32 // 0x18
	DTEST_CTRL          volatile.Register32 // 0x1C
	PACKET_RAM_CTRL     volatile.Register32 // 0x20
	FAD_CTRL            volatile.Register32 // 0x24
	LPPS_CTRL           volatile.Register32 // 0x28
	RF_NOT_ALLOWED_CTRL volatile.Register32 // 0x2C
	CRCW_CFG            volatile.Register32 // 0x30
	CRC_EC_MASK         volatile.Register32 // 0x34
	CRC_RES_OUT         volatile.Register32 // 0x38
}

// XCVR_MISC.XCVR_CTRL: TRANSCEIVER CONTROL
func (o *XCVR_MISC_Type) SetXCVR_CTRL_PROTOCOL(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0xf)|value)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_PROTOCOL() uint32 {
	return volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0xf
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_TGT_PWR_SRC(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_TGT_PWR_SRC() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x70) >> 4
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_REF_CLK_FREQ(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_REF_CLK_FREQ() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x300) >> 8
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_DEMOD_SEL(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_DEMOD_SEL() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x3000) >> 12
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_RADIO0_IRQ_SEL(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x70000)|value<<16)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_RADIO0_IRQ_SEL() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x70000) >> 16
}
func (o *XCVR_MISC_Type) SetXCVR_CTRL_RADIO1_IRQ_SEL(value uint32) {
	volatile.StoreUint32(&o.XCVR_CTRL.Reg, volatile.LoadUint32(&o.XCVR_CTRL.Reg)&^(0x700000)|value<<20)
}
func (o *XCVR_MISC_Type) GetXCVR_CTRL_RADIO1_IRQ_SEL() uint32 {
	return (volatile.LoadUint32(&o.XCVR_CTRL.Reg) & 0x700000) >> 20
}

// XCVR_MISC.XCVR_STATUS: TRANSCEIVER STATUS
func (o *XCVR_MISC_Type) SetXCVR_STATUS_TSM_COUNT(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0xff)|value)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_TSM_COUNT() uint32 {
	return volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0xff
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_PLL_SEQ_STATE(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_PLL_SEQ_STATE() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0xf00) >> 8
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_RX_MODE(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_RX_MODE() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x1000) >> 12
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_TX_MODE(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_TX_MODE() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x2000) >> 13
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_BTLE_SYSCLK_REQ(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_BTLE_SYSCLK_REQ() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x10000) >> 16
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_RIF_LL_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_RIF_LL_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x20000) >> 17
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_XTAL_READY(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_XTAL_READY() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x40000) >> 18
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_SOC_USING_RF_OSC_CLK(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_SOC_USING_RF_OSC_CLK() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x80000) >> 19
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_TSM_IRQ0(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_TSM_IRQ0() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x1000000) >> 24
}
func (o *XCVR_MISC_Type) SetXCVR_STATUS_TSM_IRQ1(value uint32) {
	volatile.StoreUint32(&o.XCVR_STATUS.Reg, volatile.LoadUint32(&o.XCVR_STATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_MISC_Type) GetXCVR_STATUS_TSM_IRQ1() uint32 {
	return (volatile.LoadUint32(&o.XCVR_STATUS.Reg) & 0x2000000) >> 25
}

// XCVR_MISC.BLE_ARB_CTRL: BLE ARBITRATION CONTROL
func (o *XCVR_MISC_Type) SetBLE_ARB_CTRL_BLE_RELINQUISH(value uint32) {
	volatile.StoreUint32(&o.BLE_ARB_CTRL.Reg, volatile.LoadUint32(&o.BLE_ARB_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_MISC_Type) GetBLE_ARB_CTRL_BLE_RELINQUISH() uint32 {
	return volatile.LoadUint32(&o.BLE_ARB_CTRL.Reg) & 0x1
}
func (o *XCVR_MISC_Type) SetBLE_ARB_CTRL_XCVR_BUSY(value uint32) {
	volatile.StoreUint32(&o.BLE_ARB_CTRL.Reg, volatile.LoadUint32(&o.BLE_ARB_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_MISC_Type) GetBLE_ARB_CTRL_XCVR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.BLE_ARB_CTRL.Reg) & 0x2) >> 1
}

// XCVR_MISC.OVERWRITE_VER: OVERWRITE VERSION
func (o *XCVR_MISC_Type) SetOVERWRITE_VER(value uint32) {
	volatile.StoreUint32(&o.OVERWRITE_VER.Reg, volatile.LoadUint32(&o.OVERWRITE_VER.Reg)&^(0xff)|value)
}
func (o *XCVR_MISC_Type) GetOVERWRITE_VER() uint32 {
	return volatile.LoadUint32(&o.OVERWRITE_VER.Reg) & 0xff
}

// XCVR_MISC.DMA_CTRL: TRANSCEIVER DMA CONTROL
func (o *XCVR_MISC_Type) SetDMA_CTRL_DMA_PAGE(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0xf)|value)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_DMA_PAGE() uint32 {
	return volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0xf
}
func (o *XCVR_MISC_Type) SetDMA_CTRL_SINGLE_REQ_MODE(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_SINGLE_REQ_MODE() uint32 {
	return (volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0x10) >> 4
}
func (o *XCVR_MISC_Type) SetDMA_CTRL_BYPASS_DMA_SYNC(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_BYPASS_DMA_SYNC() uint32 {
	return (volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0x20) >> 5
}
func (o *XCVR_MISC_Type) SetDMA_CTRL_DMA_TRIGGERRED(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_DMA_TRIGGERRED() uint32 {
	return (volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0x40) >> 6
}
func (o *XCVR_MISC_Type) SetDMA_CTRL_DMA_TIMED_OUT(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_DMA_TIMED_OUT() uint32 {
	return (volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_MISC_Type) SetDMA_CTRL_DMA_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.DMA_CTRL.Reg, volatile.LoadUint32(&o.DMA_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_MISC_Type) GetDMA_CTRL_DMA_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.DMA_CTRL.Reg) & 0xf00) >> 8
}

// XCVR_MISC.DMA_DATA: TRANSCEIVER DMA DATA
func (o *XCVR_MISC_Type) SetDMA_DATA(value uint32) {
	volatile.StoreUint32(&o.DMA_DATA.Reg, value)
}
func (o *XCVR_MISC_Type) GetDMA_DATA() uint32 {
	return volatile.LoadUint32(&o.DMA_DATA.Reg)
}

// XCVR_MISC.DTEST_CTRL: DIGITAL TEST MUX CONTROL
func (o *XCVR_MISC_Type) SetDTEST_CTRL_DTEST_PAGE(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x3f)|value)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_DTEST_PAGE() uint32 {
	return volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x3f
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_DTEST_EN(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_DTEST_EN() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_GPIO0_OVLAY_PIN(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_GPIO0_OVLAY_PIN() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0xf00) >> 8
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_GPIO1_OVLAY_PIN(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_GPIO1_OVLAY_PIN() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0xf000) >> 12
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_TSM_GPIO_OVLAY(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_TSM_GPIO_OVLAY() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x30000) >> 16
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_DTEST_SHFT(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_DTEST_SHFT() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x7000000) >> 24
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_RAW_MODE_I(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_RAW_MODE_I() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x10000000) >> 28
}
func (o *XCVR_MISC_Type) SetDTEST_CTRL_RAW_MODE_Q(value uint32) {
	volatile.StoreUint32(&o.DTEST_CTRL.Reg, volatile.LoadUint32(&o.DTEST_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_MISC_Type) GetDTEST_CTRL_RAW_MODE_Q() uint32 {
	return (volatile.LoadUint32(&o.DTEST_CTRL.Reg) & 0x20000000) >> 29
}

// XCVR_MISC.PACKET_RAM_CTRL: PACKET RAM CONTROL
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_DBG_PAGE(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0xf)|value)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_DBG_PAGE() uint32 {
	return volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0xf
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_PB_PROTECT(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_PB_PROTECT() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x10) >> 4
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_XCVR_RAM_ALLOW(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_XCVR_RAM_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x20) >> 5
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x40) >> 6
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_DBG_TRIGGERRED(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_DBG_TRIGGERRED() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_DBG_RAM_FULL(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_DBG_RAM_FULL() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x300) >> 8
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x400) >> 10
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM0_CLK_ON_OVRD(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM0_CLK_ON_OVRD() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x1000) >> 12
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM1_CLK_ON_OVRD(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM1_CLK_ON_OVRD() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x2000) >> 13
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x4000) >> 14
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM0_CE_ON_OVRD(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM0_CE_ON_OVRD() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x10000) >> 16
}
func (o *XCVR_MISC_Type) SetPACKET_RAM_CTRL_RAM1_CE_ON_OVRD(value uint32) {
	volatile.StoreUint32(&o.PACKET_RAM_CTRL.Reg, volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_MISC_Type) GetPACKET_RAM_CTRL_RAM1_CE_ON_OVRD() uint32 {
	return (volatile.LoadUint32(&o.PACKET_RAM_CTRL.Reg) & 0x20000) >> 17
}

// XCVR_MISC.FAD_CTRL: FAD CONTROL
func (o *XCVR_MISC_Type) SetFAD_CTRL_FAD_EN(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_FAD_EN() uint32 {
	return volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0x1
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_ANTX(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_ANTX() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0x2) >> 1
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_ANTX_EN(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0x30)|value<<4)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_ANTX_EN() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0x30) >> 4
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_ANTX_HZ(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_ANTX_HZ() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0x40) >> 6
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_ANTX_CTRLMODE(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_ANTX_CTRLMODE() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_ANTX_POL(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_ANTX_POL() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0xf00) >> 8
}
func (o *XCVR_MISC_Type) SetFAD_CTRL_FAD_NOT_GPIO(value uint32) {
	volatile.StoreUint32(&o.FAD_CTRL.Reg, volatile.LoadUint32(&o.FAD_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_MISC_Type) GetFAD_CTRL_FAD_NOT_GPIO() uint32 {
	return (volatile.LoadUint32(&o.FAD_CTRL.Reg) & 0xf000) >> 12
}

// XCVR_MISC.LPPS_CTRL: LOW POWER PREAMBLE SEARCH CONTROL
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_ENABLE() uint32 {
	return volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x1
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_TZA_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_TZA_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x2) >> 1
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_BBA_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_BBA_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x4) >> 2
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_ADC_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_ADC_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x8) >> 3
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_DCOC_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_DCOC_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x10) >> 4
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_PDET_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_PDET_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x20) >> 5
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_SY_LO_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_SY_LO_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x40) >> 6
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_SY_LO_BUF_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_SY_LO_BUF_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x80) >> 7
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_RX_DIG_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_RX_DIG_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x100) >> 8
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_DCOC_DIG_ALLOW(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_DCOC_DIG_ALLOW() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0x200) >> 9
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_START_RX(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_START_RX() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0xff0000) >> 16
}
func (o *XCVR_MISC_Type) SetLPPS_CTRL_LPPS_DEST_RX(value uint32) {
	volatile.StoreUint32(&o.LPPS_CTRL.Reg, volatile.LoadUint32(&o.LPPS_CTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_MISC_Type) GetLPPS_CTRL_LPPS_DEST_RX() uint32 {
	return (volatile.LoadUint32(&o.LPPS_CTRL.Reg) & 0xff000000) >> 24
}

// XCVR_MISC.RF_NOT_ALLOWED_CTRL: WIFI COEXISTENCE CONTROL
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x1)|value)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX() uint32 {
	return volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x1
}
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX() uint32 {
	return (volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x2) >> 1
}
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED() uint32 {
	return (volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x4) >> 2
}
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT() uint32 {
	return (volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x8) >> 3
}
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT() uint32 {
	return (volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x10) >> 4
}
func (o *XCVR_MISC_Type) SetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED(value uint32) {
	volatile.StoreUint32(&o.RF_NOT_ALLOWED_CTRL.Reg, volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_MISC_Type) GetRF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED() uint32 {
	return (volatile.LoadUint32(&o.RF_NOT_ALLOWED_CTRL.Reg) & 0x20) >> 5
}

// XCVR_MISC.CRCW_CFG: CRC/WHITENER CONTROL
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRCW_EN(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x1)|value)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRCW_EN() uint32 {
	return volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x1
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_ZERO(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_ZERO() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x2) >> 1
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_EARLY_FAIL(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_EARLY_FAIL() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x4) >> 2
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_RES_OUT_VLD(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_RES_OUT_VLD() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x8) >> 3
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_EC_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x7ff0000)|value<<16)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_EC_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x7ff0000) >> 16
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_EC_DONE(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_EC_DONE() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x10000000) >> 28
}
func (o *XCVR_MISC_Type) SetCRCW_CFG_CRC_EC_FAIL(value uint32) {
	volatile.StoreUint32(&o.CRCW_CFG.Reg, volatile.LoadUint32(&o.CRCW_CFG.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_MISC_Type) GetCRCW_CFG_CRC_EC_FAIL() uint32 {
	return (volatile.LoadUint32(&o.CRCW_CFG.Reg) & 0x20000000) >> 29
}

// XCVR_MISC.CRC_EC_MASK: CRC ERROR CORRECTION MASK
func (o *XCVR_MISC_Type) SetCRC_EC_MASK(value uint32) {
	volatile.StoreUint32(&o.CRC_EC_MASK.Reg, value)
}
func (o *XCVR_MISC_Type) GetCRC_EC_MASK() uint32 {
	return volatile.LoadUint32(&o.CRC_EC_MASK.Reg)
}

// XCVR_MISC.CRC_RES_OUT: CRC RESULT
func (o *XCVR_MISC_Type) SetCRC_RES_OUT(value uint32) {
	volatile.StoreUint32(&o.CRC_RES_OUT.Reg, value)
}
func (o *XCVR_MISC_Type) GetCRC_RES_OUT() uint32 {
	return volatile.LoadUint32(&o.CRC_RES_OUT.Reg)
}

// XCVR_TSM
type XCVR_TSM_Type struct {
	CTRL          volatile.Register32 // 0x0
	END_OF_SEQ    volatile.Register32 // 0x4
	OVRD0         volatile.Register32 // 0x8
	OVRD1         volatile.Register32 // 0xC
	OVRD2         volatile.Register32 // 0x10
	OVRD3         volatile.Register32 // 0x14
	PA_POWER      volatile.Register32 // 0x18
	PA_RAMP_TBL0  volatile.Register32 // 0x1C
	PA_RAMP_TBL1  volatile.Register32 // 0x20
	RECYCLE_COUNT volatile.Register32 // 0x24
	FAST_CTRL1    volatile.Register32 // 0x28
	FAST_CTRL2    volatile.Register32 // 0x2C
	TIMING00      volatile.Register32 // 0x30
	TIMING01      volatile.Register32 // 0x34
	TIMING02      volatile.Register32 // 0x38
	TIMING03      volatile.Register32 // 0x3C
	TIMING04      volatile.Register32 // 0x40
	TIMING05      volatile.Register32 // 0x44
	TIMING06      volatile.Register32 // 0x48
	TIMING07      volatile.Register32 // 0x4C
	TIMING08      volatile.Register32 // 0x50
	TIMING09      volatile.Register32 // 0x54
	TIMING10      volatile.Register32 // 0x58
	TIMING11      volatile.Register32 // 0x5C
	TIMING12      volatile.Register32 // 0x60
	TIMING13      volatile.Register32 // 0x64
	TIMING14      volatile.Register32 // 0x68
	TIMING15      volatile.Register32 // 0x6C
	TIMING16      volatile.Register32 // 0x70
	TIMING17      volatile.Register32 // 0x74
	TIMING18      volatile.Register32 // 0x78
	TIMING19      volatile.Register32 // 0x7C
	TIMING20      volatile.Register32 // 0x80
	TIMING21      volatile.Register32 // 0x84
	TIMING22      volatile.Register32 // 0x88
	TIMING23      volatile.Register32 // 0x8C
	TIMING24      volatile.Register32 // 0x90
	TIMING25      volatile.Register32 // 0x94
	TIMING26      volatile.Register32 // 0x98
	TIMING27      volatile.Register32 // 0x9C
	TIMING28      volatile.Register32 // 0xA0
	TIMING29      volatile.Register32 // 0xA4
	TIMING30      volatile.Register32 // 0xA8
	TIMING31      volatile.Register32 // 0xAC
	TIMING32      volatile.Register32 // 0xB0
	TIMING33      volatile.Register32 // 0xB4
	TIMING34      volatile.Register32 // 0xB8
	TIMING35      volatile.Register32 // 0xBC
	TIMING36      volatile.Register32 // 0xC0
	TIMING37      volatile.Register32 // 0xC4
	TIMING38      volatile.Register32 // 0xC8
	TIMING39      volatile.Register32 // 0xCC
	TIMING40      volatile.Register32 // 0xD0
	TIMING41      volatile.Register32 // 0xD4
	TIMING42      volatile.Register32 // 0xD8
	TIMING43      volatile.Register32 // 0xDC
	TIMING44      volatile.Register32 // 0xE0
	TIMING45      volatile.Register32 // 0xE4
	TIMING46      volatile.Register32 // 0xE8
	TIMING47      volatile.Register32 // 0xEC
	TIMING48      volatile.Register32 // 0xF0
	TIMING49      volatile.Register32 // 0xF4
	TIMING50      volatile.Register32 // 0xF8
	TIMING51      volatile.Register32 // 0xFC
	TIMING52      volatile.Register32 // 0x100
	TIMING53      volatile.Register32 // 0x104
	TIMING54      volatile.Register32 // 0x108
	TIMING55      volatile.Register32 // 0x10C
	TIMING56      volatile.Register32 // 0x110
	TIMING57      volatile.Register32 // 0x114
	TIMING58      volatile.Register32 // 0x118
}

// XCVR_TSM.CTRL: TRANSCEIVER SEQUENCE MANAGER CONTROL
func (o *XCVR_TSM_Type) SetCTRL_FORCE_TX_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetCTRL_FORCE_TX_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetCTRL_FORCE_RX_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetCTRL_FORCE_RX_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetCTRL_PA_RAMP_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30)|value<<4)
}
func (o *XCVR_TSM_Type) GetCTRL_PA_RAMP_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30) >> 4
}
func (o *XCVR_TSM_Type) SetCTRL_DATA_PADDING_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *XCVR_TSM_Type) GetCTRL_DATA_PADDING_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0) >> 6
}
func (o *XCVR_TSM_Type) SetCTRL_TSM_IRQ0_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_TSM_Type) GetCTRL_TSM_IRQ0_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *XCVR_TSM_Type) SetCTRL_TSM_IRQ1_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_TSM_Type) GetCTRL_TSM_IRQ1_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *XCVR_TSM_Type) SetCTRL_RAMP_DN_DELAY(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_TSM_Type) GetCTRL_RAMP_DN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf000) >> 12
}
func (o *XCVR_TSM_Type) SetCTRL_TX_ABORT_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TSM_Type) GetCTRL_TX_ABORT_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *XCVR_TSM_Type) SetCTRL_RX_ABORT_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TSM_Type) GetCTRL_RX_ABORT_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *XCVR_TSM_Type) SetCTRL_ABORT_ON_CTUNE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TSM_Type) GetCTRL_ABORT_ON_CTUNE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *XCVR_TSM_Type) SetCTRL_ABORT_ON_CYCLE_SLIP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_TSM_Type) GetCTRL_ABORT_ON_CYCLE_SLIP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *XCVR_TSM_Type) SetCTRL_ABORT_ON_FREQ_TARG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TSM_Type) GetCTRL_ABORT_ON_FREQ_TARG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *XCVR_TSM_Type) SetCTRL_BKPT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetCTRL_BKPT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.END_OF_SEQ: TSM END OF SEQUENCE
func (o *XCVR_TSM_Type) SetEND_OF_SEQ_END_OF_TX_WU(value uint32) {
	volatile.StoreUint32(&o.END_OF_SEQ.Reg, volatile.LoadUint32(&o.END_OF_SEQ.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetEND_OF_SEQ_END_OF_TX_WU() uint32 {
	return volatile.LoadUint32(&o.END_OF_SEQ.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetEND_OF_SEQ_END_OF_TX_WD(value uint32) {
	volatile.StoreUint32(&o.END_OF_SEQ.Reg, volatile.LoadUint32(&o.END_OF_SEQ.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetEND_OF_SEQ_END_OF_TX_WD() uint32 {
	return (volatile.LoadUint32(&o.END_OF_SEQ.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetEND_OF_SEQ_END_OF_RX_WU(value uint32) {
	volatile.StoreUint32(&o.END_OF_SEQ.Reg, volatile.LoadUint32(&o.END_OF_SEQ.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetEND_OF_SEQ_END_OF_RX_WU() uint32 {
	return (volatile.LoadUint32(&o.END_OF_SEQ.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetEND_OF_SEQ_END_OF_RX_WD(value uint32) {
	volatile.StoreUint32(&o.END_OF_SEQ.Reg, volatile.LoadUint32(&o.END_OF_SEQ.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetEND_OF_SEQ_END_OF_RX_WD() uint32 {
	return (volatile.LoadUint32(&o.END_OF_SEQ.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.OVRD0: TSM OVERRIDE REGISTER 0
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_HF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x1)|value)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_HF_EN_OVRD_EN() uint32 {
	return volatile.LoadUint32(&o.OVRD0.Reg) & 0x1
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_HF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_HF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x2) >> 1
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_ADCDAC_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_ADCDAC_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_ADCDAC_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_ADCDAC_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_BBA_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_BBA_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x10) >> 4
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_BBA_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_BBA_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x20) >> 5
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_PD_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_PD_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x40) >> 6
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_PD_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_PD_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x80) >> 7
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_FDBK_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_FDBK_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x100) >> 8
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_FDBK_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_FDBK_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x200) >> 9
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x400) >> 10
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x800) >> 11
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VTREF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VTREF_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x1000) >> 12
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VTREF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VTREF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x2000) >> 13
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x4000) >> 14
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_FDBK_BLEED_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_FDBK_BLEED_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x8000) >> 15
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x10000) >> 16
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x20000) >> 17
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x40000) >> 18
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x80000) >> 19
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x100000) >> 20
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x200000) >> 21
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x400000) >> 22
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x800000) >> 23
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x1000000) >> 24
}
func (o *XCVR_TSM_Type) SetOVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_TSM_Type) GetOVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x2000000) >> 25
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x4000000)|value<<26)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x4000000) >> 26
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_VCO_AUTOTUNE_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_VCO_AUTOTUNE_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x8000000) >> 27
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x10000000) >> 28
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x20000000) >> 29
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_VCO_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_VCO_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x40000000) >> 30
}
func (o *XCVR_TSM_Type) SetOVRD0_SY_VCO_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD0.Reg, volatile.LoadUint32(&o.OVRD0.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TSM_Type) GetOVRD0_SY_VCO_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD0.Reg) & 0x80000000) >> 31
}

// XCVR_TSM.OVRD1: TSM OVERRIDE REGISTER 1
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_RX_BUF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x1)|value)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_RX_BUF_EN_OVRD_EN() uint32 {
	return volatile.LoadUint32(&o.OVRD1.Reg) & 0x1
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_RX_BUF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_RX_BUF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x2) >> 1
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_TX_BUF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_TX_BUF_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_TX_BUF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_TX_BUF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_DIVN_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_DIVN_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x10) >> 4
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_DIVN_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_DIVN_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x20) >> 5
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x40) >> 6
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_PD_FILTER_CHARGE_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_PD_FILTER_CHARGE_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x80) >> 7
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_PD_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_PD_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x100) >> 8
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_PD_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_PD_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x200) >> 9
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_DIVN_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_DIVN_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x400) >> 10
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_DIVN_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_DIVN_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x800) >> 11
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_RX_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_RX_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x1000) >> 12
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_RX_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_RX_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x2000) >> 13
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_TX_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_TX_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x4000) >> 14
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_LO_TX_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_LO_TX_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x8000) >> 15
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_DIVN_CAL_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_DIVN_CAL_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x10000) >> 16
}
func (o *XCVR_TSM_Type) SetOVRD1_SY_DIVN_CAL_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TSM_Type) GetOVRD1_SY_DIVN_CAL_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x20000) >> 17
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_MIXER_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_MIXER_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x40000) >> 18
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_MIXER_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_MIXER_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x80000) >> 19
}
func (o *XCVR_TSM_Type) SetOVRD1_TX_PA_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TSM_Type) GetOVRD1_TX_PA_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x100000) >> 20
}
func (o *XCVR_TSM_Type) SetOVRD1_TX_PA_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_TSM_Type) GetOVRD1_TX_PA_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x200000) >> 21
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_I_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_I_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x400000) >> 22
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_I_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_I_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x800000) >> 23
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_Q_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_Q_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x1000000) >> 24
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_Q_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_Q_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x2000000) >> 25
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_RESET_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x4000000)|value<<26)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_RESET_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x4000000) >> 26
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_ADC_RESET_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_ADC_RESET_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x8000000) >> 27
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_BBA_I_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_BBA_I_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x10000000) >> 28
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_BBA_I_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_BBA_I_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x20000000) >> 29
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_BBA_Q_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_BBA_Q_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x40000000) >> 30
}
func (o *XCVR_TSM_Type) SetOVRD1_RX_BBA_Q_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD1.Reg, volatile.LoadUint32(&o.OVRD1.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TSM_Type) GetOVRD1_RX_BBA_Q_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD1.Reg) & 0x80000000) >> 31
}

// XCVR_TSM.OVRD2: TSM OVERRIDE REGISTER 2
func (o *XCVR_TSM_Type) SetOVRD2_RX_BBA_PDET_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x1)|value)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_BBA_PDET_EN_OVRD_EN() uint32 {
	return volatile.LoadUint32(&o.OVRD2.Reg) & 0x1
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_BBA_PDET_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_BBA_PDET_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x2) >> 1
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_BBA_DCOC_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_BBA_DCOC_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_BBA_DCOC_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_BBA_DCOC_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_LNA_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_LNA_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x10) >> 4
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_LNA_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_LNA_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x20) >> 5
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_I_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_I_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x40) >> 6
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_I_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_I_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x80) >> 7
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_Q_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_Q_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x100) >> 8
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_Q_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_Q_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x200) >> 9
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_PDET_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_PDET_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x400) >> 10
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_PDET_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_PDET_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x800) >> 11
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_DCOC_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_DCOC_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x1000) >> 12
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_TZA_DCOC_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_TZA_DCOC_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x2000) >> 13
}
func (o *XCVR_TSM_Type) SetOVRD2_PLL_DIG_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_TSM_Type) GetOVRD2_PLL_DIG_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x4000) >> 14
}
func (o *XCVR_TSM_Type) SetOVRD2_PLL_DIG_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_TSM_Type) GetOVRD2_PLL_DIG_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x8000) >> 15
}
func (o *XCVR_TSM_Type) SetOVRD2_TX_DIG_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TSM_Type) GetOVRD2_TX_DIG_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x10000) >> 16
}
func (o *XCVR_TSM_Type) SetOVRD2_TX_DIG_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TSM_Type) GetOVRD2_TX_DIG_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x20000) >> 17
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_DIG_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_DIG_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x40000) >> 18
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_DIG_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_DIG_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x80000) >> 19
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_INIT_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_INIT_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x100000) >> 20
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_INIT_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_INIT_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x200000) >> 21
}
func (o *XCVR_TSM_Type) SetOVRD2_SIGMA_DELTA_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_TSM_Type) GetOVRD2_SIGMA_DELTA_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x400000) >> 22
}
func (o *XCVR_TSM_Type) SetOVRD2_SIGMA_DELTA_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_TSM_Type) GetOVRD2_SIGMA_DELTA_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x800000) >> 23
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_PHY_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_PHY_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x1000000) >> 24
}
func (o *XCVR_TSM_Type) SetOVRD2_RX_PHY_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_TSM_Type) GetOVRD2_RX_PHY_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x2000000) >> 25
}
func (o *XCVR_TSM_Type) SetOVRD2_DCOC_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x4000000)|value<<26)
}
func (o *XCVR_TSM_Type) GetOVRD2_DCOC_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x4000000) >> 26
}
func (o *XCVR_TSM_Type) SetOVRD2_DCOC_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_TSM_Type) GetOVRD2_DCOC_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x8000000) >> 27
}
func (o *XCVR_TSM_Type) SetOVRD2_DCOC_INIT_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_TSM_Type) GetOVRD2_DCOC_INIT_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x10000000) >> 28
}
func (o *XCVR_TSM_Type) SetOVRD2_DCOC_INIT_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_TSM_Type) GetOVRD2_DCOC_INIT_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x20000000) >> 29
}
func (o *XCVR_TSM_Type) SetOVRD2_FREQ_TARG_LD_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_TSM_Type) GetOVRD2_FREQ_TARG_LD_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x40000000) >> 30
}
func (o *XCVR_TSM_Type) SetOVRD2_FREQ_TARG_LD_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD2.Reg, volatile.LoadUint32(&o.OVRD2.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TSM_Type) GetOVRD2_FREQ_TARG_LD_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD2.Reg) & 0x80000000) >> 31
}

// XCVR_TSM.OVRD3: TSM OVERRIDE REGISTER 3
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE0_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x1)|value)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE0_EN_OVRD_EN() uint32 {
	return volatile.LoadUint32(&o.OVRD3.Reg) & 0x1
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE0_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE0_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x2) >> 1
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE1_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE1_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE1_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE1_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE2_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE2_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x10) >> 4
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE2_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE2_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x20) >> 5
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE3_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE3_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x40) >> 6
}
func (o *XCVR_TSM_Type) SetOVRD3_TSM_SPARE3_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_TSM_Type) GetOVRD3_TSM_SPARE3_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x80) >> 7
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x100) >> 8
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_BIAS_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_BIAS_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x200) >> 9
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x400) >> 10
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_VCO_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_VCO_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x800) >> 11
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x1000) >> 12
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_FCAL_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x2000)|value<<13)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_FCAL_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x2000) >> 13
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x4000)|value<<14)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x4000) >> 14
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_LF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_LF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x8000) >> 15
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x10000) >> 16
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_PD_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_PD_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x20000) >> 17
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x40000) >> 18
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x80000) >> 19
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x100000) >> 20
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x200000) >> 21
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x400000) >> 22
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x800000) >> 23
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_RCCAL_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_RCCAL_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x1000000) >> 24
}
func (o *XCVR_TSM_Type) SetOVRD3_RXTX_RCCAL_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_TSM_Type) GetOVRD3_RXTX_RCCAL_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x2000000) >> 25
}
func (o *XCVR_TSM_Type) SetOVRD3_TX_HPM_DAC_EN_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x4000000)|value<<26)
}
func (o *XCVR_TSM_Type) GetOVRD3_TX_HPM_DAC_EN_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x4000000) >> 26
}
func (o *XCVR_TSM_Type) SetOVRD3_TX_HPM_DAC_EN_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_TSM_Type) GetOVRD3_TX_HPM_DAC_EN_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x8000000) >> 27
}
func (o *XCVR_TSM_Type) SetOVRD3_TX_MODE_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_TSM_Type) GetOVRD3_TX_MODE_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x10000000) >> 28
}
func (o *XCVR_TSM_Type) SetOVRD3_TX_MODE_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x20000000)|value<<29)
}
func (o *XCVR_TSM_Type) GetOVRD3_TX_MODE_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x20000000) >> 29
}
func (o *XCVR_TSM_Type) SetOVRD3_RX_MODE_OVRD_EN(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x40000000)|value<<30)
}
func (o *XCVR_TSM_Type) GetOVRD3_RX_MODE_OVRD_EN() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x40000000) >> 30
}
func (o *XCVR_TSM_Type) SetOVRD3_RX_MODE_OVRD(value uint32) {
	volatile.StoreUint32(&o.OVRD3.Reg, volatile.LoadUint32(&o.OVRD3.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_TSM_Type) GetOVRD3_RX_MODE_OVRD() uint32 {
	return (volatile.LoadUint32(&o.OVRD3.Reg) & 0x80000000) >> 31
}

// XCVR_TSM.PA_POWER: PA POWER
func (o *XCVR_TSM_Type) SetPA_POWER(value uint32) {
	volatile.StoreUint32(&o.PA_POWER.Reg, volatile.LoadUint32(&o.PA_POWER.Reg)&^(0x3f)|value)
}
func (o *XCVR_TSM_Type) GetPA_POWER() uint32 {
	return volatile.LoadUint32(&o.PA_POWER.Reg) & 0x3f
}

// XCVR_TSM.PA_RAMP_TBL0: PA RAMP TABLE 0
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL0_PA_RAMP0(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL0.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg)&^(0x3f)|value)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL0_PA_RAMP0() uint32 {
	return volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg) & 0x3f
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL0_PA_RAMP1(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL0.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL0_PA_RAMP1() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg) & 0x3f00) >> 8
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL0_PA_RAMP2(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL0.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg)&^(0x3f0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL0_PA_RAMP2() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg) & 0x3f0000) >> 16
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL0_PA_RAMP3(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL0.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg)&^(0x3f000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL0_PA_RAMP3() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL0.Reg) & 0x3f000000) >> 24
}

// XCVR_TSM.PA_RAMP_TBL1: PA RAMP TABLE 1
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL1_PA_RAMP4(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL1.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg)&^(0x3f)|value)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL1_PA_RAMP4() uint32 {
	return volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg) & 0x3f
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL1_PA_RAMP5(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL1.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg)&^(0x3f00)|value<<8)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL1_PA_RAMP5() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg) & 0x3f00) >> 8
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL1_PA_RAMP6(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL1.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg)&^(0x3f0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL1_PA_RAMP6() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg) & 0x3f0000) >> 16
}
func (o *XCVR_TSM_Type) SetPA_RAMP_TBL1_PA_RAMP7(value uint32) {
	volatile.StoreUint32(&o.PA_RAMP_TBL1.Reg, volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg)&^(0x3f000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetPA_RAMP_TBL1_PA_RAMP7() uint32 {
	return (volatile.LoadUint32(&o.PA_RAMP_TBL1.Reg) & 0x3f000000) >> 24
}

// XCVR_TSM.RECYCLE_COUNT: TSM RECYCLE COUNT
func (o *XCVR_TSM_Type) SetRECYCLE_COUNT_RECYCLE_COUNT0(value uint32) {
	volatile.StoreUint32(&o.RECYCLE_COUNT.Reg, volatile.LoadUint32(&o.RECYCLE_COUNT.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetRECYCLE_COUNT_RECYCLE_COUNT0() uint32 {
	return volatile.LoadUint32(&o.RECYCLE_COUNT.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetRECYCLE_COUNT_RECYCLE_COUNT1(value uint32) {
	volatile.StoreUint32(&o.RECYCLE_COUNT.Reg, volatile.LoadUint32(&o.RECYCLE_COUNT.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetRECYCLE_COUNT_RECYCLE_COUNT1() uint32 {
	return (volatile.LoadUint32(&o.RECYCLE_COUNT.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetRECYCLE_COUNT_RECYCLE_COUNT2(value uint32) {
	volatile.StoreUint32(&o.RECYCLE_COUNT.Reg, volatile.LoadUint32(&o.RECYCLE_COUNT.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetRECYCLE_COUNT_RECYCLE_COUNT2() uint32 {
	return (volatile.LoadUint32(&o.RECYCLE_COUNT.Reg) & 0xff0000) >> 16
}

// XCVR_TSM.FAST_CTRL1: TSM FAST WARMUP CONTROL REGISTER 1
func (o *XCVR_TSM_Type) SetFAST_CTRL1_FAST_TX_WU_EN(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL1.Reg, volatile.LoadUint32(&o.FAST_CTRL1.Reg)&^(0x1)|value)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL1_FAST_TX_WU_EN() uint32 {
	return volatile.LoadUint32(&o.FAST_CTRL1.Reg) & 0x1
}
func (o *XCVR_TSM_Type) SetFAST_CTRL1_FAST_RX_WU_EN(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL1.Reg, volatile.LoadUint32(&o.FAST_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL1_FAST_RX_WU_EN() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL1.Reg) & 0x2) >> 1
}
func (o *XCVR_TSM_Type) SetFAST_CTRL1_FAST_RX2TX_EN(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL1.Reg, volatile.LoadUint32(&o.FAST_CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL1_FAST_RX2TX_EN() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL1.Reg) & 0x4) >> 2
}
func (o *XCVR_TSM_Type) SetFAST_CTRL1_FAST_WU_CLEAR(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL1.Reg, volatile.LoadUint32(&o.FAST_CTRL1.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL1_FAST_WU_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL1.Reg) & 0x8) >> 3
}
func (o *XCVR_TSM_Type) SetFAST_CTRL1_FAST_RX2TX_START(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL1.Reg, volatile.LoadUint32(&o.FAST_CTRL1.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL1_FAST_RX2TX_START() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL1.Reg) & 0xff00) >> 8
}

// XCVR_TSM.FAST_CTRL2: TSM FAST WARMUP CONTROL REGISTER 2
func (o *XCVR_TSM_Type) SetFAST_CTRL2_FAST_START_TX(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL2.Reg, volatile.LoadUint32(&o.FAST_CTRL2.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL2_FAST_START_TX() uint32 {
	return volatile.LoadUint32(&o.FAST_CTRL2.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetFAST_CTRL2_FAST_DEST_TX(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL2.Reg, volatile.LoadUint32(&o.FAST_CTRL2.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL2_FAST_DEST_TX() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL2.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetFAST_CTRL2_FAST_START_RX(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL2.Reg, volatile.LoadUint32(&o.FAST_CTRL2.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL2_FAST_START_RX() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL2.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetFAST_CTRL2_FAST_DEST_RX(value uint32) {
	volatile.StoreUint32(&o.FAST_CTRL2.Reg, volatile.LoadUint32(&o.FAST_CTRL2.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetFAST_CTRL2_FAST_DEST_RX() uint32 {
	return (volatile.LoadUint32(&o.FAST_CTRL2.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING00: TSM_TIMING00
func (o *XCVR_TSM_Type) SetTIMING00_BB_LDO_HF_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING00.Reg, volatile.LoadUint32(&o.TIMING00.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING00_BB_LDO_HF_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING00.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING00_BB_LDO_HF_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING00.Reg, volatile.LoadUint32(&o.TIMING00.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING00_BB_LDO_HF_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING00.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING00_BB_LDO_HF_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING00.Reg, volatile.LoadUint32(&o.TIMING00.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING00_BB_LDO_HF_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING00.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING00_BB_LDO_HF_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING00.Reg, volatile.LoadUint32(&o.TIMING00.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING00_BB_LDO_HF_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING00.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING01: TSM_TIMING01
func (o *XCVR_TSM_Type) SetTIMING01_BB_LDO_ADCDAC_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING01.Reg, volatile.LoadUint32(&o.TIMING01.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING01_BB_LDO_ADCDAC_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING01.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING01_BB_LDO_ADCDAC_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING01.Reg, volatile.LoadUint32(&o.TIMING01.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING01_BB_LDO_ADCDAC_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING01.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING01_BB_LDO_ADCDAC_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING01.Reg, volatile.LoadUint32(&o.TIMING01.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING01_BB_LDO_ADCDAC_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING01.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING01_BB_LDO_ADCDAC_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING01.Reg, volatile.LoadUint32(&o.TIMING01.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING01_BB_LDO_ADCDAC_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING01.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING02: TSM_TIMING02
func (o *XCVR_TSM_Type) SetTIMING02_BB_LDO_BBA_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING02.Reg, volatile.LoadUint32(&o.TIMING02.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING02_BB_LDO_BBA_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING02.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING02_BB_LDO_BBA_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING02.Reg, volatile.LoadUint32(&o.TIMING02.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING02_BB_LDO_BBA_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING02.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING03: TSM_TIMING03
func (o *XCVR_TSM_Type) SetTIMING03_BB_LDO_PD_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING03.Reg, volatile.LoadUint32(&o.TIMING03.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING03_BB_LDO_PD_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING03.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING03_BB_LDO_PD_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING03.Reg, volatile.LoadUint32(&o.TIMING03.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING03_BB_LDO_PD_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING03.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING03_BB_LDO_PD_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING03.Reg, volatile.LoadUint32(&o.TIMING03.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING03_BB_LDO_PD_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING03.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING03_BB_LDO_PD_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING03.Reg, volatile.LoadUint32(&o.TIMING03.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING03_BB_LDO_PD_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING03.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING04: TSM_TIMING04
func (o *XCVR_TSM_Type) SetTIMING04_BB_LDO_FDBK_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING04.Reg, volatile.LoadUint32(&o.TIMING04.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING04_BB_LDO_FDBK_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING04.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING04_BB_LDO_FDBK_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING04.Reg, volatile.LoadUint32(&o.TIMING04.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING04_BB_LDO_FDBK_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING04.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING04_BB_LDO_FDBK_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING04.Reg, volatile.LoadUint32(&o.TIMING04.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING04_BB_LDO_FDBK_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING04.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING04_BB_LDO_FDBK_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING04.Reg, volatile.LoadUint32(&o.TIMING04.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING04_BB_LDO_FDBK_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING04.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING05: TSM_TIMING05
func (o *XCVR_TSM_Type) SetTIMING05_BB_LDO_VCOLO_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING05.Reg, volatile.LoadUint32(&o.TIMING05.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING05_BB_LDO_VCOLO_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING05.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING05_BB_LDO_VCOLO_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING05.Reg, volatile.LoadUint32(&o.TIMING05.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING05_BB_LDO_VCOLO_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING05.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING05_BB_LDO_VCOLO_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING05.Reg, volatile.LoadUint32(&o.TIMING05.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING05_BB_LDO_VCOLO_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING05.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING05_BB_LDO_VCOLO_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING05.Reg, volatile.LoadUint32(&o.TIMING05.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING05_BB_LDO_VCOLO_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING05.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING06: TSM_TIMING06
func (o *XCVR_TSM_Type) SetTIMING06_BB_LDO_VTREF_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING06.Reg, volatile.LoadUint32(&o.TIMING06.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING06_BB_LDO_VTREF_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING06.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING06_BB_LDO_VTREF_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING06.Reg, volatile.LoadUint32(&o.TIMING06.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING06_BB_LDO_VTREF_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING06.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING06_BB_LDO_VTREF_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING06.Reg, volatile.LoadUint32(&o.TIMING06.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING06_BB_LDO_VTREF_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING06.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING06_BB_LDO_VTREF_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING06.Reg, volatile.LoadUint32(&o.TIMING06.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING06_BB_LDO_VTREF_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING06.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING07: TSM_TIMING07
func (o *XCVR_TSM_Type) SetTIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING07.Reg, volatile.LoadUint32(&o.TIMING07.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING07.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING07.Reg, volatile.LoadUint32(&o.TIMING07.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING07.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING07.Reg, volatile.LoadUint32(&o.TIMING07.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING07.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING07.Reg, volatile.LoadUint32(&o.TIMING07.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING07.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING08: TSM_TIMING08
func (o *XCVR_TSM_Type) SetTIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING08.Reg, volatile.LoadUint32(&o.TIMING08.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING08.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING08.Reg, volatile.LoadUint32(&o.TIMING08.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING08.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING08.Reg, volatile.LoadUint32(&o.TIMING08.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING08.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING08.Reg, volatile.LoadUint32(&o.TIMING08.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING08.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING09: TSM_TIMING09
func (o *XCVR_TSM_Type) SetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING09.Reg, volatile.LoadUint32(&o.TIMING09.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING09.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING09.Reg, volatile.LoadUint32(&o.TIMING09.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING09.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING09.Reg, volatile.LoadUint32(&o.TIMING09.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING09.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING09.Reg, volatile.LoadUint32(&o.TIMING09.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING09.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING10: TSM_TIMING10
func (o *XCVR_TSM_Type) SetTIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING10.Reg, volatile.LoadUint32(&o.TIMING10.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING10.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING10.Reg, volatile.LoadUint32(&o.TIMING10.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING10.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING10.Reg, volatile.LoadUint32(&o.TIMING10.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING10.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING10.Reg, volatile.LoadUint32(&o.TIMING10.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING10.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING11: TSM_TIMING11
func (o *XCVR_TSM_Type) SetTIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING11.Reg, volatile.LoadUint32(&o.TIMING11.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING11.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING11.Reg, volatile.LoadUint32(&o.TIMING11.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING11.Reg) & 0xff00) >> 8
}

// XCVR_TSM.TIMING12: TSM_TIMING12
func (o *XCVR_TSM_Type) SetTIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING12.Reg, volatile.LoadUint32(&o.TIMING12.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING12.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING12.Reg, volatile.LoadUint32(&o.TIMING12.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING12.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING13: TSM_TIMING13
func (o *XCVR_TSM_Type) SetTIMING13_SY_VCO_AUTOTUNE_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING13.Reg, volatile.LoadUint32(&o.TIMING13.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING13_SY_VCO_AUTOTUNE_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING13.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING13_SY_VCO_AUTOTUNE_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING13.Reg, volatile.LoadUint32(&o.TIMING13.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING13_SY_VCO_AUTOTUNE_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING13.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING13_SY_VCO_AUTOTUNE_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING13.Reg, volatile.LoadUint32(&o.TIMING13.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING13_SY_VCO_AUTOTUNE_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING13.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING13_SY_VCO_AUTOTUNE_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING13.Reg, volatile.LoadUint32(&o.TIMING13.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING13_SY_VCO_AUTOTUNE_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING13.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING14: TSM_TIMING14
func (o *XCVR_TSM_Type) SetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING14.Reg, volatile.LoadUint32(&o.TIMING14.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING14.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING14.Reg, volatile.LoadUint32(&o.TIMING14.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING14.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING14.Reg, volatile.LoadUint32(&o.TIMING14.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING14.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING14.Reg, volatile.LoadUint32(&o.TIMING14.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING14.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING15: TSM_TIMING15
func (o *XCVR_TSM_Type) SetTIMING15_SY_VCO_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING15.Reg, volatile.LoadUint32(&o.TIMING15.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING15_SY_VCO_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING15.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING15_SY_VCO_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING15.Reg, volatile.LoadUint32(&o.TIMING15.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING15_SY_VCO_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING15.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING15_SY_VCO_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING15.Reg, volatile.LoadUint32(&o.TIMING15.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING15_SY_VCO_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING15.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING15_SY_VCO_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING15.Reg, volatile.LoadUint32(&o.TIMING15.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING15_SY_VCO_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING15.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING16: TSM_TIMING16
func (o *XCVR_TSM_Type) SetTIMING16_SY_LO_RX_BUF_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING16.Reg, volatile.LoadUint32(&o.TIMING16.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING16_SY_LO_RX_BUF_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING16.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING16_SY_LO_RX_BUF_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING16.Reg, volatile.LoadUint32(&o.TIMING16.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING16_SY_LO_RX_BUF_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING16.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING17: TSM_TIMING17
func (o *XCVR_TSM_Type) SetTIMING17_SY_LO_TX_BUF_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING17.Reg, volatile.LoadUint32(&o.TIMING17.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING17_SY_LO_TX_BUF_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING17.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING17_SY_LO_TX_BUF_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING17.Reg, volatile.LoadUint32(&o.TIMING17.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING17_SY_LO_TX_BUF_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING17.Reg) & 0xff00) >> 8
}

// XCVR_TSM.TIMING18: TSM_TIMING18
func (o *XCVR_TSM_Type) SetTIMING18_SY_DIVN_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING18.Reg, volatile.LoadUint32(&o.TIMING18.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING18_SY_DIVN_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING18.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING18_SY_DIVN_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING18.Reg, volatile.LoadUint32(&o.TIMING18.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING18_SY_DIVN_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING18.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING18_SY_DIVN_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING18.Reg, volatile.LoadUint32(&o.TIMING18.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING18_SY_DIVN_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING18.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING18_SY_DIVN_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING18.Reg, volatile.LoadUint32(&o.TIMING18.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING18_SY_DIVN_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING18.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING19: TSM_TIMING19
func (o *XCVR_TSM_Type) SetTIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING19.Reg, volatile.LoadUint32(&o.TIMING19.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING19.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING19.Reg, volatile.LoadUint32(&o.TIMING19.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING19.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING19.Reg, volatile.LoadUint32(&o.TIMING19.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING19.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING19.Reg, volatile.LoadUint32(&o.TIMING19.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING19.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING20: TSM_TIMING20
func (o *XCVR_TSM_Type) SetTIMING20_SY_PD_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING20.Reg, volatile.LoadUint32(&o.TIMING20.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING20_SY_PD_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING20.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING20_SY_PD_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING20.Reg, volatile.LoadUint32(&o.TIMING20.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING20_SY_PD_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING20.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING20_SY_PD_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING20.Reg, volatile.LoadUint32(&o.TIMING20.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING20_SY_PD_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING20.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING20_SY_PD_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING20.Reg, volatile.LoadUint32(&o.TIMING20.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING20_SY_PD_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING20.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING21: TSM_TIMING21
func (o *XCVR_TSM_Type) SetTIMING21_SY_LO_DIVN_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING21.Reg, volatile.LoadUint32(&o.TIMING21.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING21_SY_LO_DIVN_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING21.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING21_SY_LO_DIVN_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING21.Reg, volatile.LoadUint32(&o.TIMING21.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING21_SY_LO_DIVN_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING21.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING21_SY_LO_DIVN_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING21.Reg, volatile.LoadUint32(&o.TIMING21.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING21_SY_LO_DIVN_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING21.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING21_SY_LO_DIVN_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING21.Reg, volatile.LoadUint32(&o.TIMING21.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING21_SY_LO_DIVN_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING21.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING22: TSM_TIMING22
func (o *XCVR_TSM_Type) SetTIMING22_SY_LO_RX_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING22.Reg, volatile.LoadUint32(&o.TIMING22.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING22_SY_LO_RX_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING22.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING22_SY_LO_RX_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING22.Reg, volatile.LoadUint32(&o.TIMING22.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING22_SY_LO_RX_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING22.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING23: TSM_TIMING23
func (o *XCVR_TSM_Type) SetTIMING23_SY_LO_TX_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING23.Reg, volatile.LoadUint32(&o.TIMING23.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING23_SY_LO_TX_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING23.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING23_SY_LO_TX_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING23.Reg, volatile.LoadUint32(&o.TIMING23.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING23_SY_LO_TX_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING23.Reg) & 0xff00) >> 8
}

// XCVR_TSM.TIMING24: TSM_TIMING24
func (o *XCVR_TSM_Type) SetTIMING24_SY_DIVN_CAL_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING24.Reg, volatile.LoadUint32(&o.TIMING24.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING24_SY_DIVN_CAL_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING24.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING24_SY_DIVN_CAL_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING24.Reg, volatile.LoadUint32(&o.TIMING24.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING24_SY_DIVN_CAL_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING24.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING24_SY_DIVN_CAL_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING24.Reg, volatile.LoadUint32(&o.TIMING24.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING24_SY_DIVN_CAL_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING24.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING24_SY_DIVN_CAL_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING24.Reg, volatile.LoadUint32(&o.TIMING24.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING24_SY_DIVN_CAL_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING24.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING25: TSM_TIMING25
func (o *XCVR_TSM_Type) SetTIMING25_RX_LNA_MIXER_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING25.Reg, volatile.LoadUint32(&o.TIMING25.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING25_RX_LNA_MIXER_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING25.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING25_RX_LNA_MIXER_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING25.Reg, volatile.LoadUint32(&o.TIMING25.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING25_RX_LNA_MIXER_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING25.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING26: TSM_TIMING26
func (o *XCVR_TSM_Type) SetTIMING26_TX_PA_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING26.Reg, volatile.LoadUint32(&o.TIMING26.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING26_TX_PA_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING26.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING26_TX_PA_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING26.Reg, volatile.LoadUint32(&o.TIMING26.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING26_TX_PA_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING26.Reg) & 0xff00) >> 8
}

// XCVR_TSM.TIMING27: TSM_TIMING27
func (o *XCVR_TSM_Type) SetTIMING27_RX_ADC_I_Q_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING27.Reg, volatile.LoadUint32(&o.TIMING27.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING27_RX_ADC_I_Q_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING27.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING27_RX_ADC_I_Q_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING27.Reg, volatile.LoadUint32(&o.TIMING27.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING27_RX_ADC_I_Q_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING27.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING28: TSM_TIMING28
func (o *XCVR_TSM_Type) SetTIMING28_RX_ADC_RESET_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING28.Reg, volatile.LoadUint32(&o.TIMING28.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING28_RX_ADC_RESET_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING28.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING28_RX_ADC_RESET_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING28.Reg, volatile.LoadUint32(&o.TIMING28.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING28_RX_ADC_RESET_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING28.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING29: TSM_TIMING29
func (o *XCVR_TSM_Type) SetTIMING29_RX_BBA_I_Q_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING29.Reg, volatile.LoadUint32(&o.TIMING29.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING29_RX_BBA_I_Q_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING29.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING29_RX_BBA_I_Q_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING29.Reg, volatile.LoadUint32(&o.TIMING29.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING29_RX_BBA_I_Q_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING29.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING30: TSM_TIMING30
func (o *XCVR_TSM_Type) SetTIMING30_RX_BBA_PDET_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING30.Reg, volatile.LoadUint32(&o.TIMING30.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING30_RX_BBA_PDET_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING30.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING30_RX_BBA_PDET_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING30.Reg, volatile.LoadUint32(&o.TIMING30.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING30_RX_BBA_PDET_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING30.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING31: TSM_TIMING31
func (o *XCVR_TSM_Type) SetTIMING31_RX_BBA_TZA_DCOC_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING31.Reg, volatile.LoadUint32(&o.TIMING31.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING31_RX_BBA_TZA_DCOC_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING31.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING31_RX_BBA_TZA_DCOC_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING31.Reg, volatile.LoadUint32(&o.TIMING31.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING31_RX_BBA_TZA_DCOC_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING31.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING32: TSM_TIMING32
func (o *XCVR_TSM_Type) SetTIMING32_RX_TZA_I_Q_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING32.Reg, volatile.LoadUint32(&o.TIMING32.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING32_RX_TZA_I_Q_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING32.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING32_RX_TZA_I_Q_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING32.Reg, volatile.LoadUint32(&o.TIMING32.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING32_RX_TZA_I_Q_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING32.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING33: TSM_TIMING33
func (o *XCVR_TSM_Type) SetTIMING33_RX_TZA_PDET_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING33.Reg, volatile.LoadUint32(&o.TIMING33.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING33_RX_TZA_PDET_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING33.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING33_RX_TZA_PDET_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING33.Reg, volatile.LoadUint32(&o.TIMING33.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING33_RX_TZA_PDET_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING33.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING34: TSM_TIMING34
func (o *XCVR_TSM_Type) SetTIMING34_PLL_DIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING34.Reg, volatile.LoadUint32(&o.TIMING34.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING34_PLL_DIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING34.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING34_PLL_DIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING34.Reg, volatile.LoadUint32(&o.TIMING34.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING34_PLL_DIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING34.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING34_PLL_DIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING34.Reg, volatile.LoadUint32(&o.TIMING34.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING34_PLL_DIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING34.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING34_PLL_DIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING34.Reg, volatile.LoadUint32(&o.TIMING34.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING34_PLL_DIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING34.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING35: TSM_TIMING35
func (o *XCVR_TSM_Type) SetTIMING35_TX_DIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING35.Reg, volatile.LoadUint32(&o.TIMING35.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING35_TX_DIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING35.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING35_TX_DIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING35.Reg, volatile.LoadUint32(&o.TIMING35.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING35_TX_DIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING35.Reg) & 0xff00) >> 8
}

// XCVR_TSM.TIMING36: TSM_TIMING36
func (o *XCVR_TSM_Type) SetTIMING36_RX_DIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING36.Reg, volatile.LoadUint32(&o.TIMING36.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING36_RX_DIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING36.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING36_RX_DIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING36.Reg, volatile.LoadUint32(&o.TIMING36.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING36_RX_DIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING36.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING37: TSM_TIMING37
func (o *XCVR_TSM_Type) SetTIMING37_RX_INIT_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING37.Reg, volatile.LoadUint32(&o.TIMING37.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING37_RX_INIT_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING37.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING37_RX_INIT_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING37.Reg, volatile.LoadUint32(&o.TIMING37.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING37_RX_INIT_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING37.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING38: TSM_TIMING38
func (o *XCVR_TSM_Type) SetTIMING38_SIGMA_DELTA_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING38.Reg, volatile.LoadUint32(&o.TIMING38.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING38_SIGMA_DELTA_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING38.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING38_SIGMA_DELTA_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING38.Reg, volatile.LoadUint32(&o.TIMING38.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING38_SIGMA_DELTA_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING38.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING38_SIGMA_DELTA_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING38.Reg, volatile.LoadUint32(&o.TIMING38.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING38_SIGMA_DELTA_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING38.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING38_SIGMA_DELTA_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING38.Reg, volatile.LoadUint32(&o.TIMING38.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING38_SIGMA_DELTA_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING38.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING39: TSM_TIMING39
func (o *XCVR_TSM_Type) SetTIMING39_RX_PHY_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING39.Reg, volatile.LoadUint32(&o.TIMING39.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING39_RX_PHY_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING39.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING39_RX_PHY_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING39.Reg, volatile.LoadUint32(&o.TIMING39.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING39_RX_PHY_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING39.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING40: TSM_TIMING40
func (o *XCVR_TSM_Type) SetTIMING40_DCOC_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING40.Reg, volatile.LoadUint32(&o.TIMING40.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING40_DCOC_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING40.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING40_DCOC_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING40.Reg, volatile.LoadUint32(&o.TIMING40.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING40_DCOC_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING40.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING41: TSM_TIMING41
func (o *XCVR_TSM_Type) SetTIMING41_DCOC_INIT_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING41.Reg, volatile.LoadUint32(&o.TIMING41.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING41_DCOC_INIT_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING41.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING41_DCOC_INIT_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING41.Reg, volatile.LoadUint32(&o.TIMING41.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING41_DCOC_INIT_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING41.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING42: TSM_TIMING42
func (o *XCVR_TSM_Type) SetTIMING42_SAR_ADC_TRIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING42.Reg, volatile.LoadUint32(&o.TIMING42.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING42_SAR_ADC_TRIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING42.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING42_SAR_ADC_TRIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING42.Reg, volatile.LoadUint32(&o.TIMING42.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING42_SAR_ADC_TRIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING42.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING42_SAR_ADC_TRIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING42.Reg, volatile.LoadUint32(&o.TIMING42.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING42_SAR_ADC_TRIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING42.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING42_SAR_ADC_TRIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING42.Reg, volatile.LoadUint32(&o.TIMING42.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING42_SAR_ADC_TRIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING42.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING43: TSM_TIMING43
func (o *XCVR_TSM_Type) SetTIMING43_TSM_SPARE0_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING43.Reg, volatile.LoadUint32(&o.TIMING43.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING43_TSM_SPARE0_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING43.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING43_TSM_SPARE0_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING43.Reg, volatile.LoadUint32(&o.TIMING43.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING43_TSM_SPARE0_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING43.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING43_TSM_SPARE0_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING43.Reg, volatile.LoadUint32(&o.TIMING43.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING43_TSM_SPARE0_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING43.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING43_TSM_SPARE0_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING43.Reg, volatile.LoadUint32(&o.TIMING43.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING43_TSM_SPARE0_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING43.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING44: TSM_TIMING44
func (o *XCVR_TSM_Type) SetTIMING44_TSM_SPARE1_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING44.Reg, volatile.LoadUint32(&o.TIMING44.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING44_TSM_SPARE1_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING44.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING44_TSM_SPARE1_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING44.Reg, volatile.LoadUint32(&o.TIMING44.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING44_TSM_SPARE1_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING44.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING44_TSM_SPARE1_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING44.Reg, volatile.LoadUint32(&o.TIMING44.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING44_TSM_SPARE1_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING44.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING44_TSM_SPARE1_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING44.Reg, volatile.LoadUint32(&o.TIMING44.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING44_TSM_SPARE1_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING44.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING45: TSM_TIMING45
func (o *XCVR_TSM_Type) SetTIMING45_TSM_SPARE2_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING45.Reg, volatile.LoadUint32(&o.TIMING45.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING45_TSM_SPARE2_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING45.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING45_TSM_SPARE2_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING45.Reg, volatile.LoadUint32(&o.TIMING45.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING45_TSM_SPARE2_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING45.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING45_TSM_SPARE2_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING45.Reg, volatile.LoadUint32(&o.TIMING45.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING45_TSM_SPARE2_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING45.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING45_TSM_SPARE2_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING45.Reg, volatile.LoadUint32(&o.TIMING45.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING45_TSM_SPARE2_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING45.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING46: TSM_TIMING46
func (o *XCVR_TSM_Type) SetTIMING46_TSM_SPARE3_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING46.Reg, volatile.LoadUint32(&o.TIMING46.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING46_TSM_SPARE3_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING46.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING46_TSM_SPARE3_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING46.Reg, volatile.LoadUint32(&o.TIMING46.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING46_TSM_SPARE3_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING46.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING46_TSM_SPARE3_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING46.Reg, volatile.LoadUint32(&o.TIMING46.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING46_TSM_SPARE3_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING46.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING46_TSM_SPARE3_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING46.Reg, volatile.LoadUint32(&o.TIMING46.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING46_TSM_SPARE3_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING46.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING47: TSM_TIMING47
func (o *XCVR_TSM_Type) SetTIMING47_GPIO0_TRIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING47.Reg, volatile.LoadUint32(&o.TIMING47.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING47_GPIO0_TRIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING47.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING47_GPIO0_TRIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING47.Reg, volatile.LoadUint32(&o.TIMING47.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING47_GPIO0_TRIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING47.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING47_GPIO0_TRIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING47.Reg, volatile.LoadUint32(&o.TIMING47.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING47_GPIO0_TRIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING47.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING47_GPIO0_TRIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING47.Reg, volatile.LoadUint32(&o.TIMING47.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING47_GPIO0_TRIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING47.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING48: TSM_TIMING48
func (o *XCVR_TSM_Type) SetTIMING48_GPIO1_TRIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING48.Reg, volatile.LoadUint32(&o.TIMING48.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING48_GPIO1_TRIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING48.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING48_GPIO1_TRIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING48.Reg, volatile.LoadUint32(&o.TIMING48.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING48_GPIO1_TRIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING48.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING48_GPIO1_TRIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING48.Reg, volatile.LoadUint32(&o.TIMING48.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING48_GPIO1_TRIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING48.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING48_GPIO1_TRIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING48.Reg, volatile.LoadUint32(&o.TIMING48.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING48_GPIO1_TRIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING48.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING49: TSM_TIMING49
func (o *XCVR_TSM_Type) SetTIMING49_GPIO2_TRIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING49.Reg, volatile.LoadUint32(&o.TIMING49.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING49_GPIO2_TRIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING49.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING49_GPIO2_TRIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING49.Reg, volatile.LoadUint32(&o.TIMING49.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING49_GPIO2_TRIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING49.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING49_GPIO2_TRIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING49.Reg, volatile.LoadUint32(&o.TIMING49.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING49_GPIO2_TRIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING49.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING49_GPIO2_TRIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING49.Reg, volatile.LoadUint32(&o.TIMING49.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING49_GPIO2_TRIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING49.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING50: TSM_TIMING50
func (o *XCVR_TSM_Type) SetTIMING50_GPIO3_TRIG_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING50.Reg, volatile.LoadUint32(&o.TIMING50.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING50_GPIO3_TRIG_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING50.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING50_GPIO3_TRIG_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING50.Reg, volatile.LoadUint32(&o.TIMING50.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING50_GPIO3_TRIG_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING50.Reg) & 0xff00) >> 8
}
func (o *XCVR_TSM_Type) SetTIMING50_GPIO3_TRIG_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING50.Reg, volatile.LoadUint32(&o.TIMING50.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING50_GPIO3_TRIG_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING50.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING50_GPIO3_TRIG_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING50.Reg, volatile.LoadUint32(&o.TIMING50.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING50_GPIO3_TRIG_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING50.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING51: TSM_TIMING51
func (o *XCVR_TSM_Type) SetTIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING51.Reg, volatile.LoadUint32(&o.TIMING51.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING51.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING51.Reg, volatile.LoadUint32(&o.TIMING51.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING51.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING52: TSM_TIMING52
func (o *XCVR_TSM_Type) SetTIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING52.Reg, volatile.LoadUint32(&o.TIMING52.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING52.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING52.Reg, volatile.LoadUint32(&o.TIMING52.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING52.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING53: TSM_TIMING53
func (o *XCVR_TSM_Type) SetTIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING53.Reg, volatile.LoadUint32(&o.TIMING53.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING53.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING53.Reg, volatile.LoadUint32(&o.TIMING53.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING53.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING54: TSM_TIMING54
func (o *XCVR_TSM_Type) SetTIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING54.Reg, volatile.LoadUint32(&o.TIMING54.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING54.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING54.Reg, volatile.LoadUint32(&o.TIMING54.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING54.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING55: TSM_TIMING55
func (o *XCVR_TSM_Type) SetTIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING55.Reg, volatile.LoadUint32(&o.TIMING55.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING55.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING55.Reg, volatile.LoadUint32(&o.TIMING55.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING55.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING56: TSM_TIMING56
func (o *XCVR_TSM_Type) SetTIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING56.Reg, volatile.LoadUint32(&o.TIMING56.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING56.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING56.Reg, volatile.LoadUint32(&o.TIMING56.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING56.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING57: TSM_TIMING57
func (o *XCVR_TSM_Type) SetTIMING57_RXTX_RCCAL_EN_RX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING57.Reg, volatile.LoadUint32(&o.TIMING57.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_TSM_Type) GetTIMING57_RXTX_RCCAL_EN_RX_HI() uint32 {
	return (volatile.LoadUint32(&o.TIMING57.Reg) & 0xff0000) >> 16
}
func (o *XCVR_TSM_Type) SetTIMING57_RXTX_RCCAL_EN_RX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING57.Reg, volatile.LoadUint32(&o.TIMING57.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_TSM_Type) GetTIMING57_RXTX_RCCAL_EN_RX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING57.Reg) & 0xff000000) >> 24
}

// XCVR_TSM.TIMING58: TSM_TIMING58
func (o *XCVR_TSM_Type) SetTIMING58_TX_HPM_DAC_EN_TX_HI(value uint32) {
	volatile.StoreUint32(&o.TIMING58.Reg, volatile.LoadUint32(&o.TIMING58.Reg)&^(0xff)|value)
}
func (o *XCVR_TSM_Type) GetTIMING58_TX_HPM_DAC_EN_TX_HI() uint32 {
	return volatile.LoadUint32(&o.TIMING58.Reg) & 0xff
}
func (o *XCVR_TSM_Type) SetTIMING58_TX_HPM_DAC_EN_TX_LO(value uint32) {
	volatile.StoreUint32(&o.TIMING58.Reg, volatile.LoadUint32(&o.TIMING58.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_TSM_Type) GetTIMING58_TX_HPM_DAC_EN_TX_LO() uint32 {
	return (volatile.LoadUint32(&o.TIMING58.Reg) & 0xff00) >> 8
}

// XCVR_PHY
type XCVR_PHY_Type struct {
	PHY_PRE_REF0 volatile.Register32 // 0x0
	PRE_REF1     volatile.Register32 // 0x4
	PRE_REF2     volatile.Register32 // 0x8
	_            [20]byte
	CFG1         volatile.Register32 // 0x20
	CFG2         volatile.Register32 // 0x24
	EL_CFG       volatile.Register32 // 0x28
	NTW_ADR_BSM  volatile.Register32 // 0x2C
	STATUS       volatile.Register32 // 0x30
}

// XCVR_PHY.PHY_PRE_REF0: PREAMBLE REFERENCE WAVEFORM 0
func (o *XCVR_PHY_Type) SetPHY_PRE_REF0(value uint32) {
	volatile.StoreUint32(&o.PHY_PRE_REF0.Reg, value)
}
func (o *XCVR_PHY_Type) GetPHY_PRE_REF0() uint32 {
	return volatile.LoadUint32(&o.PHY_PRE_REF0.Reg)
}

// XCVR_PHY.PRE_REF1: PREAMBLE REFERENCE WAVEFORM 1
func (o *XCVR_PHY_Type) SetPRE_REF1(value uint32) {
	volatile.StoreUint32(&o.PRE_REF1.Reg, value)
}
func (o *XCVR_PHY_Type) GetPRE_REF1() uint32 {
	return volatile.LoadUint32(&o.PRE_REF1.Reg)
}

// XCVR_PHY.PRE_REF2: PREAMBLE REFERENCE WAVEFORM 2
func (o *XCVR_PHY_Type) SetPRE_REF2_FSK_PREAMBLE_REF2(value uint32) {
	volatile.StoreUint32(&o.PRE_REF2.Reg, volatile.LoadUint32(&o.PRE_REF2.Reg)&^(0xffff)|value)
}
func (o *XCVR_PHY_Type) GetPRE_REF2_FSK_PREAMBLE_REF2() uint32 {
	return volatile.LoadUint32(&o.PRE_REF2.Reg) & 0xffff
}

// XCVR_PHY.CFG1: PHY CONFIGURATION REGISTER 1
func (o *XCVR_PHY_Type) SetCFG1_AA_PLAYBACK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_PHY_Type) GetCFG1_AA_PLAYBACK() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2) >> 1
}
func (o *XCVR_PHY_Type) SetCFG1_AA_OUTPUT_SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_PHY_Type) GetCFG1_AA_OUTPUT_SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4) >> 2
}
func (o *XCVR_PHY_Type) SetCFG1_FSK_BIT_INVERT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_PHY_Type) GetCFG1_FSK_BIT_INVERT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8) >> 3
}
func (o *XCVR_PHY_Type) SetCFG1_RFU00(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_PHY_Type) GetCFG1_RFU00() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *XCVR_PHY_Type) SetCFG1_BSM_EN_BLE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_PHY_Type) GetCFG1_BSM_EN_BLE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20) >> 5
}
func (o *XCVR_PHY_Type) SetCFG1_DEMOD_CLK_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc0)|value<<6)
}
func (o *XCVR_PHY_Type) GetCFG1_DEMOD_CLK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc0) >> 6
}
func (o *XCVR_PHY_Type) SetCFG1_CTS_THRESH(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PHY_Type) GetCFG1_CTS_THRESH() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff00) >> 8
}
func (o *XCVR_PHY_Type) SetCFG1_FSK_FTS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x700000)|value<<20)
}
func (o *XCVR_PHY_Type) GetCFG1_FSK_FTS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x700000) >> 20
}
func (o *XCVR_PHY_Type) SetCFG1_RFU01(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_PHY_Type) GetCFG1_RFU01() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000000) >> 24
}
func (o *XCVR_PHY_Type) SetCFG1_RFU02(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_PHY_Type) GetCFG1_RFU02() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000000) >> 25
}
func (o *XCVR_PHY_Type) SetCFG1_BLE_NTW_ADR_THR(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x70000000)|value<<28)
}
func (o *XCVR_PHY_Type) GetCFG1_BLE_NTW_ADR_THR() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x70000000) >> 28
}

// XCVR_PHY.CFG2: PHY CONFIGURATION REGISTER 2
func (o *XCVR_PHY_Type) SetCFG2_PHY_FIFO_PRECHG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *XCVR_PHY_Type) GetCFG2_PHY_FIFO_PRECHG() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *XCVR_PHY_Type) SetCFG2_RFU03(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU03() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}
func (o *XCVR_PHY_Type) SetCFG2_RFU04(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU04() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x20) >> 5
}
func (o *XCVR_PHY_Type) SetCFG2_RFU05(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU05() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x40) >> 6
}
func (o *XCVR_PHY_Type) SetCFG2_RFU06(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU06() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80) >> 7
}
func (o *XCVR_PHY_Type) SetCFG2_X2_DEMOD_GAIN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_PHY_Type) GetCFG2_X2_DEMOD_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf00) >> 8
}
func (o *XCVR_PHY_Type) SetCFG2_RFU07(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU07() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *XCVR_PHY_Type) SetCFG2_RFU08(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU08() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x20000) >> 17
}
func (o *XCVR_PHY_Type) SetCFG2_RFU09(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x40000)|value<<18)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU09() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x40000) >> 18
}
func (o *XCVR_PHY_Type) SetCFG2_RFU10(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU10() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80000) >> 19
}
func (o *XCVR_PHY_Type) SetCFG2_RFU11(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU11() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *XCVR_PHY_Type) SetCFG2_RFU12(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU12() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *XCVR_PHY_Type) SetCFG2_RFU13(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU13() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *XCVR_PHY_Type) SetCFG2_RFU14(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU14() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x800000) >> 23
}
func (o *XCVR_PHY_Type) SetCFG2_RFU15(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU15() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000000) >> 24
}
func (o *XCVR_PHY_Type) SetCFG2_RFU16(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_PHY_Type) GetCFG2_RFU16() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000000) >> 25
}
func (o *XCVR_PHY_Type) SetCFG2_PHY_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_PHY_Type) GetCFG2_PHY_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x80000000) >> 31
}

// XCVR_PHY.EL_CFG: PHY EARLY/LATE CONFIGURATION REGISTER
func (o *XCVR_PHY_Type) SetEL_CFG_EL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EL_CFG.Reg, volatile.LoadUint32(&o.EL_CFG.Reg)&^(0x1)|value)
}
func (o *XCVR_PHY_Type) GetEL_CFG_EL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EL_CFG.Reg) & 0x1
}
func (o *XCVR_PHY_Type) SetEL_CFG_EL_ZB_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EL_CFG.Reg, volatile.LoadUint32(&o.EL_CFG.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_PHY_Type) GetEL_CFG_EL_ZB_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.EL_CFG.Reg) & 0x2) >> 1
}
func (o *XCVR_PHY_Type) SetEL_CFG_EL_ZB_WIN_SIZE(value uint32) {
	volatile.StoreUint32(&o.EL_CFG.Reg, volatile.LoadUint32(&o.EL_CFG.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_PHY_Type) GetEL_CFG_EL_ZB_WIN_SIZE() uint32 {
	return (volatile.LoadUint32(&o.EL_CFG.Reg) & 0x4) >> 2
}
func (o *XCVR_PHY_Type) SetEL_CFG_EL_WIN_SIZE(value uint32) {
	volatile.StoreUint32(&o.EL_CFG.Reg, volatile.LoadUint32(&o.EL_CFG.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_PHY_Type) GetEL_CFG_EL_WIN_SIZE() uint32 {
	return (volatile.LoadUint32(&o.EL_CFG.Reg) & 0xf00) >> 8
}
func (o *XCVR_PHY_Type) SetEL_CFG_EL_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.EL_CFG.Reg, volatile.LoadUint32(&o.EL_CFG.Reg)&^(0x3f0000)|value<<16)
}
func (o *XCVR_PHY_Type) GetEL_CFG_EL_INTERVAL() uint32 {
	return (volatile.LoadUint32(&o.EL_CFG.Reg) & 0x3f0000) >> 16
}

// XCVR_PHY.NTW_ADR_BSM: PHY NETWORK ADDRESS FOR BSM
func (o *XCVR_PHY_Type) SetNTW_ADR_BSM(value uint32) {
	volatile.StoreUint32(&o.NTW_ADR_BSM.Reg, value)
}
func (o *XCVR_PHY_Type) GetNTW_ADR_BSM() uint32 {
	return volatile.LoadUint32(&o.NTW_ADR_BSM.Reg)
}

// XCVR_PHY.STATUS: PHY STATUS REGISTER
func (o *XCVR_PHY_Type) SetSTATUS_PREAMBLE_FOUND(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *XCVR_PHY_Type) GetSTATUS_PREAMBLE_FOUND() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *XCVR_PHY_Type) SetSTATUS_AA_SFD_MATCHED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_PHY_Type) GetSTATUS_AA_SFD_MATCHED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *XCVR_PHY_Type) SetSTATUS_AA_MATCHED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf0)|value<<4)
}
func (o *XCVR_PHY_Type) GetSTATUS_AA_MATCHED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf0) >> 4
}
func (o *XCVR_PHY_Type) SetSTATUS_HAMMING_DISTANCE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x700)|value<<8)
}
func (o *XCVR_PHY_Type) GetSTATUS_HAMMING_DISTANCE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x700) >> 8
}
func (o *XCVR_PHY_Type) SetSTATUS_DATA_FIFO_DEPTH(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_PHY_Type) GetSTATUS_DATA_FIFO_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xf000) >> 12
}
func (o *XCVR_PHY_Type) SetSTATUS_CFO_ESTIMATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_PHY_Type) GetSTATUS_CFO_ESTIMATE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xff0000) >> 16
}

// XCVR_ZBDEMOD
type XCVR_ZBDEM_Type struct {
	CORR_CTRL   volatile.Register32 // 0x0
	PN_TYPE     volatile.Register32 // 0x4
	PN_CODE     volatile.Register32 // 0x8
	SYNC_CTRL   volatile.Register32 // 0xC
	CCA_LQI_SRC volatile.Register32 // 0x10
	FAD_THR     volatile.Register32 // 0x14
	ZBDEM_AFC   volatile.Register32 // 0x18
}

// XCVR_ZBDEM.CORR_CTRL: 802.15.4 DEMOD CORRELLATOR CONTROL
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_CORR_VT(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0xff)|value)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_CORR_VT() uint32 {
	return volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0xff
}
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_CORR_NVAL(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0x700)|value<<8)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_CORR_NVAL() uint32 {
	return (volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0x700) >> 8
}
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_MAX_CORR_EN(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_MAX_CORR_EN() uint32 {
	return (volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0x800) >> 11
}
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_ZBDEM_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_ZBDEM_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0x8000) >> 15
}
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_RX_MAX_CORR(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_RX_MAX_CORR() uint32 {
	return (volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0xff0000) >> 16
}
func (o *XCVR_ZBDEM_Type) SetCORR_CTRL_RX_MAX_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.CORR_CTRL.Reg, volatile.LoadUint32(&o.CORR_CTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *XCVR_ZBDEM_Type) GetCORR_CTRL_RX_MAX_PREAMBLE() uint32 {
	return (volatile.LoadUint32(&o.CORR_CTRL.Reg) & 0xff000000) >> 24
}

// XCVR_ZBDEM.PN_TYPE: 802.15.4 DEMOD PN TYPE
func (o *XCVR_ZBDEM_Type) SetPN_TYPE(value uint32) {
	volatile.StoreUint32(&o.PN_TYPE.Reg, volatile.LoadUint32(&o.PN_TYPE.Reg)&^(0x1)|value)
}
func (o *XCVR_ZBDEM_Type) GetPN_TYPE() uint32 {
	return volatile.LoadUint32(&o.PN_TYPE.Reg) & 0x1
}
func (o *XCVR_ZBDEM_Type) SetPN_TYPE_TX_INV(value uint32) {
	volatile.StoreUint32(&o.PN_TYPE.Reg, volatile.LoadUint32(&o.PN_TYPE.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ZBDEM_Type) GetPN_TYPE_TX_INV() uint32 {
	return (volatile.LoadUint32(&o.PN_TYPE.Reg) & 0x2) >> 1
}

// XCVR_ZBDEM.PN_CODE: 802.15.4 DEMOD PN CODE
func (o *XCVR_ZBDEM_Type) SetPN_CODE_PN_LSB(value uint32) {
	volatile.StoreUint32(&o.PN_CODE.Reg, volatile.LoadUint32(&o.PN_CODE.Reg)&^(0xffff)|value)
}
func (o *XCVR_ZBDEM_Type) GetPN_CODE_PN_LSB() uint32 {
	return volatile.LoadUint32(&o.PN_CODE.Reg) & 0xffff
}
func (o *XCVR_ZBDEM_Type) SetPN_CODE_PN_MSB(value uint32) {
	volatile.StoreUint32(&o.PN_CODE.Reg, volatile.LoadUint32(&o.PN_CODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *XCVR_ZBDEM_Type) GetPN_CODE_PN_MSB() uint32 {
	return (volatile.LoadUint32(&o.PN_CODE.Reg) & 0xffff0000) >> 16
}

// XCVR_ZBDEM.SYNC_CTRL: 802.15.4 DEMOD SYMBOL SYNC CONTROL
func (o *XCVR_ZBDEM_Type) SetSYNC_CTRL_SYNC_PER(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x7)|value)
}
func (o *XCVR_ZBDEM_Type) GetSYNC_CTRL_SYNC_PER() uint32 {
	return volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x7
}
func (o *XCVR_ZBDEM_Type) SetSYNC_CTRL_TRACK_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_ZBDEM_Type) GetSYNC_CTRL_TRACK_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x8) >> 3
}

// XCVR_ZBDEM.CCA_LQI_SRC: 802.15.4 CCA/LQI SOURCE
func (o *XCVR_ZBDEM_Type) SetCCA_LQI_SRC_CCA1_FROM_RX_DIG(value uint32) {
	volatile.StoreUint32(&o.CCA_LQI_SRC.Reg, volatile.LoadUint32(&o.CCA_LQI_SRC.Reg)&^(0x1)|value)
}
func (o *XCVR_ZBDEM_Type) GetCCA_LQI_SRC_CCA1_FROM_RX_DIG() uint32 {
	return volatile.LoadUint32(&o.CCA_LQI_SRC.Reg) & 0x1
}
func (o *XCVR_ZBDEM_Type) SetCCA_LQI_SRC_LQI_FROM_RX_DIG(value uint32) {
	volatile.StoreUint32(&o.CCA_LQI_SRC.Reg, volatile.LoadUint32(&o.CCA_LQI_SRC.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ZBDEM_Type) GetCCA_LQI_SRC_LQI_FROM_RX_DIG() uint32 {
	return (volatile.LoadUint32(&o.CCA_LQI_SRC.Reg) & 0x2) >> 1
}
func (o *XCVR_ZBDEM_Type) SetCCA_LQI_SRC_LQI_START_AT_SFD(value uint32) {
	volatile.StoreUint32(&o.CCA_LQI_SRC.Reg, volatile.LoadUint32(&o.CCA_LQI_SRC.Reg)&^(0x4)|value<<2)
}
func (o *XCVR_ZBDEM_Type) GetCCA_LQI_SRC_LQI_START_AT_SFD() uint32 {
	return (volatile.LoadUint32(&o.CCA_LQI_SRC.Reg) & 0x4) >> 2
}

// XCVR_ZBDEM.FAD_THR: FAD CORRELATOR THRESHOLD
func (o *XCVR_ZBDEM_Type) SetFAD_THR(value uint32) {
	volatile.StoreUint32(&o.FAD_THR.Reg, volatile.LoadUint32(&o.FAD_THR.Reg)&^(0xff)|value)
}
func (o *XCVR_ZBDEM_Type) GetFAD_THR() uint32 {
	return volatile.LoadUint32(&o.FAD_THR.Reg) & 0xff
}

// XCVR_ZBDEM.ZBDEM_AFC: 802.15.4 AFC STATUS
func (o *XCVR_ZBDEM_Type) SetZBDEM_AFC_AFC_EN(value uint32) {
	volatile.StoreUint32(&o.ZBDEM_AFC.Reg, volatile.LoadUint32(&o.ZBDEM_AFC.Reg)&^(0x1)|value)
}
func (o *XCVR_ZBDEM_Type) GetZBDEM_AFC_AFC_EN() uint32 {
	return volatile.LoadUint32(&o.ZBDEM_AFC.Reg) & 0x1
}
func (o *XCVR_ZBDEM_Type) SetZBDEM_AFC_DCD_EN(value uint32) {
	volatile.StoreUint32(&o.ZBDEM_AFC.Reg, volatile.LoadUint32(&o.ZBDEM_AFC.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ZBDEM_Type) GetZBDEM_AFC_DCD_EN() uint32 {
	return (volatile.LoadUint32(&o.ZBDEM_AFC.Reg) & 0x2) >> 1
}
func (o *XCVR_ZBDEM_Type) SetZBDEM_AFC_AFC_OUT(value uint32) {
	volatile.StoreUint32(&o.ZBDEM_AFC.Reg, volatile.LoadUint32(&o.ZBDEM_AFC.Reg)&^(0x1f00)|value<<8)
}
func (o *XCVR_ZBDEM_Type) GetZBDEM_AFC_AFC_OUT() uint32 {
	return (volatile.LoadUint32(&o.ZBDEM_AFC.Reg) & 0x1f00) >> 8
}

// XCVR_ANALOG
type XCVR_ANA_Type struct {
	BB_LDO_1   volatile.Register32 // 0x0
	BB_LDO_2   volatile.Register32 // 0x4
	RX_ADC     volatile.Register32 // 0x8
	RX_BBA     volatile.Register32 // 0xC
	RX_LNA     volatile.Register32 // 0x10
	RX_TZA     volatile.Register32 // 0x14
	RX_AUXPLL  volatile.Register32 // 0x18
	SY_CTRL_1  volatile.Register32 // 0x1C
	SY_CTRL_2  volatile.Register32 // 0x20
	TX_DAC_PA  volatile.Register32 // 0x24
	BALUN_TX   volatile.Register32 // 0x28
	BALUN_RX   volatile.Register32 // 0x2C
	DFT_OBSV_1 volatile.Register32 // 0x30
	DFT_OBSV_2 volatile.Register32 // 0x34
}

// XCVR_ANA.BB_LDO_1: RF Analog Baseband LDO Control 1
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_ADCDAC_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x1)|value)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_ADCDAC_BYP() uint32 {
	return volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x1
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_ADCDAC_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_ADCDAC_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x2) >> 1
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_ADCDAC_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0xc)|value<<2)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_ADCDAC_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0xc) >> 2
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_ADCDAC_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_ADCDAC_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x70) >> 4
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_BBA_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x100)|value<<8)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_BBA_BYP() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x100) >> 8
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_BBA_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_BBA_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x200) >> 9
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_BBA_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0xc00)|value<<10)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_BBA_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0xc00) >> 10
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_BBA_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_BBA_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x7000) >> 12
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_FDBK_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_FDBK_BYP() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x10000) >> 16
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_FDBK_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x20000)|value<<17)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_FDBK_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x20000) >> 17
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_FDBK_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0xc0000)|value<<18)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_FDBK_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0xc0000) >> 18
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_FDBK_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x700000)|value<<20)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_FDBK_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x700000) >> 20
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_HF_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_HF_BYP() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x1000000) >> 24
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_HF_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_HF_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x2000000) >> 25
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_HF_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0xc000000)|value<<26)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_HF_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0xc000000) >> 26
}
func (o *XCVR_ANA_Type) SetBB_LDO_1_BB_LDO_HF_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_1.Reg, volatile.LoadUint32(&o.BB_LDO_1.Reg)&^(0x70000000)|value<<28)
}
func (o *XCVR_ANA_Type) GetBB_LDO_1_BB_LDO_HF_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_1.Reg) & 0x70000000) >> 28
}

// XCVR_ANA.BB_LDO_2: RF Analog Baseband LDO Control 2
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_PD_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x1)|value)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_PD_BYP() uint32 {
	return volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x1
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_PD_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_PD_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x2) >> 1
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_PD_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0xc)|value<<2)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_PD_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0xc) >> 2
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_PD_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_PD_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x70) >> 4
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VCO_SPARE(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VCO_SPARE() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x300) >> 8
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VCOLO_BYP(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VCOLO_BYP() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x400) >> 10
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VCOLO_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VCOLO_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x800) >> 11
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VCOLO_TRIM(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VCOLO_TRIM() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x7000) >> 12
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VTREF_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VTREF_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x10000) >> 16
}
func (o *XCVR_ANA_Type) SetBB_LDO_2_BB_LDO_VTREF_TC(value uint32) {
	volatile.StoreUint32(&o.BB_LDO_2.Reg, volatile.LoadUint32(&o.BB_LDO_2.Reg)&^(0x60000)|value<<17)
}
func (o *XCVR_ANA_Type) GetBB_LDO_2_BB_LDO_VTREF_TC() uint32 {
	return (volatile.LoadUint32(&o.BB_LDO_2.Reg) & 0x60000) >> 17
}

// XCVR_ANA.RX_ADC: RF Analog ADC Control
func (o *XCVR_ANA_Type) SetRX_ADC_RX_ADC_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_ADC.Reg, volatile.LoadUint32(&o.RX_ADC.Reg)&^(0xff)|value)
}
func (o *XCVR_ANA_Type) GetRX_ADC_RX_ADC_BUMP() uint32 {
	return volatile.LoadUint32(&o.RX_ADC.Reg) & 0xff
}
func (o *XCVR_ANA_Type) SetRX_ADC_RX_ADC_FS_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_ADC.Reg, volatile.LoadUint32(&o.RX_ADC.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_ANA_Type) GetRX_ADC_RX_ADC_FS_SEL() uint32 {
	return (volatile.LoadUint32(&o.RX_ADC.Reg) & 0x300) >> 8
}
func (o *XCVR_ANA_Type) SetRX_ADC_RX_ADC_I_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_ADC.Reg, volatile.LoadUint32(&o.RX_ADC.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_ANA_Type) GetRX_ADC_RX_ADC_I_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_ADC.Reg) & 0x400) >> 10
}
func (o *XCVR_ANA_Type) SetRX_ADC_RX_ADC_Q_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_ADC.Reg, volatile.LoadUint32(&o.RX_ADC.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_ANA_Type) GetRX_ADC_RX_ADC_Q_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_ADC.Reg) & 0x800) >> 11
}
func (o *XCVR_ANA_Type) SetRX_ADC_RX_ADC_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_ADC.Reg, volatile.LoadUint32(&o.RX_ADC.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_ANA_Type) GetRX_ADC_RX_ADC_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_ADC.Reg) & 0xf000) >> 12
}

// XCVR_ANA.RX_BBA: RF Analog BBA Control
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_BW_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x7)|value)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_BW_SEL() uint32 {
	return volatile.LoadUint32(&o.RX_BBA.Reg) & 0x7
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_CUR_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_CUR_BUMP() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x8) >> 3
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_DIAGSEL1(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_DIAGSEL1() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x10) >> 4
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_DIAGSEL2(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_DIAGSEL2() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x20) >> 5
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_DIAGSEL3(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_DIAGSEL3() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x40) >> 6
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_DIAGSEL4(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x80)|value<<7)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_DIAGSEL4() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x80) >> 7
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x3f0000)|value<<16)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x3f0000) >> 16
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA2_BW_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA2_BW_SEL() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x7000000) >> 24
}
func (o *XCVR_ANA_Type) SetRX_BBA_RX_BBA2_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_BBA.Reg, volatile.LoadUint32(&o.RX_BBA.Reg)&^(0x70000000)|value<<28)
}
func (o *XCVR_ANA_Type) GetRX_BBA_RX_BBA2_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_BBA.Reg) & 0x70000000) >> 28
}

// XCVR_ANA.RX_LNA: RF Analog LNA Control
func (o *XCVR_ANA_Type) SetRX_LNA_RX_LNA_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0xf)|value)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_LNA_BUMP() uint32 {
	return volatile.LoadUint32(&o.RX_LNA.Reg) & 0xf
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_LNA_HG_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_LNA_HG_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0x10) >> 4
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_LNA_HIZ_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0x20)|value<<5)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_LNA_HIZ_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0x20) >> 5
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_LNA_LG_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0x40)|value<<6)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_LNA_LG_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0x40) >> 6
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_LNA_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_LNA_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0x300) >> 8
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_MIXER_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0xf0000)|value<<16)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_MIXER_BUMP() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0xf0000) >> 16
}
func (o *XCVR_ANA_Type) SetRX_LNA_RX_MIXER_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_LNA.Reg, volatile.LoadUint32(&o.RX_LNA.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_ANA_Type) GetRX_LNA_RX_MIXER_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_LNA.Reg) & 0x100000) >> 20
}

// XCVR_ANA.RX_TZA: RF Analog TZA Control
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA_BW_SEL(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x7)|value)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA_BW_SEL() uint32 {
	return volatile.LoadUint32(&o.RX_TZA.Reg) & 0x7
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA_CUR_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA_CUR_BUMP() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x8) >> 3
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA_GAIN_BUMP(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA_GAIN_BUMP() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x10) >> 4
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x3f0000)|value<<16)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x3f0000) >> 16
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA1_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x1000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA1_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x1000000) >> 24
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA2_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x2000000)|value<<25)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA2_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x2000000) >> 25
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA3_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x4000000)|value<<26)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA3_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x4000000) >> 26
}
func (o *XCVR_ANA_Type) SetRX_TZA_RX_TZA4_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_TZA.Reg, volatile.LoadUint32(&o.RX_TZA.Reg)&^(0x8000000)|value<<27)
}
func (o *XCVR_ANA_Type) GetRX_TZA_RX_TZA4_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_TZA.Reg) & 0x8000000) >> 27
}

// XCVR_ANA.RX_AUXPLL: RF Analog Aux PLL Control
func (o *XCVR_ANA_Type) SetRX_AUXPLL_BIAS_TRIM(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x7)|value)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_BIAS_TRIM() uint32 {
	return volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x7
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_DIAGSEL1(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_DIAGSEL1() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x8) >> 3
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_DIAGSEL2(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x10)|value<<4)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_DIAGSEL2() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x10) >> 4
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_LF_CNTL(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0xe0)|value<<5)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_LF_CNTL() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0xe0) >> 5
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0xf00)|value<<8)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0xf00) >> 8
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_VCO_DAC_REF_ADJUST(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0xf000)|value<<12)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_VCO_DAC_REF_ADJUST() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0xf000) >> 12
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_VTUNE_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x10000)|value<<16)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_VTUNE_TESTMODE() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x10000) >> 16
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_RXTX_BAL_BIAST(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x300000)|value<<20)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_RXTX_BAL_BIAST() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x300000) >> 20
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_RXTX_BAL_SPARE(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x7000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_RXTX_BAL_SPARE() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x7000000) >> 24
}
func (o *XCVR_ANA_Type) SetRX_AUXPLL_RXTX_RCCAL_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.RX_AUXPLL.Reg, volatile.LoadUint32(&o.RX_AUXPLL.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_ANA_Type) GetRX_AUXPLL_RXTX_RCCAL_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.RX_AUXPLL.Reg) & 0x10000000) >> 28
}

// XCVR_ANA.SY_CTRL_1: RF Analog Synthesizer Control 1
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_DIVN_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x1)|value)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_DIVN_SPARE() uint32 {
	return volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x1
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_FCAL_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x2)|value<<1)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_FCAL_SPARE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x2) >> 1
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LO_BUMP_RTLO_FDBK(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x30)|value<<4)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LO_BUMP_RTLO_FDBK() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x30) >> 4
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LO_BUMP_RTLO_RX(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0xc0)|value<<6)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LO_BUMP_RTLO_RX() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0xc0) >> 6
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LO_BUMP_RTLO_TX(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x300)|value<<8)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LO_BUMP_RTLO_TX() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x300) >> 8
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LO_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LO_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x400) >> 10
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LO_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x7000)|value<<12)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LO_SPARE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x7000) >> 12
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LPF_FILT_CTRL(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x70000)|value<<16)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LPF_FILT_CTRL() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x70000) >> 16
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_LPF_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x80000)|value<<19)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_LPF_SPARE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x80000) >> 19
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_PD_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x100000)|value<<20)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_PD_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x100000) >> 20
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_PD_PCH_TUNE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x600000)|value<<21)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_PD_PCH_TUNE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x600000) >> 21
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_PD_PCH_SEL(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x800000)|value<<23)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_PD_PCH_SEL() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x800000) >> 23
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_PD_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x3000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_PD_SPARE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x3000000) >> 24
}
func (o *XCVR_ANA_Type) SetSY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_1.Reg, volatile.LoadUint32(&o.SY_CTRL_1.Reg)&^(0x10000000)|value<<28)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_1.Reg) & 0x10000000) >> 28
}

// XCVR_ANA.SY_CTRL_2: RF Analog Synthesizer Control 2
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_BIAS(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x7)|value)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_BIAS() uint32 {
	return volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x7
}
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x8)|value<<3)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x8) >> 3
}
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_KV(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x70)|value<<4)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_KV() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x70) >> 4
}
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_KVM(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x700)|value<<8)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_KVM() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x700) >> 8
}
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_PK_DET_ON(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x1000)|value<<12)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_PK_DET_ON() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x1000) >> 12
}
func (o *XCVR_ANA_Type) SetSY_CTRL_2_SY_VCO_SPARE(value uint32) {
	volatile.StoreUint32(&o.SY_CTRL_2.Reg, volatile.LoadUint32(&o.SY_CTRL_2.Reg)&^(0x1c000)|value<<14)
}
func (o *XCVR_ANA_Type) GetSY_CTRL_2_SY_VCO_SPARE() uint32 {
	return (volatile.LoadUint32(&o.SY_CTRL_2.Reg) & 0x1c000) >> 14
}

// XCVR_ANA.TX_DAC_PA: RF Analog TX HPM DAC and PA Control
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_BUMP_CAP(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x3)|value)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_BUMP_CAP() uint32 {
	return volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x3
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_BUMP_IDAC(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x18)|value<<3)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_BUMP_IDAC() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x18) >> 3
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_BUMP_RLOAD(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0xc0)|value<<6)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_BUMP_RLOAD() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0xc0) >> 6
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x200)|value<<9)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x200) >> 9
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_INVERT_CLK(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x400)|value<<10)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_INVERT_CLK() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x400) >> 10
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_OPAMP_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x800)|value<<11)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_OPAMP_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x800) >> 11
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_DAC_SPARE(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0xe000)|value<<13)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_DAC_SPARE() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0xe000) >> 13
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_PA_BUMP_VBIAS(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0xe0000)|value<<17)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_PA_BUMP_VBIAS() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0xe0000) >> 17
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_PA_DIAGSEL(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x200000)|value<<21)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_PA_DIAGSEL() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x200000) >> 21
}
func (o *XCVR_ANA_Type) SetTX_DAC_PA_TX_PA_SPARE(value uint32) {
	volatile.StoreUint32(&o.TX_DAC_PA.Reg, volatile.LoadUint32(&o.TX_DAC_PA.Reg)&^(0x3800000)|value<<23)
}
func (o *XCVR_ANA_Type) GetTX_DAC_PA_TX_PA_SPARE() uint32 {
	return (volatile.LoadUint32(&o.TX_DAC_PA.Reg) & 0x3800000) >> 23
}

// XCVR_ANA.BALUN_TX: RF Analog Balun TX Mode Control
func (o *XCVR_ANA_Type) SetBALUN_TX_RXTX_BAL_TX_CODE(value uint32) {
	volatile.StoreUint32(&o.BALUN_TX.Reg, volatile.LoadUint32(&o.BALUN_TX.Reg)&^(0xffffff)|value)
}
func (o *XCVR_ANA_Type) GetBALUN_TX_RXTX_BAL_TX_CODE() uint32 {
	return volatile.LoadUint32(&o.BALUN_TX.Reg) & 0xffffff
}

// XCVR_ANA.BALUN_RX: RF Analog Balun RX Mode Control
func (o *XCVR_ANA_Type) SetBALUN_RX_RXTX_BAL_RX_CODE(value uint32) {
	volatile.StoreUint32(&o.BALUN_RX.Reg, volatile.LoadUint32(&o.BALUN_RX.Reg)&^(0xffffff)|value)
}
func (o *XCVR_ANA_Type) GetBALUN_RX_RXTX_BAL_RX_CODE() uint32 {
	return volatile.LoadUint32(&o.BALUN_RX.Reg) & 0xffffff
}

// XCVR_ANA.DFT_OBSV_1: RF Analog DFT Observation Register 1
func (o *XCVR_ANA_Type) SetDFT_OBSV_1_DFT_FREQ_COUNTER(value uint32) {
	volatile.StoreUint32(&o.DFT_OBSV_1.Reg, volatile.LoadUint32(&o.DFT_OBSV_1.Reg)&^(0x7ffff)|value)
}
func (o *XCVR_ANA_Type) GetDFT_OBSV_1_DFT_FREQ_COUNTER() uint32 {
	return volatile.LoadUint32(&o.DFT_OBSV_1.Reg) & 0x7ffff
}
func (o *XCVR_ANA_Type) SetDFT_OBSV_1_CTUNE_MAX_DIFF(value uint32) {
	volatile.StoreUint32(&o.DFT_OBSV_1.Reg, volatile.LoadUint32(&o.DFT_OBSV_1.Reg)&^(0xff00000)|value<<20)
}
func (o *XCVR_ANA_Type) GetDFT_OBSV_1_CTUNE_MAX_DIFF() uint32 {
	return (volatile.LoadUint32(&o.DFT_OBSV_1.Reg) & 0xff00000) >> 20
}

// XCVR_ANA.DFT_OBSV_2: RF Analog DFT Observation Register 2
func (o *XCVR_ANA_Type) SetDFT_OBSV_2_SYN_BIST_MAX_DIFF(value uint32) {
	volatile.StoreUint32(&o.DFT_OBSV_2.Reg, volatile.LoadUint32(&o.DFT_OBSV_2.Reg)&^(0x1ffff)|value)
}
func (o *XCVR_ANA_Type) GetDFT_OBSV_2_SYN_BIST_MAX_DIFF() uint32 {
	return volatile.LoadUint32(&o.DFT_OBSV_2.Reg) & 0x1ffff
}
func (o *XCVR_ANA_Type) SetDFT_OBSV_2_SYN_BIST_MAX_DIFF_CH(value uint32) {
	volatile.StoreUint32(&o.DFT_OBSV_2.Reg, volatile.LoadUint32(&o.DFT_OBSV_2.Reg)&^(0x7f000000)|value<<24)
}
func (o *XCVR_ANA_Type) GetDFT_OBSV_2_SYN_BIST_MAX_DIFF_CH() uint32 {
	return (volatile.LoadUint32(&o.DFT_OBSV_2.Reg) & 0x7f000000) >> 24
}
func (o *XCVR_ANA_Type) SetDFT_OBSV_2_SYN_BIST_IGNORE_FAILS(value uint32) {
	volatile.StoreUint32(&o.DFT_OBSV_2.Reg, volatile.LoadUint32(&o.DFT_OBSV_2.Reg)&^(0x80000000)|value<<31)
}
func (o *XCVR_ANA_Type) GetDFT_OBSV_2_SYN_BIST_IGNORE_FAILS() uint32 {
	return (volatile.LoadUint32(&o.DFT_OBSV_2.Reg) & 0x80000000) >> 31
}

// XCVR_PKT_RAM
type XCVR_PKT_RAM_Type struct {
	PACKET_RAM_0_0   volatile.Register16 // 0x0
	PACKET_RAM_0_1   volatile.Register16 // 0x2
	PACKET_RAM_0_2   volatile.Register16 // 0x4
	PACKET_RAM_0_3   volatile.Register16 // 0x6
	PACKET_RAM_0_4   volatile.Register16 // 0x8
	PACKET_RAM_0_5   volatile.Register16 // 0xA
	PACKET_RAM_0_6   volatile.Register16 // 0xC
	PACKET_RAM_0_7   volatile.Register16 // 0xE
	PACKET_RAM_0_8   volatile.Register16 // 0x10
	PACKET_RAM_0_9   volatile.Register16 // 0x12
	PACKET_RAM_0_10  volatile.Register16 // 0x14
	PACKET_RAM_0_11  volatile.Register16 // 0x16
	PACKET_RAM_0_12  volatile.Register16 // 0x18
	PACKET_RAM_0_13  volatile.Register16 // 0x1A
	PACKET_RAM_0_14  volatile.Register16 // 0x1C
	PACKET_RAM_0_15  volatile.Register16 // 0x1E
	PACKET_RAM_0_16  volatile.Register16 // 0x20
	PACKET_RAM_0_17  volatile.Register16 // 0x22
	PACKET_RAM_0_18  volatile.Register16 // 0x24
	PACKET_RAM_0_19  volatile.Register16 // 0x26
	PACKET_RAM_0_20  volatile.Register16 // 0x28
	PACKET_RAM_0_21  volatile.Register16 // 0x2A
	PACKET_RAM_0_22  volatile.Register16 // 0x2C
	PACKET_RAM_0_23  volatile.Register16 // 0x2E
	PACKET_RAM_0_24  volatile.Register16 // 0x30
	PACKET_RAM_0_25  volatile.Register16 // 0x32
	PACKET_RAM_0_26  volatile.Register16 // 0x34
	PACKET_RAM_0_27  volatile.Register16 // 0x36
	PACKET_RAM_0_28  volatile.Register16 // 0x38
	PACKET_RAM_0_29  volatile.Register16 // 0x3A
	PACKET_RAM_0_30  volatile.Register16 // 0x3C
	PACKET_RAM_0_31  volatile.Register16 // 0x3E
	PACKET_RAM_0_32  volatile.Register16 // 0x40
	PACKET_RAM_0_33  volatile.Register16 // 0x42
	PACKET_RAM_0_34  volatile.Register16 // 0x44
	PACKET_RAM_0_35  volatile.Register16 // 0x46
	PACKET_RAM_0_36  volatile.Register16 // 0x48
	PACKET_RAM_0_37  volatile.Register16 // 0x4A
	PACKET_RAM_0_38  volatile.Register16 // 0x4C
	PACKET_RAM_0_39  volatile.Register16 // 0x4E
	PACKET_RAM_0_40  volatile.Register16 // 0x50
	PACKET_RAM_0_41  volatile.Register16 // 0x52
	PACKET_RAM_0_42  volatile.Register16 // 0x54
	PACKET_RAM_0_43  volatile.Register16 // 0x56
	PACKET_RAM_0_44  volatile.Register16 // 0x58
	PACKET_RAM_0_45  volatile.Register16 // 0x5A
	PACKET_RAM_0_46  volatile.Register16 // 0x5C
	PACKET_RAM_0_47  volatile.Register16 // 0x5E
	PACKET_RAM_0_48  volatile.Register16 // 0x60
	PACKET_RAM_0_49  volatile.Register16 // 0x62
	PACKET_RAM_0_50  volatile.Register16 // 0x64
	PACKET_RAM_0_51  volatile.Register16 // 0x66
	PACKET_RAM_0_52  volatile.Register16 // 0x68
	PACKET_RAM_0_53  volatile.Register16 // 0x6A
	PACKET_RAM_0_54  volatile.Register16 // 0x6C
	PACKET_RAM_0_55  volatile.Register16 // 0x6E
	PACKET_RAM_0_56  volatile.Register16 // 0x70
	PACKET_RAM_0_57  volatile.Register16 // 0x72
	PACKET_RAM_0_58  volatile.Register16 // 0x74
	PACKET_RAM_0_59  volatile.Register16 // 0x76
	PACKET_RAM_0_60  volatile.Register16 // 0x78
	PACKET_RAM_0_61  volatile.Register16 // 0x7A
	PACKET_RAM_0_62  volatile.Register16 // 0x7C
	PACKET_RAM_0_63  volatile.Register16 // 0x7E
	PACKET_RAM_0_64  volatile.Register16 // 0x80
	PACKET_RAM_0_65  volatile.Register16 // 0x82
	PACKET_RAM_0_66  volatile.Register16 // 0x84
	PACKET_RAM_0_67  volatile.Register16 // 0x86
	PACKET_RAM_0_68  volatile.Register16 // 0x88
	PACKET_RAM_0_69  volatile.Register16 // 0x8A
	PACKET_RAM_0_70  volatile.Register16 // 0x8C
	PACKET_RAM_0_71  volatile.Register16 // 0x8E
	PACKET_RAM_0_72  volatile.Register16 // 0x90
	PACKET_RAM_0_73  volatile.Register16 // 0x92
	PACKET_RAM_0_74  volatile.Register16 // 0x94
	PACKET_RAM_0_75  volatile.Register16 // 0x96
	PACKET_RAM_0_76  volatile.Register16 // 0x98
	PACKET_RAM_0_77  volatile.Register16 // 0x9A
	PACKET_RAM_0_78  volatile.Register16 // 0x9C
	PACKET_RAM_0_79  volatile.Register16 // 0x9E
	PACKET_RAM_0_80  volatile.Register16 // 0xA0
	PACKET_RAM_0_81  volatile.Register16 // 0xA2
	PACKET_RAM_0_82  volatile.Register16 // 0xA4
	PACKET_RAM_0_83  volatile.Register16 // 0xA6
	PACKET_RAM_0_84  volatile.Register16 // 0xA8
	PACKET_RAM_0_85  volatile.Register16 // 0xAA
	PACKET_RAM_0_86  volatile.Register16 // 0xAC
	PACKET_RAM_0_87  volatile.Register16 // 0xAE
	PACKET_RAM_0_88  volatile.Register16 // 0xB0
	PACKET_RAM_0_89  volatile.Register16 // 0xB2
	PACKET_RAM_0_90  volatile.Register16 // 0xB4
	PACKET_RAM_0_91  volatile.Register16 // 0xB6
	PACKET_RAM_0_92  volatile.Register16 // 0xB8
	PACKET_RAM_0_93  volatile.Register16 // 0xBA
	PACKET_RAM_0_94  volatile.Register16 // 0xBC
	PACKET_RAM_0_95  volatile.Register16 // 0xBE
	PACKET_RAM_0_96  volatile.Register16 // 0xC0
	PACKET_RAM_0_97  volatile.Register16 // 0xC2
	PACKET_RAM_0_98  volatile.Register16 // 0xC4
	PACKET_RAM_0_99  volatile.Register16 // 0xC6
	PACKET_RAM_0_100 volatile.Register16 // 0xC8
	PACKET_RAM_0_101 volatile.Register16 // 0xCA
	PACKET_RAM_0_102 volatile.Register16 // 0xCC
	PACKET_RAM_0_103 volatile.Register16 // 0xCE
	PACKET_RAM_0_104 volatile.Register16 // 0xD0
	PACKET_RAM_0_105 volatile.Register16 // 0xD2
	PACKET_RAM_0_106 volatile.Register16 // 0xD4
	PACKET_RAM_0_107 volatile.Register16 // 0xD6
	PACKET_RAM_0_108 volatile.Register16 // 0xD8
	PACKET_RAM_0_109 volatile.Register16 // 0xDA
	PACKET_RAM_0_110 volatile.Register16 // 0xDC
	PACKET_RAM_0_111 volatile.Register16 // 0xDE
	PACKET_RAM_0_112 volatile.Register16 // 0xE0
	PACKET_RAM_0_113 volatile.Register16 // 0xE2
	PACKET_RAM_0_114 volatile.Register16 // 0xE4
	PACKET_RAM_0_115 volatile.Register16 // 0xE6
	PACKET_RAM_0_116 volatile.Register16 // 0xE8
	PACKET_RAM_0_117 volatile.Register16 // 0xEA
	PACKET_RAM_0_118 volatile.Register16 // 0xEC
	PACKET_RAM_0_119 volatile.Register16 // 0xEE
	PACKET_RAM_0_120 volatile.Register16 // 0xF0
	PACKET_RAM_0_121 volatile.Register16 // 0xF2
	PACKET_RAM_0_122 volatile.Register16 // 0xF4
	PACKET_RAM_0_123 volatile.Register16 // 0xF6
	PACKET_RAM_0_124 volatile.Register16 // 0xF8
	PACKET_RAM_0_125 volatile.Register16 // 0xFA
	PACKET_RAM_0_126 volatile.Register16 // 0xFC
	PACKET_RAM_0_127 volatile.Register16 // 0xFE
	PACKET_RAM_0_128 volatile.Register16 // 0x100
	PACKET_RAM_0_129 volatile.Register16 // 0x102
	PACKET_RAM_0_130 volatile.Register16 // 0x104
	PACKET_RAM_0_131 volatile.Register16 // 0x106
	PACKET_RAM_0_132 volatile.Register16 // 0x108
	PACKET_RAM_0_133 volatile.Register16 // 0x10A
	PACKET_RAM_0_134 volatile.Register16 // 0x10C
	PACKET_RAM_0_135 volatile.Register16 // 0x10E
	PACKET_RAM_0_136 volatile.Register16 // 0x110
	PACKET_RAM_0_137 volatile.Register16 // 0x112
	PACKET_RAM_0_138 volatile.Register16 // 0x114
	PACKET_RAM_0_139 volatile.Register16 // 0x116
	PACKET_RAM_0_140 volatile.Register16 // 0x118
	PACKET_RAM_0_141 volatile.Register16 // 0x11A
	PACKET_RAM_0_142 volatile.Register16 // 0x11C
	PACKET_RAM_0_143 volatile.Register16 // 0x11E
	PACKET_RAM_0_144 volatile.Register16 // 0x120
	PACKET_RAM_0_145 volatile.Register16 // 0x122
	PACKET_RAM_0_146 volatile.Register16 // 0x124
	PACKET_RAM_0_147 volatile.Register16 // 0x126
	PACKET_RAM_0_148 volatile.Register16 // 0x128
	PACKET_RAM_0_149 volatile.Register16 // 0x12A
	PACKET_RAM_0_150 volatile.Register16 // 0x12C
	PACKET_RAM_0_151 volatile.Register16 // 0x12E
	PACKET_RAM_0_152 volatile.Register16 // 0x130
	PACKET_RAM_0_153 volatile.Register16 // 0x132
	PACKET_RAM_0_154 volatile.Register16 // 0x134
	PACKET_RAM_0_155 volatile.Register16 // 0x136
	PACKET_RAM_0_156 volatile.Register16 // 0x138
	PACKET_RAM_0_157 volatile.Register16 // 0x13A
	PACKET_RAM_0_158 volatile.Register16 // 0x13C
	PACKET_RAM_0_159 volatile.Register16 // 0x13E
	PACKET_RAM_0_160 volatile.Register16 // 0x140
	PACKET_RAM_0_161 volatile.Register16 // 0x142
	PACKET_RAM_0_162 volatile.Register16 // 0x144
	PACKET_RAM_0_163 volatile.Register16 // 0x146
	PACKET_RAM_0_164 volatile.Register16 // 0x148
	PACKET_RAM_0_165 volatile.Register16 // 0x14A
	PACKET_RAM_0_166 volatile.Register16 // 0x14C
	PACKET_RAM_0_167 volatile.Register16 // 0x14E
	PACKET_RAM_0_168 volatile.Register16 // 0x150
	PACKET_RAM_0_169 volatile.Register16 // 0x152
	PACKET_RAM_0_170 volatile.Register16 // 0x154
	PACKET_RAM_0_171 volatile.Register16 // 0x156
	PACKET_RAM_0_172 volatile.Register16 // 0x158
	PACKET_RAM_0_173 volatile.Register16 // 0x15A
	PACKET_RAM_0_174 volatile.Register16 // 0x15C
	PACKET_RAM_0_175 volatile.Register16 // 0x15E
	PACKET_RAM_0_176 volatile.Register16 // 0x160
	PACKET_RAM_0_177 volatile.Register16 // 0x162
	PACKET_RAM_0_178 volatile.Register16 // 0x164
	PACKET_RAM_0_179 volatile.Register16 // 0x166
	PACKET_RAM_0_180 volatile.Register16 // 0x168
	PACKET_RAM_0_181 volatile.Register16 // 0x16A
	PACKET_RAM_0_182 volatile.Register16 // 0x16C
	PACKET_RAM_0_183 volatile.Register16 // 0x16E
	PACKET_RAM_0_184 volatile.Register16 // 0x170
	PACKET_RAM_0_185 volatile.Register16 // 0x172
	PACKET_RAM_0_186 volatile.Register16 // 0x174
	PACKET_RAM_0_187 volatile.Register16 // 0x176
	PACKET_RAM_0_188 volatile.Register16 // 0x178
	PACKET_RAM_0_189 volatile.Register16 // 0x17A
	PACKET_RAM_0_190 volatile.Register16 // 0x17C
	PACKET_RAM_0_191 volatile.Register16 // 0x17E
	PACKET_RAM_0_192 volatile.Register16 // 0x180
	PACKET_RAM_0_193 volatile.Register16 // 0x182
	PACKET_RAM_0_194 volatile.Register16 // 0x184
	PACKET_RAM_0_195 volatile.Register16 // 0x186
	PACKET_RAM_0_196 volatile.Register16 // 0x188
	PACKET_RAM_0_197 volatile.Register16 // 0x18A
	PACKET_RAM_0_198 volatile.Register16 // 0x18C
	PACKET_RAM_0_199 volatile.Register16 // 0x18E
	PACKET_RAM_0_200 volatile.Register16 // 0x190
	PACKET_RAM_0_201 volatile.Register16 // 0x192
	PACKET_RAM_0_202 volatile.Register16 // 0x194
	PACKET_RAM_0_203 volatile.Register16 // 0x196
	PACKET_RAM_0_204 volatile.Register16 // 0x198
	PACKET_RAM_0_205 volatile.Register16 // 0x19A
	PACKET_RAM_0_206 volatile.Register16 // 0x19C
	PACKET_RAM_0_207 volatile.Register16 // 0x19E
	PACKET_RAM_0_208 volatile.Register16 // 0x1A0
	PACKET_RAM_0_209 volatile.Register16 // 0x1A2
	PACKET_RAM_0_210 volatile.Register16 // 0x1A4
	PACKET_RAM_0_211 volatile.Register16 // 0x1A6
	PACKET_RAM_0_212 volatile.Register16 // 0x1A8
	PACKET_RAM_0_213 volatile.Register16 // 0x1AA
	PACKET_RAM_0_214 volatile.Register16 // 0x1AC
	PACKET_RAM_0_215 volatile.Register16 // 0x1AE
	PACKET_RAM_0_216 volatile.Register16 // 0x1B0
	PACKET_RAM_0_217 volatile.Register16 // 0x1B2
	PACKET_RAM_0_218 volatile.Register16 // 0x1B4
	PACKET_RAM_0_219 volatile.Register16 // 0x1B6
	PACKET_RAM_0_220 volatile.Register16 // 0x1B8
	PACKET_RAM_0_221 volatile.Register16 // 0x1BA
	PACKET_RAM_0_222 volatile.Register16 // 0x1BC
	PACKET_RAM_0_223 volatile.Register16 // 0x1BE
	PACKET_RAM_0_224 volatile.Register16 // 0x1C0
	PACKET_RAM_0_225 volatile.Register16 // 0x1C2
	PACKET_RAM_0_226 volatile.Register16 // 0x1C4
	PACKET_RAM_0_227 volatile.Register16 // 0x1C6
	PACKET_RAM_0_228 volatile.Register16 // 0x1C8
	PACKET_RAM_0_229 volatile.Register16 // 0x1CA
	PACKET_RAM_0_230 volatile.Register16 // 0x1CC
	PACKET_RAM_0_231 volatile.Register16 // 0x1CE
	PACKET_RAM_0_232 volatile.Register16 // 0x1D0
	PACKET_RAM_0_233 volatile.Register16 // 0x1D2
	PACKET_RAM_0_234 volatile.Register16 // 0x1D4
	PACKET_RAM_0_235 volatile.Register16 // 0x1D6
	PACKET_RAM_0_236 volatile.Register16 // 0x1D8
	PACKET_RAM_0_237 volatile.Register16 // 0x1DA
	PACKET_RAM_0_238 volatile.Register16 // 0x1DC
	PACKET_RAM_0_239 volatile.Register16 // 0x1DE
	PACKET_RAM_0_240 volatile.Register16 // 0x1E0
	PACKET_RAM_0_241 volatile.Register16 // 0x1E2
	PACKET_RAM_0_242 volatile.Register16 // 0x1E4
	PACKET_RAM_0_243 volatile.Register16 // 0x1E6
	PACKET_RAM_0_244 volatile.Register16 // 0x1E8
	PACKET_RAM_0_245 volatile.Register16 // 0x1EA
	PACKET_RAM_0_246 volatile.Register16 // 0x1EC
	PACKET_RAM_0_247 volatile.Register16 // 0x1EE
	PACKET_RAM_0_248 volatile.Register16 // 0x1F0
	PACKET_RAM_0_249 volatile.Register16 // 0x1F2
	PACKET_RAM_0_250 volatile.Register16 // 0x1F4
	PACKET_RAM_0_251 volatile.Register16 // 0x1F6
	PACKET_RAM_0_252 volatile.Register16 // 0x1F8
	PACKET_RAM_0_253 volatile.Register16 // 0x1FA
	PACKET_RAM_0_254 volatile.Register16 // 0x1FC
	PACKET_RAM_0_255 volatile.Register16 // 0x1FE
	PACKET_RAM_0_256 volatile.Register16 // 0x200
	PACKET_RAM_0_257 volatile.Register16 // 0x202
	PACKET_RAM_0_258 volatile.Register16 // 0x204
	PACKET_RAM_0_259 volatile.Register16 // 0x206
	PACKET_RAM_0_260 volatile.Register16 // 0x208
	PACKET_RAM_0_261 volatile.Register16 // 0x20A
	PACKET_RAM_0_262 volatile.Register16 // 0x20C
	PACKET_RAM_0_263 volatile.Register16 // 0x20E
	PACKET_RAM_0_264 volatile.Register16 // 0x210
	PACKET_RAM_0_265 volatile.Register16 // 0x212
	PACKET_RAM_0_266 volatile.Register16 // 0x214
	PACKET_RAM_0_267 volatile.Register16 // 0x216
	PACKET_RAM_0_268 volatile.Register16 // 0x218
	PACKET_RAM_0_269 volatile.Register16 // 0x21A
	PACKET_RAM_0_270 volatile.Register16 // 0x21C
	PACKET_RAM_0_271 volatile.Register16 // 0x21E
	PACKET_RAM_0_272 volatile.Register16 // 0x220
	PACKET_RAM_0_273 volatile.Register16 // 0x222
	PACKET_RAM_0_274 volatile.Register16 // 0x224
	PACKET_RAM_0_275 volatile.Register16 // 0x226
	PACKET_RAM_0_276 volatile.Register16 // 0x228
	PACKET_RAM_0_277 volatile.Register16 // 0x22A
	PACKET_RAM_0_278 volatile.Register16 // 0x22C
	PACKET_RAM_0_279 volatile.Register16 // 0x22E
	PACKET_RAM_0_280 volatile.Register16 // 0x230
	PACKET_RAM_0_281 volatile.Register16 // 0x232
	PACKET_RAM_0_282 volatile.Register16 // 0x234
	PACKET_RAM_0_283 volatile.Register16 // 0x236
	PACKET_RAM_0_284 volatile.Register16 // 0x238
	PACKET_RAM_0_285 volatile.Register16 // 0x23A
	PACKET_RAM_0_286 volatile.Register16 // 0x23C
	PACKET_RAM_0_287 volatile.Register16 // 0x23E
	PACKET_RAM_0_288 volatile.Register16 // 0x240
	PACKET_RAM_0_289 volatile.Register16 // 0x242
	PACKET_RAM_0_290 volatile.Register16 // 0x244
	PACKET_RAM_0_291 volatile.Register16 // 0x246
	PACKET_RAM_0_292 volatile.Register16 // 0x248
	PACKET_RAM_0_293 volatile.Register16 // 0x24A
	PACKET_RAM_0_294 volatile.Register16 // 0x24C
	PACKET_RAM_0_295 volatile.Register16 // 0x24E
	PACKET_RAM_0_296 volatile.Register16 // 0x250
	PACKET_RAM_0_297 volatile.Register16 // 0x252
	PACKET_RAM_0_298 volatile.Register16 // 0x254
	PACKET_RAM_0_299 volatile.Register16 // 0x256
	PACKET_RAM_0_300 volatile.Register16 // 0x258
	PACKET_RAM_0_301 volatile.Register16 // 0x25A
	PACKET_RAM_0_302 volatile.Register16 // 0x25C
	PACKET_RAM_0_303 volatile.Register16 // 0x25E
	PACKET_RAM_0_304 volatile.Register16 // 0x260
	PACKET_RAM_0_305 volatile.Register16 // 0x262
	PACKET_RAM_0_306 volatile.Register16 // 0x264
	PACKET_RAM_0_307 volatile.Register16 // 0x266
	PACKET_RAM_0_308 volatile.Register16 // 0x268
	PACKET_RAM_0_309 volatile.Register16 // 0x26A
	PACKET_RAM_0_310 volatile.Register16 // 0x26C
	PACKET_RAM_0_311 volatile.Register16 // 0x26E
	PACKET_RAM_0_312 volatile.Register16 // 0x270
	PACKET_RAM_0_313 volatile.Register16 // 0x272
	PACKET_RAM_0_314 volatile.Register16 // 0x274
	PACKET_RAM_0_315 volatile.Register16 // 0x276
	PACKET_RAM_0_316 volatile.Register16 // 0x278
	PACKET_RAM_0_317 volatile.Register16 // 0x27A
	PACKET_RAM_0_318 volatile.Register16 // 0x27C
	PACKET_RAM_0_319 volatile.Register16 // 0x27E
	PACKET_RAM_0_320 volatile.Register16 // 0x280
	PACKET_RAM_0_321 volatile.Register16 // 0x282
	PACKET_RAM_0_322 volatile.Register16 // 0x284
	PACKET_RAM_0_323 volatile.Register16 // 0x286
	PACKET_RAM_0_324 volatile.Register16 // 0x288
	PACKET_RAM_0_325 volatile.Register16 // 0x28A
	PACKET_RAM_0_326 volatile.Register16 // 0x28C
	PACKET_RAM_0_327 volatile.Register16 // 0x28E
	PACKET_RAM_0_328 volatile.Register16 // 0x290
	PACKET_RAM_0_329 volatile.Register16 // 0x292
	PACKET_RAM_0_330 volatile.Register16 // 0x294
	PACKET_RAM_0_331 volatile.Register16 // 0x296
	PACKET_RAM_0_332 volatile.Register16 // 0x298
	PACKET_RAM_0_333 volatile.Register16 // 0x29A
	PACKET_RAM_0_334 volatile.Register16 // 0x29C
	PACKET_RAM_0_335 volatile.Register16 // 0x29E
	PACKET_RAM_0_336 volatile.Register16 // 0x2A0
	PACKET_RAM_0_337 volatile.Register16 // 0x2A2
	PACKET_RAM_0_338 volatile.Register16 // 0x2A4
	PACKET_RAM_0_339 volatile.Register16 // 0x2A6
	PACKET_RAM_0_340 volatile.Register16 // 0x2A8
	PACKET_RAM_0_341 volatile.Register16 // 0x2AA
	PACKET_RAM_0_342 volatile.Register16 // 0x2AC
	PACKET_RAM_0_343 volatile.Register16 // 0x2AE
	PACKET_RAM_0_344 volatile.Register16 // 0x2B0
	PACKET_RAM_0_345 volatile.Register16 // 0x2B2
	PACKET_RAM_0_346 volatile.Register16 // 0x2B4
	PACKET_RAM_0_347 volatile.Register16 // 0x2B6
	PACKET_RAM_0_348 volatile.Register16 // 0x2B8
	PACKET_RAM_0_349 volatile.Register16 // 0x2BA
	PACKET_RAM_0_350 volatile.Register16 // 0x2BC
	PACKET_RAM_0_351 volatile.Register16 // 0x2BE
	PACKET_RAM_0_352 volatile.Register16 // 0x2C0
	PACKET_RAM_0_353 volatile.Register16 // 0x2C2
	PACKET_RAM_0_354 volatile.Register16 // 0x2C4
	PACKET_RAM_0_355 volatile.Register16 // 0x2C6
	PACKET_RAM_0_356 volatile.Register16 // 0x2C8
	PACKET_RAM_0_357 volatile.Register16 // 0x2CA
	PACKET_RAM_0_358 volatile.Register16 // 0x2CC
	PACKET_RAM_0_359 volatile.Register16 // 0x2CE
	PACKET_RAM_0_360 volatile.Register16 // 0x2D0
	PACKET_RAM_0_361 volatile.Register16 // 0x2D2
	PACKET_RAM_0_362 volatile.Register16 // 0x2D4
	PACKET_RAM_0_363 volatile.Register16 // 0x2D6
	PACKET_RAM_0_364 volatile.Register16 // 0x2D8
	PACKET_RAM_0_365 volatile.Register16 // 0x2DA
	PACKET_RAM_0_366 volatile.Register16 // 0x2DC
	PACKET_RAM_0_367 volatile.Register16 // 0x2DE
	PACKET_RAM_0_368 volatile.Register16 // 0x2E0
	PACKET_RAM_0_369 volatile.Register16 // 0x2E2
	PACKET_RAM_0_370 volatile.Register16 // 0x2E4
	PACKET_RAM_0_371 volatile.Register16 // 0x2E6
	PACKET_RAM_0_372 volatile.Register16 // 0x2E8
	PACKET_RAM_0_373 volatile.Register16 // 0x2EA
	PACKET_RAM_0_374 volatile.Register16 // 0x2EC
	PACKET_RAM_0_375 volatile.Register16 // 0x2EE
	PACKET_RAM_0_376 volatile.Register16 // 0x2F0
	PACKET_RAM_0_377 volatile.Register16 // 0x2F2
	PACKET_RAM_0_378 volatile.Register16 // 0x2F4
	PACKET_RAM_0_379 volatile.Register16 // 0x2F6
	PACKET_RAM_0_380 volatile.Register16 // 0x2F8
	PACKET_RAM_0_381 volatile.Register16 // 0x2FA
	PACKET_RAM_0_382 volatile.Register16 // 0x2FC
	PACKET_RAM_0_383 volatile.Register16 // 0x2FE
	PACKET_RAM_0_384 volatile.Register16 // 0x300
	PACKET_RAM_0_385 volatile.Register16 // 0x302
	PACKET_RAM_0_386 volatile.Register16 // 0x304
	PACKET_RAM_0_387 volatile.Register16 // 0x306
	PACKET_RAM_0_388 volatile.Register16 // 0x308
	PACKET_RAM_0_389 volatile.Register16 // 0x30A
	PACKET_RAM_0_390 volatile.Register16 // 0x30C
	PACKET_RAM_0_391 volatile.Register16 // 0x30E
	PACKET_RAM_0_392 volatile.Register16 // 0x310
	PACKET_RAM_0_393 volatile.Register16 // 0x312
	PACKET_RAM_0_394 volatile.Register16 // 0x314
	PACKET_RAM_0_395 volatile.Register16 // 0x316
	PACKET_RAM_0_396 volatile.Register16 // 0x318
	PACKET_RAM_0_397 volatile.Register16 // 0x31A
	PACKET_RAM_0_398 volatile.Register16 // 0x31C
	PACKET_RAM_0_399 volatile.Register16 // 0x31E
	PACKET_RAM_0_400 volatile.Register16 // 0x320
	PACKET_RAM_0_401 volatile.Register16 // 0x322
	PACKET_RAM_0_402 volatile.Register16 // 0x324
	PACKET_RAM_0_403 volatile.Register16 // 0x326
	PACKET_RAM_0_404 volatile.Register16 // 0x328
	PACKET_RAM_0_405 volatile.Register16 // 0x32A
	PACKET_RAM_0_406 volatile.Register16 // 0x32C
	PACKET_RAM_0_407 volatile.Register16 // 0x32E
	PACKET_RAM_0_408 volatile.Register16 // 0x330
	PACKET_RAM_0_409 volatile.Register16 // 0x332
	PACKET_RAM_0_410 volatile.Register16 // 0x334
	PACKET_RAM_0_411 volatile.Register16 // 0x336
	PACKET_RAM_0_412 volatile.Register16 // 0x338
	PACKET_RAM_0_413 volatile.Register16 // 0x33A
	PACKET_RAM_0_414 volatile.Register16 // 0x33C
	PACKET_RAM_0_415 volatile.Register16 // 0x33E
	PACKET_RAM_0_416 volatile.Register16 // 0x340
	PACKET_RAM_0_417 volatile.Register16 // 0x342
	PACKET_RAM_0_418 volatile.Register16 // 0x344
	PACKET_RAM_0_419 volatile.Register16 // 0x346
	PACKET_RAM_0_420 volatile.Register16 // 0x348
	PACKET_RAM_0_421 volatile.Register16 // 0x34A
	PACKET_RAM_0_422 volatile.Register16 // 0x34C
	PACKET_RAM_0_423 volatile.Register16 // 0x34E
	PACKET_RAM_0_424 volatile.Register16 // 0x350
	PACKET_RAM_0_425 volatile.Register16 // 0x352
	PACKET_RAM_0_426 volatile.Register16 // 0x354
	PACKET_RAM_0_427 volatile.Register16 // 0x356
	PACKET_RAM_0_428 volatile.Register16 // 0x358
	PACKET_RAM_0_429 volatile.Register16 // 0x35A
	PACKET_RAM_0_430 volatile.Register16 // 0x35C
	PACKET_RAM_0_431 volatile.Register16 // 0x35E
	PACKET_RAM_0_432 volatile.Register16 // 0x360
	PACKET_RAM_0_433 volatile.Register16 // 0x362
	PACKET_RAM_0_434 volatile.Register16 // 0x364
	PACKET_RAM_0_435 volatile.Register16 // 0x366
	PACKET_RAM_0_436 volatile.Register16 // 0x368
	PACKET_RAM_0_437 volatile.Register16 // 0x36A
	PACKET_RAM_0_438 volatile.Register16 // 0x36C
	PACKET_RAM_0_439 volatile.Register16 // 0x36E
	PACKET_RAM_0_440 volatile.Register16 // 0x370
	PACKET_RAM_0_441 volatile.Register16 // 0x372
	PACKET_RAM_0_442 volatile.Register16 // 0x374
	PACKET_RAM_0_443 volatile.Register16 // 0x376
	PACKET_RAM_0_444 volatile.Register16 // 0x378
	PACKET_RAM_0_445 volatile.Register16 // 0x37A
	PACKET_RAM_0_446 volatile.Register16 // 0x37C
	PACKET_RAM_0_447 volatile.Register16 // 0x37E
	PACKET_RAM_0_448 volatile.Register16 // 0x380
	PACKET_RAM_0_449 volatile.Register16 // 0x382
	PACKET_RAM_0_450 volatile.Register16 // 0x384
	PACKET_RAM_0_451 volatile.Register16 // 0x386
	PACKET_RAM_0_452 volatile.Register16 // 0x388
	PACKET_RAM_0_453 volatile.Register16 // 0x38A
	PACKET_RAM_0_454 volatile.Register16 // 0x38C
	PACKET_RAM_0_455 volatile.Register16 // 0x38E
	PACKET_RAM_0_456 volatile.Register16 // 0x390
	PACKET_RAM_0_457 volatile.Register16 // 0x392
	PACKET_RAM_0_458 volatile.Register16 // 0x394
	PACKET_RAM_0_459 volatile.Register16 // 0x396
	PACKET_RAM_0_460 volatile.Register16 // 0x398
	PACKET_RAM_0_461 volatile.Register16 // 0x39A
	PACKET_RAM_0_462 volatile.Register16 // 0x39C
	PACKET_RAM_0_463 volatile.Register16 // 0x39E
	PACKET_RAM_0_464 volatile.Register16 // 0x3A0
	PACKET_RAM_0_465 volatile.Register16 // 0x3A2
	PACKET_RAM_0_466 volatile.Register16 // 0x3A4
	PACKET_RAM_0_467 volatile.Register16 // 0x3A6
	PACKET_RAM_0_468 volatile.Register16 // 0x3A8
	PACKET_RAM_0_469 volatile.Register16 // 0x3AA
	PACKET_RAM_0_470 volatile.Register16 // 0x3AC
	PACKET_RAM_0_471 volatile.Register16 // 0x3AE
	PACKET_RAM_0_472 volatile.Register16 // 0x3B0
	PACKET_RAM_0_473 volatile.Register16 // 0x3B2
	PACKET_RAM_0_474 volatile.Register16 // 0x3B4
	PACKET_RAM_0_475 volatile.Register16 // 0x3B6
	PACKET_RAM_0_476 volatile.Register16 // 0x3B8
	PACKET_RAM_0_477 volatile.Register16 // 0x3BA
	PACKET_RAM_0_478 volatile.Register16 // 0x3BC
	PACKET_RAM_0_479 volatile.Register16 // 0x3BE
	PACKET_RAM_0_480 volatile.Register16 // 0x3C0
	PACKET_RAM_0_481 volatile.Register16 // 0x3C2
	PACKET_RAM_0_482 volatile.Register16 // 0x3C4
	PACKET_RAM_0_483 volatile.Register16 // 0x3C6
	PACKET_RAM_0_484 volatile.Register16 // 0x3C8
	PACKET_RAM_0_485 volatile.Register16 // 0x3CA
	PACKET_RAM_0_486 volatile.Register16 // 0x3CC
	PACKET_RAM_0_487 volatile.Register16 // 0x3CE
	PACKET_RAM_0_488 volatile.Register16 // 0x3D0
	PACKET_RAM_0_489 volatile.Register16 // 0x3D2
	PACKET_RAM_0_490 volatile.Register16 // 0x3D4
	PACKET_RAM_0_491 volatile.Register16 // 0x3D6
	PACKET_RAM_0_492 volatile.Register16 // 0x3D8
	PACKET_RAM_0_493 volatile.Register16 // 0x3DA
	PACKET_RAM_0_494 volatile.Register16 // 0x3DC
	PACKET_RAM_0_495 volatile.Register16 // 0x3DE
	PACKET_RAM_0_496 volatile.Register16 // 0x3E0
	PACKET_RAM_0_497 volatile.Register16 // 0x3E2
	PACKET_RAM_0_498 volatile.Register16 // 0x3E4
	PACKET_RAM_0_499 volatile.Register16 // 0x3E6
	PACKET_RAM_0_500 volatile.Register16 // 0x3E8
	PACKET_RAM_0_501 volatile.Register16 // 0x3EA
	PACKET_RAM_0_502 volatile.Register16 // 0x3EC
	PACKET_RAM_0_503 volatile.Register16 // 0x3EE
	PACKET_RAM_0_504 volatile.Register16 // 0x3F0
	PACKET_RAM_0_505 volatile.Register16 // 0x3F2
	PACKET_RAM_0_506 volatile.Register16 // 0x3F4
	PACKET_RAM_0_507 volatile.Register16 // 0x3F6
	PACKET_RAM_0_508 volatile.Register16 // 0x3F8
	PACKET_RAM_0_509 volatile.Register16 // 0x3FA
	PACKET_RAM_0_510 volatile.Register16 // 0x3FC
	PACKET_RAM_0_511 volatile.Register16 // 0x3FE
	PACKET_RAM_0_512 volatile.Register16 // 0x400
	PACKET_RAM_0_513 volatile.Register16 // 0x402
	PACKET_RAM_0_514 volatile.Register16 // 0x404
	PACKET_RAM_0_515 volatile.Register16 // 0x406
	PACKET_RAM_0_516 volatile.Register16 // 0x408
	PACKET_RAM_0_517 volatile.Register16 // 0x40A
	PACKET_RAM_0_518 volatile.Register16 // 0x40C
	PACKET_RAM_0_519 volatile.Register16 // 0x40E
	PACKET_RAM_0_520 volatile.Register16 // 0x410
	PACKET_RAM_0_521 volatile.Register16 // 0x412
	PACKET_RAM_0_522 volatile.Register16 // 0x414
	PACKET_RAM_0_523 volatile.Register16 // 0x416
	PACKET_RAM_0_524 volatile.Register16 // 0x418
	PACKET_RAM_0_525 volatile.Register16 // 0x41A
	PACKET_RAM_0_526 volatile.Register16 // 0x41C
	PACKET_RAM_0_527 volatile.Register16 // 0x41E
	PACKET_RAM_0_528 volatile.Register16 // 0x420
	PACKET_RAM_0_529 volatile.Register16 // 0x422
	PACKET_RAM_0_530 volatile.Register16 // 0x424
	PACKET_RAM_0_531 volatile.Register16 // 0x426
	PACKET_RAM_0_532 volatile.Register16 // 0x428
	PACKET_RAM_0_533 volatile.Register16 // 0x42A
	PACKET_RAM_0_534 volatile.Register16 // 0x42C
	PACKET_RAM_0_535 volatile.Register16 // 0x42E
	PACKET_RAM_0_536 volatile.Register16 // 0x430
	PACKET_RAM_0_537 volatile.Register16 // 0x432
	PACKET_RAM_0_538 volatile.Register16 // 0x434
	PACKET_RAM_0_539 volatile.Register16 // 0x436
	PACKET_RAM_0_540 volatile.Register16 // 0x438
	PACKET_RAM_0_541 volatile.Register16 // 0x43A
	PACKET_RAM_0_542 volatile.Register16 // 0x43C
	PACKET_RAM_0_543 volatile.Register16 // 0x43E
	PACKET_RAM_1_0   volatile.Register16 // 0x440
	PACKET_RAM_1_1   volatile.Register16 // 0x442
	PACKET_RAM_1_2   volatile.Register16 // 0x444
	PACKET_RAM_1_3   volatile.Register16 // 0x446
	PACKET_RAM_1_4   volatile.Register16 // 0x448
	PACKET_RAM_1_5   volatile.Register16 // 0x44A
	PACKET_RAM_1_6   volatile.Register16 // 0x44C
	PACKET_RAM_1_7   volatile.Register16 // 0x44E
	PACKET_RAM_1_8   volatile.Register16 // 0x450
	PACKET_RAM_1_9   volatile.Register16 // 0x452
	PACKET_RAM_1_10  volatile.Register16 // 0x454
	PACKET_RAM_1_11  volatile.Register16 // 0x456
	PACKET_RAM_1_12  volatile.Register16 // 0x458
	PACKET_RAM_1_13  volatile.Register16 // 0x45A
	PACKET_RAM_1_14  volatile.Register16 // 0x45C
	PACKET_RAM_1_15  volatile.Register16 // 0x45E
	PACKET_RAM_1_16  volatile.Register16 // 0x460
	PACKET_RAM_1_17  volatile.Register16 // 0x462
	PACKET_RAM_1_18  volatile.Register16 // 0x464
	PACKET_RAM_1_19  volatile.Register16 // 0x466
	PACKET_RAM_1_20  volatile.Register16 // 0x468
	PACKET_RAM_1_21  volatile.Register16 // 0x46A
	PACKET_RAM_1_22  volatile.Register16 // 0x46C
	PACKET_RAM_1_23  volatile.Register16 // 0x46E
	PACKET_RAM_1_24  volatile.Register16 // 0x470
	PACKET_RAM_1_25  volatile.Register16 // 0x472
	PACKET_RAM_1_26  volatile.Register16 // 0x474
	PACKET_RAM_1_27  volatile.Register16 // 0x476
	PACKET_RAM_1_28  volatile.Register16 // 0x478
	PACKET_RAM_1_29  volatile.Register16 // 0x47A
	PACKET_RAM_1_30  volatile.Register16 // 0x47C
	PACKET_RAM_1_31  volatile.Register16 // 0x47E
	PACKET_RAM_1_32  volatile.Register16 // 0x480
	PACKET_RAM_1_33  volatile.Register16 // 0x482
	PACKET_RAM_1_34  volatile.Register16 // 0x484
	PACKET_RAM_1_35  volatile.Register16 // 0x486
	PACKET_RAM_1_36  volatile.Register16 // 0x488
	PACKET_RAM_1_37  volatile.Register16 // 0x48A
	PACKET_RAM_1_38  volatile.Register16 // 0x48C
	PACKET_RAM_1_39  volatile.Register16 // 0x48E
	PACKET_RAM_1_40  volatile.Register16 // 0x490
	PACKET_RAM_1_41  volatile.Register16 // 0x492
	PACKET_RAM_1_42  volatile.Register16 // 0x494
	PACKET_RAM_1_43  volatile.Register16 // 0x496
	PACKET_RAM_1_44  volatile.Register16 // 0x498
	PACKET_RAM_1_45  volatile.Register16 // 0x49A
	PACKET_RAM_1_46  volatile.Register16 // 0x49C
	PACKET_RAM_1_47  volatile.Register16 // 0x49E
	PACKET_RAM_1_48  volatile.Register16 // 0x4A0
	PACKET_RAM_1_49  volatile.Register16 // 0x4A2
	PACKET_RAM_1_50  volatile.Register16 // 0x4A4
	PACKET_RAM_1_51  volatile.Register16 // 0x4A6
	PACKET_RAM_1_52  volatile.Register16 // 0x4A8
	PACKET_RAM_1_53  volatile.Register16 // 0x4AA
	PACKET_RAM_1_54  volatile.Register16 // 0x4AC
	PACKET_RAM_1_55  volatile.Register16 // 0x4AE
	PACKET_RAM_1_56  volatile.Register16 // 0x4B0
	PACKET_RAM_1_57  volatile.Register16 // 0x4B2
	PACKET_RAM_1_58  volatile.Register16 // 0x4B4
	PACKET_RAM_1_59  volatile.Register16 // 0x4B6
	PACKET_RAM_1_60  volatile.Register16 // 0x4B8
	PACKET_RAM_1_61  volatile.Register16 // 0x4BA
	PACKET_RAM_1_62  volatile.Register16 // 0x4BC
	PACKET_RAM_1_63  volatile.Register16 // 0x4BE
	PACKET_RAM_1_64  volatile.Register16 // 0x4C0
	PACKET_RAM_1_65  volatile.Register16 // 0x4C2
	PACKET_RAM_1_66  volatile.Register16 // 0x4C4
	PACKET_RAM_1_67  volatile.Register16 // 0x4C6
	PACKET_RAM_1_68  volatile.Register16 // 0x4C8
	PACKET_RAM_1_69  volatile.Register16 // 0x4CA
	PACKET_RAM_1_70  volatile.Register16 // 0x4CC
	PACKET_RAM_1_71  volatile.Register16 // 0x4CE
	PACKET_RAM_1_72  volatile.Register16 // 0x4D0
	PACKET_RAM_1_73  volatile.Register16 // 0x4D2
	PACKET_RAM_1_74  volatile.Register16 // 0x4D4
	PACKET_RAM_1_75  volatile.Register16 // 0x4D6
	PACKET_RAM_1_76  volatile.Register16 // 0x4D8
	PACKET_RAM_1_77  volatile.Register16 // 0x4DA
	PACKET_RAM_1_78  volatile.Register16 // 0x4DC
	PACKET_RAM_1_79  volatile.Register16 // 0x4DE
	PACKET_RAM_1_80  volatile.Register16 // 0x4E0
	PACKET_RAM_1_81  volatile.Register16 // 0x4E2
	PACKET_RAM_1_82  volatile.Register16 // 0x4E4
	PACKET_RAM_1_83  volatile.Register16 // 0x4E6
	PACKET_RAM_1_84  volatile.Register16 // 0x4E8
	PACKET_RAM_1_85  volatile.Register16 // 0x4EA
	PACKET_RAM_1_86  volatile.Register16 // 0x4EC
	PACKET_RAM_1_87  volatile.Register16 // 0x4EE
	PACKET_RAM_1_88  volatile.Register16 // 0x4F0
	PACKET_RAM_1_89  volatile.Register16 // 0x4F2
	PACKET_RAM_1_90  volatile.Register16 // 0x4F4
	PACKET_RAM_1_91  volatile.Register16 // 0x4F6
	PACKET_RAM_1_92  volatile.Register16 // 0x4F8
	PACKET_RAM_1_93  volatile.Register16 // 0x4FA
	PACKET_RAM_1_94  volatile.Register16 // 0x4FC
	PACKET_RAM_1_95  volatile.Register16 // 0x4FE
	PACKET_RAM_1_96  volatile.Register16 // 0x500
	PACKET_RAM_1_97  volatile.Register16 // 0x502
	PACKET_RAM_1_98  volatile.Register16 // 0x504
	PACKET_RAM_1_99  volatile.Register16 // 0x506
	PACKET_RAM_1_100 volatile.Register16 // 0x508
	PACKET_RAM_1_101 volatile.Register16 // 0x50A
	PACKET_RAM_1_102 volatile.Register16 // 0x50C
	PACKET_RAM_1_103 volatile.Register16 // 0x50E
	PACKET_RAM_1_104 volatile.Register16 // 0x510
	PACKET_RAM_1_105 volatile.Register16 // 0x512
	PACKET_RAM_1_106 volatile.Register16 // 0x514
	PACKET_RAM_1_107 volatile.Register16 // 0x516
	PACKET_RAM_1_108 volatile.Register16 // 0x518
	PACKET_RAM_1_109 volatile.Register16 // 0x51A
	PACKET_RAM_1_110 volatile.Register16 // 0x51C
	PACKET_RAM_1_111 volatile.Register16 // 0x51E
	PACKET_RAM_1_112 volatile.Register16 // 0x520
	PACKET_RAM_1_113 volatile.Register16 // 0x522
	PACKET_RAM_1_114 volatile.Register16 // 0x524
	PACKET_RAM_1_115 volatile.Register16 // 0x526
	PACKET_RAM_1_116 volatile.Register16 // 0x528
	PACKET_RAM_1_117 volatile.Register16 // 0x52A
	PACKET_RAM_1_118 volatile.Register16 // 0x52C
	PACKET_RAM_1_119 volatile.Register16 // 0x52E
	PACKET_RAM_1_120 volatile.Register16 // 0x530
	PACKET_RAM_1_121 volatile.Register16 // 0x532
	PACKET_RAM_1_122 volatile.Register16 // 0x534
	PACKET_RAM_1_123 volatile.Register16 // 0x536
	PACKET_RAM_1_124 volatile.Register16 // 0x538
	PACKET_RAM_1_125 volatile.Register16 // 0x53A
	PACKET_RAM_1_126 volatile.Register16 // 0x53C
	PACKET_RAM_1_127 volatile.Register16 // 0x53E
	PACKET_RAM_1_128 volatile.Register16 // 0x540
	PACKET_RAM_1_129 volatile.Register16 // 0x542
	PACKET_RAM_1_130 volatile.Register16 // 0x544
	PACKET_RAM_1_131 volatile.Register16 // 0x546
	PACKET_RAM_1_132 volatile.Register16 // 0x548
	PACKET_RAM_1_133 volatile.Register16 // 0x54A
	PACKET_RAM_1_134 volatile.Register16 // 0x54C
	PACKET_RAM_1_135 volatile.Register16 // 0x54E
	PACKET_RAM_1_136 volatile.Register16 // 0x550
	PACKET_RAM_1_137 volatile.Register16 // 0x552
	PACKET_RAM_1_138 volatile.Register16 // 0x554
	PACKET_RAM_1_139 volatile.Register16 // 0x556
	PACKET_RAM_1_140 volatile.Register16 // 0x558
	PACKET_RAM_1_141 volatile.Register16 // 0x55A
	PACKET_RAM_1_142 volatile.Register16 // 0x55C
	PACKET_RAM_1_143 volatile.Register16 // 0x55E
	PACKET_RAM_1_144 volatile.Register16 // 0x560
	PACKET_RAM_1_145 volatile.Register16 // 0x562
	PACKET_RAM_1_146 volatile.Register16 // 0x564
	PACKET_RAM_1_147 volatile.Register16 // 0x566
	PACKET_RAM_1_148 volatile.Register16 // 0x568
	PACKET_RAM_1_149 volatile.Register16 // 0x56A
	PACKET_RAM_1_150 volatile.Register16 // 0x56C
	PACKET_RAM_1_151 volatile.Register16 // 0x56E
	PACKET_RAM_1_152 volatile.Register16 // 0x570
	PACKET_RAM_1_153 volatile.Register16 // 0x572
	PACKET_RAM_1_154 volatile.Register16 // 0x574
	PACKET_RAM_1_155 volatile.Register16 // 0x576
	PACKET_RAM_1_156 volatile.Register16 // 0x578
	PACKET_RAM_1_157 volatile.Register16 // 0x57A
	PACKET_RAM_1_158 volatile.Register16 // 0x57C
	PACKET_RAM_1_159 volatile.Register16 // 0x57E
	PACKET_RAM_1_160 volatile.Register16 // 0x580
	PACKET_RAM_1_161 volatile.Register16 // 0x582
	PACKET_RAM_1_162 volatile.Register16 // 0x584
	PACKET_RAM_1_163 volatile.Register16 // 0x586
	PACKET_RAM_1_164 volatile.Register16 // 0x588
	PACKET_RAM_1_165 volatile.Register16 // 0x58A
	PACKET_RAM_1_166 volatile.Register16 // 0x58C
	PACKET_RAM_1_167 volatile.Register16 // 0x58E
	PACKET_RAM_1_168 volatile.Register16 // 0x590
	PACKET_RAM_1_169 volatile.Register16 // 0x592
	PACKET_RAM_1_170 volatile.Register16 // 0x594
	PACKET_RAM_1_171 volatile.Register16 // 0x596
	PACKET_RAM_1_172 volatile.Register16 // 0x598
	PACKET_RAM_1_173 volatile.Register16 // 0x59A
	PACKET_RAM_1_174 volatile.Register16 // 0x59C
	PACKET_RAM_1_175 volatile.Register16 // 0x59E
	PACKET_RAM_1_176 volatile.Register16 // 0x5A0
	PACKET_RAM_1_177 volatile.Register16 // 0x5A2
	PACKET_RAM_1_178 volatile.Register16 // 0x5A4
	PACKET_RAM_1_179 volatile.Register16 // 0x5A6
	PACKET_RAM_1_180 volatile.Register16 // 0x5A8
	PACKET_RAM_1_181 volatile.Register16 // 0x5AA
	PACKET_RAM_1_182 volatile.Register16 // 0x5AC
	PACKET_RAM_1_183 volatile.Register16 // 0x5AE
	PACKET_RAM_1_184 volatile.Register16 // 0x5B0
	PACKET_RAM_1_185 volatile.Register16 // 0x5B2
	PACKET_RAM_1_186 volatile.Register16 // 0x5B4
	PACKET_RAM_1_187 volatile.Register16 // 0x5B6
	PACKET_RAM_1_188 volatile.Register16 // 0x5B8
	PACKET_RAM_1_189 volatile.Register16 // 0x5BA
	PACKET_RAM_1_190 volatile.Register16 // 0x5BC
	PACKET_RAM_1_191 volatile.Register16 // 0x5BE
	PACKET_RAM_1_192 volatile.Register16 // 0x5C0
	PACKET_RAM_1_193 volatile.Register16 // 0x5C2
	PACKET_RAM_1_194 volatile.Register16 // 0x5C4
	PACKET_RAM_1_195 volatile.Register16 // 0x5C6
	PACKET_RAM_1_196 volatile.Register16 // 0x5C8
	PACKET_RAM_1_197 volatile.Register16 // 0x5CA
	PACKET_RAM_1_198 volatile.Register16 // 0x5CC
	PACKET_RAM_1_199 volatile.Register16 // 0x5CE
	PACKET_RAM_1_200 volatile.Register16 // 0x5D0
	PACKET_RAM_1_201 volatile.Register16 // 0x5D2
	PACKET_RAM_1_202 volatile.Register16 // 0x5D4
	PACKET_RAM_1_203 volatile.Register16 // 0x5D6
	PACKET_RAM_1_204 volatile.Register16 // 0x5D8
	PACKET_RAM_1_205 volatile.Register16 // 0x5DA
	PACKET_RAM_1_206 volatile.Register16 // 0x5DC
	PACKET_RAM_1_207 volatile.Register16 // 0x5DE
	PACKET_RAM_1_208 volatile.Register16 // 0x5E0
	PACKET_RAM_1_209 volatile.Register16 // 0x5E2
	PACKET_RAM_1_210 volatile.Register16 // 0x5E4
	PACKET_RAM_1_211 volatile.Register16 // 0x5E6
	PACKET_RAM_1_212 volatile.Register16 // 0x5E8
	PACKET_RAM_1_213 volatile.Register16 // 0x5EA
	PACKET_RAM_1_214 volatile.Register16 // 0x5EC
	PACKET_RAM_1_215 volatile.Register16 // 0x5EE
	PACKET_RAM_1_216 volatile.Register16 // 0x5F0
	PACKET_RAM_1_217 volatile.Register16 // 0x5F2
	PACKET_RAM_1_218 volatile.Register16 // 0x5F4
	PACKET_RAM_1_219 volatile.Register16 // 0x5F6
	PACKET_RAM_1_220 volatile.Register16 // 0x5F8
	PACKET_RAM_1_221 volatile.Register16 // 0x5FA
	PACKET_RAM_1_222 volatile.Register16 // 0x5FC
	PACKET_RAM_1_223 volatile.Register16 // 0x5FE
	PACKET_RAM_1_224 volatile.Register16 // 0x600
	PACKET_RAM_1_225 volatile.Register16 // 0x602
	PACKET_RAM_1_226 volatile.Register16 // 0x604
	PACKET_RAM_1_227 volatile.Register16 // 0x606
	PACKET_RAM_1_228 volatile.Register16 // 0x608
	PACKET_RAM_1_229 volatile.Register16 // 0x60A
	PACKET_RAM_1_230 volatile.Register16 // 0x60C
	PACKET_RAM_1_231 volatile.Register16 // 0x60E
	PACKET_RAM_1_232 volatile.Register16 // 0x610
	PACKET_RAM_1_233 volatile.Register16 // 0x612
	PACKET_RAM_1_234 volatile.Register16 // 0x614
	PACKET_RAM_1_235 volatile.Register16 // 0x616
	PACKET_RAM_1_236 volatile.Register16 // 0x618
	PACKET_RAM_1_237 volatile.Register16 // 0x61A
	PACKET_RAM_1_238 volatile.Register16 // 0x61C
	PACKET_RAM_1_239 volatile.Register16 // 0x61E
	PACKET_RAM_1_240 volatile.Register16 // 0x620
	PACKET_RAM_1_241 volatile.Register16 // 0x622
	PACKET_RAM_1_242 volatile.Register16 // 0x624
	PACKET_RAM_1_243 volatile.Register16 // 0x626
	PACKET_RAM_1_244 volatile.Register16 // 0x628
	PACKET_RAM_1_245 volatile.Register16 // 0x62A
	PACKET_RAM_1_246 volatile.Register16 // 0x62C
	PACKET_RAM_1_247 volatile.Register16 // 0x62E
	PACKET_RAM_1_248 volatile.Register16 // 0x630
	PACKET_RAM_1_249 volatile.Register16 // 0x632
	PACKET_RAM_1_250 volatile.Register16 // 0x634
	PACKET_RAM_1_251 volatile.Register16 // 0x636
	PACKET_RAM_1_252 volatile.Register16 // 0x638
	PACKET_RAM_1_253 volatile.Register16 // 0x63A
	PACKET_RAM_1_254 volatile.Register16 // 0x63C
	PACKET_RAM_1_255 volatile.Register16 // 0x63E
	PACKET_RAM_1_256 volatile.Register16 // 0x640
	PACKET_RAM_1_257 volatile.Register16 // 0x642
	PACKET_RAM_1_258 volatile.Register16 // 0x644
	PACKET_RAM_1_259 volatile.Register16 // 0x646
	PACKET_RAM_1_260 volatile.Register16 // 0x648
	PACKET_RAM_1_261 volatile.Register16 // 0x64A
	PACKET_RAM_1_262 volatile.Register16 // 0x64C
	PACKET_RAM_1_263 volatile.Register16 // 0x64E
	PACKET_RAM_1_264 volatile.Register16 // 0x650
	PACKET_RAM_1_265 volatile.Register16 // 0x652
	PACKET_RAM_1_266 volatile.Register16 // 0x654
	PACKET_RAM_1_267 volatile.Register16 // 0x656
	PACKET_RAM_1_268 volatile.Register16 // 0x658
	PACKET_RAM_1_269 volatile.Register16 // 0x65A
	PACKET_RAM_1_270 volatile.Register16 // 0x65C
	PACKET_RAM_1_271 volatile.Register16 // 0x65E
	PACKET_RAM_1_272 volatile.Register16 // 0x660
	PACKET_RAM_1_273 volatile.Register16 // 0x662
	PACKET_RAM_1_274 volatile.Register16 // 0x664
	PACKET_RAM_1_275 volatile.Register16 // 0x666
	PACKET_RAM_1_276 volatile.Register16 // 0x668
	PACKET_RAM_1_277 volatile.Register16 // 0x66A
	PACKET_RAM_1_278 volatile.Register16 // 0x66C
	PACKET_RAM_1_279 volatile.Register16 // 0x66E
	PACKET_RAM_1_280 volatile.Register16 // 0x670
	PACKET_RAM_1_281 volatile.Register16 // 0x672
	PACKET_RAM_1_282 volatile.Register16 // 0x674
	PACKET_RAM_1_283 volatile.Register16 // 0x676
	PACKET_RAM_1_284 volatile.Register16 // 0x678
	PACKET_RAM_1_285 volatile.Register16 // 0x67A
	PACKET_RAM_1_286 volatile.Register16 // 0x67C
	PACKET_RAM_1_287 volatile.Register16 // 0x67E
	PACKET_RAM_1_288 volatile.Register16 // 0x680
	PACKET_RAM_1_289 volatile.Register16 // 0x682
	PACKET_RAM_1_290 volatile.Register16 // 0x684
	PACKET_RAM_1_291 volatile.Register16 // 0x686
	PACKET_RAM_1_292 volatile.Register16 // 0x688
	PACKET_RAM_1_293 volatile.Register16 // 0x68A
	PACKET_RAM_1_294 volatile.Register16 // 0x68C
	PACKET_RAM_1_295 volatile.Register16 // 0x68E
	PACKET_RAM_1_296 volatile.Register16 // 0x690
	PACKET_RAM_1_297 volatile.Register16 // 0x692
	PACKET_RAM_1_298 volatile.Register16 // 0x694
	PACKET_RAM_1_299 volatile.Register16 // 0x696
	PACKET_RAM_1_300 volatile.Register16 // 0x698
	PACKET_RAM_1_301 volatile.Register16 // 0x69A
	PACKET_RAM_1_302 volatile.Register16 // 0x69C
	PACKET_RAM_1_303 volatile.Register16 // 0x69E
	PACKET_RAM_1_304 volatile.Register16 // 0x6A0
	PACKET_RAM_1_305 volatile.Register16 // 0x6A2
	PACKET_RAM_1_306 volatile.Register16 // 0x6A4
	PACKET_RAM_1_307 volatile.Register16 // 0x6A6
	PACKET_RAM_1_308 volatile.Register16 // 0x6A8
	PACKET_RAM_1_309 volatile.Register16 // 0x6AA
	PACKET_RAM_1_310 volatile.Register16 // 0x6AC
	PACKET_RAM_1_311 volatile.Register16 // 0x6AE
	PACKET_RAM_1_312 volatile.Register16 // 0x6B0
	PACKET_RAM_1_313 volatile.Register16 // 0x6B2
	PACKET_RAM_1_314 volatile.Register16 // 0x6B4
	PACKET_RAM_1_315 volatile.Register16 // 0x6B6
	PACKET_RAM_1_316 volatile.Register16 // 0x6B8
	PACKET_RAM_1_317 volatile.Register16 // 0x6BA
	PACKET_RAM_1_318 volatile.Register16 // 0x6BC
	PACKET_RAM_1_319 volatile.Register16 // 0x6BE
	PACKET_RAM_1_320 volatile.Register16 // 0x6C0
	PACKET_RAM_1_321 volatile.Register16 // 0x6C2
	PACKET_RAM_1_322 volatile.Register16 // 0x6C4
	PACKET_RAM_1_323 volatile.Register16 // 0x6C6
	PACKET_RAM_1_324 volatile.Register16 // 0x6C8
	PACKET_RAM_1_325 volatile.Register16 // 0x6CA
	PACKET_RAM_1_326 volatile.Register16 // 0x6CC
	PACKET_RAM_1_327 volatile.Register16 // 0x6CE
	PACKET_RAM_1_328 volatile.Register16 // 0x6D0
	PACKET_RAM_1_329 volatile.Register16 // 0x6D2
	PACKET_RAM_1_330 volatile.Register16 // 0x6D4
	PACKET_RAM_1_331 volatile.Register16 // 0x6D6
	PACKET_RAM_1_332 volatile.Register16 // 0x6D8
	PACKET_RAM_1_333 volatile.Register16 // 0x6DA
	PACKET_RAM_1_334 volatile.Register16 // 0x6DC
	PACKET_RAM_1_335 volatile.Register16 // 0x6DE
	PACKET_RAM_1_336 volatile.Register16 // 0x6E0
	PACKET_RAM_1_337 volatile.Register16 // 0x6E2
	PACKET_RAM_1_338 volatile.Register16 // 0x6E4
	PACKET_RAM_1_339 volatile.Register16 // 0x6E6
	PACKET_RAM_1_340 volatile.Register16 // 0x6E8
	PACKET_RAM_1_341 volatile.Register16 // 0x6EA
	PACKET_RAM_1_342 volatile.Register16 // 0x6EC
	PACKET_RAM_1_343 volatile.Register16 // 0x6EE
	PACKET_RAM_1_344 volatile.Register16 // 0x6F0
	PACKET_RAM_1_345 volatile.Register16 // 0x6F2
	PACKET_RAM_1_346 volatile.Register16 // 0x6F4
	PACKET_RAM_1_347 volatile.Register16 // 0x6F6
	PACKET_RAM_1_348 volatile.Register16 // 0x6F8
	PACKET_RAM_1_349 volatile.Register16 // 0x6FA
	PACKET_RAM_1_350 volatile.Register16 // 0x6FC
	PACKET_RAM_1_351 volatile.Register16 // 0x6FE
	PACKET_RAM_1_352 volatile.Register16 // 0x700
	PACKET_RAM_1_353 volatile.Register16 // 0x702
	PACKET_RAM_1_354 volatile.Register16 // 0x704
	PACKET_RAM_1_355 volatile.Register16 // 0x706
	PACKET_RAM_1_356 volatile.Register16 // 0x708
	PACKET_RAM_1_357 volatile.Register16 // 0x70A
	PACKET_RAM_1_358 volatile.Register16 // 0x70C
	PACKET_RAM_1_359 volatile.Register16 // 0x70E
	PACKET_RAM_1_360 volatile.Register16 // 0x710
	PACKET_RAM_1_361 volatile.Register16 // 0x712
	PACKET_RAM_1_362 volatile.Register16 // 0x714
	PACKET_RAM_1_363 volatile.Register16 // 0x716
	PACKET_RAM_1_364 volatile.Register16 // 0x718
	PACKET_RAM_1_365 volatile.Register16 // 0x71A
	PACKET_RAM_1_366 volatile.Register16 // 0x71C
	PACKET_RAM_1_367 volatile.Register16 // 0x71E
	PACKET_RAM_1_368 volatile.Register16 // 0x720
	PACKET_RAM_1_369 volatile.Register16 // 0x722
	PACKET_RAM_1_370 volatile.Register16 // 0x724
	PACKET_RAM_1_371 volatile.Register16 // 0x726
	PACKET_RAM_1_372 volatile.Register16 // 0x728
	PACKET_RAM_1_373 volatile.Register16 // 0x72A
	PACKET_RAM_1_374 volatile.Register16 // 0x72C
	PACKET_RAM_1_375 volatile.Register16 // 0x72E
	PACKET_RAM_1_376 volatile.Register16 // 0x730
	PACKET_RAM_1_377 volatile.Register16 // 0x732
	PACKET_RAM_1_378 volatile.Register16 // 0x734
	PACKET_RAM_1_379 volatile.Register16 // 0x736
	PACKET_RAM_1_380 volatile.Register16 // 0x738
	PACKET_RAM_1_381 volatile.Register16 // 0x73A
	PACKET_RAM_1_382 volatile.Register16 // 0x73C
	PACKET_RAM_1_383 volatile.Register16 // 0x73E
	PACKET_RAM_1_384 volatile.Register16 // 0x740
	PACKET_RAM_1_385 volatile.Register16 // 0x742
	PACKET_RAM_1_386 volatile.Register16 // 0x744
	PACKET_RAM_1_387 volatile.Register16 // 0x746
	PACKET_RAM_1_388 volatile.Register16 // 0x748
	PACKET_RAM_1_389 volatile.Register16 // 0x74A
	PACKET_RAM_1_390 volatile.Register16 // 0x74C
	PACKET_RAM_1_391 volatile.Register16 // 0x74E
	PACKET_RAM_1_392 volatile.Register16 // 0x750
	PACKET_RAM_1_393 volatile.Register16 // 0x752
	PACKET_RAM_1_394 volatile.Register16 // 0x754
	PACKET_RAM_1_395 volatile.Register16 // 0x756
	PACKET_RAM_1_396 volatile.Register16 // 0x758
	PACKET_RAM_1_397 volatile.Register16 // 0x75A
	PACKET_RAM_1_398 volatile.Register16 // 0x75C
	PACKET_RAM_1_399 volatile.Register16 // 0x75E
	PACKET_RAM_1_400 volatile.Register16 // 0x760
	PACKET_RAM_1_401 volatile.Register16 // 0x762
	PACKET_RAM_1_402 volatile.Register16 // 0x764
	PACKET_RAM_1_403 volatile.Register16 // 0x766
	PACKET_RAM_1_404 volatile.Register16 // 0x768
	PACKET_RAM_1_405 volatile.Register16 // 0x76A
	PACKET_RAM_1_406 volatile.Register16 // 0x76C
	PACKET_RAM_1_407 volatile.Register16 // 0x76E
	PACKET_RAM_1_408 volatile.Register16 // 0x770
	PACKET_RAM_1_409 volatile.Register16 // 0x772
	PACKET_RAM_1_410 volatile.Register16 // 0x774
	PACKET_RAM_1_411 volatile.Register16 // 0x776
	PACKET_RAM_1_412 volatile.Register16 // 0x778
	PACKET_RAM_1_413 volatile.Register16 // 0x77A
	PACKET_RAM_1_414 volatile.Register16 // 0x77C
	PACKET_RAM_1_415 volatile.Register16 // 0x77E
	PACKET_RAM_1_416 volatile.Register16 // 0x780
	PACKET_RAM_1_417 volatile.Register16 // 0x782
	PACKET_RAM_1_418 volatile.Register16 // 0x784
	PACKET_RAM_1_419 volatile.Register16 // 0x786
	PACKET_RAM_1_420 volatile.Register16 // 0x788
	PACKET_RAM_1_421 volatile.Register16 // 0x78A
	PACKET_RAM_1_422 volatile.Register16 // 0x78C
	PACKET_RAM_1_423 volatile.Register16 // 0x78E
	PACKET_RAM_1_424 volatile.Register16 // 0x790
	PACKET_RAM_1_425 volatile.Register16 // 0x792
	PACKET_RAM_1_426 volatile.Register16 // 0x794
	PACKET_RAM_1_427 volatile.Register16 // 0x796
	PACKET_RAM_1_428 volatile.Register16 // 0x798
	PACKET_RAM_1_429 volatile.Register16 // 0x79A
	PACKET_RAM_1_430 volatile.Register16 // 0x79C
	PACKET_RAM_1_431 volatile.Register16 // 0x79E
	PACKET_RAM_1_432 volatile.Register16 // 0x7A0
	PACKET_RAM_1_433 volatile.Register16 // 0x7A2
	PACKET_RAM_1_434 volatile.Register16 // 0x7A4
	PACKET_RAM_1_435 volatile.Register16 // 0x7A6
	PACKET_RAM_1_436 volatile.Register16 // 0x7A8
	PACKET_RAM_1_437 volatile.Register16 // 0x7AA
	PACKET_RAM_1_438 volatile.Register16 // 0x7AC
	PACKET_RAM_1_439 volatile.Register16 // 0x7AE
	PACKET_RAM_1_440 volatile.Register16 // 0x7B0
	PACKET_RAM_1_441 volatile.Register16 // 0x7B2
	PACKET_RAM_1_442 volatile.Register16 // 0x7B4
	PACKET_RAM_1_443 volatile.Register16 // 0x7B6
	PACKET_RAM_1_444 volatile.Register16 // 0x7B8
	PACKET_RAM_1_445 volatile.Register16 // 0x7BA
	PACKET_RAM_1_446 volatile.Register16 // 0x7BC
	PACKET_RAM_1_447 volatile.Register16 // 0x7BE
	PACKET_RAM_1_448 volatile.Register16 // 0x7C0
	PACKET_RAM_1_449 volatile.Register16 // 0x7C2
	PACKET_RAM_1_450 volatile.Register16 // 0x7C4
	PACKET_RAM_1_451 volatile.Register16 // 0x7C6
	PACKET_RAM_1_452 volatile.Register16 // 0x7C8
	PACKET_RAM_1_453 volatile.Register16 // 0x7CA
	PACKET_RAM_1_454 volatile.Register16 // 0x7CC
	PACKET_RAM_1_455 volatile.Register16 // 0x7CE
	PACKET_RAM_1_456 volatile.Register16 // 0x7D0
	PACKET_RAM_1_457 volatile.Register16 // 0x7D2
	PACKET_RAM_1_458 volatile.Register16 // 0x7D4
	PACKET_RAM_1_459 volatile.Register16 // 0x7D6
	PACKET_RAM_1_460 volatile.Register16 // 0x7D8
	PACKET_RAM_1_461 volatile.Register16 // 0x7DA
	PACKET_RAM_1_462 volatile.Register16 // 0x7DC
	PACKET_RAM_1_463 volatile.Register16 // 0x7DE
	PACKET_RAM_1_464 volatile.Register16 // 0x7E0
	PACKET_RAM_1_465 volatile.Register16 // 0x7E2
	PACKET_RAM_1_466 volatile.Register16 // 0x7E4
	PACKET_RAM_1_467 volatile.Register16 // 0x7E6
	PACKET_RAM_1_468 volatile.Register16 // 0x7E8
	PACKET_RAM_1_469 volatile.Register16 // 0x7EA
	PACKET_RAM_1_470 volatile.Register16 // 0x7EC
	PACKET_RAM_1_471 volatile.Register16 // 0x7EE
	PACKET_RAM_1_472 volatile.Register16 // 0x7F0
	PACKET_RAM_1_473 volatile.Register16 // 0x7F2
	PACKET_RAM_1_474 volatile.Register16 // 0x7F4
	PACKET_RAM_1_475 volatile.Register16 // 0x7F6
	PACKET_RAM_1_476 volatile.Register16 // 0x7F8
	PACKET_RAM_1_477 volatile.Register16 // 0x7FA
	PACKET_RAM_1_478 volatile.Register16 // 0x7FC
	PACKET_RAM_1_479 volatile.Register16 // 0x7FE
	PACKET_RAM_1_480 volatile.Register16 // 0x800
	PACKET_RAM_1_481 volatile.Register16 // 0x802
	PACKET_RAM_1_482 volatile.Register16 // 0x804
	PACKET_RAM_1_483 volatile.Register16 // 0x806
	PACKET_RAM_1_484 volatile.Register16 // 0x808
	PACKET_RAM_1_485 volatile.Register16 // 0x80A
	PACKET_RAM_1_486 volatile.Register16 // 0x80C
	PACKET_RAM_1_487 volatile.Register16 // 0x80E
	PACKET_RAM_1_488 volatile.Register16 // 0x810
	PACKET_RAM_1_489 volatile.Register16 // 0x812
	PACKET_RAM_1_490 volatile.Register16 // 0x814
	PACKET_RAM_1_491 volatile.Register16 // 0x816
	PACKET_RAM_1_492 volatile.Register16 // 0x818
	PACKET_RAM_1_493 volatile.Register16 // 0x81A
	PACKET_RAM_1_494 volatile.Register16 // 0x81C
	PACKET_RAM_1_495 volatile.Register16 // 0x81E
	PACKET_RAM_1_496 volatile.Register16 // 0x820
	PACKET_RAM_1_497 volatile.Register16 // 0x822
	PACKET_RAM_1_498 volatile.Register16 // 0x824
	PACKET_RAM_1_499 volatile.Register16 // 0x826
	PACKET_RAM_1_500 volatile.Register16 // 0x828
	PACKET_RAM_1_501 volatile.Register16 // 0x82A
	PACKET_RAM_1_502 volatile.Register16 // 0x82C
	PACKET_RAM_1_503 volatile.Register16 // 0x82E
	PACKET_RAM_1_504 volatile.Register16 // 0x830
	PACKET_RAM_1_505 volatile.Register16 // 0x832
	PACKET_RAM_1_506 volatile.Register16 // 0x834
	PACKET_RAM_1_507 volatile.Register16 // 0x836
	PACKET_RAM_1_508 volatile.Register16 // 0x838
	PACKET_RAM_1_509 volatile.Register16 // 0x83A
	PACKET_RAM_1_510 volatile.Register16 // 0x83C
	PACKET_RAM_1_511 volatile.Register16 // 0x83E
	PACKET_RAM_1_512 volatile.Register16 // 0x840
	PACKET_RAM_1_513 volatile.Register16 // 0x842
	PACKET_RAM_1_514 volatile.Register16 // 0x844
	PACKET_RAM_1_515 volatile.Register16 // 0x846
	PACKET_RAM_1_516 volatile.Register16 // 0x848
	PACKET_RAM_1_517 volatile.Register16 // 0x84A
	PACKET_RAM_1_518 volatile.Register16 // 0x84C
	PACKET_RAM_1_519 volatile.Register16 // 0x84E
	PACKET_RAM_1_520 volatile.Register16 // 0x850
	PACKET_RAM_1_521 volatile.Register16 // 0x852
	PACKET_RAM_1_522 volatile.Register16 // 0x854
	PACKET_RAM_1_523 volatile.Register16 // 0x856
	PACKET_RAM_1_524 volatile.Register16 // 0x858
	PACKET_RAM_1_525 volatile.Register16 // 0x85A
	PACKET_RAM_1_526 volatile.Register16 // 0x85C
	PACKET_RAM_1_527 volatile.Register16 // 0x85E
	PACKET_RAM_1_528 volatile.Register16 // 0x860
	PACKET_RAM_1_529 volatile.Register16 // 0x862
	PACKET_RAM_1_530 volatile.Register16 // 0x864
	PACKET_RAM_1_531 volatile.Register16 // 0x866
	PACKET_RAM_1_532 volatile.Register16 // 0x868
	PACKET_RAM_1_533 volatile.Register16 // 0x86A
	PACKET_RAM_1_534 volatile.Register16 // 0x86C
	PACKET_RAM_1_535 volatile.Register16 // 0x86E
	PACKET_RAM_1_536 volatile.Register16 // 0x870
	PACKET_RAM_1_537 volatile.Register16 // 0x872
	PACKET_RAM_1_538 volatile.Register16 // 0x874
	PACKET_RAM_1_539 volatile.Register16 // 0x876
	PACKET_RAM_1_540 volatile.Register16 // 0x878
	PACKET_RAM_1_541 volatile.Register16 // 0x87A
	PACKET_RAM_1_542 volatile.Register16 // 0x87C
	PACKET_RAM_1_543 volatile.Register16 // 0x87E
}

// XCVR_PKT_RAM.PACKET_RAM_0_0: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_0_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_0.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_0.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_0_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_0.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_0_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_0.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_0.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_0_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_0.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_1: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_1_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_1.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_1.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_1_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_1.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_1_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_1.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_1.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_1_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_1.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_2: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_2_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_2.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_2.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_2_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_2.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_2_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_2.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_2.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_2_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_2.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_3: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_3_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_3.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_3.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_3_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_3.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_3_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_3.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_3.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_3_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_3.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_4: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_4_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_4.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_4.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_4_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_4.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_4_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_4.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_4.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_4_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_4.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_5: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_5_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_5.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_5.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_5_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_5.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_5_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_5.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_5.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_5_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_5.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_6: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_6_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_6.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_6.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_6_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_6.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_6_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_6.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_6.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_6_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_6.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_7: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_7_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_7.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_7.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_7_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_7.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_7_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_7.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_7.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_7_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_7.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_8: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_8_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_8.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_8.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_8_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_8.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_8_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_8.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_8.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_8_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_8.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_9: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_9_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_9.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_9.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_9_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_9.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_9_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_9.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_9.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_9_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_9.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_10: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_10_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_10.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_10.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_10_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_10.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_10_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_10.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_10.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_10_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_10.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_11: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_11_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_11.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_11.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_11_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_11.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_11_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_11.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_11.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_11_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_11.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_12: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_12_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_12.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_12.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_12_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_12.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_12_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_12.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_12.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_12_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_12.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_13: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_13_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_13.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_13.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_13_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_13.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_13_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_13.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_13.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_13_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_13.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_14: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_14_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_14.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_14.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_14_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_14.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_14_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_14.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_14.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_14_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_14.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_15: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_15_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_15.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_15.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_15_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_15.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_15_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_15.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_15.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_15_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_15.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_16: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_16_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_16.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_16.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_16_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_16.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_16_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_16.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_16.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_16_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_16.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_17: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_17_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_17.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_17.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_17_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_17.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_17_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_17.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_17.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_17_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_17.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_18: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_18_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_18.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_18.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_18_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_18.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_18_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_18.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_18.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_18_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_18.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_19: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_19_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_19.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_19.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_19_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_19.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_19_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_19.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_19.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_19_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_19.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_20: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_20_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_20.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_20.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_20_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_20.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_20_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_20.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_20.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_20_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_20.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_21: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_21_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_21.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_21.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_21_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_21.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_21_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_21.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_21.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_21_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_21.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_22: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_22_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_22.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_22.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_22_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_22.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_22_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_22.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_22.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_22_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_22.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_23: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_23_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_23.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_23.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_23_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_23.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_23_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_23.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_23.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_23_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_23.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_24: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_24_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_24.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_24.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_24_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_24.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_24_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_24.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_24.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_24_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_24.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_25: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_25_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_25.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_25.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_25_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_25.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_25_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_25.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_25.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_25_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_25.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_26: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_26_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_26.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_26.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_26_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_26.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_26_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_26.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_26.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_26_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_26.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_27: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_27_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_27.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_27.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_27_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_27.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_27_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_27.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_27.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_27_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_27.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_28: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_28_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_28.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_28.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_28_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_28.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_28_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_28.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_28.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_28_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_28.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_29: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_29_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_29.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_29.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_29_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_29.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_29_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_29.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_29.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_29_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_29.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_30: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_30_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_30.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_30.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_30_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_30.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_30_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_30.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_30.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_30_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_30.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_31: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_31_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_31.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_31.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_31_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_31.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_31_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_31.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_31.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_31_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_31.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_32: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_32_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_32.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_32.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_32_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_32.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_32_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_32.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_32.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_32_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_32.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_33: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_33_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_33.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_33.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_33_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_33.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_33_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_33.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_33.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_33_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_33.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_34: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_34_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_34.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_34.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_34_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_34.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_34_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_34.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_34.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_34_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_34.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_35: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_35_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_35.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_35.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_35_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_35.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_35_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_35.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_35.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_35_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_35.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_36: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_36_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_36.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_36.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_36_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_36.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_36_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_36.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_36.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_36_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_36.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_37: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_37_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_37.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_37.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_37_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_37.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_37_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_37.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_37.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_37_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_37.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_38: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_38_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_38.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_38.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_38_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_38.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_38_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_38.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_38.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_38_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_38.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_39: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_39_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_39.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_39.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_39_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_39.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_39_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_39.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_39.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_39_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_39.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_40: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_40_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_40.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_40.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_40_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_40.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_40_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_40.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_40.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_40_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_40.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_41: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_41_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_41.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_41.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_41_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_41.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_41_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_41.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_41.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_41_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_41.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_42: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_42_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_42.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_42.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_42_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_42.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_42_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_42.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_42.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_42_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_42.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_43: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_43_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_43.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_43.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_43_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_43.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_43_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_43.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_43.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_43_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_43.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_44: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_44_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_44.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_44.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_44_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_44.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_44_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_44.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_44.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_44_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_44.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_45: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_45_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_45.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_45.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_45_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_45.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_45_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_45.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_45.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_45_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_45.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_46: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_46_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_46.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_46.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_46_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_46.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_46_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_46.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_46.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_46_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_46.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_47: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_47_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_47.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_47.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_47_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_47.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_47_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_47.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_47.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_47_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_47.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_48: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_48_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_48.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_48.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_48_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_48.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_48_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_48.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_48.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_48_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_48.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_49: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_49_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_49.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_49.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_49_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_49.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_49_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_49.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_49.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_49_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_49.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_50: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_50_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_50.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_50.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_50_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_50.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_50_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_50.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_50.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_50_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_50.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_51: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_51_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_51.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_51.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_51_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_51.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_51_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_51.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_51.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_51_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_51.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_52: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_52_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_52.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_52.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_52_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_52.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_52_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_52.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_52.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_52_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_52.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_53: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_53_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_53.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_53.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_53_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_53.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_53_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_53.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_53.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_53_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_53.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_54: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_54_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_54.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_54.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_54_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_54.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_54_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_54.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_54.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_54_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_54.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_55: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_55_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_55.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_55.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_55_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_55.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_55_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_55.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_55.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_55_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_55.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_56: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_56_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_56.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_56.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_56_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_56.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_56_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_56.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_56.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_56_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_56.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_57: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_57_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_57.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_57.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_57_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_57.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_57_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_57.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_57.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_57_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_57.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_58: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_58_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_58.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_58.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_58_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_58.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_58_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_58.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_58.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_58_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_58.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_59: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_59_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_59.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_59.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_59_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_59.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_59_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_59.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_59.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_59_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_59.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_60: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_60_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_60.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_60.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_60_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_60.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_60_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_60.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_60.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_60_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_60.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_61: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_61_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_61.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_61.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_61_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_61.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_61_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_61.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_61.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_61_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_61.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_62: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_62_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_62.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_62.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_62_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_62.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_62_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_62.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_62.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_62_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_62.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_63: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_63_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_63.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_63.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_63_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_63.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_63_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_63.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_63.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_63_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_63.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_64: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_64_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_64.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_64.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_64_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_64.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_64_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_64.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_64.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_64_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_64.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_65: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_65_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_65.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_65.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_65_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_65.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_65_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_65.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_65.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_65_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_65.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_66: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_66_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_66.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_66.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_66_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_66.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_66_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_66.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_66.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_66_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_66.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_67: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_67_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_67.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_67.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_67_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_67.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_67_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_67.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_67.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_67_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_67.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_68: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_68_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_68.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_68.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_68_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_68.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_68_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_68.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_68.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_68_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_68.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_69: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_69_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_69.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_69.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_69_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_69.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_69_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_69.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_69.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_69_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_69.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_70: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_70_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_70.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_70.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_70_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_70.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_70_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_70.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_70.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_70_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_70.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_71: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_71_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_71.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_71.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_71_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_71.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_71_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_71.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_71.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_71_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_71.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_72: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_72_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_72.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_72.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_72_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_72.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_72_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_72.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_72.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_72_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_72.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_73: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_73_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_73.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_73.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_73_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_73.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_73_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_73.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_73.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_73_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_73.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_74: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_74_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_74.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_74.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_74_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_74.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_74_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_74.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_74.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_74_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_74.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_75: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_75_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_75.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_75.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_75_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_75.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_75_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_75.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_75.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_75_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_75.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_76: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_76_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_76.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_76.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_76_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_76.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_76_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_76.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_76.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_76_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_76.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_77: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_77_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_77.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_77.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_77_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_77.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_77_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_77.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_77.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_77_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_77.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_78: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_78_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_78.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_78.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_78_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_78.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_78_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_78.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_78.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_78_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_78.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_79: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_79_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_79.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_79.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_79_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_79.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_79_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_79.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_79.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_79_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_79.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_80: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_80_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_80.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_80.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_80_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_80.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_80_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_80.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_80.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_80_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_80.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_81: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_81_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_81.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_81.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_81_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_81.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_81_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_81.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_81.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_81_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_81.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_82: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_82_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_82.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_82.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_82_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_82.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_82_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_82.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_82.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_82_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_82.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_83: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_83_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_83.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_83.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_83_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_83.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_83_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_83.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_83.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_83_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_83.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_84: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_84_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_84.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_84.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_84_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_84.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_84_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_84.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_84.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_84_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_84.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_85: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_85_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_85.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_85.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_85_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_85.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_85_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_85.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_85.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_85_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_85.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_86: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_86_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_86.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_86.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_86_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_86.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_86_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_86.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_86.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_86_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_86.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_87: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_87_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_87.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_87.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_87_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_87.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_87_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_87.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_87.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_87_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_87.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_88: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_88_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_88.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_88.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_88_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_88.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_88_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_88.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_88.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_88_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_88.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_89: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_89_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_89.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_89.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_89_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_89.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_89_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_89.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_89.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_89_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_89.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_90: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_90_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_90.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_90.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_90_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_90.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_90_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_90.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_90.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_90_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_90.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_91: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_91_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_91.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_91.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_91_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_91.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_91_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_91.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_91.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_91_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_91.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_92: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_92_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_92.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_92.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_92_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_92.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_92_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_92.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_92.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_92_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_92.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_93: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_93_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_93.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_93.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_93_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_93.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_93_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_93.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_93.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_93_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_93.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_94: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_94_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_94.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_94.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_94_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_94.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_94_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_94.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_94.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_94_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_94.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_95: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_95_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_95.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_95.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_95_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_95.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_95_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_95.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_95.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_95_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_95.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_96: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_96_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_96.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_96.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_96_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_96.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_96_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_96.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_96.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_96_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_96.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_97: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_97_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_97.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_97.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_97_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_97.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_97_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_97.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_97.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_97_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_97.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_98: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_98_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_98.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_98.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_98_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_98.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_98_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_98.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_98.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_98_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_98.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_99: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_99_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_99.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_99.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_99_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_99.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_99_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_99.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_99.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_99_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_99.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_100: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_100_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_100.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_100.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_100_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_100.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_100_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_100.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_100.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_100_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_100.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_101: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_101_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_101.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_101.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_101_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_101.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_101_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_101.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_101.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_101_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_101.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_102: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_102_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_102.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_102.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_102_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_102.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_102_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_102.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_102.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_102_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_102.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_103: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_103_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_103.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_103.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_103_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_103.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_103_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_103.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_103.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_103_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_103.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_104: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_104_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_104.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_104.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_104_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_104.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_104_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_104.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_104.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_104_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_104.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_105: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_105_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_105.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_105.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_105_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_105.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_105_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_105.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_105.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_105_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_105.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_106: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_106_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_106.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_106.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_106_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_106.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_106_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_106.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_106.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_106_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_106.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_107: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_107_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_107.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_107.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_107_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_107.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_107_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_107.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_107.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_107_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_107.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_108: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_108_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_108.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_108.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_108_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_108.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_108_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_108.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_108.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_108_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_108.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_109: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_109_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_109.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_109.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_109_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_109.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_109_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_109.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_109.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_109_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_109.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_110: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_110_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_110.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_110.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_110_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_110.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_110_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_110.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_110.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_110_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_110.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_111: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_111_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_111.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_111.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_111_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_111.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_111_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_111.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_111.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_111_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_111.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_112: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_112_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_112.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_112.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_112_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_112.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_112_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_112.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_112.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_112_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_112.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_113: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_113_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_113.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_113.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_113_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_113.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_113_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_113.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_113.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_113_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_113.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_114: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_114_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_114.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_114.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_114_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_114.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_114_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_114.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_114.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_114_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_114.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_115: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_115_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_115.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_115.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_115_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_115.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_115_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_115.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_115.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_115_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_115.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_116: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_116_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_116.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_116.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_116_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_116.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_116_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_116.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_116.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_116_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_116.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_117: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_117_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_117.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_117.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_117_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_117.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_117_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_117.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_117.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_117_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_117.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_118: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_118_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_118.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_118.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_118_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_118.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_118_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_118.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_118.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_118_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_118.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_119: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_119_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_119.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_119.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_119_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_119.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_119_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_119.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_119.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_119_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_119.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_120: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_120_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_120.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_120.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_120_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_120.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_120_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_120.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_120.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_120_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_120.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_121: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_121_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_121.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_121.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_121_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_121.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_121_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_121.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_121.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_121_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_121.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_122: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_122_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_122.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_122.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_122_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_122.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_122_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_122.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_122.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_122_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_122.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_123: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_123_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_123.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_123.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_123_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_123.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_123_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_123.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_123.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_123_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_123.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_124: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_124_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_124.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_124.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_124_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_124.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_124_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_124.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_124.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_124_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_124.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_125: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_125_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_125.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_125.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_125_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_125.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_125_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_125.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_125.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_125_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_125.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_126: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_126_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_126.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_126.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_126_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_126.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_126_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_126.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_126.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_126_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_126.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_127: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_127_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_127.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_127.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_127_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_127.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_127_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_127.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_127.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_127_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_127.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_128: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_128_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_128.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_128.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_128_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_128.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_128_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_128.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_128.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_128_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_128.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_129: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_129_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_129.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_129.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_129_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_129.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_129_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_129.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_129.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_129_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_129.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_130: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_130_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_130.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_130.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_130_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_130.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_130_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_130.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_130.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_130_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_130.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_131: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_131_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_131.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_131.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_131_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_131.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_131_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_131.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_131.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_131_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_131.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_132: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_132_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_132.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_132.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_132_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_132.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_132_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_132.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_132.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_132_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_132.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_133: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_133_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_133.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_133.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_133_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_133.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_133_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_133.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_133.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_133_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_133.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_134: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_134_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_134.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_134.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_134_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_134.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_134_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_134.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_134.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_134_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_134.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_135: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_135_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_135.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_135.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_135_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_135.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_135_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_135.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_135.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_135_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_135.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_136: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_136_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_136.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_136.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_136_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_136.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_136_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_136.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_136.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_136_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_136.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_137: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_137_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_137.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_137.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_137_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_137.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_137_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_137.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_137.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_137_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_137.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_138: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_138_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_138.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_138.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_138_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_138.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_138_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_138.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_138.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_138_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_138.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_139: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_139_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_139.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_139.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_139_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_139.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_139_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_139.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_139.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_139_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_139.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_140: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_140_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_140.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_140.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_140_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_140.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_140_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_140.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_140.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_140_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_140.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_141: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_141_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_141.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_141.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_141_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_141.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_141_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_141.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_141.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_141_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_141.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_142: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_142_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_142.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_142.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_142_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_142.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_142_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_142.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_142.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_142_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_142.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_143: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_143_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_143.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_143.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_143_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_143.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_143_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_143.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_143.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_143_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_143.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_144: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_144_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_144.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_144.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_144_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_144.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_144_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_144.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_144.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_144_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_144.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_145: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_145_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_145.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_145.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_145_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_145.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_145_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_145.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_145.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_145_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_145.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_146: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_146_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_146.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_146.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_146_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_146.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_146_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_146.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_146.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_146_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_146.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_147: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_147_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_147.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_147.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_147_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_147.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_147_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_147.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_147.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_147_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_147.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_148: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_148_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_148.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_148.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_148_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_148.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_148_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_148.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_148.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_148_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_148.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_149: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_149_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_149.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_149.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_149_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_149.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_149_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_149.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_149.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_149_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_149.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_150: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_150_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_150.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_150.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_150_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_150.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_150_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_150.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_150.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_150_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_150.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_151: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_151_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_151.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_151.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_151_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_151.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_151_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_151.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_151.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_151_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_151.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_152: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_152_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_152.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_152.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_152_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_152.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_152_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_152.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_152.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_152_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_152.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_153: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_153_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_153.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_153.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_153_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_153.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_153_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_153.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_153.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_153_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_153.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_154: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_154_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_154.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_154.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_154_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_154.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_154_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_154.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_154.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_154_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_154.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_155: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_155_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_155.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_155.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_155_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_155.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_155_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_155.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_155.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_155_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_155.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_156: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_156_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_156.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_156.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_156_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_156.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_156_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_156.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_156.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_156_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_156.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_157: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_157_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_157.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_157.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_157_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_157.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_157_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_157.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_157.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_157_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_157.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_158: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_158_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_158.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_158.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_158_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_158.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_158_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_158.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_158.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_158_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_158.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_159: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_159_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_159.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_159.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_159_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_159.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_159_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_159.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_159.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_159_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_159.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_160: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_160_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_160.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_160.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_160_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_160.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_160_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_160.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_160.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_160_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_160.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_161: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_161_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_161.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_161.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_161_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_161.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_161_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_161.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_161.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_161_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_161.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_162: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_162_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_162.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_162.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_162_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_162.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_162_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_162.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_162.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_162_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_162.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_163: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_163_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_163.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_163.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_163_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_163.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_163_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_163.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_163.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_163_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_163.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_164: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_164_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_164.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_164.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_164_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_164.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_164_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_164.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_164.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_164_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_164.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_165: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_165_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_165.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_165.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_165_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_165.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_165_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_165.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_165.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_165_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_165.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_166: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_166_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_166.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_166.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_166_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_166.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_166_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_166.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_166.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_166_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_166.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_167: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_167_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_167.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_167.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_167_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_167.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_167_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_167.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_167.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_167_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_167.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_168: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_168_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_168.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_168.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_168_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_168.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_168_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_168.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_168.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_168_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_168.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_169: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_169_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_169.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_169.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_169_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_169.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_169_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_169.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_169.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_169_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_169.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_170: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_170_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_170.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_170.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_170_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_170.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_170_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_170.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_170.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_170_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_170.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_171: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_171_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_171.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_171.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_171_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_171.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_171_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_171.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_171.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_171_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_171.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_172: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_172_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_172.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_172.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_172_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_172.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_172_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_172.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_172.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_172_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_172.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_173: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_173_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_173.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_173.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_173_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_173.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_173_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_173.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_173.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_173_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_173.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_174: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_174_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_174.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_174.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_174_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_174.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_174_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_174.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_174.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_174_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_174.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_175: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_175_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_175.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_175.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_175_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_175.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_175_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_175.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_175.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_175_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_175.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_176: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_176_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_176.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_176.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_176_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_176.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_176_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_176.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_176.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_176_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_176.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_177: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_177_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_177.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_177.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_177_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_177.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_177_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_177.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_177.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_177_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_177.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_178: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_178_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_178.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_178.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_178_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_178.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_178_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_178.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_178.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_178_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_178.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_179: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_179_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_179.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_179.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_179_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_179.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_179_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_179.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_179.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_179_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_179.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_180: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_180_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_180.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_180.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_180_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_180.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_180_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_180.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_180.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_180_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_180.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_181: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_181_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_181.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_181.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_181_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_181.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_181_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_181.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_181.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_181_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_181.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_182: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_182_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_182.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_182.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_182_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_182.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_182_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_182.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_182.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_182_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_182.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_183: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_183_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_183.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_183.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_183_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_183.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_183_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_183.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_183.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_183_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_183.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_184: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_184_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_184.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_184.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_184_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_184.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_184_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_184.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_184.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_184_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_184.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_185: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_185_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_185.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_185.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_185_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_185.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_185_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_185.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_185.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_185_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_185.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_186: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_186_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_186.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_186.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_186_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_186.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_186_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_186.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_186.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_186_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_186.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_187: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_187_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_187.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_187.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_187_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_187.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_187_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_187.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_187.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_187_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_187.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_188: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_188_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_188.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_188.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_188_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_188.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_188_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_188.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_188.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_188_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_188.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_189: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_189_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_189.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_189.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_189_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_189.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_189_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_189.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_189.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_189_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_189.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_190: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_190_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_190.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_190.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_190_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_190.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_190_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_190.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_190.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_190_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_190.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_191: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_191_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_191.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_191.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_191_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_191.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_191_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_191.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_191.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_191_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_191.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_192: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_192_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_192.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_192.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_192_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_192.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_192_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_192.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_192.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_192_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_192.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_193: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_193_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_193.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_193.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_193_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_193.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_193_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_193.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_193.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_193_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_193.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_194: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_194_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_194.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_194.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_194_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_194.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_194_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_194.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_194.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_194_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_194.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_195: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_195_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_195.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_195.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_195_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_195.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_195_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_195.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_195.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_195_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_195.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_196: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_196_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_196.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_196.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_196_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_196.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_196_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_196.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_196.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_196_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_196.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_197: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_197_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_197.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_197.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_197_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_197.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_197_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_197.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_197.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_197_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_197.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_198: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_198_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_198.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_198.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_198_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_198.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_198_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_198.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_198.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_198_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_198.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_199: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_199_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_199.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_199.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_199_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_199.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_199_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_199.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_199.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_199_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_199.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_200: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_200_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_200.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_200.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_200_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_200.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_200_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_200.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_200.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_200_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_200.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_201: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_201_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_201.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_201.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_201_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_201.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_201_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_201.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_201.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_201_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_201.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_202: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_202_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_202.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_202.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_202_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_202.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_202_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_202.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_202.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_202_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_202.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_203: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_203_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_203.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_203.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_203_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_203.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_203_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_203.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_203.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_203_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_203.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_204: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_204_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_204.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_204.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_204_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_204.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_204_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_204.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_204.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_204_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_204.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_205: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_205_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_205.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_205.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_205_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_205.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_205_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_205.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_205.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_205_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_205.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_206: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_206_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_206.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_206.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_206_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_206.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_206_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_206.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_206.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_206_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_206.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_207: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_207_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_207.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_207.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_207_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_207.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_207_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_207.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_207.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_207_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_207.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_208: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_208_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_208.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_208.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_208_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_208.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_208_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_208.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_208.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_208_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_208.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_209: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_209_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_209.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_209.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_209_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_209.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_209_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_209.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_209.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_209_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_209.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_210: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_210_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_210.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_210.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_210_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_210.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_210_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_210.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_210.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_210_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_210.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_211: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_211_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_211.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_211.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_211_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_211.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_211_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_211.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_211.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_211_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_211.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_212: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_212_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_212.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_212.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_212_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_212.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_212_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_212.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_212.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_212_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_212.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_213: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_213_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_213.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_213.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_213_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_213.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_213_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_213.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_213.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_213_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_213.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_214: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_214_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_214.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_214.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_214_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_214.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_214_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_214.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_214.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_214_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_214.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_215: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_215_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_215.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_215.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_215_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_215.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_215_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_215.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_215.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_215_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_215.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_216: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_216_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_216.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_216.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_216_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_216.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_216_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_216.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_216.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_216_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_216.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_217: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_217_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_217.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_217.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_217_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_217.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_217_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_217.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_217.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_217_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_217.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_218: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_218_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_218.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_218.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_218_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_218.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_218_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_218.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_218.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_218_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_218.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_219: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_219_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_219.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_219.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_219_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_219.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_219_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_219.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_219.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_219_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_219.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_220: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_220_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_220.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_220.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_220_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_220.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_220_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_220.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_220.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_220_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_220.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_221: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_221_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_221.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_221.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_221_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_221.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_221_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_221.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_221.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_221_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_221.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_222: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_222_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_222.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_222.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_222_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_222.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_222_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_222.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_222.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_222_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_222.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_223: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_223_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_223.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_223.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_223_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_223.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_223_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_223.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_223.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_223_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_223.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_224: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_224_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_224.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_224.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_224_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_224.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_224_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_224.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_224.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_224_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_224.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_225: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_225_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_225.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_225.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_225_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_225.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_225_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_225.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_225.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_225_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_225.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_226: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_226_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_226.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_226.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_226_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_226.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_226_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_226.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_226.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_226_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_226.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_227: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_227_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_227.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_227.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_227_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_227.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_227_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_227.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_227.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_227_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_227.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_228: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_228_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_228.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_228.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_228_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_228.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_228_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_228.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_228.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_228_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_228.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_229: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_229_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_229.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_229.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_229_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_229.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_229_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_229.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_229.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_229_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_229.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_230: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_230_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_230.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_230.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_230_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_230.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_230_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_230.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_230.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_230_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_230.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_231: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_231_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_231.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_231.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_231_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_231.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_231_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_231.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_231.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_231_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_231.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_232: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_232_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_232.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_232.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_232_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_232.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_232_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_232.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_232.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_232_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_232.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_233: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_233_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_233.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_233.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_233_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_233.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_233_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_233.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_233.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_233_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_233.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_234: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_234_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_234.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_234.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_234_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_234.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_234_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_234.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_234.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_234_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_234.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_235: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_235_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_235.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_235.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_235_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_235.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_235_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_235.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_235.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_235_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_235.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_236: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_236_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_236.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_236.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_236_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_236.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_236_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_236.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_236.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_236_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_236.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_237: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_237_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_237.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_237.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_237_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_237.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_237_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_237.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_237.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_237_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_237.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_238: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_238_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_238.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_238.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_238_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_238.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_238_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_238.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_238.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_238_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_238.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_239: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_239_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_239.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_239.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_239_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_239.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_239_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_239.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_239.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_239_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_239.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_240: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_240_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_240.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_240.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_240_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_240.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_240_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_240.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_240.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_240_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_240.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_241: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_241_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_241.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_241.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_241_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_241.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_241_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_241.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_241.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_241_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_241.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_242: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_242_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_242.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_242.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_242_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_242.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_242_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_242.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_242.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_242_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_242.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_243: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_243_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_243.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_243.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_243_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_243.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_243_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_243.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_243.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_243_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_243.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_244: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_244_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_244.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_244.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_244_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_244.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_244_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_244.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_244.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_244_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_244.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_245: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_245_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_245.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_245.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_245_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_245.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_245_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_245.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_245.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_245_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_245.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_246: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_246_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_246.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_246.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_246_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_246.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_246_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_246.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_246.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_246_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_246.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_247: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_247_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_247.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_247.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_247_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_247.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_247_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_247.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_247.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_247_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_247.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_248: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_248_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_248.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_248.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_248_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_248.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_248_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_248.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_248.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_248_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_248.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_249: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_249_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_249.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_249.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_249_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_249.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_249_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_249.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_249.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_249_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_249.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_250: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_250_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_250.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_250.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_250_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_250.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_250_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_250.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_250.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_250_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_250.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_251: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_251_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_251.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_251.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_251_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_251.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_251_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_251.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_251.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_251_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_251.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_252: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_252_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_252.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_252.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_252_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_252.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_252_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_252.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_252.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_252_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_252.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_253: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_253_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_253.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_253.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_253_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_253.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_253_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_253.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_253.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_253_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_253.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_254: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_254_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_254.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_254.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_254_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_254.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_254_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_254.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_254.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_254_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_254.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_255: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_255_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_255.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_255.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_255_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_255.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_255_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_255.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_255.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_255_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_255.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_256: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_256_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_256.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_256.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_256_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_256.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_256_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_256.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_256.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_256_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_256.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_257: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_257_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_257.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_257.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_257_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_257.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_257_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_257.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_257.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_257_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_257.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_258: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_258_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_258.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_258.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_258_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_258.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_258_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_258.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_258.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_258_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_258.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_259: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_259_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_259.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_259.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_259_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_259.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_259_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_259.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_259.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_259_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_259.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_260: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_260_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_260.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_260.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_260_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_260.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_260_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_260.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_260.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_260_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_260.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_261: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_261_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_261.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_261.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_261_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_261.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_261_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_261.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_261.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_261_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_261.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_262: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_262_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_262.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_262.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_262_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_262.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_262_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_262.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_262.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_262_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_262.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_263: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_263_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_263.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_263.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_263_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_263.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_263_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_263.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_263.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_263_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_263.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_264: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_264_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_264.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_264.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_264_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_264.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_264_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_264.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_264.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_264_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_264.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_265: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_265_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_265.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_265.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_265_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_265.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_265_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_265.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_265.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_265_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_265.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_266: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_266_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_266.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_266.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_266_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_266.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_266_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_266.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_266.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_266_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_266.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_267: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_267_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_267.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_267.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_267_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_267.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_267_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_267.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_267.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_267_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_267.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_268: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_268_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_268.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_268.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_268_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_268.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_268_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_268.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_268.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_268_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_268.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_269: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_269_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_269.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_269.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_269_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_269.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_269_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_269.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_269.Reg)&^(0xff00)|value<<8)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_269_MSBYTE() uint16 {
	return (volatile.LoadUint16(&o.PACKET_RAM_0_269.Reg) & 0xff00) >> 8
}

// XCVR_PKT_RAM.PACKET_RAM_0_270: Shared Packet RAM for multiple Link Layer usage.
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_270_LSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_270.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_270.Reg)&^(0xff)|value)
}
func (o *XCVR_PKT_RAM_Type) GetPACKET_RAM_0_270_LSBYTE() uint16 {
	return volatile.LoadUint16(&o.PACKET_RAM_0_270.Reg) & 0xff
}
func (o *XCVR_PKT_RAM_Type) SetPACKET_RAM_0_270_MSBYTE(value uint16) {
	volatile.StoreUint16(&o.PACKET_RAM_0_270.Reg, volatile.LoadUint16(&o.PACKET_RAM_0_270.Reg)&^(0xff00)|value<<8)
}
func (o 