/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.SolrSuggester;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterParams;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.apache.solr.util.SolrResponseUtil;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestComponent
extends SearchComponent
implements SolrCoreAware,
SuggesterParams,
Accountable,
SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_NAME = "suggest";
    private static final String DEFAULT_DICT_NAME = "default";
    private static final String CONFIG_PARAM_LABEL = "suggester";
    private static final String BUILD_ON_COMMIT_LABEL = "buildOnCommit";
    private static final String BUILD_ON_OPTIMIZE_LABEL = "buildOnOptimize";
    private static final String BUILD_ON_STARTUP_LABEL = "buildOnStartup";
    protected NamedList<?> initParams;
    protected Map<String, SolrSuggester> suggesters = new ConcurrentHashMap<String, SolrSuggester>();

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
        if (this.initParams != null) {
            log.info("Initializing SuggestComponent");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                Path storeFile;
                if (!this.initParams.getName(i).equals(CONFIG_PARAM_LABEL)) continue;
                SolrSuggester suggester = new SolrSuggester();
                NamedList suggesterParams = (NamedList)this.initParams.getVal(i);
                String dictionary = suggester.init(suggesterParams, core);
                if (dictionary != null) {
                    boolean isDefault = dictionary.equals(DEFAULT_DICT_NAME);
                    if (isDefault && !hasDefault) {
                        hasDefault = true;
                    } else if (isDefault) {
                        throw new RuntimeException("More than one dictionary is missing name.");
                    }
                    this.suggesters.put(dictionary, suggester);
                } else if (!hasDefault) {
                    this.suggesters.put(DEFAULT_DICT_NAME, suggester);
                    hasDefault = true;
                } else {
                    throw new RuntimeException("More than one dictionary is missing name.");
                }
                Object buildOnStartupObj = suggesterParams.get(BUILD_ON_STARTUP_LABEL);
                boolean buildOnStartup = buildOnStartupObj == null ? (storeFile = suggester.getStoreFile()) == null || !Files.exists(storeFile, new LinkOption[0]) : Boolean.parseBoolean((String)buildOnStartupObj);
                boolean buildOnCommit = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_COMMIT_LABEL));
                boolean buildOnOptimize = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_OPTIMIZE_LABEL));
                if (!buildOnCommit && !buildOnOptimize && !buildOnStartup) continue;
                SuggesterListener listener = new SuggesterListener(core, suggester, buildOnCommit, buildOnOptimize, buildOnStartup, core.isReloaded());
                if (log.isInfoEnabled()) {
                    log.info("Registering searcher listener for suggester: {} = {}", (Object)suggester.getName(), (Object)listener);
                }
                core.registerFirstSearcherListener(listener);
                core.registerNewSearcherListener(listener);
            }
        }
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        log.info("SuggestComponent prepare with : {}", (Object)params);
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        Collection<SolrSuggester> querysuggesters = buildAll || reloadAll ? this.suggesters.values() : this.getSuggesters(params);
        if (params.getBool("suggest.build", false) || buildAll) {
            for (SolrSuggester suggester : querysuggesters) {
                suggester.build(rb.req.getCore(), rb.req.getSearcher());
            }
            rb.rsp.add("command", !buildAll ? "build" : "buildAll");
        } else if (params.getBool("suggest.reload", false) || reloadAll) {
            for (SolrSuggester suggester : querysuggesters) {
                suggester.reload();
            }
            rb.rsp.add("command", !reloadAll ? "reload" : "reloadAll");
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        log.info("SuggestComponent distributedProcess with : {}", (Object)params);
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 4;
            sreq.params = new ModifiableSolrParams(rb.req.getParams());
            sreq.params.remove("shards");
            rb.addRequest(this, sreq);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        List<SolrSuggester> querySuggesters;
        SolrParams params = rb.req.getParams();
        log.info("SuggestComponent process with : {}", (Object)params);
        if (!params.getBool(COMPONENT_NAME, false) || this.suggesters.isEmpty()) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        try {
            querySuggesters = this.getSuggesters(params);
        }
        catch (SolrException ex) {
            if (!buildAll && !reloadAll) {
                throw ex;
            }
            querySuggesters = new ArrayList<SolrSuggester>();
        }
        String query = params.get("suggest.q");
        if (query == null && (query = rb.getQueryString()) == null) {
            query = params.get("q");
        }
        if (query != null) {
            int count = params.getInt("suggest.count", 1);
            boolean highlight = params.getBool("suggest.highlight", false);
            boolean allTermsRequired = params.getBool("suggest.allTermsRequired", true);
            String contextFilter = params.get("suggest.cfq");
            if (contextFilter != null && (contextFilter = contextFilter.trim()).length() == 0) {
                contextFilter = null;
            }
            SuggesterOptions options = new SuggesterOptions(new CharsRef(query), count, contextFilter, allTermsRequired, highlight);
            SimpleOrderedMap namedListResults = new SimpleOrderedMap();
            for (SolrSuggester suggester : querySuggesters) {
                SuggesterResult suggesterResult = suggester.getSuggestions(options);
                this.toNamedList(suggesterResult, (SimpleOrderedMap<SimpleOrderedMap<NamedList<Object>>>)namedListResults);
            }
            rb.rsp.add(COMPONENT_NAME, namedListResults);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        log.info("SuggestComponent finishStage with : {}", (Object)params);
        if (!params.getBool(COMPONENT_NAME, false) || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        int count = params.getInt("suggest.count", 1);
        ArrayList<SuggesterResult> suggesterResults = new ArrayList<SuggesterResult>();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                SimpleOrderedMap namedList = (SimpleOrderedMap)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, COMPONENT_NAME, false);
                if (namedList == null) continue;
                if (log.isInfoEnabled()) {
                    log.info("{} : {}", (Object)srsp.getShard(), (Object)namedList);
                }
                suggesterResults.add(this.toSuggesterResult((SimpleOrderedMap<SimpleOrderedMap<NamedList<Object>>>)namedList));
            }
        }
        SuggesterResult suggesterResult = SuggestComponent.merge(suggesterResults, count);
        SimpleOrderedMap namedListResults = new SimpleOrderedMap();
        this.toNamedList(suggesterResult, (SimpleOrderedMap<SimpleOrderedMap<NamedList<Object>>>)namedListResults);
        rb.rsp.add(COMPONENT_NAME, namedListResults);
    }

    private static SuggesterResult merge(List<SuggesterResult> suggesterResults, int count) {
        SuggesterResult result = new SuggesterResult();
        HashSet<String> allTokens = new HashSet<String>();
        TreeSet<String> suggesterNames = new TreeSet<String>();
        for (SuggesterResult shardResult : suggesterResults) {
            for (String suggesterName : shardResult.getSuggesterNames()) {
                allTokens.addAll(shardResult.getTokens(suggesterName));
                suggesterNames.add(suggesterName);
            }
        }
        for (String suggesterName : suggesterNames) {
            for (String token : allTokens) {
                Lookup.LookupPriorityQueue resultQueue = new Lookup.LookupPriorityQueue(count);
                for (SuggesterResult shardResult : suggesterResults) {
                    List<Lookup.LookupResult> suggests = shardResult.getLookupResult(suggesterName, token);
                    if (suggests == null) continue;
                    for (Lookup.LookupResult res : suggests) {
                        resultQueue.insertWithOverflow((Object)res);
                    }
                }
                ArrayList<Lookup.LookupResult> sortedSuggests = new ArrayList<Lookup.LookupResult>();
                Collections.addAll(sortedSuggests, resultQueue.getResults());
                result.add(suggesterName, token, sortedSuggests);
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Suggester component";
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.solrMetricsContext.gauge(() -> this.ramBytesUsed(), true, "totalSizeInBytes", this.getCategory().toString());
        MetricsMap suggestersMap = new MetricsMap(map -> {
            for (Map.Entry<String, SolrSuggester> entry : this.suggesters.entrySet()) {
                SolrSuggester suggester = entry.getValue();
                map.putNoEx((CharSequence)entry.getKey(), (Object)suggester.toString());
            }
        });
        this.solrMetricsContext.gauge(suggestersMap, true, "suggesters", this.getCategory().toString(), scope);
    }

    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        for (SolrSuggester suggester : this.suggesters.values()) {
            sizeInBytes += suggester.ramBytesUsed();
        }
        return sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.suggesters);
    }

    private List<SolrSuggester> getSuggesters(SolrParams params) {
        ArrayList<SolrSuggester> solrSuggesters = new ArrayList<SolrSuggester>();
        for (String suggesterName : this.getSuggesterNames(params)) {
            SolrSuggester curSuggester = this.suggesters.get(suggesterName);
            if (curSuggester != null) {
                solrSuggesters.add(curSuggester);
                continue;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No suggester named " + suggesterName + " was configured");
        }
        if (solrSuggesters.size() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'suggest.dictionary' parameter not specified and no default suggester configured");
        }
        return solrSuggesters;
    }

    private SortedSet<String> getSuggesterNames(SolrParams params) {
        TreeSet<String> suggesterNames = new TreeSet<String>();
        String[] suggesterNamesFromParams = params.getParams("suggest.dictionary");
        if (suggesterNamesFromParams == null) {
            suggesterNames.add(DEFAULT_DICT_NAME);
        } else {
            for (String name : suggesterNamesFromParams) {
                suggesterNames.add(name);
            }
        }
        return suggesterNames;
    }

    private void toNamedList(SuggesterResult suggesterResult, SimpleOrderedMap<SimpleOrderedMap<NamedList<Object>>> resultObj) {
        TreeSet<String> sortedSuggesterNames = new TreeSet<String>(suggesterResult.getSuggesterNames());
        for (String suggesterName : sortedSuggesterNames) {
            SimpleOrderedMap results = new SimpleOrderedMap();
            for (String token : suggesterResult.getTokens(suggesterName)) {
                SimpleOrderedMap suggestionBody = new SimpleOrderedMap();
                List<Lookup.LookupResult> lookupResults = suggesterResult.getLookupResult(suggesterName, token);
                suggestionBody.add("numFound", (Object)lookupResults.size());
                ArrayList<SimpleOrderedMap> suggestEntriesNamedList = new ArrayList<SimpleOrderedMap>();
                for (Lookup.LookupResult lookupResult : lookupResults) {
                    String suggestionString = lookupResult.key.toString();
                    long weight = lookupResult.value;
                    String payload = lookupResult.payload != null ? lookupResult.payload.utf8ToString() : "";
                    SimpleOrderedMap suggestEntryNamedList = new SimpleOrderedMap();
                    suggestEntryNamedList.add("term", (Object)suggestionString);
                    suggestEntryNamedList.add("weight", (Object)weight);
                    suggestEntryNamedList.add("payload", (Object)payload);
                    suggestEntriesNamedList.add(suggestEntryNamedList);
                }
                suggestionBody.add("suggestions", suggestEntriesNamedList);
                results.add(token, (Object)suggestionBody);
            }
            resultObj.add(suggesterName, (Object)results);
        }
    }

    private SuggesterResult toSuggesterResult(SimpleOrderedMap<SimpleOrderedMap<NamedList<Object>>> suggestionsMap) {
        SuggesterResult result = new SuggesterResult();
        if (suggestionsMap == null) {
            return result;
        }
        for (Map.Entry entry : suggestionsMap) {
            String suggesterName = (String)entry.getKey();
            for (Map.Entry suggestions : (SimpleOrderedMap)entry.getValue()) {
                String tokenString = (String)suggestions.getKey();
                ArrayList<Lookup.LookupResult> lookupResults = new ArrayList<Lookup.LookupResult>();
                NamedList suggestion = (NamedList)suggestions.getValue();
                for (int j = 0; j < suggestion.size(); ++j) {
                    String property = suggestion.getName(j);
                    if (property.equals("suggestions")) {
                        List suggestionEntries = (List)suggestion.getVal(j);
                        for (NamedList suggestionEntry : suggestionEntries) {
                            String term = (String)suggestionEntry.get("term");
                            Long weight = (Long)suggestionEntry.get("weight");
                            String payload = (String)suggestionEntry.get("payload");
                            Lookup.LookupResult res = new Lookup.LookupResult((CharSequence)new CharsRef(term), weight.longValue(), new BytesRef((CharSequence)payload));
                            lookupResults.add(res);
                        }
                    }
                    result.add(suggesterName, tokenString, lookupResults);
                }
            }
        }
        return result;
    }

    private static class SuggesterListener
    implements SolrEventListener {
        private final SolrCore core;
        private final SolrSuggester suggester;
        private final boolean buildOnCommit;
        private final boolean buildOnOptimize;
        private final boolean buildOnStartup;
        private final AtomicLong callCount = new AtomicLong(0L);
        private final boolean isCoreReload;

        public SuggesterListener(SolrCore core, SolrSuggester checker, boolean buildOnCommit, boolean buildOnOptimize, boolean buildOnStartup, boolean isCoreReload) {
            this.core = core;
            this.suggester = checker;
            this.buildOnCommit = buildOnCommit;
            this.buildOnOptimize = buildOnOptimize;
            this.buildOnStartup = buildOnStartup;
            this.isCoreReload = isCoreReload;
        }

        @Override
        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            long thisCallCount = this.callCount.incrementAndGet();
            if (this.isCoreReload && thisCallCount == 1L) {
                log.info("Skipping first newSearcher call for suggester {} in core reload", (Object)this.suggester);
                return;
            }
            if (thisCallCount == 1L || this.isCoreReload && thisCallCount == 2L) {
                if (this.buildOnStartup) {
                    if (log.isInfoEnabled()) {
                        log.info("buildOnStartup: {}", (Object)this.suggester.getName());
                    }
                    this.buildSuggesterIndex(newSearcher);
                }
            } else if (this.buildOnCommit) {
                if (log.isInfoEnabled()) {
                    log.info("buildOnCommit: {}", (Object)this.suggester.getName());
                }
                this.buildSuggesterIndex(newSearcher);
            } else if (this.buildOnOptimize && newSearcher.getIndexReader().leaves().size() == 1) {
                if (log.isInfoEnabled()) {
                    log.info("buildOnOptimize: {}", (Object)this.suggester.getName());
                }
                this.buildSuggesterIndex(newSearcher);
            }
        }

        private void buildSuggesterIndex(SolrIndexSearcher newSearcher) {
            try {
                this.suggester.build(this.core, newSearcher);
            }
            catch (Exception e) {
                log.error("Exception in building suggester index for {}: ", (Object)this.suggester.getName(), (Object)e);
            }
        }

        @Override
        public void postCommit() {
        }

        @Override
        public void postSoftCommit() {
        }

        public String toString() {
            return "SuggesterListener [core=" + this.core + ", suggester=" + this.suggester + ", buildOnCommit=" + this.buildOnCommit + ", buildOnOptimize=" + this.buildOnOptimize + ", buildOnStartup=" + this.buildOnStartup + ", isCoreReload=" + this.isCoreReload + "]";
        }
    }

    private static class SuggesterResultLabels {
        static final String SUGGEST = "suggest";
        static final String SUGGESTIONS = "suggestions";
        static final String SUGGESTION_NUM_FOUND = "numFound";
        static final String SUGGESTION_TERM = "term";
        static final String SUGGESTION_WEIGHT = "weight";
        static final String SUGGESTION_PAYLOAD = "payload";

        private SuggesterResultLabels() {
        }
    }
}

