/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilterFactory;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhrasesIdentificationComponent
extends SearchComponent {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int SHARD_PURPOSE = 4;
    public static final String COMPONENT_NAME = "phrases";
    public static final String PHRASE_INPUT = "phrases.q";
    public static final String PHRASE_FIELDS = "phrases.fields";
    public static final String PHRASE_ANALYSIS_FIELD = "phrases.analysis.field";
    public static final String PHRASE_SUMMARY_PRE = "phrases.pre";
    public static final String PHRASE_SUMMARY_POST = "phrases.post";
    public static final String PHRASE_INDEX_MAXLEN = "phrases.maxlength.index";
    public static final String PHRASE_QUERY_MAXLEN = "phrases.maxlength.query";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if (params.getBool("isShard", false) && 0 == (4 & params.getInt("shards.purpose", 0))) {
            return;
        }
        rb.req.getContext().put(this.getClass(), PhrasesContextData.parseAndValidateRequest(rb.req));
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) {
        PhrasesContextData contextData = (PhrasesContextData)rb.req.getContext().get(this.getClass());
        if (null == contextData) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            for (ShardRequest sreq : rb.outgoing) {
                if (0 == (4 & sreq.purpose)) continue;
                return ResponseBuilder.STAGE_GET_FIELDS;
            }
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 4;
            sreq.params = new ModifiableSolrParams(rb.req.getParams());
            sreq.params.remove("shards");
            rb.addRequest(this, sreq);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            return ResponseBuilder.STAGE_DONE;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        PhrasesContextData contextData = (PhrasesContextData)rb.req.getContext().get(this.getClass());
        if (null == contextData || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        BitSet shardsHandled = new BitSet(rb.shards.length);
        for (ShardRequest sreq : rb.finished) {
            if (0 == (sreq.purpose & 4)) continue;
            for (ShardResponse shardRsp : sreq.responses) {
                List shardPhrases;
                NamedList phrasesWrapper;
                NamedList top;
                int shardNum = rb.getShardNum(shardRsp.getShard());
                if (shardsHandled.get(shardNum)) continue;
                shardsHandled.set(shardNum);
                SolrResponse rsp = shardRsp.getSolrResponse();
                if (null == rsp || null == (top = rsp.getResponse()) || null == (phrasesWrapper = (NamedList)top.get(COMPONENT_NAME)) || null == (shardPhrases = (List)phrasesWrapper.get("_all"))) continue;
                Phrase.populateStats(contextData.allPhrases, shardPhrases);
            }
        }
        this.scoreAndAddResultsToResponse(rb, contextData);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        PhrasesContextData contextData = (PhrasesContextData)rb.req.getContext().get(this.getClass());
        if (null == contextData) {
            return;
        }
        Phrase.populateStats(contextData.allPhrases, contextData.fieldWeights.keySet(), rb.req.getSearcher());
        if (rb.req.getParams().getBool("isShard", false)) {
            SimpleOrderedMap output = new SimpleOrderedMap();
            output.add("_all", Phrase.formatShardResponse(contextData.allPhrases));
            rb.rsp.add(COMPONENT_NAME, output);
        } else {
            this.scoreAndAddResultsToResponse(rb, contextData);
        }
    }

    private void scoreAndAddResultsToResponse(ResponseBuilder rb, PhrasesContextData contextData) {
        assert (null != contextData) : "Should not be called if no phrase data to use";
        if (null == contextData) {
            return;
        }
        SimpleOrderedMap output = new SimpleOrderedMap();
        rb.rsp.add(COMPONENT_NAME, output);
        output.add("input", (Object)contextData.rawInput);
        if (0 == contextData.allPhrases.size()) {
            output.add("summary", (Object)contextData.rawInput);
            output.add("details", Collections.emptyList());
            return;
        }
        Phrase.populateScores(contextData);
        int maxPosition = contextData.allPhrases.get(contextData.allPhrases.size() - 1).getPositionEnd();
        List validScoringPhrasesSorted = contextData.allPhrases.stream().filter(p -> 0.0 < p.getTotalScore()).sorted(Comparator.comparing(p -> p.getTotalScore(), Collections.reverseOrder())).collect(Collectors.toList());
        BitSet positionsCovered = new BitSet(maxPosition + 1);
        ArrayList<Phrase> results = new ArrayList<Phrase>(maxPosition);
        for (Phrase phrase : validScoringPhrasesSorted) {
            BitSet phrasePositions = phrase.getPositionsBitSet();
            if (!phrasePositions.intersects(positionsCovered)) {
                positionsCovered.or(phrasePositions);
                results.add(phrase);
            }
            if (positionsCovered.cardinality() != maxPosition + 1) continue;
            break;
        }
        output.add("summary", (Object)contextData.summarize(results));
        output.add("details", results.stream().map(p -> p.getDetails()).collect(Collectors.toList()));
    }

    @Override
    public String getDescription() {
        return "Phrases Identification Component";
    }

    public static int getMaxShingleSize(Analyzer analyzer) {
        if (!TokenizerChain.class.isInstance(analyzer)) {
            return -1;
        }
        TokenFilterFactory[] factories = ((TokenizerChain)analyzer).getTokenFilterFactories();
        if (0 == factories.length) {
            return -1;
        }
        int result = -1;
        for (TokenFilterFactory tff : factories) {
            if (!ShingleFilterFactory.class.isInstance(tff)) continue;
            if (0 < result) {
                return -1;
            }
            Map args = tff.getOriginalArgs();
            result = args.containsKey("maxShingleSize") ? Integer.parseInt((String)args.get("maxShingleSize")) : 2;
        }
        return result;
    }

    public static final class Phrase {
        private boolean is_indexed;
        private double total_score = -1.0;
        private CharSequence subSequence;
        private BytesRef bytes;
        private int offset_start;
        private int offset_end;
        private int position_start;
        private int position_end;
        private Integer checksum = null;
        private final List<Phrase> individualIndexedTerms = new ArrayList<Phrase>(7);
        private final List<Phrase> largestIndexedSubPhrases = new ArrayList<Phrase>(7);
        private final List<Phrase> indexedSuperPhrases = new ArrayList<Phrase>(7);
        private final Map<String, Long> subTerms_conjunctionCounts = new TreeMap<String, Long>();
        private final Map<String, Long> phrase_ttf = new TreeMap<String, Long>();
        private final Map<String, Long> phrase_df = new TreeMap<String, Long>();
        private final Map<String, Double> fieldScores = new TreeMap<String, Double>();

        public static List<Phrase> extractPhrases(String input, SchemaField analysisField, int maxIndexedPositionLength, int maxQueryPositionLength) {
            assert (maxIndexedPositionLength <= maxQueryPositionLength);
            CharsRefBuilder buffer = new CharsRefBuilder();
            FieldType ft = analysisField.getType();
            Analyzer analyzer = ft.getQueryAnalyzer();
            ArrayList<Phrase> results = new ArrayList<Phrase>(42);
            try (TokenStream tokenStream = analyzer.tokenStream(analysisField.getName(), input);){
                OffsetAttribute offsetAttr = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
                PositionIncrementAttribute posIncAttr = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
                PositionLengthAttribute posLenAttr = (PositionLengthAttribute)tokenStream.addAttribute(PositionLengthAttribute.class);
                TermToBytesRefAttribute termAttr = (TermToBytesRefAttribute)tokenStream.addAttribute(TermToBytesRefAttribute.class);
                int position = 0;
                int lastPosLen = -1;
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    Phrase phrase = new Phrase();
                    int posInc = posIncAttr.getPositionIncrement();
                    int posLen = posLenAttr.getPositionLength();
                    if (0 == posInc && posLen <= lastPosLen) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Phrase identification currently requires that the analyzer used must produce tokens that overlap in increasing order of length. ");
                    }
                    lastPosLen = posLen;
                    phrase.position_start = position += posInc;
                    phrase.position_end = position + posLen;
                    phrase.is_indexed = posLen <= maxIndexedPositionLength;
                    phrase.offset_start = offsetAttr.startOffset();
                    phrase.offset_end = offsetAttr.endOffset();
                    phrase.subSequence = input.subSequence(phrase.offset_start, phrase.offset_end);
                    if (phrase.is_indexed) {
                        phrase.bytes = BytesRef.deepCopyOf((BytesRef)termAttr.getBytesRef());
                    }
                    results.add(phrase);
                }
                tokenStream.end();
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Analysis error extracting phrases from: " + input, (Throwable)e);
            }
            block8: for (int p = 0; p < results.size(); ++p) {
                int i;
                Phrase current = (Phrase)results.get(p);
                if (!current.is_indexed) continue;
                Phrase.addLinkages(current, current, maxIndexedPositionLength);
                for (i = p - 1; 0 <= i; --i) {
                    Phrase previous = (Phrase)results.get(i);
                    if (previous.position_start < current.position_end - maxQueryPositionLength) break;
                    if (current.position_end > previous.position_end) continue;
                    Phrase.addLinkages(previous, current, maxIndexedPositionLength);
                }
                for (i = p + 1; i < results.size(); ++i) {
                    Phrase next = (Phrase)results.get(i);
                    if (current.position_start != next.position_start) continue block8;
                    if (current.position_end > next.position_end) continue;
                    Phrase.addLinkages(next, current, maxIndexedPositionLength);
                }
            }
            return Collections.unmodifiableList(results);
        }

        private static void addLinkages(Phrase outer, Phrase inner, int maxIndexedPositionLength) {
            assert (outer.position_start <= inner.position_start);
            assert (inner.position_end <= outer.position_end);
            assert (inner.is_indexed);
            int inner_len = inner.getPositionLength();
            if (1 == inner_len) {
                outer.individualIndexedTerms.add(inner);
            }
            if (maxIndexedPositionLength == inner_len || inner == outer && inner_len < maxIndexedPositionLength) {
                outer.largestIndexedSubPhrases.add(inner);
            }
            if (outer.is_indexed && inner != outer) {
                inner.indexedSuperPhrases.add(outer);
            }
        }

        public static List<NamedList<Object>> formatShardResponse(List<Phrase> phrases) {
            ArrayList<NamedList<Object>> results = new ArrayList<NamedList<Object>>(phrases.size());
            for (Phrase p : phrases) {
                SimpleOrderedMap data = new SimpleOrderedMap();
                data.add("checksum", (Object)p.getChecksum());
                if (p.is_indexed) {
                    data.add("ttf", (Object)new NamedList(p.phrase_ttf));
                    data.add("df", (Object)new NamedList(p.phrase_df));
                }
                data.add("conj_dc", (Object)new NamedList(p.subTerms_conjunctionCounts));
                results.add((NamedList<Object>)data);
            }
            return results;
        }

        public static void populateStats(List<Phrase> phrases, List<NamedList<Object>> shardData) {
            int numPhrases = phrases.size();
            if (shardData.size() != numPhrases) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "num phrases in shard data not consistent: " + numPhrases + " vs " + shardData.size());
            }
            for (int i = 0; i < phrases.size(); ++i) {
                try {
                    Phrase p = phrases.get(i);
                    NamedList<Object> data = shardData.get(i);
                    if (!p.getChecksum().equals(data.get("checksum"))) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "phrase #" + i + " in shard data had invalid checksum");
                    }
                    if (p.is_indexed) {
                        for (Map.Entry ttf : (NamedList)data.get("ttf")) {
                            p.phrase_ttf.merge((String)ttf.getKey(), (Long)ttf.getValue(), Long::sum);
                        }
                        for (Map.Entry df : (NamedList)data.get("df")) {
                            p.phrase_df.merge((String)df.getKey(), (Long)df.getValue(), Long::sum);
                        }
                    }
                    for (Map.Entry conj_dc : (NamedList)data.get("conj_dc")) {
                        p.subTerms_conjunctionCounts.merge((String)conj_dc.getKey(), (Long)conj_dc.getValue(), Long::sum);
                    }
                    continue;
                }
                catch (RuntimeException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "shard data for phrase#" + i + " not consistent", (Throwable)e);
                }
            }
        }

        public static void populateStats(List<Phrase> phrases, Collection<String> fieldNames, SolrIndexSearcher searcher) throws IOException {
            DirectoryReader reader = searcher.getIndexReader();
            for (String field : fieldNames) {
                for (Phrase phrase : phrases) {
                    if (phrase.is_indexed) {
                        Term t = new Term(field, phrase.bytes);
                        phrase.phrase_ttf.put(field, reader.totalTermFreq(t));
                        phrase.phrase_df.put(field, Long.valueOf(reader.docFreq(t)));
                    }
                    ArrayList<Query> filters = new ArrayList<Query>(phrase.individualIndexedTerms.size());
                    for (Phrase term : phrase.individualIndexedTerms) {
                        filters.add((Query)new TermQuery(new Term(field, term.bytes)));
                    }
                    long count = searcher.getDocSet(filters).size();
                    phrase.subTerms_conjunctionCounts.put(field, count);
                }
            }
        }

        public static void populateScores(PhrasesContextData contextData) {
            Phrase.populateScores(contextData.allPhrases, contextData.fieldWeights, contextData.maxIndexedPositionLength, contextData.maxQueryPositionLength);
        }

        public static void populateScores(List<Phrase> phrases, Map<String, Double> fieldWeights, int maxIndexedPositionLength, int maxQueryPositionLength) {
            double total_weight = fieldWeights.values().stream().mapToDouble(Double::doubleValue).sum();
            for (Phrase phrase : phrases) {
                double phrase_cumulative_score = 0.0;
                for (Map.Entry<String, Double> entry : fieldWeights.entrySet()) {
                    String field = entry.getKey();
                    double weight = entry.getValue();
                    double field_score = Phrase.computeFieldScore(phrase, field, maxIndexedPositionLength, maxQueryPositionLength);
                    phrase.fieldScores.put(field, field_score);
                    phrase_cumulative_score += field_score * weight;
                }
                phrase.total_score = total_weight < 0.0 ? Double.NEGATIVE_INFINITY : phrase_cumulative_score / total_weight;
            }
        }

        private Phrase() {
        }

        public String toString() {
            return "'" + this.subSequence + "'[" + this.offset_start + ":" + this.offset_end + "][" + this.position_start + ":" + this.position_end + "]";
        }

        public NamedList<Object> getDetails() {
            SimpleOrderedMap out = new SimpleOrderedMap();
            out.add("text", (Object)this.subSequence);
            out.add("offset_start", (Object)this.getOffsetStart());
            out.add("offset_end", (Object)this.getOffsetEnd());
            out.add("score", (Object)this.getTotalScore());
            out.add("field_scores", this.fieldScores);
            return out;
        }

        private Integer getChecksum() {
            if (null == this.checksum) {
                this.checksum = Arrays.hashCode(new int[]{this.offset_start, this.offset_end, this.position_start, this.position_end});
            }
            return this.checksum;
        }

        public CharSequence getSubSequence() {
            return this.subSequence;
        }

        public List<Phrase> getIndividualIndexedTerms() {
            return this.individualIndexedTerms;
        }

        public List<Phrase> getLargestIndexedSubPhrases() {
            return this.largestIndexedSubPhrases;
        }

        public List<Phrase> getIndexedSuperPhrases() {
            return this.indexedSuperPhrases;
        }

        public int getPositionStart() {
            return this.position_start;
        }

        public int getPositionEnd() {
            return this.position_end;
        }

        public int getPositionLength() {
            return this.position_end - this.position_start;
        }

        public BitSet getPositionsBitSet() {
            BitSet result = new BitSet();
            result.set(this.position_start, this.position_end);
            return result;
        }

        public int getOffsetStart() {
            return this.offset_start;
        }

        public int getOffsetEnd() {
            return this.offset_end;
        }

        public double getTotalScore() {
            return this.total_score;
        }

        public double getFieldScore(String field) {
            return this.fieldScores.getOrDefault(field, -1.0);
        }

        public long getTTF(String field) {
            if (!this.is_indexed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "TTF is only available for indexed phrases");
            }
            return this.phrase_ttf.getOrDefault(field, 0L);
        }

        public long getConjunctionDocCount(String field) {
            return this.subTerms_conjunctionCounts.getOrDefault(field, 0L);
        }

        public long getDocFreq(String field) {
            if (!this.is_indexed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "DF is only available for indexed phrases");
            }
            return this.phrase_df.getOrDefault(field, 0L);
        }

        private static double computeFieldScore(Phrase input, String field, int maxIndexedPositionLength, int maxQueryPositionLength) {
            long num_indexed_sub_phrases = input.getLargestIndexedSubPhrases().size();
            assert (0L <= num_indexed_sub_phrases);
            if (input.getIndividualIndexedTerms().size() < input.getPositionLength()) {
                return -1.0;
            }
            long phrase_conj_count = input.getConjunctionDocCount(field);
            if (phrase_conj_count <= 0L) {
                return -1.0;
            }
            if (input.getPositionLength() <= 1) {
                return 0.0;
            }
            double field_score = 0.0;
            long max_sub_conj_count = phrase_conj_count;
            for (Phrase words : input.getLargestIndexedSubPhrases()) {
                long phrase_ttf = words.getTTF(field);
                long phrase_df = words.getDocFreq(field);
                long words_conj_count = words.getConjunctionDocCount(field);
                max_sub_conj_count = Math.max(words_conj_count, max_sub_conj_count);
                double max_wrapper_phrase_probability = words.getIndexedSuperPhrases().stream().mapToDouble(p -> p.getConjunctionDocCount(field) <= 0L ? 0.0 : (double)p.getDocFreq(field) / (double)p.getConjunctionDocCount(field)).max().orElse(0.0);
                LongSummaryStatistics words_ttfs = words.getIndividualIndexedTerms().stream().collect(Collectors.summarizingLong(t -> t.getTTF(field)));
                double words_phrase_prob = (double)phrase_ttf / (double)words_ttfs.getMin();
                double words_not_phrase_prob = (double)phrase_ttf / (double)words_ttfs.getMax();
                double phrase_prob = (double)phrase_conj_count / (double)words_conj_count;
                double phrase_score = words_phrase_prob * (phrase_prob - max_wrapper_phrase_probability);
                double not_phrase_score = words_not_phrase_prob * (1.0 - (phrase_prob - max_wrapper_phrase_probability));
                double words_score = phrase_score - not_phrase_score;
                field_score += words_score;
            }
            field_score *= 1.0 / (double)(1 + maxQueryPositionLength - maxIndexedPositionLength);
            return field_score *= (double)phrase_conj_count / (double)max_sub_conj_count;
        }
    }

    public static final class PhrasesContextData {
        public final String rawInput;
        public final int maxIndexedPositionLength;
        public final int maxQueryPositionLength;
        public final Map<String, Double> fieldWeights;
        public final SchemaField analysisField;
        public final List<Phrase> allPhrases;
        public final String summaryPre;
        public final String summaryPost;

        public static PhrasesContextData parseAndValidateRequest(SolrQueryRequest req) throws SolrException {
            return new PhrasesContextData(req);
        }

        private PhrasesContextData(SolrQueryRequest req) throws SolrException {
            SolrParams params = req.getParams();
            this.rawInput = params.get(PhrasesIdentificationComponent.PHRASE_INPUT, params.get("q"));
            if (null == this.rawInput) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "phrase identification requires a query string or phrases.q param override");
            }
            SchemaField tmpAnalysisField = null;
            TreeMap<String, Double> tmpWeights = new TreeMap<String, Double>();
            String analysisFieldName = params.get(PhrasesIdentificationComponent.PHRASE_ANALYSIS_FIELD);
            if (null != analysisFieldName && null == (tmpAnalysisField = req.getSchema().getFieldOrNull(analysisFieldName))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "phrases.analysis.field param specifies a field name that does not exist: " + analysisFieldName);
            }
            Map<String, Float> rawFields = SolrPluginUtils.parseFieldBoosts(params.getParams(PhrasesIdentificationComponent.PHRASE_FIELDS));
            if (rawFields.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "phrases.fields param must specify a (weighted) list of fields to evaluate for phrase identification");
            }
            for (Map.Entry<String, Float> entry : rawFields.entrySet()) {
                double weight;
                SchemaField field = req.getSchema().getFieldOrNull(entry.getKey());
                if (null == field) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "phrases.fields param contains a field name that does not exist: " + entry.getKey());
                }
                if (null == tmpAnalysisField) {
                    tmpAnalysisField = field;
                }
                if (null == analysisFieldName && !field.getType().equals(tmpAnalysisField.getType())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "All fields specified in phrases.fields must have the same fieldType, or the advanced phrases.analysis.field option must specify an override");
                }
                double d = weight = null == entry.getValue() ? 1.0 : (double)entry.getValue().floatValue();
                if (weight < 0.0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "phrases.fields param must use non-negative weight value for field " + field.getName());
                }
                tmpWeights.put(entry.getKey(), weight);
            }
            assert (null != tmpAnalysisField);
            this.analysisField = tmpAnalysisField;
            this.fieldWeights = Collections.unmodifiableMap(tmpWeights);
            FieldType ft = this.analysisField.getType();
            this.maxIndexedPositionLength = req.getParams().getInt(PhrasesIdentificationComponent.PHRASE_INDEX_MAXLEN, PhrasesIdentificationComponent.getMaxShingleSize(ft.getIndexAnalyzer()));
            if (this.maxIndexedPositionLength < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to determine max position length of indexed phrases using index analyzer for analysis field: " + this.analysisField.getName() + " and no override detected using param: phrases.maxlength.index");
            }
            this.maxQueryPositionLength = req.getParams().getInt(PhrasesIdentificationComponent.PHRASE_QUERY_MAXLEN, PhrasesIdentificationComponent.getMaxShingleSize(ft.getQueryAnalyzer()));
            if (this.maxQueryPositionLength < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to determine max position length of query phrases using query analyzer for analysis field: " + this.analysisField.getName() + " and no override detected using param: phrases.maxlength.query");
            }
            if (this.maxQueryPositionLength < this.maxIndexedPositionLength) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Effective value of phrases.maxlength.index (either from index analyzer shingle factory,  or expert param override) must be less then or equal to the effective value of phrases.maxlength.query (either from query analyzer shingle factory, or expert param override)");
            }
            this.summaryPre = params.get(PhrasesIdentificationComponent.PHRASE_SUMMARY_PRE, "{");
            this.summaryPost = params.get(PhrasesIdentificationComponent.PHRASE_SUMMARY_POST, "}");
            this.allPhrases = Phrase.extractPhrases(this.rawInput, this.analysisField, this.maxIndexedPositionLength, this.maxQueryPositionLength);
        }

        public String summarize(List<Phrase> results) {
            StringBuilder out = new StringBuilder(this.rawInput);
            List reversed = results.stream().sorted(Comparator.comparing(p -> p.getPositionStart(), Collections.reverseOrder())).collect(Collectors.toList());
            for (Phrase p2 : reversed) {
                out.insert(p2.getOffsetEnd(), this.summaryPost);
                out.insert(p2.getOffsetStart(), this.summaryPre);
            }
            return out.toString();
        }
    }
}

