/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.Option;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.FileUtils;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.CreateCollectionTool;
import org.apache.solr.cli.CreateTool;
import org.apache.solr.cli.SimplePostTool;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.StatusTool;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.SolrException;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class RunExampleTool
extends ToolBase {
    private static final String PROMPT_FOR_NUMBER = "Please enter %s [%d]: ";
    private static final String PROMPT_FOR_NUMBER_IN_RANGE = "Please enter %s between %d and %d [%d]: ";
    private static final String PROMPT_NUMBER_TOO_SMALL = "%d is too small! Please enter %s between %d and %d [%d]: ";
    private static final String PROMPT_NUMBER_TOO_LARGE = "%d is too large! Please enter %s between %d and %d [%d]: ";
    protected InputStream userInput;
    protected Executor executor;
    protected String script;
    protected File serverDir;
    protected File exampleDir;
    protected String urlScheme;

    public RunExampleTool() {
        this(null, System.in, CLIO.getOutStream());
    }

    public RunExampleTool(Executor executor, InputStream userInput, PrintStream stdout) {
        super(stdout);
        this.executor = executor != null ? executor : new DefaultExecutor();
        this.userInput = userInput;
    }

    @Override
    public String getName() {
        return "run_example";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"noprompt").required(false).desc("Don't prompt for input; accept all defaults when running examples that accept user input.").build(), Option.builder((String)"e").argName("NAME").hasArg().required(true).desc("Name of the example to launch, one of: cloud, techproducts, schemaless, films.").longOpt("example").build(), Option.builder((String)"script").argName("PATH").hasArg().required(false).desc("Path to the bin/solr script.").build(), Option.builder((String)"d").argName("DIR").hasArg().required(true).desc("Path to the Solr server directory.").longOpt("serverDir").build(), Option.builder((String)"force").argName("FORCE").desc("Force option in case Solr is run as root.").build(), Option.builder((String)"exampleDir").argName("DIR").hasArg().required(false).desc("Path to the Solr example directory; if not provided, ${serverDir}/../example is expected to exist.").build(), Option.builder((String)"urlScheme").argName("SCHEME").hasArg().required(false).desc("Solr URL scheme: http or https, defaults to http if not specified.").build(), Option.builder((String)"p").argName("PORT").hasArg().required(false).desc("Specify the port to start the Solr HTTP listener on; default is 8983.").longOpt("port").build(), Option.builder((String)"h").argName("HOSTNAME").hasArg().required(false).desc("Specify the hostname for this Solr instance.").longOpt("host").build(), Option.builder((String)"z").argName("ZKHOST").hasArg().required(false).desc("ZooKeeper connection string; only used when running in SolrCloud mode using -c.").longOpt("zkhost").build(), Option.builder((String)"c").required(false).desc("Start Solr in SolrCloud mode; if -z not supplied, an embedded ZooKeeper instance is started on Solr port+1000, such as 9983 if Solr is bound to 8983.").longOpt("cloud").build(), Option.builder((String)"m").argName("MEM").hasArg().required(false).desc("Sets the min (-Xms) and max (-Xmx) heap size for the JVM, such as: -m 4g results in: -Xms4g -Xmx4g; by default, this script sets the heap size to 512m.").longOpt("memory").build(), Option.builder((String)"a").argName("OPTS").hasArg().required(false).desc("Additional options to be passed to the JVM when starting example Solr server(s).").longOpt("addlopts").build());
    }

    @Override
    public void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
        this.urlScheme = cli.getOptionValue("urlScheme", "http");
        this.serverDir = new File(cli.getOptionValue("serverDir"));
        if (!this.serverDir.isDirectory()) {
            throw new IllegalArgumentException("Value of -serverDir option is invalid! " + this.serverDir.getAbsolutePath() + " is not a directory!");
        }
        this.script = cli.getOptionValue("script");
        if (this.script != null) {
            if (!new File(this.script).isFile()) {
                throw new IllegalArgumentException("Value of -script option is invalid! " + this.script + " not found");
            }
        } else {
            File scriptFile = new File(this.serverDir.getParentFile(), "bin/solr");
            if (scriptFile.isFile()) {
                this.script = scriptFile.getAbsolutePath();
            } else {
                scriptFile = new File(this.serverDir.getParentFile(), "bin/solr.cmd");
                if (scriptFile.isFile()) {
                    this.script = scriptFile.getAbsolutePath();
                } else {
                    throw new IllegalArgumentException("Cannot locate the bin/solr script! Please pass -script to this application.");
                }
            }
        }
        File file = this.exampleDir = cli.hasOption("exampleDir") ? new File(cli.getOptionValue("exampleDir")) : new File(this.serverDir.getParent(), "example");
        if (!this.exampleDir.isDirectory()) {
            throw new IllegalArgumentException("Value of -exampleDir option is invalid! " + this.exampleDir.getAbsolutePath() + " is not a directory!");
        }
        this.echoIfVerbose("Running with\nserverDir=" + this.serverDir.getAbsolutePath() + ",\nexampleDir=" + this.exampleDir.getAbsolutePath() + "\nscript=" + this.script, cli);
        String exampleType = cli.getOptionValue("example");
        if ("cloud".equals(exampleType)) {
            this.runCloudExample(cli);
        } else if ("techproducts".equals(exampleType) || "schemaless".equals(exampleType) || "films".equals(exampleType)) {
            this.runExample(cli, exampleType);
        } else {
            throw new IllegalArgumentException("Unsupported example " + exampleType + "! Please choose one of: cloud, schemaless, techproducts, or films");
        }
    }

    protected void runExample(org.apache.commons.cli.CommandLine cli, String exampleName) throws Exception {
        File exDir = this.setupExampleDir(this.serverDir, this.exampleDir, exampleName);
        String collectionName = "schemaless".equals(exampleName) ? "gettingstarted" : exampleName;
        String configSet = "techproducts".equals(exampleName) ? "sample_techproducts_configs" : "_default";
        boolean isCloudMode = cli.hasOption('c');
        String zkHost = cli.getOptionValue('z');
        int port = Integer.parseInt(cli.getOptionValue('p', System.getenv().getOrDefault("SOLR_PORT", "8983")));
        Map<String, Object> nodeStatus = this.startSolr(new File(exDir, "solr"), isCloudMode, cli, port, zkHost, 30);
        File configsetsDir = new File(this.serverDir, "solr/configsets");
        String solrUrl = (String)nodeStatus.get("baseUrl");
        boolean alreadyExists = false;
        if (nodeStatus.get("cloud") != null) {
            if (SolrCLI.safeCheckCollectionExists(solrUrl, collectionName)) {
                alreadyExists = true;
                this.echo("\nWARNING: Collection '" + collectionName + "' already exists!\nChecked collection existence using Collections API");
            }
        } else {
            String coreName = collectionName;
            if (SolrCLI.safeCheckCoreExists(solrUrl, coreName)) {
                alreadyExists = true;
                this.echo("\nWARNING: Core '" + coreName + "' already exists!\nChecked core existence using Core API command");
            }
        }
        if (!alreadyExists) {
            String[] createArgs = new String[]{"-name", collectionName, "-shards", "1", "-replicationFactor", "1", "-confname", collectionName, "-confdir", configSet, "-configsetsDir", configsetsDir.getAbsolutePath(), "-solrUrl", solrUrl};
            CreateTool createTool = new CreateTool(this.stdout);
            int createCode = createTool.runTool(SolrCLI.processCommandLineArgs(createTool.getName(), createTool.getOptions(), createArgs));
            if (createCode != 0) {
                throw new Exception("Failed to create " + collectionName + " using command: " + Arrays.asList(createArgs));
            }
        }
        if ("techproducts".equals(exampleName) && !alreadyExists) {
            File readOnlyExampleDir;
            File exampledocsDir = new File(this.exampleDir, "exampledocs");
            if (!exampledocsDir.isDirectory() && (readOnlyExampleDir = new File(this.serverDir.getParentFile(), "example")).isDirectory()) {
                exampledocsDir = new File(readOnlyExampleDir, "exampledocs");
            }
            if (exampledocsDir.isDirectory()) {
                String updateUrl = String.format(Locale.ROOT, "%s/%s/update", solrUrl, collectionName);
                this.echo("Indexing tech product example docs from " + exampledocsDir.getAbsolutePath());
                String currentPropVal = System.getProperty("url");
                System.setProperty("url", updateUrl);
                String currentTypeVal = System.getProperty("type");
                System.setProperty("type", "application/xml");
                SimplePostTool.main(new String[]{exampledocsDir.getAbsolutePath() + "/*.xml"});
                if (currentPropVal != null) {
                    System.setProperty("url", currentPropVal);
                } else {
                    System.clearProperty("url");
                }
                if (currentTypeVal != null) {
                    System.setProperty("type", currentTypeVal);
                } else {
                    System.clearProperty("type");
                }
            } else {
                this.echo("exampledocs directory not found, skipping indexing step for the techproducts example");
            }
        } else if ("films".equals(exampleName) && !alreadyExists) {
            try (Http2SolrClient solrClient = new Http2SolrClient.Builder(solrUrl).build();){
                this.echo("Adding dense vector field type to films schema \"_default\"");
                SolrCLI.postJsonToSolr((SolrClient)solrClient, "/" + collectionName + "/schema", "{\n        \"add-field-type\" : {\n          \"name\":\"knn_vector_10\",\n          \"class\":\"solr.DenseVectorField\",\n          \"vectorDimension\":10,\n          \"similarityFunction\":cosine\n          \"knnAlgorithm\":hnsw\n        }\n      }");
                this.echo("Adding name, initial_release_date, and film_vector fields to films schema \"_default\"");
                SolrCLI.postJsonToSolr((SolrClient)solrClient, "/" + collectionName + "/schema", "{\n        \"add-field\" : {\n          \"name\":\"name\",\n          \"type\":\"text_general\",\n          \"multiValued\":false,\n          \"stored\":true\n        },\n        \"add-field\" : {\n          \"name\":\"initial_release_date\",\n          \"type\":\"pdate\",\n          \"stored\":true\n        },\n        \"add-field\" : {\n          \"name\":\"film_vector\",\n          \"type\":\"knn_vector_10\",\n          \"indexed\":true\n          \"stored\":true\n        }\n      }");
                this.echo("Adding paramsets \"algo\" and \"algo_b\" to films configuration for relevancy tuning");
                SolrCLI.postJsonToSolr((SolrClient)solrClient, "/" + collectionName + "/config/params", "{\n        \"set\": {\n        \"algo_a\":{\n               \"defType\":\"dismax\",\n               \"qf\":\"name\"\n             }\n           },\n           \"set\": {\n             \"algo_b\":{\n               \"defType\":\"dismax\",\n               \"qf\":\"name\",\n               \"mm\":\"100%\"\n             }\n            }\n        }\n");
                File filmsJsonFile = new File(this.exampleDir, "films/films.json");
                String updateUrl = String.format(Locale.ROOT, "%s/%s/update/json", solrUrl, collectionName);
                this.echo("Indexing films example docs from " + filmsJsonFile.getAbsolutePath());
                String currentPropVal = System.getProperty("url");
                System.setProperty("url", updateUrl);
                SimplePostTool.main(new String[]{filmsJsonFile.getAbsolutePath()});
                if (currentPropVal != null) {
                    System.setProperty("url", currentPropVal);
                } else {
                    System.clearProperty("url");
                }
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
            }
            this.echo("\nSolr " + exampleName + " example launched successfully. Direct your Web browser to " + solrUrl + " to visit the Solr Admin UI");
        }
    }

    protected void runCloudExample(org.apache.commons.cli.CommandLine cli) throws Exception {
        String solrUrl;
        Scanner readInput;
        File cloudDir;
        boolean prompt = !cli.hasOption("noprompt");
        int numNodes = 2;
        int[] cloudPorts = new int[]{8983, 7574, 8984, 7575};
        int defaultPort = Integer.parseInt(cli.getOptionValue('p', System.getenv().getOrDefault("SOLR_PORT", "8983")));
        if (defaultPort != 8983) {
            cloudPorts = new int[]{defaultPort, defaultPort + 1, defaultPort + 2, defaultPort + 3};
        }
        if (!(cloudDir = new File(this.exampleDir, "cloud")).isDirectory()) {
            cloudDir.mkdir();
        }
        this.echo("\nWelcome to the SolrCloud example!\n");
        Scanner scanner = readInput = prompt ? new Scanner(this.userInput, StandardCharsets.UTF_8.name()) : null;
        if (prompt) {
            this.echo("This interactive session will help you launch a SolrCloud cluster on your local workstation.");
            numNodes = this.promptForInt(readInput, "To begin, how many Solr nodes would you like to run in your local cluster? (specify 1-4 nodes) [2]: ", "a number", numNodes, 1, 4);
            this.echo("Ok, let's start up " + numNodes + " Solr nodes for your example SolrCloud cluster.");
            for (int n = 0; n < numNodes; ++n) {
                String promptMsg = String.format(Locale.ROOT, "Please enter the port for node%d [%d]: ", n + 1, cloudPorts[n]);
                int port = this.promptForPort(readInput, n + 1, promptMsg, cloudPorts[n]);
                while (!this.isPortAvailable(port)) {
                    port = this.promptForPort(readInput, n + 1, "Oops! Looks like port " + port + " is already being used by another process. Please choose a different port.", cloudPorts[n]);
                }
                cloudPorts[n] = port;
                this.echoIfVerbose("Using port " + port + " for node " + (n + 1), cli);
            }
        } else {
            this.echo("Starting up " + numNodes + " Solr nodes for your example SolrCloud cluster.\n");
        }
        File node1Dir = this.setupExampleDir(this.serverDir, cloudDir, "node1");
        for (int n = 2; n <= numNodes; ++n) {
            File nodeNDir = new File(cloudDir, "node" + n);
            if (!nodeNDir.isDirectory()) {
                this.echo("Cloning " + node1Dir.getAbsolutePath() + " into\n   " + nodeNDir.getAbsolutePath());
                FileUtils.copyDirectory((File)node1Dir, (File)nodeNDir);
                continue;
            }
            this.echo(nodeNDir.getAbsolutePath() + " already exists.");
        }
        String zkHost = cli.getOptionValue('z');
        Map<String, Object> nodeStatus = this.startSolr(new File(node1Dir, "solr"), true, cli, cloudPorts[0], zkHost, 30);
        if (zkHost == null) {
            String zookeeper;
            Map cloudStatus = (Map)nodeStatus.get("cloud");
            if (cloudStatus != null && (zookeeper = (String)cloudStatus.get("ZooKeeper")) != null) {
                zkHost = zookeeper;
            }
            if (zkHost == null) {
                throw new Exception("Could not get the ZooKeeper connection string for node1!");
            }
        }
        if (numNodes > 1) {
            for (int n = 1; n < numNodes; ++n) {
                this.startSolr(new File(cloudDir, "node" + (n + 1) + "/solr"), true, cli, cloudPorts[n], zkHost, 30);
            }
        }
        if ((solrUrl = (String)nodeStatus.get("baseUrl")).endsWith("/")) {
            solrUrl = solrUrl.substring(0, solrUrl.length() - 1);
        }
        this.waitToSeeLiveNodes(zkHost, numNodes);
        String collectionName = this.createCloudExampleCollection(numNodes, readInput, prompt, solrUrl);
        this.echo("\n\nSolrCloud example running, please visit: " + solrUrl + " \n");
    }

    protected void waitToSeeLiveNodes(String zkHost, int numNodes) {
        try (CloudHttp2SolrClient cloudClient = new CloudSolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();){
            cloudClient.connect();
            Set liveNodes = cloudClient.getClusterState().getLiveNodes();
            int numLiveNodes = liveNodes != null ? liveNodes.size() : 0;
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
            while (System.nanoTime() < timeout && numLiveNodes < numNodes) {
                this.echo("\nWaiting up to 10 seconds to see " + (numNodes - numLiveNodes) + " more nodes join the SolrCloud cluster ...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                liveNodes = cloudClient.getClusterState().getLiveNodes();
                numLiveNodes = liveNodes != null ? liveNodes.size() : 0;
            }
            if (numLiveNodes < numNodes) {
                this.echo("\nWARNING: Only " + numLiveNodes + " of " + numNodes + " are active in the cluster after 10 seconds! Please check the solr.log for each node to look for errors.\n");
            }
        }
        catch (Exception exc) {
            CLIO.err("Failed to see if " + numNodes + " joined the SolrCloud cluster due to: " + exc);
        }
    }

    protected Map<String, Object> startSolr(File solrHomeDir, boolean cloudMode, org.apache.commons.cli.CommandLine cli, int port, String zkHost, int maxWaitSecs) throws Exception {
        String extraArgs = this.readExtraArgs(cli.getArgs());
        String host = cli.getOptionValue('h');
        String memory = cli.getOptionValue('m');
        String hostArg = host != null && !"localhost".equals(host) ? " -h " + host : "";
        Object zkHostArg = zkHost != null ? " -z " + zkHost : "";
        Object memArg = memory != null ? " -m " + memory : "";
        String cloudModeArg = cloudMode ? "-cloud " : "";
        String forceArg = cli.hasOption("force") ? " -force" : "";
        String verboseArg = this.verbose ? "-V" : "";
        String addlOpts = cli.getOptionValue('a');
        Object addlOptsArg = addlOpts != null ? " -a \"" + addlOpts + "\"" : "";
        File cwd = new File(System.getProperty("user.dir"));
        File binDir = new File(this.script).getParentFile();
        boolean isWindows = OS.isFamilyDOS() || OS.isFamilyWin9x() || OS.isFamilyWindows();
        String callScript = !isWindows && cwd.equals(binDir.getParentFile()) ? "bin/solr" : this.script;
        String cwdPath = cwd.getAbsolutePath();
        String solrHome = solrHomeDir.getAbsolutePath();
        if (!isWindows && cwdPath.length() > 1 && solrHome.startsWith(cwdPath)) {
            solrHome = solrHome.substring(cwdPath.length() + 1);
        }
        String startCmd = String.format(Locale.ROOT, "\"%s\" start %s -p %d -s \"%s\" %s %s %s %s %s %s %s", callScript, cloudModeArg, port, solrHome, hostArg, zkHostArg, memArg, forceArg, verboseArg, extraArgs, addlOptsArg);
        startCmd = startCmd.replaceAll("\\s+", " ").trim();
        this.echo("\nStarting up Solr on port " + port + " using command:");
        this.echo(startCmd + "\n");
        String solrUrl = String.format(Locale.ROOT, "%s://%s:%d/solr", this.urlScheme, host != null ? host : "localhost", port);
        Map<String, Object> nodeStatus = this.checkPortConflict(solrUrl, solrHomeDir, port);
        if (nodeStatus != null) {
            return nodeStatus;
        }
        int code = 0;
        if (isWindows) {
            HashMap<String, String> startEnv = new HashMap<String, String>();
            Map procEnv = EnvironmentUtils.getProcEnvironment();
            if (procEnv != null) {
                for (Map.Entry entry : procEnv.entrySet()) {
                    String envVar = (String)entry.getKey();
                    String envVarVal = (String)entry.getValue();
                    if (envVarVal == null || "EXAMPLE".equals(envVar) || envVar.startsWith("SOLR_")) continue;
                    startEnv.put(envVar, envVarVal);
                }
            }
            DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
            this.executor.execute(CommandLine.parse((String)startCmd), startEnv, (ExecuteResultHandler)handler);
            try {
                handler.waitFor(3000L);
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
            }
            if (handler.hasResult() && handler.getExitValue() != 0) {
                throw new Exception("Failed to start Solr using command: " + startCmd + " Exception : " + handler.getException());
            }
        } else {
            try {
                code = this.executor.execute(CommandLine.parse((String)startCmd));
            }
            catch (ExecuteException e) {
                throw new Exception("Failed to start Solr using command: " + startCmd + " Exception : " + e);
            }
        }
        if (code != 0) {
            throw new Exception("Failed to start Solr using command: " + startCmd);
        }
        return this.getNodeStatus(solrUrl, maxWaitSecs);
    }

    protected Map<String, Object> checkPortConflict(String solrUrl, File solrHomeDir, int port) {
        Object solr_home;
        if (this.isPortAvailable(port)) {
            return null;
        }
        Map<String, Object> nodeStatus = null;
        try {
            nodeStatus = new StatusTool().getStatus(solrUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nodeStatus != null && (solr_home = (String)nodeStatus.get("solr_home")) != null) {
            Object solrHomePath = solrHomeDir.getAbsolutePath();
            if (!((String)solrHomePath).endsWith("/")) {
                solrHomePath = (String)solrHomePath + "/";
            }
            if (!((String)solr_home).endsWith("/")) {
                solr_home = (String)solr_home + "/";
            }
            if (((String)solrHomePath).equals(solr_home)) {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(nodeStatus);
                this.echo("Solr is already setup and running on port " + port + " with status:\n" + arr);
                this.echo("\nIf this is not the example node you are trying to start, please choose a different port.");
                nodeStatus.put("baseUrl", solrUrl);
                return nodeStatus;
            }
        }
        throw new IllegalStateException("Port " + port + " is already being used by another process.");
    }

    protected String readExtraArgs(String[] extraArgsArr) {
        String extraArgs = "";
        if (extraArgsArr != null && extraArgsArr.length > 0) {
            StringBuilder sb = new StringBuilder();
            int app = 0;
            for (int e = 0; e < extraArgsArr.length; ++e) {
                String arg = extraArgsArr[e];
                if ("e".equals(arg) || "example".equals(arg)) {
                    ++e;
                    continue;
                }
                if (app > 0) {
                    sb.append(" ");
                }
                sb.append(arg);
                ++app;
            }
            extraArgs = sb.toString().trim();
        }
        return extraArgs;
    }

    protected String createCloudExampleCollection(int numNodes, Scanner readInput, boolean prompt, String solrUrl) throws Exception {
        int numShards = 2;
        int replicationFactor = 2;
        String cloudConfig = "_default";
        String collectionName = "gettingstarted";
        File configsetsDir = new File(this.serverDir, "solr/configsets");
        if (prompt) {
            this.echo("\nNow let's create a new collection for indexing documents in your " + numNodes + "-node cluster.");
            while (SolrCLI.safeCheckCollectionExists(solrUrl, collectionName = this.prompt(readInput, "Please provide a name for your new collection: [" + collectionName + "] ", collectionName))) {
                this.echo("\nCollection '" + collectionName + "' already exists!");
                int oneOrTwo = this.promptForInt(readInput, "Do you want to re-use the existing collection or create a new one? Enter 1 to reuse, 2 to create new [1]: ", "a 1 or 2", 1, 1, 2);
                if (oneOrTwo != 1) continue;
                return collectionName;
            }
            numShards = this.promptForInt(readInput, "How many shards would you like to split " + collectionName + " into? [2]", "a shard count", 2, 1, 4);
            replicationFactor = this.promptForInt(readInput, "How many replicas per shard would you like to create? [2] ", "a replication factor", 2, 1, 4);
            this.echo("Please choose a configuration for the " + collectionName + " collection, available options are:");
            String validConfigs = "_default or sample_techproducts_configs [" + cloudConfig + "] ";
            cloudConfig = this.prompt(readInput, validConfigs, cloudConfig);
            while (!this.isValidConfig(configsetsDir, cloudConfig)) {
                this.echo(cloudConfig + " is not a valid configuration directory! Please choose a configuration for the " + collectionName + " collection, available options are:");
                cloudConfig = this.prompt(readInput, validConfigs, cloudConfig);
            }
        } else if (SolrCLI.safeCheckCollectionExists(solrUrl, collectionName)) {
            this.echo("\nCollection '" + collectionName + "' already exists! Skipping collection creation step.");
            return collectionName;
        }
        String[] createArgs = new String[]{"-name", collectionName, "-shards", String.valueOf(numShards), "-replicationFactor", String.valueOf(replicationFactor), "-confname", collectionName, "-confdir", cloudConfig, "-configsetsDir", configsetsDir.getAbsolutePath(), "-solrUrl", solrUrl};
        CreateCollectionTool createCollectionTool = new CreateCollectionTool(this.stdout);
        int createCode = createCollectionTool.runTool(SolrCLI.processCommandLineArgs(createCollectionTool.getName(), createCollectionTool.getOptions(), createArgs));
        if (createCode != 0) {
            throw new Exception("Failed to create collection using command: " + Arrays.asList(createArgs));
        }
        return collectionName;
    }

    protected boolean isValidConfig(File configsetsDir, String config) {
        File configDir = new File(configsetsDir, config);
        if (configDir.isDirectory()) {
            return true;
        }
        configDir = new File(config);
        return configDir.isDirectory();
    }

    protected Map<String, Object> getNodeStatus(String solrUrl, int maxWaitSecs) throws Exception {
        String mode;
        StatusTool statusTool = new StatusTool();
        if (this.verbose) {
            this.echo("\nChecking status of Solr at " + solrUrl + " ...");
        }
        URL solrURL = new URL(solrUrl);
        Map<String, Object> nodeStatus = statusTool.waitToSeeSolrUp(solrUrl, maxWaitSecs, TimeUnit.SECONDS);
        nodeStatus.put("baseUrl", solrUrl);
        CharArr arr = new CharArr();
        new JSONWriter(arr, 2).write(nodeStatus);
        String string = mode = nodeStatus.get("cloud") != null ? "cloud" : "standalone";
        if (this.verbose) {
            this.echo("\nSolr is running on " + solrURL.getPort() + " in " + mode + " mode with status:\n" + arr);
        }
        return nodeStatus;
    }

    protected File setupExampleDir(File serverDir, File exampleParentDir, String dirName) throws IOException {
        File solrXml = new File(serverDir, "solr/solr.xml");
        if (!solrXml.isFile()) {
            throw new IllegalArgumentException("Value of -serverDir option is invalid! " + solrXml.getAbsolutePath() + " not found!");
        }
        File zooCfg = new File(serverDir, "solr/zoo.cfg");
        if (!zooCfg.isFile()) {
            throw new IllegalArgumentException("Value of -serverDir option is invalid! " + zooCfg.getAbsolutePath() + " not found!");
        }
        File solrHomeDir = new File(exampleParentDir, dirName + "/solr");
        if (!solrHomeDir.isDirectory()) {
            this.echo("Creating Solr home directory " + solrHomeDir);
            solrHomeDir.mkdirs();
        } else {
            this.echo("Solr home directory " + solrHomeDir.getAbsolutePath() + " already exists.");
        }
        this.copyIfNeeded(solrXml, new File(solrHomeDir, "solr.xml"));
        this.copyIfNeeded(zooCfg, new File(solrHomeDir, "zoo.cfg"));
        return solrHomeDir.getParentFile();
    }

    protected void copyIfNeeded(File src, File dest) throws IOException {
        if (!dest.isFile()) {
            Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
        }
        if (!dest.isFile()) {
            throw new IllegalStateException("Required file " + dest.getAbsolutePath() + " not found!");
        }
    }

    protected boolean isPortAvailable(int port) {
        boolean bl;
        Socket s = new Socket("localhost", port);
        try {
            assert (s != null);
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        s.close();
        return bl;
    }

    protected Integer promptForPort(Scanner s, int node, String prompt, Integer defVal) {
        return this.promptForInt(s, prompt, "a port for node " + node, defVal, null, null);
    }

    protected Integer promptForInt(Scanner s, String prompt, String label, Integer defVal, Integer min, Integer max) {
        Integer inputAsInt = null;
        String value = this.prompt(s, prompt, null);
        if (value != null) {
            int attempts = 3;
            while (value != null && --attempts > 0) {
                try {
                    inputAsInt = Integer.valueOf(value);
                    if (min != null && inputAsInt < min) {
                        value = this.prompt(s, String.format(Locale.ROOT, PROMPT_NUMBER_TOO_SMALL, inputAsInt, label, min, max, defVal));
                        inputAsInt = null;
                        continue;
                    }
                    if (max == null || inputAsInt <= max) continue;
                    value = this.prompt(s, String.format(Locale.ROOT, PROMPT_NUMBER_TOO_LARGE, inputAsInt, label, min, max, defVal));
                    inputAsInt = null;
                }
                catch (NumberFormatException nfe) {
                    if (this.verbose) {
                        this.echo(value + " is not a number!");
                    }
                    if (min != null && max != null) {
                        value = this.prompt(s, String.format(Locale.ROOT, PROMPT_FOR_NUMBER_IN_RANGE, label, min, max, defVal));
                        continue;
                    }
                    value = this.prompt(s, String.format(Locale.ROOT, PROMPT_FOR_NUMBER, label, defVal));
                }
            }
            if (attempts == 0 && inputAsInt == null) {
                this.echo("Too many failed attempts! Going with default value " + defVal);
            }
        }
        return inputAsInt != null ? inputAsInt : defVal;
    }

    protected String prompt(Scanner s, String prompt) {
        return this.prompt(s, prompt, null);
    }

    protected String prompt(Scanner s, String prompt, String defaultValue) {
        this.echo(prompt);
        String nextInput = s.nextLine();
        if (nextInput != null && (nextInput = nextInput.trim()).isEmpty()) {
            nextInput = null;
        }
        return nextInput != null ? nextInput : defaultValue;
    }
}

