/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;

public class CreateCoreTool
extends ToolBase {
    public CreateCoreTool() {
        this(CLIO.getOutStream());
    }

    public CreateCoreTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "create_core";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_SOLRURL, Option.builder((String)"name").argName("NAME").hasArg().required(true).desc("Name of the core to create.").build(), Option.builder((String)"confdir").argName("CONFIG").hasArg().required(false).desc("Configuration directory to copy when creating the new core; default is _default.").build(), Option.builder((String)"configsetsDir").argName("DIR").hasArg().required(true).desc("Path to configsets directory on the local system.").build(), SolrCLI.OPTION_VERBOSE);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        String coreRootDirectory;
        File configsetsDir;
        Object solrUrl = cli.getOptionValue("solrUrl", SolrCLI.getDefaultSolrUrl());
        if (!((String)solrUrl).endsWith("/")) {
            solrUrl = (String)solrUrl + "/";
        }
        if (!(configsetsDir = new File(cli.getOptionValue("configsetsDir"))).isDirectory()) {
            throw new FileNotFoundException(configsetsDir.getAbsolutePath() + " not found!");
        }
        String configSet = cli.getOptionValue("confdir", "_default");
        File configSetDir = new File(configsetsDir, configSet);
        if (!configSetDir.isDirectory()) {
            File possibleConfigDir = new File(configSet);
            if (possibleConfigDir.isDirectory()) {
                configSetDir = possibleConfigDir;
            } else {
                throw new FileNotFoundException("Specified config directory " + configSet + " not found in " + configsetsDir.getAbsolutePath());
            }
        }
        String coreName = cli.getOptionValue("name");
        try (SolrClient solrClient = SolrCLI.getSolrClient((String)solrUrl);){
            Map systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system")).asMap();
            if ("solrcloud".equals(systemInfo.get("mode"))) {
                throw new IllegalStateException("Solr at " + (String)solrUrl + " is running in SolrCloud mode, please use create_collection command instead.");
            }
            coreRootDirectory = (String)systemInfo.get("core_root");
            if (coreRootDirectory == null) {
                coreRootDirectory = (String)systemInfo.get("solr_home");
            }
            if (coreRootDirectory == null) {
                coreRootDirectory = configsetsDir.getParentFile().getAbsolutePath();
            }
        }
        if (SolrCLI.safeCheckCoreExists((String)solrUrl, coreName)) {
            throw new IllegalArgumentException("\nCore '" + coreName + "' already exists!\nChecked core existence using Core API command");
        }
        File coreInstanceDir = new File(coreRootDirectory, coreName);
        File confDir = new File(configSetDir, "conf");
        if (!coreInstanceDir.isDirectory()) {
            coreInstanceDir.mkdirs();
            if (!coreInstanceDir.isDirectory()) {
                throw new IOException("Failed to create new core instance directory: " + coreInstanceDir.getAbsolutePath());
            }
            if (confDir.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)confDir, (File)coreInstanceDir);
            } else if (new File(configSetDir, "solrconfig.xml").isFile()) {
                FileUtils.copyDirectory((File)configSetDir, (File)new File(coreInstanceDir, "conf"));
            } else {
                throw new IllegalArgumentException("\n" + configSetDir.getAbsolutePath() + " doesn't contain a conf subdirectory or solrconfig.xml\n");
            }
            this.echoIfVerbose("\nCopying configuration to new core instance directory:\n" + coreInstanceDir.getAbsolutePath(), cli);
        }
        this.echoIfVerbose("\nCreating new core '" + coreName + "' using CoreAdminRequest", cli);
        try (SolrClient solrClient = SolrCLI.getSolrClient((String)solrUrl);){
            CoreAdminResponse res = CoreAdminRequest.createCore((String)coreName, (String)coreName, (SolrClient)solrClient);
            if (cli.hasOption(SolrCLI.OPTION_VERBOSE.getOpt())) {
                this.echo(res.jsonStr());
                this.echo("\n");
            } else {
                this.echo(String.format(Locale.ROOT, "\nCreated new core '%s'", coreName));
            }
        }
        catch (Exception e) {
            PathUtils.deleteDirectory((Path)coreInstanceDir.toPath());
            throw e;
        }
    }
}

