/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.visualizer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.visualizer.InputExcludedRelWriter;
import org.apache.calcite.plan.visualizer.NodeUpdateHelper;
import org.apache.calcite.plan.visualizer.StepInfo;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Util;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RuleMatchVisualizer
implements RelOptListener {
    private static final String INITIAL = "INITIAL";
    private static final String FINAL = "FINAL";
    public static final String DEFAULT_SET = "default";
    private final String templateDirectory = "org/apache/calcite/plan/visualizer";
    private final @Nullable String outputDirectory;
    private final @Nullable String outputSuffix;
    private String latestRuleID = "";
    private int latestRuleTransformCount = 1;
    private boolean initialized = false;
    private @Nullable RelOptPlanner planner = null;
    private boolean includeTransitiveEdges = false;
    private boolean includeIntermediateCosts = false;
    private final List<StepInfo> steps = new ArrayList<StepInfo>();
    private final Map<String, NodeUpdateHelper> allNodes = new LinkedHashMap<String, NodeUpdateHelper>();

    public RuleMatchVisualizer(String outputDirectory, String outputSuffix) {
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "outputDirectory");
        this.outputSuffix = Objects.requireNonNull(outputSuffix, "outputSuffix");
    }

    public RuleMatchVisualizer() {
        this.outputDirectory = null;
        this.outputSuffix = null;
    }

    public void attachTo(RelOptPlanner planner) {
        assert (this.planner == null);
        planner.addListener(this);
        this.planner = planner;
    }

    public void setIncludeTransitiveEdges(boolean includeTransitiveEdges) {
        this.includeTransitiveEdges = includeTransitiveEdges;
    }

    public void setIncludeIntermediateCosts(boolean includeIntermediateCosts) {
        this.includeIntermediateCosts = includeIntermediateCosts;
    }

    @Override
    public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
        if (!this.initialized) {
            assert (this.planner != null);
            RelNode root = this.planner.getRoot();
            assert (root != null);
            this.initialized = true;
            this.updateInitialPlan(root);
        }
    }

    private void updateInitialPlan(RelNode node) {
        if (node instanceof HepRelVertex) {
            this.updateInitialPlan(node.stripped());
            return;
        }
        this.registerRelNode(node);
        for (RelNode input : RuleMatchVisualizer.getInputs(node)) {
            this.updateInitialPlan(input);
        }
    }

    private static List<RelNode> getInputs(RelNode node) {
        return Util.transform(node.getInputs(), n -> n instanceof HepRelVertex ? n.stripped() : n);
    }

    @Override
    public void relChosen(RelOptListener.RelChosenEvent event) {
        if (event.getRel() == null) {
            assert (this.planner != null);
            RelNode root = this.planner.getRoot();
            assert (root != null);
            this.updateFinalPlan(root);
            this.addStep(FINAL, null);
            this.writeToFile();
        }
    }

    private void updateFinalPlan(RelNode node) {
        int size = this.steps.size();
        if (size > 0 && FINAL.equals(this.steps.get(size - 1).getId())) {
            return;
        }
        this.registerRelNode(node).updateAttribute("inFinalPlan", Boolean.TRUE);
        if (node instanceof RelSubset) {
            RelNode best = ((RelSubset)node).getBest();
            if (best == null) {
                return;
            }
            this.updateFinalPlan(best);
        } else {
            for (RelNode input : RuleMatchVisualizer.getInputs(node)) {
                this.updateFinalPlan(input);
            }
        }
    }

    @Override
    public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
        if (event.isBefore()) {
            if (this.latestRuleID.isEmpty()) {
                this.addStep(INITIAL, null);
                this.latestRuleID = INITIAL;
            }
            return;
        }
        RelOptRuleCall ruleCall = event.getRuleCall();
        String ruleID = Integer.toString(ruleCall.id);
        String displayRuleName = ruleCall.id + "-" + ruleCall.getRule();
        if (ruleID.equals(this.latestRuleID)) {
            ++this.latestRuleTransformCount;
            displayRuleName = displayRuleName + "-" + this.latestRuleTransformCount;
        } else {
            this.latestRuleTransformCount = 1;
        }
        this.latestRuleID = ruleID;
        this.addStep(displayRuleName, ruleCall);
    }

    @Override
    public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
    }

    @Override
    public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
        RelNode rel = event.getRel();
        assert (rel != null);
        Object eqClass = event.getEquivalenceClass();
        if (eqClass instanceof String) {
            String eqClassStr = (String)eqClass;
            eqClassStr = eqClassStr.replace("equivalence class ", "");
            String setId = "set-" + eqClassStr;
            this.registerSet(setId);
            this.registerRelNode(rel).updateAttribute("set", setId);
        }
        this.registerRelNode(rel);
    }

    private void registerSet(String setID) {
        this.allNodes.computeIfAbsent(setID, k -> {
            NodeUpdateHelper h = new NodeUpdateHelper(setID, null);
            h.updateAttribute("label", DEFAULT_SET.equals(setID) ? "" : setID);
            h.updateAttribute("kind", "set");
            return h;
        });
    }

    private NodeUpdateHelper registerRelNode(RelNode rel) {
        return this.allNodes.computeIfAbsent(RuleMatchVisualizer.key(rel), k -> {
            NodeUpdateHelper h = new NodeUpdateHelper(RuleMatchVisualizer.key(rel), rel);
            h.updateAttribute("label", RuleMatchVisualizer.getNodeLabel(rel));
            h.updateAttribute("explanation", RuleMatchVisualizer.getNodeExplanation(rel));
            h.updateAttribute("set", DEFAULT_SET);
            if (rel instanceof RelSubset) {
                h.updateAttribute("kind", "subset");
            }
            return h;
        });
    }

    private void updateNodeInfo(RelNode rel, boolean isLastStep) {
        NodeUpdateHelper helper = this.registerRelNode(rel);
        if (this.includeIntermediateCosts || isLastStep) {
            RelOptPlanner planner = this.planner;
            assert (planner != null);
            RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
            RelOptCost cost = planner.getCost(rel, mq);
            Double rowCount = mq.getRowCount(rel);
            helper.updateAttribute("cost", RuleMatchVisualizer.formatCost(rowCount, cost));
        }
        ArrayList inputs = new ArrayList();
        if (rel instanceof RelSubset) {
            RelSubset relSubset = (RelSubset)rel;
            relSubset.getRels().forEach(input -> inputs.add(RuleMatchVisualizer.key(input)));
            HashSet transitive = new HashSet();
            relSubset.getSubsetsSatisfyingThis().filter(other -> !other.equals(relSubset)).forEach(input -> {
                inputs.add(RuleMatchVisualizer.key(input));
                if (!this.includeTransitiveEdges) {
                    input.getRels().forEach(r -> transitive.add(RuleMatchVisualizer.key(r)));
                }
            });
            inputs.removeAll(transitive);
        } else {
            RuleMatchVisualizer.getInputs(rel).forEach(input -> inputs.add(RuleMatchVisualizer.key(input)));
        }
        helper.updateAttribute("inputs", inputs);
    }

    private void addStep(String stepID, @Nullable RelOptRuleCall ruleCall) {
        LinkedHashMap<String, Object> nextNodeUpdates = new LinkedHashMap<String, Object>();
        boolean usesDefaultSet = this.allNodes.values().stream().anyMatch(h -> DEFAULT_SET.equals(h.getValue("set")));
        if (usesDefaultSet) {
            this.registerSet(DEFAULT_SET);
        }
        for (NodeUpdateHelper h2 : this.allNodes.values()) {
            Object update;
            RelNode rel = h2.getRel();
            if (rel != null) {
                this.updateNodeInfo(rel, FINAL.equals(stepID));
            }
            if (h2.isEmptyUpdate() || (update = h2.getAndResetUpdate()) == null) continue;
            nextNodeUpdates.put(h2.getKey(), update);
        }
        List matchedRels = (List)Arrays.stream(ruleCall == null ? new RelNode[]{} : ruleCall.rels).map(RuleMatchVisualizer::key).collect(Util.toImmutableList());
        this.steps.add(new StepInfo(stepID, nextNodeUpdates, matchedRels));
    }

    public String getJsonStringResult() {
        try {
            LinkedHashMap<String, List<StepInfo>> data = new LinkedHashMap<String, List<StepInfo>>();
            data.put("steps", this.steps);
            ObjectMapper objectMapper = new ObjectMapper();
            DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
            printer = printer.withoutSpacesInObjectEntries();
            return objectMapper.writer((PrettyPrinter)printer).writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeToFile() {
        if (this.outputDirectory == null || this.outputSuffix == null) {
            return;
        }
        try {
            String templatePath = Paths.get("org/apache/calcite/plan/visualizer", new String[0]).resolve("viz-template.html").toString();
            ClassLoader cl = this.getClass().getClassLoader();
            assert (cl != null);
            InputStream resourceAsStream = cl.getResourceAsStream(templatePath);
            assert (resourceAsStream != null);
            String htmlTemplate = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
            String htmlFileName = "planner-viz" + this.outputSuffix + ".html";
            String dataFileName = "planner-viz-data" + this.outputSuffix + ".js";
            String replaceString = "src=\"planner-viz-data.js\"";
            int replaceIndex = htmlTemplate.indexOf(replaceString);
            String htmlContent = htmlTemplate.substring(0, replaceIndex) + "src=\"" + dataFileName + "\"" + htmlTemplate.substring(replaceIndex + replaceString.length());
            String dataJsContent = "var data = " + this.getJsonStringResult() + ";\n";
            Path outputDirPath = Paths.get(this.outputDirectory, new String[0]);
            Path htmlOutput = outputDirPath.resolve(htmlFileName);
            Path dataOutput = outputDirPath.resolve(dataFileName);
            if (!Files.exists(outputDirPath, new LinkOption[0])) {
                Files.createDirectories(outputDirPath, new FileAttribute[0]);
            }
            Files.write(htmlOutput, htmlContent.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.write(dataOutput, dataJsContent.getBytes(Charsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String key(RelNode rel) {
        return "" + rel.getId();
    }

    private static String getNodeLabel(RelNode relNode) {
        if (relNode instanceof RelSubset) {
            RelSubset relSubset = (RelSubset)relNode;
            String setId = RuleMatchVisualizer.getSetId(relSubset);
            return "subset#" + relSubset.getId() + "-set" + setId + "-\n" + relSubset.getTraitSet();
        }
        return "#" + relNode.getId() + "-" + relNode.getRelTypeName();
    }

    private static String getSetId(RelSubset relSubset) {
        String explanation = RuleMatchVisualizer.getNodeExplanation(relSubset);
        int start = explanation.indexOf("RelSubset") + "RelSubset".length();
        if (start < 0) {
            return "";
        }
        int end = explanation.indexOf(".", start);
        if (end < 0) {
            return "";
        }
        return explanation.substring(start, end);
    }

    private static String getNodeExplanation(RelNode relNode) {
        InputExcludedRelWriter relWriter = new InputExcludedRelWriter();
        relNode.explain(relWriter);
        return relWriter.toString();
    }

    private static String formatCost(Double rowCount, @Nullable RelOptCost cost) {
        if (cost == null) {
            return "null";
        }
        String originalStr = cost.toString();
        if (originalStr.contains("inf") || originalStr.contains("huge") || originalStr.contains("tiny")) {
            return originalStr;
        }
        return new MessageFormat("\nrowCount: {0}\nrows: {1}\ncpu:  {2}\nio:   {3}", Locale.ROOT).format(new String[]{RuleMatchVisualizer.formatCostScientific(rowCount), RuleMatchVisualizer.formatCostScientific(cost.getRows()), RuleMatchVisualizer.formatCostScientific(cost.getCpu()), RuleMatchVisualizer.formatCostScientific(cost.getIo())});
    }

    private static String formatCostScientific(double costNumber) {
        long costRounded = Math.round(costNumber);
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(Locale.ROOT);
        formatter.applyPattern("#.#############################################E0");
        return formatter.format(costRounded);
    }
}

