/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.preferences;

import java.awt.BorderLayout;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class AnnotationPreferencesPanel
extends OWLPreferencesPanel {
    private Map<JCheckBox, URI> checkBoxURIMap;

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        TreeSet annotationProperties = new TreeSet();
        for (OWLOntology ont : this.getOWLModelManager().getOntologies()) {
            annotationProperties.addAll(ont.getAnnotationPropertiesInSignature());
        }
        this.checkBoxURIMap = new HashMap<JCheckBox, URI>();
        for (OWLAnnotationProperty property : annotationProperties) {
            JCheckBox cb = new JCheckBox(this.getOWLModelManager().getRendering((OWLObject)property), this.getOWLEditorKit().getWorkspace().isHiddenAnnotationURI(property.getIRI().toURI()));
            this.checkBoxURIMap.put(cb, property.getIRI().toURI());
            box.add(cb);
            box.add(Box.createVerticalStrut(4));
            cb.setOpaque(false);
        }
        JPanel holder = new JPanel(new BorderLayout());
        holder.setBorder(ComponentFactory.createTitledBorder((String)"Hidden annotation URIs"));
        holder.add(new JScrollPane(box));
        this.add(holder);
    }

    public void applyChanges() {
        HashSet<URI> hiddenURIs = new HashSet<URI>();
        for (JCheckBox cb : this.checkBoxURIMap.keySet()) {
            if (!cb.isSelected()) continue;
            hiddenURIs.add(this.checkBoxURIMap.get(cb));
        }
        this.getOWLEditorKit().getWorkspace().setHiddenAnnotationURIs(hiddenURIs);
    }

    public void dispose() throws Exception {
    }
}

