/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.protege.editor.core.AbstractModelManager;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.model.ChangeListMinimizer;
import org.protege.editor.owl.model.DocumentFormatMapper;
import org.protege.editor.owl.model.DocumentFormatUpdater;
import org.protege.editor.owl.model.IOListenerManager;
import org.protege.editor.owl.model.MissingImportHandler;
import org.protege.editor.owl.model.MissingImportHandlerImpl;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OntologyManagerFactory;
import org.protege.editor.owl.model.OntologyReloader;
import org.protege.editor.owl.model.cache.DeprecationCache;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCacheImpl;
import org.protege.editor.owl.model.cache.OWLObjectRenderingCache;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.find.OWLEntityFinder;
import org.protege.editor.owl.model.find.OWLEntityFinderImpl;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManagerImpl;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.HistoryManagerImpl;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.OWLReasonerManagerImpl;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.io.OntologyLoader;
import org.protege.editor.owl.model.io.OntologySaver;
import org.protege.editor.owl.model.io.OntologySourcesManager;
import org.protege.editor.owl.model.io.UserResolvedIRIMapper;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.model.prefix.PrefixedNameRenderer;
import org.protege.editor.owl.model.selection.ontologies.ImportsClosureOntologySelectionStrategy;
import org.protege.editor.owl.model.selection.ontologies.OntologySelectionStrategy;
import org.protege.editor.owl.model.util.ListenerManager;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.OWLObjectRenderingComparator;
import org.protege.editor.owl.ui.clsdescriptioneditor.ManchesterOWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandler;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.protege.xmlcatalog.XMLCatalog;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLModelManagerImpl
extends AbstractModelManager
implements OWLModelManager,
OWLEntityRendererListener,
OWLOntologyChangeListener,
OWLOntologyLoaderListener,
IOListenerManager {
    private final Logger logger = LoggerFactory.getLogger(OWLModelManagerImpl.class);
    private final HistoryManager historyManager;
    private final OWLReasonerManager owlReasonerManager;
    private final Set<OWLOntologyID> dirtyOntologies = new HashSet<OWLOntologyID>();
    private final OWLOntologyManager manager;
    private final OntologyCatalogManager ontologyCatalogManager = new OntologyCatalogManager();
    private final Set<OWLOntology> activeOntologies = new HashSet<OWLOntology>();
    private final Set<OntologySelectionStrategy> ontSelectionStrategies = new HashSet<OntologySelectionStrategy>();
    private final DeprecationCache deprecationCache;
    private final UserResolvedIRIMapper userResolvedIRIMapper = new UserResolvedIRIMapper(new MissingImportHandlerImpl());
    private final List<OWLModelManagerListener> modelManagerChangeListeners = new ArrayList<OWLModelManagerListener>();
    private final ListenerManager<OWLModelManagerListener> modelManagerListenerManager = new ListenerManager();
    private final ListenerManager<OWLOntologyChangeListener> changeListenerManager = new ListenerManager();
    private final List<IOListener> ioListeners = new ArrayList<IOListener>();
    private OWLModelManagerEntityRenderer entityRenderer;
    private OWLObjectRenderer objectRenderer;
    private OWLOntology activeOntology;
    private OWLEntityRenderingCache owlEntityRenderingCache;
    private OWLObjectRenderingCache owlObjectRenderingCache;
    private OWLEntityFinder entityFinder;
    private ExplanationManager explanationManager;
    private OWLEntityFactory entityFactory;
    private OntologySelectionStrategy activeOntologiesStrategy;
    private OWLExpressionCheckerFactory owlExpressionCheckerFactory;
    private OntologyLoadErrorHandler loadErrorHandler;
    private PrefixedNameRenderer prefixedNameRenderer;

    public OWLModelManagerImpl() {
        this.manager = OntologyManagerFactory.createManager();
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.objectRenderer = new OWLObjectRendererImpl(this);
        this.prefixedNameRenderer = PrefixedNameRenderer.builder().withOwlPrefixes().withWellKnownPrefixes().build();
        this.owlEntityRenderingCache = new OWLEntityRenderingCacheImpl();
        this.owlEntityRenderingCache.setOWLModelManager(this);
        this.owlObjectRenderingCache = new OWLObjectRenderingCache(this);
        this.owlExpressionCheckerFactory = new ManchesterOWLExpressionCheckerFactory(this);
        this.activeOntologiesStrategy = new ImportsClosureOntologySelectionStrategy(this);
        this.historyManager = new HistoryManagerImpl(this);
        this.owlReasonerManager = new OWLReasonerManagerImpl(this);
        this.owlReasonerManager.getReasonerPreferences().addListener(() -> this.fireEvent(EventType.ONTOLOGY_CLASSIFIED));
        this.deprecationCache = new DeprecationCache(this.manager.getOWLDataFactory().getOWLDeprecated());
        this.getOWLEntityRenderer();
        this.put(OntologySourcesManager.ID, new OntologySourcesManager(this));
    }

    @Override
    public void fireEvent(EventType type) {
        this.logger.debug("Firing event {}", (Object)type);
        Runnable r = () -> {
            OWLModelManagerChangeEvent event = new OWLModelManagerChangeEvent(this, type);
            this.logger.debug("Firing model manager event: {}", (Object)event);
            for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
                try {
                    listener.handleChange(event);
                }
                catch (Throwable e) {
                    this.logger.warn("Exception thrown by listener: {}.  Detatching bad listener.", (Object)listener.getClass().getName());
                    this.modelManagerChangeListeners.remove(listener);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    @Override
    public OWLModelManagerEntityRenderer getOWLEntityRenderer() {
        if (this.entityRenderer == null) {
            try {
                OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
                RendererPlugin plugin = preferences.getRendererPlugin();
                this.entityRenderer = plugin.newInstance();
                this.loadRenderer();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logger.error(e.getMessage());
            }
            if (this.entityRenderer == null) {
                this.entityRenderer = new OWLEntityRendererImpl();
                this.loadRenderer();
            }
        }
        return this.entityRenderer;
    }

    private void loadRenderer() {
        this.entityRenderer.addListener(this);
        this.entityRenderer.setup(this);
        this.entityRenderer.initialise();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ENTITY_RENDERER_CHANGED);
    }

    private void rebuildEntityIndices() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.owlEntityRenderingCache.rebuild();
        this.owlObjectRenderingCache.clear();
        stopwatch.stop();
        this.logger.debug("Rebuilt entity indices in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public void setOWLEntityRenderer(OWLModelManagerEntityRenderer renderer) {
        this.refreshRenderer();
    }

    public void dispose() {
        super.dispose();
        OntologySourcesManager sourcesMngr = (OntologySourcesManager)this.get(OntologySourcesManager.ID);
        this.removeIOListener(sourcesMngr);
        try {
            this.owlEntityRenderingCache.dispose();
            this.owlObjectRenderingCache.dispose();
            if (this.entityRenderer != null) {
                this.entityRenderer.dispose();
            }
            this.owlReasonerManager.dispose();
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst disposing of the model manager: {}", (Object)e.getMessage(), (Object)e);
        }
        this.modelManagerListenerManager.dumpWarningForAllListeners(this.logger, "(Listeners should be removed in the plugin dispose method!)");
        this.changeListenerManager.dumpWarningForAllListeners(this.logger, "(Listeners should be removed in the plugin dispose method!)");
    }

    @Override
    public void removeIOListener(IOListener listener) {
        this.ioListeners.remove(listener);
    }

    public boolean isDirty() {
        return !this.dirtyOntologies.isEmpty();
    }

    @Override
    public void setDirty(OWLOntology ontology) {
        this.dirtyOntologies.add(ontology.getOntologyID());
    }

    @Override
    public boolean isDirty(OWLOntology ontology) {
        return this.dirtyOntologies.contains(ontology.getOntologyID());
    }

    @Override
    public void setClean(OWLOntology ontology) {
        this.dirtyOntologies.remove(ontology.getOntologyID());
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    @Override
    public OWLHierarchyManager getOWLHierarchyManager() {
        OWLHierarchyManager hm = (OWLHierarchyManager)this.get(OWLHierarchyManager.ID);
        if (hm == null) {
            hm = new OWLHierarchyManagerImpl(this);
            this.put(OWLHierarchyManager.ID, hm);
        }
        return hm;
    }

    @Override
    public ExplanationManager getExplanationManager() {
        return this.explanationManager;
    }

    @Override
    public void setExplanationManager(ExplanationManager explanationManager) {
        this.explanationManager = explanationManager;
    }

    public boolean loadOntologyFromPhysicalURI(URI uri) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        try {
            this.logger.info(LogBanner.start((String)"Loading Ontology"));
            this.logger.info("Loading ontology from {}", (Object)uri);
            stopwatch.start();
            OntologyLoader loader = new OntologyLoader(this, this.userResolvedIRIMapper);
            Optional<OWLOntology> loadedOntology = loader.loadOntology(uri);
            this.logger.info("Loading for ontology and imports closure successfully completed in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            loadedOntology.ifPresent(ontology -> {
                DocumentFormatUpdater formatUpdater = new DocumentFormatUpdater(new DocumentFormatMapper());
                formatUpdater.updateFormat((OWLOntology)ontology);
            });
            this.logger.info(LogBanner.end());
            return loadedOntology.isPresent();
        }
        catch (OWLOntologyCreationException e) {
            OWLOntologyID id = new OWLOntologyID(com.google.common.base.Optional.of((Object)IRI.create((URI)uri)), com.google.common.base.Optional.absent());
            this.handleLoadError(id, uri, (Exception)((Object)e));
            return false;
        }
    }

    private void handleLoadError(OWLOntologyID owlOntologyID, URI documentURI, Exception e) {
        if (this.loadErrorHandler != null) {
            try {
                this.loadErrorHandler.handleErrorLoadingOntology(owlOntologyID, documentURI, e);
            }
            catch (Throwable e1) {
                ErrorLogPanel.showErrorDialog((Throwable)e1);
            }
        }
    }

    public void startedLoadingOntology(@Nonnull OWLOntologyLoaderListener.LoadingStartedEvent event) {
        this.logger.info("Loading {} from {}", (Object)event.getOntologyID(), (Object)event.getDocumentIRI());
        this.fireBeforeLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    @Override
    public void fireBeforeLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an exception during event dispatch: {}", e);
            }
        }
    }

    public void finishedLoadingOntology(@Nonnull OWLOntologyLoaderListener.LoadingFinishedEvent event) {
        if (!event.isSuccessful()) {
            this.handleLoadError(event.getOntologyID(), event.getDocumentIRI().toURI(), event.getException());
        }
        this.fireAfterLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    @Override
    public void fireAfterLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an exception during event dispatch: {}", e);
            }
        }
    }

    @Override
    public XMLCatalog addRootFolder(File dir) {
        return this.ontologyCatalogManager.addFolder(dir);
    }

    @Override
    public URI getOntologyPhysicalURI(OWLOntology ontology) {
        IRI ontologyDocumentIRI = this.manager.getOntologyDocumentIRI(ontology);
        if (this.isDefaultOWLAPIDocumentIRI(ontologyDocumentIRI)) {
            return URI.create("");
        }
        return ontologyDocumentIRI.toURI();
    }

    private boolean isDefaultOWLAPIDocumentIRI(IRI iri) {
        URI uri = iri.toURI();
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals("owlapi");
    }

    @Override
    public void setPhysicalURI(OWLOntology ontology, URI physicalURI) {
        this.manager.setOntologyDocumentIRI(ontology, IRI.create((URI)physicalURI));
    }

    @Override
    public OWLOntology createNewOntology(OWLOntologyID ontologyID, URI physicalURI) throws OWLOntologyCreationException {
        if (physicalURI != null && ontologyID.getDefaultDocumentIRI().isPresent()) {
            this.manager.getIRIMappers().add((Serializable)new SimpleIRIMapper((IRI)ontologyID.getDefaultDocumentIRI().get(), IRI.create((URI)physicalURI)));
        }
        OWLOntology ont = this.manager.createOntology(ontologyID);
        this.setActiveOntology(ont);
        if (physicalURI != null) {
            try {
                File containingDirectory = new File(physicalURI).getParentFile();
                if (containingDirectory.exists()) {
                    this.getOntologyCatalogManager().addFolder(containingDirectory);
                }
            }
            catch (IllegalArgumentException iae) {
                this.logger.info("Cannot generate ontology catalog for ontology at {}. {}", (Object)physicalURI, (Object)iae.getMessage());
            }
        }
        this.fireEvent(EventType.ONTOLOGY_CREATED);
        return ont;
    }

    @Override
    public OntologyCatalogManager getOntologyCatalogManager() {
        return this.ontologyCatalogManager;
    }

    private void setActiveOntology(OWLOntology activeOntology, boolean force) {
        if (!force && this.activeOntology != null && this.activeOntology.equals(activeOntology)) {
            return;
        }
        this.activeOntology = activeOntology;
        this.logger.debug("Setting active ontology to " + activeOntology.getOntologyID());
        this.rebuildActiveOntologiesCache();
        this.deprecationCache.rebuildCacheFromActiveOntologies(this.getActiveOntologies());
        this.entityRenderer.ontologiesChanged();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
    }

    private void rebuildActiveOntologiesCache() {
        this.activeOntologies.clear();
        this.activeOntologies.addAll(this.activeOntologiesStrategy.getOntologies());
    }

    @Override
    public Set<OWLOntology> getActiveOntologies() {
        return this.activeOntologies;
    }

    @Override
    public OWLOntology reload(OWLOntology ont) throws OWLOntologyCreationException {
        try {
            OntologyReloader reloader = new OntologyReloader(ont, this);
            reloader.reload();
            this.rebuildActiveOntologiesCache();
            this.refreshRenderer();
        }
        finally {
            this.setClean(ont);
            this.fireEvent(EventType.ONTOLOGY_RELOADED);
        }
        return ont;
    }

    @Override
    public boolean removeOntology(OWLOntology ont) {
        if (ont.equals(this.activeOntology)) {
            this.logger.debug("Request received to remove an ontology that is the active ontology.  Cannot remove the active ontology.  Ignoring request.");
            return false;
        }
        if (this.manager.contains(ont.getOntologyID()) && this.manager.getOntologies().size() == 1) {
            this.logger.debug("Request received to remove the one and only ontology that is open.  This is not allowed.  Ignoring request.");
            return false;
        }
        this.activeOntologies.remove(ont);
        this.dirtyOntologies.remove(ont.getOntologyID());
        this.manager.removeOntology(ont);
        this.setActiveOntology(this.activeOntology, true);
        return true;
    }

    @Override
    @Deprecated
    public void save() throws OWLOntologyStorageException {
        HashSet<OWLOntology> ontologiesToSave = new HashSet<OWLOntology>();
        for (OWLOntologyID ontId : this.dirtyOntologies) {
            if (this.manager.contains(ontId)) {
                ontologiesToSave.add(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
        for (OWLOntology ontology : ontologiesToSave) {
            this.save(ontology);
        }
    }

    @Override
    public void save(OWLOntology ont) throws OWLOntologyStorageException {
        OWLDocumentFormat format;
        URI documentURI = this.manager.getOntologyDocumentIRI(ont).toURI();
        this.fireBeforeSaveEvent(ont.getOntologyID(), documentURI);
        OWLDocumentFormat previousFormat = this.manager.getOntologyFormat(ont);
        if (previousFormat == null) {
            format = new RDFXMLDocumentFormat();
            this.logger.info("No document format for {} has been found.  Using the {} format.", (Object)ont.getOntologyID(), (Object)format);
        } else {
            format = previousFormat;
        }
        IRI documentIRI = IRI.create((URI)documentURI);
        OntologySaver saver = OntologySaver.builder().addOntology(ont, format, documentIRI).build();
        saver.saveOntologies();
        this.manager.setOntologyDocumentIRI(ont, documentIRI);
        this.logger.info("Saved ontology {} to {} in {} format", new Object[]{ont.getOntologyID(), documentIRI, format});
        this.dirtyOntologies.remove(ont.getOntologyID());
        this.fireEvent(EventType.ONTOLOGY_SAVED);
        this.fireAfterSaveEvent(ont.getOntologyID(), documentURI);
    }

    @Override
    public void fireBeforeSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an error during event dispatch: {}", e);
            }
        }
    }

    @Override
    public void fireAfterSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an error during event dispatch: {}", e);
            }
        }
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    @Override
    public Set<OWLOntology> getDirtyOntologies() {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        for (OWLOntologyID ontId : new ArrayList<OWLOntologyID>(this.dirtyOntologies)) {
            if (this.manager.contains(ontId)) {
                ontologies.add(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
        return ontologies;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.manager.getOWLDataFactory();
    }

    @Override
    public boolean isActiveOntologyMutable() {
        return this.isMutable(this.getActiveOntology());
    }

    @Override
    public boolean isMutable(OWLOntology ontology) {
        return true;
    }

    @Override
    public OWLOntology getActiveOntology() {
        return this.activeOntology;
    }

    @Override
    public void setActiveOntology(OWLOntology activeOntology) {
        this.setActiveOntology(activeOntology, false);
    }

    @Override
    public OntologySelectionStrategy getActiveOntologiesStrategy() {
        return this.activeOntologiesStrategy;
    }

    @Override
    public void setActiveOntologiesStrategy(OntologySelectionStrategy strategy) {
        this.activeOntologiesStrategy = strategy;
        this.setActiveOntology(this.getActiveOntology(), true);
        this.fireEvent(EventType.ONTOLOGY_VISIBILITY_CHANGED);
    }

    @Override
    public Set<OntologySelectionStrategy> getActiveOntologiesStrategies() {
        return this.ontSelectionStrategies;
    }

    @Override
    public void registerOntologySelectionStrategy(OntologySelectionStrategy strategy) {
        this.ontSelectionStrategies.add(strategy);
    }

    @Override
    public void applyChange(OWLOntologyChange change) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                change = adcManager.getChangeRewriter().rewriteChange(change);
            }
            this.applyChanges(Collections.singletonList(change));
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public void applyChanges(List<? extends OWLOntologyChange> changes) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                changes = adcManager.getChangeRewriter().rewriteChanges(changes);
            }
            this.logger.debug(LogBanner.start((String)"Applying changes"));
            this.logger.debug("Number of requested changes: {}", (Object)changes.size());
            List<OWLOntologyChange> minimizedChanges = new ChangeListMinimizer().getMinimisedChanges(changes);
            this.logger.debug("Number of minimized changes: {}", (Object)minimizedChanges.size());
            this.logger.debug(LogBanner.end());
            if (minimizedChanges.isEmpty()) {
                return;
            }
            this.manager.applyChanges(minimizedChanges);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) {
        if (changes.isEmpty()) {
            return;
        }
        this.deprecationCache.handleOntologyChanges(changes, this.getActiveOntologies());
        this.getHistoryManager().logChanges(changes);
        boolean refreshActiveOntology = false;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange instanceof SetOntologyID) {
                SetOntologyID ontologyIDChange = (SetOntologyID)oWLOntologyChange;
                this.dirtyOntologies.remove(ontologyIDChange.getOriginalOntologyID());
            }
            this.dirtyOntologies.add(oWLOntologyChange.getOntology().getOntologyID());
            if (!oWLOntologyChange.isImportChange()) continue;
            refreshActiveOntology = true;
        }
        if (refreshActiveOntology) {
            this.setActiveOntology(this.getActiveOntology(), true);
        }
    }

    @Override
    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    @Override
    public boolean isChangedEntity(OWLEntity entity) {
        return false;
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.addOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.removeOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void addListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.add(listener);
        this.modelManagerListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.remove(listener);
        this.modelManagerListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void addIOListener(IOListener listener) {
        this.ioListeners.add(listener);
    }

    @Override
    public String getDisabmiguatedRendering(OWLObject object, RenderingEscapeUtils.RenderingEscapeSetting renderingEscapeSetting) {
        String prefixedName;
        String escapedRendering = this.getRendering(object);
        String desiredRendering = renderingEscapeSetting == RenderingEscapeUtils.RenderingEscapeSetting.ESCAPED_RENDERING ? escapedRendering : RenderingEscapeUtils.unescape(escapedRendering);
        if (!(object instanceof OWLEntity)) {
            return desiredRendering;
        }
        Set<OWLEntity> matchingEntities = this.getOWLEntityFinder().getOWLEntities(escapedRendering);
        if (matchingEntities.size() <= 1) {
            return desiredRendering;
        }
        IRI entityIri = ((OWLEntity)object).getIRI();
        Optional<String> oboId = OboUtilities.getOboIdFromIri(entityIri);
        String disambiguatedRendering = oboId.isPresent() ? desiredRendering + " (" + oboId.get() + ")" : ((prefixedName = this.prefixedNameRenderer.getPrefixedNameOrElse(entityIri, null)) != null ? desiredRendering + " (" + prefixedName + ")" : desiredRendering);
        return disambiguatedRendering;
    }

    @Override
    public String getRendering(OWLObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof OWLEntity) {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null && object instanceof OWLClass && adcManager.isAnonymous((OWLClass)object)) {
                return this.owlObjectRenderingCache.getRendering((OWLObject)adcManager.getExpression((OWLClass)object), this.getOWLObjectRenderer());
            }
            this.getOWLEntityRenderer();
            String rendering = this.owlEntityRenderingCache.getRendering((OWLEntity)object);
            if (rendering != null) {
                return rendering;
            }
            return this.getOWLEntityRenderer().render((OWLEntity)object);
        }
        return this.owlObjectRenderingCache.getRendering(object, this.getOWLObjectRenderer());
    }

    @Override
    public OWLEntityFinder getOWLEntityFinder() {
        if (this.entityFinder == null) {
            this.entityFinder = new OWLEntityFinderImpl(this, this.owlEntityRenderingCache);
        }
        return this.entityFinder;
    }

    @Override
    public OWLObjectRenderer getOWLObjectRenderer() {
        return this.objectRenderer;
    }

    @Override
    public void renderingChanged(OWLEntity entity, OWLModelManagerEntityRenderer renderer) {
        this.owlEntityRenderingCache.updateRendering(entity);
        this.owlObjectRenderingCache.clear();
        for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
            listener.handleChange(new OWLModelManagerChangeEvent(this, EventType.ENTITY_RENDERING_CHANGED));
        }
    }

    @Override
    public void refreshRenderer() {
        if (this.entityRenderer != null) {
            this.entityRenderer.removeListener(this);
            try {
                this.entityRenderer.dispose();
            }
            catch (Exception e) {
                this.logger.warn("An error occurred whilst disposing of the entity renderer: {}", (Throwable)e);
            }
        }
        this.entityRenderer = null;
        this.getOWLEntityRenderer();
        this.loadRenderer();
    }

    @Override
    public OWLExpressionCheckerFactory getOWLExpressionCheckerFactory() {
        return this.owlExpressionCheckerFactory;
    }

    @Override
    public OWLEntityFactory getOWLEntityFactory() {
        if (this.entityFactory == null) {
            this.entityFactory = new CustomOWLEntityFactory(this);
        }
        return this.entityFactory;
    }

    @Override
    public void setOWLEntityFactory(OWLEntityFactory owlEntityFactory) {
        this.entityFactory = owlEntityFactory;
    }

    @Override
    public Comparator<OWLObject> getOWLObjectComparator() {
        OWLObjectRenderingComparator comparator = (OWLObjectRenderingComparator)this.get("OWL_OBJECT_COMPARATOR_KEY");
        if (comparator == null) {
            comparator = new OWLObjectRenderingComparator(this);
            this.put("OWL_OBJECT_COMPARATOR_KEY", comparator);
        }
        return comparator;
    }

    @Override
    public boolean isDeprecated(@Nonnull OWLObject object) {
        return this.deprecationCache.isDeprecated(object);
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public OWLReasonerManager getOWLReasonerManager() {
        return this.owlReasonerManager;
    }

    @Override
    public ReasonerPreferences getReasonerPreferences() {
        return this.getOWLReasonerManager().getReasonerPreferences();
    }

    @Override
    public void setMissingImportHandler(MissingImportHandler missingImportHandler) {
        this.userResolvedIRIMapper.setMissingImportHandler(missingImportHandler);
    }

    @Override
    public void setLoadErrorHandler(OntologyLoadErrorHandler handler) {
        this.loadErrorHandler = handler;
    }
}

