/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public final class LatexBracketChecker
implements OWLClassExpressionVisitor {
    private boolean requiresBracket;
    @Nonnull
    private static final LatexBracketChecker INSTANCE = new LatexBracketChecker();

    private LatexBracketChecker() {
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.requiresBracket = true;
    }

    public void visit(OWLDataCardinalityRestriction node) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.requiresBracket = true;
    }

    public void visit(OWLObjectCardinalityRestriction node) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.requiresBracket = false;
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLClass ce) {
        this.requiresBracket = false;
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.requiresBracket = true;
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.requiresBracket = true;
    }

    public static boolean requiresBracket(@Nonnull OWLClassExpression classExpression) {
        LatexBracketChecker.INSTANCE.requiresBracket = true;
        classExpression.accept(INSTANCE);
        return LatexBracketChecker.INSTANCE.requiresBracket;
    }
}

