/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.Main;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeMediaDB;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.GuiDownloads;
import mediathek.gui.GuiFilme;
import mediathek.gui.MVTray;
import mediathek.gui.TabPaneIndex;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.actions.CreateProtocolFileAction;
import mediathek.gui.actions.LoadFilmListAction;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.actions.MemoryMonitorAction;
import mediathek.gui.actions.QuitAction;
import mediathek.gui.actions.ResetSettingsAction;
import mediathek.gui.actions.SearchProgramUpdateAction;
import mediathek.gui.actions.SettingsAction;
import mediathek.gui.actions.ShowAboHistoryAction;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.actions.ShowOnlineHelpAction;
import mediathek.gui.actions.ShowProgramInfosAction;
import mediathek.gui.actions.export.FilmListExportAction;
import mediathek.gui.actions.import_actions.ImportOldAbosAction;
import mediathek.gui.actions.import_actions.ImportOldBlacklistAction;
import mediathek.gui.actions.import_actions.ImportOldReplacementListAction;
import mediathek.gui.bandwidth.BandwidthMonitorController;
import mediathek.gui.dialog.DialogBeenden;
import mediathek.gui.dialog.DialogMediaDB;
import mediathek.gui.dialog.LoadFilmListDialog;
import mediathek.gui.dialog.about.AboutDialog;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.messages.BandwidthMonitorStateChangedEvent;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.mediadb.MediaDbDialogVisibleEvent;
import mediathek.javafx.FilmListFilterTask;
import mediathek.javafx.FilmListNetworkReaderTask;
import mediathek.javafx.FilmListReaderTask;
import mediathek.javafx.OrfSetupInformationThread;
import mediathek.javafx.SelectedItemsLabel;
import mediathek.javafx.ShutdownDialog;
import mediathek.javafx.StatusBarController;
import mediathek.javafx.VerticalSeparator;
import mediathek.javafx.tool.FXProgressPane;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MenuTabSwitchListener;
import mediathek.mainwindow.WindowLocationConfigSaverListener;
import mediathek.res.GetIcon;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.Log;
import mediathek.tool.MemoryUtils;
import mediathek.tool.TABS;
import mediathek.tool.UIProgressState;
import mediathek.tool.threads.IndicatorThread;
import mediathek.update.AutomaticFilmlistUpdate;
import mediathek.update.ProgramUpdateCheck;
import mediathek.update.ProgrammUpdateSuchen;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGui
extends JFrame {
    private static final String ICON_NAME = "MediathekView.png";
    private static final String ICON_PATH = "/mediathek/res/";
    private static final int ICON_WIDTH = 58;
    private static final int ICON_HEIGHT = 58;
    private static final String KEY_F10 = "F10";
    private static final String NONE = "none";
    private static final Logger logger = LogManager.getLogger(MediathekGui.class);
    private static MediathekGui ui = null;
    protected final AtomicInteger numDownloadsStarted = new AtomicInteger(0);
    private final Daten daten = Daten.getInstance();
    private final JMenu jMenuDatei = new JMenu();
    private final JMenu jMenuFilme = new JMenu();
    private final JMenuBar jMenuBar = new JMenuBar();
    private final JMenu jMenuDownload = new JMenu();
    private final JMenu jMenuAbos = new JMenu();
    private final JMenu jMenuAnsicht = new JMenu();
    private final JMenu jMenuHilfe = new JMenu();
    private final IntegerProperty selectedItemsProperty = new SimpleIntegerProperty(0);
    private final ObjectProperty<TabPaneIndex> tabPaneIndexProperty = new SimpleObjectProperty<TabPaneIndex>(TabPaneIndex.NONE);
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final HashMap<JMenu, MenuTabSwitchListener> menuListeners = new HashMap();
    private final JCheckBoxMenuItem cbBandwidthDisplay = new JCheckBoxMenuItem("Bandbreitennutzung");
    private final JCheckBoxMenuItem cbSearchMediaDb = new JCheckBoxMenuItem("Mediensammlung durchsuchen");
    private final JFXPanel statusBarPanel = new JFXPanel();
    private final LoadFilmListAction loadFilmListAction;
    private final SearchProgramUpdateAction searchProgramUpdateAction;
    private final MemoryMonitorAction showMemoryMonitorAction = new MemoryMonitorAction();
    public GuiFilme tabFilme;
    public GuiDownloads tabDownloads;
    protected Configuration config = ApplicationConfiguration.getConfiguration();
    private BandwidthMonitorController bandwidthMonitor;
    private MVTray tray;
    private DialogEinstellungen dialogEinstellungen;
    private StatusBarController statusBarController;
    private InfoDialog filmInfo;
    private ProgramUpdateCheck programUpdateChecker;
    private IndicatorThread progressIndicatorThread;
    private DialogMediaDB dialogMediaDB;
    private ManageAboAction manageAboAction;

    public MediathekGui() {
        ui = this;
        this.setDefaultCloseOperation(0);
        IconFontSwing.register(FontAwesome.getIconFont());
        this.loadFilmListAction = new LoadFilmListAction(this);
        this.searchProgramUpdateAction = new SearchProgramUpdateAction(this);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MAINWINDOW));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.statusBarPanel, "Last");
        this.setIconAndWindowImage();
        this.createMenuBar();
        this.remapF10Key();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.WAIT_FOR_HISTORY_DATA));
        try {
            this.daten.waitForHistoryDataLoadingToComplete();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForHistoryDataLoadingToComplete()", (Throwable)e);
        }
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CREATE_STATUS_BAR));
        this.createStatusBar();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.SETUP_FILM_LISTENERS));
        this.setupFilmListListener();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_TABS));
        this.initTabs();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_MENUS));
        this.initMenus();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MEDIADB_DIALOG));
        this.initializeMediaDbDialog();
        this.daten.getMessageBus().subscribe(this);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MEMORY_MONITOR));
        this.createMemoryMonitor();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_BANDWIDTH_MONITOR));
        if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BANDWIDTH_MONITOR_VISIBLE))) {
            this.getBandwidthMonitorController().setVisibility();
        }
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FINISHED));
        this.workaroundControlsFxNotificationBug();
        this.workaroundJavaFxInitializationBug();
        SwingUtilities.invokeLater(() -> {
            if (Taskbar.isTaskbarSupported()) {
                this.setupTaskbarMenu();
            }
        });
        this.setupSystemTray();
        SwingUtilities.invokeLater(this::setApplicationWindowSize);
        this.loadFilmlist();
        this.setupUpdateCheck();
        this.showVlcHintForAustrianUsers();
    }

    public static MediathekGui ui() {
        return ui;
    }

    private void setupSystemTray() {
        SwingUtilities.invokeLater(() -> {
            this.initializeSystemTray();
            this.initWindowListenerForTray();
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private BandwidthMonitorController getBandwidthMonitorController() {
        if (this.bandwidthMonitor == null) {
            this.bandwidthMonitor = new BandwidthMonitorController(this);
        }
        return this.bandwidthMonitor;
    }

    private void showVlcHintForAustrianUsers() {
        OrfSetupInformationThread thread2 = new OrfSetupInformationThread();
        this.daten.getTimerPool().schedule(thread2, 10L, TimeUnit.SECONDS);
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            MenuItem miLoadNewFilmlist = new MenuItem("Neue Filmliste laden");
            miLoadNewFilmlist.addActionListener(e -> this.performFilmListLoadOperation(false));
            popupMenu.addSeparator();
            popupMenu.add(miLoadNewFilmlist);
            taskbar.setMenu(popupMenu);
        }
    }

    private void setIconAndWindowImage() {
        this.setWindowTitle();
        this.setIconImage(GetIcon.getIcon(ICON_NAME, ICON_PATH, 58, 58).getImage());
    }

    private void remapF10Key() {
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(KEY_F10), NONE);
    }

    private void createMenuBar() {
        this.jMenuDatei.setMnemonic('d');
        this.jMenuDatei.setText("Datei");
        this.jMenuBar.add(this.jMenuDatei);
        this.jMenuFilme.setMnemonic('F');
        this.jMenuFilme.setText("Filme");
        this.jMenuBar.add(this.jMenuFilme);
        this.jMenuDownload.setMnemonic('O');
        this.jMenuDownload.setText("Downloads");
        this.jMenuBar.add(this.jMenuDownload);
        this.jMenuAbos.setMnemonic('b');
        this.jMenuAbos.setText("Abos");
        this.jMenuBar.add(this.jMenuAbos);
        this.jMenuAnsicht.setMnemonic('a');
        this.jMenuAnsicht.setText("Ansicht");
        this.jMenuBar.add(this.jMenuAnsicht);
        this.jMenuHilfe.setMnemonic('h');
        this.jMenuHilfe.setText("Hilfe");
        this.jMenuBar.add(this.jMenuHilfe);
        this.setJMenuBar(this.jMenuBar);
    }

    protected void workaroundControlsFxNotificationBug() {
    }

    protected void workaroundJavaFxInitializationBug() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            Stage window = new Stage();
            window.setWidth(10.0);
            window.setHeight(10.0);
            window.show();
            window.hide();
        });
    }

    private void createMemoryMonitor() {
        if (Config.isDebugModeEnabled()) {
            this.showMemoryMonitorAction.showMemoryMonitor();
        }
    }

    private void loadFilmlist() {
        Platform.runLater(() -> {
            if (GuiFunktionen.getImportArtFilme() == FilmListUpdateType.AUTOMATIC && this.daten.getListeFilme().isTooOld()) {
                Daten.dontWriteFilmlistOnStartup.set(false);
            } else {
                Daten.dontWriteFilmlistOnStartup.set(true);
            }
            FXProgressPane progressPane = new FXProgressPane();
            FilmListReaderTask filmListReaderTask = new FilmListReaderTask();
            filmListReaderTask.setOnRunning(e -> {
                this.getStatusBarController().getStatusBar().getRightItems().add(progressPane);
                progressPane.bindTask(filmListReaderTask);
            });
            FilmListNetworkReaderTask networkTask = new FilmListNetworkReaderTask();
            networkTask.setOnRunning(e -> progressPane.bindTask(networkTask));
            FilmListFilterTask filterTask = new FilmListFilterTask(true);
            filterTask.setOnRunning(e -> progressPane.bindTask(filterTask));
            EventHandler<WorkerStateEvent> workerStateEventEventHandler = e -> this.getStatusBarController().getStatusBar().getRightItems().remove(progressPane);
            filterTask.setOnSucceeded(workerStateEventEventHandler);
            filterTask.setOnFailed(workerStateEventEventHandler);
            ((CompletableFuture)CompletableFuture.runAsync(filmListReaderTask).thenRun(networkTask)).thenRun(filterTask);
            Daten.dontWriteFilmlistOnStartup.set(false);
        });
    }

    public DialogMediaDB getMediaDatabaseDialog() {
        if (this.dialogMediaDB == null) {
            this.dialogMediaDB = new DialogMediaDB(this);
        }
        return this.dialogMediaDB;
    }

    private void initializeMediaDbDialog() {
        if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN))) {
            this.getMediaDatabaseDialog().setVis();
        }
    }

    public IntegerProperty getSelectedItemsProperty() {
        return this.selectedItemsProperty;
    }

    private void createStatusBar() {
        this.statusBarController = new StatusBarController(this.daten);
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.statusBarPanel.setScene(new Scene(this.statusBarController.createStatusBar()));
            this.installSelectedItemsLabel();
        });
        boolean enablePowerManagement = ApplicationConfiguration.getConfiguration().getBoolean("ui.filmlist_label.enable_powermanagement", false);
        if (enablePowerManagement) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    Platform.runLater(() -> MediathekGui.this.statusBarController.getFilmlistAgeLabel().enableTimer());
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    Platform.runLater(() -> MediathekGui.this.statusBarController.getFilmlistAgeLabel().disableTimer());
                }
            });
        }
    }

    private void installSelectedItemsLabel() {
        ObservableList<Node> leftItems = this.statusBarController.getStatusBar().getLeftItems();
        leftItems.add(0, new SelectedItemsLabel(this.selectedItemsProperty));
        leftItems.add(1, new VerticalSeparator());
    }

    public StatusBarController getStatusBarController() {
        return this.statusBarController;
    }

    public ObjectProperty<TabPaneIndex> tabPaneIndexProperty() {
        return this.tabPaneIndexProperty;
    }

    public InfoDialog getFilmInfoDialog() {
        if (this.filmInfo == null) {
            this.filmInfo = new InfoDialog((Window)this);
        }
        return this.filmInfo;
    }

    @Handler
    private void handleMediaDbDialogEvent(MediaDbDialogVisibleEvent e) {
        SwingUtilities.invokeLater(() -> this.cbSearchMediaDb.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN))));
    }

    @Handler
    private void handleTabVisualSettingsChangedEvent(TabVisualSettingsChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.configureTabPlacement();
            this.configureTabIcons();
        });
    }

    @Handler
    private void handleBandwidthMonitorStateChangedEvent(BandwidthMonitorStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.cbBandwidthDisplay.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BANDWIDTH_MONITOR_VISIBLE))));
    }

    private void setWindowTitle() {
        this.setTitle("MediathekView " + Konstanten.MVVERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.mainwindow.width");
            int height = config.getInt("application.ui.mainwindow.height");
            int x = config.getInt("application.ui.mainwindow.location.x");
            int y = config.getInt("application.ui.mainwindow.location.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException e) {
            this.setExtendedState(6);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setApplicationWindowSize() {
        if (Config.isStartMaximized() || ApplicationConfiguration.getConfiguration().getBoolean("application.ui.mainwindow.maximized", true)) {
            this.setExtendedState(6);
        } else {
            this.restoreSizeFromConfig();
        }
        SwingUtilities.invokeLater(() -> this.addComponentListener(new WindowLocationConfigSaverListener()));
    }

    private void setupFilmListListener() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(true);
                MediathekGui.this.daten.allesSpeichern();
            }

            @Override
            public void fertigOnlyOne(ListenerFilmeLadenEvent event) {
                MediathekGui.this.setupAutomaticFilmlistReload();
                MediathekGui.this.prepareMediaDb();
            }
        });
    }

    private void setupAutomaticFilmlistReload() {
        AutomaticFilmlistUpdate.IUpdateAction performUpdate = () -> {
            if (GuiFunktionen.getImportArtFilme() == FilmListUpdateType.AUTOMATIC && this.daten.getListeDownloads().unfinishedDownloads() == 0L) {
                FilmeLaden filmeLaden = new FilmeLaden(this.daten);
                filmeLaden.loadFilmlist("");
            }
        };
        AutomaticFilmlistUpdate automaticFilmlistUpdate = new AutomaticFilmlistUpdate(performUpdate);
        automaticFilmlistUpdate.start();
    }

    protected void initWindowListenerForTray() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MediathekGui.this.tray != null && Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_TRAY))) {
                    MediathekGui.this.setVisible(false);
                } else {
                    MediathekGui.this.beenden(false, false);
                }
            }
        });
    }

    private void prepareMediaDb() {
        ListeMediaDB mediaDb = this.daten.getListeMediaDB();
        mediaDb.loadSavedList();
        mediaDb.createMediaDB("");
    }

    private void setupUpdateCheck() {
        this.programUpdateChecker = new ProgramUpdateCheck(this.daten);
        this.programUpdateChecker.start();
    }

    public void initializeSystemTray() {
        boolean useTray = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_TRAY));
        if (this.tray == null && useTray) {
            this.tray = new MVTray().systemTray();
        } else if (this.tray != null && !useTray) {
            this.tray.beenden();
            this.tray = null;
        }
    }

    private void initTabs() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_DOWNLOAD_TAB));
        this.tabDownloads = new GuiDownloads(this.daten, this);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_FILM_TAB));
        this.tabFilme = new GuiFilme(this.daten, this);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.ADD_TABS_TO_UI));
        this.tabbedPane.addTab("Filme", this.tabFilme);
        this.tabbedPane.addTab("Downloads", this.tabDownloads);
        this.tabbedPane.setSelectedIndex(0);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CONFIGURE_TABS));
        this.configureTabPlacement();
        this.configureTabIcons();
    }

    public void enableUpdateMenuItem(boolean enable) {
        this.searchProgramUpdateAction.setEnabled(enable);
    }

    private void configureTabPlacement() {
        boolean topPosition = this.config.getBoolean("application.ui.tab_position.top", true);
        if (topPosition) {
            this.tabbedPane.setTabPlacement(1);
        } else {
            this.tabbedPane.setTabPlacement(2);
        }
    }

    private void configureTabIcons() {
        boolean icon = this.config.getBoolean("application.ui.mainwindow.tab_icons", false);
        if (!icon) {
            this.setTabIcon(this.tabFilme, null);
            this.setTabIcon(this.tabDownloads, null);
        } else {
            this.setTabIcon(this.tabFilme, Icons.ICON_TAB_FILM);
            this.setTabIcon(this.tabDownloads, Icons.ICON_TAB_DOWNLOAD);
        }
    }

    private void setTabIcon(Component tab, Icon icon) {
        int index = this.tabbedPane.indexOfComponent(tab);
        this.tabbedPane.setIconAt(index, icon);
    }

    protected IndicatorThread createProgressIndicatorThread() throws Exception {
        throw new Exception("Unsupported Platform");
    }

    @Handler
    protected void handleDownloadStart(DownloadStartEvent msg) {
        this.numDownloadsStarted.incrementAndGet();
        if (this.progressIndicatorThread == null) {
            try {
                this.progressIndicatorThread = this.createProgressIndicatorThread();
                this.progressIndicatorThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Handler
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        int numDL = this.numDownloadsStarted.decrementAndGet();
        if (numDL == 0 && this.progressIndicatorThread != null) {
            this.progressIndicatorThread.interrupt();
            this.progressIndicatorThread = null;
        }
    }

    protected void installMenuTabSwitchListener() {
        this.menuListeners.put(this.jMenuFilme, new MenuTabSwitchListener(this, TABS.TAB_FILME));
        this.menuListeners.put(this.jMenuDownload, new MenuTabSwitchListener(this, TABS.TAB_DOWNLOADS));
        if (this.config.getBoolean("application.ui.install_tab_listeners", true)) {
            this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
            this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
        }
    }

    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
        switch (msg.event) {
            case INSTALL: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
                break;
            }
            case REMOVE: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.removeMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.removeMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
            }
        }
    }

    private void createFileMenu() {
        this.jMenuDatei.add(this.loadFilmListAction);
        this.jMenuDatei.addSeparator();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(new FilmListExportAction(this));
        JMenu importMenu = new JMenu("Import");
        importMenu.add(new ImportOldAbosAction());
        importMenu.add(new ImportOldBlacklistAction());
        importMenu.add(new ImportOldReplacementListAction());
        this.jMenuDatei.add(exportMenu);
        this.jMenuDatei.add(importMenu);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(new SettingsAction(this));
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(new QuitAction(this));
        }
    }

    private void createViewMenu() {
        final JCheckBoxMenuItem cbShowButtons = new JCheckBoxMenuItem("Buttons anzeigen");
        if (!SystemUtils.IS_OS_MAC_OSX) {
            cbShowButtons.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        }
        cbShowButtons.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN)));
        cbShowButtons.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN, String.valueOf(cbShowButtons.isSelected()));
            Listener.notify(2, MediathekGui.class.getSimpleName());
        });
        Listener.addListener(new Listener(2, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                cbShowButtons.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN)));
            }
        });
        this.cbBandwidthDisplay.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BANDWIDTH_MONITOR_VISIBLE)));
        this.cbBandwidthDisplay.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BANDWIDTH_MONITOR_VISIBLE, Boolean.toString(this.cbBandwidthDisplay.isSelected()));
            this.getBandwidthMonitorController().setVisibility();
        });
        this.cbSearchMediaDb.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN)));
        this.cbSearchMediaDb.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN, String.valueOf(this.cbSearchMediaDb.isSelected()));
            this.getMediaDatabaseDialog().setVis();
        });
        JMenuItem showFilmFilterDialog = new JMenuItem("Filterdialog anzeigen");
        showFilmFilterDialog.addActionListener(l -> {
            JDialog dlg = this.tabFilme.fap.filterDialog;
            if (dlg != null && !dlg.isVisible()) {
                dlg.setVisible(true);
            }
        });
        this.jMenuAnsicht.add(cbShowButtons);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showMemoryMonitorAction);
        this.jMenuAnsicht.add(this.cbBandwidthDisplay);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(showFilmFilterDialog);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(new ShowFilmInformationAction(true));
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.cbSearchMediaDb);
    }

    private void createHelpMenu() {
        this.jMenuHilfe.add(new ShowOnlineHelpAction());
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new CreateProtocolFileAction());
        this.jMenuHilfe.add(new ResetSettingsAction(this, this.daten));
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(this.searchProgramUpdateAction);
        this.jMenuHilfe.add(new ShowProgramInfosAction(this));
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuHilfe.addSeparator();
            this.jMenuHilfe.add(new ShowAboutAction(this));
        }
    }

    protected void initMenus() {
        this.installMenuTabSwitchListener();
        this.createFileMenu();
        this.tabFilme.installMenuEntries(this.jMenuFilme);
        this.tabDownloads.installMenuEntries(this.jMenuDownload);
        this.createViewMenu();
        this.createAboMenu();
        this.createHelpMenu();
    }

    private void createAboMenu() {
        this.jMenuAbos.add(new CreateNewAboAction(this.daten.getListeAbo()));
        this.jMenuAbos.add(new ShowAboHistoryAction(MediathekGui.ui(), this.daten));
        this.jMenuAbos.addSeparator();
        this.tabFilme.fap.manageAboAction = this.manageAboAction = new ManageAboAction(this.daten);
        this.jMenuAbos.add(this.manageAboAction);
    }

    public void showAboutDialog() {
        AboutDialog dialog = new AboutDialog(this);
        GuiFunktionen.centerOnScreen(dialog, false);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void performFilmListLoadOperation(boolean manualMode) {
        if (manualMode || GuiFunktionen.getImportArtFilme() == FilmListUpdateType.MANUAL) {
            LoadFilmListDialog dlg = new LoadFilmListDialog(this);
            dlg.setVisible(true);
        } else {
            FilmeLaden filmeLaden = new FilmeLaden(this.daten);
            filmeLaden.loadFilmlist("");
        }
    }

    private DialogEinstellungen getSettingsDialog() {
        if (this.dialogEinstellungen == null) {
            this.dialogEinstellungen = new DialogEinstellungen();
        }
        return this.dialogEinstellungen;
    }

    public void showSettingsDialog() {
        this.getSettingsDialog().setVisible(true);
    }

    private void writeOldConfiguration() {
        if (this.bandwidthMonitor != null) {
            this.bandwidthMonitor.writeConfig();
        }
        if (this.dialogMediaDB != null) {
            GuiFunktionen.getSize(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_GROESSE, this.getMediaDatabaseDialog());
        }
    }

    protected void closeControlsFxWorkaroundStage() {
    }

    public boolean beenden(boolean showOptionTerminate, boolean shutDown) {
        if (this.daten.getListeDownloads().unfinishedDownloads() > 0L) {
            DialogBeenden dialogBeenden = new DialogBeenden(this);
            if (showOptionTerminate) {
                dialogBeenden.setComboWaitAndTerminate();
            }
            dialogBeenden.setVisible(true);
            if (!dialogBeenden.applicationCanTerminate()) {
                return false;
            }
            shutDown = dialogBeenden.isShutdownRequested();
        }
        this.showMemoryMonitorAction.closeMemoryMonitor();
        this.closeControlsFxWorkaroundStage();
        this.programUpdateChecker.close();
        ShutdownDialog dialog = new ShutdownDialog(this, 9);
        dialog.show();
        this.manageAboAction.closeDialog();
        dialog.setStatusText(1, "Beende Threadpools");
        this.shutdownTimerPool();
        this.waitForCommonPoolToComplete();
        dialog.setStatusText(2, "Film-Daten sichern");
        this.tabFilme.tabelleSpeichern();
        dialog.setStatusText(3, "Download-Daten sichern");
        this.tabDownloads.tabelleSpeichern();
        dialog.setStatusText(4, "MediaDB sichern");
        if (this.dialogMediaDB != null) {
            this.getMediaDatabaseDialog().tabelleSpeichern();
        }
        dialog.setStatusText(5, "Downloads anhalten");
        this.stopDownloads();
        dialog.setStatusText(6, "Programmkonfiguration schreiben");
        this.writeOldConfiguration();
        if (MemoryUtils.isLowMemoryEnvironment()) {
            dialog.setStatusText(7, "Datenbank schlie\u00dfen");
            DatenFilm.Database.closeDatabase();
        }
        dialog.setStatusText(8, "Programmdaten sichern");
        this.daten.allesSpeichern();
        dialog.setStatusText(9, "Fertig.");
        dialog.hide();
        this.tabFilme.fap.filterDialog.dispose();
        if (this.bandwidthMonitor != null) {
            this.bandwidthMonitor.close();
        }
        Log.endMsg();
        if (shutDown) {
            this.shutdownComputer();
        }
        this.dispose();
        ApplicationConfiguration.getInstance().writeConfiguration();
        Platform.exit();
        System.exit(0);
        return false;
    }

    private void shutdownTimerPool() {
        ScheduledThreadPoolExecutor timerPool = this.daten.getTimerPool();
        timerPool.shutdown();
        try {
            timerPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("timerPool shutdown exception", (Throwable)e);
        }
        List<Runnable> taskList = timerPool.shutdownNow();
        if (!taskList.isEmpty()) {
            logger.trace("timerPool taskList was not empty");
            logger.trace(taskList.toString());
        }
    }

    private void stopDownloads() {
        if (this.daten.getListeDownloads() != null) {
            for (DatenDownload download : this.daten.getListeDownloads()) {
                Start s2 = download.start;
                if (s2 == null) continue;
                s2.stoppen = true;
            }
        }
    }

    private void waitForCommonPoolToComplete() {
        while (ForkJoinPool.commonPool().hasQueuedSubmissions()) {
            try {
                logger.debug("POOL SUBMISSIONS: {}", (Object)ForkJoinPool.commonPool().getQueuedSubmissionCount());
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void shutdownComputer() {
    }

    public void searchForUpdateOrShowProgramInfos(boolean infos) {
        new ProgrammUpdateSuchen().checkVersion(!infos, infos, false);
    }
}

