/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.Listener;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListeBlacklist
extends LinkedList<DatenBlacklist> {
    private static final Logger logger = LogManager.getLogger(ListeBlacklist.class);
    private static final String[] EMPTY_STRING = new String[]{""};
    private long days = 0L;
    private boolean doNotShowFutureFilms;
    private boolean doNotShowGeoBlockedFilms;
    private boolean blacklistIsActive;
    private long filmlaengeSoll = 0L;
    private int nr = 0;

    public synchronized void addWithoutNotification(DatenBlacklist b) {
        b.arr[0] = Integer.toString(this.nr++);
        super.add(b);
    }

    @Override
    public synchronized boolean add(DatenBlacklist b) {
        b.arr[0] = Integer.toString(this.nr++);
        boolean ret = super.add(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized boolean remove(Object b) {
        boolean ret = super.remove(b);
        this.filterListAndNotifyListeners();
        return ret;
    }

    @Override
    public synchronized DatenBlacklist remove(int idx) {
        DatenBlacklist ret = (DatenBlacklist)super.remove(idx);
        this.filterListAndNotifyListeners();
        return ret;
    }

    public synchronized DatenBlacklist remove(String idx) {
        DatenBlacklist bl = this.get(idx);
        if (bl != null) {
            this.remove(bl);
        }
        this.filterListAndNotifyListeners();
        return bl;
    }

    @Override
    public synchronized DatenBlacklist get(int idx) {
        return (DatenBlacklist)super.get(idx);
    }

    public synchronized DatenBlacklist get(String strIndex) {
        return this.stream().filter(e -> e.arr[0].equals(strIndex)).findFirst().orElse(null);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.filterListAndNotifyListeners();
    }

    public synchronized Object[][] getObjectData() {
        Object[][] object = new Object[this.size()][5];
        int i = 0;
        for (DatenBlacklist blacklist : this) {
            object[i] = blacklist.arr;
            ++i;
        }
        return object;
    }

    public synchronized void filterListe() {
        Daten daten = Daten.getInstance();
        ListeFilme listeFilme = daten.getListeFilme();
        ListeFilme listeRet = daten.getListeFilmeNachBlackList();
        this.loadCurrentFilterSettings();
        Stopwatch stopwatch = Stopwatch.createStarted();
        listeRet.clear();
        if (listeFilme != null) {
            listeRet.setMetaData(listeFilme.metaData());
            this.parallelStream().forEach(entry -> {
                entry.toLower();
                entry.hasPattern();
            });
            listeRet.neueFilme = false;
            Predicate<DatenFilm> pred = this.createPredicate();
            Stopwatch stopwatch2 = Stopwatch.createStarted();
            listeFilme.parallelStream().filter(pred).forEachOrdered(listeRet::add);
            stopwatch2.stop();
            logger.debug("FILTERING and ADDING() took: {}", (Object)stopwatch2);
            this.setupNewEntries();
            listeRet.fillSenderList();
        }
        stopwatch.stop();
        logger.debug("filterListe(): {}", (Object)stopwatch);
    }

    private Predicate<DatenFilm> createPredicate() {
        ArrayList<Predicate<DatenFilm>> filterList = new ArrayList<Predicate<DatenFilm>>();
        if (this.days != 0L) {
            filterList.add(this::checkDate);
        }
        if (this.blacklistIsActive) {
            if (!this.isEmpty()) {
                filterList.add(this::applyBlacklistFilters);
            }
            if (this.doNotShowGeoBlockedFilms) {
                filterList.add(this::checkGeoBlockedFilm);
            }
            if (this.doNotShowFutureFilms) {
                filterList.add(this::checkIfFilmIsInFuture);
            }
            filterList.add(this::checkFilmLength);
        }
        Predicate<DatenFilm> pred = filterList.stream().reduce(Predicate::and).orElse(x -> true);
        filterList.clear();
        return pred;
    }

    private void setupNewEntries() {
        Daten daten = Daten.getInstance();
        daten.getListeFilmeNachBlackList().stream().filter(DatenFilm::isNew).findAny().ifPresent(ignored -> {
            daten.getListeFilmeNachBlackList().neueFilme = true;
        });
    }

    public synchronized boolean checkBlackOkFilme_Downloads(DatenFilm film) {
        this.loadCurrentFilterSettings();
        this.days = 0L;
        this.blacklistIsActive = true;
        return this.applyFiltersForAbos(film);
    }

    public synchronized void filterListAndNotifyListeners() {
        this.filterListe();
        Listener.notify(39, ListeBlacklist.class.getSimpleName());
    }

    private void loadCurrentFilterSettings() {
        try {
            String val = (String)MediathekGui.ui().tabFilme.fap.zeitraumProperty.getValue();
            if (val.equals("\u221e")) {
                this.days = 0L;
            } else {
                long max = 86400000L * (long)Integer.parseInt(val);
                this.days = System.currentTimeMillis() - max;
            }
        }
        catch (Exception ex) {
            this.days = 0L;
        }
        try {
            this.filmlaengeSoll = Long.parseLong(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)) * 60L;
        }
        catch (Exception ex) {
            this.filmlaengeSoll = 0L;
        }
        this.blacklistIsActive = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON));
        this.doNotShowFutureFilms = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN));
        this.doNotShowGeoBlockedFilms = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_GEO_NICHT_ANZEIGEN));
    }

    private boolean applyFiltersForAbos(DatenFilm film) {
        if (!this.checkDate(film)) {
            return false;
        }
        if (!this.blacklistIsActive) {
            return true;
        }
        if (this.doNotShowGeoBlockedFilms && !this.checkGeoBlockedFilm(film)) {
            return false;
        }
        if (this.doNotShowFutureFilms && !this.checkIfFilmIsInFuture(film)) {
            return false;
        }
        if (!this.checkFilmLength(film)) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (DatenBlacklist blacklistEntry : this) {
            String[] stringArray;
            String[] stringArray2;
            String string = blacklistEntry.arr[1];
            String string2 = blacklistEntry.arr[2];
            if (Filter.isPattern(blacklistEntry.arr[3])) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = blacklistEntry.arr[3];
            } else {
                stringArray2 = blacklistEntry.arr[3].toLowerCase().split(",");
            }
            if (Filter.isPattern(blacklistEntry.arr[4])) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = blacklistEntry.arr[4];
            } else {
                stringArray = blacklistEntry.arr[4].toLowerCase().split(",");
            }
            if (!Filter.filterAufFilmPruefen(string, string2, stringArray2, stringArray, new String[]{""}, 0, true, film, true)) continue;
            return Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
        }
        return !Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
    }

    private boolean checkGeoBlockedFilm(DatenFilm film) {
        Optional<String> geoOpt = film.getGeo();
        if (geoOpt.isEmpty()) {
            return true;
        }
        String geoLocation = ApplicationConfiguration.getConfiguration().getString("geo.location");
        return geoOpt.orElse("").contains(geoLocation);
    }

    private String[] mySplit(String inputString) {
        String[] pTitle = StringUtils.split(inputString, ',');
        if (pTitle.length == 0) {
            return EMPTY_STRING;
        }
        return pTitle;
    }

    private String[] createPattern(boolean isPattern, String inputString) {
        if (isPattern) {
            return new String[]{inputString};
        }
        return this.mySplit(inputString);
    }

    private boolean applyBlacklistFilters(DatenFilm film) {
        boolean isWhitelist = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
        for (DatenBlacklist entry : this) {
            String[] pThema;
            String[] pTitel;
            if (!this.performFiltering(entry, pTitel = this.createPattern(entry.patternTitle, entry.arr[3]), pThema = this.createPattern(entry.patternThema, entry.arr[4]), film)) continue;
            return isWhitelist;
        }
        return !isWhitelist;
    }

    private boolean performFiltering(DatenBlacklist entry, String[] titelSuchen, String[] themaTitelSuchen, DatenFilm film) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        String senderSuchen = entry.arr[1];
        String themaSuchen = entry.arr[2];
        if ((senderSuchen.isEmpty() || film.getSender().compareTo(senderSuchen) == 0) && (themaSuchen.isEmpty() || thema.equalsIgnoreCase(themaSuchen)) && (titelSuchen.length == 0 || Filter.pruefen(titelSuchen, title)) && (themaTitelSuchen.length == 0 || Filter.pruefen(themaTitelSuchen, thema) || Filter.pruefen(themaTitelSuchen, title)) && this.checkLengthWithMin(film.getFilmLength())) {
            result = true;
        }
        return result;
    }

    private boolean checkLengthWithMin(long filmLaenge) {
        return Filter.lengthCheck(0, filmLaenge) || filmLaenge > 0L;
    }

    private boolean checkDate(@NotNull DatenFilm film) {
        if (this.days != 0L) {
            long filmTime = film.getDatumFilm().getTime();
            return filmTime == 0L || filmTime >= this.days;
        }
        return true;
    }

    private boolean checkIfFilmIsInFuture(@NotNull DatenFilm film) {
        return film.getDatumFilm().getTime() <= System.currentTimeMillis();
    }

    private boolean checkFilmLength(@NotNull DatenFilm film) {
        long filmLength = film.getFilmLength();
        return this.filmlaengeSoll == 0L || filmLength == 0L || this.filmlaengeSoll <= filmLength;
    }
}

