/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.SunMoonCalculator;
import eu.hansolo.tilesfx.weather.DarkSky;
import eu.hansolo.tilesfx.weather.WeatherSymbol;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class EphemerisTileSkin
extends TileSkin {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private SunMoonCalculator smc;
    private Text titleText;
    private Text text;
    private Circle blueHourDotMorning;
    private Text blueHourTitleMorning;
    private Text blueHourSunriseText;
    private VBox blueHourSunriseTextBox;
    private HBox blueHourSunriseBox;
    private WeatherSymbol sunriseSymbol;
    private Text sunriseTitle;
    private Text sunriseText;
    private VBox sunriseTextBox;
    private HBox sunriseBox;
    private Circle goldenHourDotMorning;
    private Text goldenHourTitleMorning;
    private Text goldenHourSunriseText;
    private VBox goldenHourSunriseTextBox;
    private HBox goldenHourSunriseBox;
    private Circle goldenHourDotEvening;
    private Text goldenHourTitleEvening;
    private Text goldenHourSunsetText;
    private VBox goldenHourSunsetTextBox;
    private HBox goldenHourSunsetBox;
    private WeatherSymbol sunsetSymbol;
    private Text sunsetTitle;
    private Text sunsetText;
    private VBox sunsetTextBox;
    private HBox sunsetBox;
    private Circle blueHourDotEvening;
    private Text blueHourTitleEvening;
    private Text blueHourSunsetText;
    private VBox blueHourSunsetTextBox;
    private HBox blueHourSunsetBox;
    private VBox infoBoxMorning;
    private VBox infoBoxEvening;
    private HBox infoBox;

    public EphemerisTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        LocalDateTime now = LocalDateTime.now();
        ZonedDateTime zdt = now.atZone(this.tile.getZoneId());
        try {
            this.smc = new SunMoonCalculator(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), this.tile.getCurrentLocation().getLatitude(), this.tile.getCurrentLocation().getLongitude());
            this.smc.calcEphemeris(this.tile.getZoneId());
        }
        catch (Exception e) {
            this.smc = null;
        }
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.blueHourDotMorning = new Circle(14.0, Tile.TileColor.BLUE.color);
        this.blueHourTitleMorning = new Text("Blue Hour");
        this.blueHourSunriseText = new Text("--:--");
        this.blueHourSunriseTextBox = new VBox(this.blueHourTitleMorning, this.blueHourSunriseText);
        this.blueHourSunriseBox = new HBox(this.blueHourDotMorning, this.blueHourSunriseTextBox);
        this.blueHourSunriseBox.setAlignment(Pos.CENTER_LEFT);
        this.sunriseSymbol = new WeatherSymbol(DarkSky.ConditionAndIcon.SUNRISE, 22.0, this.tile.getForegroundColor());
        this.sunriseTitle = new Text("Sunrise");
        this.sunriseText = new Text("--:--");
        this.sunriseTextBox = new VBox(this.sunriseTitle, this.sunriseText);
        this.sunriseBox = new HBox(this.sunriseSymbol, this.sunriseTextBox);
        this.sunriseBox.setAlignment(Pos.CENTER_LEFT);
        this.goldenHourDotMorning = new Circle(14.0, Tile.TileColor.ORANGE.color);
        this.goldenHourTitleMorning = new Text("Golden Hour");
        this.goldenHourSunriseText = new Text("--:--");
        this.goldenHourSunriseTextBox = new VBox(this.goldenHourTitleMorning, this.goldenHourSunriseText);
        this.goldenHourSunriseBox = new HBox(this.goldenHourDotMorning, this.goldenHourSunriseTextBox);
        this.goldenHourSunriseBox.setAlignment(Pos.CENTER_LEFT);
        this.goldenHourDotEvening = new Circle(14.0, Tile.TileColor.ORANGE.color);
        this.goldenHourTitleEvening = new Text("Golden Hour");
        this.goldenHourSunsetText = new Text("--:--");
        this.goldenHourSunsetTextBox = new VBox(this.goldenHourTitleEvening, this.goldenHourSunsetText);
        this.goldenHourSunsetBox = new HBox(this.goldenHourDotEvening, this.goldenHourSunsetTextBox);
        this.goldenHourSunsetBox.setAlignment(Pos.CENTER_LEFT);
        this.sunsetSymbol = new WeatherSymbol(DarkSky.ConditionAndIcon.SUNSET, 22.0, this.tile.getForegroundColor());
        this.sunsetTitle = new Text("Sunset");
        this.sunsetText = new Text("--:--");
        this.sunsetTextBox = new VBox(this.sunsetTitle, this.sunsetText);
        this.sunsetBox = new HBox(this.sunsetSymbol, this.sunsetTextBox);
        this.sunsetBox.setAlignment(Pos.CENTER_LEFT);
        this.blueHourDotEvening = new Circle(14.0, Tile.TileColor.BLUE.color);
        this.blueHourTitleEvening = new Text("Blue Hour");
        this.blueHourSunsetText = new Text("--:--");
        this.blueHourSunsetTextBox = new VBox(this.blueHourTitleEvening, this.blueHourSunsetText);
        this.blueHourSunsetBox = new HBox(this.blueHourDotEvening, this.blueHourSunsetTextBox);
        this.blueHourSunsetBox.setAlignment(Pos.CENTER_LEFT);
        this.infoBoxMorning = new VBox(this.blueHourSunriseBox, this.sunriseBox, this.goldenHourSunriseBox);
        this.infoBoxEvening = new VBox(this.goldenHourSunsetBox, this.sunsetBox, this.blueHourSunsetBox);
        this.infoBox = new HBox(this.infoBoxMorning, this.infoBoxEvening);
        this.infoBox.setAlignment(Pos.CENTER);
        this.text = new Text(this.tile.getText());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.infoBox});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.calcEphemeris();
        }
    }

    private void calcEphemeris() {
        try {
            this.smc.setDate(LocalDate.now());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.smc.calcEphemeris(this.tile.getZoneId());
        this.blueHourSunriseText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunriseCivil()), TIME_FORMATTER.format(this.smc.getSunriseBlueHour())));
        this.sunriseText.setText(TIME_FORMATTER.format(this.smc.getSunrise()));
        this.goldenHourSunriseText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunrise()), TIME_FORMATTER.format(this.smc.getSunriseGoldenHour())));
        this.goldenHourSunsetText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunsetGoldenHour()), TIME_FORMATTER.format(this.smc.getSunset())));
        this.sunsetText.setText(TIME_FORMATTER.format(this.smc.getSunset()));
        this.blueHourSunsetText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunsetBlueHour()), TIME_FORMATTER.format(this.smc.getSunsetCivil())));
    }

    @Override
    protected void resizeDynamicText() {
        double fontSize = this.size * Tile.TextSize.SMALL.factor;
        Font font = Fonts.latoRegular(fontSize);
        this.blueHourSunriseText.setFont(font);
        this.sunriseText.setFont(font);
        this.goldenHourSunriseText.setFont(font);
        this.goldenHourSunsetText.setFont(font);
        this.sunsetText.setFont(font);
        this.blueHourSunsetText.setFont(font);
        fontSize = this.size * Tile.TextSize.SMALLER.factor;
        font = Fonts.latoRegular(fontSize);
        this.blueHourTitleMorning.setFont(font);
        this.sunriseTitle.setFont(font);
        this.goldenHourTitleMorning.setFont(font);
        this.goldenHourTitleEvening.setFont(font);
        this.sunsetTitle.setFont(font);
        this.blueHourTitleEvening.setFont(font);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.blueHourDotMorning.setRadius(this.size * 0.03);
        this.goldenHourDotMorning.setRadius(this.size * 0.03);
        this.blueHourDotEvening.setRadius(this.size * 0.03);
        this.goldenHourDotEvening.setRadius(this.size * 0.03);
        this.sunriseSymbol.setPrefSize(this.size * 0.07, this.size * 0.07);
        this.sunsetSymbol.setPrefSize(this.size * 0.07, this.size * 0.07);
        this.blueHourSunriseBox.setSpacing(this.size * 0.025);
        this.sunriseBox.setSpacing(this.size * 0.025);
        this.goldenHourSunriseBox.setSpacing(this.size * 0.025);
        this.goldenHourSunsetBox.setSpacing(this.size * 0.025);
        this.sunsetBox.setSpacing(this.size * 0.025);
        this.blueHourSunsetBox.setSpacing(this.size * 0.025);
        this.infoBoxMorning.setSpacing(this.contentBounds.getHeight() * 0.25);
        this.infoBoxEvening.setSpacing(this.contentBounds.getHeight() * 0.25);
        this.infoBox.setSpacing(this.width * 0.15);
        this.infoBox.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.infoBox.relocate(this.contentBounds.getX(), this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.blueHourSunriseText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunriseCivil()), TIME_FORMATTER.format(this.smc.getSunriseBlueHour())));
        this.sunriseText.setText(TIME_FORMATTER.format(this.smc.getSunrise()));
        this.goldenHourSunriseText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunrise()), TIME_FORMATTER.format(this.smc.getSunriseGoldenHour())));
        this.goldenHourSunsetText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunsetGoldenHour()), TIME_FORMATTER.format(this.smc.getSunset())));
        this.sunsetText.setText(TIME_FORMATTER.format(this.smc.getSunset()));
        this.blueHourSunsetText.setText(String.join((CharSequence)" - ", TIME_FORMATTER.format(this.smc.getSunsetBlueHour()), TIME_FORMATTER.format(this.smc.getSunsetCivil())));
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.blueHourDotMorning.setFill(Tile.TileColor.BLUE.color);
        this.blueHourTitleMorning.setFill(this.tile.getTextColor());
        this.blueHourSunriseText.setFill(this.tile.getTextColor());
        this.sunriseSymbol.setSymbolColor(this.tile.getTextColor());
        this.sunriseTitle.setFill(this.tile.getTextColor());
        this.sunriseText.setFill(this.tile.getTextColor());
        this.goldenHourDotMorning.setFill(Tile.TileColor.ORANGE.color);
        this.goldenHourTitleMorning.setFill(this.tile.getTextColor());
        this.goldenHourSunriseText.setFill(this.tile.getTextColor());
        this.goldenHourDotEvening.setFill(Tile.TileColor.ORANGE.color);
        this.goldenHourTitleEvening.setFill(this.tile.getTextColor());
        this.goldenHourSunsetText.setFill(this.tile.getTextColor());
        this.sunsetSymbol.setSymbolColor(this.tile.getTextColor());
        this.sunsetTitle.setFill(this.tile.getTextColor());
        this.sunsetText.setFill(this.tile.getTextColor());
        this.blueHourDotEvening.setFill(Tile.TileColor.BLUE.color);
        this.blueHourTitleEvening.setFill(this.tile.getTextColor());
        this.blueHourSunsetText.setFill(this.tile.getTextColor());
    }
}

