# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_gix_global_optspecs
	string join \n r/repository= c/config= t/threads= v/verbose trace no-verbose progress s/strict progress-keep-open f/format= object-hash= h/help V/version
end

function __fish_gix_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_gix_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_gix_using_subcommand
	set -l cmd (__fish_gix_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c gix -n "__fish_gix_needs_command" -s r -l repository -d 'The repository to access' -r -F
complete -c gix -n "__fish_gix_needs_command" -s c -l config -d 'Add these values to the configuration in the form of `key=value` or `key`' -r
complete -c gix -n "__fish_gix_needs_command" -s t -l threads -d 'The amount of threads to use for some operations' -r
complete -c gix -n "__fish_gix_needs_command" -s f -l format -d 'Determine the format to use when outputting statistics' -r -f -a "{human\t'',json\t''}"
complete -c gix -n "__fish_gix_needs_command" -l object-hash -d 'The object format to assume when reading files that don\'t inherently know about it, or when writing files' -r -f -a "{SHA1\t''}"
complete -c gix -n "__fish_gix_needs_command" -s v -l verbose -d 'Display verbose messages and progress information'
complete -c gix -n "__fish_gix_needs_command" -l trace -d 'Display structured `tracing` output in a tree-like structure'
complete -c gix -n "__fish_gix_needs_command" -l no-verbose -d 'Turn off verbose message display for commands where these are shown by default'
complete -c gix -n "__fish_gix_needs_command" -l progress -d 'Bring up a terminal user interface displaying progress visually'
complete -c gix -n "__fish_gix_needs_command" -s s -l strict -d 'Don\'t default malformed configuration flags, but show an error instead. Ignore IO errors as well'
complete -c gix -n "__fish_gix_needs_command" -l progress-keep-open -d 'The progress TUI will stay up even though the work is already completed'
complete -c gix -n "__fish_gix_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_needs_command" -s V -l version -d 'Print version'
complete -c gix -n "__fish_gix_needs_command" -f -a "archive" -d 'Subcommands for creating worktree archives'
complete -c gix -n "__fish_gix_needs_command" -f -a "clean"
complete -c gix -n "__fish_gix_needs_command" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graph files'
complete -c gix -n "__fish_gix_needs_command" -f -a "odb" -d 'Interact with the object database'
complete -c gix -n "__fish_gix_needs_command" -f -a "fsck" -d 'Check for missing objects'
complete -c gix -n "__fish_gix_needs_command" -f -a "tree" -d 'Interact with tree objects'
complete -c gix -n "__fish_gix_needs_command" -f -a "commit" -d 'Interact with commit objects'
complete -c gix -n "__fish_gix_needs_command" -f -a "verify" -d 'Verify the integrity of the entire repository'
complete -c gix -n "__fish_gix_needs_command" -f -a "revision" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_gix_needs_command" -f -a "rev" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_gix_needs_command" -f -a "r" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_gix_needs_command" -f -a "credential" -d 'A program just like `git credential`'
complete -c gix -n "__fish_gix_needs_command" -f -a "fetch" -d 'Fetch data from remotes and store it in the repository'
complete -c gix -n "__fish_gix_needs_command" -f -a "clone"
complete -c gix -n "__fish_gix_needs_command" -f -a "mailmap" -d 'Interact with the mailmap'
complete -c gix -n "__fish_gix_needs_command" -f -a "remote" -d 'Interact with the remote hosts'
complete -c gix -n "__fish_gix_needs_command" -f -a "remotes" -d 'Interact with the remote hosts'
complete -c gix -n "__fish_gix_needs_command" -f -a "attributes" -d 'Interact with the attribute files like .gitattributes'
complete -c gix -n "__fish_gix_needs_command" -f -a "attrs" -d 'Interact with the attribute files like .gitattributes'
complete -c gix -n "__fish_gix_needs_command" -f -a "exclude" -d 'Interact with the exclude files like .gitignore'
complete -c gix -n "__fish_gix_needs_command" -f -a "index"
complete -c gix -n "__fish_gix_needs_command" -f -a "submodule" -d 'Interact with submodules'
complete -c gix -n "__fish_gix_needs_command" -f -a "cat" -d 'Show whatever object is at the given spec'
complete -c gix -n "__fish_gix_needs_command" -f -a "is-clean"
complete -c gix -n "__fish_gix_needs_command" -f -a "is-changed"
complete -c gix -n "__fish_gix_needs_command" -f -a "config-tree" -d 'Show which git configuration values are used or planned'
complete -c gix -n "__fish_gix_needs_command" -f -a "status" -d 'compute repository status similar to `git status`'
complete -c gix -n "__fish_gix_needs_command" -f -a "config" -d 'Print all entries in a configuration file or access other sub-commands'
complete -c gix -n "__fish_gix_needs_command" -f -a "merge-base" -d 'A command for calculating all merge-bases'
complete -c gix -n "__fish_gix_needs_command" -f -a "merge" -d 'perform merges of various kinds'
complete -c gix -n "__fish_gix_needs_command" -f -a "diff" -d 'Print all changes between two objects'
complete -c gix -n "__fish_gix_needs_command" -f -a "worktree" -d 'Commands for handling worktrees'
complete -c gix -n "__fish_gix_needs_command" -f -a "free" -d 'Subcommands that need no git repository to run'
complete -c gix -n "__fish_gix_needs_command" -f -a "no-repo" -d 'Subcommands that need no git repository to run'
complete -c gix -n "__fish_gix_needs_command" -f -a "completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_gix_needs_command" -f -a "generate-completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_gix_needs_command" -f -a "shell-completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_gix_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand archive" -s f -l format -d 'Explicitly set the format. Otherwise derived from the suffix of the output file' -r -f -a "{internal\t'An internal format that is for debugging, it should not be persisted and cannot be read back',tar\t'Use the `.tar` file format, uncompressed',tar-gz\t'Use the `.tar.gz` file format, compressed with `gzip`',zip\t'Use the `.zip` container format'}"
complete -c gix -n "__fish_gix_using_subcommand archive" -l prefix -d 'Apply the prefix verbatim to any path we add to the archive. Use a trailing `/` if prefix is a directory' -r
complete -c gix -n "__fish_gix_using_subcommand archive" -s l -l compression-level -d 'The compression strength to use for `.zip` and `.tar.gz` archives, valid from 0-9' -r
complete -c gix -n "__fish_gix_using_subcommand archive" -s p -l add-path -d 'Add the given path to the archive. Directories will always be empty' -r -F
complete -c gix -n "__fish_gix_using_subcommand archive" -s v -l add-virtual-file -d 'Add the new file from a slash-separated path, which must happen in pairs of two, first the path, then the content' -r
complete -c gix -n "__fish_gix_using_subcommand archive" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand clean" -l skip-hidden-repositories -d 'Enter ignored directories to skip repositories contained within' -r -f -a "{all\t'',non-bare\t''}"
complete -c gix -n "__fish_gix_using_subcommand clean" -l find-untracked-repositories -d 'What kind of repositories to find inside of untracked directories' -r -f -a "{all\t'',non-bare\t''}"
complete -c gix -n "__fish_gix_using_subcommand clean" -l debug -d 'Print additional debug information to help understand decisions it made'
complete -c gix -n "__fish_gix_using_subcommand clean" -s n -l dry-run -d 'A dummy to easy with muscle-memory. This flag is assumed if provided or not, and has no effect'
complete -c gix -n "__fish_gix_using_subcommand clean" -s e -l execute -d 'Actually perform the operation, which deletes files on disk without chance of recovery'
complete -c gix -n "__fish_gix_using_subcommand clean" -s x -l ignored -d 'Remove ignored (and expendable) files'
complete -c gix -n "__fish_gix_using_subcommand clean" -s p -l precious -d 'Remove precious files'
complete -c gix -n "__fish_gix_using_subcommand clean" -s d -l directories -d 'Remove whole directories'
complete -c gix -n "__fish_gix_using_subcommand clean" -s r -l repositories -d 'Remove nested repositories, even outside ignored directories'
complete -c gix -n "__fish_gix_using_subcommand clean" -s m -l pathspec-matches-result -d 'Pathspec patterns are used to match the result of the dirwalk, not the dirwalk itself'
complete -c gix -n "__fish_gix_using_subcommand clean" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and not __fish_seen_subcommand_from verify list help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and not __fish_seen_subcommand_from verify list help" -f -a "verify" -d 'Verify the integrity of a commit graph file'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and not __fish_seen_subcommand_from verify list help" -f -a "list" -d 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and not __fish_seen_subcommand_from verify list help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from verify" -s s -l statistics -d 'output statistical information about the graph'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a commit graph file'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
complete -c gix -n "__fish_gix_using_subcommand commit-graph; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -f -a "statistics" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_gix_using_subcommand odb; and not __fish_seen_subcommand_from entries info stats statistics help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from stats" -l extra-header-lookup -d 'Lookup headers again, but without preloading indices'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from stats" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from statistics" -l extra-header-lookup -d 'Lookup headers again, but without preloading indices'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from statistics" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from help" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from help" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_gix_using_subcommand odb; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand fsck" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand tree; and not __fish_seen_subcommand_from entries info help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand tree; and not __fish_seen_subcommand_from entries info help" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_gix_using_subcommand tree; and not __fish_seen_subcommand_from entries info help" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_gix_using_subcommand tree; and not __fish_seen_subcommand_from entries info help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from entries" -s r -l recursive -d 'Traverse the entire tree and its subtrees respectively, not only this tree'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from entries" -s e -l extended -d 'Provide files size as well. This is expensive as the object is decoded entirely'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from info" -s e -l extended -d 'Provide files size as well. This is expensive as the object is decoded entirely'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from help" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from help" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_gix_using_subcommand tree; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand commit; and not __fish_seen_subcommand_from verify describe help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit; and not __fish_seen_subcommand_from verify describe help" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_gix_using_subcommand commit; and not __fish_seen_subcommand_from verify describe help" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_gix_using_subcommand commit; and not __fish_seen_subcommand_from verify describe help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s c -l max-candidates -d 'Consider only the given `n` candidates. This can take longer, but potentially produces more accurate results' -r
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s d -l dirty-suffix -d 'Set the suffix to append if the repository is dirty (not counting untracked files)' -r
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s t -l annotated-tags -d 'Use annotated tag references only, not all tags'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s a -l all-refs -d 'Use all references under the `ref/` namespaces, which includes tag references, local and remote branches'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s f -l first-parent -d 'Only follow the first parent when traversing the commit graph'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s l -l long -d 'Always display the long format, even if that would not be necessary as the id is located directly on a reference'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s s -l statistics -d 'Print information on stderr to inform about performance statistics'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -l always -d 'If there was no way to describe the commit, fallback to using the abbreviated input revision'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from describe" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from help" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_gix_using_subcommand commit; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand verify" -s a -l algorithm -d 'The algorithm used to verify packs. They differ in costs' -r -f -a "{less-time\t'',less-memory\t''}"
complete -c gix -n "__fish_gix_using_subcommand verify" -s s -l statistics -d 'output statistical information'
complete -c gix -n "__fish_gix_using_subcommand verify" -l decode -d 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
complete -c gix -n "__fish_gix_using_subcommand verify" -l re-encode -d 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
complete -c gix -n "__fish_gix_using_subcommand verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "l" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "e" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "query" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "parse" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "p" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "prev" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand revision; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from list" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from list" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from l" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from l" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from l" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from explain" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from e" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from resolve" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from p" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from previous-branches" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from prev" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand revision; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "l" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "e" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "query" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "parse" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "p" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "prev" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand rev; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from list" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from list" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from l" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from l" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from l" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from explain" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from e" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from resolve" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from p" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from previous-branches" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from prev" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand rev; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "l" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "e" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "query" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "parse" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "p" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "prev" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand r; and not __fish_seen_subcommand_from list l explain e resolve query parse p previous-branches prev help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from list" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from list" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from l" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from l" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from l" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from explain" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from e" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from resolve" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git\t'The version stored in the Git Object Database',worktree\t'The version that would be checked out into the worktree, including filters',diff\t'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git\t'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw\t'Show the raw bytes - only useful for piping into files for use with tooling',pretty\t'Display a tree in human-readable form'}"
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from p" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from previous-branches" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from prev" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand r; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "get" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "store" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "erase" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand credential; and not __fish_seen_subcommand_from fill get approve store reject erase help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from fill" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from approve" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from store" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from reject" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from erase" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from help" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from help" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from help" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand credential; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand fetch" -s g -l open-negotiation-graph -d 'Open the commit graph used for negotiation and write an SVG file to PATH' -r -F
complete -c gix -n "__fish_gix_using_subcommand fetch" -l depth -d 'Fetch with the history truncated to the given number of commits as seen from the remote' -r
complete -c gix -n "__fish_gix_using_subcommand fetch" -l deepen -d 'Extend the current shallow boundary by the given amount of commits, with 0 meaning no change' -r
complete -c gix -n "__fish_gix_using_subcommand fetch" -l shallow-since -d 'Cutoff all history past the given date. Can be combined with shallow-exclude' -r
complete -c gix -n "__fish_gix_using_subcommand fetch" -l shallow-exclude -d 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since' -r
complete -c gix -n "__fish_gix_using_subcommand fetch" -s r -l remote -d 'The name of the remote to connect to, or the url of the remote to connect to directly' -r
complete -c gix -n "__fish_gix_using_subcommand fetch" -s n -l dry-run -d 'Don\'t change the local repository, but otherwise try to be as accurate as possible'
complete -c gix -n "__fish_gix_using_subcommand fetch" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_gix_using_subcommand fetch" -s s -l negotiation-info -d 'Print statistics about negotiation phase'
complete -c gix -n "__fish_gix_using_subcommand fetch" -l unshallow -d 'Remove the shallow boundary and fetch the entire history available on the remote'
complete -c gix -n "__fish_gix_using_subcommand fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand clone" -l depth -d 'Create a shallow clone with the history truncated to the given number of commits' -r
complete -c gix -n "__fish_gix_using_subcommand clone" -l shallow-since -d 'Cutoff all history past the given date. Can be combined with shallow-exclude' -r
complete -c gix -n "__fish_gix_using_subcommand clone" -l shallow-exclude -d 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since' -r
complete -c gix -n "__fish_gix_using_subcommand clone" -l ref -d 'The name of the reference to check out' -r
complete -c gix -n "__fish_gix_using_subcommand clone" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_gix_using_subcommand clone" -l bare -d 'The clone will be bare and a working tree checkout won\'t be available'
complete -c gix -n "__fish_gix_using_subcommand clone" -l no-tags -d 'Do not clone any tags. Useful to reduce the size of the clone if only branches are needed'
complete -c gix -n "__fish_gix_using_subcommand clone" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and not __fish_seen_subcommand_from entries check help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and not __fish_seen_subcommand_from entries check help" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and not __fish_seen_subcommand_from entries check help" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and not __fish_seen_subcommand_from entries check help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and __fish_seen_subcommand_from check" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and __fish_seen_subcommand_from help" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_gix_using_subcommand mailmap; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -s n -l name -d 'The name of the remote to connect to, or the URL of the remote to connect to directly' -r
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_gix_using_subcommand remote; and not __fish_seen_subcommand_from refs ref-map help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from refs" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from ref-map" -s u -l show-unmapped-remote-refs -d 'Also display remote references that were sent by the server, but filtered by the refspec locally'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from ref-map" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_gix_using_subcommand remote; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -s n -l name -d 'The name of the remote to connect to, or the URL of the remote to connect to directly' -r
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_gix_using_subcommand remotes; and not __fish_seen_subcommand_from refs ref-map help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from refs" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from ref-map" -s u -l show-unmapped-remote-refs -d 'Also display remote references that were sent by the server, but filtered by the refspec locally'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from ref-map" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_gix_using_subcommand remotes; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand attributes; and not __fish_seen_subcommand_from validate-baseline query help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attributes; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_gix_using_subcommand attributes; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_gix_using_subcommand attributes; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from validate-baseline" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from validate-baseline" -l no-ignore -d 'Don\'t validated excludes as obtaining them with `check-ignore` can be very slow'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from validate-baseline" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from query" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_gix_using_subcommand attributes; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand attrs; and not __fish_seen_subcommand_from validate-baseline query help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attrs; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_gix_using_subcommand attrs; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_gix_using_subcommand attrs; and not __fish_seen_subcommand_from validate-baseline query help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from validate-baseline" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from validate-baseline" -l no-ignore -d 'Don\'t validated excludes as obtaining them with `check-ignore` can be very slow'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from validate-baseline" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from query" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_gix_using_subcommand attrs; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand exclude; and not __fish_seen_subcommand_from query help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand exclude; and not __fish_seen_subcommand_from query help" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_gix_using_subcommand exclude; and not __fish_seen_subcommand_from query help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from query" -s p -l patterns -d 'Additional patterns to use for exclusions. They have the highest priority' -r
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from query" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from query" -s i -l show-ignore-patterns -d 'Show actual ignore patterns instead of un-excluding an entry'
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from help" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_gix_using_subcommand exclude; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand index; and not __fish_seen_subcommand_from entries from-tree read-tree help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand index; and not __fish_seen_subcommand_from entries from-tree read-tree help" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_gix_using_subcommand index; and not __fish_seen_subcommand_from entries from-tree read-tree help" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_gix_using_subcommand index; and not __fish_seen_subcommand_from entries from-tree read-tree help" -f -a "read-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_gix_using_subcommand index; and not __fish_seen_subcommand_from entries from-tree read-tree help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -s f -l format -d 'How to output index entries' -r -f -a "{simple\t'Show only minimal information, useful for first glances',rich\t'Show much more information that is still human-readable'}"
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -l no-attributes -d 'Do not visualize excluded entries or attributes per path'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -s i -l attributes-from-index -d 'Load attribute and ignore files from the index, don\'t look at the worktree'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -s r -l recurse-submodules -d 'Display submodule entries as well if their repository exists'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from from-tree" -s i -l index-output-path -d 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work' -r -F
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from from-tree" -s f -l force -d 'Overwrite the specified index file if it already exists'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from from-tree" -s s -l skip-hash -d 'Don\'t write the trailing hash for a performance gain'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from from-tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from read-tree" -s i -l index-output-path -d 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work' -r -F
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from read-tree" -s f -l force -d 'Overwrite the specified index file if it already exists'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from read-tree" -s s -l skip-hash -d 'Don\'t write the trailing hash for a performance gain'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from read-tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from help" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_gix_using_subcommand index; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand submodule; and not __fish_seen_subcommand_from list help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand submodule; and not __fish_seen_subcommand_from list help" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_gix_using_subcommand submodule; and not __fish_seen_subcommand_from list help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand submodule; and __fish_seen_subcommand_from list" -s d -l dirty-suffix -d 'Set the suffix to append if the repository is dirty (not counting untracked files)' -r
complete -c gix -n "__fish_gix_using_subcommand submodule; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand submodule; and __fish_seen_subcommand_from help" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_gix_using_subcommand submodule; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand cat" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand is-clean" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand is-changed" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand config-tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand status" -s f -l format -d 'The way status data is displayed' -r -f -a "{simplified\t'A basic format that is easy to read, and useful for a first glimpse as flat list',porcelain-v2\t'Output very similar to `git status --porcelain=2`'}"
complete -c gix -n "__fish_gix_using_subcommand status" -l ignored -d 'If enabled, show ignored files and directories' -r -f -a "{collapsed\t'display all ignored files and directories, but collapse them if possible to simplify',matching\t'Show exact matches. Note that this may show directories if these are a match as well'}"
complete -c gix -n "__fish_gix_using_subcommand status" -l submodules -d 'Define how to display the submodule status. Defaults to git configuration if unset' -r -f -a "{all\t'display all information about submodules, including ref changes, modifications and untracked files',ref-change\t'Compare only the configuration of the superprojects commit with the actually checked out `HEAD` commit',modifications\t'See if there are worktree modifications compared to the index, but do not check for untracked files',none\t'Ignore all submodule changes'}"
complete -c gix -n "__fish_gix_using_subcommand status" -l index-worktree-renames -d 'Enable rename tracking between the index and the working tree, preventing the collapse of folders as well' -r
complete -c gix -n "__fish_gix_using_subcommand status" -s s -l statistics -d 'Print additional statistics to help understanding performance'
complete -c gix -n "__fish_gix_using_subcommand status" -l no-write -d 'Don\'t write back a changed index, which forces this operation to always be idempotent'
complete -c gix -n "__fish_gix_using_subcommand status" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand config" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand merge-base" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand merge; and not __fish_seen_subcommand_from file tree commit help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand merge; and not __fish_seen_subcommand_from file tree commit help" -f -a "file" -d 'Merge a file by specifying ours, base and theirs'
complete -c gix -n "__fish_gix_using_subcommand merge; and not __fish_seen_subcommand_from file tree commit help" -f -a "tree" -d 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
complete -c gix -n "__fish_gix_using_subcommand merge; and not __fish_seen_subcommand_from file tree commit help" -f -a "commit" -d 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
complete -c gix -n "__fish_gix_using_subcommand merge; and not __fish_seen_subcommand_from file tree commit help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from file" -s c -l resolve-with -d 'Decide how to resolve conflicts. If unset, write conflict markers and fail' -r -f -a "{union\t'Use ours then theirs in case of conflict',ours\t'Use only ours in case of conflict',theirs\t'Use only theirs in case of conflict'}"
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from tree" -s f -l file-favor -d 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail' -r -f -a "{ours\t'Use only ours in case of conflict',theirs\t'Use only theirs in case of conflict'}"
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from tree" -s m -l in-memory -d 'Keep all objects to be written in memory to avoid any disk IO'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from tree" -s d -l debug -d 'Print additional information about conflicts for debugging'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from tree" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from commit" -s f -l file-favor -d 'Decide how to resolve content conflicts in files. If unset, write conflict markers and fail' -r -f -a "{ours\t'Use only ours in case of conflict',theirs\t'Use only theirs in case of conflict'}"
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from commit" -s m -l in-memory -d 'Keep all objects to be written in memory to avoid any disk IO'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from commit" -s d -l debug -d 'Print additional information about conflicts for debugging'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from commit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from help" -f -a "file" -d 'Merge a file by specifying ours, base and theirs'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from help" -f -a "tree" -d 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from help" -f -a "commit" -d 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
complete -c gix -n "__fish_gix_using_subcommand merge; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand diff; and not __fish_seen_subcommand_from tree help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand diff; and not __fish_seen_subcommand_from tree help" -f -a "tree" -d 'Diff two trees'
complete -c gix -n "__fish_gix_using_subcommand diff; and not __fish_seen_subcommand_from tree help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand diff; and __fish_seen_subcommand_from tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand diff; and __fish_seen_subcommand_from help" -f -a "tree" -d 'Diff two trees'
complete -c gix -n "__fish_gix_using_subcommand diff; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand worktree; and not __fish_seen_subcommand_from list help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand worktree; and not __fish_seen_subcommand_from list help" -f -a "list" -d 'List all worktrees, along with some accompanying information'
complete -c gix -n "__fish_gix_using_subcommand worktree; and not __fish_seen_subcommand_from list help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand worktree; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand worktree; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all worktrees, along with some accompanying information'
complete -c gix -n "__fish_gix_using_subcommand worktree; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_gix_using_subcommand free; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from commit-graph" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from commit-graph" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from commit-graph" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from mailmap" -s p -l path -d 'The path to the mailmap file' -r -F
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from mailmap" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from mailmap" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from mailmap" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from pack" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -l object-hash -d 'The object format to assume when reading files that don\'t inherently know about it, or when writing files' -r -f -a "{SHA1\t''}"
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -s i -l index-path -d 'The path to the index file' -r -F
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from index" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from discover" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_gix_using_subcommand free; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and not __fish_seen_subcommand_from commit-graph mailmap pack index discover help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from commit-graph" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from commit-graph" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from commit-graph" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from mailmap" -s p -l path -d 'The path to the mailmap file' -r -F
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from mailmap" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from mailmap" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from mailmap" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from pack" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -l object-hash -d 'The object format to assume when reading files that don\'t inherently know about it, or when writing files' -r -f -a "{SHA1\t''}"
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -s i -l index-path -d 'The path to the index file' -r -F
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from index" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from discover" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_gix_using_subcommand no-repo; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand completions" -s s -l shell -d 'The shell to generate completions for. Otherwise it\'s derived from the environment' -r -f -a "{bash\t'',elvish\t'',fish\t'',powershell\t'',zsh\t''}"
complete -c gix -n "__fish_gix_using_subcommand completions" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand generate-completions" -s s -l shell -d 'The shell to generate completions for. Otherwise it\'s derived from the environment' -r -f -a "{bash\t'',elvish\t'',fish\t'',powershell\t'',zsh\t''}"
complete -c gix -n "__fish_gix_using_subcommand generate-completions" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand shell-completions" -s s -l shell -d 'The shell to generate completions for. Otherwise it\'s derived from the environment' -r -f -a "{bash\t'',elvish\t'',fish\t'',powershell\t'',zsh\t''}"
complete -c gix -n "__fish_gix_using_subcommand shell-completions" -s h -l help -d 'Print help'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "archive" -d 'Subcommands for creating worktree archives'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "clean"
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graph files'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "odb" -d 'Interact with the object database'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "fsck" -d 'Check for missing objects'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "tree" -d 'Interact with tree objects'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "commit" -d 'Interact with commit objects'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "verify" -d 'Verify the integrity of the entire repository'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "revision" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "credential" -d 'A program just like `git credential`'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "fetch" -d 'Fetch data from remotes and store it in the repository'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "clone"
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "mailmap" -d 'Interact with the mailmap'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "remote" -d 'Interact with the remote hosts'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "attributes" -d 'Interact with the attribute files like .gitattributes'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "exclude" -d 'Interact with the exclude files like .gitignore'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "index"
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "submodule" -d 'Interact with submodules'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "cat" -d 'Show whatever object is at the given spec'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "is-clean"
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "is-changed"
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "config-tree" -d 'Show which git configuration values are used or planned'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "status" -d 'compute repository status similar to `git status`'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "config" -d 'Print all entries in a configuration file or access other sub-commands'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "merge-base" -d 'A command for calculating all merge-bases'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "merge" -d 'perform merges of various kinds'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "diff" -d 'Print all changes between two objects'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "worktree" -d 'Commands for handling worktrees'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "free" -d 'Subcommands that need no git repository to run'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_gix_using_subcommand help; and not __fish_seen_subcommand_from archive clean commit-graph odb fsck tree commit verify revision credential fetch clone mailmap remote attributes exclude index submodule cat is-clean is-changed config-tree status config merge-base merge diff worktree free completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from commit-graph" -f -a "verify" -d 'Verify the integrity of a commit graph file'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from commit-graph" -f -a "list" -d 'List all entries in the commit-graph file as reachable by starting from `HEAD`'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from odb" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from odb" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from odb" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from tree" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from tree" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from commit" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from commit" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from revision" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from revision" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from revision" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from revision" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from credential" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from credential" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from credential" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from mailmap" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from mailmap" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from remote" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from remote" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from attributes" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from attributes" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from exclude" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from index" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from index" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from submodule" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from merge" -f -a "file" -d 'Merge a file by specifying ours, base and theirs'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from merge" -f -a "tree" -d 'Merge a tree by specifying ours, base and theirs, writing it to the object database'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from merge" -f -a "commit" -d 'Merge a commits by specifying ours, and theirs, writing the tree to the object database'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from diff" -f -a "tree" -d 'Diff two trees'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from worktree" -f -a "list" -d 'List all worktrees, along with some accompanying information'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from free" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from free" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from free" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from free" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_gix_using_subcommand help; and __fish_seen_subcommand_from free" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
