/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.TableLockImpl;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.utils.MapDeepEquals;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class TimeIndexStore<T extends Element, K, S extends TimeSet<K>, M extends TimeMap<K, ?>> {
    protected final TableLockImpl lock;
    protected final Class<T> elementType;
    protected final Map<K, Integer> timeSortedMap;
    protected final IntSortedSet garbageQueue;
    protected int[] countMap;
    protected int length;
    protected TimeIndexImpl mainIndex;
    protected final Map<GraphView, TimeIndexImpl> viewIndexes;

    protected TimeIndexStore(Class<T> type, TableLockImpl lock, boolean indexed, Map<K, Integer> sortedMap) {
        this.elementType = type;
        this.lock = lock;
        this.garbageQueue = new IntRBTreeSet();
        this.timeSortedMap = sortedMap;
        this.countMap = new int[0];
        this.viewIndexes = indexed ? new Object2ObjectOpenHashMap() : null;
    }

    protected abstract void checkK(K var1);

    protected abstract double getLow(K var1);

    protected abstract TimeIndexImpl createIndex(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer add(K k) {
        this.checkK(k);
        this.lock();
        try {
            Integer id = this.timeSortedMap.get(k);
            if (id == null) {
                if (!this.garbageQueue.isEmpty()) {
                    id = this.garbageQueue.firstInt();
                    this.garbageQueue.remove((Object)id);
                } else {
                    id = this.length++;
                }
                this.timeSortedMap.put(k, id);
                this.ensureArraySize(id);
                this.countMap[id.intValue()] = 1;
            } else {
                int n = id;
                this.countMap[n] = this.countMap[n] + 1;
            }
            Integer n = id;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(K k, Element element) {
        this.lock();
        try {
            int timeIndex = this.add(k);
            if (this.mainIndex != null) {
                this.mainIndex.add(timeIndex, element);
                if (!this.viewIndexes.isEmpty()) {
                    for (Map.Entry<GraphView, TimeIndexImpl> entry : this.viewIndexes.entrySet()) {
                        GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                        DirectedSubgraph graph = graphView.getDirectedGraph();
                        boolean node = element instanceof Node;
                        if (!(node ? graph.contains((Node)element) : graph.contains((Edge)element))) continue;
                        entry.getValue().add(timeIndex, element);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void add(TimeMap<K, ?> timeMap) {
        for (K timeKey : timeMap.toKeysArray()) {
            this.add(timeKey);
        }
    }

    public void add(TimeSet<K> timeSet, Element element) {
        for (K timeKey : timeSet.toArray()) {
            this.add(timeKey, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer remove(K k) {
        this.lock();
        try {
            this.checkK(k);
            Integer id = this.timeSortedMap.get(k);
            if (id != null) {
                int n = id;
                this.countMap[n] = this.countMap[n] - 1;
                if (this.countMap[n] == 0) {
                    this.garbageQueue.add(id);
                    this.timeSortedMap.remove(k);
                }
            }
            Integer n = id;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K k, Element element) {
        this.lock();
        try {
            Integer timeIndex = this.remove(k);
            if (timeIndex == null) {
                return;
            }
            if (this.mainIndex != null) {
                this.mainIndex.remove(timeIndex, element);
                if (!this.viewIndexes.isEmpty()) {
                    for (Map.Entry<GraphView, TimeIndexImpl> entry : this.viewIndexes.entrySet()) {
                        GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                        DirectedSubgraph graph = graphView.getDirectedGraph();
                        if (element instanceof Node) {
                            if (!graph.contains((Node)element)) continue;
                            entry.getValue().remove(timeIndex, element);
                            continue;
                        }
                        if (!graph.contains((Edge)element)) continue;
                        entry.getValue().remove(timeIndex, element);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void remove(M timeMap) {
        for (Object timeKey : timeMap.toKeysArray()) {
            this.remove((K)timeKey);
        }
    }

    public void remove(S timeSet, Element element) {
        for (Object timeKey : timeSet.toArray()) {
            this.remove((S)timeKey, element);
        }
    }

    public boolean contains(K k) {
        this.checkK(k);
        this.lock();
        try {
            boolean bl = this.timeSortedMap.containsKey(k);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(Element element) {
        this.lock();
        try {
            S timeSet = this.getTimeSet(element);
            if (timeSet != null) {
                this.add((TimeSet<K>)timeSet, element);
            }
            Element element2 = element;
            synchronized (element2) {
                for (Object val : element.getAttributes()) {
                    if (!(val instanceof TimeMap)) continue;
                    TimeMap dynamicValue = (TimeMap)val;
                    this.add(dynamicValue);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Element element) {
        this.lock();
        try {
            S timeSet = this.getTimeSet(element);
            if (timeSet != null) {
                this.remove(timeSet, element);
            }
            Element element2 = element;
            synchronized (element2) {
                for (Object val : element.getAttributes()) {
                    if (!(val instanceof TimeMap)) continue;
                    TimeMap dynamicValue = (TimeMap)val;
                    this.remove((M)dynamicValue);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            this.timeSortedMap.clear();
            this.garbageQueue.clear();
            this.countMap = new int[0];
            this.length = 0;
            if (this.mainIndex != null) {
                this.mainIndex.clear();
                if (!this.viewIndexes.isEmpty()) {
                    for (TimeIndexImpl index : this.viewIndexes.values()) {
                        index.clear();
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public int size() {
        return this.timeSortedMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeIndex getIndex(Graph graph) {
        GraphView view = graph.getView();
        if (view.isMainView()) {
            return this.mainIndex;
        }
        this.lock();
        try {
            TimeIndexImpl viewIndex = this.viewIndexes.get(graph.getView());
            if (viewIndex == null) {
                viewIndex = this.createViewIndex(graph);
            }
            TimeIndexImpl timeIndexImpl = viewIndex;
            return timeIndexImpl;
        }
        finally {
            this.unlock();
        }
    }

    protected TimeIndexImpl createViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't create a view index for the main view");
        }
        TimeIndexImpl viewIndex = this.createIndex(false);
        this.viewIndexes.put(graph.getView(), viewIndex);
        this.indexView(graph);
        return viewIndex;
    }

    public void deleteViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't delete a view index for the main view");
        }
        this.lock();
        try {
            TimeIndexImpl index = this.viewIndexes.remove(graph.getView());
            if (index != null) {
                index.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexView(Graph graph) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(graph.getView());
        if (viewIndex != null) {
            graph.readLock();
            this.lock();
            try {
                Iterator<Element> iterator = null;
                if (this.elementType.equals(Node.class)) {
                    iterator = graph.getNodes().iterator();
                } else if (this.elementType.equals(Edge.class)) {
                    iterator = graph.getEdges().iterator();
                }
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Element element = iterator.next();
                        S set = this.getTimeSet(element);
                        if (set == null) continue;
                        K[] ts = set.toArray();
                        int tsLength = ts.length;
                        for (int i = 0; i < tsLength; ++i) {
                            int timestamp = this.timeSortedMap.get(ts[i]);
                            viewIndex.add(timestamp, element);
                        }
                    }
                }
            }
            finally {
                graph.readUnlock();
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInView(T element, GraphView view) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null) {
            this.lock();
            try {
                S set = this.getTimeSet((Element)element);
                if (set != null) {
                    K[] ts = set.toArray();
                    int tsLength = ts.length;
                    for (int i = 0; i < tsLength; ++i) {
                        int timestampIndex = this.timeSortedMap.get(ts[i]);
                        viewIndex.add(timestampIndex, (Element)element);
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInView(T element, GraphView view) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null) {
            this.lock();
            try {
                S set = this.getTimeSet((Element)element);
                if (set != null) {
                    K[] ts = set.toArray();
                    int tsLength = ts.length;
                    for (int i = 0; i < tsLength; ++i) {
                        int timestampIndex = this.timeSortedMap.get(ts[i]);
                        viewIndex.remove(timestampIndex, (Element)element);
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    public void clear(GraphView view) {
        TimeIndexImpl viewIndex = this.viewIndexes.get(view);
        if (viewIndex != null) {
            viewIndex.clear();
        }
    }

    public boolean hasIndex() {
        return this.mainIndex != null;
    }

    private S getTimeSet(Element element) {
        Object[] attributes = element.getAttributes();
        if (2 < attributes.length) {
            return (S)((TimeSet)attributes[2]);
        }
        return null;
    }

    private void checkTimeIndex(Integer timeIndex) {
        if (timeIndex == null) {
            throw new IllegalArgumentException("Unknown time index");
        }
    }

    protected void ensureArraySize(int index) {
        if (index >= this.countMap.length) {
            int newSize = Math.min(Math.max(index + 1, (int)((double)index * 1.1)), Integer.MAX_VALUE);
            int[] newArray = new int[newSize];
            System.arraycopy(this.countMap, 0, newArray, 0, this.countMap.length);
            this.countMap = newArray;
        }
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 29 * hash + this.elementType.hashCode();
        for (Map.Entry<K, Integer> entry : this.timeSortedMap.entrySet()) {
            hash = 29 * hash + entry.getKey().hashCode();
            hash = 29 * hash + entry.getValue().hashCode();
            hash = 29 * hash + this.countMap[entry.getValue()];
        }
        return hash;
    }

    public boolean deepEquals(TimeIndexStore obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TimeIndexStore other = obj;
        if (!other.elementType.equals(this.elementType)) {
            return false;
        }
        if (!MapDeepEquals.mapDeepEquals(this.timeSortedMap, other.timeSortedMap)) {
            return false;
        }
        int[] otherCountMap = other.countMap;
        for (Integer k : this.timeSortedMap.values()) {
            if (otherCountMap[k] == this.countMap[k]) continue;
            return false;
        }
        return true;
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

