/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.plugin.attribute.ListContainsUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ListAttributeContainsBuilder
implements CategoryBuilder {
    private static final Category CONTAINS = new Category(NbBundle.getMessage(ListAttributeContainsBuilder.class, (String)"AttributeContainsBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return CONTAINS;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        AttributeContainsFilterBuilder b;
        ArrayList<AttributeContainsFilterBuilder> builders = new ArrayList<AttributeContainsFilterBuilder>();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        for (Column col : am.getNodeTable()) {
            if (!col.isArray()) continue;
            b = new AttributeContainsFilterBuilder(col);
            builders.add(b);
        }
        for (Column col : am.getEdgeTable()) {
            if (!col.isArray()) continue;
            b = new AttributeContainsFilterBuilder(col);
            builders.add(b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class AttributeContainsFilter<K extends Element>
    extends AbstractAttributeFilter<K> {
        private Object match;

        public AttributeContainsFilter(Column column) {
            super(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeContainsBuilder.name"), column);
            this.addProperty(Object.class, "match");
        }

        public boolean init(Graph graph) {
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                return graph.getNodeCount() != 0;
            }
            if (AttributeUtils.isEdgeColumn((Column)this.column)) {
                return graph.getEdgeCount() != 0;
            }
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            Object array;
            if (this.match != null && (array = element.getAttribute(this.column)) != null) {
                int length = Array.getLength(array);
                Class<?> componentType = array.getClass().getComponentType();
                Class<?> matchType = this.match.getClass();
                boolean sameType = componentType.equals(matchType);
                for (int i = 0; i < length; ++i) {
                    Object val = Array.get(array, i);
                    if (!(sameType ? val.equals(this.match) : val.equals(AttributeUtils.parse((String)this.match.toString(), componentType)))) continue;
                    return true;
                }
            }
            return false;
        }

        public void finish() {
        }

        public void setMatch(Object match) {
            this.match = match;
        }

        public Object getMatch() {
            return this.match;
        }

        public static class Edge
        extends AttributeContainsFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends AttributeContainsFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }

    public static class AttributeContainsFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public AttributeContainsFilterBuilder(Column column) {
            super(column, CONTAINS, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeContainsBuilder.description"), null);
        }

        public AttributeContainsFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new AttributeContainsFilter.Node(this.column) : new AttributeContainsFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            return ((ListContainsUI)Lookup.getDefault().lookup(ListContainsUI.class)).getPanel((AttributeContainsFilter)filter);
        }
    }
}

