#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSColor = 913,
  CSSColorValue = 922,
  CSSConditionRule = 936,
  CSSContainerRule = 953,
  CSSCounterStyleRule = 970,
  CSSCustomPropertyRegisteredEvent = 990,
  CSSFontFaceRule = 1023,
  CSSFontFeatureValuesRule = 1039,
  CSSFontPaletteValuesRule = 1064,
  CSSGroupingRule = 1089,
  CSSHSL = 1105,
  CSSHWB = 1112,
  CSSImageValue = 1119,
  CSSImportRule = 1133,
  CSSKeyframeRule = 1147,
  CSSKeyframesRule = 1163,
  CSSKeywordValue = 1180,
  CSSLCH = 1196,
  CSSLab = 1203,
  CSSLayerBlockRule = 1210,
  CSSLayerStatementRule = 1228,
  CSSMarginRule = 1250,
  CSSMathClamp = 1264,
  CSSMathInvert = 1277,
  CSSMathMax = 1291,
  CSSMathMin = 1302,
  CSSMathNegate = 1313,
  CSSMathProduct = 1327,
  CSSMathSum = 1342,
  CSSMathValue = 1353,
  CSSMatrixComponent = 1366,
  CSSMediaRule = 1385,
  CSSMozDocumentRule = 1398,
  CSSNamespaceRule = 1417,
  CSSNestedDeclarations = 1434,
  CSSNumericArray = 1456,
  CSSNumericValue = 1472,
  CSSOKLCH = 1488,
  CSSOKLab = 1497,
  CSSPageDescriptors = 1506,
  CSSPageRule = 1525,
  CSSPerspective = 1537,
  CSSPositionTryDescriptors = 1552,
  CSSPositionTryRule = 1578,
  CSSPropertyRule = 1597,
  CSSPseudoElement = 1613,
  CSSRGB = 1630,
  CSSRotate = 1637,
  CSSRule = 1647,
  CSSRuleList = 1655,
  CSSScale = 1667,
  CSSScopeRule = 1676,
  CSSSkew = 1689,
  CSSSkewX = 1697,
  CSSSkewY = 1706,
  CSSStartingStyleRule = 1715,
  CSSStyleDeclaration = 1736,
  CSSStyleRule = 1756,
  CSSStyleSheet = 1769,
  CSSStyleValue = 1783,
  CSSSupportsRule = 1797,
  CSSTransformComponent = 1813,
  CSSTransformValue = 1835,
  CSSTransition = 1853,
  CSSTranslate = 1867,
  CSSUnitValue = 1880,
  CSSUnparsedValue = 1893,
  CSSVariableReferenceValue = 1910,
  Cache = 1936,
  CacheStorage = 1942,
  CallbackDebuggerNotification = 1955,
  CanonicalBrowsingContext = 1984,
  CanvasCaptureMediaStream = 2009,
  CanvasGradient = 2034,
  CanvasPattern = 2049,
  CanvasRenderingContext2D = 2063,
  CaretPosition = 2088,
  CaretStateChangedEvent = 2102,
  ChannelMergerNode = 2125,
  ChannelSplitterNode = 2143,
  ChannelWrapper = 2163,
  CharacterData = 2178,
  CheckerboardReportService = 2192,
  ChildProcessMessageManager = 2218,
  ChildSHistory = 2245,
  ChromeMessageBroadcaster = 2259,
  ChromeMessageSender = 2284,
  ChromeNodeList = 2304,
  ChromeUtils = 2319,
  ChromeWorker = 2331,
  Client = 2344,
  Clients = 2351,
  Clipboard = 2359,
  ClipboardEvent = 2369,
  ClipboardItem = 2384,
  ClonedErrorHolder = 2398,
  CloseEvent = 2416,
  CloseWatcher = 2427,
  CommandEvent = 2440,
  Comment = 2453,
  CompositionEvent = 2461,
  CompressionStream = 2478,
  ConsoleInstance = 2496,
  ConstantSourceNode = 2512,
  ContentFrameMessageManager = 2531,
  ContentProcessMessageManager = 2558,
  ContentVisibilityAutoStateChangeEvent = 2587,
  ConvolverNode = 2625,
  CookieChangeEvent = 2639,
  CookieStore = 2657,
  CookieStoreManager = 2669,
  CountQueuingStrategy = 2688,
  CreateOfferRequest = 2709,
  Credential = 2728,
  CredentialsContainer = 2739,
  Crypto = 2760,
  CryptoKey = 2767,
  CustomElementRegistry = 2777,
  CustomEvent = 2799,
  CustomStateSet = 2811,
  DOMException = 2826,
  DOMImplementation = 2839,
  DOMLocalization = 2857,
  DOMMatrix = 2873,
  DOMMatrixReadOnly = 2883,
  DOMParser = 2901,
  DOMPoint = 2911,
  DOMPointReadOnly = 2920,
  DOMQuad = 2937,
  DOMRect = 2945,
  DOMRectList = 2953,
  DOMRectReadOnly = 2965,
  DOMStringList = 2981,
  DOMStringMap = 2995,
  DOMTokenList = 3008,
  DataTransfer = 3021,
  DataTransferItem = 3034,
  DataTransferItemList = 3051,
  DebuggerNotification = 3072,
  DebuggerNotificationObserver = 3093,
  DecompressionStream = 3122,
  DedicatedWorkerGlobalScope = 3142,
  DelayNode = 3169,
  DeprecationReportBody = 3179,
  DeviceAcceleration = 3201,
  DeviceLightEvent = 3220,
  DeviceMotionEvent = 3237,
  DeviceOrientationEvent = 3255,
  DeviceRotationRate = 3278,
  Directory = 3297,
  Document = 3307,
  DocumentFragment = 3316,
  DocumentL10n = 3333,
  DocumentTimeline = 3346,
  DocumentType = 3363,
  DominatorTree = 3376,
  DragEvent = 3390,
  DynamicsCompressorNode = 3400,
  EXT_blend_minmax = 3423,
  EXT_color_buffer_float = 3440,
  EXT_color_buffer_half_float = 3463,
  EXT_depth_clamp = 3491,
  EXT_disjoint_timer_query = 3507,
  EXT_float_blend = 3532,
  EXT_frag_depth = 3548,
  EXT_sRGB = 3563,
  EXT_shader_texture_lod = 3572,
  EXT_texture_compression_bptc = 3595,
  EXT_texture_compression_rgtc = 3624,
  EXT_texture_filter_anisotropic = 3653,
  EXT_texture_norm16 = 3684,
  Element = 3703,
  ElementInternals = 3711,
  EncodedAudioChunk = 3728,
  EncodedVideoChunk = 3746,
  ErrorEvent = 3764,
  Event = 3775,
  EventCallbackDebuggerNotification = 3781,
  EventCounts = 3815,
  EventSource = 3827,
  EventTarget = 3839,
  Exception = 3851,
  ExtendableCookieChangeEvent = 3861,
  ExtendableEvent = 3889,
  ExtendableMessageEvent = 3905,
  ExtensionAlarms = 3928,
  ExtensionBrowser = 3944,
  ExtensionBrowserSettings = 3961,
  ExtensionBrowserSettingsColorManagement = 3986,
  ExtensionDns = 4026,
  ExtensionEventManager = 4039,
  ExtensionMockAPI = 4061,
  ExtensionPort = 4078,
  ExtensionProxy = 4092,
  ExtensionRuntime = 4107,
  ExtensionScripting = 4124,
  ExtensionSetting = 4143,
  ExtensionTest = 4160,
  External = 4174,
  FeaturePolicy = 4183,
  FeaturePolicyViolationReportBody = 4197,
  FetchEvent = 4230,
  FetchObserver = 4241,
  File = 4255,
  FileList = 4260,
  FileReader = 4269,
  FileReaderSync = 4280,
  FileSystem = 4295,
  FileSystemDirectoryEntry = 4306,
  FileSystemDirectoryHandle = 4331,
  FileSystemDirectoryHandle_AsyncIterator = 4357,
  FileSystemDirectoryIterator = 4397,
  FileSystemDirectoryReader = 4425,
  FileSystemEntry = 4451,
  FileSystemFileEntry = 4467,
  FileSystemFileHandle = 4487,
  FileSystemHandle = 4508,
  FileSystemSyncAccessHandle = 4525,
  FileSystemWritableFileStream = 4552,
  Flex = 4581,
  FlexItemValues = 4586,
  FlexLineValues = 4601,
  FluentBundle = 4616,
  FluentBundleAsyncIterator = 4629,
  FluentBundleIterator = 4655,
  FluentPattern = 4676,
  FluentResource = 4690,
  FocusEvent = 4705,
  FontFace = 4716,
  FontFaceSet = 4725,
  FontFaceSetIterator = 4737,
  FontFaceSetLoadEvent = 4757,
  FormData = 4778,
  FormData_Iterator = 4787,
  FormDataEvent = 4805,
  FragmentDirective = 4819,
  FrameCrashedEvent = 4837,
  FrameLoader = 4855,
  GPU = 4867,
  GPUAdapter = 4871,
  GPUAdapterInfo = 4882,
  GPUBindGroup = 4897,
  GPUBindGroupLayout = 4910,
  GPUBuffer = 4929,
  GPUBufferUsage = 4939,
  GPUCanvasContext = 4954,
  GPUColorWrite = 4971,
  GPUCommandBuffer = 4985,
  GPUCommandEncoder = 5002,
  GPUCompilationInfo = 5020,
  GPUCompilationMessage = 5039,
  GPUComputePassEncoder = 5061,
  GPUComputePipeline = 5083,
  GPUDevice = 5102,
  GPUDeviceLostInfo = 5112,
  GPUError = 5130,
  GPUExternalTexture = 5139,
  GPUInternalError = 5158,
  GPUMapMode = 5175,
  GPUOutOfMemoryError = 5186,
  GPUPipelineError = 5206,
  GPUPipelineLayout = 5223,
  GPUQuerySet = 5241,
  GPUQueue = 5253,
  GPURenderBundle = 5262,
  GPURenderBundleEncoder = 5278,
  GPURenderPassEncoder = 5301,
  GPURenderPipeline = 5322,
  GPUSampler = 5340,
  GPUShaderModule = 5351,
  GPUShaderStage = 5367,
  GPUSupportedFeatures = 5382,
  GPUSupportedLimits = 5403,
  GPUTexture = 5422,
  GPUTextureUsage = 5433,
  GPUTextureView = 5449,
  GPUUncapturedErrorEvent = 5464,
  GPUValidationError = 5488,
  GainNode = 5507,
  Gamepad = 5516,
  GamepadAxisMoveEvent = 5524,
  GamepadButton = 5545,
  GamepadButtonEvent = 5559,
  GamepadEvent = 5578,
  GamepadHapticActuator = 5591,
  GamepadLightIndicator = 5613,
  GamepadPose = 5635,
  GamepadServiceTest = 5647,
  GamepadTouch = 5666,
  Geolocation = 5679,
  GeolocationCoordinates = 5691,
  GeolocationPosition = 5714,
  GeolocationPositionError = 5734,
  GetUserMediaRequest = 5759,
  GleanBoolean = 5779,
  GleanCategory = 5792,
  GleanCounter = 5806,
  GleanCustomDistribution = 5819,
  GleanDatetime = 5843,
  GleanDenominator = 5857,
  GleanDualLabeledCounter = 5874,
  GleanEvent = 5898,
  GleanImpl = 5909,
  GleanLabeled = 5919,
  GleanMemoryDistribution = 5932,
  GleanMetric = 5956,
  GleanNumerator = 5968,
  GleanObject = 5983,
  GleanPingsImpl = 5995,
  GleanQuantity = 6010,
  GleanRate = 6024,
  GleanString = 6034,
  GleanStringList = 6046,
  GleanText = 6062,
  GleanTimespan = 6072,
  GleanTimingDistribution = 6086,
  GleanUrl = 6110,
  GleanUuid = 6119,
  Grid = 6129,
  GridArea = 6134,
  GridDimension = 6143,
  GridLine = 6157,
  GridLines = 6166,
  GridTrack = 6176,
  GridTracks = 6186,
  HTMLAllCollection = 6197,
  HTMLAnchorElement = 6215,
  HTMLAreaElement = 6233,
  HTMLAudioElement = 6249,
  HTMLBRElement = 6266,
  HTMLBaseElement = 6280,
  HTMLBodyElement = 6296,
  HTMLButtonElement = 6312,
  HTMLCanvasElement = 6330,
  HTMLCollection = 6348,
  HTMLDListElement = 6363,
  HTMLDataElement = 6380,
  HTMLDataListElement = 6396,
  HTMLDetailsElement = 6416,
  HTMLDialogElement = 6435,
  HTMLDirectoryElement = 6453,
  HTMLDivElement = 6474,
  HTMLDocument = 6489,
  HTMLElement = 6502,
  HTMLEmbedElement = 6514,
  HTMLFieldSetElement = 6531,
  HTMLFontElement = 6551,
  HTMLFormControlsCollection = 6567,
  HTMLFormElement = 6594,
  HTMLFrameElement = 6610,
  HTMLFrameSetElement = 6627,
  HTMLHRElement = 6647,
  HTMLHeadElement = 6661,
  HTMLHeadingElement = 6677,
  HTMLHtmlElement = 6696,
  HTMLIFrameElement = 6712,
  HTMLImageElement = 6730,
  HTMLInputElement = 6747,
  HTMLLIElement = 6764,
  HTMLLabelElement = 6778,
  HTMLLegendElement = 6795,
  HTMLLinkElement = 6813,
  HTMLMapElement = 6829,
  HTMLMarqueeElement = 6844,
  HTMLMediaElement = 6863,
  HTMLMenuElement = 6880,
  HTMLMetaElement = 6896,
  HTMLMeterElement = 6912,
  HTMLModElement = 6929,
  HTMLOListElement = 6944,
  HTMLObjectElement = 6961,
  HTMLOptGroupElement = 6979,
  HTMLOptionElement = 6999,
  HTMLOptionsCollection = 7017,
  HTMLOutputElement = 7039,
  HTMLParagraphElement = 7057,
  HTMLParamElement = 7078,
  HTMLPictureElement = 7095,
  HTMLPreElement = 7114,
  HTMLProgressElement = 7129,
  HTMLQuoteElement = 7149,
  HTMLScriptElement = 7166,
  HTMLSelectElement = 7184,
  HTMLSlotElement = 7202,
  HTMLSourceElement = 7218,
  HTMLSpanElement = 7236,
  HTMLStyleElement = 7252,
  HTMLTableCaptionElement = 7269,
  HTMLTableCellElement = 7293,
  HTMLTableColElement = 7314,
  HTMLTableElement = 7334,
  HTMLTableRowElement = 7351,
  HTMLTableSectionElement = 7371,
  HTMLTemplateElement = 7395,
  HTMLTextAreaElement = 7415,
  HTMLTimeElement = 7435,
  HTMLTitleElement = 7451,
  HTMLTrackElement = 7468,
  HTMLUListElement = 7485,
  HTMLUnknownElement = 7502,
  HTMLVideoElement = 7521,
  HashChangeEvent = 7538,
  Headers = 7554,
  Headers_Iterator = 7562,
  HeapSnapshot = 7579,
  Highlight = 7592,
  HighlightRegistry = 7602,
  History = 7620,
  IDBCursor = 7628,
  IDBCursorWithValue = 7638,
  IDBDatabase = 7657,
  IDBFactory = 7669,
  IDBIndex = 7680,
  IDBKeyRange = 7689,
  IDBObjectStore = 7701,
  IDBOpenDBRequest = 7716,
  IDBRequest = 7733,
  IDBTransaction = 7744,
  IDBVersionChangeEvent = 7759,
  IIRFilterNode = 7781,
  IOUtils = 7795,
  IdentityCredential = 7803,
  IdentityProvider = 7822,
  IdleDeadline = 7839,
  Image = 7852,
  ImageBitmap = 7858,
  ImageBitmapRenderingContext = 7870,
  ImageCapture = 7898,
  ImageCaptureError = 7911,
  ImageCaptureErrorEvent = 7929,
  ImageData = 7952,
  ImageDecoder = 7962,
  ImageDocument = 7975,
  ImageTrack = 7989,
  ImageTrackList = 8000,
  InferenceSession = 8015,
  InputEvent = 8032,
  InspectorCSSParser = 8043,
  InspectorFontFace = 8062,
  InspectorUtils = 8080,
  InstallTriggerImpl = 8095,
  IntersectionObserver = 8114,
  IntersectionObserverEntry = 8135,
  IntlUtils = 8161,
  JSProcessActorChild = 8171,
  JSProcessActorParent = 8191,
  JSWindowActorChild = 8212,
  JSWindowActorParent = 8231,
  KeyEvent = 8251,
  KeyboardEvent = 8260,
  KeyframeEffect = 8274,
  L10nFileSource = 8289,
  L10nOverlays = 8304,
  L10nRegistry = 8317,
  LargestContentfulPaint = 8330,
  LegacyMozTCPSocket = 8353,
  Localization = 8372,
  Location = 8385,
  Lock = 8394,
  LockManager = 8399,
  MIDIAccess = 8411,
  MIDIConnectionEvent = 8422,
  MIDIInput = 8442,
  MIDIInputMap = 8452,
  MIDIMessageEvent = 8465,
  MIDIOutput = 8482,
  MIDIOutputMap = 8493,
  MIDIPort = 8507,
  MLS = 8516,
  MLSGroupView = 8520,
  MOZ_debug = 8533,
  MatchGlob = 8543,
  MatchPattern = 8553,
  MatchPatternSet = 8566,
  MathMLElement = 8582,
  MediaCapabilities = 8596,
  MediaControlService = 8614,
  MediaController = 8634,
  MediaDeviceInfo = 8650,
  MediaDevices = 8666,
  MediaElementAudioSourceNode = 8679,
  MediaEncryptedEvent = 8707,
  MediaError = 8727,
  MediaKeyError = 8738,
  MediaKeyMessageEvent = 8752,
  MediaKeySession = 8773,
  MediaKeyStatusMap = 8789,
  MediaKeyStatusMap_Iterator = 8807,
  MediaKeySystemAccess = 8834,
  MediaKeys = 8855,
  MediaList = 8865,
  MediaMetadata = 8875,
  MediaQueryList = 8889,
  MediaQueryListEvent = 8904,
  MediaRecorder = 8924,
  MediaRecorderErrorEvent = 8938,
  MediaSession = 8962,
  MediaSource = 8975,
  MediaStream = 8987,
  MediaStreamAudioDestinationNode = 8999,
  MediaStreamAudioSourceNode = 9031,
  MediaStreamError = 9058,
  MediaStreamEvent = 9075,
  MediaStreamTrack = 9092,
  MediaStreamTrackAudioSourceNode = 9109,
  MediaStreamTrackEvent = 9141,
  MerchantValidationEvent = 9163,
  MessageBroadcaster = 9187,
  MessageChannel = 9206,
  MessageEvent = 9221,
  MessageListenerManager = 9234,
  MessagePort = 9257,
  MessageSender = 9269,
  MimeType = 9283,
  MimeTypeArray = 9292,
  MouseEvent = 9306,
  MouseScrollEvent = 9317,
  MozCanvasPrintState = 9334,
  MozDocumentMatcher = 9354,
  MozDocumentObserver = 9373,
  MozQueryInterface = 9393,
  MozSharedMap = 9411,
  MozSharedMap_Iterator = 9424,
  MozSharedMapChangeEvent = 9446,
  MozStorageAsyncStatementParams = 9470,
  MozStorageStatementParams = 9501,
  MozStorageStatementRow = 9527,
  MozWritableSharedMap = 9550,
  MutationEvent = 9571,
  MutationObserver = 9585,
  MutationRecord = 9602,
  NamedNodeMap = 9617,
  NavigateEvent = 9630,
  Navigation = 9644,
  NavigationActivation = 9655,
  NavigationCurrentEntryChangeEvent = 9676,
  NavigationDestination = 9710,
  NavigationHistoryEntry = 9732,
  NavigationPreloadManager = 9755,
  NavigationTransition = 9780,
  Navigator = 9801,
  NavigatorLogin = 9811,
  NetworkInformation = 9826,
  Node = 9845,
  NodeFilter = 9850,
  NodeIterator = 9861,
  NodeList = 9874,
  Notification = 9883,
  NotificationEvent = 9896,
  NotifyPaintEvent = 9914,
  OES_draw_buffers_indexed = 9931,
  OES_element_index_uint = 9956,
  OES_fbo_render_mipmap = 9979,
  OES_standard_derivatives = 10001,
  OES_texture_float = 10026,
  OES_texture_float_linear = 10044,
  OES_texture_half_float = 10069,
  OES_texture_half_float_linear = 10092,
  OES_vertex_array_object = 10122,
  OVR_multiview2 = 10146,
  OfflineAudioCompletionEvent = 10161,
  OfflineAudioContext = 10189,
  OffscreenCanvas = 10209,
  OffscreenCanvasRenderingContext2D = 10225,
  Option = 10259,
  OscillatorNode = 10266,
  PageTransitionEvent = 10281,
  PaintRequest = 10301,
  PaintRequestList = 10314,
  PaintWorkletGlobalScope = 10331,
  PannerNode = 10355,
  ParentProcessMessageManager = 10366,
  Path2D = 10394,
  PathUtils = 10401,
  PaymentAddress = 10411,
  PaymentMethodChangeEvent = 10426,
  PaymentRequest = 10451,
  PaymentRequestUpdateEvent = 10466,
  PaymentResponse = 10492,
  PeerConnectionImpl = 10508,
  PeerConnectionObserver = 10527,
  Performance = 10550,
  PerformanceEntry = 10562,
  PerformanceEntryEvent = 10579,
  PerformanceEventTiming = 10601,
  PerformanceMark = 10624,
  PerformanceMeasure = 10640,
  PerformanceNavigation = 10659,
  PerformanceNavigationTiming = 10681,
  PerformanceObserver = 10709,
  PerformanceObserverEntryList = 10729,
  PerformancePaintTiming = 10758,
  PerformanceResourceTiming = 10781,
  PerformanceServerTiming = 10807,
  PerformanceTiming = 10831,
  PeriodicWave = 10849,
  PermissionStatus = 10862,
  Permissions = 10879,
  PlacesBookmark = 10891,
  PlacesBookmarkAddition = 10906,
  PlacesBookmarkChanged = 10929,
  PlacesBookmarkGuid = 10951,
  PlacesBookmarkKeyword = 10970,
  PlacesBookmarkMoved = 10992,
  PlacesBookmarkRemoved = 11012,
  PlacesBookmarkTags = 11034,
  PlacesBookmarkTime = 11053,
  PlacesBookmarkTitle = 11072,
  PlacesBookmarkUrl = 11092,
  PlacesEvent = 11110,
  PlacesEventCounts = 11122,
  PlacesFavicon = 11140,
  PlacesHistoryCleared = 11154,
  PlacesObservers = 11175,
  PlacesPurgeCaches = 11191,
  PlacesRanking = 11209,
  PlacesVisit = 11223,
  PlacesVisitRemoved = 11235,
  PlacesVisitTitle = 11254,
  PlacesWeakCallbackWrapper = 11271,
  Plugin = 11297,
  PluginArray = 11304,
  PluginCrashedEvent = 11316,
  PointerEvent = 11335,
  PopStateEvent = 11348,
  PopupBlockedEvent = 11362,
  PopupPositionedEvent = 11380,
  PositionStateEvent = 11401,
  PrecompiledScript = 11420,
  PrivateAttribution = 11438,
  ProcessMessageManager = 11457,
  ProcessingInstruction = 11479,
  ProgressEvent = 11501,
  PromiseDebugging = 11515,
  PromiseNativeHandler = 11532,
  PromiseRejectionEvent = 11553,
  PublicKeyCredential = 11575,
  PushEvent = 11595,
  PushManager = 11605,
  PushManagerImpl = 11617,
  PushMessageData = 11633,
  PushSubscription = 11649,
  PushSubscriptionChangeEvent = 11666,
  PushSubscriptionOptions = 11694,
  RTCCertificate = 11718,
  RTCDTMFSender = 11733,
  RTCDTMFToneChangeEvent = 11747,
  RTCDataChannel = 11770,
  RTCDataChannelEvent = 11785,
  RTCDtlsTransport = 11805,
  RTCEncodedAudioFrame = 11822,
  RTCEncodedVideoFrame = 11843,
  RTCIceCandidate = 11864,
  RTCIceTransport = 11880,
  RTCIdentityProviderRegistrar = 11896,
  RTCPeerConnection = 11925,
  RTCPeerConnectionIceEvent = 11943,
  RTCPeerConnectionStatic = 11969,
  RTCRtpReceiver = 11993,
  RTCRtpScriptTransform = 12008,
  RTCRtpScriptTransformer = 12030,
  RTCRtpSender = 12054,
  RTCRtpTransceiver = 12067,
  RTCSctpTransport = 12085,
  RTCSessionDescription = 12102,
  RTCStatsReport = 12124,
  RTCTrackEvent = 12139,
  RTCTransformEvent = 12153,
  RadioNodeList = 12171,
  Range = 12185,
  ReadableByteStreamController = 12191,
  ReadableStream = 12220,
  ReadableStream_AsyncIterator = 12235,
  ReadableStreamBYOBReader = 12264,
  ReadableStreamBYOBRequest = 12289,
  ReadableStreamDefaultController = 12315,
  ReadableStreamDefaultReader = 12347,
  Report = 12375,
  ReportBody = 12382,
  ReportingObserver = 12393,
  Request = 12411,
  ResizeObserver = 12419,
  ResizeObserverEntry = 12434,
  ResizeObserverSize = 12454,
  Response = 12473,
  SVGAElement = 12482,
  SVGAngle = 12494,
  SVGAnimateElement = 12503,
  SVGAnimateMotionElement = 12521,
  SVGAnimateTransformElement = 12545,
  SVGAnimatedAngle = 12572,
  SVGAnimatedBoolean = 12589,
  SVGAnimatedEnumeration = 12608,
  SVGAnimatedInteger = 12631,
  SVGAnimatedLength = 12650,
  SVGAnimatedLengthList = 12668,
  SVGAnimatedNumber = 12690,
  SVGAnimatedNumberList = 12708,
  SVGAnimatedPreserveAspectRatio = 12730,
  SVGAnimatedRect = 12761,
  SVGAnimatedString = 12777,
  SVGAnimatedTransformList = 12795,
  SVGAnimationElement = 12820,
  SVGCircleElement = 12840,
  SVGClipPathElement = 12857,
  SVGComponentTransferFunctionElement = 12876,
  SVGDefsElement = 12912,
  SVGDescElement = 12927,
  SVGElement = 12942,
  SVGEllipseElement = 12953,
  SVGFEBlendElement = 12971,
  SVGFEColorMatrixElement = 12989,
  SVGFEComponentTransferElement = 13013,
  SVGFECompositeElement = 13043,
  SVGFEConvolveMatrixElement = 13065,
  SVGFEDiffuseLightingElement = 13092,
  SVGFEDisplacementMapElement = 13120,
  SVGFEDistantLightElement = 13148,
  SVGFEDropShadowElement = 13173,
  SVGFEFloodElement = 13196,
  SVGFEFuncAElement = 13214,
  SVGFEFuncBElement = 13232,
  SVGFEFuncGElement = 13250,
  SVGFEFuncRElement = 13268,
  SVGFEGaussianBlurElement = 13286,
  SVGFEImageElement = 13311,
  SVGFEMergeElement = 13329,
  SVGFEMergeNodeElement = 13347,
  SVGFEMorphologyElement = 13369,
  SVGFEOffsetElement = 13392,
  SVGFEPointLightElement = 13411,
  SVGFESpecularLightingElement = 13434,
  SVGFESpotLightElement = 13463,
  SVGFETileElement = 13485,
  SVGFETurbulenceElement = 13502,
  SVGFilterElement = 13525,
  SVGForeignObjectElement = 13542,
  SVGGElement = 13566,
  SVGGeometryElement = 13578,
  SVGGradientElement = 13597,
  SVGGraphicsElement = 13616,
  SVGImageElement = 13635,
  SVGLength = 13651,
  SVGLengthList = 13661,
  SVGLineElement = 13675,
  SVGLinearGradientElement = 13690,
  SVGMPathElement = 13715,
  SVGMarkerElement = 13731,
  SVGMaskElement = 13748,
  SVGMatrix = 13763,
  SVGMetadataElement = 13773,
  SVGNumber = 13792,
  SVGNumberList = 13802,
  SVGPathElement = 13816,
  SVGPathSegment = 13831,
  SVGPatternElement = 13846,
  SVGPoint = 13864,
  SVGPointList = 13873,
  SVGPolygonElement = 13886,
  SVGPolylineElement = 13904,
  SVGPreserveAspectRatio = 13923,
  SVGRadialGradientElement = 13946,
  SVGRect = 13971,
  SVGRectElement = 13979,
  SVGSVGElement = 13994,
  SVGScriptElement = 14008,
  SVGSetElement = 14025,
  SVGStopElement = 14039,
  SVGStringList = 14054,
  SVGStyleElement = 14068,
  SVGSwitchElement = 14084,
  SVGSymbolElement = 14101,
  SVGTSpanElement = 14118,
  SVGTextContentElement = 14134,
  SVGTextElement = 14156,
  SVGTextPathElement = 14171,
  SVGTextPositioningElement = 14190,
  SVGTitleElement = 14216,
  SVGTransform = 14232,
  SVGTransformList = 14245,
  SVGUnitTypes = 14262,
  SVGUseElement = 14275,
  SVGViewElement = 14289,
  Sanitizer = 14304,
  Scheduler = 14314,
  Screen = 14324,
  ScreenLuminance = 14331,
  ScreenOrientation = 14347,
  ScriptProcessorNode = 14365,
  ScrollAreaEvent = 14385,
  SecurityPolicyViolationEvent = 14401,
  Selection = 14430,
  ServiceWorker = 14440,
  ServiceWorkerContainer = 14454,
  ServiceWorkerGlobalScope = 14477,
  ServiceWorkerRegistration = 14502,
  SessionStoreFormData = 14528,
  SessionStoreScrollData = 14549,
  SessionStoreUtils = 14572,
  ShadowRealmGlobalScope = 14590,
  ShadowRoot = 14613,
  SharedWorker = 14624,
  SharedWorkerGlobalScope = 14637,
  SimpleGestureEvent = 14661,
  SourceBuffer = 14680,
  SourceBufferList = 14693,
  SpeechGrammar = 14710,
  SpeechGrammarList = 14724,
  SpeechRecognition = 14742,
  SpeechRecognitionAlternative = 14760,
  SpeechRecognitionError = 14789,
  SpeechRecognitionEvent = 14812,
  SpeechRecognitionResult = 14835,
  SpeechRecognitionResultList = 14859,
  SpeechSynthesis = 14887,
  SpeechSynthesisErrorEvent = 14903,
  SpeechSynthesisEvent = 14929,
  SpeechSynthesisUtterance = 14950,
  SpeechSynthesisVoice = 14975,
  StaticRange = 14996,
  StereoPannerNode = 15008,
  Storage = 15025,
  StorageEvent = 15033,
  StorageManager = 15046,
  StreamFilter = 15061,
  StreamFilterDataEvent = 15074,
  StructuredCloneHolder = 15096,
  StructuredCloneTester = 15118,
  StylePropertyMap = 15140,
  StylePropertyMapReadOnly = 15157,
  StylePropertyMapReadOnly_Iterator = 15182,
  StyleSheet = 15216,
  StyleSheetApplicableStateChangeEvent = 15227,
  StyleSheetList = 15264,
  StyleSheetRemovedEvent = 15279,
  SubmitEvent = 15302,
  SubtleCrypto = 15314,
  SyncMessageSender = 15327,
  SyncReadFile = 15345,
  TCPServerSocket = 15358,
  TCPServerSocketEvent = 15374,
  TCPSocket = 15395,
  TCPSocketErrorEvent = 15405,
  TCPSocketEvent = 15425,
  TaskController = 15440,
  TaskPriorityChangeEvent = 15455,
  TaskSignal = 15479,
  Tensor = 15490,
  TestUtils = 15497,
  TestingDeprecatedInterface = 15507,
  Text = 15534,
  TextClause = 15539,
  TextDecoder = 15550,
  TextDecoderStream = 15562,
  TextEncoder = 15580,
  TextEncoderStream = 15592,
  TextEvent = 15610,
  TextMetrics = 15620,
  TextTrack = 15632,
  TextTrackCue = 15642,
  TextTrackCueList = 15655,
  TextTrackList = 15672,
  TimeEvent = 15686,
  TimeRanges = 15696,
  ToggleEvent = 15707,
  Touch = 15719,
  TouchEvent = 15725,
  TouchList = 15736,
  TrackEvent = 15746,
  TransformStream = 15757,
  TransformStreamDefaultController = 15773,
  TransitionEvent = 15806,
  TreeColumn = 15822,
  TreeColumns = 15833,
  TreeContentView = 15845,
  TreeWalker = 15861,
  TrustedHTML = 15872,
  TrustedScript = 15884,
  TrustedScriptURL = 15898,
  TrustedTypePolicy = 15915,
  TrustedTypePolicyFactory = 15933,
  UDPMessageEvent = 15958,
  UDPSocket = 15974,
  UIEvent = 15984,
  URL = 15992,
  URLPattern = 15996,
  URLSearchParams = 16007,
  URLSearchParams_Iterator = 16023,
  UniFFIPointer = 16048,
  UniFFIScaffolding = 16062,
  UserActivation = 16080,
  UserInteraction = 16095,
  UserProximityEvent = 16111,
  VRDisplay = 16130,
  VRDisplayCapabilities = 16140,
  VRDisplayEvent = 16162,
  VREyeParameters = 16177,
  VRFieldOfView = 16193,
  VRFrameData = 16207,
  VRMockController = 16219,
  VRMockDisplay = 16236,
  VRPose = 16250,
  VRServiceTest = 16257,
  VRStageParameters = 16271,
  VTTCue = 16289,
  VTTRegion = 16296,
  ValidityState = 16306,
  VideoColorSpace = 16320,
  VideoDecoder = 16336,
  VideoEncoder = 16349,
  VideoFrame = 16362,
  VideoPlaybackQuality = 16373,
  VideoTrack = 16394,
  VideoTrackList = 16405,
  ViewTransition = 16420,
  VisualViewport = 16435,
  WEBGL_color_buffer_float = 16450,
  WEBGL_compressed_texture_astc = 16475,
  WEBGL_compressed_texture_etc = 16505,
  WEBGL_compressed_texture_etc1 = 16534,
  WEBGL_compressed_texture_pvrtc = 16564,
  WEBGL_compressed_texture_s3tc = 16595,
  WEBGL_compressed_texture_s3tc_srgb = 16625,
  WEBGL_debug_renderer_info = 16660,
  WEBGL_debug_shaders = 16686,
  WEBGL_depth_texture = 16706,
  WEBGL_draw_buffers = 16726,
  WEBGL_explicit_present = 16745,
  WEBGL_lose_context = 16768,
  WEBGL_provoking_vertex = 16787,
  WGSLLanguageFeatures = 16810,
  WakeLock = 16831,
  WakeLockSentinel = 16840,
  WaveShaperNode = 16857,
  WebExtensionContentScript = 16872,
  WebExtensionPolicy = 16898,
  WebGL2RenderingContext = 16917,
  WebGLActiveInfo = 16940,
  WebGLBuffer = 16956,
  WebGLContextEvent = 16968,
  WebGLFramebuffer = 16986,
  WebGLProgram = 17003,
  WebGLQuery = 17016,
  WebGLRenderbuffer = 17027,
  WebGLRenderingContext = 17045,
  WebGLSampler = 17067,
  WebGLShader = 17080,
  WebGLShaderPrecisionFormat = 17092,
  WebGLSync = 17119,
  WebGLTexture = 17129,
  WebGLTransformFeedback = 17142,
  WebGLUniformLocation = 17165,
  WebGLVertexArrayObject = 17186,
  WebKitCSSMatrix = 17209,
  WebSocket = 17225,
  WebTransport = 17235,
  WebTransportBidirectionalStream = 17248,
  WebTransportDatagramDuplexStream = 17280,
  WebTransportError = 17313,
  WebTransportReceiveStream = 17331,
  WebTransportSendStream = 17357,
  WebrtcGlobalInformation = 17380,
  WheelEvent = 17404,
  Window = 17415,
  WindowClient = 17422,
  WindowContext = 17435,
  WindowGlobalChild = 17449,
  WindowGlobalParent = 17467,
  WindowRoot = 17486,
  Worker = 17497,
  WorkerDebuggerGlobalScope = 17504,
  WorkerGlobalScope = 17530,
  WorkerLocation = 17548,
  WorkerNavigator = 17563,
  WorkerTestUtils = 17579,
  Worklet = 17595,
  WorkletGlobalScope = 17603,
  WritableStream = 17622,
  WritableStreamDefaultController = 17637,
  WritableStreamDefaultWriter = 17669,
  XMLDocument = 17697,
  XMLHttpRequest = 17709,
  XMLHttpRequestEventTarget = 17724,
  XMLHttpRequestUpload = 17750,
  XMLSerializer = 17771,
  XPathEvaluator = 17785,
  XPathExpression = 17800,
  XPathResult = 17816,
  XRBoundedReferenceSpace = 17828,
  XRFrame = 17852,
  XRInputSource = 17860,
  XRInputSourceArray = 17874,
  XRInputSourceEvent = 17893,
  XRInputSourcesChangeEvent = 17912,
  XRPose = 17938,
  XRReferenceSpace = 17945,
  XRReferenceSpaceEvent = 17962,
  XRRenderState = 17984,
  XRRigidTransform = 17998,
  XRSession = 18015,
  XRSessionEvent = 18025,
  XRSpace = 18040,
  XRSystem = 18048,
  XRView = 18057,
  XRViewerPose = 18064,
  XRViewport = 18077,
  XRWebGLLayer = 18088,
  XSLTProcessor = 18101,
  XULCommandEvent = 18115,
  XULElement = 18131,
  XULFrameElement = 18142,
  XULMenuElement = 18158,
  XULPopupElement = 18173,
  XULResizerElement = 18189,
  XULTextElement = 18207,
  XULTreeElement = 18222,
  console = 18237,
  webkitSpeechGrammar = 18245,
  webkitSpeechGrammarList = 18265,
  webkitSpeechRecognition = 18289,
  webkitURL = 18313,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
