/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ToggleEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "ToggleEvent.h"
#include "ToggleEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ToggleEvent.h"

namespace mozilla::dom {


ToggleEvent::ToggleEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ToggleEvent::~ToggleEvent()
{
}

ToggleEvent*
ToggleEvent::AsToggleEvent()
{
  return this;
}

JSObject*
ToggleEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ToggleEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ToggleEvent>
ToggleEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ToggleEventInit& aEventInitDict)
{
  RefPtr<ToggleEvent> e = new ToggleEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mOldState = aEventInitDict.mOldState;
  e->mNewState = aEventInitDict.mNewState;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<ToggleEvent>
ToggleEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ToggleEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
ToggleEvent::GetOldState(nsString& aRetVal) const
{
  aRetVal = mOldState;
}

void
ToggleEvent::GetNewState(nsString& aRetVal) const
{
  aRetVal = mNewState;
}


} // namespace mozilla::dom
