/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
#ifndef mozilla_glean_jog_ffi_generated_h
#define mozilla_glean_jog_ffi_generated_h


/* Generated with cbindgen:0.29.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsTArray.h"
#include "nsString.h"

namespace mozilla::glean::jog {

extern "C" {

/// Test-only method.
///
/// Registers a metric.
/// Doesn't check to see if it's been registered before.
/// Doesn't check that it would pass schema validation if it were a real metric.
///
/// `extra_args` is a JSON-encoded string in a form that serde can read into an ExtraMetricArgs.
///
/// No effort has been made to make this pleasant to use, since it's for
/// internal testing only (ie, the testing of JOG itself).
uint32_t jog_test_register_metric(const nsACString *metric_type,
                                  const nsACString *category,
                                  const nsACString *name,
                                  const nsTArray<nsCString> *send_in_pings,
                                  const nsACString *lifetime,
                                  bool disabled,
                                  const nsACString *extra_args);

/// Creates and registers a metric as specified,
/// making it and its APIs available on the JS Glean global.
///
/// Not necessary for most uses of FOG and Glean.
/// If you're not sure if you should call this,
/// err on the side of not calling it.
///
/// # Arguments
///
/// * `metric_type` - The type of metric (e.g., "counter", "string", etc.)
/// * `category` - The category/namespace for the metric
/// * `name` - The name of the metric
/// * `send_in_pings` - The pings this metric should be included in
/// * `lifetime` - The lifetime of the metric (e.g., "ping", "application", "user")
/// * `disabled` - Whether the metric is disabled
/// * `extra_args` - Optional JSON string with additional configuration
///
/// # Returns
///
/// NS_OK if the metric was registered successfully, or NS_ERROR_FAILURE if registration failed
nsresult jog_register_metric(const nsACString *metric_type,
                             const nsACString *category,
                             const nsACString *name,
                             const nsTArray<nsCString> *send_in_pings,
                             const nsACString *lifetime,
                             bool disabled,
                             const nsACString *extra_args);

/// Test-only method.
///
/// Registers a ping. Doesn't check to see if it's been registered before.
/// Doesn't check that it would pass schema validation if it were a real ping.
uint32_t jog_test_register_ping(const nsACString *name,
                                bool include_client_id,
                                bool send_if_empty,
                                bool precise_timestamps,
                                bool include_info_sections,
                                bool enabled,
                                const nsTArray<nsCString> *schedules_pings,
                                const nsTArray<nsCString> *reason_codes,
                                bool follows_collection_enabled,
                                const nsTArray<nsCString> *uploader_capabilities);

/// Creates and registers a ping as specified,
/// making it and its APIs available on the JS GleanPings global.
///
/// Not necessary for most uses of FOG and Glean.
/// If you're not sure if you should call this,
/// err on the side of not calling it.
///
/// # Arguments
///
/// * `name` - The name of the ping
/// * `include_client_id` - Whether the ping should include the client_id
/// * `send_if_empty` - Whether the ping should send even if empty
/// * `precise_timestamps` - Whether to use precise timestamps
/// * `include_info_sections` - Whether to include client_info and ping_info sections
/// * `enabled` - Whether the ping is enabled
/// * `schedules_pings` - Array of pings that this ping schedules
/// * `reason_codes` - Array of valid reason codes for this ping
/// * `follows_collection_enabled` - Whether this ping follows the collection enabled setting
/// * `uploader_capabilities` - Array of capabilities that the uploader must support to handle this ping
///
/// # Returns
///
/// NS_OK if the ping was registered successfully, or NS_ERROR_FAILURE if registration failed
nsresult jog_register_ping(const nsACString *name,
                           bool include_client_id,
                           bool send_if_empty,
                           bool precise_timestamps,
                           bool include_info_sections,
                           bool enabled,
                           const nsTArray<nsCString> *schedules_pings,
                           const nsTArray<nsCString> *reason_codes,
                           bool follows_collection_enabled,
                           const nsTArray<nsCString> *uploader_capabilities);

/// Test-only method.
///
/// Clears all runtime registration storage of registered metrics and pings.
///
/// **MUST BE* called from the main thread only.
void jog_test_clear_registered_metrics_and_pings();

/// Read the file at the provided location, interpret it as a jogfile,
/// and register those pings and metrics.
/// Returns true if we successfully parsed the jogfile. Does not mean
/// all or any metrics and pings successfully registered,
/// just that serde managed to deserialize it into metrics and pings and we tried to register them all.
bool jog_load_jogfile(const nsAString *jogfile_path);

}  // extern "C"

}  // namespace mozilla::glean::jog

#endif // mozilla_glean_jog_ffi_generated_h
