#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tree-diff
version:              0.2
visibility:           public
id:                   tree-diff-0.2-ANf8AHBr0tJ1tWiBQn7ips
key:                  tree-diff-0.2-ANf8AHBr0tJ1tWiBQn7ips
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  a7e45b2d5ff4f421028695e911d93fdb
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-8.10.5/site-local/tree-diff-0.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/tree-diff-0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/tree-diff-0.2
hs-libraries:         HStree-diff-0.2-ANf8AHBr0tJ1tWiBQn7ips
depends:
    QuickCheck-2.14.2-3M8ld1AYJUs5Ehp4oq5AMK
    aeson-1.5.6.0-Fw6cTmCp4oOK2plDv84u6I
    ansi-terminal-0.11-KZlfwqvn41oLlRmR1M9CEn
    ansi-wl-pprint-0.6.9-4Mzh6BhiCVpFwrCWKH3P3O base-4.14.2.0
    base-compat-0.11.2-Eyusxyk2CrTGloLdon9bIK bytestring-0.10.12.0
    containers-0.6.4.1 deepseq-1.4.4.0
    hashable-1.3.2.0-3hvuAxdSjzxDW0RNnAXdYP parsec-3.1.14.0
    parsers-0.12.10-6f5ds8FlomF25YpgHWE5tr pretty-1.1.3.6
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    scientific-0.3.7.0-VQu2zXXWCs7DIf6RrgM53
    semialign-1.2-JBIb9ab0V1K5cNzITIXjhA
    strict-0.4.0.1-HF4FcpUOCg9AtuP4ulyfvO
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV text-1.2.4.1
    these-1.1.1.1-LLYlOpfclwpJHbcSWEnCHY time-1.9.3
    unordered-containers-0.2.14.0-Dm8JoFpaxnRD1kEXsRDdDL
    uuid-types-1.0.5-7ik2IJH98LALk89hZtu3A3
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

