#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-Iwm6dg7PTcBKaCykckNilT
key:                  arch-hs-0.12.1-Iwm6dg7PTcBKaCykckNilT
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  5e41b7444d6faaa8d9a199218bd5c417
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-Iwm6dg7PTcBKaCykckNilT
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.6.6/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.10.3.0 Diff-0.5-ITRWFAaKGpZDrg9OMgbtjy
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    algebraic-graphs-0.7-Fd2WzVe5ywKDNBKqDqDERb
    arch-web-0.3.2-Bj1ENeIGTcxGwlOyvaW9Bg base-4.18.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-9Ano6zkKE8Q3t2Yg7Ibwss
    conduit-extra-1.3.8-B6Eb1ypzIORHRjCExezdNC containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    hackage-db-2.1.3-JhmZgcZzr9M2bY6VBok6eL
    http-client-0.7.19-3gG1vVFkVnQK6P9M9ZTkXM
    http-client-tls-0.3.6.4-9XDlH6cw2Z89HV4HLa1SKi
    megaparsec-9.7.0-9mft2rSPe2E2MODG5XVe3i
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    neat-interpolation-0.5.1.4-7Orqa1mGqVi5fKSqwjWIWW
    optparse-simple-0.1.1.4-9DHuQYXSLeA21o4YWJjuTU
    polysemy-1.9.2.0-L6Y9wxeoJIyYi0wpGG5i8
    prettyprinter-1.7.1-3RIfAGP8Xsr2KtHw8aT8ed
    prettyprinter-ansi-terminal-1.1.3-K5bcMFIz4auKJOMHGQ0axp
    servant-client-0.20.3.0-LuRKbtynQESIOdgbnZFrR5
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tar-conduit-0.4.1-HYW3R0HVFZ1GERQKiGomR1 template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

