/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.BufferManager;
import com.sun.xml.stream.xerces.impl.io.ASCIIReader;
import com.sun.xml.stream.xerces.impl.io.UCSReader;
import com.sun.xml.stream.xerces.impl.io.UTF8Reader;
import com.sun.xml.stream.xerces.util.EncodingMap;
import com.sun.xml.stream.xerces.util.XMLChar;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Locale;

public class StreamBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final boolean DEBUG = false;
    CharBuffer charBuffer = null;
    Reader fReader = null;
    boolean fAllowJavaEncodings = true;

    int getLength() {
        return 8192;
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    public boolean getMore() throws IOException {
        int n;
        char[] cArray;
        int n2;
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        }
        if ((n2 = this.fReader.read(cArray = this.charBuffer.array(), n = this.charBuffer.position(), this.charBuffer.capacity())) == -1) {
            this.endOfStream = true;
            return false;
        }
        this.charBuffer = CharBuffer.wrap(cArray);
        this.charBuffer.limit(n2);
        return n2 > 0;
    }

    public boolean arrangeCapacity(int n) throws IOException {
        return false;
    }

    public void setEncoding(String string) throws IOException {
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL uRL = new URL(file.toURI().toString());
            StreamBufferManager streamBufferManager = new StreamBufferManager(uRL.openStream(), "UTF-8");
            CharBuffer charBuffer = streamBufferManager.getCharBuffer();
            int n = 0;
            while (streamBufferManager.getMore()) {
                System.out.println("Loop " + n++ + " = " + streamBufferManager.getCharBuffer());
            }
            System.out.println("End of stream reached = " + streamBufferManager.endOfStream());
            System.out.println("Total no. of loops required = " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    public StreamBufferManager(InputStream inputStream, String string) throws IOException {
        this.init(inputStream, string);
    }

    void init(InputStream inputStream, String string) throws IOException {
        Boolean bl = null;
        RewindableInputStream rewindableInputStream = new RewindableInputStream(inputStream);
        if (string == null) {
            byte[] byArray = new byte[4];
            int n = 0;
            while (n < 4) {
                byArray[n] = (byte)((InputStream)rewindableInputStream).read();
                ++n;
            }
            if (n == 4) {
                Object[] objectArray = this.getEncodingName(byArray, n);
                string = (String)objectArray[0];
                bl = (Boolean)objectArray[1];
                ((InputStream)rewindableInputStream).reset();
                boolean bl2 = false;
                if (n > 2 && string.equals("UTF-8")) {
                    int n2 = byArray[0] & 0xFF;
                    int n3 = byArray[1] & 0xFF;
                    int n4 = byArray[2] & 0xFF;
                    if (n2 == 239 && n3 == 187 && n4 == 191) {
                        ((InputStream)rewindableInputStream).skip(3L);
                    }
                }
                this.fReader = this.createReader(rewindableInputStream, string, bl);
            } else {
                this.fReader = this.createReader(rewindableInputStream, string, bl);
            }
        } else {
            this.fReader = this.createReader(rewindableInputStream, string, bl);
        }
        this.charBuffer = CharBuffer.allocate(8192);
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string2 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, 8192, null, Locale.getDefault());
        }
        if (string2.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, 8192, null, Locale.getDefault());
        }
        if (string2.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            throw new IOException("Encoding byte order not supported");
        }
        if (string2.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            throw new IOException("Encoding byte order not supported");
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            throw new IOException("Encoding declaration " + string + "not valid");
        }
        String string3 = EncodingMap.getIANA2JavaMapping(string2);
        if (string3 == null) {
            if (this.fAllowJavaEncodings) {
                string3 = string;
            } else {
                throw new IOException("Encoding " + string + " not supported");
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream, string3));
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;
        static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;

        public int available() throws IOException {
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.available();
            }
            return n;
        }

        public int read() throws IOException {
            int n = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n;
            ++this.fOffset;
            return n & 0xFF;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.fMark = this.fOffset;
        }

        public void setStartOffset(int n) {
            this.fStartOffset = n;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l);
            }
            if (l <= (long)n) {
                this.fOffset = (int)((long)this.fOffset + l);
                return l;
            }
            this.fOffset += n;
            if (this.fOffset == this.fEndOffset) {
                return n;
            }
            return this.fInputStream.skip(l -= (long)n) + (long)n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.fLength - this.fOffset;
            if (n3 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.read(byArray, n, n2);
            }
            if (n2 < n3) {
                if (n2 <= 0) {
                    return 0;
                }
            } else {
                n2 = n3;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n, n2);
            }
            this.fOffset += n2;
            return n2;
        }

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }
    }
}

