/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.PropertiesFileSpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class PropertiesFileSpellingEngine
extends SpellingEngine {
    /*
     * Unable to fully structure code
     */
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        listener = new SpellingEngine.SpellEventListener(collector, document);
        isIgnoringAmpersand = PreferenceConstants.getPreferenceStore().getBoolean("spelling_ignore_ampersand_in_properties");
        try {
            checker.addListener(listener);
            partitionList = new ArrayList<ITypedRegion>();
            i = 0;
            while (i < regions.length) {
                partitionList.addAll(Arrays.asList(TextUtilities.computePartitioning((IDocument)document, (String)"___pf_partitioning", (int)regions[i].getOffset(), (int)regions[i].getLength(), (boolean)false)));
                ++i;
            }
            partitions = partitionList.toArray(new ITypedRegion[partitionList.size()]);
            i = 0;
            while (i < partitions.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                try {
                    if (listener.isProblemsThresholdReached()) ** continue;
                    partition = partitions[i];
                    if ("__pf_comment".equals(partition.getType())) {
                        while (i < partitions.length - 1) {
                            next = partitions[i + 1];
                            gapOffset = partition.getOffset() + partition.getLength();
                            gapLength = next.getOffset() - gapOffset;
                            if (!"__pf_comment".equals(next.getType()) && !this.isWhitespace(document, next.getOffset(), next.getLength()) || !this.isWhitespace(document, gapOffset, gapLength)) break;
                            partition = new TypedRegion(partition.getOffset(), next.getOffset() + next.getLength() - partition.getOffset(), partition.getType());
                            ++i;
                        }
                    }
                    if ("__pf_comment".equals(partitionType = partition.getType()) || !isIgnoringAmpersand && "__pf_roperty_value".equals(partitionType)) {
                        locale = checker.getLocale();
                        checker.execute(new SpellCheckIterator(document, (IRegion)partition, locale));
                    } else if (isIgnoringAmpersand && "__pf_roperty_value".equals(partitionType)) {
                        locale = checker.getLocale();
                        checker.execute(new PropertiesFileSpellCheckIterator(document, (IRegion)partition, locale));
                    }
                    ++i;
                    continue;
                }
                catch (BadLocationException x) {
                    JavaPlugin.log(x);
                }
                break;
            }
        }
        finally {
            checker.removeListener(listener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWhitespace(IDocument document, int offset, int length) {
        try {
            int i = 0;
            while (true) {
                if (i >= length) {
                    return true;
                }
                if (!Character.isWhitespace(document.getChar(offset + i))) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return false;
        }
    }
}

