/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private WorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IJavaReconcilingListener fJavaReconcilingListener;
    private boolean fIsJavaReconcilingListener;

    public JavaReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = JavaPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        this.fIsJavaReconcilingListener = this.fEditor instanceof IJavaReconcilingListener;
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener = (IJavaReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    private void reconcile(final boolean initialReconcile) {
        final CompilationUnit[] ast = new CompilationUnit[1];
        try {
            final ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput(), false);
            if (unit != null) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        block12: {
                            try {
                                IProblemRequestorExtension extension = JavaReconcilingStrategy.this.getProblemRequestorExtension();
                                if (extension != null) {
                                    extension.setProgressMonitor(JavaReconcilingStrategy.this.fProgressMonitor);
                                    extension.setIsActive(true);
                                }
                                try {
                                    try {
                                        boolean isASTNeeded;
                                        boolean bl = isASTNeeded = initialReconcile || JavaPlugin.getDefault().getASTProvider().isActive(unit);
                                        if (JavaReconcilingStrategy.this.fIsJavaReconcilingListener && isASTNeeded) {
                                            int reconcileFlags = 7;
                                            ast[0] = unit.reconcile(3, reconcileFlags, null, JavaReconcilingStrategy.this.fProgressMonitor);
                                            if (ast[0] != null) {
                                                ASTNodes.setFlagsToAST((ASTNode)ast[0], 4);
                                            }
                                            break block12;
                                        }
                                        unit.reconcile(0, true, null, JavaReconcilingStrategy.this.fProgressMonitor);
                                    }
                                    catch (OperationCanceledException operationCanceledException) {
                                        Assert.isTrue((JavaReconcilingStrategy.this.fProgressMonitor == null || JavaReconcilingStrategy.this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                                        ast[0] = null;
                                        if (extension != null) {
                                            extension.setProgressMonitor(null);
                                            extension.setIsActive(false);
                                        }
                                    }
                                }
                                finally {
                                    if (extension != null) {
                                        extension.setProgressMonitor(null);
                                        extension.setIsActive(false);
                                    }
                                }
                            }
                            catch (JavaModelException ex) {
                                this.handleException(ex);
                            }
                        }
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.eclipse.jdt.ui", 0, "Error in JDT Core during reconcile", ex);
                        JavaPlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.fIsJavaReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
            throw throwable;
        }
        try {
            if (this.fIsJavaReconcilingListener) {
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener.aboutToBeReconciled();
        }
    }
}

