/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceParameterObjectWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class IntroduceParameterObjectWizard
extends RefactoringWizard {
    public IntroduceParameterObjectWizard(Refactoring refactoring) {
        super(refactoring, 4);
        this.setDefaultPageTitle(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new IntroduceParameterObjectInputPage());
    }

    private static class IntroduceParameterObjectInputPage
    extends UserInputWizardPage {
        private static final String CREATE_TOP_LEVEL_SETTING = "CreateTopLevel";
        private static final String CREATE_SETTERS_SETTING = "CreateSetters";
        private static final String CREATE_GETTERS_SETTING = "CreateGetters";
        private IntroduceParameterObjectRefactoring fRefactoring;
        private JavaSourceViewer fSignaturePreview;
        private IDocument fSignaturePreviewDocument = new Document();
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;

        public IntroduceParameterObjectInputPage() {
            super(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_name);
            this.setTitle(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_title);
            this.setDescription(RefactoringMessages.IntroduceParameterObjectWizard_wizardpage_description);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            this.fRefactoring = (IntroduceParameterObjectRefactoring)this.getRefactoring();
            Composite result = new Composite(parent, 0);
            result.setLayout((Layout)new GridLayout(2, false));
            Group group = this.createGroup(result, RefactoringMessages.IntroduceParameterObjectWizard_type_group);
            this.createClassNameInput((Composite)group);
            this.createLocationInput((Composite)group);
            this.createTable((Composite)group);
            this.createGetterInput((Composite)group);
            this.createSetterInput((Composite)group);
            group = this.createGroup(result, RefactoringMessages.IntroduceParameterObjectWizard_method_group);
            this.createParameterNameInput(group);
            this.createDelegateInput(group);
            this.createSignaturePreview((Composite)group);
            this.validateRefactoring();
            this.setControl((Control)result);
        }

        private void createParameterNameInput(Group group) {
            Label l = new Label((Composite)group, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_parameterfield_label);
            Text text = new Text((Composite)group, 2048);
            text.setText(this.fRefactoring.getParameterName());
            text.addModifyListener(new ModifyListener(this, text){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent e) {
                    IntroduceParameterObjectInputPage.access$1(this.this$1).setParameterName(this.val$text.getText());
                    IntroduceParameterObjectInputPage.access$0(this.this$1);
                    this.this$1.validateRefactoring();
                }
            });
            text.setLayoutData((Object)new GridData(768));
        }

        protected void validateRefactoring() {
            IStatus validatePackageName;
            ArrayList<String> names = new ArrayList<String>();
            boolean oneChecked = false;
            this.setMessage(null);
            this.setErrorMessage(null);
            this.setPageComplete(true);
            IJavaProject project = this.fRefactoring.getMethod().getJavaProject();
            String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            String compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            List parameterInfos = this.fRefactoring.getParameterInfos();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (names.contains(pi.getNewName())) {
                    this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_notunique, pi.getNewName()));
                    this.setPageComplete(false);
                    return;
                }
                names.add(pi.getNewName());
                IStatus validateIdentifier = JavaConventions.validateIdentifier((String)pi.getNewName(), (String)sourceLevel, (String)compliance);
                if (this.isErrorMessage(validateIdentifier)) {
                    return;
                }
                if (!pi.isCreateField()) continue;
                oneChecked = true;
            }
            if (!oneChecked) {
                this.setErrorMessage(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_atleastoneparameter);
                this.setPageComplete(false);
                return;
            }
            IStatus validateJavaTypeName = JavaConventions.validateJavaTypeName((String)this.fRefactoring.getClassName(), (String)sourceLevel, (String)compliance);
            if (this.isErrorMessage(validateJavaTypeName)) {
                return;
            }
            if (this.fRefactoring.getClassName().indexOf(46) != -1) {
                this.setErrorMessage(RefactoringMessages.IntroduceParameterObjectWizard_dot_not_allowed_error);
                this.setPageComplete(false);
            }
            if (!"".equals(this.fRefactoring.getPackage()) && this.isErrorMessage(validatePackageName = JavaConventions.validatePackageName((String)this.fRefactoring.getPackage(), (String)sourceLevel, (String)compliance))) {
                return;
            }
            try {
                IType type = project.findType(this.fRefactoring.getNewTypeName());
                if (type != null) {
                    StringBuffer packageName = new StringBuffer();
                    JavaElementLabels.getPackageFragmentLabel(type.getPackageFragment(), JavaElementLabels.ALL_DEFAULT, packageName);
                    if (this.fRefactoring.isCreateAsTopLevel()) {
                        this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_type_already_exists_in_package_info, new Object[]{this.fRefactoring.getClassName(), packageName.toString()}));
                        this.setPageComplete(false);
                        return;
                    }
                    this.setErrorMessage(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_parametername_check_alreadyexists, new Object[]{this.fRefactoring.getClassName(), type.getCompilationUnit().getElementName()}));
                    this.setPageComplete(false);
                    return;
                }
            }
            catch (JavaModelException javaModelException) {}
        }

        private boolean isErrorMessage(IStatus validationStatus) {
            if (!validationStatus.isOK()) {
                if (validationStatus.getSeverity() == 4) {
                    this.setErrorMessage(validationStatus.getMessage());
                    this.setPageComplete(false);
                    return true;
                }
                if (validationStatus.getSeverity() == 1) {
                    this.setMessage(validationStatus.getMessage(), 1);
                } else {
                    this.setMessage(validationStatus.getMessage(), 2);
                }
            }
            return false;
        }

        private void createSignaturePreview(Composite composite) {
            Label previewLabel = new Label(composite, 0);
            previewLabel.setText(RefactoringMessages.IntroduceParameterObjectWizard_signaturepreview_label);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            previewLabel.setLayoutData((Object)gridData);
            IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
            this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, store);
            this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
            this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
            this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
            this.fSignaturePreview.setDocument(this.fSignaturePreviewDocument);
            this.fSignaturePreview.setEditable(false);
            Control signaturePreviewControl = this.fSignaturePreview.getControl();
            PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
            GridData gdata = new GridData(1808);
            gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
            gdata.horizontalSpan = 2;
            signaturePreviewControl.setLayoutData((Object)gdata);
            this.updateSignaturePreview();
        }

        private void createDelegateInput(Group group) {
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox((Composite)group, this.getRefactoring(), false);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fLeaveDelegateCheckBox.setLayoutData((Object)gridData);
            if (this.fLeaveDelegateCheckBox != null) {
                this.fDeprecateDelegateCheckBox = new Button((Composite)group, 32);
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                GridLayout layout = (GridLayout)group.getLayout();
                data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                data.horizontalSpan = 2;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                IntroduceParameterObjectRefactoring refactoring = this.fRefactoring;
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(refactoring));
                refactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, refactoring){
                    final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                    private final /* synthetic */ ChangeSignatureRefactoring val$refactoring;
                    {
                        this.this$1 = introduceParameterObjectInputPage;
                        this.val$refactoring = changeSignatureRefactoring;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$refactoring.setDeprecateDelegates(IntroduceParameterObjectInputPage.access$2(this.this$1).getSelection());
                        this.this$1.validateRefactoring();
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                    {
                        this.this$1 = introduceParameterObjectInputPage;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        IntroduceParameterObjectInputPage.access$2(this.this$1).setEnabled(IntroduceParameterObjectInputPage.access$3(this.this$1).getSelection());
                    }
                });
            }
        }

        private Group createGroup(Composite result, String caption) {
            Group group = new Group(result, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setText(caption);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            group.setLayoutData((Object)gridData);
            return group;
        }

        private void createLocationInput(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_destination_label);
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            composite.setLayoutData((Object)gridData);
            Button topLvlRadio = new Button(composite, 16);
            topLvlRadio.setText(RefactoringMessages.IntroduceParameterObjectWizard_createastoplevel_radio);
            topLvlRadio.addSelectionListener((SelectionListener)new SelectionAdapter(this, topLvlRadio){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ Button val$topLvlRadio;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$topLvlRadio = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean fAsTopLevel = this.val$topLvlRadio.getSelection();
                    IntroduceParameterObjectInputPage.access$1(this.this$1).setCreateAsTopLevel(fAsTopLevel);
                    IntroduceParameterObjectInputPage.access$0(this.this$1);
                    this.this$1.validateRefactoring();
                }
            });
            Button nestedRadio = new Button(composite, 16);
            nestedRadio.setText(Messages.format(RefactoringMessages.IntroduceParameterObjectWizard_createasnestedclass_radio, this.fRefactoring.getContainingClass().getName()));
            boolean createAsTopLevel = this.getBooleanSetting(CREATE_TOP_LEVEL_SETTING, this.fRefactoring.isCreateAsTopLevel());
            this.fRefactoring.setCreateAsTopLevel(createAsTopLevel);
            topLvlRadio.setSelection(createAsTopLevel);
            nestedRadio.setSelection(!createAsTopLevel);
        }

        private void createTable(Composite parent) {
            Composite result = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            result.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            result.setLayoutData((Object)gridData);
            Label l = new Label(result, 0);
            l.setText(RefactoringMessages.IntroduceParameterObjectWizard_fields_selection_label);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            l.setLayoutData((Object)gridData);
            TableLayoutComposite layoutComposite = new TableLayoutComposite(result, 0);
            layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, this.convertWidthInCharsToPixels(20), true));
            layoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(60, this.convertWidthInCharsToPixels(20), true));
            CheckboxTableViewer tv = CheckboxTableViewer.newCheckList((Composite)layoutComposite, (int)68352);
            tv.setContentProvider((IContentProvider)new ParameterObjectCreatorContentProvider());
            this.createColumns(tv);
            Table table = tv.getTable();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            gridData = new GridData(1808);
            table.setLayoutData((Object)gridData);
            tv.setInput((Object)this.fRefactoring);
            List parameterInfos = this.fRefactoring.getParameterInfos();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                tv.setChecked((Object)pi, pi.isCreateField());
            }
            tv.refresh(true);
            gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.getTableHeightHint(table, parameterInfos.size());
            layoutComposite.setLayoutData(gridData);
            Composite controls = new Composite(result, 0);
            gridData = new GridData(4, 4, false, false);
            controls.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            controls.setLayout((Layout)gridLayout);
            Button upButton = new Button(controls, 0);
            upButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_moveentryup_button);
            gridData = new GridData(768);
            upButton.setLayoutData((Object)gridData);
            SWTUtil.setButtonDimensionHint(upButton);
            upButton.setEnabled(false);
            Button downButton = new Button(controls, 0);
            downButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_moventrydown_button);
            gridData = new GridData(768);
            downButton.setLayoutData((Object)gridData);
            SWTUtil.setButtonDimensionHint(downButton);
            downButton.setEnabled(false);
            this.addSpacer(controls);
            Button editButton = new Button(controls, 0);
            editButton.setText(RefactoringMessages.IntroduceParameterObjectWizard_edit_button);
            editButton.setLayoutData((Object)new GridData(768));
            editButton.setEnabled(!tv.getSelection().isEmpty());
            SWTUtil.setButtonDimensionHint(editButton);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, tv){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ CheckboxTableViewer val$tv;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$tv = checkboxTableViewer;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = this.val$tv.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        ParameterInfo selected = (ParameterInfo)ss.getFirstElement();
                        String message = RefactoringMessages.IntroduceParameterObjectWizard_fieldname_message;
                        String title = RefactoringMessages.IntroduceParameterObjectWizard_fieldname_title;
                        InputDialog inputDialog = new InputDialog(this.this$1.getShell(), title, message, selected.getNewName(), new IInputValidator(this){
                            final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public String isValid(String newText) {
                                String compliance;
                                IJavaProject project = IntroduceParameterObjectInputPage.access$1(5.access$0(this.this$2)).getCompilationUnit().getJavaProject();
                                String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
                                IStatus status = JavaConventions.validateIdentifier((String)newText, (String)sourceLevel, (String)(compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true)));
                                if (!status.isOK()) {
                                    return status.getMessage();
                                }
                                return null;
                            }
                        });
                        if (inputDialog.open() == 0) {
                            selected.setNewName(inputDialog.getValue());
                            this.val$tv.refresh((Object)selected);
                            IntroduceParameterObjectInputPage.access$0(this.this$1);
                        }
                    }
                }

                static /* synthetic */ IntroduceParameterObjectInputPage access$0(5 var0) {
                    return var0.this$1;
                }
            });
            downButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, tv, upButton, downButton, editButton){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ CheckboxTableViewer val$tv;
                private final /* synthetic */ Button val$upButton;
                private final /* synthetic */ Button val$downButton;
                private final /* synthetic */ Button val$editButton;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$tv = checkboxTableViewer;
                    this.val$upButton = button;
                    this.val$downButton = button2;
                    this.val$editButton = button3;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = this.val$tv.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        ParameterInfo selected = (ParameterInfo)ss.getFirstElement();
                        IntroduceParameterObjectInputPage.access$1(this.this$1).moveFieldDown(selected);
                        this.val$tv.refresh();
                        IntroduceParameterObjectInputPage.access$4(this.this$1, (TableViewer)this.val$tv, this.val$upButton, this.val$downButton, this.val$editButton);
                    }
                }
            });
            upButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, tv, upButton, downButton, editButton){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ CheckboxTableViewer val$tv;
                private final /* synthetic */ Button val$upButton;
                private final /* synthetic */ Button val$downButton;
                private final /* synthetic */ Button val$editButton;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$tv = checkboxTableViewer;
                    this.val$upButton = button;
                    this.val$downButton = button2;
                    this.val$editButton = button3;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = this.val$tv.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        ParameterInfo selected = (ParameterInfo)ss.getFirstElement();
                        IntroduceParameterObjectInputPage.access$1(this.this$1).moveFieldUp(selected);
                        this.val$tv.refresh();
                        IntroduceParameterObjectInputPage.access$4(this.this$1, (TableViewer)this.val$tv, this.val$upButton, this.val$downButton, this.val$editButton);
                    }
                }
            });
            tv.addCheckStateListener(new ICheckStateListener(this, tv, upButton, downButton, editButton){
                Map fLastNames;
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ CheckboxTableViewer val$tv;
                private final /* synthetic */ Button val$upButton;
                private final /* synthetic */ Button val$downButton;
                private final /* synthetic */ Button val$editButton;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$tv = checkboxTableViewer;
                    this.val$upButton = button;
                    this.val$downButton = button2;
                    this.val$editButton = button3;
                    this.fLastNames = new HashMap<K, V>();
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ParameterInfo element = (ParameterInfo)event.getElement();
                    element.setCreateField(event.getChecked());
                    if (element.isCreateField()) {
                        String lastName = (String)this.fLastNames.get(element);
                        if (lastName == null) {
                            lastName = IntroduceParameterObjectInputPage.access$1(this.this$1).getFieldName(element);
                        }
                        element.setNewName(lastName);
                    } else {
                        this.fLastNames.put(element, element.getNewName());
                        element.setNewName(element.getOldName());
                    }
                    this.val$tv.update((Object)element, null);
                    IntroduceParameterObjectInputPage.access$4(this.this$1, (TableViewer)this.val$tv, this.val$upButton, this.val$downButton, this.val$editButton);
                    this.this$1.validateRefactoring();
                }
            });
            tv.addSelectionChangedListener(new ISelectionChangedListener(this, tv, upButton, downButton, editButton){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ CheckboxTableViewer val$tv;
                private final /* synthetic */ Button val$upButton;
                private final /* synthetic */ Button val$downButton;
                private final /* synthetic */ Button val$editButton;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$tv = checkboxTableViewer;
                    this.val$upButton = button;
                    this.val$downButton = button2;
                    this.val$editButton = button3;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IntroduceParameterObjectInputPage.access$4(this.this$1, (TableViewer)this.val$tv, this.val$upButton, this.val$downButton, this.val$editButton);
                }
            });
        }

        private void addSpacer(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData(768);
            gd.heightHint = 5;
            label.setLayoutData((Object)gd);
        }

        private void createColumns(CheckboxTableViewer tv) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)tv.getTable());
            TableViewerColumn viwerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viwerColumn.setLabelProvider((CellLabelProvider)new ParameterInfoLabelProvider(this){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                }

                protected String doGetValue(ParameterInfo pi) {
                    return pi.getNewTypeName();
                }
            });
            TableColumn column = viwerColumn.getColumn();
            column.setText(RefactoringMessages.IntroduceParameterObjectWizard_type_column);
            viwerColumn = new TableViewerColumn((TableViewer)tv, 16384);
            viwerColumn.setLabelProvider((CellLabelProvider)new ParameterInfoLabelProvider(this){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                }

                protected String doGetValue(ParameterInfo pi) {
                    return pi.getNewName();
                }
            });
            viwerColumn.setEditingSupport((EditingSupport)new ParameterInfoEditingSupport(this, (CellEditor)cellEditor, (ColumnViewer)tv){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                }

                public String doGetValue(ParameterInfo pi) {
                    return pi.getNewName();
                }

                public void doSetValue(ParameterInfo pi, String string) {
                    pi.setNewName(string);
                }
            });
            column = viwerColumn.getColumn();
            column.setText(RefactoringMessages.IntroduceParameterObjectWizard_name_column);
        }

        private void createGetterInput(Composite result) {
            Composite buttons = new Composite(result, 0);
            GridLayout gridLayout = new GridLayout(2, true);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttons.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            buttons.setLayoutData((Object)gridData);
            Button button = new Button(buttons, 32);
            button.setText(RefactoringMessages.IntroduceParameterObjectWizard_creategetter_checkbox);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ Button val$button;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$button = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    IntroduceParameterObjectInputPage.access$1(this.this$1).setCreateGetter(this.val$button.getSelection());
                    this.this$1.validateRefactoring();
                }
            });
            button.setSelection(this.getBooleanSetting(CREATE_GETTERS_SETTING, this.fRefactoring.isCreateGetter()));
            this.fRefactoring.setCreateGetter(button.getSelection());
            gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }

        private void createSetterInput(Composite result) {
            Button button = new Button(result, 32);
            button.setText(RefactoringMessages.IntroduceParameterObjectWizard_createsetter_checkbox);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ Button val$button;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$button = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    IntroduceParameterObjectInputPage.access$1(this.this$1).setCreateSetter(this.val$button.getSelection());
                    this.this$1.validateRefactoring();
                }
            });
            button.setSelection(this.getBooleanSetting(CREATE_SETTERS_SETTING, this.fRefactoring.isCreateSetter()));
            this.fRefactoring.setCreateSetter(button.getSelection());
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
        }

        private void createClassNameInput(Composite result) {
            Label label = new Label(result, 16384);
            label.setText(RefactoringMessages.IntroduceParameterObjectWizard_classnamefield_label);
            Text text = new Text(result, 2052);
            text.setText(this.fRefactoring.getClassName());
            text.selectAll();
            text.setFocus();
            text.addModifyListener(new ModifyListener(this, text){
                final /* synthetic */ IntroduceParameterObjectInputPage this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = introduceParameterObjectInputPage;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent e) {
                    IntroduceParameterObjectInputPage.access$1(this.this$1).setClassName(this.val$text.getText());
                    IntroduceParameterObjectInputPage.access$0(this.this$1);
                    this.this$1.validateRefactoring();
                }
            });
            text.setLayoutData((Object)new GridData(768));
        }

        private void updateButtons(TableViewer tv, Button upButton, Button downButton, Button editButton) {
            IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
            ParameterInfo firstElement = (ParameterInfo)selection.getFirstElement();
            if (selection.isEmpty()) {
                upButton.setEnabled(false);
                downButton.setEnabled(false);
                editButton.setEnabled(false);
            } else {
                int selectionIndex = tv.getTable().getSelectionIndex();
                upButton.setEnabled(selectionIndex != 0);
                downButton.setEnabled(selectionIndex != tv.getTable().getItemCount() - 1);
                editButton.setEnabled(firstElement.isCreateField());
            }
            this.fRefactoring.updateParameterPosition();
            this.updateSignaturePreview();
        }

        private void updateSignaturePreview() {
            try {
                int top = this.fSignaturePreview.getTextWidget().getTopPixel();
                this.fSignaturePreviewDocument.set(this.fRefactoring.getNewMethodSignature());
                this.fSignaturePreview.getTextWidget().setTopPixel(top);
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.IntroduceParameterObjectWizard_error_title, RefactoringMessages.IntroduceParameterObjectWizard_error_description);
            }
        }

        public void dispose() {
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            IDialogSettings settings = this.getRefactoringSettings();
            settings.put(CREATE_GETTERS_SETTING, this.fRefactoring.isCreateGetter());
            settings.put(CREATE_SETTERS_SETTING, this.fRefactoring.isCreateSetter());
            settings.put(CREATE_TOP_LEVEL_SETTING, this.fRefactoring.isCreateAsTopLevel());
            super.dispose();
        }

        protected boolean getBooleanSetting(String key, boolean defaultValue) {
            String update = this.getRefactoringSettings().get(key);
            if (update != null) {
                return Boolean.valueOf(update);
            }
            return defaultValue;
        }

        static /* synthetic */ IntroduceParameterObjectRefactoring access$1(IntroduceParameterObjectInputPage introduceParameterObjectInputPage) {
            return introduceParameterObjectInputPage.fRefactoring;
        }

        static /* synthetic */ Button access$2(IntroduceParameterObjectInputPage introduceParameterObjectInputPage) {
            return introduceParameterObjectInputPage.fDeprecateDelegateCheckBox;
        }

        static /* synthetic */ Button access$3(IntroduceParameterObjectInputPage introduceParameterObjectInputPage) {
            return introduceParameterObjectInputPage.fLeaveDelegateCheckBox;
        }

        static /* synthetic */ void access$4(IntroduceParameterObjectInputPage introduceParameterObjectInputPage, TableViewer tableViewer, Button button, Button button2, Button button3) {
            introduceParameterObjectInputPage.updateButtons(tableViewer, button, button2, button3);
        }

        private abstract class ParameterInfoEditingSupport
        extends EditingSupport {
            private CellEditor fTextEditor;

            private ParameterInfoEditingSupport(CellEditor textEditor, ColumnViewer tv) {
                super(tv);
                this.fTextEditor = textEditor;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    this.doSetValue(pi, value.toString());
                    this.getViewer().update(element, null);
                }
                IntroduceParameterObjectInputPage.this.validateRefactoring();
                IntroduceParameterObjectInputPage.this.updateSignaturePreview();
            }

            public abstract void doSetValue(ParameterInfo var1, String var2);

            protected Object getValue(Object element) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    return this.doGetValue(pi);
                }
                return null;
            }

            public abstract String doGetValue(ParameterInfo var1);

            protected CellEditor getCellEditor(Object element) {
                return this.fTextEditor;
            }

            protected boolean canEdit(Object element) {
                if (element instanceof ParameterInfo) {
                    ParameterInfo pi = (ParameterInfo)element;
                    return this.fTextEditor != null && pi.isCreateField();
                }
                return false;
            }
        }

        private abstract class ParameterInfoLabelProvider
        extends CellLabelProvider {
            private ParameterInfoLabelProvider() {
            }

            public void update(ViewerCell cell) {
                ParameterInfo pi = (ParameterInfo)cell.getElement();
                cell.setText(this.doGetValue(pi));
            }

            protected abstract String doGetValue(ParameterInfo var1);
        }

        private final class ParameterObjectCreatorContentProvider
        implements IStructuredContentProvider {
            private ParameterObjectCreatorContentProvider() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IntroduceParameterObjectRefactoring) {
                    IntroduceParameterObjectRefactoring refactoring = (IntroduceParameterObjectRefactoring)inputElement;
                    List parameterInfos = refactoring.getParameterInfos();
                    ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(parameterInfos.size());
                    Iterator iter = parameterInfos.iterator();
                    while (iter.hasNext()) {
                        ParameterInfo pi = (ParameterInfo)iter.next();
                        if (pi.isAdded()) continue;
                        result.add(pi);
                    }
                    return result.toArray();
                }
                return null;
            }
        }
    }
}

