/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentSetupParticipant;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.JavaColorManager;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class PropertiesFileEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.PropertiesFileEditorPreferencePage_key, "pf_coloring_key"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_value, "pf_coloring_value"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_assignment, "pf_coloring_assignment"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_argument, "pf_coloring_argument"}, {PreferencesMessages.PropertiesFileEditorPreferencePage_comment, "pf_coloring_comment"}};
    private OverlayPreferenceStore fOverlayStore;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private SourceViewer fPreviewViewer;
    private boolean fFieldsInitialized = false;
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private final List fHighlightingColorList = new ArrayList();
    private TableViewer fHighlightingColorListViewer;
    private IColorManager fColorManager;

    public PropertiesFileEditorPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, colorKey));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + BOLD));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + ITALIC));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + STRIKETHROUGH));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + UNDERLINE));
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.properties_file_editor_preference_page_context");
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getUnderlineKey()));
        this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
        this.fBoldCheckBox.setEnabled(true);
        this.fItalicCheckBox.setEnabled(true);
        this.fStrikethroughCheckBox.setEnabled(true);
        this.fUnderlineCheckBox.setEnabled(true);
    }

    private Control createSyntaxPage(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_foreground);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setComparator((ViewerComparator)new WorkbenchViewerSorter());
        gd = new GridData(1, 4, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        label = new Label(stylesComposite, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(parent, 16384);
        label.setText(PreferencesMessages.PropertiesFileEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(parent);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesFileEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)PropertiesFileEditorPreferencePage.this.fOverlayStore, (String)item.getColorKey(), (RGB)PropertiesFileEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(item.getBoldKey(), PropertiesFileEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(item.getItalicKey(), PropertiesFileEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(item.getStrikethroughKey(), PropertiesFileEditorPreferencePage.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = PropertiesFileEditorPreferencePage.this.getHighlightingColorListItem();
                PropertiesFileEditorPreferencePage.this.fOverlayStore.setValue(item.getUnderlineKey(), PropertiesFileEditorPreferencePage.this.fUnderlineCheckBox.getSelection());
            }
        });
        parent.layout();
        return parent;
    }

    private Control createPreviewer(Composite parent) {
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, JavaPlugin.getDefault().getCombinedPreferenceStore()});
        this.fPreviewViewer = new JavaSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        this.fColorManager = new JavaColorManager(false);
        PropertiesFileSourceViewerConfiguration configuration = new PropertiesFileSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, "___pf_partitioning");
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.PropertiesFileEditor.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new SourcePreviewerUpdater(this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("PropertiesFileEditorColorSettingPreviewCode.txt");
        Document document = new Document(content);
        PropertiesFileDocumentSetupParticipant.setupDocument((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        PropertiesFileEditorPreferencePage.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        this.createHeader(contents);
        this.createSyntaxPage(contents);
        this.initialize();
        Dialog.applyDialogFont((Control)contents);
        return contents;
    }

    private void createHeader(Composite contents) {
        String text = PreferencesMessages.PropertiesFileEditorPreferencePage_link;
        Link link = new Link(contents, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PropertiesFileEditorPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.PropertiesFileEditorPreferencePage_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        this.addFiller(contents);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[i][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[i][1]) + UNDERLINE, null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
    }

    private void initializeFields() {
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
        Iterator iter = this.fMasterSlaveListeners.iterator();
        while (iter.hasNext()) {
            SelectionListener listener = (SelectionListener)iter.next();
            listener.widgetSelected(null);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleSyntaxColorListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        this.fColorManager.dispose();
        super.dispose();
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    JavaPlugin.log(io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }

    private static class SourcePreviewerUpdater {
        SourcePreviewerUpdater(SourceViewer viewer, PropertiesFileSourceViewerConfiguration configuration, IPreferenceStore preferenceStore) {
            Assert.isNotNull((Object)viewer);
            Assert.isNotNull((Object)((Object)configuration));
            Assert.isNotNull((Object)preferenceStore);
            IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(this, viewer){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.jdt.ui.PropertiesFileEditor.textfont")) {
                        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.PropertiesFileEditor.textfont");
                        this.val$viewer.getTextWidget().setFont(font);
                    }
                }
            };
            IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(this, configuration, viewer){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ PropertiesFileSourceViewerConfiguration val$configuration;
                private final /* synthetic */ SourceViewer val$viewer;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$configuration = propertiesFileSourceViewerConfiguration;
                    this.val$viewer = sourceViewer;
                }

                public void propertyChange(PropertyChangeEvent event) {
                    if (this.val$configuration.affectsTextPresentation(event)) {
                        this.val$configuration.handlePropertyChangeEvent(event);
                        this.val$viewer.invalidateTextPresentation();
                    }
                }
            };
            viewer.getTextWidget().addDisposeListener(new DisposeListener(this, preferenceStore, propertyChangeListener, fontChangeListener){
                final /* synthetic */ SourcePreviewerUpdater this$1;
                private final /* synthetic */ IPreferenceStore val$preferenceStore;
                private final /* synthetic */ IPropertyChangeListener val$propertyChangeListener;
                private final /* synthetic */ IPropertyChangeListener val$fontChangeListener;
                {
                    this.this$1 = sourcePreviewerUpdater;
                    this.val$preferenceStore = iPreferenceStore;
                    this.val$propertyChangeListener = iPropertyChangeListener;
                    this.val$fontChangeListener = iPropertyChangeListener2;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.val$preferenceStore.removePropertyChangeListener(this.val$propertyChangeListener);
                    JFaceResources.getFontRegistry().removeListener(this.val$fontChangeListener);
                }
            });
            JFaceResources.getFontRegistry().addListener(fontChangeListener);
            preferenceStore.addPropertyChangeListener(propertyChangeListener);
        }
    }
}

