/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ControlStatementsCleanUp
extends AbstractCleanUp {
    public ControlStatementsCleanUp(Map options) {
        super(options);
    }

    public ControlStatementsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        boolean useBlocks = this.isEnabled("cleanup.use_blocks");
        if (!useBlocks) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_blocks") || this.isEnabled("cleanup.never_use_blocks") || this.isEnabled("cleanup.use_blocks_only_for_return_and_throw");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean useBlocks = this.isEnabled("cleanup.use_blocks");
        if (!useBlocks) {
            return null;
        }
        return ControlStatementsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_blocks"), this.isEnabled("cleanup.never_use_blocks"), this.isEnabled("cleanup.use_blocks_only_for_return_and_throw"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ConvertSingleStatementInControlBodeyToBlock_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocks_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocksWithReturnOrThrow_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            buf.append("if (obj == null) {\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else {\n");
            buf.append("    return;\n");
            buf.append("}\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            buf.append("if (obj == null)\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("\n");
            buf.append("if (ids.length > 0)\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("else\n");
            buf.append("    return;\n");
            buf.append("\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            buf.append("if (obj == null)\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        } else {
            buf.append("if (obj == null) {\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

