/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.CommentFormatFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class CommentFormatCleanUp
extends AbstractCleanUp {
    public CommentFormatCleanUp(Map options) {
        super(options);
    }

    public CommentFormatCleanUp() {
    }

    public IFix createFix(ICompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        if (!this.isEnabled("cleanup.format_source_code")) {
            return null;
        }
        HashMap preferences = new HashMap(compilationUnit.getJavaProject().getOptions(true));
        boolean singleLineComment = "true".equals(preferences.get("org.eclipse.jdt.core.formatter.comment.format_line_comments"));
        boolean blockComment = "true".equals(preferences.get("org.eclipse.jdt.core.formatter.comment.format_block_comments"));
        boolean javaDoc = "true".equals(preferences.get("org.eclipse.jdt.core.formatter.comment.format_javadoc_comments"));
        return CommentFormatFix.createCleanUp(compilationUnit, singleLineComment, blockComment, javaDoc, preferences);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return null;
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        return false;
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        return null;
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" *A Javadoc comment\n");
        buf.append("* @since 2007\n");
        buf.append(" */\n");
        return buf.toString();
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

