/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.corext.template.java.JavaVariable;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.swt.widgets.Shell;

public class JavaContext
extends CompilationUnitContext {
    private CompilationUnitCompletion fCompletion;
    private Set fUsedNames = new HashSet();
    private Map fVariables = new HashMap();

    public JavaContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public JavaContext(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            IJavaProject project = this.getJavaProject();
            return Strings.computeIndentUnits(lineContent, project);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        this.clear();
        if (!this.canEvaluate(template)) {
            throw new TemplateException(JavaTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                JavaVariable variable = new JavaVariable(type, name, offsets);
                JavaContext.this.fVariables.put(name, variable);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.jdt.ui.template.format");
        IJavaProject project = this.getJavaProject();
        JavaFormatter formatter = new JavaFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), useCodeFormatter, project);
        formatter.format(buffer, (TemplateContext)this);
        this.clear();
        return buffer;
    }

    private void clear() {
        this.fUsedNames.clear();
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = JavaTemplateMessages.JavaContext_error_title;
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            JavaPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    private CompilationUnitCompletion getCompletion() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(compilationUnit);
            if (compilationUnit != null) {
                try {
                    compilationUnit.codeComplete(this.getStart(), (CompletionRequestor)this.fCompletion);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return this.fCompletion;
    }

    public CompilationUnitCompletion.Variable[] getArrays() {
        CompilationUnitCompletion.Variable[] localArrays = this.getCompletion().findLocalArrays();
        this.arrange(localArrays);
        return localArrays;
    }

    private void arrange(CompilationUnitCompletion.Variable[] variables) {
        Arrays.sort(variables, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.rank((CompilationUnitCompletion.Variable)o1) - this.rank((CompilationUnitCompletion.Variable)o2);
            }

            private int rank(CompilationUnitCompletion.Variable l) {
                return JavaContext.this.fUsedNames.contains(l.getName()) ? 1 : 0;
            }
        });
    }

    public CompilationUnitCompletion.Variable[] getLocalVariables(String type) {
        CompilationUnitCompletion.Variable[] localVariables = this.getCompletion().findLocalVariables(type);
        this.arrange(localVariables);
        return localVariables;
    }

    public CompilationUnitCompletion.Variable[] getFields(String type) {
        CompilationUnitCompletion.Variable[] fields = this.getCompletion().findFieldVariables(type);
        this.arrange(fields);
        return fields;
    }

    public CompilationUnitCompletion.Variable[] getIterables() {
        CompilationUnitCompletion.Variable[] iterables = this.getCompletion().findLocalIterables();
        this.arrange(iterables);
        return iterables;
    }

    public void markAsUsed(String name) {
        this.fUsedNames.add(name);
    }

    public String[] suggestVariableNames(String type) throws IllegalArgumentException {
        String[] excludes = this.computeExcludes();
        String[] result = this.suggestVariableName(type, excludes);
        return result;
    }

    private String[] computeExcludes() {
        String[] excludes = this.getCompletion().getLocalVariableNames();
        if (!this.fUsedNames.isEmpty()) {
            String[] allExcludes = new String[this.fUsedNames.size() + excludes.length];
            System.arraycopy(excludes, 0, allExcludes, 0, excludes.length);
            System.arraycopy(this.fUsedNames.toArray(), 0, allExcludes, 0, this.fUsedNames.size());
            excludes = allExcludes;
        }
        return excludes;
    }

    private String[] suggestVariableName(String type, String[] excludes) throws IllegalArgumentException {
        int dim = 0;
        while (type.endsWith("[]")) {
            ++dim;
            type = type.substring(0, type.length() - 2);
        }
        IJavaProject project = this.getJavaProject();
        if (project != null) {
            return StubUtility.getVariableNameSuggestions(5, project, type, dim, Arrays.asList(excludes), true);
        }
        return new String[]{Signature.getSimpleName((String)type).toLowerCase()};
    }

    public void addImport(String type) {
        if (this.isReadOnly()) {
            return;
        }
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return;
        }
        try {
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                SimpleName nameNode;
                IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
                TypeNameMatch[] matches = this.findAllTypes(type, searchScope, nameNode = null, null, cu);
                if (matches.length != 1) {
                    return;
                }
                type = matches[0].getFullyQualifiedName();
            }
            Position position = new Position(this.getCompletionOffset(), this.getCompletionLength());
            IDocument document = this.getDocument();
            String category = "__template_position_importer" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            try {
                try {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                    CompilationUnit root = this.getASTRoot(cu);
                    ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.getCompletionOffset(), rewrite);
                    rewrite.addImport(type, context);
                    JavaModelUtil.applyEdit(cu, rewrite.rewriteImports(null), false, null);
                    this.setCompletionOffset(position.getOffset());
                    this.setCompletionLength(position.getLength());
                }
                catch (CoreException e) {
                    JavaContext.handleException(null, (Exception)((Object)e));
                    document.removePosition(position);
                    document.removePositionUpdater((IPositionUpdater)updater);
                    document.removePositionCategory(category);
                }
            }
            finally {
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
            }
        }
        catch (BadLocationException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
        catch (JavaModelException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
    }

    private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
        return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)compilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private TypeNameMatch[] findAllTypes(String simpleTypeName, IJavaSearchScope searchScope, SimpleName nameNode, IProgressMonitor monitor, ICompilationUnit cu) throws JavaModelException {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
        int typeKinds = 126;
        if (nameNode != null) {
            typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)nameNode, is50OrHigher);
        }
        ArrayList typeInfos = new ArrayList();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(typeInfos);
        new SearchEngine().searchAllTypeNames(null, 0, simpleTypeName.toCharArray(), 8, this.getSearchForConstant(typeKinds), searchScope, (TypeNameMatchRequestor)requestor, 1, monitor);
        ArrayList<TypeNameMatch> typeRefsFound = new ArrayList<TypeNameMatch>(typeInfos.size());
        int i = 0;
        int len = typeInfos.size();
        while (i < len) {
            TypeNameMatch curr = (TypeNameMatch)typeInfos.get(i);
            if (curr.getPackageName().length() > 0 && this.isOfKind(curr, typeKinds, is50OrHigher) && this.isVisible(curr, cu)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound.toArray(new TypeNameMatch[typeRefsFound.size()]);
    }

    private int getSearchForConstant(int typeKinds) {
        switch (typeKinds & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
        int flags = curr.getModifiers();
        if (Flags.isAnnotation((int)flags)) {
            return is50OrHigher && (typeKinds & 8) != 0;
        }
        if (Flags.isEnum((int)flags)) {
            return is50OrHigher && (typeKinds & 0x10) != 0;
        }
        if (Flags.isInterface((int)flags)) {
            return (typeKinds & 4) != 0;
        }
        return (typeKinds & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch curr, ICompilationUnit cu) {
        int flags = curr.getModifiers();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
            return true;
        }
        return curr.getPackageName().equals(cu.getParent().getElementName());
    }

    public static String evaluateTemplate(Template template, ICompilationUnit compilationUnit, int position) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, JavaTemplateMessages.JavaContext_error_message, null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        JavaContext context = new JavaContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }

    TemplateVariable getTemplateVariable(String name) {
        TemplateVariable variable = (TemplateVariable)this.fVariables.get(name);
        if (variable != null && !variable.isResolved()) {
            this.getContextType().resolve(variable, (TemplateContext)this);
        }
        return variable;
    }

    public void addDependency(MultiVariable master, MultiVariable slave) {
        MultiVariableGuess guess = this.getMultiVariableGuess();
        if (guess == null) {
            guess = new MultiVariableGuess();
            this.setMultiVariableGuess(guess);
        }
        guess.addDependency(master, slave);
    }
}

