/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceFactoryRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceIndirectionRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ReplaceInvocationsRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameResourceProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractSupertypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractSupertypeRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.JavaMoveRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInnerToTopRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.PushDownRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.fix.CleanUpRefactoringWizard;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ChangeSignatureWizard;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.ConvertAnonymousToNestedWizard;
import org.eclipse.jdt.internal.ui.refactoring.ExtractInterfaceWizard;
import org.eclipse.jdt.internal.ui.refactoring.ExtractSupertypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.InferTypeArgumentsWizard;
import org.eclipse.jdt.internal.ui.refactoring.InlineConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.InlineTempWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceFactoryWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceIndirectionWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceParameterObjectWizard;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceParameterWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveInnerToTopWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveInstanceMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.MoveMembersWizard;
import org.eclipse.jdt.internal.ui.refactoring.PullUpWizard;
import org.eclipse.jdt.internal.ui.refactoring.PushDownWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UseSupertypeWizard;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.code.InlineMethodWizard;
import org.eclipse.jdt.internal.ui.refactoring.code.ReplaceInvocationsWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.refactoring.sef.SelfEncapsulateFieldWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class RefactoringExecutionStarter {
    private static RenameSupport createRenameSupport(IJavaElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RenameSupport.create((IJavaProject)element, newName, flags);
            }
            case 3: {
                return RenameSupport.create((IPackageFragmentRoot)element, newName);
            }
            case 4: {
                return RenameSupport.create((IPackageFragment)element, newName, flags);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)element, newName, flags);
            }
            case 7: {
                return RenameSupport.create((IType)element, newName, flags);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringExecutionStarter.createRenameSupport((IJavaElement)method.getDeclaringType(), newName, flags);
                }
                return RenameSupport.create((IMethod)element, newName, flags);
            }
            case 8: {
                return RenameSupport.create((IField)element, newName, flags);
            }
            case 15: {
                return RenameSupport.create((ITypeParameter)element, newName, flags);
            }
            case 14: {
                return RenameSupport.create((ILocalVariable)element, newName, flags);
            }
        }
        return null;
    }

    public static void startChangeSignatureRefactoring(IMethod method, final SelectionDispatchAction action, final Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isChangeSignatureAvailable(method)) {
            return;
        }
        ChangeSignatureRefactoring refactoring = new ChangeSignatureRefactoring(method);
        UserInterfaceStarter starter = new UserInterfaceStarter(){

            public final boolean activate(Refactoring ref, Shell parent, int saveMode) throws CoreException {
                RefactoringStatusEntry entry;
                RefactoringStatus status = ref.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (status.hasFatalError() && ((entry = status.getEntryMatchingSeverity(4)).getCode() == 1 || entry.getCode() == 2)) {
                    String message = entry.getMessage();
                    Object element = entry.getData();
                    message = String.valueOf(message) + RefactoringMessages.RefactoringErrorDialogUtil_okToPerformQuestion;
                    if (element != null && MessageDialog.openQuestion((Shell)shell, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)message)) {
                        StructuredSelection selection = new StructuredSelection(element);
                        boolean wasEnabled = action.isEnabled();
                        action.selectionChanged((IStructuredSelection)selection);
                        if (action.isEnabled()) {
                            action.run((IStructuredSelection)selection);
                        } else {
                            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ModifyParameterAction_problem_title, (String)ActionMessages.ModifyParameterAction_problem_message);
                        }
                        action.setEnabled(wasEnabled);
                    }
                    return false;
                }
                return super.activate(ref, parent, saveMode);
            }
        };
        starter.initialize(new ChangeSignatureWizard(refactoring));
        try {
            starter.activate(refactoring, shell, 4);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.RefactoringStarter_unexpected_exception);
        }
    }

    public static void startChangeTypeRefactoring(ICompilationUnit unit, Shell shell, int offset, int length) throws JavaModelException {
        ChangeTypeRefactoring refactoring = new ChangeTypeRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new ChangeTypeWizard(refactoring), shell, RefactoringMessages.ChangeTypeAction_dialog_title, 4);
    }

    public static void startCleanupRefactoring(ICompilationUnit[] cus, ICleanUp[] cleanUps, Shell shell, boolean showWizard, String actionName) throws InvocationTargetException, JavaModelException {
        CleanUpRefactoring refactoring = new CleanUpRefactoring(actionName);
        int i = 0;
        while (i < cus.length) {
            refactoring.addCompilationUnit(cus[i]);
            ++i;
        }
        if (!showWizard) {
            i = 0;
            while (i < cleanUps.length) {
                refactoring.addCleanUp(cleanUps[i]);
                ++i;
            }
            Object context = refactoring.getCompilationUnits().length > 1 ? new ProgressMonitorDialog(shell) : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            RefactoringExecutionHelper helper = new RefactoringExecutionHelper(refactoring, 1, 4, shell, (IRunnableContext)context);
            try {
                helper.perform(true, true);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            CleanUpRefactoringWizard refactoringWizard = new CleanUpRefactoringWizard(refactoring, 2);
            RefactoringStarter starter = new RefactoringStarter();
            starter.activate(refactoring, refactoringWizard, shell, actionName, 4);
        }
    }

    public static void startConvertAnonymousRefactoring(ICompilationUnit unit, int offset, int length, Shell shell) throws JavaModelException {
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new ConvertAnonymousToNestedWizard(refactoring), shell, RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, 4);
    }

    public static void startCopyRefactoring(IResource[] resources, IJavaElement[] javaElements, Shell shell) throws JavaModelException {
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements);
        if (copyPolicy.canEnable()) {
            JavaCopyProcessor processor = new JavaCopyProcessor(copyPolicy);
            JavaCopyRefactoring refactoring = new JavaCopyRefactoring(processor);
            ReorgCopyWizard wizard = new ReorgCopyWizard(refactoring);
            processor.setNewNameQueries(new NewNameQueries((Wizard)wizard));
            processor.setReorgQueries(new ReorgQueries((Wizard)wizard));
            new RefactoringStarter().activate((Refactoring)refactoring, wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 5);
        }
    }

    public static void startCutRefactoring(Object[] elements, Shell shell) throws CoreException, InterruptedException, InvocationTargetException {
        JavaDeleteProcessor processor = new JavaDeleteProcessor(elements);
        processor.setSuggestGetterSetterDeletion(false);
        processor.setQueries(new ReorgQueries(shell));
        new RefactoringExecutionHelper((Refactoring)new JavaDeleteRefactoring(processor), RefactoringCore.getConditionCheckingFailedSeverity(), 5, shell, (IRunnableContext)new ProgressMonitorDialog(shell)).perform(false, false);
    }

    public static void startDeleteRefactoring(Object[] elements, Shell shell) throws CoreException {
        JavaDeleteRefactoring refactoring = new JavaDeleteRefactoring(new JavaDeleteProcessor(elements));
        DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, 5);
    }

    public static void startExtractInterfaceRefactoring(IType type, Shell shell) throws JavaModelException {
        ExtractInterfaceRefactoring refactoring = new ExtractInterfaceRefactoring(new ExtractInterfaceProcessor(type, JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject())));
        new RefactoringStarter().activate((Refactoring)refactoring, new ExtractInterfaceWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startExtractSupertypeRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(members)) {
            return;
        }
        IJavaProject project = null;
        if (members != null && members.length > 0) {
            project = members[0].getJavaProject();
        }
        ExtractSupertypeRefactoring refactoring = new ExtractSupertypeRefactoring(new ExtractSupertypeProcessor(members, JavaPreferencesSettings.getCodeGenerationSettings(project)));
        new RefactoringStarter().activate((Refactoring)refactoring, new ExtractSupertypeWizard((Refactoring)refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startInferTypeArgumentsRefactoring(IJavaElement[] elements, Shell shell) {
        try {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(elements)) {
                return;
            }
            InferTypeArgumentsRefactoring refactoring = new InferTypeArgumentsRefactoring(elements);
            new RefactoringStarter().activate(refactoring, new InferTypeArgumentsWizard(refactoring), shell, RefactoringMessages.InferTypeArgumentsAction_dialog_title, 4);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.InferTypeArgumentsAction_dialog_title, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public static boolean startInlineConstantRefactoring(ICompilationUnit unit, CompilationUnit node, int offset, int length, Shell shell) throws JavaModelException {
        InlineConstantRefactoring refactoring = new InlineConstantRefactoring(unit, node, offset, length);
        if (!refactoring.checkStaticFinalConstantNameSelected().hasFatalError()) {
            new RefactoringStarter().activate(refactoring, new InlineConstantWizard(refactoring), shell, RefactoringMessages.InlineConstantAction_dialog_title, 4);
            return true;
        }
        return false;
    }

    public static boolean startInlineMethodRefactoring(ITypeRoot typeRoot, CompilationUnit node, int offset, int length, Shell shell) throws JavaModelException {
        InlineMethodRefactoring refactoring = InlineMethodRefactoring.create(typeRoot, node, offset, length);
        if (refactoring != null) {
            new RefactoringStarter().activate(refactoring, new InlineMethodWizard(refactoring), shell, RefactoringMessages.InlineMethodAction_dialog_title, 4);
            return true;
        }
        return false;
    }

    public static boolean startInlineTempRefactoring(ICompilationUnit unit, CompilationUnit node, ITextSelection selection, Shell shell) throws JavaModelException {
        InlineTempRefactoring refactoring = new InlineTempRefactoring(unit, node, selection.getOffset(), selection.getLength());
        if (!refactoring.checkIfTempSelected().hasFatalError()) {
            new RefactoringStarter().activate(refactoring, new InlineTempWizard(refactoring), shell, RefactoringMessages.InlineTempAction_inline_temp, 5);
            return true;
        }
        return false;
    }

    public static void startIntroduceFactoryRefactoring(ICompilationUnit unit, ITextSelection selection, Shell shell) throws JavaModelException {
        IntroduceFactoryRefactoring refactoring = new IntroduceFactoryRefactoring(unit, selection.getOffset(), selection.getLength());
        new RefactoringStarter().activate(refactoring, new IntroduceFactoryWizard(refactoring, RefactoringMessages.IntroduceFactoryAction_use_factory), shell, RefactoringMessages.IntroduceFactoryAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(IClassFile file, int offset, int length, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(file, offset, length);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(ICompilationUnit unit, int offset, int length, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceIndirectionRefactoring(IMethod method, Shell shell) throws JavaModelException {
        IntroduceIndirectionRefactoring refactoring = new IntroduceIndirectionRefactoring(method);
        new RefactoringStarter().activate(refactoring, new IntroduceIndirectionWizard(refactoring, RefactoringMessages.IntroduceIndirectionAction_dialog_title), shell, RefactoringMessages.IntroduceIndirectionAction_dialog_title, 4);
    }

    public static void startIntroduceParameter(ICompilationUnit unit, int offset, int length, Shell shell) throws JavaModelException {
        IntroduceParameterRefactoring refactoring = new IntroduceParameterRefactoring(unit, offset, length);
        new RefactoringStarter().activate(refactoring, new IntroduceParameterWizard(refactoring), shell, RefactoringMessages.IntroduceParameterAction_dialog_title, 4);
    }

    public static void startMoveInnerRefactoring(IType type, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveInnerAvailable(type)) {
            return;
        }
        MoveInnerToTopRefactoring refactoring = new MoveInnerToTopRefactoring(type, JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject()));
        new RefactoringStarter().activate(refactoring, new MoveInnerToTopWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startMoveMethodRefactoring(IMethod method, Shell shell) throws JavaModelException {
        MoveInstanceMethodRefactoring refactoring = new MoveInstanceMethodRefactoring(new MoveInstanceMethodProcessor(method, JavaPreferencesSettings.getCodeGenerationSettings(method.getJavaProject())));
        new RefactoringStarter().activate((Refactoring)refactoring, new MoveInstanceMethodWizard(refactoring), shell, RefactoringMessages.MoveInstanceMethodAction_dialog_title, 4);
    }

    public static void startMoveRefactoring(IResource[] resources, IJavaElement[] elements, Shell shell) throws JavaModelException {
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, elements);
        if (policy.canEnable()) {
            JavaMoveProcessor processor = new JavaMoveProcessor(policy);
            JavaMoveRefactoring refactoring = new JavaMoveRefactoring(processor);
            ReorgMoveWizard wizard = new ReorgMoveWizard(refactoring);
            processor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
            processor.setReorgQueries(new ReorgQueries((Wizard)wizard));
            new RefactoringStarter().activate((Refactoring)refactoring, wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 2);
        }
    }

    public static void startMoveStaticMembersRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(members)) {
            return;
        }
        HashSet<IMember> set = new HashSet<IMember>();
        set.addAll(Arrays.asList(members));
        IMember[] elements = set.toArray(new IMember[set.size()]);
        IJavaProject project = null;
        if (elements.length > 0) {
            project = elements[0].getJavaProject();
        }
        JavaMoveRefactoring refactoring = new JavaMoveRefactoring(new MoveStaticMembersProcessor(elements, JavaPreferencesSettings.getCodeGenerationSettings(project)));
        new RefactoringStarter().activate((Refactoring)refactoring, new MoveMembersWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 3);
    }

    public static void startPullUpRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isPullUpAvailable(members)) {
            return;
        }
        IJavaProject project = null;
        if (members != null && members.length > 0) {
            project = members[0].getJavaProject();
        }
        PullUpRefactoring refactoring = new PullUpRefactoring(new PullUpRefactoringProcessor(members, JavaPreferencesSettings.getCodeGenerationSettings(project)));
        new RefactoringStarter().activate((Refactoring)refactoring, new PullUpWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startPushDownRefactoring(IMember[] members, Shell shell) throws JavaModelException {
        if (!RefactoringAvailabilityTester.isPushDownAvailable(members)) {
            return;
        }
        PushDownRefactoring refactoring = new PushDownRefactoring(new PushDownRefactoringProcessor(members));
        new RefactoringStarter().activate((Refactoring)refactoring, new PushDownWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    public static void startRenameRefactoring(IJavaElement element, Shell shell) throws CoreException {
        RenameSupport support = RefactoringExecutionStarter.createRenameSupport(element, null, 1);
        if (support != null && support.preCheck().isOK()) {
            support.openDialog(shell);
        }
    }

    public static void startRenameResourceRefactoring(IResource resource, Shell shell) throws CoreException {
        JavaRenameRefactoring refactoring = new JavaRenameRefactoring(new RenameResourceProcessor(resource));
        RenameUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, shell, 2);
    }

    public static void startReplaceInvocationsRefactoring(ITypeRoot typeRoot, int offset, int length, Shell shell) throws JavaModelException {
        ReplaceInvocationsRefactoring refactoring = new ReplaceInvocationsRefactoring(typeRoot, offset, length);
        new RefactoringStarter().activate(refactoring, new ReplaceInvocationsWizard(refactoring), shell, RefactoringMessages.ReplaceInvocationsAction_dialog_title, 4);
    }

    public static void startReplaceInvocationsRefactoring(IMethod method, Shell shell) throws JavaModelException {
        ReplaceInvocationsRefactoring refactoring = new ReplaceInvocationsRefactoring(method);
        new RefactoringStarter().activate(refactoring, new ReplaceInvocationsWizard(refactoring), shell, RefactoringMessages.ReplaceInvocationsAction_dialog_title, 4);
    }

    public static void startSelfEncapsulateRefactoring(IField field, Shell shell) {
        try {
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                return;
            }
            SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(field);
            new RefactoringStarter().activate(refactoring, new SelfEncapsulateFieldWizard(refactoring), shell, "", 4);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ActionMessages.SelfEncapsulateFieldAction_dialog_title, ActionMessages.SelfEncapsulateFieldAction_dialog_cannot_perform);
        }
    }

    public static void startUseSupertypeRefactoring(IType type, Shell shell) throws JavaModelException {
        UseSuperTypeRefactoring refactoring = new UseSuperTypeRefactoring(new UseSuperTypeProcessor(type));
        new RefactoringStarter().activate((Refactoring)refactoring, new UseSupertypeWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
    }

    private RefactoringExecutionStarter() {
    }

    public static void startIntroduceParameterObject(ICompilationUnit unit, int offset, int length, Shell shell) throws CoreException {
        IJavaElement javaElement = unit.getElementAt(offset);
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            RefactoringExecutionStarter.startIntroduceParameterObject(method, shell);
        }
    }

    public static void startIntroduceParameterObject(IMethod method, Shell shell) throws CoreException {
        RefactoringStatusEntry entry;
        RefactoringStatus availability = Checks.checkAvailability((IJavaElement)method);
        if (availability.hasError()) {
            MessageDialog.openError((Shell)shell, (String)RefactoringMessages.RefactoringExecutionStarter_IntroduceParameterObject_problem_title, (String)RefactoringMessages.RefactoringExecutionStarter_IntroduceParameterObject_problem_description);
            return;
        }
        IntroduceParameterObjectRefactoring refactoring = new IntroduceParameterObjectRefactoring(method);
        RefactoringStatus status = refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        if (status.hasFatalError() && ((entry = status.getEntryMatchingSeverity(4)).getCode() == 1 || entry.getCode() == 2)) {
            String message = entry.getMessage();
            Object element = entry.getData();
            IMethod superMethod = (IMethod)element;
            availability = Checks.checkAvailability((IJavaElement)superMethod);
            if (availability.hasError()) {
                MessageDialog.openError((Shell)shell, (String)RefactoringMessages.RefactoringExecutionStarter_IntroduceParameterObject_problem_title, (String)RefactoringMessages.RefactoringExecutionStarter_IntroduceParameterObject_problem_description);
                return;
            }
            message = String.valueOf(message) + RefactoringMessages.RefactoringErrorDialogUtil_okToPerformQuestion;
            refactoring = element != null && MessageDialog.openQuestion((Shell)shell, (String)RefactoringMessages.OpenRefactoringWizardAction_refactoring, (String)message) ? new IntroduceParameterObjectRefactoring(superMethod) : null;
        }
        if (refactoring != null) {
            new RefactoringStarter().activate(refactoring, new IntroduceParameterObjectWizard(refactoring), shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 4);
        }
    }
}

