/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.Util;
import org.eclipse.text.edits.TextEditGroup;

class AssociativeInfixExpressionFragment
extends ASTFragment
implements IExpressionFragment {
    private final List fOperands;
    private final InfixExpression fGroupRoot;

    public static IExpressionFragment createSubPartFragmentBySourceRange(InfixExpression node, SourceRange range, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)range);
        Assert.isTrue((!range.covers((ASTNode)node) ? 1 : 0) != 0);
        Assert.isTrue((boolean)new SourceRange((ASTNode)node).covers(range));
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        ArrayList groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(groupRoot);
        List subGroup = AssociativeInfixExpressionFragment.findSubGroupForSourceRange(groupMembers, range);
        if (subGroup.isEmpty() || AssociativeInfixExpressionFragment.rangeIncludesExtraNonWhitespace(range, subGroup, cu)) {
            return null;
        }
        return new AssociativeInfixExpressionFragment(groupRoot, subGroup);
    }

    public static IExpressionFragment createFragmentForFullSubtree(InfixExpression node) {
        Assert.isNotNull((Object)node);
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        ArrayList groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(node);
        return new AssociativeInfixExpressionFragment(groupRoot, groupMembers);
    }

    private static InfixExpression findGroupRoot(InfixExpression node) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node));
        while (!AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)node)) {
            ASTNode parent = node.getParent();
            Assert.isNotNull((Object)parent);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix(parent));
            Assert.isTrue((((InfixExpression)parent).getOperator() == node.getOperator() ? 1 : 0) != 0);
            node = (InfixExpression)parent;
        }
        return node;
    }

    private static List findSubGroupForSourceRange(List group, SourceRange range) {
        Assert.isTrue((!group.isEmpty() ? 1 : 0) != 0);
        ArrayList<ASTNode> subGroup = new ArrayList<ASTNode>();
        boolean entered = false;
        boolean exited = false;
        if (range.getOffset() == ((ASTNode)group.get(0)).getStartPosition()) {
            entered = true;
        }
        int i = 0;
        while (i < group.size() - 1) {
            ASTNode member = (ASTNode)group.get(i);
            ASTNode nextMember = (ASTNode)group.get(i + 1);
            if (entered) {
                subGroup.add(member);
                if (AssociativeInfixExpressionFragment.rangeEndsBetween(range, member, nextMember)) {
                    exited = true;
                    break;
                }
            } else if (AssociativeInfixExpressionFragment.rangeStartsBetween(range, member, nextMember)) {
                entered = true;
            }
            ++i;
        }
        ASTNode lastGroupMember = (ASTNode)group.get(group.size() - 1);
        if (range.getEndExclusive() == new SourceRange(lastGroupMember).getEndExclusive()) {
            subGroup.add(lastGroupMember);
            exited = true;
        }
        if (!exited) {
            return new ArrayList(0);
        }
        return subGroup;
    }

    private static boolean rangeStartsBetween(SourceRange range, ASTNode first, ASTNode next) {
        int pos = range.getOffset();
        return first.getStartPosition() + first.getLength() <= pos && pos <= next.getStartPosition();
    }

    private static boolean rangeEndsBetween(SourceRange range, ASTNode first, ASTNode next) {
        int pos = range.getEndExclusive();
        return first.getStartPosition() + first.getLength() <= pos && pos <= next.getStartPosition();
    }

    private static boolean rangeIncludesExtraNonWhitespace(SourceRange range, List operands, ICompilationUnit cu) throws JavaModelException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, AssociativeInfixExpressionFragment.getRangeOfOperands(operands), cu.getBuffer());
    }

    private static SourceRange getRangeOfOperands(List operands) {
        Expression first = (Expression)operands.get(0);
        Expression last = (Expression)operands.get(operands.size() - 1);
        return new SourceRange(first.getStartPosition(), last.getStartPosition() + last.getLength() - first.getStartPosition());
    }

    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        IASTFragment fragmentForNode = ASTFragmentFactory.createFragmentForFullSubtree(node);
        if (fragmentForNode instanceof AssociativeInfixExpressionFragment) {
            AssociativeInfixExpressionFragment kin = (AssociativeInfixExpressionFragment)fragmentForNode;
            return kin.getSubFragmentsWithMyNodeMatching(this);
        }
        return new IASTFragment[0];
    }

    private static List getMatchingContiguousNodeSubsequences(List source, List toMatch) {
        ArrayList subsequences = new ArrayList();
        int i = 0;
        while (i < source.size()) {
            if (AssociativeInfixExpressionFragment.matchesAt(i, source, toMatch)) {
                subsequences.add(source.subList(i, i + toMatch.size()));
                i += toMatch.size();
                continue;
            }
            ++i;
        }
        return subsequences;
    }

    private static boolean matchesAt(int index, List subject, List toMatch) {
        if (index + toMatch.size() > subject.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)subject.get(index), (ASTNode)toMatch.get(i))) {
                return false;
            }
            ++i;
            ++index;
        }
        return true;
    }

    private static boolean isAGroupRoot(ASTNode node) {
        Assert.isNotNull((Object)node);
        return AssociativeInfixExpressionFragment.isAssociativeInfix(node) && !AssociativeInfixExpressionFragment.isParentInfixWithSameOperator((InfixExpression)node);
    }

    private static boolean isAssociativeInfix(ASTNode node) {
        return node instanceof InfixExpression && AssociativeInfixExpressionFragment.isOperatorAssociative(((InfixExpression)node).getOperator());
    }

    private static boolean isParentInfixWithSameOperator(InfixExpression node) {
        return node.getParent() instanceof InfixExpression && ((InfixExpression)node.getParent()).getOperator() == node.getOperator();
    }

    private static boolean isOperatorAssociative(InfixExpression.Operator operator) {
        return operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.XOR || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.CONDITIONAL_AND;
    }

    private AssociativeInfixExpressionFragment(InfixExpression groupRoot, List operands) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        Assert.isTrue((operands.size() >= 2 ? 1 : 0) != 0);
        this.fGroupRoot = groupRoot;
        this.fOperands = Collections.unmodifiableList(operands);
    }

    public boolean matches(IASTFragment other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        AssociativeInfixExpressionFragment otherOfKind = (AssociativeInfixExpressionFragment)other;
        return this.getOperator() == otherOfKind.getOperator() && this.doOperandsMatch(otherOfKind);
    }

    private boolean doOperandsMatch(AssociativeInfixExpressionFragment other) {
        if (this.getOperands().size() != other.getOperands().size()) {
            return false;
        }
        Iterator myOperands = this.getOperands().iterator();
        Iterator othersOperands = other.getOperands().iterator();
        while (myOperands.hasNext() && othersOperands.hasNext()) {
            ASTNode othersOperand;
            ASTNode myOperand = (ASTNode)myOperands.next();
            if (JdtASTMatcher.doNodesMatch(myOperand, othersOperand = (ASTNode)othersOperands.next())) continue;
            return false;
        }
        return true;
    }

    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return AssociativeInfixExpressionFragment.union(this.getSubFragmentsWithMyNodeMatching(toMatch), this.getSubFragmentsWithAnotherNodeMatching(toMatch));
    }

    private IASTFragment[] getSubFragmentsWithMyNodeMatching(IASTFragment toMatch) {
        if (toMatch.getClass() != this.getClass()) {
            return new IASTFragment[0];
        }
        AssociativeInfixExpressionFragment kinToMatch = (AssociativeInfixExpressionFragment)toMatch;
        if (kinToMatch.getOperator() != this.getOperator()) {
            return new IASTFragment[0];
        }
        List matchingSubsequences = AssociativeInfixExpressionFragment.getMatchingContiguousNodeSubsequences(this.getOperands(), kinToMatch.getOperands());
        IASTFragment[] matches = new IASTFragment[matchingSubsequences.size()];
        int i = 0;
        while (i < matchingSubsequences.size()) {
            AssociativeInfixExpressionFragment match = new AssociativeInfixExpressionFragment(this.fGroupRoot, (List)matchingSubsequences.get(i));
            Assert.isTrue((match.matches(toMatch) || toMatch.matches(match) ? 1 : 0) != 0);
            matches[i] = match;
            ++i;
        }
        return matches;
    }

    private IASTFragment[] getSubFragmentsWithAnotherNodeMatching(IASTFragment toMatch) {
        IASTFragment[] result = new IASTFragment[]{};
        Iterator iter = this.getOperands().iterator();
        while (iter.hasNext()) {
            ASTNode operand = (ASTNode)iter.next();
            result = AssociativeInfixExpressionFragment.union(result, ASTMatchingFragmentFinder.findMatchingFragments(operand, (ASTFragment)toMatch));
        }
        return result;
    }

    private static IASTFragment[] union(IASTFragment[] a1, IASTFragment[] a2) {
        IASTFragment[] union = new IASTFragment[a1.length + a2.length];
        System.arraycopy(a1, 0, union, 0, a1.length);
        System.arraycopy(a2, 0, union, a1.length, a2.length);
        return union;
    }

    public Expression getAssociatedExpression() {
        return this.fGroupRoot;
    }

    public ASTNode getAssociatedNode() {
        return this.fGroupRoot;
    }

    public InfixExpression getGroupRoot() {
        return this.fGroupRoot;
    }

    public int getLength() {
        return this.getEndPositionExclusive() - this.getStartPosition();
    }

    private int getEndPositionExclusive() {
        List operands = this.getOperands();
        ASTNode lastNode = (ASTNode)operands.get(operands.size() - 1);
        return lastNode.getStartPosition() + lastNode.getLength();
    }

    public int getStartPosition() {
        return ((ASTNode)this.getOperands().get(0)).getStartPosition();
    }

    public List getOperands() {
        return this.fOperands;
    }

    public InfixExpression.Operator getOperator() {
        return this.fGroupRoot.getOperator();
    }

    public Expression createCopyTarget(ASTRewrite rewrite) throws JavaModelException {
        ArrayList allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (allOperands.size() == this.fOperands.size()) {
            return (Expression)rewrite.createCopyTarget((ASTNode)this.fGroupRoot);
        }
        CompilationUnit root = (CompilationUnit)this.fGroupRoot.getRoot();
        ICompilationUnit cu = (ICompilationUnit)root.getJavaElement();
        String source = cu.getBuffer().getText(this.getStartPosition(), this.getLength());
        return (Expression)rewrite.createStringPlaceholder(source, 27);
    }

    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        ArrayList allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (allOperands.size() == this.fOperands.size()) {
            rewrite.replace((ASTNode)this.fGroupRoot, replacement, textEditGroup);
            return;
        }
        int first = allOperands.indexOf(this.fOperands.get(0));
        int after = first + this.fOperands.size();
        ArrayList<ASTNode> newOperands = new ArrayList<ASTNode>();
        int i = 0;
        while (i < allOperands.size()) {
            if (i < first || after <= i) {
                newOperands.add(rewrite.createCopyTarget((ASTNode)((Expression)allOperands.get(i))));
            } else {
                newOperands.add(replacement);
                i = after - 1;
            }
            ++i;
        }
        Expression newExpression = ASTNodeFactory.newInfixExpression(rewrite.getAST(), this.getOperator(), newOperands);
        rewrite.replace((ASTNode)this.getGroupRoot(), (ASTNode)newExpression, textEditGroup);
    }

    private static ArrayList findGroupMembersInOrderFor(InfixExpression groupRoot) {
        return new GroupMemberFinder(groupRoot).fMembersInOrder;
    }

    public int hashCode() {
        return this.fGroupRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociativeInfixExpressionFragment other = (AssociativeInfixExpressionFragment)obj;
        return this.fGroupRoot.equals((Object)other.fGroupRoot) && this.fOperands.equals(other.fOperands);
    }

    private static class GroupMemberFinder
    extends GenericVisitor {
        private ArrayList fMembersInOrder = new ArrayList();
        private InfixExpression fGroupRoot;

        public GroupMemberFinder(InfixExpression groupRoot) {
            super(true);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)groupRoot));
            this.fGroupRoot = groupRoot;
            this.fGroupRoot.accept((ASTVisitor)this);
        }

        protected boolean visitNode(ASTNode node) {
            if (node instanceof InfixExpression && ((InfixExpression)node).getOperator() == this.fGroupRoot.getOperator()) {
                return true;
            }
            this.fMembersInOrder.add(node);
            return false;
        }
    }
}

