/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ui.CodeGeneration;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaModelException {
        boolean useIs = StubUtility.useIsForBooleanGetters(field.getJavaProject());
        return GetterSetterUtil.getGetterName(field, excludedNames, useIs);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IVariableBinding variableType, IJavaProject project, String[] excludedNames, boolean isBoolean) {
        boolean useIs = StubUtility.useIsForBooleanGetters(project) && isBoolean;
        return GetterSetterUtil.getGetterName(project, variableType.getName(), variableType.getModifiers(), useIs, excludedNames);
    }

    public static String getGetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    public static String getSetterName(IVariableBinding variableType, IJavaProject project, String[] excludedNames, boolean isBoolean) {
        return GetterSetterUtil.getSetterName(project, variableType.getName(), variableType.getModifiers(), isBoolean, excludedNames);
    }

    public static String getSetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestSetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return NamingConventions.suggestSetterName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags(), (boolean)JavaModelUtil.isBoolean(field), (String[])excludedNames);
    }

    public static IMethod getGetter(IField field) throws JavaModelException {
        String getterName = GetterSetterUtil.getGetterName(field, EMPTY, true);
        IMethod primaryCandidate = JavaModelUtil.findMethod(getterName, new String[0], false, field.getDeclaringType());
        if (!JavaModelUtil.isBoolean(field) || primaryCandidate != null && primaryCandidate.exists()) {
            return primaryCandidate;
        }
        String secondCandidateName = GetterSetterUtil.getGetterName(field, EMPTY, false);
        return JavaModelUtil.findMethod(secondCandidateName, new String[0], false, field.getDeclaringType());
    }

    public static IMethod getSetter(IField field) throws JavaModelException {
        String[] args = new String[]{field.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(field, EMPTY), args, false, field.getDeclaringType());
    }

    public static String getSetterStub(IField field, String setterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        String returnSig = field.getTypeSignature();
        String typeName = Signature.toString((String)returnSig);
        IJavaProject project = field.getJavaProject();
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)project, (String)fieldName, (int)field.getFlags());
        String argname = StubUtility.suggestArgumentName(project, accessorName, EMPTY);
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isSync = Flags.isSynchronized((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getSetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, field.getElementName(), typeName, argname, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isSync) {
            buf.append("synchronized ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append("void ");
        buf.append(setterName);
        buf.append('(');
        buf.append(typeName);
        buf.append(' ');
        buf.append(argname);
        buf.append(") {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(project);
        if (argname.equals(fieldName) || useThis && !isStatic) {
            fieldName = isStatic ? String.valueOf(parentType.getElementName()) + '.' + fieldName : "this." + fieldName;
        }
        if ((body = CodeGeneration.getSetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, fieldName, argname, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }

    public static String getGetterStub(IField field, String getterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        boolean isStatic = Flags.isStatic((int)flags);
        boolean isSync = Flags.isSynchronized((int)flags);
        boolean isFinal = Flags.isFinal((int)flags);
        String typeName = Signature.toString((String)field.getTypeSignature());
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)field.getJavaProject(), (String)fieldName, (int)field.getFlags());
        String lineDelim = "\n";
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getGetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, field.getElementName(), typeName, accessorName, lineDelim)) != null) {
            buf.append(comment);
            buf.append(lineDelim);
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isSync) {
            buf.append("synchronized ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append(typeName);
        buf.append(' ');
        buf.append(getterName);
        buf.append("() {");
        buf.append(lineDelim);
        boolean useThis = StubUtility.useThisForFieldAccess(field.getJavaProject());
        if (useThis && !isStatic) {
            fieldName = "this." + fieldName;
        }
        if ((body = CodeGeneration.getGetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, fieldName, lineDelim)) != null) {
            buf.append(body);
        }
        buf.append("}");
        buf.append(lineDelim);
        return buf.toString();
    }
}

