/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.BiFunction;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jspecify.annotations.Nullable;

public class BiProvider<R, A, B>
extends AbstractMinimalProvider<R> {
    private final @Nullable Class<R> type;
    private final BiFunction<? super A, ? super B, ? extends R> combiner;
    private final ProviderInternal<A> left;
    private final ProviderInternal<B> right;

    public BiProvider(@Nullable Class<R> type, Provider<A> left, Provider<B> right, BiFunction<? super A, ? super B, ? extends @Nullable R> combiner) {
        this.type = type;
        this.combiner = combiner;
        this.left = Providers.internal(left);
        this.right = Providers.internal(right);
    }

    @Override
    protected String toStringNoReentrance() {
        return String.format("and(%s, %s)", this.left, this.right);
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext ignored = this.openScope();){
            if (!this.left.calculatePresence(consumer) || !this.right.calculatePresence(consumer)) {
                boolean bl = false;
                return bl;
            }
        }
        return super.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends R> calculateExecutionTimeValue() {
        try (EvaluationScopeContext ignored = this.openScope();){
            if (BiProvider.isChangingValue(this.left) || BiProvider.isChangingValue(this.right)) {
                ValueSupplier.ExecutionTimeValue executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(this);
                return executionTimeValue;
            }
        }
        return super.calculateExecutionTimeValue();
    }

    private static boolean isChangingValue(ProviderInternal<?> provider) {
        return provider.calculateExecutionTimeValue().isChangingValue();
    }

    @Override
    protected ValueSupplier.Value<? extends R> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext ignored = this.openScope();){
            ValueSupplier.Value<A> leftValue = this.left.calculateValue(consumer);
            if (leftValue.isMissing()) {
                ValueSupplier.Value value = leftValue.asType();
                return value;
            }
            ValueSupplier.Value<B> rightValue = this.right.calculateValue(consumer);
            if (rightValue.isMissing()) {
                ValueSupplier.Value value = rightValue.asType();
                return value;
            }
            R combinedUnpackedValue = this.combiner.apply(leftValue.getWithoutSideEffect(), rightValue.getWithoutSideEffect());
            ValueSupplier.Value<R> value = ValueSupplier.Value.ofNullable(combinedUnpackedValue).withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
            return value;
        }
    }

    @Override
    public @Nullable Class<R> getType() {
        return this.type;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationScopeContext ignored = this.openScope();){
            ValueSupplier.PlusProducer plusProducer = new ValueSupplier.PlusProducer(this.left.getProducer(), this.right.getProducer());
            return plusProducer;
        }
    }
}

