/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.WorkerLimits;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultConditionalExecutionQueue<T>
implements ConditionalExecutionQueue<T> {
    public static final int KEEP_ALIVE_TIME_MS = 2000;
    private final WorkerLimits workerLimits;
    private final WorkerLeaseService workerLeaseService;
    private final ManagedExecutor executor;
    private final Deque<ConditionalExecution<T>> queue = new LinkedList<ConditionalExecution<T>>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private QueueState queueState = QueueState.Working;
    @GuardedBy(value="lock")
    private int workerCount;

    public DefaultConditionalExecutionQueue(String displayName, WorkerLimits workerLimits, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService) {
        this.workerLimits = workerLimits;
        this.workerLeaseService = workerLeaseService;
        this.executor = executorFactory.create(displayName);
        this.executor.setKeepAlive(2000, TimeUnit.MILLISECONDS);
    }

    @Override
    public void submit(ConditionalExecution<T> execution) {
        if (this.queueState == QueueState.Stopped) {
            throw new IllegalStateException("DefaultConditionalExecutionQueue cannot be reused once it has been stopped.");
        }
        this.lock.lock();
        try {
            if (this.workerCount < this.getMaxWorkerCount()) {
                this.expand(true);
            }
            this.queue.add(execution);
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void expand() {
        this.expand(false);
    }

    private int getMaxWorkerCount() {
        return this.workerLimits.getMaxWorkerCount();
    }

    private void expand(boolean force) {
        this.lock.lock();
        try {
            if (force || !this.queue.isEmpty()) {
                Future ignored = this.executor.submit((Runnable)new ExecutionRunner());
                ++this.workerCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.queueState = QueueState.Stopped;
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.executor.stop();
    }

    private class ExecutionRunner
    implements Runnable {
        private ExecutionRunner() {
        }

        @Override
        public void run() {
            try {
                ConditionalExecution<?> operation;
                while ((operation = this.waitForNextOperation()) != null) {
                    this.runBatch(operation);
                }
            }
            finally {
                this.shutDown();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ConditionalExecution<?> waitForNextOperation() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                while (DefaultConditionalExecutionQueue.this.queueState == QueueState.Working && DefaultConditionalExecutionQueue.this.queue.isEmpty() && DefaultConditionalExecutionQueue.this.workerCount <= DefaultConditionalExecutionQueue.this.getMaxWorkerCount()) {
                    try {
                        DefaultConditionalExecutionQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        return this.getReadyExecution();
                    }
                }
            }
            finally {
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
        }

        private void runBatch(final ConditionalExecution<?> firstOperation) {
            DefaultConditionalExecutionQueue.this.workerLeaseService.runAsWorkerThread(new Runnable(){

                @Override
                public void run() {
                    ConditionalExecution operation = firstOperation;
                    while (operation != null) {
                        ExecutionRunner.this.runExecution(operation);
                        operation = ExecutionRunner.this.getReadyExecution();
                    }
                }
            });
        }

        @Nullable
        private ConditionalExecution<?> getReadyExecution() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                ConditionalExecution conditionalExecution = (ConditionalExecution)DefaultConditionalExecutionQueue.this.queue.pollFirst();
                return conditionalExecution;
            }
            finally {
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
        }

        private void runExecution(ConditionalExecution<?> execution) {
            try {
                execution.getExecution().run();
            }
            finally {
                execution.complete();
            }
        }

        private void shutDown() {
            DefaultConditionalExecutionQueue.this.lock.lock();
            try {
                DefaultConditionalExecutionQueue.this.workerCount--;
            }
            finally {
                DefaultConditionalExecutionQueue.this.lock.unlock();
            }
        }
    }

    private static enum QueueState {
        Working,
        Stopped;

    }
}

