/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.schemaBuilder;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.DataTypeRef;
import org.gradle.internal.declarativedsl.analysis.DataTypeRefInternal;
import org.gradle.internal.declarativedsl.analysis.DefaultAnalysisSchemaKt;
import org.gradle.internal.declarativedsl.analysis.DefaultFqName;
import org.gradle.internal.declarativedsl.language.DataTypeInternal;
import org.gradle.internal.declarativedsl.schemaBuilder.DataSchemaBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\b\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\rH\u0002\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\r\"\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u0014"}, d2={"annotationsWithGetters", "", "", "Lkotlin/reflect/KCallable;", "getAnnotationsWithGetters", "(Lkotlin/reflect/KCallable;)Ljava/util/List;", "isBuiltInType", "", "Lkotlin/reflect/KClassifier;", "(Lkotlin/reflect/KClassifier;)Z", "checkInScope", "", "type", "Lkotlin/reflect/KType;", "typeScope", "Lorg/gradle/internal/declarativedsl/schemaBuilder/DataSchemaBuilder$PreIndex;", "isInScope", "toDataTypeRef", "Lorg/gradle/declarative/dsl/schema/DataTypeRef;", "toDataTypeRefOrError", "declarative-dsl-core"})
public final class SchemaBuildingUtilsKt {
    @NotNull
    public static final DataTypeRef toDataTypeRef(@NotNull KClassifier $this$toDataTypeRef) {
        DataTypeRef dataTypeRef;
        Intrinsics.checkNotNullParameter((Object)$this$toDataTypeRef, (String)"<this>");
        KClassifier kClassifier = $this$toDataTypeRef;
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Unit.class))) {
            dataTypeRef = DefaultAnalysisSchemaKt.getRef((DataType)DataTypeInternal.DefaultUnitType.INSTANCE);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataTypeRef = DefaultAnalysisSchemaKt.getRef((DataType)DataTypeInternal.DefaultIntDataType.INSTANCE);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            dataTypeRef = DefaultAnalysisSchemaKt.getRef((DataType)DataTypeInternal.DefaultStringDataType.INSTANCE);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            dataTypeRef = DefaultAnalysisSchemaKt.getRef((DataType)DataTypeInternal.DefaultBooleanDataType.INSTANCE);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataTypeRef = DefaultAnalysisSchemaKt.getRef((DataType)DataTypeInternal.DefaultLongDataType.INSTANCE);
        } else if (kClassifier instanceof KClass) {
            String string = ((KClass)$this$toDataTypeRef).getQualifiedName();
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            dataTypeRef = (DataTypeRef)new DataTypeRefInternal.DefaultName(DefaultFqName.Companion.parse(string));
        } else {
            throw new IllegalStateException("unexpected type".toString());
        }
        return dataTypeRef;
    }

    public static final void checkInScope(@NotNull KType type, @NotNull DataSchemaBuilder.PreIndex typeScope) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeScope, (String)"typeScope");
        KClassifier kClassifier = type.getClassifier();
        if (!(kClassifier != null ? SchemaBuildingUtilsKt.isInScope(kClassifier, typeScope) : false)) {
            throw new IllegalStateException(("type " + type + " used in a function is not in schema scope").toString());
        }
    }

    private static final boolean isInScope(KClassifier $this$isInScope, DataSchemaBuilder.PreIndex typeScope) {
        return SchemaBuildingUtilsKt.isBuiltInType($this$isInScope) || $this$isInScope instanceof KClass && typeScope.hasType((KClass)$this$isInScope);
    }

    private static final boolean isBuiltInType(KClassifier $this$isBuiltInType) {
        KClassifier kClassifier = $this$isBuiltInType;
        return (((Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(String.class))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) ? true : Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Unit.class));
    }

    @NotNull
    public static final List<Annotation> getAnnotationsWithGetters(@NotNull KCallable<?> $this$annotationsWithGetters) {
        Intrinsics.checkNotNullParameter($this$annotationsWithGetters, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$annotationsWithGetters.getAnnotations(), (Iterable)($this$annotationsWithGetters instanceof KProperty ? ((KProperty)$this$annotationsWithGetters).getGetter().getAnnotations() : CollectionsKt.emptyList()));
    }

    @NotNull
    public static final DataTypeRef toDataTypeRefOrError(@NotNull KType $this$toDataTypeRefOrError) {
        Intrinsics.checkNotNullParameter((Object)$this$toDataTypeRefOrError, (String)"<this>");
        DataTypeRef dataTypeRef = SchemaBuildingUtilsKt.toDataTypeRef($this$toDataTypeRefOrError);
        if (dataTypeRef == null) {
            throw new IllegalStateException(("failed to convert type " + $this$toDataTypeRefOrError + " to data type").toString());
        }
        return dataTypeRef;
    }

    private static final DataTypeRef toDataTypeRef(KType $this$toDataTypeRef) {
        KClassifier classifier;
        return !((Collection)$this$toDataTypeRef.getArguments()).isEmpty() ? null : ((classifier = $this$toDataTypeRef.getClassifier()) != null ? SchemaBuildingUtilsKt.toDataTypeRef(classifier) : null);
    }
}

