/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.evaluation.AnalysisStatementFilter;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AnalysisStatementFilterKt;
import org.gradle.internal.declarativedsl.analysis.CodeAnalyzer;
import org.gradle.internal.declarativedsl.analysis.StatementResolver;
import org.gradle.internal.declarativedsl.language.Assignment;
import org.gradle.internal.declarativedsl.language.DataStatement;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/CodeAnalyzerImpl;", "Lorg/gradle/internal/declarativedsl/analysis/CodeAnalyzer;", "analysisStatementFilter", "Lorg/gradle/declarative/dsl/evaluation/AnalysisStatementFilter;", "statementResolver", "Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;", "(Lorg/gradle/declarative/dsl/evaluation/AnalysisStatementFilter;Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;)V", "analyzeStatementsInProgramOrder", "", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "elements", "", "Lorg/gradle/internal/declarativedsl/language/DataStatement;", "doResolveStatement", "statement", "declarative-dsl-core"})
public final class CodeAnalyzerImpl
implements CodeAnalyzer {
    @NotNull
    private final AnalysisStatementFilter analysisStatementFilter;
    @NotNull
    private final StatementResolver statementResolver;

    public CodeAnalyzerImpl(@NotNull AnalysisStatementFilter analysisStatementFilter, @NotNull StatementResolver statementResolver) {
        Intrinsics.checkNotNullParameter((Object)analysisStatementFilter, (String)"analysisStatementFilter");
        Intrinsics.checkNotNullParameter((Object)statementResolver, (String)"statementResolver");
        this.analysisStatementFilter = analysisStatementFilter;
        this.statementResolver = statementResolver;
    }

    @Override
    public void analyzeStatementsInProgramOrder(@NotNull AnalysisContext context, @NotNull List<? extends DataStatement> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (DataStatement dataStatement : elements) {
            if (!AnalysisStatementFilterKt.shouldAnalyzeStatement(this.analysisStatementFilter, dataStatement, context.getCurrentScopes())) continue;
            this.doResolveStatement(context, dataStatement);
        }
    }

    private final void doResolveStatement(AnalysisContext context, DataStatement statement) {
        DataStatement dataStatement = statement;
        if (dataStatement instanceof Assignment) {
            this.statementResolver.doResolveAssignment(context, (Assignment)statement);
        } else if (dataStatement instanceof LocalValue) {
            this.statementResolver.doResolveLocalValue(context, (LocalValue)statement);
        } else if (dataStatement instanceof Expr) {
            this.statementResolver.doResolveExpressionStatement(context, (Expr)statement);
        }
    }
}

