/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.cache.internal.WrapperDistributionCleanupAction;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.cache.MonitoredCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;

public class GradleUserHomeCleanupService
implements Stoppable {
    private final Deleter deleter;
    private final GradleUserHomeDirProvider userHomeDirProvider;
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final UsedGradleVersions usedGradleVersions;
    private final BuildOperationRunner buildOperationRunner;
    private final CacheConfigurationsInternal cacheConfigurations;
    private boolean alreadyCleaned;

    public GradleUserHomeCleanupService(Deleter deleter, GradleUserHomeDirProvider userHomeDirProvider, GlobalScopedCacheBuilderFactory cacheBuilderFactory, UsedGradleVersions usedGradleVersions, BuildOperationRunner buildOperationRunner, CacheConfigurationsInternal cacheConfigurations) {
        this.deleter = deleter;
        this.userHomeDirProvider = userHomeDirProvider;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.usedGradleVersions = usedGradleVersions;
        this.buildOperationRunner = buildOperationRunner;
        this.cacheConfigurations = cacheConfigurations;
    }

    public void cleanup() {
        File cacheBaseDir = this.cacheBuilderFactory.getRootDir();
        boolean wasCleanedUp = this.execute(new VersionSpecificCacheCleanupAction(cacheBaseDir, this.cacheConfigurations.getReleasedWrappers().getRemoveUnusedEntriesOlderThanAsSupplier(), this.cacheConfigurations.getSnapshotWrappers().getRemoveUnusedEntriesOlderThanAsSupplier(), this.deleter, (CleanupFrequency)this.cacheConfigurations.getCleanupFrequency().get()));
        if (wasCleanedUp) {
            this.execute(new WrapperDistributionCleanupAction(this.userHomeDirProvider.getGradleUserHomeDirectory(), this.usedGradleVersions));
        }
        this.alreadyCleaned = true;
    }

    public void stop() {
        if (!this.alreadyCleaned) {
            this.cleanup();
        }
    }

    private boolean execute(final MonitoredCleanupAction action) {
        return (Boolean)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Boolean>(){

            public Boolean call(BuildOperationContext context) throws Exception {
                return action.execute((CleanupProgressMonitor)new DefaultCleanupProgressMonitor(context));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)action.getDisplayName());
            }
        });
    }
}

