/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

@NonNullApi
public class AddSoftwareTypesAsExtensionsPluginTarget
implements PluginTarget {
    private final ExtensionAddingVisitor extensionAddingVisitor;
    private final PluginTarget delegate;
    private final InspectionScheme inspectionScheme;
    private final SoftwareTypeRegistry softwareTypeRegistry;

    public AddSoftwareTypesAsExtensionsPluginTarget(ProjectInternal target, PluginTarget delegate, InspectionScheme inspectionScheme, SoftwareTypeRegistry softwareTypeRegistry) {
        this.extensionAddingVisitor = new ExtensionAddingVisitor(target);
        this.delegate = delegate;
        this.inspectionScheme = inspectionScheme;
        this.softwareTypeRegistry = softwareTypeRegistry;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.delegate.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        if (this.softwareTypeRegistry.isRegistered((Class)Cast.uncheckedCast(plugin.getClass()))) {
            DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType(plugin.getClass(), (boolean)false);
            this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, (PropertyVisitor)this.extensionAddingVisitor);
            if (!typeValidationContext.getProblems().isEmpty()) {
                throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", AddSoftwareTypesAsExtensionsPluginTarget.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
            }
        }
        this.delegate.applyImperative(pluginId, plugin);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private static Supplier<Optional<PluginId>> getOptionalSupplier(@Nullable String pluginId) {
        return () -> Optional.ofNullable(pluginId).map(DefaultPluginId::of);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        this.delegate.applyRules(pluginId, clazz);
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin, Class<?> declaringClass) {
        this.delegate.applyImperativeRulesHybrid(pluginId, plugin, declaringClass);
    }

    @NonNullApi
    public static class ExtensionAddingVisitor
    implements PropertyVisitor {
        private final ProjectInternal target;

        public ExtensionAddingVisitor(ProjectInternal target) {
            this.target = target;
        }

        public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, SoftwareType softwareType) {
            ExtensionContainer extensions = this.target.getExtensions();
            Class returnType = softwareType.modelPublicType();
            extensions.add(returnType, softwareType.name(), Cast.uncheckedNonnullCast((Object)value.call()));
        }
    }
}

