/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.io.File;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public interface DaemonJvmCriteria {
    public JavaLanguageVersion probeJavaLanguageVersion(JvmVersionDetector var1);

    public static final class Spec
    implements DaemonJvmCriteria {
        private final JavaLanguageVersion javaVersion;
        private final JvmVendorSpec vendorSpec;
        private final JvmImplementation jvmImplementation;

        public Spec(JavaLanguageVersion javaVersion, JvmVendorSpec vendorSpec, JvmImplementation jvmImplementation) {
            this.javaVersion = javaVersion;
            this.vendorSpec = vendorSpec;
            this.jvmImplementation = jvmImplementation;
        }

        public JavaLanguageVersion getJavaVersion() {
            return this.javaVersion;
        }

        public JvmVendorSpec getVendorSpec() {
            return this.vendorSpec;
        }

        public JvmImplementation getJvmImplementation() {
            return this.jvmImplementation;
        }

        public boolean isCompatibleWith(Jvm other) {
            Integer javaVersionMajor = other.getJavaVersionMajor();
            if (javaVersionMajor == null) {
                return false;
            }
            return this.isCompatibleWith(JavaLanguageVersion.of((int)javaVersionMajor));
        }

        public boolean isCompatibleWith(JavaLanguageVersion javaVersion) {
            return javaVersion.equals(this.getJavaVersion());
        }

        @Override
        public JavaLanguageVersion probeJavaLanguageVersion(JvmVersionDetector detector) {
            return this.getJavaVersion();
        }

        public String toString() {
            return String.format("Compatible with Java %s (from %s)", this.getJavaVersion(), "gradle/gradle-daemon-jvm.properties");
        }
    }

    public static final class JavaHome
    implements DaemonJvmCriteria {
        private final Source source;
        private final File javaHome;

        public JavaHome(Source source, File javaHome) {
            if (!javaHome.isDirectory()) {
                throw new IllegalArgumentException("Java home '" + javaHome.getAbsolutePath() + "' is not a directory");
            }
            Jvm.forHome((File)javaHome);
            this.source = source;
            this.javaHome = javaHome;
        }

        public File getJavaHome() {
            return this.javaHome;
        }

        @Override
        public JavaLanguageVersion probeJavaLanguageVersion(JvmVersionDetector detector) {
            return JavaLanguageVersion.of((int)detector.getJavaVersionMajor(Jvm.forHome((File)this.javaHome)));
        }

        public String toString() {
            return String.format("'%s' (from %s)", this.getJavaHome().getAbsolutePath(), this.source.description);
        }

        public static enum Source {
            ORG_GRADLE_JAVA_HOME("org.gradle.java.home"),
            TOOLING_API_CLIENT("Tooling API client"),
            EXISTING_DAEMON("existing daemon");

            private final String description;

            private Source(String description) {
                this.description = description;
            }
        }
    }

    public static final class LauncherJvm
    implements DaemonJvmCriteria {
        @Override
        public JavaLanguageVersion probeJavaLanguageVersion(JvmVersionDetector detector) {
            return JavaLanguageVersion.current();
        }

        public String toString() {
            return Jvm.current().getJavaHome().getAbsolutePath() + " (no JDK specified, using current Java home)";
        }
    }
}

