/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.SharedProblemGroup;
import org.gradle.api.problems.internal.AdditionalData;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDocLink;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultProblemDefinition;
import org.gradle.api.problems.internal.DefaultProblemGroup;
import org.gradle.api.problems.internal.DefaultProblemId;
import org.gradle.api.problems.internal.DefaultTaskPathLocation;
import org.gradle.api.problems.internal.DeprecationDataSpec;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.FileLocation;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemLocation;
import org.gradle.api.problems.internal.TypeValidationDataSpec;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;

public class DefaultProblemBuilder
implements InternalProblemBuilder {
    private static List<Class<?>> supportedAdditionalDataTypes = ImmutableList.of(GeneralDataSpec.class, DeprecationDataSpec.class, TypeValidationDataSpec.class);
    private ProblemStream problemStream;
    private ProblemId id;
    private String contextualLabel;
    private Severity severity;
    private final ImmutableList.Builder<ProblemLocation> locations = ImmutableList.builder();
    private String details;
    private DocLink docLink;
    private List<String> solutions;
    private RuntimeException exception;
    private AdditionalData additionalData;
    private boolean collectLocation = false;

    public DefaultProblemBuilder(Problem problem) {
        this.id = problem.getDefinition().getId();
        this.contextualLabel = problem.getContextualLabel();
        this.solutions = new ArrayList<String>(problem.getSolutions());
        this.severity = problem.getDefinition().getSeverity();
        this.locations.addAll(problem.getLocations());
        this.details = problem.getDetails();
        this.docLink = problem.getDefinition().getDocumentationLink();
        this.exception = problem.getException();
        this.additionalData = problem.getAdditionalData();
        this.problemStream = null;
    }

    public DefaultProblemBuilder(ProblemStream problemStream) {
        this.problemStream = problemStream;
        this.solutions = new ArrayList<String>();
        this.additionalData = null;
    }

    @Override
    public Problem build() {
        if (this.id == null) {
            return this.invalidProblem("missing-id", "Problem id must be specified", null);
        }
        if (this.id.getGroup() == null) {
            return this.invalidProblem("missing-parent", "Problem id must have a parent", null);
        }
        if (this.additionalData instanceof UnsupportedAdditionalDataSpec) {
            return this.invalidProblem("unsupported-additional-data", "Unsupported additional data type", "Unsupported additional data type: " + ((UnsupportedAdditionalDataSpec)this.additionalData).getType().getName() + ". Supported types are: " + supportedAdditionalDataTypes);
        }
        RuntimeException exceptionForProblemInstantiation = this.getExceptionForProblemInstantiation();
        if (this.problemStream != null) {
            this.addLocationsFromProblemStream(this.locations, exceptionForProblemInstantiation);
        }
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.id, this.getSeverity(), this.docLink);
        return new DefaultProblem(problemDefinition, this.contextualLabel, this.solutions, (List<ProblemLocation>)this.locations.build(), this.details, exceptionForProblemInstantiation, this.additionalData);
    }

    private void addLocationsFromProblemStream(ImmutableList.Builder<ProblemLocation> locations, RuntimeException exceptionForProblemInstantiation) {
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller(exceptionForProblemInstantiation);
        Location loc = problemDiagnostics.getLocation();
        if (loc != null) {
            locations.add((Object)DefaultProblemBuilder.getFileLocation(loc));
        }
        if (problemDiagnostics.getSource() != null && problemDiagnostics.getSource().getPluginId() != null) {
            locations.add((Object)DefaultProblemBuilder.getDefaultPluginIdLocation(problemDiagnostics));
        }
    }

    private static DefaultPluginIdLocation getDefaultPluginIdLocation(ProblemDiagnostics problemDiagnostics) {
        return new DefaultPluginIdLocation(problemDiagnostics.getSource().getPluginId());
    }

    private static FileLocation getFileLocation(Location loc) {
        String path = loc.getSourceLongDisplayName().getDisplayName();
        int line = loc.getLineNumber();
        return DefaultLineInFileLocation.from(path, line);
    }

    private Problem invalidProblem(String id, String displayName, String contextualLabel) {
        this.id(id, displayName, new DefaultProblemGroup("problems-api", "Problems API")).stackLocation();
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.id, Severity.WARNING, null);
        RuntimeException exceptionForProblemInstantiation = this.getExceptionForProblemInstantiation();
        ImmutableList.Builder problemLocations = ImmutableList.builder();
        this.addLocationsFromProblemStream((ImmutableList.Builder<ProblemLocation>)problemLocations, exceptionForProblemInstantiation);
        return new DefaultProblem(problemDefinition, contextualLabel, (List<String>)ImmutableList.of(), (List<ProblemLocation>)problemLocations.build(), null, exceptionForProblemInstantiation, null);
    }

    public RuntimeException getExceptionForProblemInstantiation() {
        return this.getException() == null && this.collectLocation ? new RuntimeException() : this.getException();
    }

    protected Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    @Override
    public InternalProblemBuilder contextualLabel(String contextualLabel) {
        this.contextualLabel = contextualLabel;
        return this;
    }

    @Override
    public InternalProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public InternalProblemBuilder taskPathLocation(String buildTreePath) {
        this.addLocation(new DefaultTaskPathLocation(buildTreePath));
        return this;
    }

    @Override
    public InternalProblemBuilder fileLocation(String path) {
        this.addLocation(DefaultFileLocation.from(path));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        this.addLocation(DefaultLineInFileLocation.from(path, line));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        this.addLocation(DefaultLineInFileLocation.from(path, line, column));
        return this;
    }

    @Override
    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        this.addLocation(DefaultOffsetInFileLocation.from(path, offset, length));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        this.addLocation(DefaultLineInFileLocation.from(path, line, column, length));
        return this;
    }

    @Override
    public InternalProblemBuilder pluginLocation(String pluginId) {
        this.addLocation(new DefaultPluginIdLocation(pluginId));
        return this;
    }

    @Override
    public InternalProblemBuilder stackLocation() {
        this.collectLocation = true;
        return this;
    }

    @Override
    public InternalProblemBuilder details(String details) {
        this.details = details;
        return this;
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable DocLink doc) {
        this.docLink = doc;
        return this;
    }

    @Override
    public InternalProblemBuilder id(String name, String displayName) {
        this.id = new DefaultProblemId(name, displayName, DefaultProblemBuilder.cloneGroup(SharedProblemGroup.generic()));
        return this;
    }

    @Override
    public InternalProblemBuilder id(String name, String displayName, ProblemGroup parent) {
        this.id = new DefaultProblemId(name, displayName, DefaultProblemBuilder.cloneGroup(parent));
        return this;
    }

    private static ProblemGroup cloneGroup(ProblemGroup original) {
        return new DefaultProblemGroup(original.getName(), original.getDisplayName(), original.getParent() == null ? null : DefaultProblemBuilder.cloneGroup(original.getParent()));
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable String url) {
        this.docLink = url == null ? null : new DefaultDocLink(url);
        return this;
    }

    @Override
    public InternalProblemBuilder solution(@Nullable String solution) {
        if (this.solutions == null) {
            this.solutions = new ArrayList<String>();
        }
        this.solutions.add(solution);
        return this;
    }

    @Override
    public <U extends AdditionalDataSpec> InternalProblemBuilder additionalData(Class<? extends U> specType, Action<? super U> config) {
        if (!supportedAdditionalDataTypes.contains(specType)) {
            this.additionalData = new UnsupportedAdditionalDataSpec(specType);
        } else if (this.additionalData == null) {
            AdditionalDataBuilder<Class<U>> additionalDatabuilder = AdditionalDataBuilderFactory.builderFor(specType);
            config.execute((Object)((AdditionalDataSpec)((Object)additionalDatabuilder)));
            this.additionalData = additionalDatabuilder.build();
        } else {
            AdditionalDataBuilder<AdditionalData> additionalDatabuilder = AdditionalDataBuilderFactory.builderFor(this.additionalData);
            config.execute((Object)((AdditionalDataSpec)((Object)additionalDatabuilder)));
            this.additionalData = additionalDatabuilder.build();
        }
        return this;
    }

    @Override
    public InternalProblemBuilder withException(RuntimeException e) {
        this.exception = e;
        return this;
    }

    @Nullable
    RuntimeException getException() {
        return this.exception;
    }

    protected void addLocation(ProblemLocation location) {
        this.locations.add((Object)location);
    }

    private static class UnsupportedAdditionalDataSpec
    implements AdditionalData {
        private final Class<?> type;

        UnsupportedAdditionalDataSpec(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

