/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ReplacedAccessor;
import org.gradle.internal.instrumentation.api.annotations.ReplacedDeprecation;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractCompile
extends SourceTask {
    private final DirectoryProperty destinationDirectory = this.getProject().getObjects().directoryProperty();
    private FileCollection classpath;
    private String sourceCompatibility;
    private String targetCompatibility;

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection configuration) {
        this.classpath = configuration;
    }

    @OutputDirectory
    @ReplacesEagerProperty(replacedAccessors={@ReplacedAccessor(value=ReplacedAccessor.AccessorType.GETTER, name="getDestinationDir"), @ReplacedAccessor(value=ReplacedAccessor.AccessorType.SETTER, name="setDestinationDir")}, binaryCompatibility=ReplacesEagerProperty.BinaryCompatibility.ACCESSORS_KEPT, deprecation=@ReplacedDeprecation(removedIn=ReplacedDeprecation.RemovedIn.GRADLE9, withUpgradeGuideMajorVersion=7, withUpgradeGuideSection="compile_task_wiring"))
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @ReplacedBy(value="destinationDirectory")
    @Deprecated
    public File getDestinationDir() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractCompile.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle9().withUpgradeGuideSection(7, "compile_task_wiring")).nagUser();
        return (File)this.destinationDirectory.getAsFile().getOrNull();
    }

    @Deprecated
    public void setDestinationDir(File destinationDir) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractCompile.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle9().withUpgradeGuideSection(7, "compile_task_wiring")).nagUser();
        this.destinationDirectory.set(destinationDir);
    }

    @Deprecated
    public void setDestinationDir(Provider<File> destinationDir) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(AbstractCompile.class, (String)"destinationDir").replaceWith((Object)"destinationDirectory")).willBeRemovedInGradle9().withUpgradeGuideSection(7, "compile_task_wiring")).nagUser();
        this.destinationDirectory.set(this.getProject().getLayout().dir(destinationDir));
    }

    @Input
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public void setSourceCompatibility(String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Input
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }
}

