/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactResolver;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Project.class})
public class ProjectDependencyResolver
implements ComponentMetaDataResolver,
DependencyToComponentIdResolver,
ArtifactResolver,
ComponentResolvers {
    private final LocalComponentRegistry localComponentRegistry;
    private final ProjectArtifactResolver artifactResolver;

    public ProjectDependencyResolver(LocalComponentRegistry localComponentRegistry, ProjectArtifactResolver artifactResolver) {
        this.localComponentRegistry = localComponentRegistry;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this;
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this;
    }

    @Override
    public void resolve(DependencyMetadata dependency, VersionSelector acceptor, @Nullable VersionSelector rejector, BuildableComponentIdResolveResult result) {
        if (dependency.getSelector() instanceof DefaultProjectComponentSelector) {
            DefaultProjectComponentSelector selector = (DefaultProjectComponentSelector)dependency.getSelector();
            ProjectComponentIdentifier projectId = selector.toIdentifier();
            LocalComponentGraphResolveState component = this.localComponentRegistry.getComponent(projectId);
            if (component == null) {
                result.failed(new ModuleVersionResolveException((ComponentSelector)selector, (Factory<String>)((Factory)() -> projectId + " not found.")));
            } else if (rejector != null && rejector.accept(component.getModuleVersionId().getVersion())) {
                result.rejected((ComponentIdentifier)projectId, component.getModuleVersionId());
            } else {
                result.resolved(component, ComponentGraphSpecificResolveState.EMPTY_STATE);
            }
        }
    }

    @Override
    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        if (ProjectDependencyResolver.isProjectModule(identifier)) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)identifier;
            LocalComponentGraphResolveState component = this.localComponentRegistry.getComponent(projectId);
            if (component == null) {
                result.failed(new ModuleVersionResolveException((ComponentSelector)DefaultProjectComponentSelector.newSelector(projectId), (Factory<String>)((Factory)() -> projectId + " not found.")));
            } else {
                result.resolved(component, ComponentGraphSpecificResolveState.EMPTY_STATE);
            }
        }
    }

    @Override
    public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
        return true;
    }

    @Override
    public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        if (ProjectDependencyResolver.isProjectModule(component.getId())) {
            throw new UnsupportedOperationException("Resolving artifacts by type is not yet supported for project modules");
        }
    }

    @Override
    public void resolveArtifact(ComponentArtifactResolveMetadata component, ComponentArtifactMetadata artifact, BuildableArtifactResolveResult result) {
        if (ProjectDependencyResolver.isProjectModule(artifact.getComponentId())) {
            this.artifactResolver.resolveArtifact(component, artifact, result);
        }
    }

    private static boolean isProjectModule(ComponentIdentifier componentId) {
        return componentId instanceof ProjectComponentIdentifier;
    }
}

