/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.console.UserInputReceiver;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.BuildExecuter;

class InProcessUserInputHandlingExecutor
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final GlobalUserInputReceiver userInputReceiver;
    private final UserInputReader userInputReader;
    private final BuildExecuter delegate;

    public InProcessUserInputHandlingExecutor(GlobalUserInputReceiver userInputReceiver, UserInputReader userInputReader, BuildExecuter delegate) {
        this.userInputReceiver = userInputReceiver;
        this.userInputReader = userInputReader;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext buildRequestContext) {
        this.userInputReceiver.dispatchTo((UserInputReceiver)new AsyncStdInReader());
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, actionParameters, buildRequestContext);
            return buildActionResult;
        }
        finally {
            this.userInputReceiver.stopDispatching();
        }
    }

    private class AsyncStdInReader
    implements UserInputReceiver {
        private AsyncStdInReader() {
        }

        public void readAndForwardText(UserInputReceiver.Normalizer normalizer) {
            Thread thread = new Thread(() -> {
                block4: {
                    block3: {
                        String line;
                        String result;
                        do {
                            try {
                                line = new BufferedReader(new InputStreamReader(System.in)).readLine();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            if (line == null) break block3;
                        } while ((result = normalizer.normalize(line)) == null);
                        InProcessUserInputHandlingExecutor.this.userInputReader.putInput((UserInputReader.UserInput)new UserInputReader.TextResponse(result));
                        break block4;
                    }
                    InProcessUserInputHandlingExecutor.this.userInputReader.putInput(UserInputReader.END_OF_INPUT);
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
    }
}

