/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.persistentOrderedSet;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.persistentOrderedSet.Links;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.persistentOrderedSet.PersistentOrderedSet;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.persistentOrderedSet.PersistentOrderedSetBuilder;
import org.jetbrains.kotlin.kotlinx.collections.immutable.implementations.persistentOrderedSet.PersistentOrderedSetMutableIterator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.internal.EndOfChain;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\"\u001a\u00020\u0014H\u0016J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0096\u0002J\u0015\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/persistentOrderedSet/PersistentOrderedSetBuilder;", "E", "Lkotlin/collections/AbstractMutableSet;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentSet$Builder;", "set", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/persistentOrderedSet/PersistentOrderedSet;", "(Lkotlinx/collections/immutable/implementations/persistentOrderedSet/PersistentOrderedSet;)V", "firstElement", "", "getFirstElement$kotlinx_collections_immutable", "()Ljava/lang/Object;", "setFirstElement$kotlinx_collections_immutable", "(Ljava/lang/Object;)V", "hashMapBuilder", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/implementations/persistentOrderedSet/Links;", "getHashMapBuilder$kotlinx_collections_immutable", "()Lkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;", "lastElement", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "build", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentSet;", "clear", "", "contains", "equals", "other", "hashCode", "iterator", "", "remove", "kotlinx-collections-immutable"})
public final class PersistentOrderedSetBuilder<E>
extends AbstractMutableSet<E>
implements PersistentSet.Builder<E> {
    @NotNull
    private PersistentOrderedSet<E> set;
    @Nullable
    private Object firstElement;
    @Nullable
    private Object lastElement;
    @NotNull
    private final PersistentHashMapBuilder<E, Links> hashMapBuilder;

    public PersistentOrderedSetBuilder(@NotNull PersistentOrderedSet<E> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.set = set;
        this.firstElement = this.set.getFirstElement$kotlinx_collections_immutable();
        this.lastElement = this.set.getLastElement$kotlinx_collections_immutable();
        this.hashMapBuilder = this.set.getHashMap$kotlinx_collections_immutable().builder();
    }

    @Nullable
    public final Object getFirstElement$kotlinx_collections_immutable() {
        return this.firstElement;
    }

    @NotNull
    public final PersistentHashMapBuilder<E, Links> getHashMapBuilder$kotlinx_collections_immutable() {
        return this.hashMapBuilder;
    }

    public int getSize() {
        return this.hashMapBuilder.size();
    }

    @Override
    @NotNull
    public PersistentSet<E> build() {
        PersistentOrderedSet persistentOrderedSet;
        PersistentMap newMap2 = this.hashMapBuilder.build();
        if (newMap2 == this.set.getHashMap$kotlinx_collections_immutable()) {
            CommonFunctionsKt.assert(this.firstElement == this.set.getFirstElement$kotlinx_collections_immutable());
            CommonFunctionsKt.assert(this.lastElement == this.set.getLastElement$kotlinx_collections_immutable());
            persistentOrderedSet = this.set;
        } else {
            persistentOrderedSet = new PersistentOrderedSet(this.firstElement, this.lastElement, newMap2);
        }
        this.set = persistentOrderedSet;
        return this.set;
    }

    @Override
    public boolean contains(Object element) {
        return this.hashMapBuilder.containsKey(element);
    }

    @Override
    public boolean add(E element) {
        if (this.hashMapBuilder.containsKey(element)) {
            return false;
        }
        if (this.isEmpty()) {
            this.firstElement = element;
            this.lastElement = element;
            ((Map)this.hashMapBuilder).put(element, new Links());
            return true;
        }
        Object v = ((Map)this.hashMapBuilder).get(this.lastElement);
        Intrinsics.checkNotNull(v);
        Links lastLinks = (Links)v;
        ((Map)this.hashMapBuilder).put(this.lastElement, lastLinks.withNext(element));
        ((Map)this.hashMapBuilder).put(element, new Links(this.lastElement));
        this.lastElement = element;
        return true;
    }

    @Override
    public boolean remove(Object element) {
        Links links = this.hashMapBuilder.remove(element);
        if (links == null) {
            return false;
        }
        Links links2 = links;
        if (links2.getHasPrevious()) {
            Object v = ((Map)this.hashMapBuilder).get(links2.getPrevious());
            Intrinsics.checkNotNull(v);
            Links previousLinks = (Links)v;
            ((Map)this.hashMapBuilder).put(links2.getPrevious(), previousLinks.withNext(links2.getNext()));
        } else {
            this.firstElement = links2.getNext();
        }
        if (links2.getHasNext()) {
            Object v = ((Map)this.hashMapBuilder).get(links2.getNext());
            Intrinsics.checkNotNull(v);
            Links nextLinks = (Links)v;
            ((Map)this.hashMapBuilder).put(links2.getNext(), nextLinks.withPrevious(links2.getPrevious()));
        } else {
            this.lastElement = links2.getPrevious();
        }
        return true;
    }

    @Override
    public void clear() {
        this.hashMapBuilder.clear();
        this.firstElement = EndOfChain.INSTANCE;
        this.lastElement = EndOfChain.INSTANCE;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PersistentOrderedSetMutableIterator(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        if (this.size() != ((Set)other).size()) {
            return false;
        }
        Set set = (Set)other;
        return set instanceof PersistentOrderedSet ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedSet)other).getHashMap$kotlinx_collections_immutable().getNode$kotlinx_collections_immutable(), equals.1.INSTANCE) : (set instanceof PersistentOrderedSetBuilder ? this.hashMapBuilder.getNode$kotlinx_collections_immutable().equalsWith$kotlinx_collections_immutable(((PersistentOrderedSetBuilder)other).hashMapBuilder.getNode$kotlinx_collections_immutable(), equals.2.INSTANCE) : super.equals(other));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

