/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.util.internal.TextUtil;

public class TreeFormatter
implements DiagnosticsVisitor {
    private final StringBuilder buffer = new StringBuilder();
    private final AbstractStyledTextOutput original;
    private Node current;
    private Prefixer prefixer = new DefaultPrefixer();
    private final boolean alwaysChildrenOnNewlines;

    public TreeFormatter() {
        this(false);
    }

    public TreeFormatter(boolean alwaysChildrenOnNewlines) {
        this.original = new AbstractStyledTextOutput(){

            @Override
            protected void doAppend(String text) {
                TreeFormatter.this.buffer.append(text);
            }
        };
        this.current = new Node();
        this.alwaysChildrenOnNewlines = alwaysChildrenOnNewlines;
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public TreeFormatter node(String text) {
        if (this.current.state == State.TraverseChildren) {
            this.current = new Node(this.current, text);
        } else {
            this.current.state = State.Done;
            this.current = new Node(this.current.parent, text);
        }
        if (this.current.isTopLevelNode()) {
            if (this.current != this.current.parent.firstChild) {
                this.original.append(TextUtil.getPlatformLineSeparator());
            }
            this.original.append(text);
            this.current.valueWritten = true;
        }
        return this;
    }

    public void blankLine() {
        this.node("");
    }

    public TreeFormatter node(Class<?> type) {
        if (type.isInterface()) {
            this.node("Interface ");
        } else {
            this.node("Class ");
        }
        this.appendType(type);
        return this;
    }

    public TreeFormatter append(CharSequence text) {
        if (this.current.state == State.CollectValue) {
            this.current.value.append(text);
            if (this.current.valueWritten) {
                this.original.append(text);
            }
        } else {
            throw new IllegalStateException("Cannot append text as there is no current node.");
        }
        return this;
    }

    public TreeFormatter appendType(Type type) {
        if (type instanceof Class) {
            Class classType = GeneratedSubclasses.unpack((Class)((Class)type));
            this.appendOuter(classType);
            this.append(classType.getSimpleName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.appendType(parameterizedType.getRawType());
            this.append("<");
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                if (i > 0) {
                    this.append(", ");
                }
                this.appendType(typeArgument);
            }
            this.append(">");
        } else {
            this.append(type.toString());
        }
        return this;
    }

    private void appendOuter(Class<?> type) {
        Class<?> outer = type.getEnclosingClass();
        if (outer != null) {
            this.appendOuter(outer);
            this.append(outer.getSimpleName());
            this.append(".");
        }
    }

    public TreeFormatter appendAnnotation(Class<? extends Annotation> type) {
        this.append("@" + type.getSimpleName());
        return this;
    }

    public TreeFormatter appendMethod(Method method) {
        this.append(method.getDeclaringClass().getSimpleName());
        this.append(".");
        this.append(method.getName());
        this.append("(");
        Class<?>[] params = method.getParameterTypes();
        int numParams = params.length;
        for (int i = 0; i < numParams; ++i) {
            Class<?> param = params[i];
            this.appendType(param);
            if (i >= numParams - 1) continue;
            this.append(", ");
        }
        this.append(")");
        if (!method.getReturnType().equals(Void.TYPE)) {
            this.append(": ");
            this.appendType(method.getGenericReturnType());
        }
        return this;
    }

    public TreeFormatter appendValue(@Nullable Object value) {
        if (value == null) {
            this.append("null");
        } else if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                this.append(value.toString());
            } else {
                this.appendValues((Object[])value);
            }
        } else if (value instanceof String) {
            this.append("'");
            this.append(value.toString());
            this.append("'");
        } else {
            this.append(value.toString());
        }
        return this;
    }

    public <T> TreeFormatter appendValues(T[] values) {
        this.append("[");
        for (int i = 0; i < values.length; ++i) {
            T value = values[i];
            if (i > 0) {
                this.append(", ");
            }
            this.appendValue(value);
        }
        this.append("]");
        return this;
    }

    public TreeFormatter appendTypes(Type ... types) {
        this.append("(");
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (type == null) {
                throw new IllegalStateException("type cannot be null");
            }
            if (i > 0) {
                this.append(", ");
            }
            this.appendType(type);
        }
        this.append(")");
        return this;
    }

    public TreeFormatter startNumberedChildren() {
        this.startChildren();
        this.prefixer = new NumberedPrefixer();
        return this;
    }

    @Override
    public TreeFormatter startChildren() {
        if (this.current.state != State.CollectValue) {
            throw new IllegalStateException("Cannot start children again");
        }
        this.current.state = State.TraverseChildren;
        return this;
    }

    @Override
    public TreeFormatter endChildren() {
        if (this.current.parent == null) {
            throw new IllegalStateException("Not visiting any node.");
        }
        if (this.current.state == State.CollectValue) {
            this.current.state = State.Done;
            this.current = this.current.parent;
        }
        if (this.current.state != State.TraverseChildren) {
            throw new IllegalStateException("Cannot end children.");
        }
        if (this.current.isTopLevelNode()) {
            this.writeNode(this.current);
        }
        this.current.state = State.Done;
        this.current = this.current.parent;
        this.prefixer = new DefaultPrefixer();
        return this;
    }

    private void writeNode(Node node) {
        if (node.prefix == null) {
            node.prefix = node.isTopLevelNode() ? "" : node.parent.prefix + "    ";
        }
        LinePrefixingStyledTextOutput output = new LinePrefixingStyledTextOutput(this.original, node.prefix, false);
        if (!node.valueWritten) {
            output.append(node.parent.prefix);
            output.append(this.prefixer.nextPrefix());
            output.append(node.value);
        }
        Separator separator = node.getFirstChildSeparator(this.alwaysChildrenOnNewlines);
        if (!separator.newLine) {
            output.append(separator.text);
            Node firstChild = node.firstChild;
            output.append(firstChild.value);
            firstChild.valueWritten = true;
            firstChild.prefix = node.prefix;
            this.writeNode(firstChild);
        } else if (node.firstChild != null) {
            this.original.append(separator.text);
            this.writeNode(node.firstChild);
        }
        if (node.nextSibling != null) {
            this.original.append(TextUtil.getPlatformLineSeparator());
            this.writeNode(node.nextSibling);
        }
    }

    private static class NumberedPrefixer
    implements Prefixer {
        private int cur = 0;

        private NumberedPrefixer() {
        }

        @Override
        public String nextPrefix() {
            return "  " + ++this.cur + ". ";
        }
    }

    private static class DefaultPrefixer
    implements Prefixer {
        private DefaultPrefixer() {
        }

        @Override
        public String nextPrefix() {
            return "  - ";
        }
    }

    private static interface Prefixer {
        public String nextPrefix();
    }

    private static class Node {
        final Node parent;
        final StringBuilder value;
        Node firstChild;
        Node lastChild;
        Node nextSibling;
        String prefix;
        State state;
        boolean valueWritten;

        private Node() {
            this.parent = null;
            this.value = new StringBuilder();
            this.prefix = "";
            this.state = State.TraverseChildren;
        }

        private Node(Node parent, String value) {
            this.parent = parent;
            this.value = new StringBuilder(value);
            this.state = State.CollectValue;
            if (parent.firstChild == null) {
                parent.firstChild = this;
                parent.lastChild = this;
            } else {
                parent.lastChild.nextSibling = this;
                parent.lastChild = this;
            }
        }

        Separator getFirstChildSeparator(boolean alwaysChildrenOnNewlines) {
            if (this.firstChild == null) {
                return Separator.NewLine;
            }
            if (this.value.length() == 0) {
                return Separator.NewLine;
            }
            char trailing = this.value.charAt(this.value.length() - 1);
            if (trailing == '.') {
                return Separator.NewLine;
            }
            if (this.firstChild.nextSibling == null && this.firstChild.firstChild == null && this.value.length() + this.firstChild.value.length() < 60 && !alwaysChildrenOnNewlines) {
                if (trailing == ':') {
                    return Separator.Empty;
                }
                return Separator.Colon;
            }
            if (trailing == ':') {
                return Separator.NewLine;
            }
            return Separator.ColonNewLine;
        }

        boolean isTopLevelNode() {
            return this.parent.parent == null;
        }
    }

    private static enum Separator {
        NewLine(true, TextUtil.getPlatformLineSeparator()),
        Empty(false, " "),
        Colon(false, ": "),
        ColonNewLine(true, ":" + TextUtil.getPlatformLineSeparator());

        final boolean newLine;
        final String text;

        private Separator(boolean newLine, String text) {
            this.newLine = newLine;
            this.text = text;
        }
    }

    private static enum State {
        CollectValue,
        TraverseChildren,
        Done;

    }
}

