/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingException;

public final class AstLoadingFilter {
    private static final Logger LOG = Logger.getInstance(AstLoadingFilter.class);
    private static final ThreadLocal<Supplier<String>> myDisallowedInfo = new ThreadLocal();
    private static final ThreadLocal<Set<VirtualFile>> myForcedAllowedFiles = ThreadLocal.withInitial(() -> new HashSet());

    private AstLoadingFilter() {
    }

    public static void assertTreeLoadingAllowed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(0);
        }
        if (file2 instanceof VirtualFileWindow || !Registry.is("ast.loading.filter", false)) {
            return;
        }
        Supplier<String> disallowedInfo = myDisallowedInfo.get();
        if (disallowedInfo != null && !myForcedAllowedFiles.get().contains(file2)) {
            AstLoadingException throwable = new AstLoadingException();
            LOG.error("Tree access disabled", (Throwable)throwable, new Attachment("debugInfo", AstLoadingFilter.buildDebugInfo(file2, disallowedInfo)));
        }
    }

    @NotNull
    private static String buildDebugInfo(@NotNull VirtualFile file2, @NotNull Supplier<String> disabledInfo) {
        if (file2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(1);
        }
        if (disabledInfo == null) {
            AstLoadingFilter.$$$reportNull$$$0(2);
        }
        @NonNls StringBuilder debugInfo2 = new StringBuilder();
        debugInfo2.append("Accessed file path: ").append(file2.getPath());
        String additionalInfo = disabledInfo.get();
        if (additionalInfo != null) {
            debugInfo2.append('\n').append("Additional info: \n").append(additionalInfo);
        }
        String string2 = debugInfo2.toString();
        if (string2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(7);
        }
        return AstLoadingFilter.disallowTreeLoading(computable, () -> null);
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable, @NotNull Supplier<String> debugInfo2) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(8);
        }
        if (debugInfo2 == null) {
            AstLoadingFilter.$$$reportNull$$$0(9);
        }
        if (myDisallowedInfo.get() != null) {
            return computable.compute();
        }
        try {
            myDisallowedInfo.set(debugInfo2);
            T t = computable.compute();
            return t;
        }
        finally {
            myDisallowedInfo.set(null);
        }
    }

    public static <T, E extends Throwable> T forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = psiFile == null ? null : psiFile.getVirtualFile();
        return virtualFile == null ? computable.compute() : AstLoadingFilter.forceAllowTreeLoading(virtualFile, computable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T forceAllowTreeLoading(@NotNull VirtualFile virtualFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        Set<VirtualFile> enabledFiles;
        if (virtualFile == null) {
            AstLoadingFilter.$$$reportNull$$$0(14);
        }
        if (computable == null) {
            AstLoadingFilter.$$$reportNull$$$0(15);
        }
        if ((enabledFiles = myForcedAllowedFiles.get()).add(virtualFile)) {
            try {
                T t = computable.compute();
                return t;
            }
            finally {
                enabledFiles.remove(virtualFile);
            }
        }
        return computable.compute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/AstLoadingFilter";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/AstLoadingFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDebugInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeLoadingAllowed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDebugInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disallowTreeLoading";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forceAllowTreeLoading";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

