/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiMethodImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue;

    public PsiAnnotationMethodImpl(PsiMethodStub stub) {
        super(stub, (IStubElementType<?, ?>)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void dropCached() {
        super.dropCached();
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String text = stub.getDefaultValueText();
            if (StringUtil.isEmpty(text)) {
                return null;
            }
            PsiAnnotationMemberValue value2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myCachedDefaultValue);
            if (value2 != null) {
                return value2;
            }
            value2 = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@Foo(" + text + ")", this).findAttributeValue(null);
            this.myCachedDefaultValue = new SoftReference<PsiAnnotationMemberValue>(value2);
            return value2;
        }
        this.myCachedDefaultValue = null;
        boolean expectedDefault = false;
        for (TreeElement childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType type2 = childNode.getElementType();
            if (type2 == JavaTokenType.DEFAULT_KEYWORD) {
                expectedDefault = true;
                continue;
            }
            if (!expectedDefault || !ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(type2)) continue;
            return (PsiAnnotationMemberValue)childNode.getPsi();
        }
        return null;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnnotationMethodImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotationMethod(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "accept"));
    }
}

